local mq = require('mq')
local btree = btree or require('behaviourtree/lib/behaviour_tree')

local ForceEnd = function ()
    mq.exit()
end

mq.event('BrokenPole', "#*#You can't fish without a fishing pole, go buy one.#*#", ForceEnd)
mq.event('NoBait', "#*#You can't fish without fishing bait, go buy some.#*#", ForceEnd)

local KeepItem = function ()
    while (mq.TLO.Cursor.ID() ~= nil and mq.TLO.Cursor.ID() ~= 0) do
        if (mq.TLO.Cursor.Name() == "Tattered Cloth Sandal" or mq.TLO.Cursor.Name() == "Rusty Dagger") then
            mq.cmd.destroy()
            mq.delay('1s')
        else 
            if (mq.TLO.Cursor.Name() ~= nil and mq.TLO.Cursor.Name() ~= "Fish Scales") then
                mq.cmd.echo('Caught '..mq.TLO.Cursor.Name())
            end
            mq.cmd.autoinventory()
        end
    end
end

local CheckPole = function ()
    if (mq.TLO.Me.Inventory('mainhand').Name() ~= nil and string.find(mq.TLO.Me.Inventory('mainhand').Name(), 'The Bone Rod') ~= nil) then return end
    mq.cmd.echo('You need to put your fishing pole in your primary hand.')
    mq.exit()
end

local fishtask = btree.Task:new({
    start = function(task, obj)
        CheckPole()
        KeepItem()
    end,
    finish = function(task, obj)
        mq.delay(10)
    end,
    run = function(task, obj)
        mq.cmd.doability('Fishing')
        return task:success()
    end
});

local foragetask = btree.Task:new({
    start = function(task, obj)
        KeepItem()
    end,
    finish = function(task, obj)
        mq.delay(10)
    end,
    run = function(task, obj)
        cmd.doability('Forage')
        return task:success()
    end
});

local tree = btree:new({
    tree = btree.Sequence:new({
        nodes = {fishtask, foragetask}
    })
});

tree:setObject(nil) -- don't actually need to do this, this is just to demonstrate
while true do
    tree:run()
end