---AugsToMake.lua
--Version 1.5
--by burdsjm
--Date 6/19/2023
local mq = require 'mq'
local version = '1.5'

local function check_and_report_item(item_name, final_product, message_format, ingredient_message_format)
    local ingredient_count = mq.TLO.FindItemCount(item_name)()
    local final_product_count = mq.TLO.FindItemCount(final_product)()
    local total_final_product_possible = math.floor(ingredient_count / 3) + final_product_count
    if total_final_product_possible < 3 then
        local missing_count = 3 - total_final_product_possible
        if missing_count > 0 then
            mq.cmdf(message_format, missing_count)
        end
    end
    if ingredient_count > 0 then
        mq.cmdf(ingredient_message_format, ingredient_count)
    end
end

-- List of items to check
local items = {
    {"Otherworldly Focus of Fortitude", "Phantasmal Luclinite Gem", '/dgt I need to make %s more NoS augs.', '/dgt I have %s Otherworldly Focus of Fortitude.'},
    {"Crystallized Restless Ore","Velium Threaded Gem", '/dgt I need to make %s more COV.', '/dgt I have %s Crystallized Restless Ore.'},
    {"Ossified Bloodied Ore", "Luclinite Ensanguined Gem",  '/dgt I need to make %s more TOL.', '/dgt I have %s Ossified Bloodied Ore.'},
    {"Crystallized Velium Ore", "Velium Infused Gem", '/dgt I need to make %s more ToV augs.', '/dgt I have %s Crystallized Velium Ore.'},
}

-- Run check
for i, item in ipairs(items) do
    check_and_report_item(item[1], item[2], item[3], item[4])
    if i < #items then
        mq.delay('2s')
    end
end

print('Checking to see if you can buy Currency Augs')

-- List of items to check

-- local currency_checks = {
--     {"Overseer Tetradrachm", 10000, "Tier Fragments in POK!!"},
--     {"Froststone Ducat", 500, "ToV augs in CC!!"},
--     {"Restless Mark", 500, "COV augs in WW!!"},
--     {"Scarlet Marks", 500, "TOL augs in ME!!"},
--     {"shaded specie", 500, "NOS Type5 in Shar!!"},
-- }

local currency_checks = {
    {"Overseer Tetradrachm", 10000, "Tier Fragments in POK!!"},
    {"Scarlet Marks", 500, "TOL augs in ME!!"},
    {"shaded specie", 500, "NOS Type5 in Shar!!"},
}


for _, currency_check in ipairs(currency_checks) do
    local currency_output = mq.TLO.Me.AltCurrency(currency_check[1])()
    local currency_value = currency_check[2]
    if currency_output then
        local currency_total = math.floor(currency_output / currency_value)
        if currency_total > 0 then
            mq.cmdf('/dgt You can buy %s, %s', currency_total, currency_check[3])
        end
    else
        print(string.format("Currency '%s' not found.", currency_check[1]))
    end
end

print('Done checking for Augs to make')