local mq = require('mq')
local PackageMan = require('mq/PackageMan')
local lfs = PackageMan.Require('luafilesystem', 'lfs')
local tabs = require("tabs")
local utils = require("utils")
local config = require("config")
local openGUI = true

mq.cmd('/plugin MQ2XAssist load')
mq.cmd('/plugin MQ2Notepad load')

local function DrawMainWindow()

    -- Window Settings
    ImGui.PushStyleVar(ImGuiStyleVar.Alpha, 0.9) -- Main window opacity.
    ImGui.PushStyleVar(ImGuiStyleVar.FrameRounding, 10.0)

    openGUI, shouldDrawGUI = ImGui.Begin('Quicky Kiss It 2.43', openGUI)
    if shouldDrawGUI then

        ImGui.SetWindowFontScale(1)
        tabs.DrawStaticStuff()

        if ImGui.BeginTabBar("MyTabBar") then
            if not config.isKissAssistRunning then
                ImGui.PushStyleVar(ImGuiStyleVar.Alpha, 0.2) -- Used to "gray out" tabs while no macro running.
            end

            -- Tab colors
            local normalTabBackgroundColor = { 0.5, 0.5, 0.5, 1.0 } -- Gray color for normal tab
            local activeTabBackgroundColor = { 0.8, 0.2, 0.2, 1.0 } -- Reddish color for active tab

            -- Main Tab
            ImGui.PushStyleColor(ImGuiCol.Tab, unpack(normalTabBackgroundColor))
            ImGui.PushStyleColor(ImGuiCol.TabActive, unpack(activeTabBackgroundColor))
            if ImGui.BeginTabItem("Main Tab") then
                tabs.DrawMainTab()
                ImGui.EndTabItem()
            end
            ImGui.PopStyleColor(2)

            -- Pulling Tab
            ImGui.PushStyleColor(ImGuiCol.Tab, unpack(normalTabBackgroundColor))
            ImGui.PushStyleColor(ImGuiCol.TabActive, unpack(activeTabBackgroundColor))
            if ImGui.BeginTabItem("Pulling") then
                tabs.DrawPullingTab()
                ImGui.EndTabItem()
            end
            ImGui.PopStyleColor(2)

            -- Mez Tools Tab
            ImGui.PushStyleColor(ImGuiCol.Tab, unpack(normalTabBackgroundColor))
            ImGui.PushStyleColor(ImGuiCol.TabActive, unpack(activeTabBackgroundColor))
            if ImGui.BeginTabItem("Mez Tools") then
                tabs.DrawMezToolsTab()
                ImGui.EndTabItem()
            end
            ImGui.PopStyleColor(2)

            -- Pet Settings Tab
            ImGui.PushStyleColor(ImGuiCol.Tab, unpack(normalTabBackgroundColor))
            ImGui.PushStyleColor(ImGuiCol.TabActive, unpack(activeTabBackgroundColor))
            if ImGui.BeginTabItem("Pet Settings") then
                tabs.DrawPetSettingsTab()
                ImGui.EndTabItem()
            end
            ImGui.PopStyleColor(2)

            -- Heal & Buffs Tab
            ImGui.PushStyleColor(ImGuiCol.Tab, unpack(normalTabBackgroundColor))
            ImGui.PushStyleColor(ImGuiCol.TabActive, unpack(activeTabBackgroundColor))
            if ImGui.BeginTabItem("Heal & Buffs") then
                tabs.DrawHealTab()
                ImGui.EndTabItem()
            end
            ImGui.PopStyleColor(2)

            if not config.isKissAssistRunning then
                ImGui.PopStyleVar()
            end
            ImGui.EndTabBar()
        end
    end
    ImGui.End()

    ImGui.PopStyleVar(2)
end

mq.imgui.init('QKI', DrawMainWindow)

local macroCheckDelay = 10
local updateIniStatusDelay = 10 -- Check every 5 seconds
local lastMacroCheckTime = os.time()
local updateIniStatusTimer = os.time()
local fadeOverPullsTimer = os.time() -- Initialize the timer
local fadeOverPullsDelay = 2         -- Check every 2 seconds

while openGUI do
    mq.delay(32)

    -- Check fadeOverPulls with a timer (every 1-2 seconds)
    if os.time() - fadeOverPullsTimer >= fadeOverPullsDelay then
        if config.fadeOverPullsEnabled then
            utils.checkAndExecuteFadeOverPulls(config)
        end
        fadeOverPullsTimer = os.time() -- Reset the timer
    end

    -- Check macro status with a timer
    if config.macroStarted and os.time() - lastMacroCheckTime >= macroCheckDelay then
        utils.checkMacroStatus(config)
        lastMacroCheckTime = os.time()
    end

    -- Check updateIniLoadedStatus with a timer
    if os.time() - updateIniStatusTimer >= updateIniStatusDelay then
        utils.updateIniLoadedStatus(config)
        updateIniStatusTimer = os.time() -- Reset the timer
    end
end
