local mq = require('mq')
local checkboxHandlers = require('checkbox_handlers')
local config = require('config')
local utils = require('utils')
showTooltips = true

--static bar for primary functions

function DrawStaticStuff()

    if config.iniLoaded then
        ImGui.PushStyleColor(ImGuiCol.Text, 0.0, 1.0, 0.0, 1.0) -- Green
        ImGui.Text("INI Loaded.")
    else
        ImGui.PushStyleColor(ImGuiCol.Text, 1.0, 0.0, 0.0, 1.0) -- Red
        ImGui.Text("NO INI LOADED!")
    end
    ImGui.PopStyleColor()

    ImGui.SameLine()
    if config.isKissAssistRunning then
        ImGui.PushStyleColor(ImGuiCol.Text, 0.0, 1.0, 0.0, 1.0) -- Green
        ImGui.Text("KissAssist Running.")
    else
        ImGui.PushStyleColor(ImGuiCol.Text, 1.0, 0.0, 0.0, 1.0) -- Red
        ImGui.Text("KissAssist NOT RUNNING!")
    end
    ImGui.PopStyleColor()

    ImGui.NewLine()
    if ImGui.SmallButton("Load INI File") then
        local filePath = utils.openFileDialog()
        if filePath and filePath ~= "" then
            config.selectedPath = filePath
            local settings, err = utils.parseIniFile(filePath)
            if settings then
                print("Loading settings from INI file")

                for key, _ in pairs(config.checkboxStates) do
                    local value = findSettingIgnoreCase(settings, key)
                    if value ~= nil then
                        config.checkboxStates[key] = value == "1"
                    end
                end

                -- Special handling for MezOn, PullLevel, MezMinLevel, and MezMaxLevel
                config.MezMinLevel = findSettingIgnoreCase(settings, "MezMinLevel") or config.MezMinLevel
                config.MezMaxLevel = findSettingIgnoreCase(settings, "MezMaxLevel") or config.MezMaxLevel
                config.setRadius = findSettingIgnoreCase(settings, "MaxRadius") or config.setRadius
                config.setArc = findSettingIgnoreCase(settings, "PullArcWidth") or config.setArc
                config.setMed = findSettingIgnoreCase(settings, "MedStart") or config.setMed
                config.setAssist = findSettingIgnoreCase(settings, "AssistAt") or config.setAssist
                config.setZrange = findSettingIgnoreCase(settings, "MaxZRange") or config.setZrange
                config.setMezradius = findSettingIgnoreCase(settings, "MezRadius") or config.setMezradius
                config.setStophp = findSettingIgnoreCase(settings, "MezStopHPs") or config.setStophp
                config.CampRadius = findSettingIgnoreCase(settings, "CampRadius") or config.CampRadius
                config.ChaseDistance = findSettingIgnoreCase(settings, "ChaseDistance") or config.ChaseDistance
                config.ChainPullHP = findSettingIgnoreCase(settings, "ChainPullHP") or config.ChainPullHP
                config.PullWait = findSettingIgnoreCase(settings, "PullWait") or config.PullWait
                config.PetAssistAt = findSettingIgnoreCase(settings, "PetAssistAt") or config.PetAssistAt
                config.AERadius = findSettingIgnoreCase(settings, "AERadius") or config.AERadius

                local pullLevelValue = findSettingIgnoreCase(settings, "PullLevel")
                if pullLevelValue then
                    local minLevel, maxLevel = pullLevelValue:match("([^|]+)|([^|]+)")
                    if minLevel and maxLevel then
                        config.setPullLevelMin = minLevel
                        config.setPullLevelMax = maxLevel
                    end
                end

                local mezOnValue = findSettingIgnoreCase(settings, "MezOn")
                if mezOnValue then
                    local mezValue = tonumber(mezOnValue)
                    if mezValue then
                        config.checkboxStates["Single Mez"] = (mezValue == 1 or mezValue == 2)
                        config.checkboxStates["AE Mez"] = (mezValue == 1 or mezValue == 3)
                    end
                end

                local stickHowValue = findSettingIgnoreCase(settings, "StickHow")
                if stickHowValue then
                    local validOption = false
                    for label, data in pairs(config.stickHowOptions) do
                        if stickHowValue == data.value then
                            config.currentStickHow = label
                            validOption = true
                            print("Loaded Stick How setting from INI: " .. stickHowValue)
                            break
                        end
                    end

                    if not validOption then
                        config.currentStickHow = "Not Set" 
                        print("Invalid Stick How setting in INI. Setting to default: Not Set")
                    end
                else
                    config.currentStickHow = "Not Set"
                    print("No Stick How setting found in INI. Setting to default: Not Set")
                end

                local useMQ2MeleeValue = findSettingIgnoreCase(settings, "UseMQ2Melee")
                for label, data in pairs(config.useMQ2MeleeOptions) do
                    if tostring(data.value) == useMQ2MeleeValue then
                        config.currentUseMQ2Melee = label
                        break
                    end
                end

                local meleeDistanceValue = findSettingIgnoreCase(settings, "MeleeDistance")
                if meleeDistanceValue then
                    config.meleeDistance = meleeDistanceValue
                end

                print("Updated All Matching Settings...")
            else
                print("Error loading INI file: " .. (err or "Unknown error"))
            end
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Click to nav to and load your kiss ini.')
    end

    ImGui.SameLine()
    ImGui.SetNextItemWidth(150)
    if ImGui.BeginCombo("Roles", config.items[config.current_item]) then
        for i, item in ipairs(config.items) do
            if ImGui.Selectable(item, config.current_item == i) then
                config.current_item = i

                if item == "Assist" then
                    selectedCommand = function()
                        mq.cmd('/keypress f2')
                        mq.cmd('/mac kissassist')
                    end
                elseif item == "Tank" then
                    selectedCommand = function()
                        mq.cmd('/keypress f2')
                        mq.cmd('/mac kissassist tank')
                    end
                elseif item == "Puller" then
                    selectedCommand = function()
                        mq.cmd('/keypress f2')
                        mq.cmd('/mac kissassist puller')
                    end
                elseif item == "Hunter" then
                    selectedCommand = function()
                        mq.cmd('/keypress f1')
                        mq.cmd('/mac kissassist hunter')
                    end
                elseif item == "Puller Tank" then
                    selectedCommand = function()
                        mq.cmd('/keypress f2')
                        mq.cmd('/mac kissassist pullertank')
                    end
                elseif item == "Pet Tank" then
                    selectedCommand = function()
                        mq.cmd('/target ${Target.Pet}')
                        mq.cmd('/mac kissassist pettank')
                    end
                elseif item == "Pet Puller Tank" then
                    selectedCommand = function()
                        mq.cmd('/target ${Target.Pet}')
                        mq.cmd('/mac kissassist petpullertank')
                    end
                elseif item == "Pet Tank" then
                    selectedCommand = function()
                        mq.cmd('/target ${Target.Pet}')
                        mq.cmd('/mac kissassist pullertank')
                    end
                elseif item == "Hunter Pet Tank" then
                    selectedCommand = function()
                        mq.cmd('/target ${Target.Pet}')
                        mq.cmd('/mac kissassist hunterpettank')
                    end
                elseif item == "Pet Assist" then
                    selectedCommand = function()
                        mq.cmd('/target ${Target.Pet}')
                        mq.cmd('/mac kissassist petassist')
                    end
                elseif item == "Not Set" then
                    selectedCommand = function()
                        mq.cmd('/end')
                    end
                end
            end
            if current_item == i then
                ImGui.SetItemDefaultFocus()
            end
        end
        ImGui.EndCombo()
    end

    ImGui.SameLine()
    if config.iniLoaded then
        if ImGui.Button("Set Role") and selectedCommand then
            selectedCommand()
            config.macroStarted = true
            config.checkMacroStatus = true
        end
    else
        ImGui.PushStyleColor(ImGuiCol.Button, 1.0, 0.5, 0.0, 1.0)
        if ImGui.Button("Set Role") then
            print("No INI file loaded. Please load an INI file to set the role.")
        end
        ImGui.PopStyleColor()
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Click to set your role and start KissAssist, you need to select and load an ini first')
    end

    ImGui.SameLine()
    if config.isMacroPaused and config.isKissAssistRunning then
        ImGui.PushStyleColor(ImGuiCol.Button, 1.0, 0.0, 0.0, 1.0) -- Red
        if ImGui.Button("Resume") then
            mq.cmd('/mqp off')
            config.isMacroPaused = false
        end
        ImGui.PopStyleColor()
    elseif config.isKissAssistRunning then
        if ImGui.Button("Pause") then
            mq.cmd('/mqp on')
            config.isMacroPaused = true
        end
    else
        if ImGui.Button("Pause") then
            print("Macro is not running. Start the macro first.")
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Pauses/Unpauses KissAssist when Running.')
    end

    ImGui.SameLine()
    if ImGui.SmallButton("STOP!") then
        mq.cmd(
            '/squelch /multiline ; /stopcast; /end; /afollow off; /stick off; /moveto off; /nav stop; /play off; /mqp on; /attack off; /twist off;')
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Issues a stop everything your doing command, including twist/cast/run/follow/attack and ends KissAssist.')
    end
    ImGui.SameLine()
    if ImGui.Checkbox('Show Tooltips', showTooltips) then
        showTooltips = true
    else
        showTooltips = false
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Turns on and off the annoying tool tips.')
    end
    ImGui.Separator()
end

--main tab

local function DrawMainTab()

ImGui.NewLine()
if ImGui.SmallButton('Edit INI') then
    mq.cmd('/kissedit')
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip('Click to open and edit the whole Kiss INI file, Kiss must be running.')
end

ImGui.SameLine()
if ImGui.SmallButton('Force Reload INI') then
    mq.cmd('/kasettings load')
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip('This runs /kasettings load command to force reload sections of your ini.')
end

ImGui.NewLine()
ImGui.SetNextItemWidth(150)
if ImGui.BeginCombo("Stick How", config.currentStickHow) then
    for _, label in ipairs(config.orderedStickHowOptions) do
        local isSelected = (config.currentStickHow == label)
        if ImGui.Selectable(label, isSelected) then
            config.currentStickHow = label
        end
        if isSelected then
            ImGui.SetItemDefaultFocus()
        end
    end
    ImGui.EndCombo()
end

ImGui.SameLine()
if ImGui.SmallButton('Set Stick How') then
    if config.selectedPath and config.selectedPath ~= "" then
        local selectedOption = config.stickHowOptions[config.currentStickHow]
        if selectedOption then

            config.stickHow = selectedOption.value
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load')


            if selectedOption.cmd then
                mq.cmd(selectedOption.cmd)
            end
        end
    else
        print("No file path selected to save settings, try reloading your ini.")
    end
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip('Tells character how to stick to mob when fighting.')
end

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.setAssist = ImGui.InputText('##setAssist', config.setAssist)

ImGui.SameLine()
if ImGui.SmallButton('Assist At') then
    mq.cmd('/assistat ', config.setAssist)
end
if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip(
        'Mob health to assist/attack. This affects when you engage and is NOT specific to melee characters. IE pet classes will send pets at this.')
end

ImGui.NewLine()
ImGui.SetNextItemWidth(50)
config.meleeDistance = ImGui.InputText('##MeleeDistance', config.meleeDistance or "")

ImGui.SameLine()
if ImGui.SmallButton('Set Melee Distance') then
    if config.meleeDistance and config.meleeDistance ~= "" then
        mq.cmd('/meleedistance ' .. config.meleeDistance)
        print("Updated melee distance to: " .. config.meleeDistance)
    end
end
if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Mobs outside this radius will not be engaged.')
end

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.CampRadius = ImGui.InputText('##sCampRadius', config.CampRadius)

ImGui.SameLine()
if ImGui.SmallButton('Camp Radius') then
    mq.cmd('/CampRadius ', config.CampRadius)
    mq.cmd('/kasettings load')
end
if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip(
        'Determines how far your characters interact based on your initial camp spot. This value should be less than MeleeDistance.')
end

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.ChaseDistance = ImGui.InputText('##sChaseDistance', config.ChaseDistance)

ImGui.SameLine()
if ImGui.SmallButton('Chase Distance') then
        mq.cmd('/ChaseDistance ', config.ChaseDistance)
    mq.cmd('/kasettings load')
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'How close you want your character to follow main assist.')
end
ImGui.Separator()
ImGui.NewLine()

local itemsPerColumn = 5
local totalItems = #config.mainTabLabels + #config.useMQ2MeleeOptions
local numColumns = math.ceil(totalItems / itemsPerColumn)
local currentItemIndex = 0

ImGui.Columns(numColumns)

for i, key in ipairs(config.mainTabLabels) do
    currentItemIndex = currentItemIndex + 1

    local isChecked = config.checkboxStates[key] or false
    local newValue, valueChanged = ImGui.Checkbox("##" .. key, isChecked)
    ImGui.SameLine()
    local displayLabel = config.displayLabels[key] or key
    ImGui.Text(displayLabel)

        if showTooltips and ImGui.IsItemHovered() then
        local tooltipText = config.mainTabTooltips[key] or "No tooltip available."
        ImGui.SetTooltip(tooltipText)
    end

    if valueChanged then
        config.checkboxStates[key] = newValue
        if checkboxHandlers[key] then
            checkboxHandlers[key](newValue)
        end
    end

    if currentItemIndex % itemsPerColumn == 0 and currentItemIndex < totalItems then
        ImGui.NextColumn()
    end
end

for label, data in pairs(config.useMQ2MeleeOptions) do
    currentItemIndex = currentItemIndex + 1

    if ImGui.RadioButton(label, config.currentUseMQ2Melee == label) then
        config.currentUseMQ2Melee = label
        if data.handler then
            data.handler()
        end
    end

    if showTooltips and ImGui.IsItemHovered() then
        local tooltipText = config.mq2MeleeRadioTooltips[label] or "No tooltip available."
        ImGui.SetTooltip(tooltipText)
    end

    if currentItemIndex % itemsPerColumn == 0 and currentItemIndex < totalItems then
        ImGui.NextColumn()
    end
end

ImGui.Columns(1)
end

--Pulling Tools Tab

local function DrawPullingTab()
ImGui.Text("Pulling Settings")

ImGui.NewLine()
if ImGui.SmallButton("Ignore Target") then
    mq.cmd('/addignore "${Target.CleanName}"')
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'Adds target to the MobsToIgnore list. Modifies KissAssist_Info.ini')
end

ImGui.SameLine()
if ImGui.SmallButton("AddPull Target") then
    mq.cmd('/addpull "${Target.CleanName}"')
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'Adds target to the MobsToPull list. Modifies KissAssist_Info.ini')
end

    local buffer_size = 64

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.setPullLevelMin = ImGui.InputText('##setPullLevelMin', config.setPullLevelMin, buffer_size)

ImGui.SameLine()
ImGui.Text("|")

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.setPullLevelMax = ImGui.InputText('##setPullLevelMax', config.setPullLevelMax, buffer_size)

if changedMin then
    config.setPullLevelMin = utils.validateNumericInput(config.setPullLevelMin)
end

if changedMax then
    config.setPullLevelMax = utils.validateNumericInput(config.setPullLevelMax)
end

ImGui.SameLine()
if ImGui.SmallButton('Set Pull Level Range') then
    if config.selectedPath and config.selectedPath ~= "" then
        local minLevel = tonumber(config.setPullLevelMin)
        local maxLevel = tonumber(config.setPullLevelMax)

        if minLevel and maxLevel then
            local combinedValue = tostring(minLevel) .. "|" .. tostring(maxLevel)
            config.settings["PullLevel"] = combinedValue
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load')
        else
            print("Invalid input for Pull Level Range.")
        end
    else
        print("No file path selected to save settings, try reloading your ini.")
    end
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
        'Set the level range of mobs to pull.')
end

ImGui.NewLine()
ImGui.SetNextItemWidth(50)
config.setRadius = ImGui.InputText('##setRadius', config.setRadius)

ImGui.SameLine()
if ImGui.SmallButton('Set Radius') then
    mq.cmd('/maxradius ', config.setRadius)
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'determines how far from camp the puller will pull.')
end

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.setArc = ImGui.InputText('##setArc', config.setArc)

ImGui.SameLine()
if ImGui.SmallButton('Set Pull Arc') then
    mq.cmd('/setpullarc ', config.setArc)
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'This command allows you to set your pull width and the direction you want to pull from. An angle width of 0 will disable directional pulling. Valid directions are n,ne,e,se,s,sw,w,nw, or any number from 1 - 360. If you leave the direction blank your current heading is used.')
end

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.setZrange = ImGui.InputText('##setZrange', config.setZrange)

ImGui.SameLine()
if ImGui.SmallButton('Set Z Range') then
    mq.cmd('/maxzrange ', config.setZrange)
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'determines how far above/below you will pull from. Think Hills, or second floors if a mob is up on a hill and your not pulling it, you might have this set too low.')
end

ImGui.NewLine()
ImGui.SetNextItemWidth(50)
config.PullWait = ImGui.InputText('##PullWait', config.PullWait)

ImGui.SameLine()
if ImGui.SmallButton('Pull Wait Time') then
    if config.selectedPath and config.selectedPath ~= "" then
        utils.saveSettingsToIniFile(config.selectedPath, config)
        mq.cmd('/kasettings load pull')
    else
        print("No file path selected to save settings, try reloading your ini.")
    end
end
if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'Wait until rampage/swarm pets drop before starting next pull. (Used for pet classes in PullerPetTank role).')
end

ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.ChainPullHP = ImGui.InputText('##ChainPullHP', config.ChainPullHP)

ImGui.SameLine()
if ImGui.SmallButton('Set Chain Pull Hp') then
    if config.selectedPath and config.selectedPath ~= "" then
        utils.saveSettingsToIniFile(config.selectedPath, config)
        mq.cmd('/kasettings load pull')
    else
        print("No file path selected to save settings, do you have an ini loaded?")
    end
end

if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
            'Mob HP level to start looking for another mob to pull if chain pull is checked. Chain pulling ONLY works in the Puller role, not PullerTank')
end

ImGui.NewLine()
config.fadeOverPullsEnabled = ImGui.Checkbox("Fade Over Pulls", config.fadeOverPullsEnabled)

ImGui.SameLine()
ImGui.SetNextItemWidth(150)
if ImGui.BeginCombo("Fade Ability", config.fadeActionLabels[config.fadeAction]) then
    for i, action in ipairs(config.fadeActions) do
        local isSelected = (config.fadeAction == action)
        if ImGui.Selectable(config.fadeActionLabels[action], isSelected) then
            config.fadeActionIndex = i
            config.fadeAction = action
        end
        if isSelected then
            ImGui.SetItemDefaultFocus()
        end
    end
    ImGui.EndCombo()
end

if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
        'Will attempt to use Class specific "Fade" AA to drop aggro if conditions are met while pulling. You must be in puller, hunter, or puller tank role for this to work')
end

ImGui.SameLine()
ImGui.Text("Hater Count:")
ImGui.SameLine()
ImGui.SetNextItemWidth(50)
config.xtHaterCountThreshold = ImGui.InputText('##xtHaterCountThreshold', tostring(config.xtHaterCountThreshold))

if showTooltips and ImGui.IsItemHovered() then
    ImGui.SetTooltip(
        'This is the number of mobs you want to reach before trying to fade a bad pull')
end

ImGui.Separator()

local itemsPerColumn = 5
local totalItems = #config.pullTabLabels
local numColumns = math.ceil(totalItems / itemsPerColumn)

ImGui.Columns(numColumns)

for i, key in ipairs(config.pullTabLabels) do
    local isChecked = config.checkboxStates[key] or false
    local newValue, valueChanged = ImGui.Checkbox("##" .. key, isChecked)
    ImGui.SameLine()

    local displayLabel = config.displayLabels[key] or key
    ImGui.Text(displayLabel)

    if showTooltips and ImGui.IsItemHovered() then
        local tooltipText = config.pullTabTooltips[key] or "No tooltip available."
        ImGui.SetTooltip(tooltipText)
    end

    if valueChanged then
        config.checkboxStates[key] = newValue
        if checkboxHandlers[key] then
            checkboxHandlers[key](newValue)
        end
    end

    if i % itemsPerColumn == 0 and i < totalItems then
        ImGui.NextColumn()
    end
end

ImGui.Columns(1)
end

-- Mez Tools Tab

local function DrawMezToolsTab()
    ImGui.Text("Mez Settings")


    ImGui.NewLine()
    ImGui.SetNextItemWidth(50)
    config.setMezradius = ImGui.InputText('##setMezRadius', config.setMezradius)

    ImGui.SameLine()
    if ImGui.SmallButton('Mez Radius') then
        if config.selectedPath and config.selectedPath ~= "" then
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load mez')
        else
            print("No file path selected to save settings, you might need to reload your ini.")
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Radius to detect mobs surrounding enchanter/bard.')
    end

    ImGui.SameLine()
    ImGui.SetNextItemWidth(50)
    config.setStophp = ImGui.InputText('##setStophp', config.setStophp)
    ImGui.SameLine()
    if ImGui.SmallButton('Mez Stop HP') then
        if config.selectedPath and config.selectedPath ~= "" then
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load mez')
        else
            print("No file path selected to save settings, try reloading your ini.")
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Mob HPs to stop mezzing at.')
    end

    ImGui.SameLine()
    if ImGui.SmallButton("Add Immune") then
        mq.cmd('/addimmune "${Target.CleanName}"')
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Adds Target to the MezImmune list **Modifies KissAssist_Info.ini**')
    end

    ImGui.NewLine()
    ImGui.SetNextItemWidth(50)
    config.MezMinLevel = ImGui.InputText('##MezMinLevel', config.MezMinLevel, config.buffer_size)

    ImGui.SameLine()
    ImGui.Text("-")

    ImGui.SameLine()
    ImGui.SetNextItemWidth(50)
    config.MezMaxLevel = ImGui.InputText('##MezMaxLevel', config.MezMaxLevel, config.buffer_size)

    ImGui.SameLine()
    if ImGui.SmallButton('Set Mez Level Range') then
        if config.selectedPath and config.selectedPath ~= "" then
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load mez')
        else
            print("No file path selected to save settings, maybe you should reload your ini.")
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Min/Max level of mobs to mez within MezRadius')
    end

    ImGui.Separator()

    ImGui.NewLine()

    local itemsPerColumn = 5
    local totalItems = #config.mezTabLabels
    local numColumns = math.ceil(totalItems / itemsPerColumn)

    ImGui.Columns(numColumns)

    for i, key in ipairs(config.mezTabLabels) do
        local isChecked = config.checkboxStates[key] or false
        local newValue, valueChanged = ImGui.Checkbox("##" .. key, isChecked)
        ImGui.SameLine()

        local displayLabel = config.displayLabels[key] or key
        ImGui.Text(displayLabel)

        if showTooltips and ImGui.IsItemHovered() then
            local tooltipText = config.mezTabTooltips[key] or "No tooltip available."
            ImGui.SetTooltip(tooltipText)
        end

        if valueChanged then
            config.checkboxStates[key] = newValue
            if checkboxHandlers[key] then
                checkboxHandlers[key](newValue)
            end
        end

        if i % itemsPerColumn == 0 and i < totalItems then
            ImGui.NextColumn()
        end
    end

    ImGui.Columns(1)
end

local function DrawPetSettingsTab()
    ImGui.Text("Pet Settings")

    ImGui.NewLine()
    ImGui.SetNextItemWidth(50)
    config.PetAssistAt = ImGui.InputText('##PetAssistAt', config.PetAssistAt)

    ImGui.SameLine()
    if ImGui.SmallButton('Pet Assist At') then
        if config.selectedPath and config.selectedPath ~= "" then
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load pet')
        else
            print("No file path selected to save settings, i think you might want to reload your ini.")
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Adjusts the mobs health your pet should start attacking.')
    end

    ImGui.Separator()
    ImGui.NewLine()

    local itemsPerColumn = 5
    local totalItems = #config.petTabLabels
    local numColumns = math.ceil(totalItems / itemsPerColumn)

    ImGui.Columns(numColumns)

    for i, key in ipairs(config.petTabLabels) do
        local isChecked = config.checkboxStates[key] or false
        local newValue, valueChanged = ImGui.Checkbox("##" .. key, isChecked)
        ImGui.SameLine()

        local displayLabel = config.displayLabels[key] or key
        ImGui.Text(displayLabel)

        if showTooltips and ImGui.IsItemHovered() then
            local tooltipText = config.petTabTooltips[key] or "No tooltip available."
            ImGui.SetTooltip(tooltipText)
        end

        if valueChanged then
            config.checkboxStates[key] = newValue
            if checkboxHandlers[key] then
                checkboxHandlers[key](newValue)
            end
        end

        if i % itemsPerColumn == 0 and i < totalItems then
            ImGui.NextColumn()
        end
    end

    ImGui.Columns(1)
end

--Heal and Buff Tab

local function DrawHealTab()
    ImGui.Text("Heal, Buff, and AE Settings")

    ImGui.NewLine()
    ImGui.SetNextItemWidth(50)
    config.AERadius = ImGui.InputText('##AERadius', config.AERadius)

    ImGui.SameLine()
    if ImGui.SmallButton('Set AE Radius') then
        if config.selectedPath and config.selectedPath ~= "" then
            utils.saveSettingsToIniFile(config.selectedPath, config)
            mq.cmd('/kasettings load ae')
        else
            print("No file path selected to save settings, this might mean you need to reload your ini.")
        end
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Radius around character to detect mobs.')
    end

    ImGui.SameLine()
    ImGui.SetNextItemWidth(50)
    config.setMed = ImGui.InputText('##setMed', config.setMed)

    ImGui.SameLine()
    if ImGui.SmallButton('Med Start') then
        mq.cmd('/medstart ', config.setMed)
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Determines the mana/endurance to begin meditating')
    end

    ImGui.SameLine()
    if ImGui.SmallButton("Force Group Rebuff") then
        mq.cmd('/buffgroup"')
    end
    if showTooltips and ImGui.IsItemHovered() then
        ImGui.SetTooltip('Forces the caster to re-cast group buffs from Kiss ini Buffs section.')
    end

    ImGui.Separator()
    ImGui.NewLine()

    local itemsPerColumn = 5
    local totalItems = #config.healTabLabels
    local numColumns = math.ceil(totalItems / itemsPerColumn)

    ImGui.Columns(numColumns)

    for i, key in ipairs(config.healTabLabels) do
        local isChecked = config.checkboxStates[key] or false
        local newValue, valueChanged = ImGui.Checkbox("##" .. key, isChecked)
        ImGui.SameLine()

        if showTooltips and ImGui.IsItemHovered() then
            local tooltipText = config.healTabTooltips[key] or "No tooltip available."
            ImGui.SetTooltip(tooltipText)
        end

        local displayLabel = config.displayLabels[key] or key
        ImGui.Text(displayLabel)

        if valueChanged then
            config.checkboxStates[key] = newValue
            if checkboxHandlers[key] then
                checkboxHandlers[key](newValue)
            end
        end

        if i % itemsPerColumn == 0 and i < totalItems then
            ImGui.NextColumn()
        end
    end

    ImGui.Columns(1)
end

return {
    DrawMainTab = DrawMainTab,
    DrawPullingTab = DrawPullingTab,
    DrawMezToolsTab = DrawMezToolsTab,
    DrawPetSettingsTab = DrawPetSettingsTab,
    DrawHealTab = DrawHealTab,
    DrawStaticStuff = DrawStaticStuff,
}
