--ZFix version 0.8
--corrector for 'You cannot hit your target'
-- by Nerp

local mq = require('mq')
require('ImGui')

local me = mq.TLO.Me.Name()
local count = 0
local target 
local savedtarget = 0
local cwtn_group_mode = 2
local MOVING = false
local DEBUG = false
local PAUSED = false
local timer = os.time()

local function debug(string)
    if(DEBUG) then print(string.format('DEBUG: %s',tostring(string))) end
end

local function pause()
    print('Pausing')
    mq.cmdf("/%s pause on", mq.TLO.Me.Class.ShortName() )
    mq.cmd("/squelch /mqp on")
    mq.cmd("/stick off")
    mq.cmd("/nav stop")
end

local function resume()
    print('Resuming')
    mq.cmdf("/%s pause off", mq.TLO.Me.Class.ShortName() )
    mq.cmd("/squelch /mqp off")
end

local function moveback(distance, angle)
    local val, headingMQ, headingLUA
    local me_X = mq.TLO.Me.X() -- .E TLO returns -X
    local me_Y = mq.TLO.Me.Y()
    local me_Z = mq.TLO.Me.Z()
    facing = 360 - mq.TLO.Me.Heading.Degrees() + 90
    local dx = distance * math.sin(math.rad(facing + angle))
    local dy = distance * math.cos(math.rad(facing + angle))
    local x2 = me_X - dx
    local y2 = me_Y - dy
    debug('me_X: '..me_X..' me_Y: '..me_Y..' dx: '..dx..' dy: '..dy..' x2: '..x2..' y2: '..y2)
    debug('Nav path check: '..tostring(mq.TLO.Navigation.PathExists(string.format('locxy %d %d', x2, y2))()) ..'  string: '..string.format('locxy %d %d', x2, y2))
    debug('Nav path distance check: '..tostring(mq.TLO.Navigation.PathLength(string.format('locxy %d %d %d', x2, y2, me_Z))())..' for distance: '..distance  )
    if mq.TLO.Navigation.PathExists(string.format('locxyz %d %d %d', x2, y2, me_Z))() then
        if mq.TLO.Navigation.PathLength(string.format('locxyz %d %d %d', x2, y2, me_Z))() > 1.25*distance then
            debug('PathLength too long - moveback Navigation canceled.')
            return false
        else
            debug('Moving back '..distance)
            mq.cmd('/squelch /nav '..string.format('locxyz %d %d %d %s', me_X - dx, me_Y - dy, me_Z, 'setopt facing=backward log=off'))
            while mq.TLO.Navigation.Active() do mq.delay(125) end
            return true
        end
    else 
        return false
    end
end

local function Event_BrokenZ()
    local dist = mq.TLO.Target.Distance() or -1
    if dist > 0 and dist < 20 then
        if timer > os.time() + 2 then
            count = 0
            timer = os.time()
            debug("resetting counter")
            return true
        end
        count = count + 1
        debug("increasing counter to "..count)
        timer = os.time()
    end
    if count < 16 then return true end
    if MOVING then return false end
    MOVING = true
    pause()
    --mq.cmd('/dgge /cwtn mode 0')
    mq.cmd('/target id ${Me.ID}')
    mq.cmd('/dgga /target clear')
    mq.cmd('/dgga /pet back')
    mq.delay(500)
    mq.cmd('/dgga /pet back')

    if moveback(40,0) then print('Backing Up (Heading 0)')
    elseif moveback(40,45) then print('Backing Up (Heading 45)')
    elseif moveback(40,-45) then print('Backing Up (Heading -45)')
    elseif moveback(40,90) then print('Backing Up (Heading 90)')
    elseif moveback(40,-90) then print('Backing Up (Heading -90)')
    else 
        print('Moveback failure')
        mq.cmd('/dgt \arI need attention.')
    end
    mq.cmd('/dgge /cwtn pause on')
    mq.cmd('/dgge /target clear')
    mq.cmd('/dgga /nav id ${Me.ID}')
    mq.cmd('/dgga /pet back')
    mq.delay(500)
    mq.cmd('/dgga /pet back')
    mq.delay(2000)
    mq.cmd('/dgge /cwtn pause off')
    mq.cmd('/target clear')
    resume()
    --mq.cmdf('/dgge /cwtn mode %s',cwtn_group_mode)
    MOVING = false
    count = 0
end

local function bind(...)
    local args = {...}
    local key = args[1]
    local value = args[2]
    if key == 'pause' then
        PAUSED = PAUSED == false
        print('Zfix Pause set to: '..tostring(PAUSED))
    elseif key == 'camp' or key == '1' then 
        cwtn_group_mode = 1
    elseif key == 'chase' or key == '2' then
        cwtn_group_mode = 2
    elseif key == 'debug' then
        DEBUG = DEBUG == false
        print('Zfix Debug set to: '..tostring(DEBUG))
    end
end

local function Init()
    mq.event('ev1', "#*#You cannot see your target#*#", Event_BrokenZ)
    mq.event('ev2', "#*#You can't hit them from here#*#", Event_BrokenZ)
    mq.bind('/zfix', bind)
    if mq.TLO.Group.MainAssist.Name() ~= me then 
        print('Only run this on your MA')
        mq.exit()
    end
    print('Usage:')
--    print('NOTE:  Default mode is chase, you must change to camp mode if you are doing that instead.')
--    print('         /zfix camp  :: set group to camp mode after force move')
--    print('         /zfix chase :: set group to chase mode after force move')
    print('         /zfix pause :: toggle pause')
    print('         /zfix debug :: toggle debug messages')
end

local function Main()
    while true do
        if not PAUSED then
            mq.doevents()
            target = mq.TLO.Target.ID()
            --reset counter if target changes
            if target ~= savedtarget and target ~= nil then 
                debug('Zfix: Target change. Resetting counter.')
                savedtarget = target
                count = 0
            end
        end
        mq.delay(1000)
    end
end

Init()
Main()