---@type Mq
local mq = require('mq')

local switchtimer = 10
local class = mq.TLO.Me.Class.ShortName()
local incombat = nil


local function split(text, delim)
    -- returns an array of fields based on text and delimiter (one character only)
    local result = {}
    local magic = "().%+-*?[]^$"

    if delim == nil then
        delim = "%s"
    elseif string.find(delim, magic, 1, true) then
        -- escape magic
        delim = "%"..delim
    end

    local pattern = "[^"..delim.."]+"
    for w in string.gmatch(text, pattern) do
        table.insert(result, w)
    end
    return result
end
mq.cmdf('/%s mode vorpal', class)
local basecamp = split(mq.TLO.Me.LocYX(), ',')
    


while true do
    
    if mq.TLO.Me.CombatState() == 'COMBAT' then
        math.randomseed(os.clock()*100000000000)
        local currentStick = math.random(0,2)
        mq.cmdf('/%s stickselection %i', class, currentStick)
        mq.delay(switchtimer * 1000)
    end
    if mq.TLO.Me.CombatState() == 'COOLDOWN' then
        math.randomseed(os.clock()*100000000000)
        local nextAssistAt = math.random(85,100)
        mq.cmdf('/%s autoassistat %i', class, nextAssistAt)
        math.randomseed(os.clock()*100000000000)
        local campOffset = math.random(-10,10)
        local newCampY = basecamp[1] + campOffset
        local newCampX = basecamp[2] + campOffset
        mq.cmdf('/nav locyx %i %i', newCampY, newCampX)
        mq.delay(switchtimer * 1000)
    end

end