-- emuzoner by jimmy6154
-- version 2 or whatever
-- thanks chatgpt for your help

local mq = require('mq')
local imgui = require('ImGui')

-- Load continent files
local regions = {
    ["Classic - Antonica"] = require('emuzoner.zonelists.antonica'),
    ["Classic - Faydwer"] = require('emuzoner.zonelists.faydwer'),
    ["Classic - Odus"] = require('emuzoner.zonelists.odus'),
    ["The Ruins of Kunark"] = require('emuzoner.zonelists.kunark'),
    ["The Scars of Velious"] = require('emuzoner.zonelists.velious'),
    ["The Shadows of Luclin"] = require('emuzoner.zonelists.luclin'),
    ["The Planes of Power"] = require('emuzoner.zonelists.planes_of_power'),
    ["Legacy of Ykesha"] = require('emuzoner.zonelists.legacy_of_ykesha'),
    ["Lost Dungeons of Norrath"] = require('emuzoner.zonelists.lost_dungeons_of_norrath'),
    ["Gates of Discord"] = require('emuzoner.zonelists.gates_of_discord'),
    ["Omens of War"] = require('emuzoner.zonelists.omens_of_war'),
    ["Dragons of Norrath"] = require('emuzoner.zonelists.dragons_of_norrath'),
    ["Depths of Darkhollow"] = require('emuzoner.zonelists.depths_of_darkhollow'),
    ["Prophecy of Ro"] = require('emuzoner.zonelists.prophecy_of_ro'),
    ["The Serpents Spine"] = require('emuzoner.zonelists.the_serpents_spine'),
    ["The Buried Sea"] = require('emuzoner.zonelists.the_buried_sea'),
    ["Secrets of Faydwer"] = require('emuzoner.zonelists.secrets_of_faydwer'),
    ["Seeds of Destruction"] = require('emuzoner.zonelists.seeds_of_destruction'),
    ["Underfoot"] = require('emuzoner.zonelists.underfoot'),
    ["House of Thule"] = require('emuzoner.zonelists.house_of_thule'),
    ["Veil of Alaris"] = require('emuzoner.zonelists.veil_of_alaris'),
    ["Rain of Fear"] = require('emuzoner.zonelists.rain_of_fear'),
}

-- Function to sort zones by label
local function sortZonesByLabel(zones)
    table.sort(zones, function(a, b) return a.label < b.label end)
end

-- Sort each region's zones by label
for _, zones in pairs(regions) do
    sortZonesByLabel(zones)
end

-- Create ordered region_names list
local region_names = {}
local region_order = {
    "Classic - Antonica",
    "Classic - Faydwer",
    "Classic - Odus",
    "The Ruins of Kunark",
    "The Scars of Velious",
    "The Shadows of Luclin",
    "The Planes of Power",
    "Legacy of Ykesha",
    "Lost Dungeons of Norrath",
    "Gates of Discord",
    "Omens of War",
    "Dragons of Norrath",
    "Depths of Darkhollow",
    "Prophecy of Ro",
    "The Serpents Spine",
    "The Buried Sea",
    "Secrets of Faydwer",
    "Seeds of Destruction",
    "Underfoot",
    "House of Thule",
    "Veil of Alaris",
    "Rain of Fear",
}

for _, region in ipairs(region_order) do
    if regions[region] then
        table.insert(region_names, region)
    end
end

local state = {
    selected_region = region_names[1],
    selected_zone = nil,
    custom_zones = {},
    window_open = true,
}

-- Load custom buttons from custombutton.lua
local function loadCustomZones()
    local file, err = io.open(mq.luaDir .. '/emuzoner/custom/custombutton.lua', 'r')
    if not file then
        print("Error opening custombutton.lua: " .. (err or "unknown error"))
        return
    end

    local content = file:read("*all")
    file:close()

    for command, label in content:gmatch('{command%s*=%s*"(.-)",.-label%s*=%s*"(.-)"}') do
        local is_goto = command:match("^#goto") ~= nil
        table.insert(state.custom_zones, {command = command, label = label, is_goto = is_goto})
    end

    -- Ensure we have exactly 4 custom zone slots
    while #state.custom_zones < 4 do
        table.insert(state.custom_zones, {command = "#zone ", label = "", is_goto = false})
    end
    -- Trim to 4 if we have more
    while #state.custom_zones > 4 do
        table.remove(state.custom_zones)
    end
end

-- Function to save a custom zone to custombutton.lua
local function saveCustomZone(index, command, label, is_goto)
    state.custom_zones[index].command = command
    state.custom_zones[index].label = label
    state.custom_zones[index].is_goto = is_goto

    local file, err = io.open(mq.luaDir .. '/emuzoner/custom/custombutton.lua', 'w')
    if not file then
        print("Error opening custombutton.lua for writing: " .. (err or "unknown error"))
        return
    end

    for i = 1, 4 do
        file:write(string.format('    {command = "%s", label = "%s"},\n', 
            state.custom_zones[i].command, state.custom_zones[i].label))
    end
    file:close()
end

local function drawGui()
    local window_open, should_draw = imgui.Begin('EMUZoner', state.window_open)
    state.window_open = window_open

    if should_draw then
        
        imgui.Text("Select a region and zone to teleport:")

        -- Dropdown for selecting a region
        if imgui.BeginCombo("Region", state.selected_region) then
            for _, region in ipairs(region_names) do
                local is_selected = (region == state.selected_region)
                if imgui.Selectable(region, is_selected) then
                    state.selected_region = region
                    state.selected_zone = nil
                end
                if is_selected then
                    imgui.SetItemDefaultFocus()
                end
            end
            imgui.EndCombo()
        end

        -- Dropdown for selecting a zone
        if state.selected_region then
            local current_zone = state.selected_zone and state.selected_zone.label or "Select a zone"
            if imgui.BeginCombo("Zone", current_zone) then
                for _, zone in ipairs(regions[state.selected_region]) do
                    local is_selected = (state.selected_zone == zone)
                    if imgui.Selectable(zone.label, is_selected) then
                        state.selected_zone = zone
                    end
                    if is_selected then
                        imgui.SetItemDefaultFocus()
                    end
                end
                imgui.EndCombo()
            end
        end

        -- Button to execute the command for the selected zone
        if state.selected_zone and imgui.Button("Teleport to " .. state.selected_zone.label) then
            mq.cmdf('/say %s', state.selected_zone.command)
            mq.cmd('/echo \ayTeleporting to ' .. state.selected_zone.label .. '\ax')
        end

        imgui.Separator()
        imgui.Text("Hot Zone Buttons:")

        -- Custom zone buttons
        local button_width = imgui.GetWindowContentRegionWidth() / 2 - 5
        for i, custom_zone in ipairs(state.custom_zones) do
            if i % 2 == 1 and i > 1 then
                imgui.NewLine()
            elseif i % 2 == 0 then
                imgui.SameLine()
            end
            
            if imgui.Button(custom_zone.label ~= "" and custom_zone.label or ("Custom Zone " .. i), button_width, 50) then
                if custom_zone.command ~= "" then
                    mq.cmdf('/say %s', custom_zone.command)
                    mq.cmd('/echo \ayTeleporting to ' .. custom_zone.label .. '\ax')
                end
            end
            
            if imgui.IsItemClicked(1) then  -- Right-click
                imgui.OpenPopup("Edit Custom Zone##" .. i)
            end

            if imgui.BeginPopup("Edit Custom Zone##" .. i) then
                imgui.Text("Label:")
                local new_label = imgui.InputText("##Label" .. i, state.custom_zones[i].label, 1024)
                if new_label ~= state.custom_zones[i].label then
                    state.custom_zones[i].label = new_label
                end

                local input_label = state.custom_zones[i].is_goto and "Goto Player, NPC LongName, or XYZ cords:" or "Zone Shortname:"
                imgui.Text(input_label)
                local command_without_prefix = state.custom_zones[i].command:gsub("^#%w+%s+", "")
                local new_command = imgui.InputText("##Command" .. i, command_without_prefix, 1024)
                if new_command ~= command_without_prefix then
                    local prefix = state.custom_zones[i].is_goto and "#goto " or "#zone "
                    state.custom_zones[i].command = prefix .. new_command
                end

                if imgui.Button("Save##" .. i) then
                    saveCustomZone(i, state.custom_zones[i].command, state.custom_zones[i].label, state.custom_zones[i].is_goto)
                    imgui.CloseCurrentPopup()
                end
                
                imgui.SameLine()
                
                if imgui.Button("Cancel##" .. i) then
                    imgui.CloseCurrentPopup()
                end

                imgui.SameLine()

                if imgui.Button(state.custom_zones[i].is_goto and "Switch to #zone" or "Switch to #goto") then
                    state.custom_zones[i].is_goto = not state.custom_zones[i].is_goto
                    local command_without_prefix = state.custom_zones[i].command:gsub("^#%w+%s+", "")
                    local new_prefix = state.custom_zones[i].is_goto and "#goto " or "#zone "
                    state.custom_zones[i].command = new_prefix .. command_without_prefix
                end

                imgui.EndPopup()
            end
        end
    end
    imgui.End()
end

-- Create and manage the imgui window
local EMUZonerWindow = function()
    drawGui()
end

loadCustomZones()
mq.imgui.init('EMUZoner', EMUZonerWindow)

print("EMUZoner script started")

-- Main loop
while state.window_open do
    mq.delay(100)  -- Reduced delay for better responsiveness
    mq.doevents()
end

print("EMUZoner script ended")
mq.exit()