-- (Re)starts Grouper.lua (thanks to rouneq for the restart snippet).

local mq = require('mq')

local function luaCommand(command, ...)
    local line = table.concat({...}, ' ')
    mq.cmd.lua(command .. " " .. line)
end

local function luaRun(...)
    luaCommand("run", ...)
end

local function luaStop(...)
    if (string.lower(select(1, ...)) == "restart") then
        mq.exit()
    end
    luaCommand("stop", ...)
end

local function luaRestart(...)
    luaStop(...)
    mq.delay(100)
    luaRun(...)
end

luaRestart('grouper/grouper.lua')
