
-- Mission_FinalFugue
-- Version 1.9
---------------------------
local mq = require('mq')
local lip = require('lib.LIP')
local logger = require('utils.logger')

---------------------------
--- CHANGE these per your desires
local request_zone = 'laurioninn'
local request_npc = 'Shalowain'
local travelto_zone = 'pallomen'
local quest_zone = 'pallomen_mission'
local delay_before_zoning = 27000  -- 27s
-------------------------

local config_path = ''
local task = mq.TLO.Task('Final Fugue')

local function file_exists(name)
	local f = io.open(name, "r")
	if f ~= nil then io.close(f) return true else return false end
end

-- Do not change these. After script run once, actual values stored in
-- config > mission_finalfugue_{charname}.ini
local settings = {
    general = {
        GroupMessage = "dannet", -- or "bc"
        KillArchers = true,
        UseBandoliers = true,
        StunBandolierName = "stun",
        RegularBandolierName = "standard",
        WaitBeforeEngagingHunters = true,
        OpenChest = false,
        ResetCampAtHunters = true,
    }
}
local function load_settings()
    local config_dir = mq.configDir:gsub('\\', '/') .. '/'
    local config_file = string.format('mission_finalfugue_%s.ini', mq.TLO.Me.CleanName())
    config_path = config_dir .. config_file
    if (file_exists(config_path) == false) then
        lip.save(config_path, settings)
   else
        settings = lip.load(config_path)

        -- Version updates
        local is_dirty = false
        if (settings.general.ResetCampAtHunters == nil) then
            settings.general.ResetCampAtHunters = true
            is_dirty = true
        end
        if (settings.general.UseBandoliers == nil) then
            settings.general.UseBandoliers = true
            is_dirty = true
        end
        if (settings.general.KillArchersAtStart ~= nil) then
            settings.general.KillArchersAtStart = nil
            is_dirty = true
        end
        if (settings.general.MoveGroupToQuestZone ~= nil) then
            settings.general.MoveGroupToQuestZone = nil
            is_dirty = true
        end
        if (settings.general.WaitBeforeEngagingHunters == nil) then
            settings.general.WaitBeforeEngagingHunters = true
            is_dirty = true
        end
        if (is_dirty) then lip.save(config_path, settings) end
   end
 end

 local function send_message(do_noparse, scope, command, ...)
    local full_command = string.format(command, ...)
    local noparse = ''
    if (do_noparse) then noparse = '/noparse ' end
    local preslash = ''
    if (settings.general.GroupMessage == 'bc') then preslash = '/' end

    full_command = string.format('%s/%s %s%s', noparse, scope, preslash, full_command)
    mq.cmd(full_command)
end

local function send_individual_message(char_name, command, ...)

    local full_command = string.format(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        full_command = string.format('/dex %s', full_command)
    else
        full_command = string.format('/bct %s /%s', char_name, full_command)
    end

    mq.cmd(full_command)
end

local function send_group_message(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(false, 'dgga', command, ...)
    else
        send_message(false, 'bcga', command, ...)
    end
end

local function send_others_message(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(false, 'dgge', command, ...)
    else
        send_message(false, 'bcg', command, ...)
    end
end

local function send_others_message_noparse(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(true, 'dgge', command, ...)
    else
        send_message(true, 'bcg', command, ...)
    end
end


local function is_up(spawn_name, distance)
    local spawn_search = 'npc '..spawn_name
    if (distance ~= nil) then
        spawn_search = string.format('%s radius %d', spawn_search, distance)
    end
    return mq.TLO.Spawn(spawn_search).ID() > 0
end

local function WaitForGroupToZone()
    local displayed_message = false
    while(true) do
        if (mq.TLO.Group.AnyoneMissing() == false) then
            return
        end

        if (displayed_message == false) then
            logger.info('In zone. Waiting for group to catch up.')
            displayed_message = true
        end

        ::keep_waiting::
        mq.delay(1000)
        mq.doevents()
    end
end

local function TravelTo(zoneName, whole_group, target_zoneName)
    if (target_zoneName == nil) then target_zoneName = zoneName end

    if (mq.TLO.Zone.ShortName() == target_zoneName and (whole_group == false or mq.TLO.Group.AnyoneMissing() == false)) then
        return
    end

    if mq.TLO.Zone.ShortName() ~= target_zoneName then
        if (whole_group == true) then
            logger.info('Whole group traveling to \at%s', zoneName)
            send_group_message('/travelto %s', zoneName)
        else
            logger.info('Traveling to %s', zoneName)
            mq.cmdf('/travelto %s', zoneName)
        end
    end

    --traveling, please wait--
    while mq.TLO.Zone.ShortName() ~= target_zoneName do
        mq.delay(500)
        mq.doevents()
    end

    if (whole_group) then
        WaitForGroupToZone()
    end
end

local function MoveToSpawn(spawn, distance)
    if (distance == nil) then distance = 5 end

    if (spawn == nil or spawn.ID() == nil) then return end
    if (spawn.Distance() < distance) then return true end

    mq.cmdf('/squelch /nav id %d npc |dist=%s', spawn.ID(), distance)
    while mq.TLO.Nav.Active() do mq.delay(1) end
    mq.delay(500)
    return true
end

local function MoveTo(spawn_name, distance)
    local spawn = mq.TLO.Spawn('npc '..spawn_name)
    return MoveToSpawn(spawn, distance)
end

local function MoveToId(spawn_id, distance)
    local spawn = mq.TLO.Spawn('npc id '..spawn_id)
    return MoveToSpawn(spawn, distance)
end

local function MoveToObject(spawn, distance)
    if (mq.TLO.SpawnCount(spawn)() <= 0) then return false end

    if (distance == nil) then distance = 5 end

    if (mq.TLO.Spawn(spawn).Distance() < distance) then return true end

    mq.cmdf('/squelch /nav spawn "%s" |dist=%s', spawn, distance)
    while mq.TLO.Nav.Active() do mq.delay(1) end
    mq.delay(500)
    return true
end

local function MoveToLoc(locXyz)
    mq.cmdf('/squelch /nav loc %s', locXyz)
    while mq.TLO.Nav.Active() do mq.delay(1) end
    mq.delay(500)
    return true
end

local function MoveToAndAttack(spawn)
    if MoveTo(spawn) == false then return false end
    mq.cmdf('/squelch /target %s', spawn)
    mq.delay(250)
    mq.cmd('/attack on')
    return true
end

local function MoveToAndTarget(spawn)
    if MoveTo(spawn) == false then return false end
    mq.cmdf('/squelch /target %s', spawn)
    mq.delay(250)
    return true
end

local function MoveToAndAttackId(id)
    if MoveToId(id) == false then return false end
    mq.cmdf('/squelch /target id %s', id)
    mq.delay(250)
    mq.cmd('/attack on')
    return true
end

local function MoveToAndTargetId(id)
    if MoveToId(id) == false then return false end
    mq.cmdf('/squelch /target id %s', id)
    mq.delay(250)
    return true
end

local function MoveToAndAct(spawn,cmd)
    if MoveToAndTarget(spawn) == false then return false end
    mq.cmd(cmd)
    return true
end

local function CorpseTargetCheck()
    if (mq.TLO.Target.Type() == "Corpse") then
        mq.delay(500)
    end
end

local function CwtnResetCamp()
    if (mq.TLO.CWTN == nil) then return end
    if (settings.general.ResetCampAtHunters == false) then return end

    logger.info('\ay Resetting CWTN camp')
    mq.cmdf('/%s resetcamp', mq.TLO.CWTN.Command())
end

local function MoveToAndHail(spawn) return MoveToAndAct(spawn, '/hail') end
local function MoveToAndSay(spawn,say) return MoveToAndAct(spawn, string.format('/say %s', say)) end
local function MoveToAndOpen(spawn) return MoveToAndAct(spawn, '/open') end

local function KillAllBaddiesIfUp(spawn_name, distance, forceGroup, resetCamp)
    local last_actual_spawn = nil
    local is_new_target = false
    local spawn_name_lowercase = string.lower(spawn_name)
    if (resetCamp == nil) then resetCamp = false end

    while(true) do
        -- If we have a target and it's our desired mob, then wait a bit...
        if (mq.TLO.Target.ID() > 0 and string.find(string.lower(mq.TLO.Target.CleanName()), spawn_name_lowercase) ~= nil) then
            MoveToId(mq.TLO.Target.ID())
            mq.delay(250)
        else
            local spawn_search = string.format('"%s"', spawn_name)
            if (distance ~= nil) then
                spawn_search = spawn_search..' radius '..distance
            end

            local actual_spawn = mq.TLO.NearestSpawn('npc '..spawn_search)
            if (actual_spawn.ID() == nil) then
                logger.debug('No spawn found: (\at%s\ao)', spawn_search)
                return false
            end

            if (last_actual_spawn == nil or last_actual_spawn.ID() ~= actual_spawn.ID()) then
                last_actual_spawn = actual_spawn
                is_new_target = true
            else
                is_new_target = false
            end

            if (is_new_target == true) then
                logger.info('\aoKilling \at%s\ao (id:\at%s\ao)', spawn_name, actual_spawn.ID())
            end

            if (MoveToAndAttackId(actual_spawn.ID()) == false) then logger.debug('Move/Attack for (%s) failed', spawn_name) return end

            if (resetCamp == true) then
                CwtnResetCamp()
                resetCamp = false
            end

            if (forceGroup == true and is_new_target) then
                send_others_message('/target id %d', actual_spawn.ID())
                mq.delay(250)
                send_others_message('/attack on')
            end
        end

        CorpseTargetCheck()
    end
end

-- Some situations, the group would not automatically engage. This tells them all to target and attack
local function KillAllBaddiesIfUpForceGroup(spawn, distance)
    KillAllBaddiesIfUp(spawn, distance, true)
end

local function KillAllBaddiesIfUpAndAnotherDown(spawn, previous_spawn, distance)
    if (is_up(previous_spawn)) then
        logger.debug('Not killing \ay%s\aw as \ag%s\aw is up', spawn, previous_spawn)
        return false
    end
    return KillAllBaddiesIfUp(spawn, distance)
end

local function DoStep(step, action)
    local objective = task.Objective(step)
    if (objective.Status() == "Done") then
        logger.info('Step %s is done.', step)
        return true
    elseif (objective.Status() == nil) then
        logger.info('Step %s hasnt been unlocked. Jumping back to top.', step)
        mq.delay(1000)
        return false
    end

    logger.info('Executing step %s.', step)
    local result = action(objective)
    mq.delay(500)
    return result
end

local function WaitForMobToEnterRange(spawn_name, distance)
    logger.info('Waiting for \ay%s\aw to get in range (%d).', spawn_name, distance)
    while(true) do
        local spawn = mq.TLO.Spawn('npc '..spawn_name)
        if (spawn.ID() <= 0) then return end
        if spawn.Distance() <= distance then
            return
        end
        mq.delay(100)
    end
end

local wave1_complete = false
local function wave1()
    if (wave1_complete) then return end

    local distance = 150
    while(true) do
        local target = nil
        if (is_up('A Rallosian hex')) then
            target = 'A Rallosian hex'
            WaitForMobToEnterRange(target, distance)
        elseif (is_up('A Rallosian warlock')) then
            target = 'A Rallosian warlock'
        elseif (is_up('A Rallosian soldier', 200)) then
            target = 'A Rallosian soldier'
            distance = 200
        else
            wave1_complete = true
            logger.debug('Wave 1 complete')
            return
        end

        KillAllBaddiesIfUp(target, distance)
    end
end

local seen_wraith = false
local waited_for_hunters = false
local function wave2()
    KillAllBaddiesIfUp("A war boar", 80)
    KillAllBaddiesIfUp("A Rallosian boar handler", 80)

    if (seen_wraith == false and is_up('wraith')) then seen_wraith = true end
    KillAllBaddiesIfUp("A war wraith", 80)
end

local function wave3()
    -- First and third conditions can hit if script been running whole time
    -- Second is if script restarted after wraith but before hunters
    if (settings.general.WaitBeforeEngagingHunters == false) then
        logger.debug('\ay Running to Hunters.')
        KillAllBaddiesIfUp('a Rallosian hunter', 150, false, true)
    elseif (waited_for_hunters == false and seen_wraith == true and is_up('wraith') == false) then
        waited_for_hunters = true
        logger.info('\ay Ready for hunters.  Waiting 30 seconds before engaging.')
        mq.delay(30000)

        logger.info('\ay Moving to hunters.')
        KillAllBaddiesIfUp('a Rallosian hunter', 600, false, true)
    elseif (seen_wraith == false) then
        local spawn = mq.TLO.Spawn('npc Shalow')
        if (spawn.ID() == 0) then return end
        if (spawn.Y() < -400 or spawn.Y() > -100) then return end

        MoveToLoc('-30 -293 -35')
        logger.info('\ay Ready for hunters.  Waiting 5 seconds then engaging (%s)', spawn.Y())
        mq.delay(5000)

        logger.info('\ay Moving to hunters.')
        KillAllBaddiesIfUp('a Rallosian hunter', 600, false, true)
    end
end

local function kill_archers()
    if (settings.general.KillArchers == false) then return end
    if (mq.TLO.SpawnCount('npc archer')() == 0) then return end

    logger.info('\ay Going to kill archers...')
    send_group_message('/target id %s', mq.TLO.Me.ID())
    KillAllBaddiesIfUpForceGroup('archer')
end

local function swap_bandolier(bandolier_name)
    if (settings.general.UseBandoliers == false) then return end

    send_group_message('/bandolier activate %s', bandolier_name)
end

local captain_name = 'Captain Kar the Unmovable'
local function kill_kar()
    local in_stun_mode = false

    -- If we're actively engaged in a fight, skip here. (If script started mid-boss fight, e.g.)
    if (settings.general.KillArchers and mq.TLO.Me.XTarget(1).ID() == 0) then
        MoveToLoc('417 -636 -35')
        while(is_up('archer') == false) do mq.delay(100) end
        kill_archers()
    end

    while(true) do
        local spawn = mq.TLO.Spawn('npc '..captain_name)
        if (spawn == nil or spawn.ID() == 0) then logger.info('Captain Kar \arDead\aw Or mission reset')
            return
        end

        if (mq.TLO.Target.Name() ~= captain_name) then
            mq.cmd('/squelch /target Captain Kar')
            mq.cmd('/attack on')
        end

        -- We occasionally get stun/kicked and need to return
        if (spawn.Distance() > 15) then MoveTo(captain_name) end

        if (spawn.Level() >= 125) then
            if (in_stun_mode) then
                logger.info('\ag Resume Attack \aw')
                swap_bandolier(settings.general.RegularBandolierName)

                in_stun_mode = false
            end
        elseif (in_stun_mode == false) then
            kill_archers()

            logger.info('\ay Stun! \aw')

            swap_bandolier(settings.general.StunBandolierName)
            in_stun_mode = true
        end

        mq.delay(250)
    end
end

local function MoveToShalowain()
    if (is_up('Shalowain') == true and mq.TLO.Spawn('npc Shalowain').Distance() > 50) then
        logger.debug('\ay Catching up to Shalowain and friends.')
        MoveTo('Shalowain')
    end
end

local function get_stage()
    if (mq.TLO.Me.XTarget(1).ID() and mq.TLO.Me.XTarget(1).Name() == captain_name) then
        return 'boss_fight'
    end

    if (is_up('Elmara') == false) then
        return 'boss_fight'
    end

    local captain_spawn = mq.TLO.Spawn('npc '..captain_name)
    if (captain_spawn.ID() > 0 and captain_spawn.Y() > 680) then
        return 'boss_fight'
    end

    return 'trash'
end

local function action_start(step)
    -- Runs on restarts (even mid fights), but not really a problem.
    MoveToAndSay('Shalowain', 'they come')

    local stage = ''

    while step.Status() ~= "Done" do
        wave1()
        wave2()
        wave3()

        MoveToShalowain()

        KillAllBaddiesIfUp("Darga Smasher", 100)
        KillAllBaddiesIfUpAndAnotherDown("Margator the Slow", "Darga Smasher", 150)
        KillAllBaddiesIfUpAndAnotherDown("Firethorn", "Margator the Slow", 150)
        KillAllBaddiesIfUpAndAnotherDown("Yarith Wardbreaker", "Firethorn", 150)

        stage = get_stage()
        if (stage == 'boss_fight') then
            logger.info('Engaging \agCaptain Kar')
            kill_kar()
        end

        MoveToShalowain()

        mq.delay(500)

        if (mq.TLO.Zone.ShortName() ~= quest_zone) then
            logger.info('\ar Exited zone.\aw Ending macro.')
            os.exit()
        end
    end
end

local function action_openChest(step)
    -- TODO: Tie into framework
    mq.cmd('/nav spawn war_chest')
    while mq.TLO.Nav.Active() do mq.delay(1) end
    mq.cmd('/targ war_chest')
    mq.delay(250)
    mq.cmd('/open')
end

local function event_failed()
    mq.cmd('/beep')
    logger.info('\ar Event Failed.\aw Aborting');
    os.exit()
end

-- TODO: Add a waiting and try again logic
local function event_request_failed(line, char, duration)
    mq.cmd('/beep')
    logger.info('\ar Event Request Failed.\aw Need to wait on \ay%s\aw for \ay%s\aw.   Waiting...', char, duration);
    os.exit()
end

-- TODO: Add a waiting and try again logic
local function event_request_failed_wait()
    mq.cmd('/beep')
    logger.info('\ar Event Request Failed.\aw Need to wait and try again.  Exiting');
    os.exit()
end

local function event_cannot_enter()
    logger.info('\ar Zone Not Ready.\aw Waiting 10 seconds and trying to enter again.');
    mq.delay(10000)
    TravelTo(travelto_zone, true, quest_zone)
end

printf('\ao Setting up events')
mq.event('event_request_failed', "#*#You can not be assigned this shared task because your previous shared task has not ended yet#*#", event_request_failed_wait)
mq.event('event_request_failed', "#*#You may not request this shared task because #1# must wait #2# before#*#", event_request_failed)
mq.event('event_failed', "#*#Some of the Rallosian army were left to their own devices.#*#", event_failed)
mq.event('cannot_enter', "#*#A strange magical presence prevents you from entering.  It's too dangerous to enter at the moment.#*#", event_cannot_enter)

local steps = {
    start=1,
    openChest=2,
}

load_settings()

if (settings.general.GroupMessage == 'dannet') then
   logger.info('\aw Group Chat: \ayDanNet\aw.')
elseif (settings.general.GroupMessage == 'bc') then
   logger.info('\aw Group Chat: \ayBC\aw.')
else
   logger.info("Unknown or invalid group command.  Must be either 'dannet' or 'bc'. Ending macro. \ar%s", settings.general.GroupMessage)
   return
end

logger.info('\aw Killing Archers: \ay%s', settings.general.KillArchers)
logger.info('\aw Use Bandoliers: \ay%s', settings.general.UseBandoliers)
if (settings.general.UseBandoliers) then
   logger.info('.     \aw Stun Bandolier: \ay%s', settings.general.StunBandolierName)
   logger.info('.     \aw Reg  Bandolier: \ay%s', settings.general.RegularBandolierName)
end

logger.info('\aw Open Chest: \ay%s', settings.general.OpenChest)

---------------------------
if (task() == nil) then
    if (mq.TLO.Zone.ShortName() ~= request_zone) then
        logger.info('Not In %s to requets task.  Move group to that zone and restart.', request_zone)
        os.exit()
    end

    MoveToAndSay(request_npc, 'smaller')

    for index=1, 5 do
        mq.delay(1000)
        mq.doevents()

        task = mq.TLO.Task('Final Fugue')
        if (task() ~= nil) then break end

        if (index >= 5) then
            logger.info('Unable to get quest. Exiting.')
            os.exit()
        end
        logger.info('...waiting for quest.')
    end

    if (task() == nil) then
        logger.info('Unable to get quest. Exiting.')
        os.exit()
    end

    logger.info('\at Got quest.')
end

if (task() == nil) then
    logger.info('Problem requesting or getting task.  Exiting.')
    os.exit()
end

if (mq.TLO.Zone.ShortName() ~= quest_zone) then
    local time_since_request = 21600000 - task.Timer()
    local time_to_wait = delay_before_zoning - time_since_request
    logger.debug('TimeSinceReq: \ag%d\ao  TimeToWait: \ag%d\ao', time_since_request, time_to_wait)
    if (time_to_wait > 0) then
        logger.info('\at Waiting for instance generation \aw(\ay%.f second(s)\aw)', time_to_wait / 1000)
        mq.delay(time_to_wait)
    end

    TravelTo(travelto_zone, true, quest_zone)
end

if (mq.TLO.Zone.ShortName() ~= quest_zone) then logger.info('Not in correct zone. Fix that and start again.') return end

send_others_message_noparse('/docommand /${Me.Class.ShortName} mode 2')
send_others_message('/chase on')
if (mq.TLO.CWTN ~= nil) then
    mq.cmdf('/%s mode 7', mq.TLO.CWTN.Command())
end

::restart::
if (DoStep(steps.start, action_start) == false) then goto restart end
if (settings.general.OpenChest) then
    printf('\at Opening Chest')
    if (DoStep(steps.openChest, action_openChest) == false) then goto restart end
end

swap_bandolier(settings.general.RegularBandolierName)

logger.info('\ar Done.')
