--- @type boolean
local mq = require('mq')
local lip = require('lib.LIP')

------------------- Version 1.7.0 -------------------

local sendPetsOnEggs = true -- <<<------------------- ONLY changee this to "true" if you want to send pets
----------------------------------------------------- or "false" if you dont want to send pets on eggs
-----------------------------------------------------

-----------------------------------------------------
------- User Settings Saved on FIRST run only -------
---- Must delete old mission_HAFMission_NAME.ini ----
--- in \RedNext\config\ folder to save for future ---
local settings = {
    general = {
        GroupMessage = "dannet", -- <<<-------------- ONLY Change This! "bc" or "dannet"
        OpenChest = "false", -- <<<------------------ "false" will not open chest, "true" will open chest.
    }
}
-----------------------------------------------------
-----------------------------------------------------


local main_zone = 'herosforge'
local quest_zone = 'herosforge_mission'
local quest_request_zone = 'laurioninn'
local quest_request_npc = 'Elisel'
local quest_request_phrase = 'small'
local quest_start_npc = 'Elmara'

local SlimeBoss = 'a huge slime'
local SlimeAdd = 'a green slime'
local SpiderBoss = 'Queen of the Spiders'
local SpiderAdd = 'a widowmaker'
local Eggs = 'egg sacs'
local Lich = 'Lich'
local Mummy = 'a mummy'
local Shalowain = 'Shalowain'
local ChestName = '#a_fading_chest00'

local Radius = '50'
local CampX = '-1011'
local CampY = '240'
local CampZ = '196'

-- North Eggs Camp
local NorthEggCampX = '-998'
local NorthEggCampY = '387'
local NorthEggCampZ = '196'

-- South Eggs Camp
local SouthEggCampX = '-1155'
local SouthEggCampY = '236'
local SouthEggCampZ = '196'

local search_string = 'npc %s loc %d %d radius %d zradius %d'
local search_string2 = 'npc %s'
local CampCordXYZ = '%d %d %d'
local DistanceCheck = '%d %d %d : %d %d %d'

local LichSetupComplete = false
local SpiderBossIgnore = false
local ShalowainXYZSetup = false

local attackDistanceThreshold = 40

local attackAnnounce = nil
local initialTargetID = nil

-- Start Settings Block for EQBC or Dannet --
local config_path = ''

local function Log(output, ...)
    printf('[\agHeroes Are Forged\aw] '..output, ...)
end

local function file_exists(name)
	local f = io.open(name, "r")
	if f ~= nil then io.close(f) return true else return false end
end

local function load_settings()
    local config_dir = mq.configDir:gsub('\\', '/') .. '/'
    local config_file = string.format('mission_HAFMission_%s.ini', mq.TLO.Me.CleanName())
    config_path = config_dir .. config_file
    if (file_exists(config_path) == false) then
        lip.save(config_path, settings)
    else
        settings = lip.load(config_path)
        -- Check if OpenChest setting exists, if not, add it with default value
        if settings.general and settings.general.OpenChest == nil then
            settings.general.OpenChest = "false"
            lip.save(config_path, settings)  -- Save the updated settings back to the file
        end
    end
end

 load_settings()

 if (settings.general.GroupMessage == 'dannet') then
    Log('\aw Group Chat: \ayDanNet\aw.')
 elseif (settings.general.GroupMessage == 'bc') then
    Log('\aw Group Chat: \ayBC\aw.')
 else
    Log("Unknown or invalid group command.  Must be either 'dannet' or 'bc'. Ending macro. \ar%s", settings.general.GroupMessage)
    os.exit()
 end

-- End of Settings Block for EQBC or Dannet --

local task = mq.TLO.Task('Heros Are Forged')

local function Credits()
    printf('\agStarting\ax \atHeroes Are Forged Mission lua\ax \aoV1.7.0\ax')
    printf('\aySpecial Thanks to the following for helping in the creation of this lua:\ax')
    printf('\ataquietone, brainiac, kaen01, GoldenFrog, and Coldblooded\ax')
    mq.delay('3s')
end

-- Start of EQBC and Dannet Control Commands --
local function send_message(do_noparse, scope, command, ...)
    local full_command = string.format(command, ...)
    local noparse = ''
    if (do_noparse) then noparse = '/noparse ' end
    local preslash = ''
    if (settings.general.GroupMessage == 'bc') then preslash = '/' end

    full_command = string.format('%s/%s %s%s', noparse, scope, preslash, full_command)
    mq.cmd(full_command)
    -- printf('%s', full_command)
end

-- "/bcga /{command}" or "/dgga /{command}"
local function send_group_message_bcga(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(false, 'dgga', command, ...)
    else
        send_message(false, 'bcga', command, ...)
    end
end

-- "/noparse /bcga /{command}" or "/noparse /dgga /{command}"
local function send_group_message_bcga_noparse(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(true, 'dgga', command, ...)
    else
        send_message(true, 'bcga', command, ...)
    end
end

-- "/bcg /{command}" or "/dgg /{command}"
local function send_others_message_bcg(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(false, 'dgge', command, ...)
    else
        send_message(false, 'bcg', command, ...)
    end
end

-- "/noparse /bcg /{command}" or "/noparse /dgg /{command}"
local function send_others_message_bcg_noparse(command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(true, 'dgge', command, ...)
    else
        send_message(true, 'bcg', command, ...)
    end
end
-- "/bct /{command}" or "/dgt /{command}" 
local function send_individual_message_bct(name, command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(false, 'dgt', command, ...)
    else
        send_message(false, 'bct', command, ...)
    end
end
-- "/noparse /bct /{command}" or "/noparse /dgt /{command}" 
local function send_individual_message_bct_noparse(name, command, ...)
    if (settings.general.GroupMessage == 'dannet') then
        send_message(true, 'dgt', command, ...)
    else
        send_message(true, 'bct', command, ...)
    end
end
-- End of EQBC and Dannet Control Commands --

------------------------------
--- Attack Functions Start ---
------------------------------
local function MoveTo(spawn)
    if (mq.TLO.SpawnCount(spawn)() <= 0) then return false end
    if (mq.TLO.Spawn(spawn).Distance() < 5) then return true end
    mq.cmdf('/squelch /nav spawn "%s" npc', spawn)
    while mq.TLO.Nav.Active() do mq.delay(1) end
        mq.delay(500)
    return true
end

local function IsWithinAttackDistance(targetName)
    local target = mq.TLO.Spawn(targetName)
    if target and target.Distance() then
        return target.Distance() < attackDistanceThreshold
    end
    return false
end

local function MoveToAndAttack(targetName)
    local target = mq.TLO.NearestSpawn('npc ' .. targetName)
    if not target() then return false end

    if not IsWithinAttackDistance(targetName) then
        MoveTo(targetName)
    end

    if initialTargetID and initialTargetID ~= mq.TLO.Target.ID() then
        initialTargetID = target.ID()  -- Update the attackAnnounce with the new target ID
        send_group_message_bcga('/squelch /target id %d', target.ID())
        mq.delay(50)
        mq.cmdf('/cwtna resetcamp')
        mq.delay(50)
        send_group_message_bcga('/attack on')
        send_group_message_bcga('/pet swarm')
        send_group_message_bcga('/pet attack')
        mq.delay(50)
    end

    return true
end

local function KillTarget(targetName, priorityTarget)
    local target = mq.TLO.NearestSpawn('npc ' .. targetName)
    if not target() then return end

    -- Initial handling of priority target
    if priorityTarget and mq.TLO.SpawnCount('npc ' .. priorityTarget)() >= 1 then
        targetName = priorityTarget  -- Switch to priority target
        target = mq.TLO.NearestSpawn('npc ' .. targetName)
        printf('\ayPriority target\ax \ar%s\ax \aydetected,\ax \agswitching target.\ax', priorityTarget)
        initialTargetID = target.ID()  -- Update initial target ID
        MoveToAndAttack(targetName)  -- Move to and attack the priority target
    else
        initialTargetID = target.ID()  -- Set initial target ID for the original target
        MoveToAndAttack(targetName)  -- Move to and attack the original target
    end

    -- Main combat loop
    while true do
        -- Check for Egg spawn scenario
        if mq.TLO.SpawnCount('npc Egg')() > 0 then
            initialTargetID = nil  -- Reset initial target ID
            return -- Return to handle eggs in the main loop
        end

        -- Continuous check for priority target appearance
        if priorityTarget and mq.TLO.SpawnCount('npc ' .. priorityTarget)() >= 1 and initialTargetID ~= mq.TLO.Spawn(priorityTarget).ID() then
            printf('\ayPriority target\ax \ar%s\ax \aydetected,\ax \agswitching target.\ax', priorityTarget)
            MoveToAndAttack(priorityTarget)  -- Move to and attack the priority target
            initialTargetID = mq.TLO.Spawn(priorityTarget).ID()  -- Update initial target ID
        end

        -- Check if the current target is the original targetName
        if mq.TLO.Target.ID() == initialTargetID then
            printf('\ayTarget:\ax \ar%s\ax \ayis up,\ax \agkill it\ax', targetName)
            break  -- Exit the loop since the original target is now the current target
        end

        mq.delay(500)
    end

    -- Handle engagement with the original targetName
    while initialTargetID == mq.TLO.Target.ID() and mq.TLO.Target.Type() ~= "Corpse" do
        mq.delay(500)  -- Adjust delay as needed for continuous combat
    end

    initialTargetID = nil  -- Reset initial target ID
end

------------------------------
---- Attack Functions End ----
------------------------------

local function StartupSettings()
    printf('\ayExecuting Startup Settings\ax')
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} pause 0')
    mq.delay(50)
    mq.cmdf('/%s mode 0', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    send_others_message_bcg('/makeleader %s', mq.TLO.Me.CleanName()) 
    mq.delay('2s')
    mq.cmdf('/grouproles set %s 1', mq.TLO.Me.CleanName())
    mq.delay('1s')
    mq.cmdf('/grouproles set %s 1', mq.TLO.Me.CleanName())
    mq.delay('1s')
    mq.cmdf('/grouproles set %s 1', mq.TLO.Me.CleanName())
    mq.delay('1s')
    send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} mode 2')
    mq.delay(50)
    mq.cmdf('/%s mode 0', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
end

local function WaitWhileCondition(conditionFunc, delayTime, timeout)
    local startTime = os.time()
    while conditionFunc() do
        mq.delay(delayTime)
        if os.time() - startTime > timeout then
            return false
        end
    end
    return true
end

local function TravelToRequestZone()
    if mq.TLO.Zone.ShortName() ~= quest_request_zone then
        send_group_message_bcga('/travelto %s', quest_request_zone)
        if not WaitWhileCondition(function() return mq.TLO.Navigation.Active() end, 50, 60) then
            printf('\ayFailed to navigate to the quest request zone.\ax')
            return
        end
        if not WaitWhileCondition(function() return mq.TLO.Zone.ShortName() ~= quest_request_zone end, 500, 60) then
            printf('\ayFailed to zone into the quest request zone.\ax')
            return
        end
    end
    if mq.TLO.Group.AnyoneMissing() then
        printf('\ayWe are missing people,\ax \agstandby\ax')
        WaitWhileCondition(function() return mq.TLO.Group.AnyoneMissing() end, 50, 300)
    end
end

local function GetTask()
    if mq.TLO.Zone.ShortName() ~= quest_request_zone then
        printf('\ayI am not in the correct zone,\ax \agTraveling to\ax \ar%s\ax', quest_request_zone)
        TravelToRequestZone()
    elseif mq.TLO.Zone.ShortName() == quest_request_zone then
        local spawn = mq.TLO.Spawn(quest_request_npc)
        if spawn and spawn.Distance() and spawn.Distance() > 30 then
            printf('\ayEveryone in zone,\ax \agmoving to\ax \ar%s\ax', quest_request_npc)
            send_group_message_bcga('/alt act 1202')
            send_group_message_bcga('/squelch /nav id ${Spawn[%s].ID}', quest_request_npc)
            mq.delay('2s')
            while mq.TLO.Navigation.Active() do
                mq.delay('2s')
            end
        end
    end

    if mq.TLO.Spawn(quest_request_npc).Distance() < 35 then
        mq.cmdf('/%s pause 1', mq.TLO.Me.Class.ShortName())
        mq.delay(50)
        while mq.TLO.Target.ID() ~= mq.TLO.Spawn(quest_request_npc).ID() do
            mq.cmdf('/target %s', quest_request_npc)
            mq.delay(50)
        end
        mq.cmdf('/say %s', quest_request_phrase)
        mq.delay(300)
        mq.cmdf('/notify TaskSelectWnd AcceptButton leftmouseup')
        while mq.TLO.Task('Heroes Are Forged')() == nil do mq.delay(50) end
        while mq.TLO.DynamicZone.LeaderFlagged() do mq.delay(50) end
        if mq.TLO.Task('Heroes Are Forged').WindowIndex() ~= nil then
            printf('\ayGot Mission\ax')
        end
    end
end

local function ZoneIn()
    printf('\ayTraveling to Instance Shortly\ax')
    mq.delay('20s')
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} pause 1')
    mq.delay('5s')
    send_group_message_bcga('/travelto %s', main_zone)
    while mq.TLO.Zone.ShortName() ~= quest_zone do
        mq.delay('15s')
    end
    while mq.TLO.Group.AnyoneMissing() do
        mq.delay(300)
    end
    printf('\ayWe are all inside!\ax')
end

local function TaskSettings()
    printf('\ayStart Task Settings\ax')
    -- setting up ignores for puller mode
    mq.cmdf('/%s ignore Shalowain', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s ignore a depleted forgebound', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s ignore a reborn warrior', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s ignore a reborn wizard', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s ignore Elmara Emberclaw', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s ignore egg sacs', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s ignore Lich\'s Power', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "%s"', mq.TLO.Me.Class.ShortName(), SpiderBoss)
    mq.delay(50)

    -- CWTN Plugin Settings
    mq.cmdf('/%s pullradius 350 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s zhigh 250 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s zlow 250 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s pullarc 360 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s campradius 20 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s burncount 2 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} assistat 100 nosave')
    mq.delay(50)
    send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} campradius 45 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} burnalways 0 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} burnallnamed 0 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} groupshrink 0 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} usegroupshrink 0 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} switchwithma 1 nosave')
    mq.delay(50)
    send_group_message_bcga('/lua run lem')
    mq.delay(50)
    printf('\agTask Settings Complete\ax')
    mq.delay('3s')
end

local function TaskSettingsEnd()
    printf('\ayReverting some CWTN Plugin Settings\ax')
    -- Removing ignores we setup before
    mq.cmdf('/%s unignore Shalowain', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "a depleted forgebound"', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "a reborn warrior"', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "a reborn wizard"', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "Elmara Emberclaw"', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "egg sacs"', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s unignore "Lich\'s Power"', mq.TLO.Me.Class.ShortName())
    mq.delay(50)

    -- Ending CWTN Plugin Settings
    mq.cmdf('/%s pullradius 500 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s zhigh 250 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s zlow 250 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s campradius 35 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s burncount 4 nosave', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} assistat 99 nosave')
    mq.delay(50)
    send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} campradius 60 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} burnalways 0 nosave')
    mq.delay(50)
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} burnallnamed 0 nosave')
    mq.delay(50)
    printf('\agTask Settings Complete\ax')
    mq.delay('3s')
end

local function TaskSetupForSlime()
    printf('\ayMoving group into position and starting event on tank.\ax')
    send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} pause 0')
    send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} mode 0')
    mq.delay(50)
    send_group_message_bcga('/alt act 1202')
    send_others_message_bcg('/squelch /nav locxyz  %d %d %d', CampX, CampY, CampZ)
    mq.delay('1s')
    mq.cmdf('/squelch /squelch /nav locxyz -1278 532 324')
    mq.delay('15s')
    send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} mode 1')
    mq.delay(50)
    while mq.TLO.Target.ID() ~= mq.TLO.Spawn(quest_start_npc).ID() do
        mq.cmdf('/target %s', quest_start_npc)
        mq.delay(150)
    end
    mq.cmdf('/say defy her')
    printf('\arStarting Event\ax')
    mq.cmdf('/squelch /nav locxyz %d %d %d', CampX, CampY, CampZ)
    while mq.TLO.Navigation.Active() do
        mq.delay('1s')
    end
    if (mq.TLO.Cursor.ID()) then
        mq.cmd('/autoinventory')
        mq.delay(2)
        mq.cmd('/autoinventory')
    end
    mq.cmdf('/%s pause 0', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    mq.cmdf('/%s mode 7', mq.TLO.Me.Class.ShortName())
    mq.delay(50)
    send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} mode 2')
    mq.delay(50)
    mq.cmd('/squelch /target clear')
    mq.delay(50)
    MoveToAndAttack(SlimeBoss)
    mq.delay(50)
    send_others_message_bcg('/squelch /target %s', SlimeBoss)
    mq.delay(100)
    send_others_message_bcg('/attack on')
    mq.delay(50)
end

function CheckGroupProximity(x, y, z)
    for i = 1, mq.TLO.Group.GroupSize() do
        local member = mq.TLO.Group.Member(i)
        if member() then
            local memberX, memberY, memberZ = member.X(), member.Y(), member.Z()
            local distance = mq.TLO.Math.Distance(string.format("%d %d %d : %d %d %d", CampX, CampY, CampZ, memberX, memberY, memberZ))()
            if distance > 50 then
                return false  -- At least one group member is outside the radius
            end
        end
    end
    return true  -- All group members are within the radius
end

local function ReturnPetsToOwner()
    local radius = tonumber(Radius)
    if not mq.TLO.Me.Combat() or (mq.TLO.Me.Combat() and mq.TLO.Target.Distance() > radius) then
        for i = 1, 3 do
            send_group_message_bcga('/pet back')
            mq.delay(500)
        end
    end
end

function InitializeGroupMembersPetOwnerIds()
    groupMembersPetOwnerIds = {}
    for i = 1, mq.TLO.Group.GroupSize() do
        local member = mq.TLO.Group.Member(i)
        if member.Pet.ID() ~= nil then
            table.insert(groupMembersPetOwnerIds, member.ID())
        end
    end
end

function CheckPetsProximityToOwner()
    -- Ensure groupMembersPetOwnerIds is initialized
    InitializeGroupMembersPetOwnerIds()

    local radius = tonumber(Radius)
    for _, petOwnerId in ipairs(groupMembersPetOwnerIds) do
        local pet = mq.TLO.Spawn('id ' .. petOwnerId).Pet
        if pet() then
            local petDistance = pet.Distance()
            if petDistance and petDistance > radius and not mq.TLO.Me.Combat() then
                return false  -- At least one pet is outside the radius
            end
        end
    end
    return true  -- All pets are within the radius or the main tank is in combat
end

------------------------------
------- Egg Camps Math -------
------------------------------
-- Function to calculate distance between two points
local function calculateDistance(x1, y1, z1, x2, y2, z2)
    return math.sqrt((x2 - x1)^2 + (y2 - y1)^2 + (z2 - z1)^2)
end

-- Function to move the group to the closest egg camp
local function moveToClosestEggCamp()
    local egg = mq.TLO.Spawn(Eggs)
    if not egg then
        print("Egg not found.")
        return
    end

    local eggX, eggY, eggZ = egg.X(), egg.Y(), egg.Z()
    local distanceToNorthCamp = calculateDistance(eggX, eggY, eggZ, NorthEggCampX, NorthEggCampY, NorthEggCampZ)
    local distanceToSouthCamp = calculateDistance(eggX, eggY, eggZ, SouthEggCampX, SouthEggCampY, SouthEggCampZ)

    if distanceToNorthCamp < distanceToSouthCamp then
        print("Moving to North Egg Camp.")
        send_group_message_bcga('/squelch /nav locxyz %s %s %s', NorthEggCampX, NorthEggCampY, NorthEggCampZ)
        while mq.TLO.Navigation.Active() do
            mq.delay(50)
        end
    else
        print("Moving to South Egg Camp.")
        send_group_message_bcga('/squelch /nav locxyz %s %s %s', SouthEggCampX, SouthEggCampY, SouthEggCampZ)
        while mq.TLO.Navigation.Active() do
            mq.delay(50)
        end
    end
end

------------------------------
--------- HandleEggs ---------
------------------------------
local function HandleEggs()
    local radius = tonumber(Radius)
    local navigationInitiated = false
    local modeChangedToZero = false
    local eggCampRun = false

    -- Check and handle SpiderBoss ignore at the start
    if not SpiderBossIgnore then
        printf('\ayEggs are up,\ax \arignoring SpiderBoss\ax \ayfor now.\ax')
        mq.cmdf('/%s ignore %s', mq.TLO.Me.Class.ShortName(), SpiderBoss)
        mq.delay(50)
        SpiderBossIgnore = true
    end

    while mq.TLO.SpawnCount(string.format("npc %s", Eggs))() >= 1 and sendPetsOnEggs do
        if mq.TLO.SpawnCount(string.format("npc %s", SpiderAdd))() >= 1 then
            -- Handle SpiderAdd...
            KillTarget(SpiderAdd)
        else
            -- No SpiderAdd and sendPetsOnEggs mode is on
            mq.cmdf('/%s mode 0', mq.TLO.Me.Class.ShortName()) -- Tank to Manuel Mode
            mq.delay(50)
            send_others_message_bcg_noparse('/docommand /${Me.Class.ShortName} mode 2') -- Group to Chase Mode
            moveToClosestEggCamp() -- Find clossest Egg Camp (North or South)
            while mq.TLO.SpawnCount(string.format("npc %s", Eggs))() >= 1 do
                send_group_message_bcga('/target egg sacs')
                mq.delay(250)
                send_group_message_bcga('/pet swarm')
                mq.delay(50)
                send_group_message_bcga('/pet attack')
                mq.delay(50)
            end
        end
        mq.cmdf('/%s mode 7', mq.TLO.Me.Class.ShortName())
        mq.delay(100)
    end

    while mq.TLO.SpawnCount(string.format("npc %s", Eggs))() >= 1 and not sendPetsOnEggs do
        if mq.TLO.SpawnCount(string.format("npc %s", SpiderAdd))() >= 1 then
            -- Handle SpiderAdd...
            KillTarget(SpiderAdd)
        else
            if not CheckGroupProximity(CampX, CampY, CampZ) then
                if not modeChangedToZero then
                    mq.cmdf('/%s mode 0', mq.TLO.Me.Class.ShortName())
                    mq.cmd('/squelch /target clear')
                    modeChangedToZero = true  -- Set flag to avoid repeated mode changes
                end

                if not navigationInitiated then
                    mq.cmd('/squelch /target clear')
                    send_group_message_bcga('/squelch /nav locxyz %d %d %d', CampX, CampY, CampZ)
                    navigationInitiated = true  -- Set flag to avoid repeated navigation commands
                end

                if not mq.TLO.Navigation.Active() then
                    -- Reset flags once navigation is complete
                    modeChangedToZero = false
                    navigationInitiated = false
                    mq.cmdf('/%s mode 7', mq.TLO.Me.Class.ShortName())
                end
            end

            if not CheckPetsProximityToOwner() then
                ReturnPetsToOwner()
            end
        end
        mq.delay(100)  -- Adjust the delay as needed
    end

    -- Handle SpiderBoss unignore at the end
    if SpiderBossIgnore then
        printf('\ayEggs are gone,\ax \agunignoring SpiderBoss & Puller Tank back on.\ax')
        mq.cmdf('/%s unignore "%s"', mq.TLO.Me.Class.ShortName(), SpiderBoss)
        SpiderBossIgnore = false
    end
end


local function LichSetup()
    while (mq.TLO.SpawnCount(string.format("npc %s", Lich))() >= 1 or mq.TLO.SpawnCount(string.format("npc %s", Mummy))() >= 1) do

        if LichSetupComplete == false then
            printf('entering LichSetupComplete', ChestName)
            mq.delay(50)
            send_group_message_bcga_noparse('/docommand /${Me.Class.ShortName} burnalways 1 nosave')
            mq.delay(50)
            mq.cmdf('/%s mode 8', mq.TLO.Me.Class.ShortName())
            mq.delay(50)
            LichSetupComplete = true
        end

        if mq.TLO.SpawnCount(string.format("npc %s", Lich))() >= 1 or mq.TLO.SpawnCount(string.format("npc %s", Mummy))() >= 1 then
            while mq.TLO.SpawnCount(string.format("npc %s", Mummy))() == 0 and mq.TLO.SpawnCount(string.format("npc %s", Lich))() >= 1 do
                if mq.TLO.CWTN.Mode() ~= 'HunterTank' then
                    mq.cmdf('/%s mode 8', mq.TLO.Me.Class.ShortName())
                    mq.delay(50)
                end
                if mq.TLO.Target.CleanName() == Lich and mq.TLO.Spawn(Lich).Distance() > 15 then
                    if not mq.TLO.Navigation.Active() then
                        mq.cmdf('/nav target %s', Lich)
                    end

                    while mq.TLO.Navigation.Active() do
                        mq.delay(1)
                    end
                    send_group_message_bcga('/attack on')
                end
            end
            if mq.TLO.SpawnCount(string.format("npc %s", Mummy))() >= 1 then
                KillTarget(Lich, Mummy)
            end
        end

        -- Check if both Lich and Mummy are defeated
        if mq.TLO.SpawnCount(string.format("npc %s", Lich))() == 0 and mq.TLO.SpawnCount(string.format("npc %s", Mummy))() == 0 then
            break  -- Exit the loop if both are defeated
        end

        mq.delay(100)  -- Adjust delay as needed
    end

    LichSetupComplete = false  -- Reset flag after completion
end


local function ShalowainSetup()
    while (mq.TLO.Me.XTarget(1).Name() == Shalowain or mq.TLO.Me.XTarget(2).Name() == Shalowain) or (mq.TLO.SpawnCount(string.format("corpse %s", Lich))() >= 1 and mq.TLO.SpawnCount(string.format("npc %s", Shalowain))() >= 1) do
        if not ShalowainXYZSetup then
            mq.cmdf('/%s unignore "%s"', mq.TLO.Me.Class.ShortName(), Shalowain)
            mq.delay(50)
            ShalowainXYZSetup = true
        end
        KillTarget(Shalowain, Mummy)  -- Assume Mummy as priority if present
    end
end

local function SetModeManualAndOpenChest()
    -- Set mode to manual
    mq.cmdf('/%s mode 0', mq.TLO.Me.Class.ShortName())

    -- Wait for the chest to spawn, with a timeout
    local timeout = 30  -- Timeout in seconds
    local startTime = os.time()
    while (os.time() - startTime) < timeout do
        if mq.TLO.SpawnCount(string.format("object %s", ChestName))() >= 1 then
            break
        end
        mq.delay(1000)  -- Check every second
    end

    if mq.TLO.SpawnCount(string.format("object %s", ChestName))() < 1 then
        printf('\ayChest %s did not spawn within the timeout period.\ax', ChestName)
        return
    end

    -- Get the chest's location
    local chest = mq.TLO.Spawn(string.format("object %s", ChestName))
    if chest() then
        -- Nav to chest
        mq.cmdf('/squelch /nav spawn %s object', ChestName)
        while mq.TLO.Navigation.Active() do
            mq.delay(50)
        end

        -- Once near the chest, target it
        while mq.TLO.Target() ~= ChestName do
            mq.cmdf('/squelch /target %s', ChestName)
            mq.delay(100)  -- Delay to ensure targeting
        end

        -- Open the chest
        mq.cmd('/open')
        mq.delay(500)  -- Delay to allow for the open command to process
    else
        printf('\ayUnable to locate the chest: %s\ax', ChestName)
    end
end


--- Main Loop Start
Credits()
StartupSettings()
mq.delay(100)
while not mq.TLO.Task('Heroes Are Forged').Select() do
    GetTask()
    mq.delay(100)
end
while mq.TLO.Task('Heroes Are Forged').Select() and mq.TLO.Zone.ShortName() ~= quest_zone do
    ZoneIn()
    mq.delay(100)
end
TaskSettings()
TaskSetupForSlime()
while true do
    if mq.TLO.SpawnCount(string.format("npc %s", Eggs))() >= 1 then
        HandleEggs()
        mq.delay(50)
    elseif mq.TLO.SpawnCount(string.format("object %s", ChestName))() >= 1 then
        if OpenChest then
            SetModeManualAndOpenChest()
            mq.delay('10s')
        else
            print('\ayOpen chest is turned OFF\ax')
            mq.cmdf('/%s mode 0', mq.TLO.Me.Class.ShortName())
        end
        TaskSettingsEnd()
        printf('\ayHeroes Are Forged Mission lua\ax - \agCompleted\ax\ay, stopping Lua.\ax')
        mq.cmdf('/lua stop hafmission')
    elseif mq.TLO.SpawnCount(string.format("npc %s", Shalowain))() >= 1 then
        KillTarget(SlimeBoss, SlimeAdd)
        mq.delay(50)
        KillTarget(SpiderBoss, SpiderAdd)
        mq.delay(50)
        LichSetup()
        mq.delay(50)
        ShalowainSetup()
        mq.delay(50)
    end
end
--- Main Loop End