local mq = require('mq')
local config = require('config')
local writeutil = {}
     

function writeutil.file_exists(path)
  local f = io.open(path)
  if f == nil then return end
  f:close()
  return path
end





function writeutil.read_config(filename)

  filename = filename or ''
  assert(type(filename) == 'string')
  local ans,u,k,v,temp = {}
  if not writeutil.file_exists(filename) then return ans end
  for line in io.lines(filename) do

    temp = line:match('^%[(.+)%]$')
    if temp ~= nil and u ~= temp then u = temp end
    k,v = line:match('^([^=]+)=(.+)$')
    if u ~= nil then
      ans[u] = ans[u] or {}
      if k ~= nil then
        ans[u][k] = v
      end
    end
  end
  return ans
end




function writeutil.write_config(filename,section,key,value)


  filename = filename or ''
  assert(type(filename) == 'string')
  if section == nil and key == nil and value == nil then return end
  local t = writeutil.read_config(filename)       

  if section ~= nil and value == nil then

    if key == nil then
      t[section] = nil                  
    else
      t[section][key] = nil             
    end
    goto WriteFile
  end

  if key:match '=' then
    error('An equals sign is not expected inside key')
  end

  t[section] = t[section] or {}        
  t[section][key] = value               

::WriteFile::                           

  for k,v in pairs(t) do
  local fo = io.open(filename,'w')
    fo:write('['..k..']\n')
    for k,v in pairs(v) do
      fo:write(k..'='..v..'\n')


  fo:flush()
  fo:close()
config=require('config')
print(config.timer)
    end

  end


  return t                            
end


return writeutil


