# Version 9     6/22/2019  by Joojoobee
#!/usr/bin/perl -w
#use strict;
use File::Spec::Functions qw'catfile';
use File::Copy qw'move';
use autodie    qw'move';
use File::Stat qw/:stat/;
use File::Compare;


   my $proc_file = "";
   my $countindents = 1;      # default to at least one indent for whole file
   my $countEmptyRows = 0;    # counter to ensure only one empty row allowed.  If 2 or more, remove those lines
   my $subCommentCount = 0;   # check for a subroutine header
   my $oldSubCommentCount = 0;
   my $subroutineTag = 0;     # Was there a subroutine tag?
   my $subroutineName = "";   # name of the subroutine to place in a header
   my $useTabsOrSpaces = "\t";
   my $TabOrSpaceUse = " using tabs for indents";
   my $modtime8 = time();
   my $modtime9 = time();
   my $newmac= "";
   my $oldfile = "";

   my $msg = '';

   if (exists $ARGV[0] && $ARGV[0] eq "s") { $useTabsOrSpaces = "  "; $TabOrSpaceUse = " using spaces for indents"; }

   foreach $proc_file (<*.*>)
   {
       if (!($proc_file=~ m/.mac$|.inc$/)) { goto nextFile; }  # only read .mac or .int files
       #print "$proc_file\t\t ... Opened  \n";
       $oldfile = $proc_file;
       open(FILE, "$proc_file");
       $modtime8 = (stat($proc_file))[8];
       $modtime9 = (stat($proc_file))[9];

       $countindents = 0;                     # reset the indent count for each new file
       if ($proc_file=~ m/.mac/) {            # if it's a .mac file, rename output file to .fmac and open it for writing
         $proc_file =~ s/.mac//;              # get the base name of the file
         open (OUT22,">$proc_file".".fmac");  # create a temporary version for writing
         $newmac = "$proc_file".".fmac";
       }
       if ($proc_file=~ m/.inc/) {            # if it's a .inc file, rename output file to .finc and open it for writing
         $proc_file =~ s/.inc//;              # get the base name of the file
         open (OUT22,">$proc_file".".finc");  # create a temporary version for writing
         $newmac = "$proc_file".".finc";
       }

       while(my $row = <FILE> )               # get each line in file
       {
           my $addback = 0;                   # set | and : check to 0
           chomp $row;                        # clean up the last row, remove line feed/CR tags
           $row =~ s/^\s+|\s+$//g;            # remove leading and trailing tabs and spaces
           my $string="";                     # reset the indent string to blank for each line

           if ($countindents <0) {      $countindents = 0; }                # in case of weird over use of }
           if (($row=~ m/}$/) && index($row,"{") < 0) { $countindents--; }  # decrement the indent for end of bracket }
           if ($row=~ m/}\s*else/i) {       $countindents--; }                # decrement the indent for end of bracket } else (case insensitive)
           if ($row=~ m/^\/next\s*\S/i) {     $countindents--; }            # decrement the indent for a next statment
           if ($row=~ m/^\|/ || $row=~ m/^:/) {                             # decrement the indent for comments or : goto lines
               #$countindents--;
               #$addback = 1;                                               # set the addback flag to put indent back after | or :
           }

           if (($row=~ m/^\|\s*---/ || $row=~ m/^\|\s*=-=/ || $row=~ m/^\||\s*---/ || $row=~ m/^\||\s*=-=/) && ($subCommentCount == 0 || $subCommentCount == 2)) { $subCommentCount++; }  # start a simple count for subroutine header
           if (($row=~ m/^\|\s*sub/i || $row=~ m/^\|\s*===/  || $row=~ m/^\|:\s*sub/i || $row=~ m/^\|:\s*===/)&& $subCommentCount == 1)   { $subCommentCount++; }                         # found a reasonable tag for "| SUB".  Case insensitive and tolerant of variation
           if ($row=~ m/^sub\s\S/i && ($subCommentCount == 3 || $subCommentCount == 0)) {                                                                                                 # found a subroutine tag (looks for word "sub" a space/tab and at least a single non space/tab letter)
                  $subroutineTag++;
                  $subroutineName = $row;
                  $subroutineName =~ s/^sub\s//i;     # remove the sub keyword
                  $subroutineName =~ s/\(.*\)//i;     # remove any variable names and ()
           }

           if ($oldSubCommentCount !=0 && $oldSubCommentCount == $subCommentCount) {  # Check for Header should not allow for any interceding lines.
            $countLines++;
            if ($countLines == 2) {           # two lines went by without a Header key, this is not a header
                  $subCommentCount = 0;           # reset header check to 0
                  $oldSubCommentCount = 0;
                  $countLines = 0;
            }
           }

           $oldSubCommentCount = $subCommentCount;    # save subCommentCount for comparison to determine if proper structure.

           if ($row ne "") {                          # build the indents
            for my $i (0 .. $countindents) {
              $string = "$string"."$useTabsOrSpaces";   # by concatenating tabs or spaces
            }
           }

           if ($row eq "") {        # check for empty lines
            $countEmptyRows++;
           }

           if ($countEmptyRows == 2) {      # two empty lines in a row, skip printing it
            $countEmptyRows = 1;
            next;
           }

           if ($subroutineTag == 1) {     # a sub keyword was found
                if ($subCommentCount != 3) {    # if the lines immediately above did not already have a header, print a header
                    $subCommentCount = 0;       # reset the header check counters, print a header
                    $oldSubCommentCount = 0;
                    $countLines = 0;
                    if ($countEmptyRows > 0) { print OUT22 "\n";  }

                    print OUT22 "|: --------------------------------------------------------------------------------------------\n";
                    print OUT22 "|: SUB: $subroutineName\n";
                    print OUT22 "|: --------------------------------------------------------------------------------------------\n";
                }
                if ($subroutineTag == 1 && $subCommentCount > 0) {   #incomplete header check, so zero the header check
                    $subCommentCount = 0;
                    $oldSubCommentCount = 0;
                    $countLines = 0;
                }

              $subroutineTag = 0;       # finished with header, reset subroutine line check
            }

           if ($subCommentCount > 3) {        # invalid header structure, so zero the header check
            $subCommentCount = 0;
            $oldSubCommentCount = 0;
            $countLines = 0;
           }

          # if ($row =~ m/\+\+\+  FormattedMQ2f/i) { next; }  # dom't rewrite the end line.

           if ($countEmptyRows <= 1) {                  # allow printing if as many as 1 empty line above
               print OUT22 "$string"."$row\n";          # print the line
               if ($row ne "") {$countEmptyRows = 0;}   # was a single empty line prior, reset counter of empty lines to 0
           }

           if ($addback == 1)     { $countindents++; }        # add back the line if de-indented for | or :
           if($row=~ m/{$/)       { $countindents++; }        # increment the indent if an open bracket { at the end of the line
           if($row=~ m/^\/for\s+\S/i )  { $countindents++; }  # increment the indent if a /for statement
           if($row=~ m/^\/squelch\s*\/for\s*\S/i )  { $countindents++; }  # increment the indent if a /squelch /for statement
        }

       close FILE;  # close input file

       if ($countEmptyRows > 0) { print OUT22 "\n";  }
      # print OUT22 "\n\n" ;
       close OUT22; # close output file

       utime $modtime8, $modtime9, $newmac;
      
       my $directory = "Processed";         # If Processed subdirectory does not exist, create one
       unless(-e $directory or mkdir $directory) {
         die "Unable to create $directory, potential permission or space limitations\n";
       }
     
        if (compare($oldfile,$newmac) != 0) {
            print "reformatted ==> $oldfile\n";
           
            my $origin      = '.';
            my $destination = 'Processed';
            my $path = catfile $destination, $oldfile;
            my $counter = 0;

              while( -e $path ){
                $counter++;
                $path = catfile $destination, "$oldfile.$counter";
              }
             
              move( catfile( $origin, $oldfile ), $path );
             
              my $modtime8 = (stat($newmac))[8];
              my $modtime9 = (stat($newmac))[9];

              my $newname = $newmac;
              if ($oldfile=~ m/.mac/) {
                $newname =~ s{.fmac}{.mac}gxms;
              }
              if ($oldfile=~ m/.inc/) {
                $newname =~ s{.finc}{.inc}gxms;
              }
             
              rename $newmac, $newname;
              utime $modtime8, $modtime9, $newmac;
       
        } else {
          unlink $newmac;
        } 
       
       nextFile:
   }

   print "Exiting \n";
   my $exit = 0;