-- XGen Bridge
-- Written by Aipoc76 for Red Guides.
-- To be used with XGen Macro collection.

-- special thanks to exspes007, knightly, aquietone, brainiac, and a slew of others for all your assistance while i fumbled around with lua.
-- It is greatly appreaciated!

---@diagnostic disable: redefined-local
---@diagnostic disable-next-line: lowercase-global
mq = require('mq')
local openGUI = true
local shouldDrawHUD = true

-- Local Variables for Text Boxes.
local data = ''
local data2 = ''
local zonedataquery = mq.TLO.sqlite('query', mq.TLO.Macro.Variable('xgv_XGenDB'), 'zonequery', 'SELECT', '*', 'FROM',
    'Zones')

local function imguicallback()

    -- start of window draw above..
    openGUI, shouldDrawHUD = ImGui.Begin('XGen Bridge', openGUI)
    ImGui.SetWindowSize(410, 250, ImGuiCond.Appearing)
    ImGui.PushStyleVar(ImGuiStyleVar.ScrollbarSize, 17)

    local id = 'id ' .. mq.TLO.Target.ID()
    local exists = mq.TLO.Navigation.PathExists(id)()

    ImGui.BeginTabBar('XGEN', ImGuiTabBarFlags.Reorderable)

    WindowW = ImGui.GetWindowSize()
    WindowH = ImGui.GetWindowHeight()
    --print(WindowW ..'X ', WindowH)

    if ImGui.BeginTabItem('Main') then
        ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)
        ImGui.TextColored(0.39, 0.58, 0.92, 1, 'Target:')
        ImGui.SameLine()
        ImGui.TextColored(1, 1, 0.1, 1, mq.TLO.Target.CleanName())
        ImGui.SameLine()
        ImGui.TextColored(1, 1, 1, 1, 'LOS:')
        ImGui.SameLine()
        local checked = (mq.TLO.Target.LineOfSight())
        if checked then ImGui.TextColored(0, 1, 0, 1, 'T') else ImGui.TextColored(1, 0, 0, 1, 'F') end
        ImGui.SameLine()
        ImGui.TextColored(1, 1, 1, 1, 'X-Status:')
        ImGui.SameLine()

        local StartXGen = 'OFF'
        local colorStyleCount = 0

        if mq.TLO.Macro() then -- this is nested like this to avoid crashing ImGui when mac ends.
            if string.find(mq.TLO.Macro.Name(), 'xgen.mac') then -- this is nested like this to avoid crashing ImGui when mac ends.
                if mq.TLO.Macro.Variable('XgenStarted')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.5, .5, 0.0, 1)
                    StartXGen = 'Starting'
                    colorStyleCount = colorStyleCount + 1
                elseif mq.TLO.Macro.Variable('XgenStarted')() == 2 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                    StartXGen = ' UP '
                    colorStyleCount = colorStyleCount + 1
                end
            end
        end


        ---@diagnostic disable-next-line: undefined-global
        if ImGui.SmallButton(StartXGen) then mq.cmdf('/macro xgen\\xgen') end
        ---@diagnostic disable-next-line: undefined-global
        ImGui.PopStyleColor(colorStyleCount)


        ImGui.SameLine()
        local EndMac = 'END##startbarend1'
        if ImGui.SmallButton(EndMac) then mq.cmdf('/end') end
        ImGui.SameLine()
        local MQPause = 'MQP##startbarmqp1'
        if mq.TLO.Macro.Paused() then MQPause = 'Paused##startbarpaused1' end
        if ImGui.SmallButton(MQPause) then mq.cmdf('/mqp') end
        ImGui.Separator()
        ImGui.Separator()



        -- Start of XGEN Tabs and buttons.
        if mq.TLO.Macro() then -- intentional to try and avoid ImGui Crash when mac shuting down.
            if string.find(mq.TLO.Macro.Name(), 'xgen.mac') and mq.TLO.Macro.Variable('XgenStarted')() == 2 then -- intentional to try and avoid ImGui Crash when mac shuting down.


                -- New Row ================================================
                local SitLabel = 'AutoSit OFF##startbarsitoff1'
                if mq.TLO.Macro.Variable('xgv_Sit1')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_Sit1')() == 1 then SitLabel = 'AutoSit ON##startbarsiton1' end
                if ImGui.SmallButton(SitLabel) then mq.cmd('/cc autosit') end
                if mq.TLO.Macro.Variable('xgv_Sit1')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local CampLabel = 'Camp OFF##startbarcampoff1'
                if mq.TLO.Macro.Variable('xgv_ToggleCamp1')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_ToggleCamp1')() == 1 then CampLabel = 'Camp ON##startbarcampon1' end
                if ImGui.SmallButton(CampLabel) then mq.cmd('/cc camp') end
                if mq.TLO.Macro.Variable('xgv_ToggleCamp1')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local MoveLabel = 'Move OFF##startbarmoveoff1'
                if mq.TLO.Macro.Variable('xgv_ToggleMove1')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_ToggleMove1')() == 1 then MoveLabel = 'Move ON##startbarmoveon1' end
                if ImGui.SmallButton(MoveLabel) then
                    mq.cmd('/cc move')
                    mq.cmd('/varset xgv_ModeRanged 0')
                end
                if mq.TLO.Macro.Variable('xgv_ToggleMove1')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local BehindLabel = 'Behind OFF##startbarbehindoff1'
                if mq.TLO.Macro.Variable('xgv_ToggleGetBehind')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_ToggleGetBehind')() == 1 then BehindLabel = 'Behind ON##startbarbehindon1' end
                if ImGui.SmallButton(BehindLabel) then mq.cmd('/cc behind') end
                if mq.TLO.Macro.Variable('xgv_ToggleGetBehind')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local MakeCamp = 'MakeCamp##startbarcamp1'
                if ImGui.SmallButton(MakeCamp) then mq.cmdf('/cc makecamp') end

                --ImGui.EndGroup(toprow)
                -- checking for xgen specifically

                ImGui.Separator()
                -- PULLER CHECKBOX
                local chkbxname = 'Puller' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('Pulling1')() == 1 -- EDIT NAME IN ''
                local cmdname = 'pullmode' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                ImGui.SameLine()
                local chkbxname = 'Hunter' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleHunter1')() == 1 -- EDIT NAME IN ''
                local cmdname = 'hunter' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                ImGui.SameLine()
                local chkbxname = 'Pull Move' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_TogglePullMove')() == 1 -- EDIT NAME IN ''
                local cmdname = 'pmove' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                ImGui.SameLine()
                local chkbxname = 'Pull Nuke' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_TogglePullNukes')() == 1 -- EDIT NAME IN ''
                local cmdname = 'pnuke' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                ImGui.SameLine()
                local chkbxname = 'Dicho' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_dicho')() == 1 -- EDIT NAME IN ''
                local cmdname = 'dicho' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                -- New Row ================================================
                -- manawatch SLIDER
                if mq.TLO.Macro() then
                    if string.find(mq.TLO.Macro.Name(), 'xgen.mac') and mq.TLO.Macro.Variable('XgenStarted')() == 2 then
                        local mwhud = mq.TLO.Macro.Variable('xgv_ToggleManaWatchHud')()
                        local m1 = mq.TLO.Macro.Variable('xgv_ToggleManaWatch')()
                        local mwslider = ImGui.SliderInt('ManaWatch ' .. mwhud, m1, 0, 3)
                        if mwslider == 0 then mq.cmd('/varset xgv_ToggleManaWatchHud OFF') end
                        if mwslider == 1 then mq.cmd('/varset xgv_ToggleManaWatchHud Healers') end
                        if mwslider == 2 then mq.cmd('/varset xgv_ToggleManaWatchHud Group') end
                        if mwslider == 3 then mq.cmd('/varset xgv_ToggleManaWatchHud Self') end

                        local storvar = mwslider
                        local hudset = mq.TLO.Macro.Variable('xgv_ToggleManaWatchHud')()

                        if mwslider ~= m1 then
                            mq.cmd('/varset xgv_ToggleManaWatch', mwslider)
                            if mwslider == 0 then mq.cmd('/varset xgv_ToggleManaWatchHud OFF') end
                            if mwslider == 1 then mq.cmd('/varset xgv_ToggleManaWatchHud Healers') end
                            if mwslider == 2 then mq.cmd('/varset xgv_ToggleManaWatchHud Group') end
                            if mwslider == 3 then mq.cmd('/varset xgv_ToggleManaWatchHud Self') end

                            mq.cmd("/cc storevar xgv_ToggleManaWatch", storvar)

                        end
                    end
                end

                -- New Row ================================================
                -- RADIUS / ZRADIUS SLIDER
                if mq.TLO.Macro() then -- intentional to try and avoid ImGui Crash when mac shuting down.
                    if string.find(mq.TLO.Macro.Name(), 'xgen.mac') and mq.TLO.Macro.Variable('XgenStarted')() == 2 then -- intentional to try and avoid ImGui Crash when mac shuting down.
                        local z1 = mq.TLO.Macro.Variable('Radius')
                        local z2 = mq.TLO.Macro.Variable('ZRadius')
                        local rads = { z1(), z2() }
                        local radiuschange = ImGui.SliderInt2("Radius   X-Y   |   Z", rads, 1, 2000)
                        local rads = radiuschange
                        for i, k, v in ipairs(rads) do
                            if i == 1 then
                                mq.cmd('/varset Radius', k)
                                mq.cmd('/squelch /mapfilter SpellRadius', k)

                            end
                            if i == 2 then mq.cmd('/varset ZRadius', k) end
                            if i == 1 and k ~= mq.TLO.Macro.Variable('Radius')() then print('Updating Pull Radius') end
                            if i == 1 and k ~= mq.TLO.Macro.Variable('Radius')() then mq.cmd('/sqlite query ${xgv_XGenDB} pullingdata INSERT OR REPLACE INTO PullRads (ZoneName,Radius,ZRadius) VALUES (trim("${Zone.Name}"), "${Radius}", "${ZRadius}")') end
                            if i == 2 and k ~= mq.TLO.Macro.Variable('ZRadius')() then mq.cmd('/sqlite query ${xgv_XGenDB} pullingdata INSERT OR REPLACE INTO PullRads (ZoneName,Radius,ZRadius) VALUES (trim("${Zone.Name}"), "${Radius}", "${ZRadius}")') end
                            if i == 2 and k ~= mq.TLO.Macro.Variable('ZRadius')() then print('Updating Pull ZRadius') end
                        end
                    end
                end
                -- New Row ================================================
                ImGui.Separator()
                -- Tankmode CHECKBOX
                local chkbxname = 'Tank' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleTankMode1')() == 1 -- EDIT NAME IN ''
                local cmdname = 'tankmode' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    -- if mode then mq.cmd('/cc shouts on') else mq.cmd('/cc shouts off') end
                end

                -- RaidTank CHECKBOX
                ImGui.SameLine()
                local chkbxname = 'RaidTank' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_RaidTankMode')() == 1 -- EDIT NAME IN ''
                local cmdname = 'raidtank' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else
                        mq.cmd('/cc', cmdname, 'off')
                    end
                end

                -- AEAggro CHECKBOX
                ImGui.SameLine()
                local chkbxname = 'AE Aggro' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleAEAggro1')() == 1 -- EDIT NAME IN ''
                local cmdname = 'aeaggro' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                -- DPSmode CHECKBOX
                ImGui.SameLine()
                local chkbxname = 'DPSMode' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleDPSMode')() == 1 -- EDIT NAME IN ''
                local cmdname = 'dpsmode' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 15.0, 4.0)
                ImGui.SameLine()

                local Follow = 'Follow'
                if ImGui.SmallButton(Follow) then mq.cmdf('/cc follow') end
                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)



                -- New Row ================================================
                -- AssistMode CHECKBOX
                local chkbxname = 'AssistMode' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_Asst1')() == 1 -- EDIT NAME IN ''
                local cmdname = 'assist' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                -- ForceBurn CHECKBOX
                ImGui.SameLine()
                local chkbxname = 'ForceBurn' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ForceBurn')() == 1 -- EDIT NAME IN ''
                local cmdname = 'forceburn' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                -- BurnOnce CHECKBOX
                ImGui.SameLine()
                local BurnOnce = 'Burn Once'
                if ImGui.SmallButton(BurnOnce) then mq.cmdf('/cc burnonce') end

                -- Nukes CHECKBOX
                ImGui.SameLine()
                local chkbxname = 'Nukes' -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleDPSNukes')() == 1 -- EDIT NAME IN ''
                local cmdname = 'nukes' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                -- DOT's CHECKBOX
                ImGui.SameLine()
                local chkbxname = "Dot's" -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleDots')() == 1 -- EDIT NAME IN ''
                local cmdname = 'dots' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end
            end --Tab MAIN
            ImGui.EndTabItem()
        end
    end

    -- #############################################################################################
    -- #############################################################################################
    -- #############################################################################################
    -- #############################################################################################

    if mq.TLO.Macro() then
        if string.find(mq.TLO.Macro.Name(), 'xgen.mac') and mq.TLO.Macro.Variable('XgenStarted')() == 2 then -- checking for running mac-- this is set in if's on purpose. ImGui crahes if the macro is stopped while lua running.
            -- ============== Nukes / Dots ManaSaver TAB =================
            local NukeClasses = 'WIZ, MAGE, DRU, NEC, SHD, SHM, RNG, PAL'
            if string.find(NukeClasses, mq.TLO.Me.Class.ShortName()) and
                ImGui.BeginTabItem('Nukes/Dots') then
                ImGui.PushItemWidth(-170)

                ImGui.TextColored(1, 1, 1, 1, 'Set to minimum % mana for nuking. Reserves mana for other stuff.')
                -- minimum mana SLIDER
                -- Start ===== ManaSaver Slider
                local minmana = mq.TLO.Macro.Variable('xgv_ManaSaver')()
                local minmanaslider = ImGui.SliderInt('% MinimumMana for Nukes', minmana, 1, 99)
                local storvar = minmanaslider
                if minmanaslider ~= minmana then
                    mq.cmd('/varset xgv_ManaSaver', minmanaslider)
                    mq.cmd("/cc storevar xgv_ManaSaver", storvar)
                end
                -- END ===== ManaSaver Slider

                -- Start ===== DotManaSaver Slider
                local dotminmana = mq.TLO.Macro.Variable('xgv_DotManaSaver')()
                local dotminmanaslider = ImGui.SliderInt('% MinimumMana for DoTs', dotminmana, 1, 99)
                local storvar = dotminmanaslider
                if dotminmanaslider ~= dotminmana then
                    mq.cmd('/varset xgv_DotManaSaver', dotminmanaslider)
                    mq.cmd("/cc storevar xgv_DotManaSaver", storvar)
                end
                -- END ===== ManaSaver Slider
                ImGui.PopItemWidth()
                ImGui.EndTabItem()
            end


            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################

            -- TANK Tab
            local TankClasses = 'SHD, PAL, WAR'
            if string.find(mq.TLO.Macro.Name(), 'xgen.mac') and
                string.find(TankClasses, mq.TLO.Me.Class.ShortName()) and
                ImGui.BeginTabItem('Tanks') then
                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)
                ImGui.TextColored(1, 0, 0, 1, 'This is for Setting Up Tanks.   Bandolier buttons SAVE sets.')
                ImGui.TextColored(0.39, 0.58, 0.92, 1, "Bandolier's")
                ImGui.SameLine()

                local TankingBando = 'Tanking'
                if ImGui.Button(TankingBando) then mq.cmd('/bandolier Add Tanking') end

                ImGui.SameLine()
                local twohdbando = '2hander'
                if ImGui.Button(twohdbando) then mq.cmd('/bandolier Add 2hander') end

                -- local twoonehanders = '1hs'
                ImGui.SameLine()
                local twoonehanders = '1hs'
                if (mq.TLO.Me.Class.ShortName() == 'WAR') then
                    if ImGui.Button(twoonehanders) then mq.cmd('/bandolier Add 1hs') end
                end

                -- BANDOLIER STUFF
                ImGui.SameLine()
                local chkbxname = "Bando" -- NAME OF CHECK BOX
                local state = mq.TLO.Macro.Variable('xgv_ToggleBando1')() == 1 -- EDIT NAME IN ''
                local cmdname = 'bando' -- /cc name you type to do command

                local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                if mode ~= state then
                    if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                end

                ImGui.SameLine()
                ImGui.PushItemWidth(-20)
                local bcount = mq.TLO.Macro.Variable('xgv_bcount')()
                local storvar = ImGui.InputInt("##nonamebox", bcount)
                if bcount ~= storvar then
                    mq.cmd('/varset xgv_bcount', storvar)
                    mq.cmd("/cc storevar xgv_bcount", storvar)

                end
                ImGui.PopItemWidth()

                ImGui.Separator()
                ImGui.Separator()


                ImGui.PushItemWidth(-120) --- PUSH -120
                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)
                local SitLabel = 'AutoSit OFF##startbarsitoff2'
                if mq.TLO.Macro.Variable('xgv_Sit1')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_Sit1')() == 1 then SitLabel = 'AutoSit ON##startbarsiton2' end
                if ImGui.SmallButton(SitLabel) then mq.cmd('/cc autosit') end
                if mq.TLO.Macro.Variable('xgv_Sit1')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local CampLabel = 'Camp OFF##startbarcampoff2'
                if mq.TLO.Macro.Variable('xgv_ToggleCamp1')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_ToggleCamp1')() == 1 then CampLabel = 'Camp ON##startbarcampon2' end
                if ImGui.SmallButton(CampLabel) then mq.cmd('/cc camp') end
                if mq.TLO.Macro.Variable('xgv_ToggleCamp1')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local MoveLabel = 'Move OFF##startbarmoveoff2'
                if mq.TLO.Macro.Variable('xgv_ToggleMove1')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_ToggleMove1')() == 1 then MoveLabel = 'Move ON##startbarmoveon2' end
                if ImGui.SmallButton(MoveLabel) then
                    mq.cmd('/cc move')
                    mq.cmd('/varset xgv_ModeRanged 0')
                end
                if mq.TLO.Macro.Variable('xgv_ToggleMove1')() == 1 then ImGui.PopStyleColor(1) end

                ImGui.SameLine()
                local BehindLabel = 'Behind OFF##startbarbehindoff2'
                if mq.TLO.Macro.Variable('xgv_ToggleGetBehind')() == 1 then
                    ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                end
                if mq.TLO.Macro.Variable('xgv_ToggleGetBehind')() == 1 then
                    BehindLabel = 'Behind ON##startbarbehindon2'
                end
                if ImGui.SmallButton(BehindLabel) then mq.cmd('/cc behind') end
                if mq.TLO.Macro.Variable('xgv_ToggleGetBehind')() == 1 then ImGui.PopStyleColor(1) end
                ImGui.PopStyleVar()

                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 8.0, 4.0)
                ImGui.Separator()

                -- Start ===== Defcon Slider
                local defconvar = mq.TLO.Macro.Variable('xgv_DefCon')()
                local defconslider = ImGui.SliderInt("Sets DefCon %", defconvar, 1, 99)
                local storvart = defconslider
                if defconslider ~= defconvar then
                    mq.cmd('/varset xgv_DefCon', defconslider)
                    mq.cmd("/cc storevar xgv_DefCon", storvart)
                end
                -- END ===== Defcon Slider

                -- Start ===== Defcon2 Slider
                local defcon2var = mq.TLO.Macro.Variable('xgv_DefCon2')()
                local defcon2slider = ImGui.SliderInt("Sets DefCon2 #", defcon2var, 1, 30)
                local storvard = defcon2slider
                if defcon2slider ~= defcon2var then
                    mq.cmd('/varset xgv_DefCon2', defcon2slider)
                    mq.cmd("/cc storevar xgv_DefCon2", storvard)
                end
                -- END ===== Defcon2 Slider

                -- Start ===== CampRad Slider
                local campradvar = mq.TLO.Macro.Variable('xgv_GrpCmp')()
                local campradslider3 = ImGui.SliderInt("Sets CampRad #", campradvar, 1, 250)
                local storvarc = campradslider3
                if campradslider3 ~= campradvar then
                    mq.cmd('/varset xgv_GrpCmp', campradslider3)
                    mq.cmd("/cc storevar xgv_GrpCmp", storvarc)
                end
                -- END ===== CampRad Slider

                -- Start ===== 2aggro slider
                local secondagro = mq.TLO.Macro.Variable('xgv_2PctAggro')()
                local secondagroslider = ImGui.SliderInt("Secondary Aggro %", secondagro, 30, 100)
                local storvar2a = secondagroslider
                if secondagroslider ~= secondagro then
                    mq.cmd('/varset xgv_2PctAggro', secondagroslider)
                    mq.cmd("/cc storevar xgv_2PctAggro", storvar2a)
                end
                -- END ===== 2aggro sliderr
                ImGui.PopStyleVar()
                ImGui.PopItemWidth() --- POP -120
                -- End of Tab ======
                ImGui.EndTabItem()

            end





            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################


            -- ============== Heal TAB =================
            local HealClasses = 'CLR, DRU, SHM, RNG, PAL, BST'
            if mq.TLO.Macro() then
                if string.find(mq.TLO.Macro.Name(), 'xgen.mac') and
                    string.find(HealClasses, mq.TLO.Me.Class.ShortName()) and
                    ImGui.BeginTabItem('Healing##h12345222333') then
                    ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 3.0)


                    -- Start -- MT Heal SLIDER
                    local mtheal = mq.TLO.Macro.Variable('xgv_MTHe1')()
                    local mthealslider = ImGui.SliderInt('% MT Heals Start', mtheal, 1, 100)
                    local storvar = mthealslider
                    if mthealslider ~= mtheal then
                        mq.cmd('/varset xgv_MTHe1', mthealslider)
                        mq.cmd("/cc storevar xgv_MTHe1", storvar)
                    end
                    -- END -- MT Heal SLIDER

                    -- Start  -- Group Heal SLIDER
                    local grpheal = mq.TLO.Macro.Variable('xgv_Pct1')()
                    local grphealslider = ImGui.SliderInt('% Grp Heals Start', grpheal, 1, 99)
                    local storvar = grphealslider
                    if grphealslider ~= grpheal then
                        mq.cmd('/varset xgv_Pct1', grphealslider)
                        mq.cmd("/cc storevar xgv_Pct1", storvar)
                    end
                    -- END -- Group Heal SLIDER

                    -- Start  -- Zerker Heal SLIDER
                    local zrkheal = mq.TLO.Macro.Variable('xgv_BERHeal')()
                    local zrkhealslider = ImGui.SliderInt('% Zerker Heals D(80)', zrkheal, 1, 99)
                    local storvar = zrkhealslider
                    if zrkhealslider ~= zrkheal then
                        mq.cmd('/varset xgv_BERHeal', zrkhealslider)
                        mq.cmd("/cc storevar xgv_BERHeal", storvar)
                    end
                    -- END -- Zerker Heal SLIDER


                    -- start Heal Range SLIDER
                    local hl1 = mq.TLO.Macro.Variable('xgv_Rng')()
                    local healhudslider = ImGui.SliderInt('HealRange ' .. hl1 .. ' Ft.', hl1, 50, 300)
                    local storvar = healhudslider
                    if healhudslider ~= hl1 then
                        mq.cmd('/varset xgv_Rng', healhudslider)
                        mq.cmd("/cc storevar xgv_Rng", storvar)
                    end

                    -- CURES

                    local chkbxname = "Cures" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_ToggleCurez')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'cure' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end

                    -- BUFFS
                    ImGui.SameLine()
                    local chkbxname = "Buffs" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_bufz')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'buffs' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end

                    -- X-Target Heals
                    ImGui.SameLine()
                    local chkbxname = "XTaHeals" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_XtargetHeals')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'xtheals' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end


                    -- Pet Heals
                    ImGui.SameLine()
                    local chkbxname = "PetHeals" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_PetHeals1')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'petheals' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end

                    -- Auto Res
                    ImGui.SameLine()
                    local chkbxname = "Auto Rez" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_AutoRez1')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'autores' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then -- NEVER EDIT
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end -- NEVER EDIT
                    end

                    ImGui.Separator()
                    ImGui.Separator()


                    -- Splash
                    ImGui.SameLine()
                    if mq.TLO.Me.Class.ShortName() == 'PAL' then
                        ImGui.TextColored(1, 1, 0, 1, 'Pally')
                        ImGui.SameLine()
                        local chkbxname = "Splash" -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('xgv_Splash1')() >= 6 -- EDIT NAME IN ''
                        local cmdname = 'splash' -- /cc name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/cc', cmdname, 'ON') else mq.cmd('/cc', cmdname, 'OFF') end
                        end
                    end


                    if mq.TLO.Me.Class.ShortName() == 'DRU' then
                        ImGui.Separator()
                        ImGui.TextColored(1, 1, 0, 1, 'Druid')
                        ImGui.SameLine()
                        local chkbxname = "Heals Only" -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('HealsOnly')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'healsonly' -- /cc name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then -- NEVER EDIT
                            if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end -- NEVER EDIT
                        end

                        ImGui.SameLine()
                        local chkbxname = "DS" -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('xgv_DamShld')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'toggleds' -- /cc name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then -- NEVER EDIT
                            if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end -- NEVER EDIT
                        end



                    end


                    if mq.TLO.Me.Class.ShortName() == 'CLR' then
                        ImGui.Separator()
                        ImGui.TextColored(1, 1, 0, 1, 'Cleric')
                        ImGui.SameLine()
                        local chkbxname = "placeholder" -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('null')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'null' -- /cc name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then -- NEVER EDIT
                            if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end -- NEVER EDIT
                        end
                    end


                    if mq.TLO.Me.Class.ShortName() == 'SHM' then
                        ImGui.Separator()
                        ImGui.TextColored(1, 1, 0, 1, 'Shaman')
                        ImGui.SameLine()
                        local chkbxname = "placeholder" -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('null')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'null' -- /cc name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then -- NEVER EDIT
                            if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end -- NEVER EDIT
                        end
                    end


                    ImGui.PopStyleVar()
                    ImGui.EndTabItem()
                end
            end


            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################



            -- ==============  GRP TAB =================
            if ImGui.BeginTabItem('Group') then

                ImGui.BeginTable('Group1', 5,
                    ImGuiTableFlags.Borders + ImGuiTableFlags.RowBg + ImGuiTableFlags.SizingFixedFit +
                    ImGuiTableFlags.PadOuterX)
                ImGui.TableNextRow()

                ImGui.TableSetupColumn('   Mercenary', 0)
                ImGui.TableSetupColumn('Members', 1)
                ImGui.TableSetupColumn('    MT / MA', 2)
                ImGui.TableSetupColumn('Grp Cmds', 3)
                ImGui.TableSetupColumn('Something', 4)
                ImGui.TableSetupScrollFreeze()
                ImGui.TableHeadersRow()
                ImGui.TableNextRow()
                ImGui.TableSetColumnIndex(0)
                -- ImGui.Separator()

                -- ROW 1
                Merc = '   Suspend   '
                if mq.TLO.Mercenary.State() == ('SUSPENDED') then
                    Merc = 'UnSuspend '
                end
                if ImGui.Button(Merc) then
                    mq.cmd('/notify MMGW_ManageWnd MMGW_SuspendButton leftmouseup')
                    mq.cmd('/varset xgv_ModeRanged 0')
                end

                -- Group Member 0

                ImGui.TableNextColumn()
                local GPMember = mq.TLO.Group.Member(0)
                if GPMember() then
                    if ImGui.Button(GPMember()) then
                        mq.cmdf('/target id %d', GPMember.ID())
                    end
                end

                ImGui.TableNextColumn()

                ImGuiCol = ImGuiCol

                local Gmemnum = '0'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMT##GMT0') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 1)
                        -- print('/grouproles set %s %d', Gmem(), 1)
                    end
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.SameLine()
                local Gmemnum = '0'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMA##GMA0') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 2)
                    end
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PopStyleColor(1) end
                end


                ImGui.TableNextColumn()
                local Follow = 'All Follow ON'
                if ImGui.Button(Follow) then mq.cmdf('/dge all /cc follow ON') end
                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)


                -- ROW 2
                ImGui.TableNextRow()
                ImGui.TableSetColumnIndex(0)


                ImGui.TableNextColumn()
                local GPMember = mq.TLO.Group.Member(1)
                if GPMember() then
                    if ImGui.Button(GPMember()) then
                        mq.cmdf('/target id %d', GPMember.ID())
                    end
                end



                ImGui.TableNextColumn()
                local Gmemnum = '1'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMT##GMT1') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 1)
                        -- print('/grouproles set %s %d', Gmem(), 1)
                    end
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.SameLine()
                local Gmemnum = '1'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMA##GMA1') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 2)
                    end
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.TableNextColumn()
                local Followoff = 'All FollowOFF'
                if ImGui.Button(Followoff) then mq.cmdf('/dge all /cc follow OFF') end
                ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)


                -- ROW 3
                ImGui.TableNextRow()
                ImGui.TableSetColumnIndex(0)
                MercStanceLabel = '  Balanced   '
                if ImGui.Button(MercStanceLabel) then
                    mq.cmd('/stance Balanced')
                end


                ImGui.TableNextColumn()
                local GPMember = mq.TLO.Group.Member(2)
                if GPMember() then
                    if ImGui.Button(GPMember()) then
                        mq.cmdf('/target id %d', GPMember.ID())
                    end
                end

                ImGui.TableNextColumn()
                local Gmemnum = '2'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMT##GMT2') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 1)

                    end
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.SameLine()
                local Gmemnum = '2'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMA##GMA2') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 2)
                    end
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PopStyleColor(1) end
                end

                -- Group Member 3

                ImGui.TableNextRow()
                ImGui.TableSetColumnIndex(0)
                MercStanceLabel = '   Efficient    '
                if ImGui.Button(MercStanceLabel) then
                    mq.cmd('/stance Efficient')
                end



                ImGui.TableNextColumn()
                local GPMember = mq.TLO.Group.Member(3)
                if GPMember() then
                    if ImGui.Button(GPMember()) then
                        mq.cmdf('/target id %d', GPMember.ID())
                    end
                end
                ImGui.TableNextColumn()
                local Gmemnum = '3'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMT##GMT3') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 1)
                    end
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.SameLine()
                local Gmemnum = '3'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMA##GMA3') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 2)
                    end
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PopStyleColor(1) end
                end


                -- Group Member 4
                ImGui.TableNextRow()
                ImGui.TableSetColumnIndex(0)
                MercStanceLabel = '   Passive     '
                if ImGui.Button(MercStanceLabel) then
                    mq.cmd('/stance Passive')
                end

                ImGui.TableNextColumn()
                local GPMember = mq.TLO.Group.Member(4)
                if GPMember() then
                    if ImGui.Button(GPMember()) then
                        mq.cmdf('/target id %d', GPMember.ID())
                    end
                end


                ImGui.TableNextColumn()
                local Gmemnum = '4'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMT##GMT4') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 1)
                    end
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.SameLine()
                local Gmemnum = '4'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMA##GMA4') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 2)
                    end
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PopStyleColor(1) end
                end

                -- Group Member 5

                ImGui.TableNextRow()
                ImGui.TableSetColumnIndex(0)
                MercStanceLabel = '  Reactive    '
                if ImGui.Button(MercStanceLabel) then
                    mq.cmd('/stance Reactive')
                end


                ImGui.TableNextColumn()
                --  ImGui.TableNextColumn()
                local GPMember = mq.TLO.Group.Member(5)
                if GPMember() then
                    if ImGui.Button(GPMember()) then
                        mq.cmdf('/target id %d', GPMember.ID())
                    end
                end


                ImGui.TableNextColumn()
                local Gmemnum = '5'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMT##GMT5') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 1)
                    end
                    if mq.TLO.Group.MainTank() == Gmem() then ImGui.PopStyleColor(1) end
                end

                ImGui.SameLine()
                local Gmemnum = '5'
                local Gmem = mq.TLO.Group.Member(Gmemnum)
                if Gmem() then
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .5, 0.1, 1) end
                    if ImGui.Button('GMA##GMA5') then
                        mq.cmdf('/grouproles set %s %d', Gmem(), 2)
                    end
                    if mq.TLO.Group.MainAssist() == Gmem() then ImGui.PopStyleColor(1) end
                end






                ImGui.EndTable()
                ImGui.EndTabItem()
            end



            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################



            -- ==============  ADMIN TAB =================
            if mq.TLO.Macro.Variable('AdminModeOn')() == 1 then
                if ImGui.BeginTabItem('AdminTab') then


                    if string.find(mq.TLO.Macro.Name(), 'xgen.mac') then
                        ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)
                        ImGui.TextColored(0.39, 0.58, 0.92, 1, 'Target:')
                        ImGui.SameLine()
                        ImGui.TextColored(1, 1, 0.1, 1, mq.TLO.Target.CleanName())
                        ImGui.SameLine()
                        ImGui.TextColored(1, 1, 1, 1, 'LOS:')
                        ImGui.SameLine()
                        local checked = (mq.TLO.Target.LineOfSight())
                        if checked then ImGui.TextColored(0, 1, 0, 1, 'T') else ImGui.TextColored(1, 0, 0, 1, 'F') end
                        ImGui.SameLine()
                        ImGui.TextColored(1, 1, 1, 1, 'X-Status:')
                        ImGui.SameLine()

                        local StartXGen = 'OFF##startbarxgenoff3'
                        local colorStyleCount = 0

                        if string.find(mq.TLO.Macro.Name(), 'xgen.mac') then
                            if mq.TLO.Macro.Variable('XgenStarted')() == 1 then
                                ImGui.PushStyleColor(ImGuiCol.Button, 0.5, .5, 0.0, 1)
                                StartXGen = 'Starting##startbarstarting3'
                                colorStyleCount = colorStyleCount + 1
                            elseif mq.TLO.Macro.Variable('XgenStarted')() == 2 then
                                ImGui.PushStyleColor(ImGuiCol.Button, 0.2, .6, 0.0, 1)
                                StartXGen = ' UP##startbarstartingup3 '
                                colorStyleCount = colorStyleCount + 1
                            end
                        end

                        if ImGui.SmallButton(StartXGen) then mq.cmdf('/macro xgen\\xgen') end
                        ImGui.PopStyleColor(colorStyleCount)

                        ImGui.SameLine()
                        local EndMac = 'END##startbarend3'
                        if ImGui.SmallButton(EndMac) then mq.cmdf('/end') end
                        ImGui.SameLine()
                        local MQPause = 'MQP##startbarmqp3'
                        if mq.TLO.Macro.Paused() then MQPause = 'Paused##startbarpaused3' end
                        if ImGui.SmallButton(MQPause) then mq.cmdf('/mqp') end
                        ImGui.Separator()
                        ImGui.Separator()


                        local chkbxname = 'Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('DebugOn')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'debug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'Assist Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('DebugAOn')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'assistdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'SETT Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('SetDebug')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'setdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'Attack Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('AttackDebug')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'attackdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end
                        ImGui.Separator()

                        local chkbxname = 'Spell Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('SDebug')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'sdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'Pull Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('PDebug')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'pdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end


                        ImGui.SameLine()
                        local chkbxname = 'Sit Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('SitDebug')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'sitdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'Target Debug' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('TargetDebug')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'targetdebug' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.Separator()

                        local chkbxname = 'Test Mode' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('TestMode')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'testmode' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                            if mode then mq.cmd('/varset xgv_iAssistHealthPct ${If[${TestMode},100,98]}') else
                                mq.cmd('/varset xgv_iAssistHealthPct ${If[${TestMode},100,98]}')
                            end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'Toggle GMA' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('EnableSetAssist')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'togglesetgma' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local chkbxname = 'Toggle GMT' -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('EnableSetTank')() == 1 -- EDIT NAME IN ''
                        local cmdname = 'togglesetgmt' -- /admin name you type to do command

                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then
                            if mode then mq.cmd('/admin', cmdname, 'on') else mq.cmd('/admin', cmdname, 'off') end
                        end

                        ImGui.SameLine()
                        local CampLabel = 'ObserverList'
                        if ImGui.Button(CampLabel) then mq.cmd('/admin o-list') end



                        ImGui.Separator()
                        local chkbxname = "Healer Tab" -- NAME OF CHECK BOX
                        local state = mq.TLO.Macro.Variable('HealTabOveride')() == 1 -- EDIT NAME IN ''
                        local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                        if mode ~= state then -- NEVER EDIT
                            if mode then mq.cmd('/varset HealTabOveride 1') else mq.cmd('/varset HealTabOveride 0') end -- NEVER EDIT
                        end


                        ImGui.Separator()
                        local CampLabel1 = 'Load HUD'
                        if ImGui.Button(CampLabel1) then mq.cmd('/cc loadhud') end

                        ImGui.SameLine()
                        local CampLabel2 = 'Lua GUI'
                        if ImGui.Button(CampLabel2) then mq.cmd('/lua gui') end

                        ImGui.SameLine()
                        local CampLabel3 = 'WindowSize'
                        if ImGui.Button(CampLabel3) then ImGui.SetWindowSize(410, 250, ImGuiCond.Always) end


                    end
                    ImGui.EndTabItem()
                end
            end



            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################



            -- Ranger Tab
            if mq.TLO.Me.Class.ShortName == 'RNG' then
                if ImGui.BeginTabItem('RNG') then
                    ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 8.0, 4.0)
                    ImGui.TextColored(0.39, 0.58, 0.92, 1, 'ID Confirmed:')
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 0.1, 1, mq.TLO.Me.ID())
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 0.1, 1, ' | ')
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 0.1, 1, mq.TLO.Me.Class())
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 1, 1, '|   X-Status:')
                    ImGui.SameLine()
                    local StartXGen = 'OFF##startbaroff4'
                    if mq.TLO.Macro.Variable('XgenStarted')() == 1 then
                        StartXGen = 'Starting##startbarstarting4'
                    elseif mq.TLO.Macro.Variable('XgenStarted')() == 2 then
                        StartXGen = ' UP##startbarup4 '
                    end
                    if ImGui.SmallButton(StartXGen) then mq.cmdf('/macro xgen\\xgen') end
                    ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 8.0, 4.0)
                    ImGui.SameLine()
                    local EndMac = 'END##startbarend4'
                    if ImGui.SmallButton(EndMac) then mq.cmdf('/end') end
                    ImGui.SameLine()
                    local MQPause = 'MQP##startbarmqp4'
                    if mq.TLO.Macro.Paused() then MQPause = 'Paused##startbarpaused4' end
                    if ImGui.SmallButton(MQPause) then mq.cmdf('/mqp') end

                    ImGui.Separator()
                    ImGui.Separator()

                    ImGui.TextColored(0.39, 0.58, 0.92, 1, 'Target:')
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 0.1, 1, mq.TLO.Target.CleanName())
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 1, 1, 'LOS:')
                    ImGui.SameLine()
                    local checked = (mq.TLO.Target.LineOfSight())
                    if checked then ImGui.TextColored(0, 1, 0, 1, 'T') else ImGui.TextColored(1, 0, 0, 1, 'F') end
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 1, 1, 'Range:')
                    ImGui.SameLine()
                    ImGui.TextColored(1, 1, 0.1, 1, mq.TLO.Target.Distance())


                    -- New Row ================================================
                    ImGui.Separator()
                    local BUFFS = 'Buffing OFF'
                    if mq.TLO.Macro.Variable('xgv_bufz')() == 1 then BUFFS = 'Buffing ON' end
                    if ImGui.Button(BUFFS) then mq.cmd('/cc buffs') end
                    ImGui.SameLine()
                    local fightmode = 'RANGED MODE OFF'
                    if mq.TLO.Macro.Variable('xgv_ModeRanged')() == 1 then fightmode = 'RANGED MODE ON' end
                    if ImGui.Button(fightmode) then mq.cmd('/cc ranged') end
                    ImGui.SameLine()
                    -- Nukes CHECKBOX
                    ImGui.SameLine()
                    local chkbxname = "AE's" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_ToggleAE')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'useae' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end

                    -- Nukes CHECKBOX
                    ImGui.SameLine()
                    local chkbxname = 'Nukes' -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('xgv_ToggleDPSNukes')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'nukes' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end

                    ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 8.0)
                    ImGui.Separator()
                    ImGui.TextColored(1, 1, 1, 1, 'Summers Nuke Cast#')
                    ImGui.SameLine()
                    ImGui.PushStyleVar(ImGuiStyleVar.ItemSpacing, 4.0, 4.0)

                    local snuke = mq.TLO.Macro.Variable('xgv_NukCnt')()
                    local sn1 = mq.TLO.Macro.Variable('xgv_NukCnt')()

                    local snslider = ImGui.SliderInt('', sn1, 1, 50)

                    local storvar = snslider
                    local hudset = mq.TLO.Macro.Variable('xgv_NukCnt')()

                    if snslider ~= sn1 then
                        mq.cmd('/varset xgv_NukCnt', snslider)

                        mq.cmd("/cc storevar xgv_NukCnt", storvar)

                    end

                    ImGui.EndTabItem()
                end -- Ranger Tab
            end



            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################



            -- ==============  MISC TAB =================
            if ImGui.BeginTabItem('Misc') then
                if ImGui.CollapsingHeader("Variables") then
                    ImGui.TextColored(1, 0, 0, 1, '/cc byos Variable "NewSpellName" is how you replace spells')
                    ImGui.BeginTable('SpellsAndVars', 2,
                        ImGuiTableFlags.Sortable + ImGuiTableFlags.Resizable + ImGuiTableFlags.Borders)
                    ImGui.TableSetupColumn('Variable')
                    ImGui.TableSetupColumn('Spell Name')
                    ImGui.TableSetupScrollFreeze()
                    ImGui.TableHeadersRow()


                    if string.find(mq.TLO.Macro.Name(), 'xgen.mac') then
                        local function mysplit(inputstr, sep)
                            if sep == nil then
                                sep = "%s"
                            end
                            local t = {}
                            for str in string.gmatch(inputstr, "([^" .. sep .. "]+)") do
                                table.insert(t, str)
                            end
                            return t
                        end

                        --local spellvar = mq.TLO.Macro.Variable('SpellVars')()
                        --local spells = mq.TLO.Macro.Variable('Spellz')()
                        local spellvar = mq.TLO.Macro.Variable('luavars')()
                        local spells = mq.TLO.Macro.Variable('luavars')()


                        local spellvarstable = mysplit(spellvar, "|")
                        local spellstable = mysplit(spells, "|")

                        for i = 1, math.min(#spellvarstable, #spellstable) do
                            ImGui.TableNextColumn()
                            ImGui.TextColored(1, 1, 1, 1, spellvarstable[i])
                            -- ImGui.TextColored(1, 1, 1, 1, spellvarstable[i] .. ' -- ' .. spellstable[i])
                            -- ImGui.ListBox("Spell Vars", current_item, { spellvarstable[i], spellstable[i], 2 })

                        end
                        ImGui.EndTable()
                    end
                end
                local tablename = 'Travel Agency'
                if ImGui.CollapsingHeader(tablename) then

                    ImGui.BeginTable(tablename, 4,
                        ImGuiTableFlags.Sortable + ImGuiTableFlags.Resizable + ImGuiTableFlags.Borders)

                    --[[ ImGui.TableGetSortSpecs() {
                        ImGui.TableUpdateLayout(tablename);
                        ImGui.TableSortSpecsBuild(tablename);
                    }
                    ImGui.TableGetColumnAvailSortDirection('Name', 2)
                    ImGui.TableFixColumnSortDirection(tablename, 2)
                    ]]

                    ImGui.TableSetupColumn('#')
                    ImGui.TableSetupColumn('ID')
                    ImGui.TableSetupColumn('Name')
                    ImGui.TableSetupColumn('Short (CLICK ME)')



                   

                    ImGui.TableHeadersRow(0)
                    ImGui.TableSetupScrollFreeze(0)
                    local i = 849
                    local x = 1
                    while i > 0 do
                        while mq.TLO.Zone(i).ID() == nil do
                            i = i - 1
                        end


                        ImGui.TableNextRow()

                        -- Column 1 COUNT
                        ImGui.TableSetColumnIndex(0)
                        ImGui.Text(i)

                        -- Column 2 ID
                        ImGui.TableSetColumnIndex(1)
                        ImGui.TextColored(1, 1, 0, 1, mq.TLO.Zone(i).ID())

                        -- Column 3 NAMES
                        ImGui.TableSetColumnIndex(2)
                        ImGui.TextColored(1, 1, 0, 1, mq.TLO.Zone(i).Name())

                        -- Column 4 SHORT NAMES
                        ImGui.TableSetColumnIndex(3)
                        if ImGui.Selectable(mq.TLO.Zone(i).ShortName()) then
                            ImGui.TextColored(1, 1, 0, 1, mq.TLO.Zone(i).ShortName())
                            mq.cmd('/travelto ', mq.TLO.Zone(i).ShortName())
                        end
                        i = i - 1
                    end



                    ImGui.EndTable()
                end
                ImGui.EndTabItem()
            end


            -- #############################################################################################
            -- #############################################################################################
            -- #############################################################################################



            -- ==============  Pull TAB =================
            if ImGui.BeginTabItem('Pull/Move') then
                -- ImGui.TextColored(1, 0, 0, 1, '                           MaxD will show 0 untill you target a NPC.')

                --ImGui.TextColored(1, 0, 0, 1, 'If using for /cc byos, do NOT include the SP-, AA-, CA-!')   + ImGuiTableFlags.BordersInnerH  + ImGuiTableFlags.BordersInnerV
                ImGui.BeginTable('Pulls', 4,
                    ImGuiTableFlags.Sortable + ImGuiTableFlags.Resizable + ImGuiTableFlags.Borders +
                    ImGuiTableFlags.PadOuterX + ImGuiTableFlags.PadOuterX)
                ImGui.TableSetupColumn('P-Options')
                ImGui.TableSetupColumn('Tab2')
                ImGui.TableSetupColumn('Tab3')
                ImGui.TableSetupColumn('Range from Mob')
                ImGui.TableHeadersRow()


                if string.find(mq.TLO.Macro.Name(), 'xgen.mac') then

                    -- COLUMN 1
                    ImGui.TableNextRow()
                    ImGui.TableSetColumnIndex(0)

                    local chkbxname = "Greys" -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('PullGREY')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'pullgrey' -- /cc name you type to do command
                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then -- NEVER EDIT
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end -- NEVER EDIT
                    end


                    -- COLUMN 3

                    ImGui.TableSetColumnIndex(3)

                    local maxd1 = mq.TLO.Macro.Variable('maxdslider')()
                    local maxdslider = ImGui.SliderFloat('MaxD ', maxd1, 0.01, 1.00)
                    local storvar = maxdslider
                    if maxdslider ~= maxd1 then
                        mq.cmd('/varset maxdslider', maxdslider)
                        mq.cmd("/cc storevar maxdslider", storvar)
                    end
                    local MaxDNumber = mq.TLO.Math.Calc(mq.TLO.Target.MaxRangeTo)() *
                        mq.TLO.Macro.Variable('maxdslider')()
                    ImGui.SameLine()
                    ImGui.TextColored(1, 0, 0, 1, MaxDNumber)



                    ImGui.TableNextRow()
                    ImGui.TableSetColumnIndex(3)
                    local chkbxname = 'Style' -- NAME OF CHECK BOX
                    local state = mq.TLO.Macro.Variable('PullStyle')() == 1 -- EDIT NAME IN ''
                    local cmdname = 'pullstyle' -- /cc name you type to do command

                    local mode = ImGui.Checkbox(chkbxname, state) -- NEVER EDIT
                    if mode ~= state then
                        if mode then mq.cmd('/cc', cmdname, 'on') else mq.cmd('/cc', cmdname, 'off') end
                    end
                    ImGui.SameLine()
                    local Radius = mq.TLO.Macro.Variable('Radius')()
                    if mq.TLO.Macro.Variable('PullStyle')() == 1 then
                        ImGui.TextColored(1, 1, 0.1, 1, '   Set Radius      ' .. Radius)
                    else ImGui.TextColored(1, 1, 0.1, 1, 'All Over')
                    end
                    ImGui.TableNextColumn()

                    ImGui.EndTable()


                    -- TEXT INPUT BOX FOR TEMP IGNORE!!!!!
                    ImGui.TextColored(1, 0, 0, 1, 'Add names for Perminant ignore list.')
                    data, _ = ImGui.InputText("Name##1", data, 100)
                    ImGui.SameLine()
                    local clickedperm = ImGui.Button("Save")
                    if clickedperm then
                        -- print('output is ', data)
                        mq.cmd('/cc permignore add ', data)
                        data = ''
                    end

                    ImGui.TextColored(1, 0, 0, 1, 'Add names for Temporary ignore list.')
                    data2, _ = ImGui.InputText("Name##2", data2, 100)
                    ImGui.SameLine()
                    local clickedtemp = ImGui.Button("Save")
                    if clickedtemp then
                        -- print('output is ', data2)
                        mq.cmd('/cc ignore ', data2)
                        data2 = ''
                    end

                    local clickedignorelist = ImGui.Button("List Ignored")
                    if clickedignorelist then
                        mq.cmd('/cc list')
                    end



                end

                ImGui.EndTabItem()
            end
            ImGui.EndTabBar()
        end
    end

    -- END OF DRAW DO NOT EDIT BELOW
    ImGui.End()
end

-- ###############################################################################################
-- ###############################################################################################
-- ########.............########..####################..######........############################
-- ########..###################..#..#################..######..#####..###########################
-- ########..###################..###..###############..######..#######..#########################
-- ########..###################..#####..#############..######..#########..#######################
-- ########..###################..#######..###########..######..###########..#####################
-- ########...........##########..#########..#########..######..###########..#####################
-- ########..###################..###########..#######..######..##########..######################
-- ########..###################..#############..#####..######..##########..######################
-- ########..###################..###############..###..######..########..########################
-- ########..###################..#################..#..######..######..##########################
-- ########.............########..####################..######........############################
-- ###############################################################################################
-- ###############################################################################################






mq.imgui.init('window', imguicallback)

while openGUI do
    mq.delay(1000)
    -- I can make a credits tab if asked and you helped me with LUA.. Read this and ask and it shall be done! :)
end
