| -----------------------------------------------------------------------------
| KAraid.inc by AmericanNero
|
| Enables player to use KA on raids without having to deal with KA auto-target
| -----------------------------------------------------------------------------

#bind Engage /karaidengage

| ---------------------------------------------------------------------------
| SUB: Bind_Engage
|
| /engage autotargetoff, turns off autotargeting so you can manually select
| targets.  Then to attack a mob, /engage on, or /engage off to stop.
| /engage autotargeton enables standard KA mode.
| ---------------------------------------------------------------------------
	Sub Bind_Engage

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/if (!${Defined[EngageMobOn]}) {
			/declare EngageMobOn	int		outer	0
		}
	
		|
		| This falls through in this order to allow dual purpose. Don't monkey with it.
		|
		/if (!${AutoTargetOn} && !${Macro.Params}) {
			/if (${EngageMobOn}) {
				/varset EngageMobOn 0
			} else {
				/varset EngageMobOn 1
			}
		}
		/if (${Macro.Params}) {
			/if (${Select[${Param0},autotargetoff]}) {
				/echo Enabling /engage. To attack use /engage 1/on (or empty to toggle)
				/varset AutoTargetOn 0
				/varset IAmMA 0
				/varset MainAssist ${Me}
				POPCALL
				/return
			}
			/if (${Select[${Param0},autotargeton]}) {
				/echo Disabling /engage, and halting attack. Restart to reset MA.
				/varset AutoTargetOn 1
				/call DisengageMob
				POPCALL
				/return
			}
		}
		/if (${AutoTargetOn}) {
			/echo Enable/disable this function by doing /engage autotargetoff|autotargeton
			/echo Then to control attack /engage 0/1/on/off/empty to toggle, 
			POPCALL
			/return
		}
		/if (${Macro.Params}) {
			/if (${Select[${Param0},1,on]}) {
					/varset EngageMobOn 1
				} else /if (${Select[${Param0},0,off]}) {
					/varset EngageMobOn 0
				} else /if (${Select[${Param0},9]}) {
					/varset EngageMobOn 9
				} else {
					/echo /engage 0/1/on/off/empty to toggle, in order to attack or stop attacking.
					/echo Enable/disable this function by doing /engage autotargetoff|autotargeton
					POPCALL
					/return
				}
			}
		}
		/if (${EngageMobOn}) {
			/call EngageMob
		} else {
			/call DisengageMob
		}
		POPCALL
	/return
| ---------------------------------------------------------------------------
| SUB: EngageMob
|
| ---------------------------------------------------------------------------
	Sub EngageMob
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/if (${Target.ID}) {
			/call IsFriendly ${Target.ID}
			/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
				/call TargetSet ${Target.ID}
				/echo Targetted -> ${MyTargetName} <- ID: ${MyTargetID}
				/varset LastTargetID ${MyTargetID}
				/varset CalledTargetID ${MyTargetID}
			} else {
				/echo Target is friendly!
				/varset EngageMobOn 0
			}
		} else {
			/echo Nothing to attack!
			/varset EngageMobOn 0
		}
		POPCALL
	/return
| ---------------------------------------------------------------------------
| SUB: DisengageMob
|
| ---------------------------------------------------------------------------
	Sub DisengageMob
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/call TargetSet
		/if (${Pet.ID}) /call PetBackOff
		/varset LastTargetID 0
		/varset CalledTargetID 0
		/call TargetThis

		POPCALL
	/return
