|------------------------------------------------------------------------------
|
| rdy.inc
|
| v1.0 Derived from ready.mac, also by AmericanNero, June 27, 2021
|
| Add the include at the bottom of kissassist.mac or whatever macro you like. That's it.
| #include rdy.mac
|
| Advise you make a hotbutton macro, e.g. /rdy leave Gribble, but
| you can also target. Current KA may try to attack the npc. /boggle
|
| Usage: /rdy triggerword taskgiver(optional) me|notme|now|menow|notmenow(optional)
|
| Example: Start the instance, and while targetting the taskgiver, do
| /rdy triggerword, and everyone in scope will join the instance when it is
| ready. Use dannet or eqbcs, or however you like to network your team(s).
|
| Remember to enclose any multi-word parameters in quotes.
|
| Instances require 45s to instantiate and randomized time padding is added.
| If a char is too far away, it will move to the taskgiver the leader has
| targetted, or specified.
|
| If the system is slow, it will pause 5s before trying to get task info.
| If a char hasn't acquired the task giver via assist or parameter, it will
| move to the leader then attempt to assist again, then go to the taskgiver.
| Characters will begin moving after some randomized interval, and thus
| arrived staggered.
|
| There are time interval parameters you may tinker with at the top of
| Sub Main. You are encouraged to tweak them to your preference, but I
| strongly advise you maintain some variability so you avoid the "ready"
| burst which makes automation obvious. There is a parameter for whether
| invis should be dropped prior to triggering, as well.
|
| Future - If I am motivated. A char may even try to get in early!
| There is a non-functioning parameter to enable/disable this feature.
|
| Todo:
| Maybe - Add early trigger word behavior (before 45s has elapsed) to mimic
|         those who just got to enter even though the instance isn't ready.
|
| To ready.mac and here:
| June 24, 2021: Added "now" option to bypass waiting.
|                Added "me" "notme" for who enters/exits
| 				 Valid combinations are:  me, notme, now, notmenow, menow
|				 Flags for group to enter/exit the instance. Leader
|                may have entered already or want the rest the group
|                to leave. etc...
|
|------------------------------------------------------------------------------
| Task Window Information
|
| Use /windows TaskWnd to get information. These are the important vars.
|
| TaskWND
|     Task_TaskList
|     STask_MemberList
|
| ${Windows[TaskWND].Child[Task_TaskList]. MQ2 Methods go here }
| ${Windows[TaskWND].Child[STask_MemberList]
|
| Task_TaskList has the following useful columns. The list begins at row 1.
| 2 Type: Q for Quest, S for Shared Task / Mission
| 3 Name
| 4 Timer Unlimited for most quests, or a countdown timer for missions
| 5 Instanced zone name
| 
| ${Window[TaskWND].Child[Task_TaskList].List[${i},3].Equal[${name}]}
|
| Important! When obtaining a shared task, that task becomes task 1.
| If .List[1,2].Equal[S] then we know that its a shared task
| and that we can get the name of it .List[1,3] and then look up
| the zone we need to be in, the questgiver, and the trigger from
| the ini.
|
| STask_MemberList has the following useful columns, beginning at row 1.
| 1 Name
| 2 Role (Leader or blank)
|
| The leader of the task is NOT always the first in the list, we
| have to search for Leader.
|
| ${Window[TaskWND].Child[STask_MemberList].List[1].Equal[${name}]}
|
| It presently takes 45s for an instance to be ready to enter. 
|------------------------------------------------------------------------------

#bind ReadyMain /rdy

Sub Bind_ReadyMain(string P1, string P2, string P3, String P4)

	|--------------------------------------------------------------------------
	|These are the user configurable params
	|--------------------------------------------------------------------------
	|
	| Trigger word
	|
	/declare RTrigger					string		local
	|
	| Trigger delay parameters
	|
	/declare RDelayMeanSecs				int			local	6
	/declare RDelayRangeSecs			int			local	3
	|
	| Move delay parameters
	|
	/declare MDelayMeanSecs				int			local	20
	/declare MDelayRangeSecs			int			local	10
	|
	| Drop invis before trigger?
	|
	/declare DropInvis					bool		local	1
	|
	| Try to get in early? Not implemented
	|
	/declare DoTriggerEarly				bool		local	1
	/declare EDelayMeanSecs				int			local	45
	/declare EDelayRangeSecs			int			local	0

	|--------------------------------------------------------------------------
	| E.g. Given a delay mean of 15 (seconds), the routine will vary /delay by
	| a random range of +/- 10 seconds.
	|--------------------------------------------------------------------------

	|
	| We can't work without eqbcs or dannet
	|
	/if (!${Macro.IsTLO[EQBC]} && !${Macro.IsTLO[DanNet]}) {
		/echo Rdy needs EQBCS or DANNET. You must... choooooose.
	}

	|
	| Check to make sure the task window object is populated
	|
	/if (!${Window[TaskWnd].Open}) /invoke ${Window[TaskWnd].DoOpen}
	/delay 5
	
	|
	| Is there anything in the task list?
	|
    /if (!${Window[TaskWnd].Child[Task_TaskList].Children}) {
		|
		| May be slow...
		|
		/delay 5s
		/if (!${Window[TaskWnd].Child[Task_TaskList].Children}) {
			/echo Rdy could not find a task. That's a problem.
			/return
		}
    }
	|
	| No shared task instance found
	|
	/if (${Window[TaskWND].Child[Task_TaskList].List[1,2].NotEqual[S]}) {
		|
		| May be slow...
		|
		/delay 5s
		/if (${Window[TaskWND].Child[Task_TaskList].List[1,2].NotEqual[S]}) {
			/echo Rdy could not find a shared task. That's a problem.
			/return
		}
	}

	/declare RStartDelaySecs			int			local	45
	/declare TaskName					string		local	${Window[TaskWND].Child[Task_TaskList].List[1,3]}
	/declare TaskMembers				int			local	${Window[TaskWND].Child[STask_MemberList].Items}
	/declare TaskLeaderID				int			local
	/declare TaskLeader					string		local
	/declare TaskGiverID				int			local
	/declare TaskGiverName				string		local
	/declare ImTaskLeader				bool		local	0
	/declare DoItNow					int			local	0
	/declare IndividualPC				string		local
	/declare RCommand					string		local

	||| Forgot to get group together before you went in? There's an app for that.
	||| 1 everyone, 0 notme, 2 me
	/declare MeToo						int			local	1

	| Attempt to get the quest getter
	|
	| The built-in list method isnt working. Have to use a for loop.
	|/varset TaskLeaderID	${Window[TaskWND].Child[STask_MemberList].List[=Leader,2]}

	/for TaskLeaderID 1 to ${TaskMembers}
		/if (${Window[TaskWND].Child[STask_MemberList].List[${TaskLeaderID},2].Equal["Leader"]}) /break
	/next TaskLeaderID
	
	/varset TaskLeader		${Window[TaskWND].Child[STask_MemberList].List[${TaskLeaderID}]}
	/if (!${TaskLeader.Length}) {
		/echo What task? There's no task.
		/return
	}
	
	/if (${Me.Name.Equal[${TaskLeader}]}) {
		/echo I'm the taskleader. I knew that.
		/varset ImTaskLeader 1
	}
	
	| Other chars will always have the trigger word and taskgiver name. The third and fourth parameters could have a char name or the command.
	| If the leader did not supply a taskgiver name, then we use the target.

	|
	| Get params
	|
	/varset RTrigger ${P1}

	/if (!${RTrigger.Length}) {
		/echo Missing trigger word.
		/return
	}

	/while (!${ImTaskLeader}) {
		/varset TaskGiverName ${P2}	
		/if (!${TaskGiverName.Length}) {
			/echo Task giver name missing.
			/return
		}

		/if (!${P3.Length}) /break
		/varset RCommand ${P3}
		
		/if (${P3.Equal[now]}) {
			/varset DoItNow 1
		} else /if (${P3.Equal[notme]}) {
				/varset MeToo 0
		} else /if (${P3.Equal[me]}) {
			/varset MeToo 2	
		} else /if (${P3.Equal[notmenow]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P3.Equal[menow]}) {
			/varset MeToo 2
			/varset DoItNow 1
		} else /if (${P3.Equal[nownotme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P3.Equal[nowme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else {
			/varset IndividualPC ${P3}
			/varset RCommand
		}
		
		/if (!${P4.Length}) /break
		/if (!${RCommand.Length}) /varset RCommand ${P4}
		
		/if (${P4.Equal[now]}) {
			/varset DoItNow 1
		} else /if (${P4.Equal[notme]}) {
				/varset MeToo 0
		} else /if (${P4.Equal[me]}) {
			/varset MeToo 2	
		} else /if (${P4.Equal[notmenow]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P4.Equal[menow]}) {
			/varset MeToo 2
			/varset DoItNow 1
		} else /if (${P4.Equal[nownotme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P4.Equal[nowme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else {
			/varset IndividualPC ${P4}
		}
		
		/break
	}

	/while (${ImTaskLeader}) {
		/if (${Spawn["${P2}"].ID}) {
			/varset TaskGiverName ${P2}
			/varset P2
		} else {
			/varset TaskGiverName ${Target.CleanName}
			/call IsFriendly ${Target.ID}
			/if (${Macro.Return.Equal[FRIENDLY]}) {
				/echo You targeted someone in your group.
				/return
			}
		}
		/if (!${Spawn["${TaskGiverName}"].ID}) {
			/echo Task giver not found.
			/return
		}

		/if (!${P2.Length}) {
			/varset P2 ${P3}
			/varset P3 ${P4}
			/varset P4
		}

		/varset RCommand ${P2}
		/if (!${P2.Length}) /break
		
		/if (${P2.Equal[now]}) {
			/varset DoItNow 1
		} else /if (${P2.Equal[notme]}) {
			/varset MeToo 0
		} else /if (${P2.Equal[me]}) {
			/varset MeToo 2	
		} else /if (${P2.Equal[notmenow]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P2.Equal[menow]}) {
			/varset MeToo 2
			/varset DoItNow 1
		} else /if (${P2.Equal[nownotme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P2.Equal[nowme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else {
			/varset MeToo 0
			/varset IndividualPC ${P2}
			/varset RCommand
		}
		
		/if (!${P3.Length}) /break
		/if (!${RCommand.Length}) /varset RCommand ${P3}

		/if (${P3.Equal[now]}) {
			/varset DoItNow 1
		} else /if (${P3.Equal[notme]}) {
				/varset MeToo 0
		} else /if (${P3.Equal[me]}) {
			/varset MeToo 2	
		} else /if (${P3.Equal[notmenow]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P3.Equal[menow]}) {
			/varset MeToo 2
			/varset DoItNow 1
		} else /if (${P3.Equal[nownotme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P3.Equal[nowme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else {
			/varset MeToo 0
			/varset IndividualPC ${P3}
			/varset RCommand
		}

		/if (!${P4.Length}) /break
		/if (!${RCommand.Length}) /varset RCommand ${P4}

		/if (${P4.Equal[now]}) {
			/varset DoItNow 1
		} else /if (${P4.Equal[notme]}) {
				/varset MeToo 0
		} else /if (${P4.Equal[me]}) {
			/varset MeToo 2	
		} else /if (${P4.Equal[notmenow]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P4.Equal[menow]}) {
			/varset MeToo 2
			/varset DoItNow 1
		} else /if (${P4.Equal[nownotme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else /if (${P4.Equal[nowme]}) {
			/varset MeToo 0
			/varset DoItNow 1
		} else {
			/varset MeToo 0
			/varset IndividualPC ${P4}
			/varset RCommand
		}
		
		/break
	}

	|/echo TaskLeader ${TaskLeader} Trigger Word ${RTrigger} Task Giver ${TaskGiverName} MeToo ${MeToo} Now ${DoItNow} Individual PC ${IndividualPC}

	/if (${ImTaskLeader}) {
		/if (!${MeToo} && !${IndividualPC.Length}) /echo Sending the group
		/if (!${MeToo} && ${IndividualPC.Length}) /echo Sending ${IndividualPC}
				
		||| 1 everyone, 0 notme, 2 me
		/if (${MeToo}<2) {
		
			/if (!${IndividualPC.Length}) {
				|
				| Sends message to all other clients
				|
				/if (${Macro.IsTLO[EQBC]}) {
					/bca //rdy "${RTrigger}" "${TaskGiverName}" ${RCommand}
				} else /if (${Macro.IsTLO[DanNet]}) {
					/dgexecute //rdy "${RTrigger}" "${TaskGiverName}" ${RCommand}
				} else {
					/echo EQBCS or DANNET are required. You must... choooooose.
					/return
				}
			} else {
				|
				| Sends message to one PC
				|
				/if (${Macro.IsTLO[EQBC]}) {
					/bct ${IndividualPC} //rdy "${RTrigger}" "${TaskGiverName}" ${RCommand}
				} else /if (${Macro.IsTLO[DanNet]}) {
					/dtell ${IndividualPC} //rdy "${RTrigger}" "${TaskGiverName}" ${RCommand}
				} else {
					/echo EQBCS or DANNET are required. You must... choooooose.
					/return
				}			
			}
		}
		
		||| If notme, I'm done. Ive sent the message.
		/if (!${MeToo}) /return
		
	} else {
		/echo ${TaskLeader} is leading ${TaskName}
		/if (!${TaskGiverName.Length}) {
			/squelch /target clear
			/delay 3
			/assist ${TaskLeader}
			/delay 3
			/varset TaskGiverName ${Target.Name}
			/if (!${Target.ID}) {
				/echo Couldn't target the task giver!
				/return
			}
		} else {
			/squelch /target clear
			/delay 3
			/target ${TaskGiverName}
			/delay 3
			/if (!${Target.ID}) {
				/echo Couldn't target the task giver!
				/return
			}
		}
	}
	
	/echo The trigger to say to ${TaskGiverName} is ${RTrigger}

	| Move if we have to
	|
	| Maybe move to the location of the task leader, then assist / fine tune position.
	| What we could do is assist now, and if we get a target, just go straight to the
	| taskgiver.
	
	/if (!${ImTaskLeader} && !${Target.ID} && ${Int[${Spawn[=${TaskLeader}].Distance}]}>25) {
		/echo I need to get closer. Going to move to the task leader. Pausing first if I need to.
		/call RDelay ${MDelayMeanSecs} ${MDelayRangeSecs} ${DoItNow}
		/call NavToWhom ${TaskLeader}
		/assist ${TaskLeader}
	}
	/if (${Target.ID} && ${Int[${Spawn["${TaskGiverName}"].Distance}]}>25) {
		/echo I need to get closer to the task giver. Pausing first if I need to.
		/call RDelay ${MDelayMeanSecs} ${MDelayRangeSecs} ${DoItNow}
		/call NavToWhom ${TaskGiverName}
	}
	/if (!${Target.ID}) {
		/echo Something went wrong. I either lost, or can't target, the task giver.
		/return
	}

	|
	| Say the magic word
	|
	/call CockTheHammer ${RStartDelaySecs}
	|
	| Almost there!
	|
	/call RDelay ${RDelayMeanSecs} ${RDelayRangeSecs} ${DoItNow}
	|
	| Make sure we havent drifted.
	|
	/call NavToWhom ${TaskGiverName}
	|
	| The user should decide whether their chars go in invised or not, im making vis so it just works right away.
	|
	/if (${DropInvis}) {
		/makemevis
		/delay 5
	}
	/if (!${TaskGiverName.Find[${Target.CleanName}]}) /target ${TaskGiverName}
	/call PullTheTrigger ${RTrigger}

/return

Sub	NavToWhom (GoToWhom)
	| If the NPC is on the move, wait.
	/if (${Spawn["${GoToWhom}"].Moving}) {
		/echo ${GoToWhom} is on the move. Waiting for them to stop.
	}
	/while (${Spawn["${GoToWhom}"].Moving}) {
		/delay 3
	}
	/if (${Int[${Spawn["${GoToWhom}"].Distance}]}<25) /return
	/squelch /nav spawn ${GoToWhom} distance=20
	/delay 1s
	/while (${Me.Moving}) {
		/delay 3
	}
/return

Sub RDelay(MeanSec,RangeSec,DoItNow)
	/if (${DoItNow}) /return
	/declare Duration		int		local
	/varcalc Duration ${MeanSec}-${Math.Rand[${RangeSec}]}+${Math.Rand[${RangeSec}]}
	/echo Pausing ${Duration}s before the next action.
	/delay ${Duration}s
/return

Sub CockTheHammer(DelaySecs)
	|
	| We need to get the time from the task and see how much has elapsed.
	| 
	|
	| Sometimes the player should try to trigger early!
	| Sometimes the player should trigger early a couple of times.
	|
	/declare Countdown			string	local
	/declare Time1				int		local
	/declare Time2				int		local
	/declare Time3				int		local
	/declare Elapsed			int		local
	/declare SecondsLeft		int		local
	/declare TriggerSecs		int		local
	
	/varset Countdown		${Window[TaskWND].Child[Task_TaskList].List[1,4]}
	
	|
	| We might be given HRS:MINS:SECS, or potentially MINS:SECS. Let's find out.
	|
	/varset Time1			${Countdown.Arg[1,:]}
	/varset Time2  			${Countdown.Arg[2,:]}
	/varset Time3			${Countdown.Arg[3,:]}
	
	|
	| If you start a timer at 60:00, after 1 sec it will read 59:59.
	| If you want to estimate how long it lasts, just do (59+1)*60
	| If the timer reads 6:00:00, after 1s it reads 5:59:59... same deal
	| take the (Hrs+1)*3600
	|
	
	/if (!${Time3}) {
		/varcalc SecondsLeft	${Time1}*60+${Time2}
		/varcalc Elapsed ((${Time1}+1)*60)-${SecondsLeft}
	} else {
		/varcalc SecondsLeft	${Time1}*3600+${Time2}*60+${Time3}
		/varcalc Elapsed ((${Time1}+1)*3600)-${SecondsLeft}
	}
	|
	| Delay the amount needed for the instance to be ready. If
	| It is ready, then proceed with the next step.
	|
	/delay 5
	/if (${Elapsed}<${DelaySecs}) {
		/varcalc TriggerSecs	${DelaySecs}-${Elapsed}
		/echo Pausing ${TriggerSecs}s while the instance is being prepared.
		|
		| Do we wait some and hail early? Add that here. For now, just do basic wait.
		|
		/delay ${TriggerSecs}s
	}
	
/return

Sub PullTheTrigger(TriggerWord)
	/say ${TriggerWord}
/return

|
| Not implemented
|
Sub EarlyBlurt(TriggerWord)
	|
	| % chance that a char will say the trigger early
	|
	/declare EarlyChanceCutoff	int		local	40
	/declare EarlyChance		int		local	${Math.Rand[100]}
	
	/if (${EarlyChance}<${EarlyChanceCutoff}) {
		/call PullTheTrigger ${TriggerWord}
	}
/return
	