| -------------------------------------------------------------------------------------------------
| SUB:Bind_AKABuff 
| ------------------------------------------------------------------------------------------------- 
    Sub Bind_AKABuff(string CharName)
        /if (!${BuffsOn}) /return

		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS Bind_AKABuff: Enter CharName ${CharName}

        /declare CharID     int     local 0

        /if (${CharName.Length} && ${CharName.NotEqual[NULL]}) {
            /varset CharID ${Spawn[=${CharName}].ID}
            | If not found, probably a pet.
            /if (!${CharID}) /varset CharID ${Spawn[${CharName} pet].ID}
        } else {
            /echo \awAKA: \ayCharacter name not provided.
            /return
        }

        /if (!${CharID}) {
            /echo \awAKA: \ayCharacter ${CharName} not found.
            /return
        }

        /varset SubParamsCache[1] 0 ${CharID}
        POPCALL
        DEBUGBUFFS Bind_AKABuff: Leave

    /return


| ----------------------------------------------------------------------------
| SUB: BuffGroup
| ----------------------------------------------------------------------------
    Sub Bind_BuffGroup(int Flag1)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS Bind_BuffGroup: Enter ${Flag1}
        /if (!${Flag1}) {
            /if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
                /bcg //buffgroup 1
            } else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
                /dgge /buffgroup 1
            } else {
                /echo BuffGroup Command requires MQ2EQBC/MQ2DanNet.
            }
        }
        /if (${BuffsOn}) {
            /varset ReadBuffsTimer 0
            /varset IniNextTimer 0
            | Load the params
            /varset SubParamsCache[1] 1 0
        }
		POPCALL
        DEBUGBUFFS Bind_BuffGroup: Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Buff List
| ----------------------------------------------------------------------------
    Sub Bind_TooBuffList(string Action, int ActionID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGBUFFS TooBuffList: Enter
        /declare WorkOnID int local ${Int[${ActionID}]}
        /declare WorkOnName string local
        /declare j1 int local 0
        /declare PeersZone string local
        /if (!${WorkOnID}) /varset WorkOnID ${Target.ID}
        DEBUGBUFFS TooBuffList: Action: ${Action} ActionID: ${ActionID} WorkOnID: ${WorkOnID}
        /if (!${WorkOnID} && ${Select[${Action},add,remove]}>0) {
            /echo Invalid ID. Please target a Character or use a proper ID.
            /return
        }
        /varset WorkOnName ${Spawn[id ${WorkOnID}].CleanName}
        /if (!${Action.Length} || ${Action.Equal[null]} || ${Select[${Action},add,remove,list,reset,clear]}==0) {
            /echo Invalid Action for Too Buff List, please use add, remove, list, reset or clear.
            /return
        }
        /if (${Action.Equal[reset]}) {
            /if (${ExtendedBuffList.Count[|]}>0) {
                /varset j1 1
                /while (${ExtendedBuffList.Arg[${j1},|].Length} && ${ExtendedBuffList.Arg[${j1},|].NotEqual[null]}) {
                    /if (!${Spawn[=${ExtendedBuffList.Arg[${j1},|]}].ID}) {
                        /echo Removed ${ExtendedBuffList.Arg[${j1},|]} from the Too Buff List.
                        /varset ExtendedBuffList ${ExtendedBuffList.Replace[${ExtendedBuffList.Arg[${j1},|]}|,]}
                    } else {
                        /varcalc j1 ${j1}+1
                    }
                }
            }
        } else /if (${Action.Equal[list]}) {
            /echo ExtendedBuffList: ${ExtendedBuffList}
        } else /if (${Action.Equal[remove]}) {
            /if (${ExtendedBuffList.Find[${WorkOnName}|]}) {
                /varset ExtendedBuffList ${ExtendedBuffList.Replace[${WorkOnName}|,]}
                /echo Removed ${WorkOnName} from Too Buff List.
            } else {
                /echo ${WorkOnName} Not Found on the Too Buff List.
            }
        } else /if (${Action.Equal[clear]}) {
            /echo Too Buff List Cleared.
            /varset ExtendedBuffList
        } else {
            /if (${ExtendedBuffList.Count[|]}>49) {
                /echo There is a limit of 50 ID's. Please remove some before trying to add more.
                /return
            }
            /if (${ExtendedBuffList.Find[${WorkOnName}|]}) {
                /echo ${WorkOnName} Found on Too Buff List. No Need to add again.
                /return
            }
            /if (${Macro.IsTLO[DanNet]} && ${DanNetOn}) {
                |/if (${DanNet.Peers[all].Find[${WorkOnName}|]}) {
                /if (${Zone.ShortName.Find[_]}) {
                    /varset PeersZone zone_${Zone.ShortName}
                } else {
                    /varset PeersZone zone_${EverQuest.Server.Lower}_${Zone.ShortName}
                }
                /if (${DanNet.Peers[${PeersZone}].Find[${WorkOnName}|]}) {
                    /echo ${WorkOnName} Found on DanNet Peers[${PeersZone}] List. No Need to add.
                    /return
                }
            }
            /varset ExtendedBuffList ${ExtendedBuffList}${WorkOnName}|
            /Echo Added ${WorkOnName} to the Too Buff List.
        }
        /varset g_ExtendedBuffList ${ExtendedBuffList}
        DEBUGBUFFS TooBuffList: Exit
    /return

| -------------------------------------------------------------------------------------
| SUB: BuffOnce
| -------------------------------------------------------------------------------------
    Sub BuffOnce(OnceSpell, int CondNumber)
        /if (${Me.Invis}) /return
        /declare OnceResult string local FALSE
		/if (!${CondNumber} || ${If[${Cond[${CondNumber}]},1,0]}) {
            /call CastWhat "${OnceSpell}" ${Me.ID} BuffOnce 0 0 FROMHERE
            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                /varset OnceResult TRUE
            } else {
                /varset OnceResult ${Macro.Return}
            }
        }
    /return ${OnceResult}
	
| ----------------------------------------------------------------------------
| SUB: Cast Buffs Spell Check
| ----------------------------------------------------------------------------
    Sub CastBuffsSpellCheck(SpellToCheck, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastBuffsSpellCheck \awEnter from ${FromWhere}
        /declare i int local
        /declare k int local
        /declare numEffects int local
        /delay 5s ${Target.BuffsPopulated}
        | If spell is already on target skip
        /if (${Target.Buff[${SpellToCheck}].ID}) {
            DEBUGCAST \at The spell ${SpellToCheck} is already on the target.
			POPCALL
            |/return TRUE
            /return ${Target.BuffDuration[${SpellToCheck}].TotalSeconds}
            | Does buff have children spells like Unified Hand of Assurance or Talisman of the Wulthan
        } else /if (${Spell[${SpellToCheck}].HasSPA[374]} || ${Spell[${SpellToCheck}].HasSPA[340]}) {
            /varcalc numEffects ${Spell[${SpellToCheck}].NumEffects}
            /for k 1 to ${numEffects}
                | Double check spell attrib to make sure it has children spells
                /if (${Spell[${SpellToCheck}].Attrib[${k}]} == 374 || ${Spell[${SpellToCheck}].Attrib[${k}]} == 340) {
                    | If child spell is already on target skip
                    /if (${Target.Buff[${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].Name}].ID}) {
                        DEBUGCAST \at${k} BuffSpellCheck: The spell ${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].Name} is already on the target.
						POPCALL
                        |/return TRUE
                        /return ${Target.BuffDuration[${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].Name}].TotalSeconds}
                    }
                }
            /next k
            |If spell doesn't stack with targets buffs skip
            /for k 1 to ${numEffects}
                | Double check spell attrib to make sure it has children spells
                /if (${Spell[${SpellToCheck}].Attrib[${k}]} == 374 || ${Spell[${SpellToCheck}].Attrib[${k}]} == 340) {
                    | If  spell doesn't stack with target buff skip
                    /for i 1 to 85
                        /if (${Target.Buff[${i}].Name.Length}) {
                            /if (!${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].WillStack[${Target.Buff[${i}]}]}) {
                                DEBUGCAST \at${i} ${k} BuffSpellCheck: The spell ${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].Name} does not stack with ${Target.Buff[${i}].Name} on the target.
								POPCALL
                                |/return TRUE
                                /return ${Target.BuffDuration[${i}].TotalSeconds}
                            }
                        }
                    /next i
                }
            /next k
        } else /if (${AltAbility[${SpellToCheck}].Spell.Trigger.ID}) {
            /if (${Target.Buff[${AltAbility[${SpellToCheck}].Spell.Trigger.Name}].ID}) {
                DEBUGCAST \at The spell ${SpellToCheck}(${AltAbility[${SpellToCheck}].Spell.Trigger}) is already on the target.
				POPCALL
                |/return TRUE
                /return ${Target.BuffDuration[${AltAbility[${SpellToCheck}].Spell.Trigger.Name}].TotalSeconds}
            }
        } else {
            /for i 1 to 85
                /if (${Target.Buff[${i}].Name.Length}) {
                    /if (!${Spell[${SpellToCheck}].WillStack[${Target.Buff[${i}]}]}) {
                    DEBUGCAST \at${i} The spell ${SpellToCheck} does not stack with ${Target.Buff[${i}].Name} on the target.
						POPCALL
                        |/return TRUE
                        /return ${Target.BuffDuration[${i}].TotalSeconds}
                }
            }
			/next i
        }
		POPCALL
        DEBUGCAST CastBuffsSpellCheck \awLeave
    /return FALSE

| -------------------------------------------------------------------------------------
| SUB: Cast Mana
| -------------------------------------------------------------------------------------
    Sub CastMana(string SentFrom)
        /if (${Me.Invis}) /return		
		/varset CheckCastManaTimerOn ${CheckCastManaTime}s

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS CastMana Enter ${SentFrom}
		
        /declare i int local
        /declare CondNo int local 0
        /for i 1 to ${Buffs.Size}
            /if (${Buffs[${i}].Find[|0]} || ${Buffs[${i}].Equal[null]}) /continue
            /if (${Select[${Buffs[${i}].Arg[2,|]},mana,managroup]}==0) /continue
            /if (${ConOn} && ${Buffs[${i}].Find[|cond]}) {
                /varset CondNo ${Buffs[${i}].Mid[${Math.Calc[${Buffs[${i}].Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }
            | Check and Cast mana type spells/aas/items - Canni/Paragon/Harvest - prevent toon from using before rez after zoning for 2 min
            /if (${Buffs[${i}].Arg[2,|].Equal[Mana]} && !${Me.Buff[Revival Sickness].ID} && !${JustZoned}) {
                /if (${Buffs[${i}].Arg[1,|].Equal[Dichotomic Psalm]} && (${IAmABard} || ${Me.CurrentEndurance}<6600)) /continue
                /if (${Me.PctMana}<=${Buffs[${i}].Arg[3,|]} && ${Me.PctHPs}>${Int[${Buffs[${i}].Arg[4,|]}]}) {
                    /if (${Cursor.ID}) /call CheckCursor CastMana 0
                    DEBUGBUFFS Canni/Paragon/Harvest
                    /call CastWhat "${Buffs[${i}].Arg[1,|]}" ${Me.ID} CastMana ${CondNo} 0 FROMHERE
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                        /echo Casting >> ${Buffs[${i}].Arg[1,|]} << for mana
                        /if (${AggroTargetID}) /break
                    }
                }
            } else /if (${Buffs[${i}].Arg[2,|].Equal[Managroup]} && (!${Medding} || (!${MedCombat} && ${Medding}))) {
                /call RegenOther "${Buffs[${i}].Arg[1,|]}" Mana ${Buffs[${i}].Arg[3,|]} 0 ${CondNo} FROMHERE
            }
        /next i
		POPCALL
        DEBUGBUFFS CastMana Leave ${SentFrom}
    /return

| -------------------------------------------------------------------------------------
| SUB: Cast Mount
| -------------------------------------------------------------------------------------
    Sub CastMount
        /if (${Me.Mount.ID} || !${MountOn} || (${Me.Drunk}>60) || (${HealsOn} && ${AggroTargetID}) || !(${Zone.Outdoor} || ${Select[${Zone.Type},1,2,5]})) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare i int local
        /for i 1 to ${Buffs.Size}
			| Cast mount
			/if (${Buffs[${i}].Arg[2,|].Equal[Mount]} && !${Buffs[${i}].Find[0]} && !${Me.Mount.ID} && !${Attacking} && ${MountOn} && !${Me.FeetWet}) {
				DEBUGBUFFS CheckBuffs Mount
					/if (${ConOn} && ${Buffs[${i}].Find[|cond]} && ${If[${Cond[${Buffs[${i}].Mid[${Math.Calc[${Buffs[${i}].Find[|cond]}+5]},3]}]},0,1]}) /continue
					/call CastWhat "${Buffs[${i}].Arg[1,|]}" ${Me.ID} CastMount 0 0 FROMHERE
				/delay 1s
				/if (${Macro.Return.Equal[CAST_NOMOUNT]}) /varset MountOn 0
			}
        /next i
		POPCALL
    /return

| -------------------------------------------------------------------------------------
| SUB: CheckAura | Check if aura is up
| -------------------------------------------------------------------------------------
    Sub CheckAura(AuraSpell, int CondNumber, string FromWhere)
        /if (${Me.Invis}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS CheckAura Enter from ${FromWhere} - Spell: ${AuraSpell}
        /declare AuraName string local
        /declare TempAura string local
        /declare AuraResult string local FALSE
        | Strip the Rk II/III out of the spell to check against aura window
        /if (${AuraSpell.Find[ Rk.]}) {
            /varset AuraName ${AuraSpell.Left[${Math.Calc[${AuraSpell.Find[ Rk.]}-1]}]}
        } else {
            /varset AuraName ${AuraSpell}
        }
        /if (${AuraSpell.Find[Disciple's Aura]}) {
        | Correct typo from SOE in monks 55 level aura
            /varset AuraName Disciples Aura
        } else /if (${Me.Class.Name.Equal[cleric]} && ${AuraSpell.Find[Reverent]}) {
            | Cleric exception for Reverent Aura
            /varset AuraName Reverent Aura
        |} else /if (${AuraSpell.Find[Mana Reverberation]} || ${AuraSpell.Find[Mana Repercussion]} || ${AuraSpell.Find[Mana Reiteration]}) {
        } else /if (${AuraSpell.Find[Mana Reiteration]}) {
            /varset AuraName Mana Recursion Aura
        } else /if (${AuraSpell.Find[Mana Reiterate]}) {
            /varset AuraName Mana Reiterate Aura
        } else /if (${AuraSpell.Find[Mana Reverberation]}) {
            /varset AuraName Mana Rev.
        } else /if (${AuraSpell.Find[Mana Resurgence]}) {
            /varset AuraName Mana Resurgence Aura
        } else /if (${AuraSpell.Find[Mana Repercussion Aura]}) {
            /varset AuraName Mana Rep. Aura
        } else /if (${AuraSpell.Find[Runic Radiance Aura]}) {
            /varset AuraName Runic Rad. Aura
        } else /if (${AuraSpell.Find[Arcane Distillect]}) {
            | Mage exceptions because aura is on pet not in aura window and other fucked up shit
            /varset TempAura Arcane Distillect
        } else /if (${AuraSpell.Find[Earthen Strength]}) {
            /varset TempAura Earthen Strength Effect
        } else /if (${AuraSpell.Find[Rathe's Strength]}) {
            /varset TempAura Rathe's Strength Effect
        }
        | Check if aura is up 4 parts - Mage | Everyone else | 2 auras cleric | 2 auras enchamter
        /if (${Select[${Me.Class.ShortName},CLR,ENC,MAG]}==0 && ${Me.Aura[1].Name.Find[${AuraName}]}) {
			POPCALL
            /return ${AuraResult}
        } else /if (${Me.Class.ShortName.Equal[MAG]} && ${Pet.ID} && ${Pet.Distance}<175) {
            /if (${Me.Aura[1].Name.Find[${TempAura}]}) {
				POPCALL
                /return ${AuraResult}
            } else /if (${Me.PetBuff[${TempAura}]}) {
				POPCALL
                /return ${AuraResult}
            }
        } else /if (${Select[${Me.Class.ShortName},CLR,ENC]} && (${Me.Aura[1].Name.Find[${AuraName}]} || ${Me.Aura[2].Name.Find[${AuraName}]})) {
			POPCALL
            /return ${AuraResult}
        }
        DEBUGBUFFS CheckAura Aura
        | - Mutant Bards do this. Not any more.
        /if (!${CondNumber} || ${If[${Cond[${CondNumber}]},1,0]}) {
            | - Normal casting
            /if (${Select[${Me.Class.ShortName},BER,MNK,ROG,WAR]} && ${Me.CurrentEndurance}>500) {
                /disc ${AuraSpell}
                /delay 10
                /while (${Me.Casting.ID} && ${Window[CastingWindow].Open}) {
                    /delay 5
                }
                /varset AuraResult TRUE
				POPCALL
                /return ${AuraResult}
            } else {
                /varset DontMoveMe 1
                /call CastWhat "${AuraSpell}" ${Me.ID} CheckAura 0 0 FROMHERE
                /varset DontMoveMe 0
                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                    /echo Casting Aura >> ${AuraSpell} <<
                    /varset AuraResult TRUE
                } else {
                    /varset AuraResult ${Macro.Return}
                }
            }
        }
		POPCALL
    /return ${AuraResult}

|-----------------------------------------------------------------------------
| SUB: Check Begged for buffs
| ----------------------------------------------------------------------------
    Sub CheckBegforBuffs(string FromWhere)
        /if (${Me.Invis}) /return
        /if (!${KABegForList.Length}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare WNWAll    string local
        /declare WNWPart1  string local
        /declare WNWPart2  string local
        /declare WNWPart3  string local
        /declare WNWx      int    local 1
        /declare WNWSpellType string local
        /declare BuffToCast   string local
        DEBUGBUFFS CheckBegForBuffs: Enter from ${FromWhere}
        /while (1) {
            /varset WNWAll ${KABegForList.Arg[${WNWx},|]}
            /if (!${WNWAll.Length} || ${WNWAll.Equal[null]}) {
                /if (!${KABegForList.Length} || ${KABegForList.Equal[null]}) /varset KABegActive 0
                /break
            }
            /varset WNWPart1 ${WNWAll.Arg[1,:]}
            /varset WNWPart2 ${WNWAll.Arg[2,:]}
            /varset WNWPart3 ${WNWAll.Arg[3,:]}
            DEBUGBUFFS CheckBegForBuffs: ${WNWAll} - ${Me.Invis}
            /if (${Me.Invis}) /break
            /varset BuffToCast ${Buffs[${WNWPart3}].Arg[1,|]}
            /if (${Me.Book[${BuffToCast}]}) {
                /varset WNWSpellType ${Spell[${BuffToCast}].TargetType}
            } else /if (${Me.AltAbility[${BuffToCast}]}) {
                /varset WNWSpellType ${Me.AltAbility[${BuffToCast}].Spell.TargetType}
            } else {
                /varset WNWSpellType self
            }
            DEBUGBUFFS CheckBegForBuffs: ${BuffToCast} - ${WNWSpellType}
            /if (${WNWSpellType.NotEqual[self]}) {
                /call CastWhat "${BuffToCast}" ${Spawn[PC ${WNWPart2}].ID} Buffs 0 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_SUCCESS]} || ${Macro.Return.Equal[CAST_RECOVER]}) {
                    /call RemoveFromBegList "${WNWAll}" ${WNWx} "${WNWSpellType}"
                } else /if (${Macro.Return.Equal[CAST_CANCELLED]}) {
                    /break
                } else {
                    /varcalc WNWx ${WNWx}+1
                }
            } else {
                /call RemoveFromBegList "${WNWAll}" ${WNWx} "self"

            }
        }
		POPCALL
        DEBUGBUFFS CheckBegForBuffs: Leave 
    /return

| -------------------------------------------------------------------------------------
| SUB: CheckBuffs
| -------------------------------------------------------------------------------------
    Sub CheckBuffs(int ForceGroup, int CharID, string FromWhere)
        /if (${Me.Moving} || !${BuffsOn} || ${IAmDead} || ${Me.Hovering} || (${Me.Invis} && ${Me.Class.Name.NotEqual[Rogue]}) || (${ChaseAssist} && ${Me.Moving}) || (${Me.Moving} && ${WhoToChase.Equal[${Me}]})) /return
		/varset CheckBuffsTimerOn ${CheckBuffsTimer}s
		|
		| Enough with the premature buffing and to those about to be rezzed again.
		|
		/if (${HoldBuffsRezzing}) /return
		|
		| Make sure the char has stopped moving
		|
		/call LastMove FROMHERE	
		/if (!${ForceGroup} && !${CharID} && ${TimeSinceMove}<10) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        | Reset parameter cache
        /varset SubParamsCache[1] |

        DEBUGBUFFS CheckBuffs CheckBuffs: Enter from ${FromWhere} ForceGroup ${ForceGroup} CharID ${CharID}
        /declare i                int     local 0
        /declare j                int     local 0
        /declare k                int     local 0
        /declare l                int     local 0
        /declare FullText         string  local 0
        /declare 2ndPart          string  local 0
        /declare 3rdPart          string  local 0
        /declare 4thPart          string  local 0
        /declare 5thPart          string  local 0
        /declare 6thPart          string  local 0
        /declare 7thPart          string  local 0
        /declare SpellRange       int     local 0
        /declare SpellToCast      string  local null
        /declare MATargetID       int     local 0
        /declare i_TargetID       int     local 0
        /declare BookSpellTT      string  local 0
        /declare BuffToCheck      string  local null
        /declare CondNo           int     local 0
        /declare PeersZone        string  local
        /declare CurrentID        int     local
		
		|
		| If we just died, we are first going to cast priority spells. We will allow 3 passes through before resuming normal buffing.
		|
		/declare PriorityFlag	  int	  local	0		
		/if (!${Me.Combat} && (${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID}) && ${PriorityBuffsDone}<3) {
			/if (${Me.PctMana}<10) {
				POPCALL
				/return
			}
			/for i 1 to ${Buffs.Size}
				/if (${Buffs[${i}].Find[|Priority]} && !${Buffs[${i}].Find[|0]}) {
					/varset PriorityFlag 1
					/break
				}
			/next i
		}
		
        /if (${PowerSource.NotEqual[NULL]} && ${Bool[${Me.Inventory[powersource].Name.Length}]} && !${Me.Inventory[powersource].Power}) {
           /call CheckCursor CheckBuffs0 0
           /nomodkey /itemnotify "${PowerSource}" leftmouseup
           /delay 5s ${Cursor.ID}
           /if (${Cursor.Name.Equal[${PowerSource}]}) /destroy
           /delay 5s ${Cursor.Equal[Null]}
        }
        |--------- Change to add Zone.Outdoor TLO and specific Zone.Type to stop mount cast spam.
        /if (${MountOn} && !${Me.Mount.ID} && ${Me.Drunk}<60 && (${Zone.Outdoor} || ${Select[${Zone.Type},1,2,5]}) && ${Me.CombatState.NotEqual[COMBAT]}) /call CastMount
        | Call Buffs Array
        /if (${Zone.ShortName.Find[_]}) {
            /varset PeersZone zone_${Zone.ShortName}
        } else {
            /varset PeersZone zone_${EverQuest.Server.Lower}_${Zone.ShortName}
        }
		
        /for i 1 to ${Buffs.Size}
			DEBUGBUFFS CheckBuffs: Top of For Loop Buffs ${Buffs.Size} Index ${i} Buff ${Buffs[${i}]}
            /if (${Me.Invis}) {
                POPCALL
                /return
            }
			/call CheckBeforeCast CheckBuffs FROMHERE
            | Check for combat and skip redundant subs called in combat routines.
            /if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0 FROMHERE
            /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
				POPCALL
				/return
			}
            /if (${ChaseAssist} && !${CombatStart}) /call DoWeChase FROMHERE
			
			|
			| Priority buffs first after resurrection
			|
			/if (${PriorityFlag} && !${Buffs[${i}].Find[|Priority]}) /continue
			
			|
			| Moved this to top. The filter doesn't seem to be working right if something is nulled while within the loop; it keeps going to other chars. I added an empty condition.
			| Why isn't the null being picked up? I don't think it's case sensitive?
			|
            | If Buffs=NULL, empty or with |0 skip to next buff
            /if (!${Buffs[${i}].Length} || ${Buffs[${i}].Equal[null]} || ${Buffs[${i}].Find[|0]}) {
				DEBUGBUFFS CheckBuffs: Skipping Buff${i} set to ${Buffs[$i]}
				/continue
			}		
            DEBUGBUFFS CheckBuffs: Evaluating parts of Buff${i}: ${Buffs[${i}]}
            | Check for spells with 2 parts such as Exigent Focusing Rk. II,Talisman of Soul's Unity Rk. II - Set Buffs to the buff
            /if (${Buffs[${i}].Arg[2,|].Length}) {
                /varset FullText ${Buffs[${i}]}
                /varset SpellToCast ${Buffs[${i}].Arg[1,|]}
                /varset 2ndPart ${Buffs[${i}].Arg[2,|]}
                /varset 3rdPart ${Buffs[${i}].Arg[3,|]}
                /varset 4thPart ${Buffs[${i}].Arg[4,|]}
                /varset 5thPart ${Buffs[${i}].Arg[5,|]}
                /if (${2ndPart.Equal[Dual]}) {
                    /if (${4thPart.Equal[MA]}) {
                        /varset 2ndPart DualMA
                    } else /if (${4thPart.Equal[melee]}) {
                        /varset 2ndPart DualMelee
                    } else /if (${4thPart.Equal[caster]}) {
                        /varset 2ndPart DualCaster
                    } else /if (${4thPart.Equal[class]}) {
                        /varset 2ndPart DualClass
                    } else /if (${4thPart.Equal[!class]}) {
                        /varset 2ndPart Dual!Class
                    } else /if (${4thPart.Equal[mgb]}) {
                        /varset 2ndPart DualMgb
                    } else /if (${4thPart.Equal[me]}) {
                        /varset 2ndPart Dualme
                    } else /if (${4thPart.Equal[mapet]}) {
                        /varset 2ndPart DualMAPet
                    } else /if (${4thPart.Equal[pet]}) {
                        /varset 2ndPart DualPet
                    }
                } else /if (${2ndPart.Equal[class]}) {
                    /varset 5thPart ${3rdPart}
                } else /if (${2ndPart.Equal[!class]}) {
                    /varset 5thPart ${3rdPart}
                } else /if (${2ndPart.Equal[alias]}) {
                    /continue
                }
            } else {
                /varset FullText ${Buffs[${i}]}
                /varset SpellToCast ${Buffs[${i}]}
                /varset 2ndPart
                /varset 3rdPart
                /varset 4thPart
                /varset 5thPart
            }
            /if (${Me.Subscription.NotEqual[gold]}) {
                /if (${Select[${2ndPart},Dual,DualMA,DualMelee,DualCaster,DualClass,Dual!Class,DualMgb,Dualme]}==0) {
                    /if (${SpellToCast.Find[ Rk.]}) {
                        /varset BuffToCheck ${SpellToCast.Left[${Math.Calc[${SpellToCast.Find[ Rk.]}-1]}]}
                    } else {
                        /varset BuffToCheck ${SpellToCast}
                    }
                } else {
                    /if (${3rdPart.Find[ Rk.]}) {
                        /varset BuffToCheck ${3rdPart.Left[${Math.Calc[${3rdPart.Find[ Rk.]}-1]}]}
                    } else {
                        /varset BuffToCheck ${3rdPart}
                    }
                }
            } else {
                /if (${Select[${2ndPart},Dual,DualMA,DualMelee,DualCaster,DualClass,Dual!Class,DualMgb,Dualme,DualMAPet,DualPet]}==0) {
                    /varset BuffToCheck ${SpellToCast}
                } else {
                    /varset BuffToCheck ${3rdPart}
                }
            }
            DEBUGBUFFS CheckBuffs 1st:${SpellToCast} 2nd: ${2ndPart} 3rd: ${3rdPart} ${BuffToCheck} 4th: ${4thPart}
            /if (${Me.Book[${SpellToCast}]}) {
                /varset BookSpellTT ${Spell[${Me.Book[${Me.Book[${SpellToCast}]}].ID}].TargetType}
            } else {
                /varset BookSpellTT 0
            }
            /if (${Int[${Spell[${SpellToCast}].Range}]}>=${Int[${Spell[${SpellToCast}].AERange}]}) {
                /varset SpellRange ${Spell[${SpellToCast}].Range}
            } else {
                /varset SpellRange ${Spell[${SpellToCast}].AERange}
            }
            /if (!${SpellRange}) /varset SpellRange 100
            DEBUGBUFFS CheckBuffs ${i} 1st: ${SpellToCast} 2nd: ${2ndPart} FullText: ${Buffs[${i}]} Type: ${Spell[${SpellToCast}].TargetType} ReadBuffsTimer: ${ReadBuffsTimer} IniNextTimer: ${IniNextTimer}
            DEBUGBUFFS CheckBuffs Skip if Combat: ${CombatStart}  Aggro: ${AggroTargetID} IDied: ${IAmDead} ReadBTimer: ${ReadBuffsTimer} Invised: ${Me.Invis}
            /if ((${Me.CombatState.Equal[COMBAT]} && ${AggroTargetID}) || ${CombatStart}) {
				POPCALL
				/return
			}
            | This was causing prob with ForceGroup, too...
            /if (${IAmDead} || ${Me.Invis} || (${ReadBuffsTimer} && !${CharID} && !${ForceGroup})) {
				POPCALL
				/return
			}
            | Conditions Check
            /if (${ConOn} && ${Buffs[${i}].Find[|cond]}) {
                /varset CondNo ${Buffs[${i}].Mid[${Math.Calc[${Buffs[${i}].Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }
			DEBUGBUFFS Buffs${i}CheckBuffs Condition Cond${CondNo}
            | Check for Mana/End AA Regen on others
            DEBUGBUFFS CheckBuffs Start of If Structure. ${SpellToCast} ${2ndPart} ${Spell[${SpellToCast}].Mana} ${Me.CurrentMana}
            /varset MacroReturn CAST_NO_RESULT
            /if (${Select[${2ndPart},Endgroup,Managroup]}>0) {
                /if (${Group}) {
                    /if (${2ndPart.Equal[Endgroup]}) {
                        /call RegenOther "${SpellToCast}" Endurance ${3rdPart} 0 ${CondNo} FROMHERE
                    } else /if (${2ndPart.Equal[Managroup]}) {
                        /call RegenOther "${SpellToCast}" Mana ${3rdPart} 0 ${CondNo} FROMHERE
                    }
                    /varset MacroReturn ${Macro.Return}
                    /if (${MacroReturn.Equal[TRUE]}) /varcalc Buff${i}GM0 (${Spell[${SpellToCast}].Duration.TotalSeconds})*10
                }
            } else /if (${2ndPart.Equal[mana]}) {
                /if (${Me.PctMana}>${3rdPart} || ${Me.PctHPs}<${Int[${4thPart}]}) /continue
                /call CastWhat "${SpellToCast}" ${Me.ID} Buffs ${CondNo} 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                    /echo You are missing components. Turning off ${SpellToCast}.
                    /varset Buffs[${i}] NULL
                    /varset FullText NULL
                    /delay 10
                    /continue
                }
            | Combat check to skip all buffs but mana regen
            | Check and Cast endurance discs/AAs - 2nd wind, respite, etc
            } else /if (${2ndPart.Equal[End]}) {
                /if (${Me.PctEndurance}<=${3rdPart} && (${Me.CombatAbilityReady[${SpellToCast}]} || ${Me.AltAbilityReady[${SpellToCast}]})) /call CheckEndurance "${SpellToCast}" ${3rdPart} ${4thPart} ${CondNo}
            | Remove buff from |Remove tag
            } else /if (${2ndPart.Equal[Remove]} && (${Me.Buff[${SpellToCast}].ID} || ${Me.Song[${SpellToCast}].ID})) {
                /if (!${CondNo} || ${If[${Cond[${CondNo}]},1,0]}) {
                    /echo Removing Buff: ${SpellToCast}
                    /removebuff "${SpellToCast}"
                }
            | If buff cost more mana than I have skip it
            } else /if (${2ndPart.NotEqual[begfor]} && ${Spell[${SpellToCast}].Mana} && ${Spell[${SpellToCast}].Mana}>${Me.CurrentMana}) {
                /continue
            | Check if aura is up
            } else /if (${2ndPart.Equal[Aura]}) {
                /call CheckAura "${SpellToCast}" ${CondNo}
            | Check for |Once tag and turn buff off is cast is successful
            } else /if (${2ndPart.Equal[Once]}) {
                /call BuffOnce "${SpellToCast}" ${CondNo}
                /if (${Macro.Return.Equal[TRUE]}) {
                    /varset Buffs[${i}] ${SpellToCast}|0
                    /echo Buffing Once with ${SpellToCast}.
                }
            | Summon items ini example Buffs1=The Guardian's Pouch|Summon|Guardian Blade|200
            } else /if (${2ndPart.Equal[Summon]}) {
                /if (${FindItemCount[=${3rdPart}]}<${4thPart}) /call SummonStuff "${SpellToCast}" "${3rdPart}" ${4thPart} ${CondNo}
                /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                    /echo You are missing components. Turning off ${SpellToCast}.
                    /varset Buffs[${i}] NULL
                    /varset FullText NULL
					/delay 10
					|
					| Dont see why we have to break. Continue to next.
					|
					/continue
                }
            } else /if (${Select[${2ndPart},mgb,dualmgb]}>0 && !${Me.Buff[${BuffToCheck}].ID}) {
                /call MassGroupBuff "${SpellToCast}" ${i} ${CondNo}
            } else /if (${2ndPart.Equal[begfor]} && !${Buff${i}GM0}) {
                | this is only run for the beggar when begging.
                /if (${Int[${3rdPart}]}>0 && ${4thPart.Equal[alias]}) {
                    /if (${Select[${5thPart},BEGFORITEMS]}>0) {
                        /if (${FindItemCount["=${SpellToCast}"]}<${3rdPart}) {
                            |"#*# KABeg for #1# #2#"
                            /call BroadCast o "KABeg for ${Me.CleanName} ${5thPart} 0"
                            /varset Buff${i}GM0 900
                        }
                    } else /if (${Select[${5thPart},BEGFORBUFFS]}>0) {
                        /if (!${Me.Buff[${SpellToCast}].ID}) {
                            /call BroadCast o "KABeg for ${Me.CleanName} ${5thPart} 0"
                            /varset Buff${i}GM0 900
                        }
                    } else {
                        /echo Invalid Option ${5thPart} for Alias. Turning Option off.
                        /varset Buffs[${i}] NULL
                        /varset FullText NULL
						|
						| Added missing /continue
						|
						/continue
                    }
                }
            | Check for Command: tag
            } else /if (${SpellToCast.Find[command:]}) {
                /varset i_TargetID ${Int[${Target.ID}]}
                /call TargetTag "${FullText}"
                /call CastWhat "${SpellToCast}" ${Macro.Return} Buffs ${CondNo} 0 FROMHERE
                |/if (${Target.ID}) /squelch /target clear
                /continue
            }
            DEBUGBUFFS CheckBuffs End of If Structure. ${2ndPart}
            | Everything above is for self/group only can skip to end if 2ndPart is in list below. mana and end are exceptions.
            /if (${Select[${2ndPart},Aura,Mount,Summon,Endgroup,Managroup,Once,Remove,Mana,End,mgb,dualmgb,begfor]}) /continue
            DEBUGBUFFS CheckBuffs BuffSlot: !${Int[${Me.Buff[${BuffToCheck}].ID}]} SongSlot: ${Int[${Me.Song[${BuffToCheck}].ID}]} Stacks: ${Spell[${SpellToCast}].Stacks[0]} 2nd Part: ${Select[${2ndPart},Aura,Mount,Summon,Endgroup,Managroup,Once,Remove]}<1 Tar Type: ${Spell[${SpellToCast}].TargetType}
            DEBUGBUFFS CheckBuffs Find 0: ${BookSpellTT.Find[0]} Spell TT: ${Spell[${SpellToCast}].TargetType.Find[single]} BookTT: ${BookSpellTT.Find[single]} Medding: ${Medding} MedCombat: ${MedCombat}
            | Cast buffs on MA && ${Spell[${Buffs[${i}]}].TargetType.Find[self]}
            /if (${Select[${2ndPart},MA,DualMA]}) {
                DEBUGBUFFS CheckBuffs MA/DualMA Tag: ${2ndPart} ${Spawn[=${MainAssist}].ID} ${Buff${i}GM7}
                | If forcegroup or charid, just redo buffs.
                /if (${Spawn[=${MainAssist}].Distance}<=${SpellRange} && ${Spawn[=${MainAssist}].ID} && (${Buff${i}GM7}==0 || ${ForceGroup} || ${CharID})) {
                    DEBUGBUFFS Cast buffs with MA tag ${Buffs[${i}]}
                    | Check buffs in file to see if MA has buff or its blocked
                    /if (${MainAssist.NotEqual[${Me}]}) {
                        /if (!${DanNetOn}) {
                            /if (${Ini["${KABuffsIni}",${Spawn[${MainAssistType} ${MainAssist}].ID},"Blockedbuffs"].Find[${BuffToCheck}]}) /continue
                            /if (${Ini["${KABuffsIni}",${Spawn[${MainAssistType} ${MainAssist}].ID},"Buffs"].Find[${BuffToCheck}]}) /continue
                        } else /if (${DanNet.Peers[${PeersZone}].Find[${MainAssist}|]}) {
                            /dquery ${MainAssist} -q "Me.BlockedBuff[${BuffToCheck}].ID" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                            /dquery ${MainAssist} -q "Me.Buff[${BuffToCheck}].ID" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                        } else {
                            /continue
                        }
                    } else {
                        /if (${Me.BlockedBuff[${BuffToCheck}].ID}) /continue
                        /if (${Me.Buff[${BuffToCheck}].ID}) /continue
                    }
					| This doesn't seem to handle MA if the caster is not ma?
                    | If its a group spell cast on mercs - owner
                    /if (${Spawn[=${MainAssist}].Type.Equal[mercenary]} && ${Spell[${SpellToCast}].TargetType.Find[group v]}) {
                        /varset MATargetID ${Spawn[=${MainAssist}].Owner.ID}
                    } else /if (${Select[${Role},hunterpettank,pettank,pullerpettank]} ) {
                        /varset MATargetID ${Pet.ID}
                    } else {
                        /varset MATargetID ${Spawn[=${MainAssist}].ID}
                    }

                    | Here we will check whether CharID matches and bypass if not. Otherwise we have to refactor the function.
                    /if (!${CharID} || (${CharID} && ${CharID}==${MATargetID})) {
                        /if (${Cursor.ID}) /call CheckCursor CheckBuffs1 0
                        DEBUGBUFFS CheckBuffs: MA Buff CastWhat "${SpellToCast}" ${MATargetID} Buffs ${CondNo}
                        /call CastWhat "${SpellToCast}" ${MATargetID} Buffs-nomem ${CondNo} 0 FROMHERE
                        DEBUGBUFFS CheckBuffs: MA Buff MacroReturn: ${Macro.Return}
                        /if (${Macro.Return.Equal[CAST_SUCCESS]} || (!${Spawn[${MainAssistType} ${MainAssist} group].ID} && ${Macro.Return.Equal[CAST_TAKEHOLD]})) {
                            /echo Buffing MA >> ${Spawn[=${MainAssist}].CleanName} << with ${SpellToCast}.
                            /varcalc Buff${i}GM7 ${Spell[${BuffToCheck}].MyDuration.TotalSeconds}*10
                            DEBUGBUFFS CheckBuffs MA Buff Timer ${Buff${i}GM7}
                            /varset WriteBuffsTimer 0
                            /call WriteBuffs
                            /continue
                        } else /if (${Macro.Return.Equal[CAST_HASBUFF]}) {
                            /varcalc Buff${i}GM7 ${HasBuffDuration}*10
                        } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                            /echo You are missing components. Turning off ${SpellToCast}.
                            |
                            | Adding this to see if it helps with retries
                            |
                            /varset WriteBuffsTimer 0
                            /varset Buffs[${i}] NULL
                            /varset FullText NULL
                            /delay 10
                            |
                            | I think continue is fine, rather than break.
                            /continue
                        }
                    } else {
                        /continue
                    }
                } else {
                    /continue
                }
            | Check if buff is up and if it stacks with existing buffs. 
            | Note that no one gets the buff unless I also dont have it.
            | If someone dies, then I will not automatically rebuff.
            | Adding ability to buff a single character, CharID
            } else /if (BUFFSNOTANITEM && (${CharID} || ${ForceGroup} || (!${Int[${Me.Buff[${BuffToCheck}].ID}]} && !${Int[${Me.Song[${BuffToCheck}].ID}]} && ${Spell[${SpellToCast}].Stacks[0]}))) {
                DEBUGBUFFS CheckBuffs -- 2nd asssigned: ${SpellToCast} TargetType: ${Spell[${SpellToCast}].TargetType}
                | If Target.Type=Group then buff self with group buff
                /if ((${BookSpellTT.Find[0]} && ${Spell[${SpellToCast}].TargetType.Find[group v]}) || ${BookSpellTT.Find[group v]}) {
                    DEBUGBUFFS In Group spell If: ${SpellToCast}
                    /if (${Cursor.ID}) /call CheckCursor CheckBuffs2 0
                    /if (!${CharID}) {
                        /call CastWhat "${SpellToCast}" ${Me.ID} Buffs-nomem ${CondNo} 0 FROMHERE
                    } else {
                        /call CastWhat "${SpellToCast}" ${CharID} Buffs-nomem ${CondNo} 0 FROMHERE
                    }
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                        /echo Buffing >> ${SpellToCast} <<
                        /doevents flush WornOff
                        /varset WriteBuffsTimer 0
                        /call WriteBuffs
                    } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
						/echo You are missing components. Turning off ${SpellToCast}.
						|
						| Without this it just keeps spinning!
						|
						/doevents flush WornOff
						/varset WriteBuffsTimer 0						
						/varset Buffs[${i}] NULL
						/varset FullText NULL
						/delay 10
						|
						| Changing from break to continue
						|
						/continue
                    }
					|
					| This needs a timer to break out in case of stuckgem
					|
                    /if (${ForceGroup} || ${CharID}) {
                        /while (${Me.SpellInCooldown}) {
                            /delay 5
                        }
                        /continue
                    }
                | If Target.Type=Single then buff each party member with single buff
                } else /if ((${BookSpellTT.Find[0]} && ${Spell[${SpellToCast}].TargetType.Find[single]}) || ${BookSpellTT.Find[single]}) {
					DEBUGBUFFS Inside Single target buff If: ${SpellToCast}
					/if (!${Buffs[${i}].Length} || ${Buffs[${i}].Equal[NULL]}) /continue
                    /if (${Buff${i}GM0}) /varset Buff${i}GM0 0
                    /if ((${CharID} && ${Me.CurrentMana}>=${Spell[${SpellToCast}].Mana}) || (${Group} && ${Me.CurrentMana}>=${Math.Calc[${Spell[${SpellToCast}].Mana}*${Group}]})) {
						| Added support for Pet and MAPet. Group skips those, picks it up in second pass, below.
                        DEBUGBUFFS CheckBuffs Single target PC group loop
                        
                        | Pet check is inside because we would need another nested loop. Instead, breaks this loop and is picked up at next.
                        /for j 0 to ${Group}
                            | Pet only, go to next loop.
                            /if (${Select[${2ndPart},DualMAPet,DualPet,MAPet,Pet]}) /break
                            /if (${Me.Invis}) /break
							/call CheckBeforeCast CheckBuffs FROMHERE
                            /if (!${CharID}) {
                                /varset CurrentID ${Group.Member[${j}].ID}
                                DEBUGBUFFS CheckBuffs ${Group.Member[${j}].ID} ${Spawn[=${Group.Member[${j}]}].Distance} ${SpellRange} ${2ndPart.Equal[Me]} ${j}>=1 ${2ndPart.Equal[MA]} ${Group.Member[${j}].ID}!=${Spawn[${MainAssistType} ${MainAssist}].ID} ${Buff${i}GM${j}} ${Me.Invis}
                            } else /if (${CharID} && !${Spawn[id ${CharID} pet].ID}) {
                                /varset CurrentID ${CharID}
                                DEBUGBUFFS CheckBuffs Buffing individual character ${CurrentID} ${Spawn[=${CurrentID}].Distance} ${SpellRange} ${2ndPart.Equal[Me]} ${2ndPart.Equal[MA]} ${CurrentID}!=${Spawn[${MainAssistType} ${MainAssist}].ID} ${Buff${i}GM${j}} ${Me.Invis}
                            } else /if (${CharID}) {
                                | It's a pet. Leave.
                                /break
                            }
							
                            | Check if party member/char is alive in zone and within spell range and spell timer does not exist
                            |/if (!${Group.Member[${j}].ID} || ${Spawn[=${Group.Member[${j}]}].Distance}>=${SpellRange} || ${Buff${i}GM${j}}) /continue
							| Removed the bufftimer check. Chars that die don't get rebuffed.
							/if (!${CurrentID} || ${Spawn[id ${CurrentID}].Distance}>=${SpellRange}) /continue
							
                            /if (${Select[${2ndPart},me,dualme]} && (${j}>0 || ${CharID})) /break
                            /if (${Me.CurrentMana}<${Spell[${SpellToCast}].Mana}) /break
                            DEBUGBUFFS CheckBuffs 3 ${2ndPart.Equal[caster]} ${Spawn[id ${CurrentID}].Class.ShortName} ${Select[${Spawn[id ${CurrentID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]} ${2ndPart.Equal[Melee]} ${Spawn[id ${CurrentID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}
                            /if ((${Select[${2ndPart},caster,DualCaster]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]}==0) || (${Select[${2ndPart},Melee,DualMelee]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}==0)) /continue
                            /if (${Select[${2ndPart},class,dualclass]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},${5thPart}]}==0) /continue
                            /if (${Select[${2ndPart},!class,dual!class]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},${5thPart}]}>0) /continue
                            /if (${Select[${2ndPart},MA,Dualma]}>0 && ${CurrentID}!=${Spawn[${MainAssistType} ${MainAssist}].ID}) /continue
                            /if (${2ndPart.Equal[!MA]} && ${CurrentID}==${Spawn[${MainAssistType} ${MainAssist}].ID}) /continue
                            /if (${Cursor.ID}) /call CheckCursor CheckBuffs3 0
                            /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
								POPCALL
                                /return
                            } else /if (${Me.Gem[${SpellToCast}]}) {
                                | Changing from 6 (1 tic) to two tic (12)
                                /if (${Me.GemTimer[${SpellToCast}].TotalSeconds}>12) /continue
                                /while (!${Me.SpellReady[${SpellToCast}]}) {
                                    /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
										POPCALL
										/return
									}
                                    /delay 3
                                }
                            }
                            /call CastWhat "${SpellToCast}" ${CurrentID} Buffs-nomem ${CondNo} 0 FROMHERE
                            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                /echo Buffing ${SpellToCast} on ${Spawn[id ${CurrentID}].CleanName}
                                /if (!${CharID}) {
                                    /varcalc Buff${i}GM${j} ${Spell[${BuffToCheck}].MyDuration.TotalSeconds}*10
                                }
                                /doevents flush WornOff
                                /varset WriteBuffsTimer 0
                                /call WriteBuffs
                            } else /if (${Macro.Return.Equal[CAST_HASBUFF]}) {
                                /if (!${CharID}) {
                                    /varcalc Buff${i}GM${j} ${HasBuffDuration}*10
                                }
                            } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
								/echo You are missing components. Turning off ${SpellToCast}.
								|
								| Missing this. Otherwise it keeps trying.
								|
								/doevents flush WornOff
								/varset WriteBuffsTimer 0
								/varset Buffs[${i}] NULL
								/varset FullText NULL
								/delay 10
								/break
                            }
                            /if (${CurrentID}==${CharID}) /break
                        /next j
						
                        DEBUGBUFFS CheckBuffs Single target for Group Pets
                        /for j 0 to ${Group}
                            | Added DualMAPet, MAPet, DualPet, and Pet support. If not pet, breaks out to next buff.
                            | If the spell has a target type and is not intended for a pet, or the group member does not have a pet, continue.
                            DEBUGBUFFS CheckBuffs 2ndPart "${2ndPart}"
                            | Also want Melee in there. If nothing is specified, then its ok for pets to have as its a general buff.
                            /if (${2ndPart.Length} && !${Select[${2ndPart},DualMAPet,DualPet,MAPet,Pet,Caster,DualCaster,Melee,DualMelee,Dual]}) /continue
                            DEBUGBUFFS CheckBuffs 2ndPart condition check
                            /if (${Me.Invis}) /break
							/call CheckBeforeCast CheckBuffs FROMHERE
                            | Check if group member has a pet and within spell range
                            /if (!${CharID}) {
                                /varset CurrentID ${Group.Member[${j}].Pet.ID}
                            } else /if (${CharID} && ${Spawn[id ${CharID} pet].ID}) {
                                /varset CurrentID ${CharID}
                            } else /if (${CharID} && ${Spawn[id ${CharID}].Pet.ID}) {
                                /varset CurrentID ${Spawn[id ${CharID}].Pet.ID}
                            } else {
                                /break
                            }

                            /if (!${CurrentID} || ${Spawn[id ${CurrentID}].Distance}>=${SpellRange}) /continue
                            /if (${Me.CurrentMana}<${Spell[${SpellToCast}].Mana}) /break
							/if (${Select[${2ndPart},DualMAPet,MAPet]} && ${CurrentID}!=${Spawn[=${MainAssist}].ID}) /continue
                            /if ((${Select[${2ndPart},caster,DualCaster]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]}==0) || (${Select[${2ndPart},Melee,DualMelee]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}==0)) /continue
                            /if (${Cursor.ID}) /call CheckCursor CheckBuffs3 0
                            /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
								POPCALL
                                /return
                            } else /if (${Me.Gem[${SpellToCast}]}) {
                                | Added another tic (Was 6, now 12). Delay divisible by 3
                                /if (${Me.GemTimer[${SpellToCast}].TotalSeconds}>12) /continue
                                /while (!${Me.SpellReady[${SpellToCast}]}) {
                                    /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
										POPCALL
										/return
									}
                                    /delay 3
                                }
                            }
                            /call CastWhat "${SpellToCast}" ${CurrentID} Buffs-nomem ${CondNo} 0 FROMHERE
                            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                /echo Buffing ${SpellToCast} on ${Spawn[id ${CurrentID}].CleanName}
                                /varset WriteBuffsTimer 0
                                /call WriteBuffsPet
                            } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
								/echo You are missing components. Turning off ${SpellToCast}.
								|
								| Missing this. Otherwise it keeps trying.
								|
								/doevents flush WornOff
								/varset WriteBuffsTimer 0
								/varset Buffs[${i}] NULL
								/varset FullText NULL
								/delay 10
								/break
                            }
                            /if (${CurrentID}==${CharID}) /break
                        /next j

                        DEBUGBUFFS XTargetWatchList Non-pet targets
                        | XTargetWatchList
                        /if (${XTarWatch}) {
                            /for j 1 to 20
                                DEBUGBUFFS CheckBuffs XTarToWatch[${j}]=${XTarToWatch[${j}]}
                                /if (!${XTarToWatch[${j}]}) /continue
                                /if (${Select[${2ndPart},DualMAPet,DualPet,MAPet,Pet]}) /break
                                /if (${Me.Invis}) /break
                                /call CheckBeforeCast CheckBuffs FROMHERE
                                /varset CurrentID ${Me.XTarget[${XTarToWatch[${j}]}].ID}
                                /if (${Spawn[id ${CurrentID}].Type.Equal[pet]}) /continue
                                DEBUGBUFFS CheckBuffs XTSlot ${XTarToWatch[${j}]} ID ${CurrentID} ${Spawn[id ${CurrentID}].Distance} ${SpellRange} ${2ndPart.Equal[Me]} ${j}>=1 ${2ndPart.Equal[MA]} ${Spawn[id ${CurrentID}].ID}!=${Spawn[${MainAssistType} ${MainAssist}].ID} ${Me.Invis}
                                
                                | Check if party member/char is alive in zone and within spell range and spell timer does not exist
                                |/if (!${Group.Member[${j}].ID} || ${Spawn[=${Group.Member[${j}]}].Distance}>=${SpellRange} || ${Buff${i}GM${j}}) /continue
                                | Removed the bufftimer check. Chars that die don't get rebuffed.
                                /if (!${CurrentID} || ${Spawn[id ${CurrentID}].Distance}>=${SpellRange}) /continue
                                
                                /if (${Select[${2ndPart},me,dualme]}) /break
                                /if (${Me.CurrentMana}<${Spell[${SpellToCast}].Mana}) /break
                                DEBUGBUFFS CheckBuffs 3 ${2ndPart.Equal[caster]} ${Spawn[id ${CurrentID}].Class.ShortName} ${Select[${Spawn[id ${CurrentID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]} ${2ndPart.Equal[Melee]} ${Spawn[id ${CurrentID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}
                                /if ((${Select[${2ndPart},caster,DualCaster]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]}==0) || (${Select[${2ndPart},Melee,DualMelee]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}==0)) /continue
                                /if (${Select[${2ndPart},class,dualclass]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},${5thPart}]}==0) /continue
                                /if (${Select[${2ndPart},!class,dual!class]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},${5thPart}]}>0) /continue
                                /if (${Select[${2ndPart},MA,Dualma]}>0 && ${CurrentID}!=${Spawn[${MainAssistType} ${MainAssist}].ID}) /continue
                                /if (${2ndPart.Equal[!MA]} && ${CurrentID}==${Spawn[${MainAssistType} ${MainAssist}].ID}) /continue
                                /if (${Cursor.ID}) /call CheckCursor CheckBuffs3 0
                                /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
                                    POPCALL
                                    /return
                                } else /if (${Me.Gem[${SpellToCast}]}) {
                                    | Changing from 6 (1 tic) to two tic (12)
                                    /if (${Me.GemTimer[${SpellToCast}].TotalSeconds}>12) /continue
                                    /while (!${Me.SpellReady[${SpellToCast}]}) {
                                        /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
                                            POPCALL
                                            /return
                                        }
                                        /delay 3
                                    }
                                }
                                /call CastWhat "${SpellToCast}" ${CurrentID} Buffs-nomem ${CondNo} 0 FROMHERE
                                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                    /echo Buffing ${SpellToCast} on ${Spawn[id ${CurrentID}].CleanName}
                                } else /if (${Macro.Return.Equal[CAST_HASBUFF]}) {
                                    |
                                } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                                    /echo You are missing components. Turning off ${SpellToCast}.
                                    |
                                    | Missing this. Otherwise it keeps trying.
                                    |
                                    /doevents flush WornOff
                                    /varset WriteBuffsTimer 0
                                    /varset Buffs[${i}] NULL
                                    /varset FullText NULL
                                    /delay 10
                                    /break
                                }
                            /next j

                            DEBUGBUFFS XTargetWatchList Pets - ${SpellToCast}
                            /for j 1 to 20
                                /if (!${XTarToWatch[${j}]}) /continue
                                | Added DualMAPet, MAPet, DualPet, and Pet support. If not pet, breaks out to next buff.
                                | If the spell has a target type and is not intended for a pet, or the group member does not have a pet, continue.
                                DEBUGBUFFS CheckBuffs 2ndPart "${2ndPart}"
                                | Also want Melee in there. If nothing is specified, then its ok for pets to have as its a general buff.
                                /if (${2ndPart.Length} && !${Select[${2ndPart},DualMAPet,DualPet,MAPet,Pet,Caster,DualCaster,Melee,DualMelee,Dual]}) /continue
                                DEBUGBUFFS CheckBuffs 2ndPart condition check
                                /if (${Me.Invis}) /break
                                /call CheckBeforeCast CheckBuffs FROMHERE
                                | Check if group member has a pet and within spell range
                                /varset CurrentID ${Me.XTarget[${XTarToWatch[${j}]}].ID}
                                /if (!${CurrentID}) /continue
                                /if (${Spawn[id ${CurrentID}].Type.NotEqual[pet]}) {
                                    /varset CurrentID ${Spawn[id ${CurrentID}].Pet.ID}    
                                }
                                /if (${Spawn[id ${CurrentID}].Type.NotEqual[pet]}) /continue
                                DEBUGBUFFS CheckBuffs XTargetWatchList Pets - ${Spawn[id ${CurrentID}].CleanName}
                                /if (!${CurrentID} || ${Spawn[id ${CurrentID}].Distance}>=${SpellRange}) /continue
                                /if (${Me.CurrentMana}<${Spell[${SpellToCast}].Mana}) /break
                                /if (${Select[${2ndPart},DualMAPet,MAPet]} && ${CurrentID}!=${Spawn[=${MainAssist}].ID}) /continue
                                /if ((${Select[${2ndPart},caster,DualCaster]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]}==0) || (${Select[${2ndPart},Melee,DualMelee]}>0 && ${Select[${Spawn[id ${CurrentID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}==0)) /continue
                                /if (${Cursor.ID}) /call CheckCursor CheckBuffs3 0
                                /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
                                    POPCALL
                                    /return
                                } else /if (${Me.Gem[${SpellToCast}]}) {
                                    | Added another tic (Was 6, now 12). Delay divisible by 3
                                    /if (${Me.GemTimer[${SpellToCast}].TotalSeconds}>12) /continue
                                    /while (!${Me.SpellReady[${SpellToCast}]}) {
                                        /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
                                            POPCALL
                                            /return
                                        }
                                        /delay 3
                                    }
                                }
                                DEBUGBUFFS CheckBuffs XTargetWatchList Pets - casting ${SpellToCast} on ${Spawn[id ${CurrentID}].CleanName}
                                /call CastWhat "${SpellToCast}" ${CurrentID} Buffs-nomem ${CondNo} 0 FROMHERE
                                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                    /echo Buffing ${SpellToCast} on ${Spawn[id ${CurrentID}].CleanName}
                                } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                                    /echo You are missing components. Turning off ${SpellToCast}.
                                    |
                                    | Missing this. Otherwise it keeps trying.
                                    |
                                    /doevents flush WornOff
                                    /varset WriteBuffsTimer 0
                                    /varset Buffs[${i}] NULL
                                    /varset FullText NULL
                                    /delay 10
                                    /break
                                }
                            /next j

                        }

                    } else /if (${Select[${2ndPart},MA,Melee,Caster,DualMA,DualMelee,DualCaster,class,dualclass,dual!class,DualMAPet,DualPet,MAPet,Pet]}==0) {
                        DEBUGBUFFS Giving buff ${SpellToCast} to myself. 2ndPart ${2ndPart}
                        /if (${Cursor.ID}) /call CheckCursor CheckBuffs4 0
                        /call CastWhat "${SpellToCast}" ${Me.ID} Buffs-nomem ${CondNo} 0 FROMHERE
                        /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                            | What is setting j?  Since the spell is being cast on the caster, just using 0.
                            /varset j 0
                            /echo Buffing ${SpellToCast} on ${Group.Member[${j}].CleanName}
                            /varcalc Buff${i}GM${j} ${Spell[${BuffToCheck}].MyDuration.TotalSeconds}*10
                            /doevents flush WornOff
                            /varset WriteBuffsTimer 0
                            /call WriteBuffs
                        } else /if (${Macro.Return.Equal[CAST_HASBUFF]}) {
                            /varcalc Buff${i}GM${j} ${HasBuffDuration}*10
                        } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                            /echo You are missing components. Turning off ${SpellToCast}.
							|
							| Missing this or it just spins.
							|
							/doevents flush WornOff
							/varset WriteBuffsTimer 0				
                            /varset Buffs[${i}] NULL
                            /varset FullText NULL
							|
							| Not sure why SpellToCast is being emptied. Added delay.
							|
                            /varset SpellToCast
							/delay 10
                            /continue
                        }
                    }
                | If Target.Type=self then buff self
                } else /if ((${BookSpellTT.Find[0]} && ${Spell[${SpellToCast}].TargetType.Find[self]}) || ${BookSpellTT.Find[self]}) {
                    DEBUGBUFFS CheckBuffs Self Buff ${Me.Buff[${BuffToCheck}].ID} ${Me.Song[${BuffToCheck}].ID}
                    /if (${Me.Buff[${BuffToCheck}].ID} || ${Me.Song[${BuffToCheck}].ID}) /continue
                    /call CastWhat "${SpellToCast}" ${Me.ID} Buffs-nomem ${CondNo} 0 FROMHERE
                    /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                        /echo You are missing components. Turning off ${SpellToCast}.
						|
						| Missing this
						|
						/doevents flush WornOff
						/varset WriteBuffsTimer 0						
                        /varset Buffs[${i}] NULL
                        /varset FullText NULL
                        /delay 10
						|
						| Why not go to the next spell instead of halting. Break to continue.
						|
                        /continue
                    } else /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                        /echo Casting ${SpellToCast} on me.
                        /delay 10
                    }
                | Check if buff needs pet as target ie Mage's Symbiosis line of mana buffs
                } else /if (${Pet.ID} && (${BookSpellTT.Find[0]} && ${Spell[${SpellToCast}].TargetType.Find[pet]} || ${Select[${Spell[${Spell[${SpellToCast}].ID}].Name.Arg[2,]},Symbiosis,Siphon,Simulacrum,Draw]})) {
                    DEBUGBUFFS CheckBuffs Self Buff that targets pet ie mage mana buff line
                    /call CastWhat "${SpellToCast}" ${Pet.ID} Buffs ${CondNo} 0 FROMHERE
                }
                | If buff is an item click it
            } else /if (${FindItem[=${SpellToCast}].Spell.Stacks[0]} && !${Int[${Me.Buff[${BuffToCheck}].ID}]} && ${Me.ItemReady[${SpellToCast}]} && ${Select[${2ndPart},Aura,Mount,Mana]}==0) {
                DEBUGBUFFS CheckBuffs Items
                /if (${Me.Buff[${BuffToCheck}].ID} || ${Me.Song[${BuffToCheck}].ID}) /continue
                /if (!${Me.Invis}) {
                    | Call of the wild ear fix
                    /if (${SpellToCast.Equal[Call of the Wild]}) {
                        /useitem "Call of the Wild"
                        /delay 15
                    } else {
                        /call CastWhat "${SpellToCast}" ${Me.ID} Buffs ${CondNo} 0 FROMHERE
                    }
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                        /echo Clicking > ${SpellToCast} <
                    } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
						/echo You are missing components. Turning off ${SpellToCast}.
						|
						| Again, stop spinning...
						|
						/doevents flush WornOff
						/varset WriteBuffsTimer 0						
						/varset Buffs[${i}] NULL
						/varset FullText NULL
						/delay 10
						/continue
                    }
                }
            }
            DEBUGBUFFS CheckBuffs  IniBuffCheck 1: Mana,Aura,Mount,Me,Summon,End:${Select[${2ndPart},Mana,Aura,Mount,Me,Summon,End,0]} Item:${FindItemCount[=${SpellToCast}]}>=1 Self:${Spell[${SpellToCast}].TargetType.Find[self]}
            | If Buff is a Mana,Aura,Mount,Me,dualme,Summon,End, an item, self buff or Spawn ID is me skip ini check because none of these are cast on others
            /if (${Select[${2ndPart},me,dualme]} || ${Me.Invis}) /continue
            /if ((${FindItemCount[=${SpellToCast}]}>=1 && ${Spell[${SpellToCast}].TargetType.Equal[self]}) || (${FindItemCount[${SpellToCast}]}>=1 && ${Spell[${BuffToCheck}].TargetType.Equal[self]}) || (${BookSpellTT.Find[0]} && ${Spell[${SpellToCast}].TargetType.Find[self]}) || ${BookSpellTT.Find[self]} || ${BookSpellTT.Find[pet]}) /continue
			/if (${Redguides} && !${IniNextTimer} && !${CombatStart}) /call CheckiniBuffs "${SpellToCast}" ${i} ${SpellRange} "${BuffToCheck}" "${2ndPart}" "${3rdPart}" "${4thPart}" "${5thPart}" "${BookSpellTT}" ${CondNo}
            DEBUGBUFFS CheckBuffs reset var ${i} ${Buffs[${i}]}
        /next i
		|
		| If we are in priority mode and got here, chances are we cast the spell(s).
		|
		/if (${PriorityFlag}) {
			/varcalc PriorityBuffsDone ${PriorityBuffsDone}+1
		}
        /if (${PowerSource.NotEqual[NULL]} && !${Bool[${Me.Inventory[powersource].Name.Length}]} && ${FindItemCount[=${PowerSource}]}) {
            /exchange "${PowerSource}" powersource
            /if (${FindItem[=${PowerSource}].Attuneable}) {
                /delay 20 ${Window[confirmationdialogbox].Open}
                /if (${Window[confirmationdialogbox].Open}) {
                    /notify confirmationdialogbox CD_Yes_Button leftmouseup
                    /delay 20 !${Window[confirmationdialogbox].Open}
                }
            }
        }
        /if (!${ReadBuffsTimer} && !${AggroTargetID}) /varset ReadBuffsTimer ${CheckBuffsTimer}s
        /if (${Macro.RunTime}>120 && !${IniNextTimer}) /varset IniNextTimer 30s
        /if (${MiscGemRemem} && (${Me.Gem[${MiscGem}].Name.NotEqual[${ReMemMiscSpell}]} || ${ReMemCastLW})) {
            /varset DontMoveMe 1
            /varset ReMemCast 1
            /call CastReMem "${ReMemMiscSpell}" 1 buffs
            /varset DontMoveMe 0
        }
		POPCALL
        DEBUGBUFFS CheckBuffs Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: CheckEndurance
| -------------------------------------------------------------------------------------
    Sub CheckEndurance(ESpell,EPct,EHealth,int CondNumber)
        /if (${Me.Invis}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare EndResult string local FALSE
        DEBUGBUFFS CheckAura Enter Spell: ${ESpell} EndPct: ${EPct} HealthPct: ${EHealth}
        /if (${EHealth.Equal[null]} || !${EHealth.Length}) /varset EHealth 0
        DEBUGBUFFS CheckAura Endurance Regen
        /if (${Me.Sitting}) /stand
        /call CastWhat "${ESpell}" ${Me.ID} CheckEndurance ${CondNumber} 0 FROMHERE
        /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
            /varset EndResult TRUE
            /echo Casting >> ${ESpell} << for endurance
        } else {
            /varset EndResult ${Macro.Return}
        }
		POPCALL
        DEBUGBUFFS CheckAura Leave
    /return ${EndResult}

| -------------------------------------------------------------------------------------
| SUB: CheckIniBuffs
| -------------------------------------------------------------------------------------
    Sub CheckIniBuffs(SpellName, BuffsNum, int BuffRange, BuffName, 2ndPart, 3rdPart, 4thPart, 5thPart, BookTT, int CondNumber, string FromWhere)
        /if (${Me.Invis}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS CheckIniBuffs Enter from ${FromWhere} - ${SpellName} ${BuffsNum} ${BuffRange} ${BuffName} ${2ndPart} ${3rdPart} ${4thPart} ${5thPart} ${BookTT} ${CondNumber} ${Me.Invis}
        /declare k int local
        /declare l int local
        | Assign var IniIDList all the spawn ids from buff ini file 2345|2195|2391| etc
        /declare IniIDList string local ${Ini["${KABuffsIni}"]}
        /declare SearchList string local
        /declare IniIDCount int local ${IniIDList.Count[|]}
        /declare SearchCount int local 0
        /declare IniBuffCount int local 0
        /declare IniBBuffList string local
        /declare IniBuffList string local
        /declare SearchBuffList string local
        /declare IniStackCheck[50] string local
        /declare PBTimerID string local
        /declare IniTempBuff string local
        /declare skipFlag int local 0
        /declare TryToBuffID int local 0
        /declare TryToBuffName string local
        /declare MercID int local 0
        /declare MercIDList string local
        /declare WhileFlag int local 1
        /while (${WhileFlag}) {
            /if (${Me.Invis}) /break
            | Check Buffs from ini
            /if (!${DanNetOn}) {
                | 1 = Ini File, 2 = Too Buff List
                /if (${WhileFlag}==1) {
                    /varset SearchList ${Ini["${KABuffsIni}"]}
                    /varset SearchCount ${IniIDList.Count[|]}
                } else {
                    /varset SearchList ${ExtendedBuffList}
                    /varset SearchCount ${ExtendedBuffList.Count[|]}
                }
            } else {
                | 1 = Characters using DanNet, 2 = Mercenaries in the area
                | 3 = Too Buff List, 4 = Pets of Characters using DanNet
                /if (${WhileFlag}==1 || ${WhileFlag}==4) {
                    /if (${Zone.ShortName.Find[_]}) {
                        /varset SearchList ${DanNet.Peers[zone_${Zone.ShortName}]}
                    } else {
                        /varset SearchList ${DanNet.Peers[zone_${EverQuest.Server.Lower}_${Zone.ShortName}]}
                    }
                    /varset SearchCount ${SearchList.Count[|]}
                } else /if (${WhileFlag}==2) {
                    | This is for Mercenaries in other groups.
                    /if (${SpawnCount[mercenary zradius 20 radius ${BuffRange}]}>0) {
                        /varset SearchCount ${SpawnCount[mercenary zradius 20 radius ${BuffRange}]}
                        /if (${Zone.ShortName.Find[_]}) {
                            /varset SearchList ${DanNet.Peers[zone_${Zone.ShortName}]}
                        } else {
                            /varset SearchList ${DanNet.Peers[zone_${EverQuest.Server.Lower}_${Zone.ShortName}]}
                        }
                        /for l 1 to ${SearchCount}
                            /varset MercID ${NearestSpawn[${l},mercenary zradius 20 radius ${BuffRange}].ID}
                            /if (${SearchList.Find[${Spawn[id ${MercID}].Owner.CleanName}]}) {
                                /varset MercIDList ${MercIDList}|${MercID}
                            }
                        /next SearchCount
                        /varset SearchList ${MercIDList}|
                        /varset SearchCount ${SearchList.Count[|]}
                    }
                } else {
                    /varset SearchList ${ExtendedBuffList}
                    /varset SearchCount ${ExtendedBuffList.Count[|]}
                }
            }
            /if (${Redguides}) {
                | IniIDCount = number of Char IDs counted in ini file. If 0 skip or Buff is null the the process.
                /if (${SearchCount}<=0 || ${SpellName.Equal[null]} || (${2ndPart.Equal[Dual]} && ${BuffName.Equal[null]})) {
					POPCALL
					/return
				}
                | Check if invalid spell and we don't have the item
                /if (!${Spell[${SpellName}].ID} && !${FindItemCount[=${SpellName}]}) {
					POPCALL
					/return
				}
                | Start scan of buffs listed on toons in ini file
                |/echo ${BuffName} ${AggroTargetID} ${Spawn[id ${AggroTargetID}].Distance}
                /for k 1 to ${SearchCount}
                    /if (${Me.Invis}) /break
                    /varset skipFlag 0
                    /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
						POPCALL
						/return
					}
                    /if (!${DanNetOn}) {
                        | 1 = Ini File, 2 = Too Buff List
                        /if (${WhileFlag}==1) {
                            /varset TryToBuffID ${Int[${SearchList.Arg[${k},|]}]}
                            /varset TryToBuffName ${Spawn[id ${TryToBuffID}].CleanName}
                        } else {
                            /varset TryToBuffName ${SearchList.Arg[${k},|]}
                            /varset TryToBuffID ${Int[${Spawn[=${TryToBuffName}].ID}]}
                        }
                    } else {
                        | 1 = Characters using DanNet, 2 = Mercenaries in the area
                        | 3 = Too Buff List, 4 = Pets of Characters using DanNet
                        /if (${WhileFlag}!=2) {
                            /varset TryToBuffName ${SearchList.Arg[${k},|]}
                            /varset TryToBuffID ${Int[${Spawn[=${TryToBuffName}].ID}]}
                        } else {
                            /varset TryToBuffID ${Int[${SearchList.Arg[${k},|]}]}
                            /varset TryToBuffName ${Spawn[id ${TryToBuffID}].CleanName}
                        }
                    }
                    |/echo ${TryToBuffID} ${TryToBuffName}
                    /if (!${TryToBuffID} || !${Spawn[id ${TryToBuffID}].ID}) /continue
                    | If the Spawn ID is not in the zone and not a PC/merc and not me skip to next ID
                    /if (${Select[${Spawn[id ${TryToBuffID}].Type},AURA,BANNER,CAMPFIRE,CORPSE,CHEST,ITEM,NPC,TRIGGER,TRAP,TIMER,MOUNT]} || ${TryToBuffID}==${Me.ID}) /continue
                    | If Buff is a Mana,Aura,Mount,Me,Summon,End, an item, self buff or Spawn ID is me skip because none of these are cast on others
                    DEBUGBUFFS CheckINIBuffs  IniBuffCheck 1: Mana,Aura,Mount,Me,Summon,End:${Select[${2ndPart},Mana,Aura,Mount,Me,Summon,End,0]} Item:${FindItemCount[=${SpellName}]}>=1 Self:${Spell[${SpellName}].TargetType.Find[self]}
                    | Set buff to correct spell to check for with Dual tag
                    /if ((${2ndPart.Find[Dual]} && ${Spell[${SpellName}].TargetType.Equal[self]}) || ${Spell[${BuffName}].TargetType.Equal[self]} || ${BookTT.Equal[self]}) {
						POPCALL
						/return
					}
                    | Check for Group only spells and skip NON group members.
                    | If buff marked MA skipped if spawn ID isn't MA
                    /if (${Select[${2ndPart},MA,DualMA]} && ${Spawn[id ${TryToBuffID}].CleanName.NotEqual[${MainAssist}]} || ${2ndPart.Equal[!MA]} && ${Spawn[id ${TryToBuffID}].CleanName.Equal[${MainAssist}]}) /continue
                    /if ((${Select[${2ndPart},Caster,DualCaster]}>0 && ${Select[${Spawn[id ${TryToBuffID}].Class.ShortName},CLR,DRU,SHM,BST,ENC,MAG,NEC,PAL,SHD,RNG,WIZ]}==0) || (${Select[${2ndPart},Melee,DualMelee]}>0 && ${Select[${Spawn[id ${TryToBuffID}].Class.ShortName},BRD,BER,BST,MNK,PAL,ROG,RNG,SHD,WAR]}==0)) /continue
                    /if (${Select[${2ndPart},class,dualclass]}>0 && ${Select[${Spawn[id ${TryToBuffID}].Class.ShortName},${5thPart}]}==0) /continue
                    DEBUGBUFFS CheckINIBuffs  IniBuffCheck 1.1: 2ndPart: ${2ndPart} Class Name: ${Spawn[id ${IniIDList.Arg[${k},|]}].Class.ShortName}
                    | Temp variable to store buff name after stripping rk stuff makes it easier to compare
                    /if (${BuffName.Find[ Rk.]}) {
                        /varset IniTempBuff ${BuffName.Left[${Math.Calc[${BuffName.Find[ Rk.]}-1]}]}
                    } else {
                        /varset IniTempBuff ${BuffName}
                    }
                    DEBUGBUFFS CheckINIBuffs  IniBuffCheck 2: ${Spawn[id ${IniIDList.Arg[${k},|]}].Name} ${IniIDList.Arg[${k},|]} ${IniTempBuff} ${BuffName}
                    /if (!${DanNetOn}) {
                        | 1 = Ini File, 2 = Too Buff List
                        /if (${WhileFlag}==1) {
                            | Assign var IniBBuffList blocked buffs list from ini file
                            /varset IniBBuffList ${Ini["${KABuffsIni}",${TryToBuffID},"Blockedbuffs"]}
                            | If the current buff is on the blocked buff list skip it.
                            DEBUGBUFFS CheckINIBuffs  IniBuffCheck 3: ${IniBBuffList.Find[${IniTempBuff}]} Buff blocked?
                            /if (${IniBBuffList.Find[${IniTempBuff}]}) /continue
                            | Assign var IniBuffList buffs list from ini file
                            /varset IniBuffList ${Ini["${KABuffsIni}",${TryToBuffID},"Buffs"]}
                            | If current buff is on the buff list skip it
                            DEBUGBUFFS CheckINIBuffs IniBuffCheck 4: ${IniTempBuff} ${IniBuffList.Find[${IniTempBuff}]}
                            /if (${IniBuffList.Find[${IniTempBuff}]}) /continue
                            | Assign buff count
                            /varset IniBuffCount ${IniBuffList.Count[|]}
                            | Check if current buff stacks will all existing buffs in list
                            DEBUGBUFFS CheckINIBuffs  IniBuffCheck 5: ${Spawn[id ${TryToBuffID}].Name} ${IniBuffCount} BuffsNum ${SpellName}
                            /for l 1 to ${IniBuffCount}
                                | Fix for stacking issues with Perfected Group Levitation there are a lot
                                /if (${IniBuffList.Arg[${l},|].Find[Group Perfected Levitation]} && !${SpellName.Find[Group Perfected Levitation]}) /continue
                                /if (!${Spell[${IniTempBuff}].RankName.WillStack[${IniBuffList.Arg[${l},|]}]}) {
                                    /varset skipFlag 1
                                    DEBUGBUFFS CheckINIBuffs IniBuffCheck Stack: ${IniBuffList.Arg[${l},|]} !Stack ${SpellName} ${Select[${Spell[${IniTempBuff}].RankName.WillStack[${IniBuffList.Arg[${l},|]}]},TRUE,FALSE,NULL]}
                                    /break
                                }
                            /next l
                        }
                    } else {
                        | 1 = Characters using DanNet, 2 = Mercenaries in the area
                        | 3 = Too Buff List, 4 = Pets of Characters using DanNet
                        /if (${WhileFlag}==1) {
                            | Is buff in Blocked Buff List?
                            /dquery ${TryToBuffName} -q "Me.BlockedBuff[${IniTempBuff}].ID" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                            /dquery ${TryToBuffName} -q "Me.Buff[${IniTempBuff}].ID" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                            /dquery ${TryToBuffName} -q "Me.Song[${IniTempBuff}].ID" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                            /dquery ${TryToBuffName} -q "Spell[${IniTempBuff}].Stacks[0]" -o DNout -t ${DanNetDelay}
                            /if (!${Bool[${DNout}]}) /continue
                        } else /if (${WhileFlag}==4) {
                            |Do I have a pet?
                            /dquery ${TryToBuffName} -q "Me.Pet.ID" -o DNout -t ${DanNetDelay}
                            /if (!${Bool[${DNout}]}) /continue
                            /varset TryToBuffID ${DNout}
                            /dquery ${TryToBuffName} -q "Me.BlockedPetBuff[${IniTempBuff}].ID" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                            /dquery ${TryToBuffName} -q "Me.Pet.Buff[${IniTempBuff}]" -o DNout -t ${DanNetDelay}
                            /if (${Bool[${DNout}]}) /continue
                            /dquery ${TryToBuffName} -q "Spell[${IniTempBuff}].StacksPet[0]" -o DNout -t ${DanNetDelay}
                            /if (!${Bool[${DNout}]}) /continue
                            /dquery ${TryToBuffName} -q "Me.Pet.Name" -o DNout -t ${DanNetDelay}
                            /varset TryToBuffName ${DNout}
                        }
                    }
                    /if (!${skipFlag}) {
                        | varset ini buff timer toon Id spell Id to shorten var and clarity
                        /varset PBTimerID ${TryToBuffID}${Spell[${SpellName}].ID}
                        | Define timer for spell i am about to cast
                        /if (!${Defined[ExtBuffTimer${PBTimerID}]}) /declare ExtBuffTimer${PBTimerID} timer outer 0
                        DEBUGBUFFS CheckINIBuffs IniBuffCheck 6: ${Spawn[id ${TryToBuffID}].Name} Temp:${IniTempBuff} OnList:${IniBuffList.Find[${IniTempBuff}]} Timer:${ExtBuffTimer${PBTimerID}}
                        | Check if toon is within spell range and cast buff
                        /if (${Spawn[id ${TryToBuffID}].Distance}<=${BuffRange} && !${ExtBuffTimer${PBTimerID}}) {
                            /if (${Spell[${SpellName}].TargetType.Equal[self]} && ${TryToBuffID}!=${Me.ID}) {
                                DEBUGBUFFS CheckINIBuffs tried to buff ${Spawn[id ${TryToBuffID}].CleanName} with a self buff
                                /continue
                            }
                            /if (${Me.SpellInCooldown} && !${IAmABard}) {
                                /while (${Me.SpellInCooldown}) {
                                    /delay 5
                                }
                            }
                            /call CastWhat "${SpellName}" ${TryToBuffID} Buffs ${CondNumber} 0 FROMHERE
                            DEBUGBUFFS CheckINIBuffs IniBuffCheck 7: "${SpellName}" ${TryToBuffID} Buffs 0 ${Macro.Return}
                            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                /echo Buffing >> ${SpellName} << on ${TryToBuffName}
                                /varset ExtBuffTimer${PBTimerID} 60s
                                /varset IniNextTimer 0
                                /doevents flush WornOff
                                /varset WriteBuffsTimer 0
                                /call WriteBuffs
                            } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                                /echo You are missing components. Turning off ${BuffName}.
								|
								| This was missing. It just kept spinning
								|
								/doevents flush WornOff
								/varset WriteBuffsTimer 0								
                                /varset Buffs[${BuffsNum}] NULL
                                /varset SpellName
                                /continue
                            } else /if (${Macro.Return.Equal[CAST_HASBUFF]}) {
                                /varset ExtBuffTimer${PBTimerID} ${HasBuffDuration}*10
                                /varset IniNextTimer 0
                            }
                        }
                        DEBUGBUFFS CheckINIBuffs IniBuffCheck 8: ExtBuffTimer${PBTimerID}:${ExtBuffTimer${PBTimerID}} IniNextTimer:${IniNextTimer}
                    }
                /next k
            }
            /if (!${DanNetOn} && ${WhileFlag}==2) {
                /break
            } else /if (${DanNetOn} && ${WhileFlag}==4) {
                /break
            }
            /varcalc WhileFlag ${WhileFlag}+1
        }
		POPCALL
        DEBUGBUFFS CheckIniBuffs Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Clean Buffs File
| ----------------------------------------------------------------------------
    Sub CleanBuffsFile
        /if (${CleanBuffsTimer}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        /declare i int local
        /declare SectionList string local ${Ini["${KABuffsIni}"]}
        /declare SectionListCount int local ${SectionList.Count[|]}
        /if (${SectionListCount}==0) /return
        /varcalc SectionListCount ${SectionListCount}-1
        /declare SectionName string local
        /for i 1 to ${SectionListCount}
            /varset SectionName ${SectionList.Arg[${i},|]}
            DEBUGBUFFS CleanBuffsFile ${i} ${SectionName} ${Math.Calc[${Ini["${KABuffsIni}",${SectionName},Day]}-${Time.Day}]} ${Math.Calc[${Time.Hour}-${Ini["${KABuffsIni}",${SectionName},Hour]}]} Day: ${Time.Day} Hour: ${Time.Hour}
            /if (${Ini["${KABuffsIni}",${SectionName},Day].NotEqual[${Time.Day}]}) {
                /ini "${KABuffsIni}" ${SectionName} NULL NULL
                /continue
            }
            /if (${Math.Calc[${Time.Hour}-${Ini["${KABuffsIni}",${SectionName},Hour]}]}!=0) /ini "${KABuffsIni}" ${SectionName} NULL NULL
        /next i
        /varset CleanBuffsTimer 10m
    /return

| -------------------------------------------------------------------------------------------------
| SUB:DoWeBuff
| -------------------------------------------------------------------------------------------------
    Sub DoWeBuff(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
        PUSHCALL

        DEBUGBUFFS Enter from ${FromWhere}

        /if (!${CheckCastManaTimerOn}) /call CastMana FROMHERE

        | Handles buff binds
        /if (${SubParamsCache[1].NotEqual[|]}) {
            /call CheckBuffs ${SubParamsCache[1]} FROMHERE
        } else /if (!${CheckBuffsTimerOn}) {
            /call CheckBuffs 0 0 FROMHERE
            /if (${KABegActive}) /call CheckBegforBuffs FROMHERE
        }
        POPCALL
    /return

| ----------------------------------------------------------------------------
|| SUB: Event AskForBuffs
| ----------------------------------------------------------------------------
    Sub Event_AskForBuffs(string Line, AFBCaller)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /varset EventFlag 1
        DEBUGBUFFS AskForBuffs: Enter
        /declare WorkID int local ${Int[${Spawn[=${AFBCaller}].ID}]}
        /if (!${AFBCaller.Length} || ${AFBCaller.Equal[null]} || !${WorkID} || ${WorkID}==${Me.ID}) {
			POPCALL
			/return
		}
        /if (${Group.Member[=${AFBCaller}].Index} || ${Spawn[id ${WorkID}].Type.NotEqual[PC]}) {
			POPCALL
			/return
		}
        /if (!${Raid.Member[${AFBCaller}].Group}) {
            /if (!${Me.Fellowship.Member[${AFBCaller}].Level}) {
                /if (!${Me.Guild.Equal[${Spawn[=${AFBCaller}].Guild}]}) {
                    /if (!${Friends.Friend[${AFBCaller}]}) {
						POPCALL
						/return
					}
                }
            }
        }
        /call Bind_TooBuffList add ${WorkID}
		POPCALL
        DEBUGBUFFS AskForBuffs: Exit
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event KABegCheck
| ----------------------------------------------------------------------------
    Sub Event_KABegCheck(Message,BCWho,BCWhat,KBCExtra)
        /if (!${BuffsOn}) /return
        /if (!${Select[${BCWhat},BEGFORITEMS,BEGFORBUFFS]}) /return
        /if (${Me.CleanName.Equal[${BCWho}]}) /return
        |/echo ${BCWho} ${BCWhat}

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /varset EventFlag 1
        /declare BCx int local 0
        /declare BCItem string local
        /declare BCCast string local

        DEBUGBUFFS KABegCheck: Enter ${BCWho} ${BCWhat}
        /if (${KABegForList.Length}>2000) {
            /echo Begged For List Exceeded Max Length. May have to beg again.
			POPCALL
            /return
        }
        /declare WorkID int local ${Int[${Spawn[PC ${BCWho}].ID}]}
        /if (!${BCWho.Length} || ${BCWho.Equal[null]} || !${WorkID} || ${WorkID}==${Me.ID}) {
			POPCALL
			/return
		}
        /if (${Spawn[id ${WorkID}].Type.NotEqual[PC]}) {
			POPCALL
			/return
		}
        /if (!${Raid.Member[${BCWho}].Group}) {
            /if (!${Me.Fellowship.Member[${BCWho}].Level}) {
                /if (!${Me.Guild.Equal[${Spawn[=${BCWho}].Guild}]}) {
                    /if (!${Friends.Friend[${BCWho}]}) {
						POPCALL
						/return
					}
                }
            }
        }
        /for BCx 1 to ${Buffs.Size}
            /if (${Buffs[${BCx}].Find[|alias|${BCWhat}]}) {
                /varset BCCast ${Buffs[${BCx}].Arg[1,|]}
                /if (${Buffs[${BCx}].Arg[2,|].Equal[summon]}) {
                    /if (${Buffs[${BCx}].Arg[6,|].NotEqual[${BCWhat}]}) /continue
                    /varset BCItem ${Buffs[${BCx}].Arg[3,|]}
                } else {
                    /varset BCItem ${Buffs[${BCx}].Arg[1,|]}
                }
                /if (!${Me.Book[${BCCast}]} && !${AltAbility[${BCCast}]}) /continue
                /varset KABegActive 1
                /if (${KABegForList.Length}) {
                    /varset KABegForList ${KABegForList}|${BCWhat}:${BCWho}:${BCx}
                } else {
                    /varset KABegForList ${BCWhat}:${BCWho}:${BCx}
                }
                /break
            }
        /next BCx
		POPCALL
        DEBUGBUFFS KABegCheck: Leave ${KABegActive}
    /return

| ----------------------------------------------------------------------------
| SUB: Event_WornOff - secondary check to rebuff
| ----------------------------------------------------------------------------
    Sub Event_WornOff(string Line, string wospell, string wotarget)
        /if (!${RebuffOn}) /return
        /if (${wotarget.Equal[${Me}]}) /return
        /if (${AggroTargetID}) /return
        /if (${Me.Class.Name.Find[bard]}) /return
        /if (${wospell.Find[promised]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
        PUSHCALL
		
        /varset EventFlag 1
        DEBUGBUFFS Event_WornOff Enter ${wospell} ${wotarget}
        /declare i int local
        /declare j int local
        /declare WOSpellTT string local 0
        /declare WOTries int local 0
        /declare WOMessage int local 0
        /if (${Me.Book[${wospell}]}) {
            /varset WOSpellTT ${Spell[${Me.Book[${Me.Book[${wospell}]}].ID}].TargetType}
        } else {
            /varset WOSpellTT ${Spell[${wospell}].TargetType}
        }
        /if (${WOSpellTT.Left[5].Equal[group]}) /varset WOSpellTT group
        DEBUGBUFFS Event_WornOff ${WOSpellTT}
        /if (${Group.Member[${wotarget}].Index}) {
            /varset j ${Group.Member[${wotarget}].Index}
            /for i 1 to ${Buffs.Size}
                /if (${Buffs[${i}].Find[${wospell}]}) {
                    /varset Buff${i}GM${j} 0
                    /if (${wotarget.Equal[${MainAssist}]}) /varset Buff${i}GM7 0
                    /if (!${WOMessage}) {
                        /echo ${wotarget} needs ${wospell} because it wore off.
                        /varset WOMessage 1
                    }
                    /if (${Select[${WOSpellTT},single,group]} && ${Me.Buff[${wospell}].ID}) {
                        /if (${Select[${EverQuest.Server},fippy,vulak,ragefire,lockjaw]}==0) {
                            /while (${WOTries}<6) {
                                /removebuff "${wospell}"
                                /delay 5
                                /varcalc WOTries ${WOTries}+1
                                /if (${Me.Buff[${wospell}].ID}) {
                                    DEBUGBUFFS Spell: ${WOSpellTT} Slot: ${Me.Buff[${wospell}].ID} Buff: ${i} GM: ${j}
                                } else {
                                    /break
                                }
                            }
                        }
                    }
                    | reset spell timer on caster
                    /varset Buff${i}GM0 0
                    /if (${ReadBuffsTimer}) /varset ReadBuffsTimer 0
                }
            /next i
        } else {
            /for i 1 to ${Buffs.Size}
                /if (${Buffs[${i}].Find[${wospell}]}) {
                    /if (${wotarget.Equal[${MainAssist}]}) /varset Buff${i}GM7 0
                    /if (!${WOMessage}) {
                        /echo ${wotarget} needs ${wospell} because it wore off.
                        /varset WOMessage 1
                    }
                    /if (${ReadBuffsTimer}) /varset ReadBuffsTimer 0
                }
            /next i
            /if (${IniNextTimer}) /varset IniNextTimer 0
        }
        POPCALL
        DEBUGBUFFS Event_WornOff Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: MassGroupBuff
| -------------------------------------------------------------------------------------
    Sub MassGroupBuff(SpellToCast1,int i1, int CondNumber)
        /if (!${SpellToCast1.Length} || ${i1}==0) /return 0

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /if (!${Spell[${SpellToCast1}].TargetType.Find[Group v]}) {
            /varset Buffs[${i1}] null
            /echo Spell ${SpellToCast1} cannot be MGB'd. Setting to null.
			POPCALL
            /return 0
        } else /if (${Me.AltAbility[Tranquil Blessings]}==0) {
            /varset Buffs[${i1}] null
            /echo You don't have Tranquil Blessings AA. Setting ${SpellToCast1} to null.
			POPCALL
            /return 0
        }
        /if (${Select[${Me.CombatState},active,resting]}==0) {
            /echo Your Not Resting. Will Have to Wait to cast MGB.
        } else /if (${Me.AltAbilityReady[Tranquil Blessings]} && ${Me.CurrentMana}>=${Math.Calc[${Spell[${SpellToCast1}].Mana}*2]}) {
            /if (!${CondNumber} || ${If[${Cond[${CondNumber}]},1,0]}) {
                /call CastWhat "Tranquil Blessings" ${Me.ID} Buffs-nomem 0 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                    /echo Casting Tranquil Blessings for MGB of ${SpellToCast1}
                    /call CastWhat "${SpellToCast1}" ${Me.ID} Buffs-nomem 0 0 FROMHERE
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                        /echo MGB of ${SpellToCast1} Successful.
                    }
                }
            }
        }
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: RegenOther
| ----------------------------------------------------------------------------
    Sub RegenOther(RGName, Stat, int StatPct, RegonOnClasses, int CondNumber, FromWhere)
		| Casting on others during combat will interrupt fast med
		/if (${Medding} && ${MedCombat}) /return FALSE
		/if (${Me.Invis}) /return FALSE

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS RegenOther Enter from ${FromWhere}: ${RGName} ${Stat} ${StatPct} ${RegonOnClasses}
        /declare i int local
        /declare ROResult string local FALSE
        /if (${RegonOnClasses.Equal[0]} || ${RegonOnClasses.Equal[null]}) {
            /if (${Stat.Equal[endurance]}) {
                /varset RegonOnClasses BER,BST,MNK,PAL,RNG,ROG,SHD,WAR
            } else /if (${Stat.Equal[mana]}) {
                /varset RegonOnClasses BRD,BST,CLR,DRU,ENC,MAG,NEC,PAL,RNG,SHD,SHM,WIZ
            }
        }
        /for i 1 to ${Group}
            DEBUGBUFFS RegenOther Class: ${Group.Member[${i}].Class.ShortName} AggroID: ${AggroTargetID}  GrpMemPct: ${Group.Member[${i}].Current${Stat}}<=${StatPct} GrpMemID: ${Group.Member[${i}].ID}
            | If bard rallying call aa skip tank or he won't attack
            /if (${RGName.Find[Rallying Call]} && ${Group.Member[${i}].ID}==${Spawn[${MainAssist} ${MainAssistType}].ID}) /continue
            | Bard Dichotomic uses endurance not mana
            /if  (${RGName.Find[Dichotomic Psalm]} && ${Me.CurrentEndurance}<15000) /continue
            | Dichotomic Psalm & Quiet Miracle do not work on bards
            /if (${Group.Member[${i}].Class.Name.Equal[bard]} && (${RGName.Equal[Dichotomic Psalm]} || ${RGName.Equal[Quiet Miracle]})) /continue
            /if (${Select[${Group.Member[${i}].Class.ShortName},${RegonOnClasses}]} && !${AggroTargetID} && ${Group.Member[${i}].Current${Stat}}<=${StatPct} && ${Group.Member[${i}].Current${Stat}}>=1 && ${Group.Member[${i}].ID}) {
                /call CastWhat "${RGName}" ${Group.Member[${i}].ID} Regenother ${CondNumber} 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                    /echo Casting ${RGName} on ${Group.Member[${i}].CleanName} for ${Stat}.
                    /varset ROResult TRUE
                    /break
                } else {
                    /varset ROResult ${Macro.Return}
                }
            }
        /next i
		POPCALL
        DEBUGBUFFS RegenOther Leave ${ROResult}
    /return ${ROResult}

|-----------------------------------------------------------------------------
| SUB: Remove From Beg List
| ----------------------------------------------------------------------------
    Sub RemoveFromBegList(string RBLAll, int RBLIdx, string RBLType)
        /if (!${RBLAll.Length} || ${RBLAll.Equal[null]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare RBLPart1  string Local
        /declare RBLPart2  string Local
        /declare RBLPart3  string Local
        /declare RBLPart1t string Local
        /declare RBLPart2t string Local
        /declare RBLPart3t string Local
        /declare RBLy      int    local 0
        /varset RBLPart1 ${RBLAll.Arg[1,:]}
        /varset RBLPart2 ${RBLAll.Arg[2,:]}
        /varset RBLPart3 ${RBLAll.Arg[3,:]}
        DEBUGBUFFS RemoveFromBegList: Enter - ${RBLAll} - ${RBLIdx} - ${RBLType}
        /if (!${RBLIdx}) /varset RBLIdx 1
        /if (${KABegForList.Find[${RBLAll}|]}) {
            /varset KABegForList ${KABegForList.Replace[${RBLAll}|,]}
            | Check for AE Items and remove any entries with same item tag and buff number entry
            /if ((${Select[${RBLPart1},BEGFORAEITEMS]} && ${KABegForList.Find[${RBLPart1}:]}) || ${RBLType.Equal[self]}) {
                /varset RBLy ${RBLIdx}
                /while (1) {
                    /varset RBLAll ${KABegForList.Arg[${RBLy},|]}
                    /if (!${RBLAll.Length} || ${RBLAll.Equal[null]}) {
                        /break
                    } else {
                        | Part1: Alias Name - Part2: Character Name - Part3: Buff entry index number
                        /varset RBLPart1t ${RBLAll.Arg[1,:]}
                        /varset RBLPart2t ${RBLAll.Arg[2,:]}
                        /varset RBLPart3t ${RBLAll.Arg[3,:]}
                        /if (${RBLPart1t.Equal[${RBLPart1}]} && ${RBLPart3t.Equal[${RBLPart3}]}) {
                            /if (${KABegForList.Find[${RBLAll}|]}) {
                                /varset KABegForList ${KABegForList.Replace[${RBLAll}|,]}
                            } else /if (${KABegForList.Find[${RBLAll}]}) {
                                /varset KABegForList ${KABegForList.Replace[${RBLAll},]}
                            } else {
                                /varcalc RBLy ${RBLy}+1
                            }
                        } else {
                            /varcalc RBLy ${RBLy}+1
                        }
                    }
                }
            } else /if (${RBLType.Equal[single]}) {
                | Check for single targeted items and remove any duplicates from list. Only need to cast once.
                /if (${KABegForList.Find[${RBLAll}]}) {
                    /while (${KABegForList.Find[${RBLAll}|]}) {
                        /varset KABegForList ${KABegForList.Replace[${RBLAll}|,]}
                    }
                    /if (${KABegForList.Find[${RBLAll}]}) /varset KABegForList ${KABegForList.Replace[${RBLAll},]}
                }
            }
        } else /if (${KABegForList.Find[${RBLAll}]}) {
            /varset KABegForList ${KABegForList.Replace[${RBLAll},]}
        }
		POPCALL
        DEBUGBUFFS RemoveFromBegList: Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: TargetTag
| -------------------------------------------------------------------------------------
    Sub TargetTag(TargetTagText)
        /declare TagReturn string local
        /if (${TargetTagText.Find[|pet]}) {
            /varset TagReturn ${Pet.ID}
        } else /if (${TargetTagText.Find[|me]}) {
            /varset TagReturn ${Me.ID}
        } else /if (${TargetTagText.Find[|ma]}) {
            /varset TagReturn ${MainAssistID}
        } else {
            /varset TagReturn 0
        }
    /return ${TagReturn}

| ----------------------------------------------------------------------------
| SUB: Write Buffs
| ----------------------------------------------------------------------------
    Sub WriteBuffs
        /if (${WriteBuffsTimer} || !${Redguides} || ${AggroTargetID} || ${EverQuest.GameState.NotEqual[INGAME]}) /return
        /if (${DanNetOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS WriteBuffs Enter
        /declare i int local 0
        /declare k int local 0
        /declare Blockedbuff string local
        /declare Blockedbufflist string local
        /declare BuffList string local
        /declare Writebufflist string local
        | Set block buffs count to 30 on emu servers and 40 on live
        /if (${MacroQuest.Build}==4) {
            /varset BlockedBuffsCount 30
        } else {
            /varset BlockedBuffsCount 40
        }
        /call CleanBuffsFile
        | Write day of the month and hour. Entry will be deleted if more than a hour old
        /if (!${Ini["${KABuffsIni}",${Me.ID},Day].Length}) /ini "${KABuffsIni}" "${Me.ID}" Day "${Time.Day}"
        /if (!${Ini["${KABuffsIni}",${Me.ID},Hour].Length}) /ini "${KABuffsIni}" "${Me.ID}" Hour "${Time.Hour}"
        /if (!${Ini["${KABuffsIni}",${Me.ID},Zone].Length}) /ini "${KABuffsIni}" "${Me.ID}" Zone "${Zone.ID}"
        /if (!${Ini["${KABuffsIni}",${Me.ID},Buffs].Length}) /ini "${KABuffsIni}" "${Me.ID}" Buffs
        /if (!${Ini["${KABuffsIni}",${Me.ID},Blockedbuffs].Length}) /ini "${KABuffsIni}" "${Me.ID}" Blockedbuffs
        /ini "${KABuffsIni}" "${Me.ID}" AmILooting ${LootOn}
        /ini "${KABuffsIni}" "${Me.ID}" MyRole ${Role}
        | Write all current buffs to Kissassist_Buffs.ini file
        /for i 0 to 40
            /if (${Window[BuffWindow].Child[BW_Buff${i}_Button].Child[Buff${i}].Tooltip.Find[(]}) {
                /varset BuffList ${Window[BuffWindow].Child[BW_Buff${i}_Button].Child[Buff${i}].Tooltip.Arg[1,(].Left[-1]}
            } else {
                /varset BuffList ${Window[BuffWindow].Child[BW_Buff${i}_Button].Child[Buff${i}].Tooltip}
            }
            /if (${BuffList.Length}) {
                DEBUGN WriteBuffs: ${i}-${BuffList}
                /if (${BuffList.Find[:Permanent]}>1) /varset BuffList ${BuffList.Left[${Math.Calc[${BuffList.Find[:Permanent]}-1]}]}
                /varset Writebufflist ${Writebufflist}${BuffList}|
            }
        /next i
        /ini "${KABuffsIni}" "${Me.ID}" Buffs "${Writebufflist}"
        /delay 15
        | Write all blocked buffs to Kissassist_Buffs.ini file
        /for k 1 to ${BlockedBuffsCount}
            /varset Blockedbuff ${Me.BlockedBuff[${k}].Name}
            /if (${Blockedbuff.Length} && ${Blockedbuff.NotEqual[null]}) {
                /varset Blockedbufflist ${Blockedbufflist}${Blockedbuff}|
            }
        /next k
        /if (${Blockedbufflist.Length}) /ini "${KABuffsIni}" "${Me.ID}" Blockedbuffs "${Blockedbufflist}"
        /if (${Window[BlockedBuffWnd].Open}) /windowstate BlockedBuffWnd close
        /varset WriteBuffsTimer 30s
		POPCALL
        DEBUGBUFFS WriteBuffs Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Write Buffs Merc state 4 = no gold membership
| ----------------------------------------------------------------------------
    Sub WriteBuffsMerc
        /if (!${Spawn[mercenary ${Group.Member[1].ID}].ID} || ${EverQuest.GameState.NotEqual[INGAME]}) /return
        /if (${WriteBuffsMercTimer}) /return
        /if (!${Redguides}) /return
        /if (${AggroTargetID}) /return
        /if (${DanNetOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS WriteBuffsmerc Enter
        /declare i int local 0
        /declare k int local 0
        /declare BuffList string local
        /declare Writebufflist string local
        /call CleanBuffsFile
        | Write day of the month and hour. Entry will be deleted if more than a hour old
        /if (!${Ini["${KABuffsIni}",${Spawn[mercenary ${MyMerc}].ID},Day].Length}) /ini "${KABuffsIni}" "${Spawn[mercenary ${MyMerc}].ID}" Day "${Time.Day}"
        /if (!${Ini["${KABuffsIni}",${Spawn[mercenary ${MyMerc}].ID},Hour].Length}) /ini "${KABuffsIni}" "${Spawn[mercenary ${MyMerc}].ID}" Hour "${Time.Hour}"
        /if (!${Ini["${KABuffsIni}",${Spawn[mercenary ${MyMerc}].ID},Zone].Length}) /ini "${KABuffsIni}" "${Spawn[mercenary ${MyMerc}].ID}" Zone "${Zone.ID}"
        /if (!${Ini["${KABuffsIni}",${Spawn[mercenary ${MyMerc}].ID},Buffs].Length}) /ini "${KABuffsIni}" "${Spawn[mercenary ${MyMerc}].ID}" Buffs
        | Write all current buffs to Kissassist_Buffs.ini file
        /call TargetThis ${Spawn[mercenary ${MyMerc}].ID}
        /delay 20
		|
		| Why is this capped at 15?
		|
        /for i 1 to 15
            DEBUGBUFFS WriteBuffsMerc ${i} ${Target.Buff[${i}]}
            /if (${Target.Buff[${i}].Name.Length}) {
                /varset BuffList ${Target.Buff[${i}]}
            } else {
                /varset BuffList
            }
            /if (${BuffList.Length}) {
                DEBUGBUFFS WriteBuffsMerc: ${i}-${BuffList}
                /varset Writebufflist ${Writebufflist}${BuffList}|
            }
        /next i
        /ini "${KABuffsIni}" "${Spawn[mercenary ${MyMerc}].ID}" Buffs "${Writebufflist}"
        /delay 15
        /varset WriteBuffsMercTimer 30s
		POPCALL
        DEBUGBUFFS WriteBuffsMerc Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Write Buffs Pet
| ----------------------------------------------------------------------------
    Sub WriteBuffsPet
        /if (!${Pet.ID} || ${EverQuest.GameState.NotEqual[ingame]}) /return
        /if (${AggroTargetID}) /return
        /if (!${Select[${Role},pettank,pullerpettank,hunterpettank,petofftank]} && ${Spawn[${MainAssist} ${MainAssistType}].ID}!=${Pet.ID}) /return
        /if (${WriteBuffsPetTimer}) /return
        /if (${DanNetOn}) /return
        /if (!${Redguides}) /return
		
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
				
        DEBUGBUFFS WriteBuffPet Enter
        /declare i int local 0
        /declare k int local 0
        /declare Blockedbuff string local
        /declare Blockedbufflist string local
        /declare BuffList string local
        /declare Writebufflist string local
        /call CleanBuffsFile
        | Write day of the month and hour. Entry will be deleted if more than a hour old
        /if (!${Ini["${KABuffsIni}",${Pet.ID},Day].Length}) /ini "${KABuffsIni}" "${Pet.ID}" Day "${Time.Day}"
        /if (!${Ini["${KABuffsIni}",${Pet.ID},Hour].Length}) /ini "${KABuffsIni}" "${Pet.ID}" Hour "${Time.Hour}"
        /if (!${Ini["${KABuffsIni}",${Pet.ID},Zone].Length}) /ini "${KABuffsIni}" "${Pet.ID}" Zone "${Zone.ID}"
        /if (!${Ini["${KABuffsIni}",${Pet.ID},Buffs].Length}) /ini "${KABuffsIni}" "${Pet.ID}" Buffs
        | Write all current buffs to Kissassist_Buffs.ini file
        /call TargetThis ${Pet.ID}
        /delay 20
        /for i 1 to 50
            DEBUGBUFFS WriteBuffPet ${i} ${Target.Buff[${i}]}
            /if (${Me.PetBuff[${i}].Name.Length}) {
                /varset BuffList ${Me.PetBuff[${i}]}
            } else {
                /varset BuffList
            }
            /if (${BuffList.Length}) {
                DEBUGBUFFS WriteBuffPet: ${i}-${BuffList}
                /varset Writebufflist ${Writebufflist}${BuffList}|
            }
        /next i
        /ini "${KABuffsIni}" "${Pet.ID}" Buffs "${Writebufflist}"
        /delay 15
        | Write all blocked buffs to Kissassist_Buffs.ini file
        /for k 0 to 39
            /varset Blockedbuff ${Me.BlockedPetBuff[${k}].Name}
            /if (${Blockedbuff.Length} && ${Blockedbuff.NotEqual[null]}) {
                /varset Blockedbufflist ${Blockedbufflist}${Blockedbuff}|
            }
        /next k
        /if (${Blockedbufflist.Length}) /ini "${KABuffsIni}" "${Pet.ID}" Blockedbuffs "${Blockedbufflist}"
        /if (${Window[BlockedPetBuffWnd].Open}) /windowstate BlockedPetBuffWnd close
        /varset WriteBuffsPetTimer 30s
		POPCALL
        DEBUGBUFFS WriteBuffsPet Leave
    /return
