
| ---------------------------------------------------------------------------
| SUB: Bind_DoThis
|
| Calls CastHotSwap with what you want to do. E.g. a spell name, item, ability, food?
| ---------------------------------------------------------------------------
	Sub Bind_DoThis(string WhatIsIt, string ToWho)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/declare ToWhoID	int		NULL

		/if (${ToWho.Length} && ${ToWho.NotEqual[NULL]}) {
			/varset ToWhoID ${Spawn[=${ToWho}].ID}
		}
		/if (!${WhatIsIt.Length} || ${WhatIsIt.Equal[NULL]}) {
			/echo Usage: /dothis "spell or ability or command" "target id or name or empty"
			POPCALL
			/return
		}
		/stopcast
		/if (${ToWhoID}) {
			/call CastHotSwap "${WhatIsIt}" ${ToWhoID} FROMHERE
		} else {
			/call CastHotSwap "${WhatIsIt}" NULL FROMHERE
		}
		POPCALL
	/return
	
| ----------------------------------------------------------------------------
| SUB: Bind Kiss Cast - To allow calling Kiss Internal Casting Routine
| ----------------------------------------------------------------------------
    Sub Bind_KissCast(string KCastWhat, int KWhatID, int ForceInterrupt)
        /if (${KCastWhat.Equal[null]} || !${KCastWhat.Length}) /return
        /if (${Me.Hovering} || ${Me.Feigning}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        | castWhat,int WhatID,string sentFrom,int CondNumber
        DEBUGCAST Bind_KissCast Enter \aw ${KCastWhat} ID: ${KWhatID} ForceInterrupt: ${ForceInterrupt}
        /declare WasCastingSpell string local null
        | I am sure we will need to add code for Bards, But not just sure what to check.
        | Will come back later and add code.
        | ******************************************************************************
        | If I am casting, then I am in the middle of the castwhat routine and need to Interrupt
        | casting current spell(ForceInterrupt==1) or I need to exit this Bind Routine.
        | Start ************************************************************************
        /if (${Me.Casting.ID} && ${Window[CastingWindow].Open}) {
            /if (${ForceInterrupt}) {
                /varset WasCastingSpell ${Me.Casting}
                /stopcast
                /delay 5
            } else {
                /echo Skipped KissCasting ${KCastWhat} I am busy casting ${Me.Casting}
				POPCALL
                /return
            }
        }
        | End ***************************************************************************
        | If a casting target was not passed then set myself as the casting target.
        /if (!${KWhatID}) /varset KWhatID ${Me.ID}
        DEBUGCAST Bind_KissCast \aw WhatID: ${KWhatID} ForceInterrupt: ${ForceInterrupt} WasCastingSpell: ${WasCastingSpell}
        /call CastWhat "${KCastWhat}" ${KWhatID} "KissCast" 0 0 FROMHERE
        | If previous cast interrupted we need to let spell casting routine it is no longer valid and was cancelled.
        /if (${WasCastingSpell.NotEqual[null]}) {
            /varset CastResult CAST_CANCELLED
        } else {
            /varset CastResult CAST_NO_RESULT
        }
		POPCALL
        DEBUGCAST Bind_KissCast \awLeave ${CastResult}
    /return

| -------------------------------------------------------------------------------------
| SUB: CastAA
|--------------------------------------------------------------------------------------
    Sub CastAA(string WhatAA,int WhatID,string sentFrom, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastAA Enter from ${FromWhere} - ${WhatAA} ${Me.AltAbility[${WhatAA}].Spell.CastTime} ${sentFrom} 
        /if (${Select[${WhatAA},Banestrike,15073]} && !${Banestrike.Find[|${Target.Race}|]} && ${Spawn[id ${MyTargetID}].Distance3D}>70 && ${CombatStart}) {
			POPCALL
			/return
		}
        /if (${Me.Invis} && !${Select[${sentFrom},SingleHeal,GroupHeal]}) {
            /varset CastResult CAST_CANCELLED
			POPCALL
            /return CAST_CANCELLED
        }
        
        /if (${IAmABard}) {
            /if (${Me.AltAbility[${WhatAA}].Spell.CastTime}>0) {
                /call CastBardCheck FROMHERE 0
            } else {
                /call CastBardCheck FROMHERE 1
            }
        }
        /varset IAMCastingID ${Me.AltAbility[${WhatAA}].Spell.ID}
        /alt act ${Me.AltAbility[${WhatAA}].ID}
        DEBUGCAST Before While: ${WhatAA} ${IAMCastingID} ${Me.Casting.ID} ${Window[CastingWindow].Open}
        /if (${Me.AltAbility[${WhatAA}].Spell.CastTime}>0) /delay 10 ${Window[CastingWindow].Open}
        /while (1) {
            /call DoCastingEvents
            /if (${sentFrom.Find[pull]} && ${PullAggroTargetID}) {
                /varset castReturn CAST_SUCCESS
                /break
            }
            /if (!${IAmABard}) {
                /if (!${Me.AltAbilityReady[${WhatAA}]} && !${Me.Casting.ID}) {
                    /varset castReturn CAST_SUCCESS
                    /break
                } else /if (!${Me.Casting.ID}) {
                    /if (${castReturn.Equal[x]}) /call DoCastingEvents 2
                    /break
                }
            } else {
                | 1 - singing Quick Cast AA and AA NotReady
                | 3 - Not Singing Cast AA and AA NotReady and Not Casting.
                /if (!${Me.AltAbilityReady[${WhatAA}]}) {
                    /if ((${Me.Casting.ID} && ${Me.Casting.ID}!=${IAMCastingID}) || !${Me.Casting.ID}) {
                        /varset castReturn CAST_SUCCESS
                        /break
                    }
                | 4 - Not Singing Cast AA and AA NotReady and still Casting. Continue/DropThrough
                } else {
                    | 2 - singing Quick Cast AA and AA Still Ready
                    | 5 - Not Singing Cast AA and AA Ready and Not Casting.
                    /if ((${Me.Casting.ID} && ${Me.Casting.ID}!=${IAMCastingID}) || (!${Me.Casting.ID} || !${Window[CastingWindow].Open})) {
                        /call DoCastingEvents 10 1
                        /break
                    }
                    | 6 - Not Singing Cast AA and AA Ready and still Casting. Continue/DropThrough
                }
                /if (!${Me.Casting.ID} || ${Me.Casting.ID}!=${IAMCastingID} || !${Window[CastingWindow].Open}) {
                    /break
                }
            }
        }
        /varset CastResult ${castReturn}
        DEBUGCAST After While: ${WhatAA} ${IAMCastingID} ${castReturn} ${WasTwisting}
        /if (${IAmABard}) {
            /if (${WasTwisting} && !${Twist}) /squelch /twist 
        }
		POPCALL
        DEBUGCAST CastAA Leave ${CastResult} ${Me.AltAbilityReady[${WhatAA}]}
    /return ${CastResult}

|--------------------------------------------------------------------------------------
| SUB: CastBardCheck
|--------------------------------------------------------------------------------------
    Sub CastBardCheck(string FromWhere, int ignorePlaying)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastBardCheck Enter from ${FromWhere}: Casting ${Me.Casting.ID} CastWindow ${Window[CastingWindow].Open}
        /if (${Twist}) {
            DEBUGCAST Twisting.  Seeing if I need to ignore.
            /varset WasTwisting TRUE
            /varset BardWasTwisting ${Twist.List}
            /if (!${ignorePlaying}) {
                DEBUGCAST IgnorePlaying ${ignorePlaying}
                /while (${Me.BardSongPlaying}) {
                    DEBUGCAST Turning twist off and stopping songs.
                    /if (${Twist}) /squelch /twist off
                    /delay 5
                    /if (${Me.Casting.ID}) /stopsong
                    /delay 30 !${Me.Casting.ID}
                }
            }
        } else {
            DEBUGCAST Was not twisting. Setting WasTwisting to False and stopping song if playing.
            /varset WasTwisting FALSE
            /if (${Me.BardSongPlaying}) {
                /stopsong
                /delay 5
            }
        }
        /call DoCastingEvents 10 1
        /varset CastResult CAST_NO_RESULT
		POPCALL
        DEBUGCAST CastBardCheck Leave ${Me.Casting.ID}
    /return

|--------------------------------------------------------------------------------------
| SUB: CastCommand
|--------------------------------------------------------------------------------------
    Sub CastCommand(string WhatSkill,int WhatID, string FromWhere)
 		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
       DEBUGCAST CastCommand Enter from ${FromWhere}
        |/declare CommandText string local ${WhatSkill.Replace[command:,]}
        /declare CommandText string local ${WhatSkill.Right[-8]}
        DEBUGCAST "${CommandText}"
        /docommand ${CommandText}
        /delay 5
        /varset CastResult CAST_SUCCESS
        DEBUGCAST CastCommand Leave
    /return ${CastResult}

|--------------------------------------------------------------------------------------
| SUB: CastDisc
|--------------------------------------------------------------------------------------
    Sub CastDisc(string WhatDisc,int WhatID,string sentFrom, string FromWhere)
 		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare WaitTimerCD timer local
        DEBUGCAST CastDisc Enter from ${FromWhere} - ${WhatDisc}
        /if (${Me.Invis} && !${Select[${sentFrom},SingleHeal,GroupHeal]}) {
            /varset CastResult CAST_CANCELLED
			POPCALL
            /return CAST_CANCELLED
        }
        /if (!${Spell[${WhatDisc}].Duration} || (${Spell[${WhatDisc}].Duration} && ${Spell[${WhatDisc}].TargetType.Equal[Self]} && !${Me.ActiveDisc.ID}) || ${Spell[${WhatDisc}].TargetType.NotEqual[Self]} || ${Spell[${WhatDisc}].DurationWindow}) {
            DEBUGCAST Well we passed the CastDisc checks...
            /if (${Spell[${WhatDisc}].RecastTime.TotalSeconds}) {
                /if (${Spell[${WhatDisc}].RecastTime.TotalSeconds} < 3) {
                    /varset WaitTimerCD ${Spell[${WhatDisc}].RecastTime.TotalSeconds}s
                } else {
                    /varset WaitTimerCD 30
                }
            } else {
                /varset WaitTimerCD 10
            }
            DEBUGCAST CastDisk ${WhatDisc} ${Me.CombatAbilityReady[${WhatDisc}]} ${WaitTimerCD}
            /while (${Me.CombatAbilityReady[${WhatDisc}]} && ${WaitTimerCD}) {
                /if (${MacroQuest.Build}!=4) {
                    /disc ${Me.CombatAbility[${Me.CombatAbility[${WhatDisc}]}].ID}
                } else {
                    |in old clients /disc only accepts name not ID
                    /disc ${WhatDisc}
                }
                /delay 1
                /if (${MacroQuest.Build}!=4) {
                    /if (${Spell[${WhatDisc}].MyCastTime}) /call CastWait "${WhatDisc}" FROMHERE
                } else {
                    /if (${Spell[${WhatDisc}].RecastTimerID} == -1) {
                        |we cant wait here for this on emu CombatAbilityReady always return true
                        /break
                    }
                }
                /delay 10 !${Me.CombatAbilityReady[${WhatDisc}]}
            }
            /varset CastResult CAST_SUCCESS
        } else {
            DEBUGCAST CastDisk ${WhatDisc} Skipping.
        }
		POPCALL
        DEBUGCAST CastDisc Leave
    /return ${CastResult}

| ----------------------------------------------------------------------------
| SUB: Cast DPS Spell Check ${Spell[${Spell[Gift of T'Vem].ID}].RecastTime}
| ----------------------------------------------------------------------------
    Sub CastDPSSpellCheck(SpellToCheck, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST DPSSpellCheck \awEnter from ${FromWhere}
        /declare i int local 0
        /declare k int local 0
        /if (${Target.Buff[${SpellToCheck}].ID} && ${Target.Buff[${SpellToCheck}].Caster.Equal[${Me}]}) {
            DEBUGCAST DPSSpellCheck ${SpellToCheck} is already on the target.
				POPCALL
                /return TRUE
        } else {
            /if (${Spell[${SpellToCheck}].HasSPA[470]}==TRUE) {
                /for k 1 to ${Spell[${SpellToCheck}].NumEffects}
                    /if (${Spell[${SpellToCheck}].Attrib[${k}]}==470) {
                        DEBUGCAST \atDEBUGCOMBAT DPSSpellCheck ${k} ${Target.Buff[${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].Name}].ID}==${Spell[${SpellToCheck}].Trigger[${k}].ID} ${Spell[${SpellToCheck}].Trigger[${k}].Name} && ${Target.Buff[${Spell[${Spell[${SpellToCheck}].Base2[${k}]}].Name}].Caster.Equal[${Me}]}
                        /if (${Target.Buff[${Spell[${SpellToCheck}].Trigger[${k}].Name}].ID} && ${Target.Buff[${Spell[${SpellToCheck}].Trigger[${k}].Name}].Caster.Equal[${Me}]}) {
                            DEBUGCAST \atDEBUGCOMBAT DPSSpellCheck The spell ${SpellToCheck}triggers ${Spell[${SpellToCheck}].Trigger[${k}].Name} is already on the target.
							POPCALL
                            /return TRUE
                        }
                    }
                /next k
            }
        }
		POPCALL
        DEBUGCAST DPSSpellCheck \awLeave
    /return FALSE

| ----------------------------------------------------------------------------
| SUB: CastHotSwap
|
| If a spell needs to be memmed, even in battle, mem a spell in the following
| Gem order: HotSwapGem, MiscGemLW, MiscGem, and last resort is last gem.
| HotSwapSpell does not remem the Hot Swap Gem, since it's intention is 
| on-the-fly emergency such as battle summoning a pet or special spell like
| call of the heroes, or whatever may need to be done NOW. Including special
| actions or use items.
| ----------------------------------------------------------------------------
    Sub CastHotSwap(string WhatIsThis,WhoID,string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastHotSwap: ENTER from ${FromWhere}
		
		/call CheckInvis
		/if (${Macro.Return.Equal[INVIS_TRUE]}) {
			POPCALL
			/return
		}
		
		/declare TheSpell		string		local	${WhatIsThis.Arg[1,|]}
		/declare CondNo			int			local	0
		/declare WhatMemSpell	int			local	${Me.Book[${Spell[${TheSpell}].RankName}]}
		/declare UseGem			int			local	0
		/declare RetrySwapCount	int			local	5
		/declare WaitTimerCM	timer		local	0
		/declare Success		int			local	0

		/if (!${TheSpell.Length}) {
			/echo CastHotSwap: No spell, action, or command provided.
			POPCALL
			/return
		}
		
		|
		| It could be an instacast / clicky. I'm removing bard and movement check.
		|
        /if (${Me.Casting.ID}) {
			POPCALL
			/return CAST_NOT_READY
		}

		|
		| If a condition was provided, get the number
		|
		|/call EstTimeToLive
        /if (${ConOn} && ${WhatIsThis.Find[|cond]}) {
			/varset CondNo ${WhatIsThis.Mid[${Math.Calc[${WhatIsThis.Find[|cond]}+5]},3]}
		}
		
		DEBUGCAST CastHotSwap: WhatIsThis ${WhatIsThis} TheSpell ${TheSpell} WhoID ${WhoID} CondNo ${CondNo} WhatMemSpell ${WhatMemSpell}
		
        /if (${Cursor.ID}) /call CheckCursor CastHotSwap 0
		/invoke (${Window[GiveWnd].DoClose})

		/if (${WhatMemSpell} && !${Me.Gem[${Spell[${TheSpell}].RankName}]}) {
			/if (${HotSwapGem}) {
				/varset UseGem ${HotSwapGem}
			} else /if (${MiscGemLW}) {
				/varset UseGem ${MiscGemLW}
			} else /if (${MiscGem}) {
				/varset UseGem ${MiscGem}
			} else {
				/varset UseGem ${Me.NumGems}
			}
		}
		
		DEBUGCAST CastHotSwap: WhatMemSpell ${WhatMemSpell} Gem ${Me.Gem[${Spell[${TheSpell}].RankName}]} UseGem ${UseGem}
		
		/while (${RetrySwapCount}) {
			/call LastMove	
			|/doevents GotHit
			/if (${WhatMemSpell} && !${Me.Gem[${Spell[${TheSpell}].RankName}]}) {
				/varset DontMoveMe 1
				DEBUGCAST CastHotSwap: CastMemSpell "${Spell[${TheSpell}].RankName}" ${UseGem}
				/call CastMemSpell "${Spell[${TheSpell}].RankName}" ${UseGem} 0 FROMHERE
				/varset DontMoveMe 0
				/delay 5
			}
			/if (${WhatMemSpell} && ${Me.Gem[${Spell[${TheSpell}].RankName}]}) {
				DEBUGCAST CastHotSwap: WaitUntilAble "${Spell[${TheSpell}].RankName}"
				/call WaitUntilAble "${Spell[${TheSpell}].RankName}" FROMHERE
				/if (${Macro.Return.NotEqual[WAIT_READY]}) {
					/varcalc RetrySwapCount ${RetrySwapCount}-1
					/delay 5
					/continue
				}
			}
						
			/if (${WhatMemSpell}) {
				/call CastWhat "${Spell[${TheSpell}].RankName}" ${WhoID} CastHotSwap ${CondNo} 0 FROMHERE
			} else {
				/call CastWhat "${TheSpell}" ${WhoID} CastHotSwap ${CondNo} 0 FROMHERE
			}
			
			DEBUGCAST CastHotSwap: Macro.Return ${Macro.Return}
			
			/if (${Macro.Return.Equal[CAST_SUCCESS]} || ${Macro.Return.Equal[X]}) {
				/varset Success 1
				/break
			} else /if (${Macro.Return.Equal[CAST_FAILED]}) {
				/varset Success 0
				/continue
			} else /if (${Macro.Return.Equal[CAST_CANCELLED]}) {
				/varset Success 0
				/break
			} else /if (${Macro.Return.Equal[CAST_NO_RESULT]}) {
				/varset Success 0
				/break
			} else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
				/varset Success 0
				/break
			} else {
				/varset Success 0
				/break
			}
			/varcalc RetrySwapCount ${RetrySwapCount}-1
			/delay 5
		}
        /if (${WhatMemSpell} && ${Me.Gem[${MiscGemLW}].Name.NotEqual[${ReMemMiscSpellLW}]} && ${MiscGemRemem}) {
            /varset DontMoveMe 1
            /call CastMemSpell "${ReMemMiscSpellLW}" ${MiscGemLW} 0 FROMHERE
            /varset DontMoveMe 0
        }		
        /if (${WhatMemSpell} && ${Me.Gem[${MiscGem}].Name.NotEqual[${ReMemMiscSpell}]} && ${MiscGemRemem}) {
            /varset DontMoveMe 1
            /call CastMemSpell "${ReMemMiscSpell}" ${MiscGem} 0 FROMHERE
            /varset DontMoveMe 0
        }
		/if (${Success}) {
			POPCALL
			/return CAST_SUCCESS
		} else {
			POPCALL
			/return CAST_FAILED
		}
		POPCALL
        DEBUGCAST CastHotSwap: EXIT
   /return

|--------------------------------------------------------------------------------------
| SUB: CastInterruptBuffs
|--------------------------------------------------------------------------------------
    Sub CastInterruptBuffs(string CIBSpell, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST Enter from ${FromWhere}
        /if (!${Me.Casting.ID}) {
			POPCALL
			/return
		}
        /if (${Me.Casting.Range}==0 && ${Me.Casting.AERange}==0) {
			POPCALL
			/return
		}
        /if (${Me.Invis}) {
            /stopcast
            /varset CastResult CAST_CANCELLED
            /echo ${CIBSpell} interrupted because I am now invised.
            DEBUGCAST CheckBUFFS1: ${Me.Invis}
			POPCALL
            /return
        }
        /if ((${Target.ID} && ${Target.PctHPs}<1) || (${Target.Type.Equal[corpse]})) {
            /stopcast
            /varset CastResult CAST_CANCELLED
            /echo ${CIBSpell} interrupted because target dead or not valid.
            DEBUGCAST CheckBUFFS2: ${Int[${Target.PctHPs}]} ${Target.Type}  ${Int[${Target.ID}]} ${Me.Casting} ${Me.Casting.TargetType}
        }
        /if (${Me.Casting.TargetType.NotEqual[self]}) {
            /if ((${Me.Casting.Range}>0 && ${Target.Distance}>${Me.Casting.Range}) || (${Me.Casting.AERange}>0 && ${Target.Distance}>${Me.Casting.AERange})) {
                /stopcast
                /varset CastResult CAST_CANCELLED
                /echo ${CIBSpell} interrupted because target out of range.
                DEBUGCAST CheckBUFFS3: ${Int[${Me.Casting.ID}]}  ${Target.Distance} ${Me.Casting.Range} ${Me.Casting.AERange} ${Me.Casting}
            }
        }
        /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
            /stopcast
            /varset CastResult CAST_CANCELLED
            /echo ${CIBSpell} interrupted because we now have aggro.
            DEBUGCAST CheckBUFFS4: ${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}
        }
		POPCALL
        DEBUGCAST Leave
    /return

|--------------------------------------------------------------------------------------
| SUB: CastInterruptDPS
|--------------------------------------------------------------------------------------
    Sub CastInterruptDPS(string CIDSpell, string FromWhere)
        /if (!${Int[${Me.Casting.ID}]} || ${Target.Type.Equal[pc]}) /return
		
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST Enter from ${FromWhere}
        /declare MAInterruptAt int local ${If[${SingleHealPointMA}<70,${SingleHealPointMA},70]}
		/declare PetInterruptAt int local ${SingleHealPointPet}
		/if (!${SingleHealPointPet}) /varset PetInterruptAt 40

        /if (${Target.PctHPs}<1 || ${Target.Type.Equal[corpse]} || !${Int[${Target.ID}]}) {
            /stopcast
            /varset CastResult CAST_CANCELLED
            /echo ${CIDSpell} interrupted due to Killing corpses is not required.
            DEBUGCAST CheckDPS1: ${Target.PctHPs} ${Target.Type} ${Int[${Target.ID}]}
        }
        /if (${HealsOn}) {
            |/if (!${IAmMA} && ${Spawn[=${MainAssist}].PctHPs}<70 && ${Spawn[${MainAssist} ${MainAssistType}].ID} && ${Spawn[${MainAssist} ${MainAssistType}].Type.NotEqual[corpse]} && ${Select[${Me.Class.ShortName},nec,mag]}==0) {
            /if (!${IAmMA} && ${Spawn[=${MainAssist}].PctHPs}<${MAInterruptAt} && ${Spawn[${MainAssist} ${MainAssistType}].ID} && ${Spawn[${MainAssist} ${MainAssistType}].Type.NotEqual[corpse]} && ${Select[${Me.Class.ShortName},nec,mag]}==0) {
                /stopcast
                /varset CastResult CAST_CANCELLED
                /echo ${CIDSpell} interrupted due to The Main Assist Needs a Heal.
                DEBUGCAST CheckDPS2: ${HealsOn}  ${Spawn[=${MainAssist}].PctHPs} ${Spawn[${MainAssist} ${MainAssistType}].ID}  ${Spawn[${MainAssist} ${MainAssistType}].Type}
				/call CheckHealth FROMHERE
            |} else /if (${Select[${Role},pettank,pullerpettank,hunterpettank]}>0 && ${Pet.ID} && ${Pet.PctHPs}<80) {
            } else /if (${Select[${Role},pettank,petofftank,pullerpettank,hunterpettank]} && ${Pet.ID} && ${Pet.PctHPs}<${PetInterruptAt} && ${SingleHeal.Size}>0) {
                /stopcast
                /varset CastResult CAST_CANCELLED
                /echo ${CIDSpell} interrupted due to my Pet Tank needs a heal.
                DEBUGCAST CheckDPS3: ${HealsOn}  ${Pet.ID} ${Pet.PctHPs}
				/call DoPetHealStuff FROMHERE
            }		
        }
		POPCALL
        DEBUGCAST Leave
    /return

|--------------------------------------------------------------------------------------
| SUB: CastInterruptHeals
|--------------------------------------------------------------------------------------
    Sub CastInterruptHeals(string CIHSpell, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST Enter from ${FromWhere}
		|
		| Why the hardcoded values in here? Shouldn't it follow the cond?
		|
        /if (!${Int[${Me.Casting.ID}]}) {
			POPCALL
			/return
		}
        | Check heal target is not an npc unless spell is detrimental like a tap or nuke type heal
        /if (${Target.Type.Equal[npc]} && ${Spell[${CIHSpell}].SpellType.NotEqual[Detrimental]}) {
            /stopcast
            /varset CastResult CAST_CANCELLED
            /echo ${CIHSpell} interrupted. Target is an NPC
            DEBUGCAST CheckHP1: ${Target.Type}
        }
        | Override default heal interupts if caster MA and has his own healing set. ie pally or sk
        |/if (${Target.Type.NotEqual[npc]} && ${SHealPct}>65 && ${Target.PctHPs}>${SHealPct} && !${CIHSpell.Find[promised]}) {
		/if (${Target.Type.NotEqual[npc]} && ${Target.PctHPs}>${SHealPct} && !${CIHSpell.Find[promised]}) {
            /stopcast
            /varset CastResult CAST_CANCELLED
			|
			| Using cleanname
			|
            /echo ${CIHSpell} interrupted. Target is above required ${SHealPct}% health. ${Target.CleanName}
            DEBUGCAST CheckHP2: ${Target.PctHPs} ${SHealPct}
        }
		POPCALL
        DEBUGCAST Leave
    /return

|--------------------------------------------------------------------------------------
| SUB: CastItem
|--------------------------------------------------------------------------------------
    Sub CastItem(string WhatItem,int WhatID,string sentFrom, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare ItemCastTime float local 0
        DEBUGCAST CastItem Enter from ${FromWhere}
        | Prevent casting of Prestige items on silver and F2P accounts
        /if (${Me.Subscription.NotEqual[gold]} && ${FindItem[=${WhatItem}].Prestige}) {
            POPCALL
            /return CAST_NO_RESULT
        }
        /if (${Me.Invis} && !${Select[${sentFrom},SingleHeal,GroupHeal]}) {
            /varset CastResult CAST_CANCELLED
			POPCALL
            /return CAST_CANCELLED
        }
        /varset ItemCastTime ${FindItem[=${WhatItem}].Clicky.CastTime.Float}
        /if (${IAmABard}) {
            | only pause twisting if Item needs the spell casting window.
            /if (${ItemCastTime}>0) {
                /call CastBardCheck FROMHERE 0
            } else {
                /call CastBardCheck FROMHERE 1
            }
            DEBUGCAST I am a bard CastItem ${WhatItem} ${ItemCastTime}
        }
        /useitem "${WhatItem}"
        /if (${ItemCastTime}>0) {
            /delay 10 ${Window[CastingWindow].Open}
            /while (1) {
                /call DoCastingEvents
                /if (${sentFrom.Find[pull]} && ${PullAggroTargetID}) {
                    /varset CastResult CAST_SUCCESS
                    /break
                }
                /if (!${Me.Casting.ID} || !${Window[CastingWindow].Open}) /break 
            }
        } else {
            /call DoCastingEvents
        }
        DEBUGCAST CastItem ${ItemCastTime} ${FindItem[=${WhatItem}].Spell.ID} ${Me.Casting.ID} ${Window[CastingWindow].Open}
        /varset CastResult ${castReturn}
        | Assign cast success if item on cooldown or summoned item consumed
        /if (!${Me.ItemReady[=${WhatItem}]} || !${FindItem[=${WhatItem}].ID} && !${Select[${CastResult},CAST_IMMUNE,CAST_RESISTED]})  /varset CastResult CAST_SUCCESS
        /if (${IAmABard}) {
            /if (${ItemCastTime}>0) {
                /if (${Me.Casting.ID}) /stopcast
            }
            /if (${WasTwisting} && !${Twist}) /squelch /twist 
        }
		POPCALL
        DEBUGCAST CastItem Leave
    /return ${CastResult}

|--------------------------------------------------------------------------------------
| SUB: CastMem
|--------------------------------------------------------------------------------------
    Sub CastMem(string WhatMemSpell,string sentFrom, string FromWhere)
        /if (!${IAmABard} && (${Me.Casting.ID} || ${Me.Moving})) /return notready
        /if (${Me.Invis} && !${Select[${sentFrom},SingleHeal,GroupHeal]}) {
            /varset CastResult CAST_CANCELLED
            /return notready
        }

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare WaitTimerCM timer local 0
        DEBUGCAST CastMem Enter from ${FromWhere}
		|
		| I think this is too restrictive. Sometimes healers have to change their lineup,
		| esp during long fights / raids. Commenting out.
		|
        | Prevent tanks and heals trying to mem spells during combat.
        |/if ((${Attacking} && ${IAmMA}) || (${HealsOn} && ${AggroTargetID} && ${sentFrom.NotEqual[Heal]} && !${Me.Mount.ID})) {
        |    /echo Cannot mem a spell during combat or while you have aggro. ${WhatMemSpell}
        |    /return notready
        |}
		|
		| Close the give window so we can mem a spell
		|
		/invoke (${Window[GiveWnd].DoClose})
        /if (${Cursor.ID}) /call CheckCursor CastMem 0
        /if (${MiscGemRemem} && ${MiscGemLW} && ${Spell[${WhatMemSpell}].RecastTime.TotalSeconds}>30) {
            /if (${ReMemWaitLong.Equal[null]}) {
                /echo RMWL: ${ReMemWaitLong} ${WhatMemSpell} ${ReMemWaitLong.Equal[${WhatMemSpell}]} ${Spell[${WhatMemSpell}].RecastTime.TotalSeconds}
                /varset ReMemWaitLong ${WhatMemSpell}
                /varset DontMoveMe 1
                /call CastMemSpell "${WhatMemSpell}" ${MiscGemLW} 0 FROMHERE
                /varset DontMoveMe 0
				POPCALL
                /return notready
            } else {
                /echo Still Waiting on Long Wait Spell ${ReMemWaitLong} 
				POPCALL
                /return notready
            }
        } else {
            /if (${Spell[${WhatMemSpell}].Mana}>${Me.CurrentMana}) {
                POPCALL
                /return notready
            }
            /varset ReMemWaitShort ${WhatMemSpell}
            /varset DontMoveMe 1
            /call CastMemSpell "${WhatMemSpell}" ${MiscGem} 0 FROMHERE
            /varset DontMoveMe 0
            /if (${Me.Gem[${WhatMemSpell}]}) {
                /varset WaitTimerCM 350
                /while (!${Me.SpellReady[${WhatMemSpell}]} && ${WaitTimerCM}) {
                    /if (${ChaseAssist}) {
                        /call DoWeChase 0 CastMem
                    } else {
                        DOPARSE
                        /delay 5
                    }
                    |/if (${sentFrom.Equal[buffs]} && ${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
                    /if (${Select[${sentFrom},buffs,buffs-nomem,buffonce,checkaura,summonstuff-nomem,dopetstuff,pet,pet-nomem]} && ${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
                        /varset CastResult CAST_CANCELLED
						POPCALL
                        /return notready
                    }
                }
            }
            /if (!${Me.Gem[${WhatMemSpell}]}) {
				POPCALL
				/return notready
			}
        }
		POPCALL
        DEBUGCAST CastMem Leave
   /return 1

|--------------------------------------------------------------------------------------
| SUB: CastMemSpell
|--------------------------------------------------------------------------------------
    Sub CastMemSpell(SpellToMem, int gemNum, int ForceIt, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastMemSpell Enter from ${FromWhere}
        /if (${Int[${SpellToMem.Length}]}==0 || ${SpellToMem.Equal[null]} || ${gemNum}==0) {
			POPCALL
			/return
		}

        /if (${Int[${Me.Gem[${SpellToMem}]}]}>0 && !${ForceIt}) {
			POPCALL
			/return
		}
        /if (${Cursor.ID} && ${Cursor.NoRent}) {
            /autoinventory
            /delay 10
        }
        | Unmem a spell if already memmed in a diffent gem
        /if (${ForceIt}) {
            /if (${Int[${Me.Gem[${SpellToMem}]}]}>0 && ${gemNum}!=${ForceIt}) {
                /notify CastSpellWnd CSPW_Spell${Int[${Math.Calc[${ForceIt}-1]}]} rightmouseup
                /delay 20 ${Int[${Me.Gem[${gemNum}].ID}]}==0
            }
        }
        /if (${Me.Book[${SpellToMem}]}) {
            /if (!${Cursor.ID}) {
                /if (${Int[${Me.Gem[${gemNum}].ID}]}>0) {
                    /notify CastSpellWnd CSPW_Spell${Int[${Math.Calc[${gemNum}-1]}]} rightmouseup
                    /delay 20 ${Int[${Me.Gem[${gemNum}].ID}]}==0
                }
                /if (!${Int[${Me.Gem[${gemNum}].Name.Length}]} || ${Me.Gem[${gemNum}].Name.NotEqual[${SpellToMem}]}) {
                    /if (${IAmABard}) {
                        /call CastBardCheck FROMHERE 0
                    }
                    /while (${Me.Moving}) {
                        DOPARSE
                        /delay 5
                    }
                    /echo Memming ${SpellToMem} in slot ${gemNum}
                    /if (${Stick.Active}) {
                        /stick pause
                        /MemSpell ${gemNum} "${SpellToMem}"
                        /delay 150 ${Me.Gem[${gemNum}].Name.Equal[${SpellToMem}]}
                        /stick unpause
                    } else {
                        /MemSpell ${gemNum} "${SpellToMem}"
                        /delay 150 ${Me.Gem[${gemNum}].Name.Equal[${SpellToMem}]}
                    }
                }
            } else {
                /echo Cannot Mem a spell with Items on Cursor. Please drop item to Inventory.
            }
        } else {
            /echo Could Not find the spell ${SpellToMem} in your spell book.
        }
		| Every single spell that is memmed the char pops up. Wastes time.
        |/if (${Window[SpellBookWnd].Open}) /windowstate spellbookwnd close
		POPCALL
        DEBUGCAST CastMemSpell FromWhere ${FromWhere} - ${SpellToMem} ${gemNum} ${ForceIt} ${Me.Gem[${gemNum}].Name}
        DEBUGCAST CastMemSpell Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: CastReady
| -------------------------------------------------------------------------------------
    Sub CastReady(string castWhat,string sentFrom, string FromWhere)
        /if (!${Bool[${castWhat}]}) /return 0

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Enter from ${FromWhere}

        /varset SpellReadyL 0
		/declare SpellTimerSec	timer	local 0
		
        /if (${sentFrom.Equal[rezwithcheck]}) {
            /if (${Select[TRUE,${Me.AltAbilityReady[${castWhat}]},${Me.ItemReady[=${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${Me.AbilityReady[${castWhat}]}]}==0) {
                /if (${Me.Book[${castWhat}]}) {
                    /if (!${Me.Gem[${castWhat}]}) {
						/echo Could not find rez spell ${castWhat}. Returning 5.
                        /varset SpellReadyL 5
                        /return ${SpellReadyL}
                    }
					/if (${Spell[${castWhat}].Mana}<=${Me.CurrentMana}) {
						/varset SpellReadyL 1
						/return ${SpellReadyL}
					} else {
						/return ${SpellReadyL}
					}
                }
            }
        } else /if (${sentFrom.Equal[singleheal]} || ${sentFrom.Equal[groupheal]}) {
            /if (${Me.Gem[${castWhat}]}) {
                | Should use WaitUntilAble here
				/varset SpellTimerSec 30s
                /while (${Me.SpellInCooldown} && ${SpellTimerSec}) {
                    /delay 2
                }
			}
        }
		| Need to add mana / endurance checks e.g. ${Spell[${castWhat}].Mana}<${Me.CurrentMana}
		/if (${Select[TRUE,${Me.AltAbilityReady[${castWhat}]},${Me.ItemReady[=${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${Me.AbilityReady[${castWhat}]},${Me.SpellReady[${castWhat}]}]}) {
			/varset SpellReadyL 1
		}
    /return ${SpellReadyL}
   
|--------------------------------------------------------------------------------------
| SUB: CastReMem
|--------------------------------------------------------------------------------------
    Sub CastReMem(string WhatMemSpell,int forceReMem,string sentFrom, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastReMem Enter from ${FromWhere}
        |We need to check if the spell just cast was swaped out and other spell needs to bo rememed.
        |Need a way to carry a flag so remem will be done out of combat after the spell has been cast.
        /if (${CastResult.Equal[CAST_SUCCESS]}) {
            |Is it the MiscGem?
            /if (${WhatMemSpell.Equal[${ReMemWaitShort}]}) {
                /varset ReMemCast 1
            |Is it the MiscGemLW
            } else /if (${WhatMemSpell.Equal[${ReMemWaitLong}]}) {
                /varset ReMemCastLW 1
            }
        }
        /if (!${forceReMem}) {
			POPCALL
			/return
		}
        /if (${sentFrom.Equal[buffs]} && ${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
			POPCALL
			/return
		}
        /if (${MiscGemRemem}==1 || ${MiscGemRemem}==2) {
            /if (!${Me.Gem[${ReMemMiscSpell}]} && ${ReMemCast} && !${CombatStart} && !${Me.Buff[Resurrection Sickness].ID} && !${sentFrom.Find[-nomem]}) {
                /if (${Cursor.ID}) /call CheckCursor CastReMem 0
                /varset DontMoveMe 1
                /call CastMemSpell "${ReMemMiscSpell}" ${MiscGem} 0 FROMHERE
                /varset DontMoveMe 0
                /varset ReMemCast 0
                /varset ReMemWaitShort null
            }
        }
        |Remem spell originally in Long Wait Gem slot
        /if ((${MiscGemRemem}==1 || ${MiscGemRemem}==3) && ${MiscGemLW} && ${ReMemWaitLong.NotEqual[null]}) {
            /if (${ReMemCastLW} && !${Me.Buff[Resurrection Sickness].ID}) {
                /if (${Cursor.ID}) /call CheckCursor CastReMem2 0
                /varset DontMoveMe 1
                /call CastMemSpell "${ReMemMiscSpellLW}" ${MiscGemLW} ${Int[${Me.Gem[${ReMemMiscSpellLW}]}]} FROMHERE
                /varset DontMoveMe 0
                /varset ReMemCastLW 0
                /varset ReMemWaitLong null
            }
        }
		POPCALL
        DEBUGCAST CastTarget Leave
    /return

|--------------------------------------------------------------------------------------
| SUB: CastSkill
|--------------------------------------------------------------------------------------
    Sub CastSkill(string WhatSkill,int WhatID,string sentFrom, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST CastSkill Enter from ${FromWhere}
        /if (${Me.Invis} && ${sentFrom.NotEqual[SingleHeal]}) {
            /varset CastResult CAST_CANCELLED
        } else {
            /doability "${WhatSkill}"
            /delay 20 !${Me.AbilityReady[${WhatSkill}]}
            /if (!${Me.AbilityReady[${WhatSkill}]}) /varset CastResult CAST_SUCCESS
            DEBUGCAST CastSkill Leave
        }
    /return ${CastResult}

|--------------------------------------------------------------------------------------
| SUB: CastSpell
|--------------------------------------------------------------------------------------
    Sub CastSpell(string WhatSpell,int WhatID,string sentFrom, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastSpell Enter from ${FromWhere} - Line#: ${WhatSpell} ID:${WhatID} SentFrom:${sentFrom} ${Me.GemTimer[${WhatSpell}]}
		| Bumping MaxTryNum from 2 to 3, the magic number.
        /declare MaxTryNum int local 3
        /declare TryNum int local 0
        /declare int_amIWasSitting bool local ${Me.Sitting}

        /if (${Me.Invis} && !${Select[${sentFrom},SingleHeal,GroupHeal]}) {
            /varset CastResult CAST_CANCELLED
			POPCALL
            /return CAST_CANCELLED
        }
        /if (!${Target.CanSplashLand} && ${Spell[${WhatSpell}].TargetType.Equal[Free Target]}) {
           /echo Splash Spell will not cast at targets location. Skipping ${WhatSpell}
		   POPCALL
           /return CAST_NO_RESULT
        }
        /if (${IAmABard}) {
            /call CastBardCheck FROMHERE
        }
        /if (${Me.Gem[${WhatSpell}]}) {
			| Seems to fix CAST_DISTRACTED
			/if (${Me.Sitting}) /stand
            /while (1) {
                /if (${Me.GemTimer[${WhatSpell}]}==0 || ${Me.SpellReady[${WhatSpell}]}) {
                    /cast "${WhatSpell}"
                    DEBUGCAST CastSpell cast "${WhatSpell}"
                    /call DoCastingEvents
                    DEBUGCAST CastSpell1 Return from DoCastingEvents 1 CastResult: ${CastResult} castReturn: ${castReturn}
					|
					| Return if out of components. Nothing can be done.
					|
					/if (${castReturn.Equal[CAST_COMPONENTS]}) {
                        POPCALL
                        /return ${castReturn}
                    }
                    /varcalc TryNum ${TryNum}+1
                    /while (${Me.Casting.ID} && ${Window[CastingWindow].Open} && ${CastResult.NotEqual[CAST_CANCELLED]}) {
                        /if (${CastingInterruptOn}) {
                            DEBUGCAST CastSpell ENTER Interrupts SentFrom ${sentFrom} Spell:${WhatSpell} CastID:${Me.Casting.ID}
                            /if (${sentFrom.Equal[SingleHeal]} && (${CastingInterruptOn}&4)==4) {
                               /call CastInterruptHeals "${WhatSpell}" FROMHERE
                            } else /if (${Select[${sentFrom},dps,gom,burn]}>0 && (${CastingInterruptOn}&8)==8) {
                               /call CastInterruptDPS "${WhatSpell}" FROMHERE
                            } else /if (${Select[${sentFrom},buffs,buffs-nomem,Regenother]}>0 && (${CastingInterruptOn}&2)==2) {
                               /call CastInterruptBuffs "${WhatSpell}" FROMHERE
                            }
                            |/delay 2
                            DEBUGCAST CastSpell LEAVE Interrupts SentFrom ${sentFrom}
                        }
                        /if (${sentFrom.Equal[pull]} && ${PullAggroTargetID}) {
                            /stopcast
							POPCALL
                            /return CAST_SUCCESS
                        }
                    }
                    /call DoCastingEvents 5
                    DEBUGCAST CastSpell2 Return from DoCastingEvents 2 CastResult: ${CastResult} castReturn: ${castReturn}
                    /if (${CastResult.Equal[CAST_CANCELLED]} || ${castReturn.Equal[x]}) /break
                    /varset CastResult ${castReturn}
                }
                |Don't change this it has to be PullAggroTargetID or you break ChainPulling.
                /if (${sentFrom.Equal[Pull]} && ${PullAggroTargetID}) {
                    POPCALL
                    /return CAST_SUCCESS
                }
                DEBUGCAST CastSpell3 ${Select[${CastResult},CAST_FIZZLE,CAST_INTERRUPTED,CAST_RESISTED]} ${Spell[${WhatSpell}].RecastTime.TotalSeconds} ${Me.GemTimer[${WhatSpell}]} ${Me.SpellReady[${WhatSpell}]}
                /if (${TryNum}<${MaxTryNum} && ${Select[${CastResult},CAST_FIZZLE,CAST_INTERRUPTED,CAST_RESISTED]}) {
                    /if  (${Spell[${WhatSpell}].RecastTime.TotalSeconds}<=2) {
                        /while (${Me.GemTimer[${WhatSpell}]} && !${Me.SpellReady[${WhatSpell}]}) {
                            /delay 5
                        }
                    } else {
                        /break
                    }
                } else {
                    /break
                }
            }
        } else {
            /echo Skip Casting ${WhatSpell}. Spell Not Memed.
            /varset CastResult CAST_NO_RESULT
        }
        /if (${IAmABard}) {
            /if (${Me.Casting.ID}) /stopcast
            /if (${WasTwisting} && !${Twist}) /squelch /twist 
        }
		|
		| Stop the meerkat peeking. Char will now sit itself back down after its been idle after a short time.
		|
        |/if (${int_amIWasSitting} && !${Me.Sitting} && !${CombatStart}) /sit
		POPCALL
        DEBUGCAST CastSpell Leave ${Me.GemTimer[${WhatSpell}]} ${CastResult}
    /return  ${CastResult}

|--------------------------------------------------------------------------------------
| SUB: CastTarget
|--------------------------------------------------------------------------------------
    Sub CastTarget(int CTWhatID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastTarget Enter \aw ID:${CTWhatID} Target:${Spawn[id ${CTWhatID}].CleanName}
        /if (${CTWhatID}) {
			/call TargetThis ${CTWhatID}
        }
		POPCALL
        DEBUGCAST CastTarget Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: CastWait
|--------------------------------------------------------------------------------------
    Sub CastWait(string WaitSpell,string sentFrom, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST CastWait Enter from ${FromWhere} - ${WaitSpell} ${Spell[${WaitSpell}].CastTime}
        /if (${Spell[${WaitSpell}].CastTime}) {
            /if (!${Me.Casting.ID} || !${Window[CastingWindow].Open}) /delay 5
            /while (${Me.Casting.ID} && ${Window[CastingWindow].Open}) {
                /if (${sentFrom.Find[pull]} && ${PullAggroTargetID}) {
                    /stopcast
                    /varset CastResult CAST_SUCCESS
                    /break
                }
                /delay 5
            }
        } else {
            /delay 5
            /varset CastResult CAST_SUCCESS
        }
        DEBUGCAST CastWait Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Cast Weave
| -------------------------------------------------------------------------------------
    Sub CastWeave(TarID, string FromWhere)
        /if (!${Select[${Me.State},stand,mount]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastWeave \awEnter from ${FromWhere}
        /declare i int local
        /declare DPSat1 int Local 0
        /declare DPSWeaveDelay timer local 2
        /declare DPSWeaveSpell string local
        /declare DPSWeaveArg3 string local
        /declare DPSWeaveArg4 string local
        /for i 1 to ${WeaveArray.Size}
            /varset DPSat1 ${Int[${WeaveArray[${i}].Arg[2,|]}]}
            /varset DPSWeaveSpell ${WeaveArray[${i}].Arg[1,|]}
            DEBUGN Cast DPSWeaveSpell:(${DPSWeaveSpell}) at (${DPSat1}%) ${i}
            /if (${DPSat1}==0 || !${TarID} || ${Spawn[id ${TarID}].Type.Equal[corpse]}) {
				POPCALL
				/return
			}
            /if (${DPSat1}<${Spawn[id ${TarID}].PctHPs} && ${DPSOn}==1) /continue
			|/call EstTimeToLive
            /if (!${ConOn} || !${WeaveArray[${i}].Find[|cond]} || ${If[${Cond[${WeaveArray[${i}].Mid[${Math.Calc[${WeaveArray[${i}].Find[|cond]}+5]},3]}]},1,0]}) {
                /if (${Me.AltAbilityReady[${WeaveArray[${i}].Arg[1,|]}]} || ${Me.ItemReady[${WeaveArray[${i}].Arg[1,|]}]} || ${Me.CombatAbilityReady[${WeaveArray[${i}].Arg[1,|]}]}) {
                    /if (${TargetSwitchingOn} && ${Target.ID} && ${Target.ID}!=${TarID}) {
                        /call CombatTargetCheck 1 FROMHERE
                        /varset TarID ${MyTargetID}
                    }
                    /call CastWhat "${DPSWeaveSpell}" ${TarID} WeaveStuff 0 0 FROMHERE
                    /while (${DPSWeaveDelay}) {
                        /doevents
                    }
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                        /echo -- Weaving: ${DPSWeaveSpell}
						POPCALL
                        /return 1
                    }
                }
            }
        /next i
		POPCALL
        DEBUGCAST CastWeave \awLeave
    /return 0

| -------------------------------------------------------------------------------------
| SUB: CastWhat
| -------------------------------------------------------------------------------------
    Sub CastWhat(string castWhat,int WhatID,string sentFrom,int CondNumber, int abortFlag, string FromWhere)
        /if (!${IAmABard} && ${Me.Casting.ID} && ${Window[CastingWindow].Open}) /return CAST_CASTING

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST CastWhat Enter from ${FromWhere} \aw ${castWhat} ID: ${WhatID} Target:${Spawn[id ${WhatID}].CleanName} SentFrom: ${sentFrom} Cond number ${CondNumber}
        /declare ReadyToCast       int      local 0
        /declare MemReturn         string   local null 
        /declare EventsCalcTimer   timer    local 0
        /declare str_TargetType    string   local ${Spell[${castWhat}].TargetType}
        /varset castReturn X
        /varset CastResult CAST_NO_RESULT
		
        /if (${castWhat.Find[command:]} || ${Me.AltAbility[${castWhat}]} || ${Me.CombatAbility[${castWhat}]} || ${FindItem[=${castWhat}].ID} || ${Me.Skill[${castWhat}]} || ${Me.Book[${castWhat}]}) {
            /if (${IAmABard}) {
                /varset ReadyToCast ${Select[TRUE,${Me.ItemReady[=${castWhat}]},${Me.AltAbilityReady[${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${If[${Me.AbilityReady[${castWhat}]} && ${Me.Skill[${castWhat}]},TRUE,FALSE]},${If[${Me.Gem[${castWhat}]} && ${Me.GemTimer[${castWhat}]}==0,TRUE,FALSE]},${Bool[${castWhat.Find[command:]}]}]}
                DEBUGCAST CastWhat \aw ${Me.ItemReady[=${castWhat}]},${Me.AltAbilityReady[${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${If[${Me.AbilityReady[${castWhat}]} && ${Me.Skill[${castWhat}]},TRUE,FALSE]},${If[${Me.Gem[${castWhat}]} && ${Me.GemTimer[${castWhat}]}==0,TRUE,FALSE]},${Bool[${castWhat.Find[command:]}]}
            } else {
                /varset ReadyToCast ${Select[TRUE,${Me.ItemReady[=${castWhat}]},${Me.AltAbilityReady[${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${If[${Me.AbilityReady[${castWhat}]} && ${Me.Skill[${castWhat}]},TRUE,FALSE]},${Me.SpellReady[${castWhat}]},${Bool[${castWhat.Find[command:]}]}]}
                DEBUGCAST CastWhat \aw ${Me.ItemReady[=${castWhat}]},${Me.AltAbilityReady[${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${If[${Me.AbilityReady[${castWhat}]} && ${Me.Skill[${castWhat}]},TRUE,FALSE]},${Me.SpellReady[${castWhat}]},${Bool[${castWhat.Find[command:]}]}
            }
            | Check for gems stuck or spell in book but not memed.
            /if (${ReadyToCast}==0 || ${Me.Casting.ID}) {
                /if (${Me.Book[${castWhat}]}) {
                    /if (!${IAmABard} && ${Me.Casting.ID} && !${Window[CastingWindow].Open}) {
                        /if (${CheckStuckGem}) /call CheckStuckGems
                        /if (${Me.Gem[${castWhat}]}) {
                            /varset ReadyToCast 5
                        } else {
                            /varset ReadyToCast 7
                        }
                    } else /if (!${FindItem[=${castWhat}].ID} && !${Me.Gem[${castWhat}]} && !${Me.AltAbility[${castWhat}]}) {
                        /varset ReadyToCast 7
                    }
                }
            }
            /if (${ReadyToCast}) {
                /if (${str_TargetType.Equal[null]}) {
                    /if (${ReadyToCast}==1) {
                        /varset str_TargetType ${FindItem[=${castWhat}].Spell.TargetType}
                    }
                }
                DEBUGCAST CastWhat \aw Target Info !${Target.ID} ${Target.ID}!=${WhatID} ${Spawn[id ${WhatID}].ID} ${ReadyToCast} ${str_TargetType}
                | Check if Castwhat has a conditon attached to it.
				|/call EstTimeToLive
                /if (${CondNumber}) {
                    /if (${Cond[${CondNumber}].Find[TARGETCHECK]}) {
                        /if (${str_TargetType.NotEqual[Self]} && (!${Target.ID} || (${Target.ID}!=${WhatID} && ${Spawn[id ${WhatID}].ID}))) /call CastTarget ${WhatID}
                    }
					DEBUGCAST CastWhat Cond${CondNumber} /noparse ${Cond[${CondNumber}]}
					DEBUGCAST CastWhat Evaluation ${If[${Cond[${CondNumber}]},0,1]}
					/if (${If[${Cond[${CondNumber}]},0,1]}) {
						POPCALL
						/return CAST_COND_FAILED
					}
				}
                /if (${str_TargetType.NotEqual[Self]} && (!${Target.ID} || (${Target.ID}!=${WhatID} && ${Spawn[id ${WhatID}].ID}))) /call CastTarget ${WhatID}
                | Check target for dps effects and stacking issues to prevent overcasting.
                /if (${sentFrom.Find[DPS]} && ${Spell[${castWhat}].SpellType.Equal[Detrimental]}) {
                    /if (!${Me.CombatAbilityReady[${castWhat}]} && !${Me.AbilityReady[${castWhat}]} && (${Me.AltAbilityReady[${castWhat}]} || ${Me.SpellReady[${castWhat}]})) {
                        /call CastDPSSpellCheck "${castWhat}" FROMHERE
                        DEBUGCAST CastWhat ${Macro.Return}
                        /if (${Macro.Return}) {
                            DEBUGCAST CastWhat --${castWhat} is already on Mob. Skipping.
							POPCALL
                            /return ${CastResult}
                        }
                    }
                | Check target for buffs and stacking issues to prevent overcasting.
                } else /if (${sentFrom.Find[Buffs]} && ${Spell[${castWhat}].SpellType.Find[Beneficial]} && ${WhatID}!=${Me.ID}) {
                    /call CastBuffsSpellCheck "${castWhat}" FROMHERE
                    DEBUGCAST CastWhat ${Macro.Return}
                    /if (${Macro.Return}) {
                        DEBUGCAST CastWhat --${castWhat} is already on Target. Skipping.
                        /varset CastResult CAST_HASBUFF
                        /varset HasBuffDuration ${Int[${Macro.Return}]}
						POPCALL
                        /return ${CastResult}
                    }
                } else /if (${sentFrom.Find[pull]} && ${PullAggroTargetID}) {
					POPCALL
                    /return
                }
                | Stop moving to Prevent cast interruption.
                /if (${Spell[${castWhat}].CastTime} && ${Me.Moving}) /call StopMoving
                | Check Castwhat for type item/aa/disc/skill/spell/command and send to correct sub
                DEBUGCAST CastWhat 2: --${castWhat} ${ReadyToCast} ${Me.SpellReady[${castWhat}]} && ${Me.Book[${castWhat}]} ${Me.Gem[${castWhat}]} && ${Me.GemTimer[${castWhat}]}==0
                /if (${ReadyToCast}==1 && ${Me.ItemReady[=${castWhat}]} && ${FindItem[=${castWhat}].ID}) {
                    /call CastItem "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
                } else /if (${ReadyToCast}==2 && ${Me.AltAbilityReady[${castWhat}]} && !${FindItem[=${castWhat}].ID}) {
                    /call CastAA "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
                } else /if (${ReadyToCast}==3 && ${Me.CombatAbilityReady[${castWhat}]} && ${Spell[${castWhat}].EnduranceCost}<${Me.Endurance}) {
                    /call CastDisc "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
                } else /if (${ReadyToCast}==4 && ${Me.AbilityReady[${castWhat}]}) {
                    /call CastSkill "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
                } else /if (${ReadyToCast}==5) {
                    /if (${Spell[${castWhat}].Mana}<${Me.CurrentMana}) {
                        /if (${Me.SpellReady[${castWhat}]} && ${Me.Book[${castWhat}]}) {
                            /call CastSpell "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
                        } else /if (${IAmABard} && ${Me.Gem[${castWhat}]} && !${Me.GemTimer[${castWhat}]}) {
                            /call CastSpell "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
                        }
						/if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
							POPCALL
							/return CAST_COMPONENTS
						}
                        /varset MemReturn ${CastResult}
                    } else {
                        /varset CastResult CAST_OUTOFMANA
						POPCALL
                        /return ${CastResult}
                    }
                } else /if (${ReadyToCast}==6 && ${castWhat.Find[command:]}) {
                    /call CastCommand "${castWhat}" ${WhatID} FROMHERE
                } else /if (${ReadyToCast}==7) {
                    /call CastMem "${castWhat}" ${sentFrom} FROMHERE
                    /varset MemReturn ${Macro.Return}
                    /if (${Macro.Return.NotEqual[notready]} && ${Me.Gem[${castWhat}]}!=0) {
                        /if (${Spell[${castWhat}].Mana}<${Me.CurrentMana}) {
                            /call CastSpell "${castWhat}" ${WhatID} ${sentFrom} FROMHERE
							/if (${Macro.Return.Equal[CAST_COMPONENTS]}) /return CAST_COMPONENTS
                        } else {
                            /varset CastResult CAST_OUTOFMANA
							POPCALL
                            /return ${CastResult}
                        }
                    }
                }
                /if (${sentFrom.Find[pull]} && ${PullAggroTargetID}) /return CAST_SUCCESS
                | Remem spell originally in Miscgem slot except if combat or just rezd
                | 0nly need to do this if ReadyToCast had a value other than 0.
                /if (${MiscGemRemem}) {
                    /if (${ReadyToCast}==7 && ${MemReturn.NotEqual[notready]}) {
                        /call CastReMem "${castWhat}" 0 ${sentFrom} FROMHERE
                    } else /if (${ReadyToCast}==5 && ${MemReturn.NotEqual[CAST_NO_RESULT]} && (${ReMemWaitLong.Equal[${castWhat}]} || ${ReMemWaitShort.Equal[${castWhat}]})) {
                        /call CastReMem "${castWhat}" 0 ${sentFrom} FROMHERE
                    }
                }
                /if (${IAmABard}) {
                    |/echo ${Twist} ${Twist.List.Length} ${Twist.List}
                    /if (!${Twist} && ${Twist.List.Length}) /squelch /twist
                }
            } else {
                /varset CastResult CAST_RECOVER
            }
        }
		POPCALL
        DEBUGCAST CastWhat \aw Leave ${CastResult}
    /return ${CastResult}

| ----------------------------------------------------------------------------
| SUB: DoCastingEvents
| ----------------------------------------------------------------------------
    Sub DoCastingEvents(int CastTimer, int actionFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST DoCastingEvents \awEnter
        /declare CastCalcTimer timer local 10
        /declare castHold string local ${castReturn}
        /if (${CastTimer}) /varset CastCalcTimer ${CastTimer}
        /while (${CastCalcTimer} && ${castHold.Equal[${castReturn}]}) {
            /doevents CAST_BEGIN
			|
			| Failed because you cannot cast on the mob.
			|
			/doevents CAST_CANNOTCAST
            /doevents CAST_CANNOTSEE
            /doevents CAST_COLLAPSE
            /doevents CAST_COMPONENTS
			/doevents CAST_COMPONENT
            /doevents CAST_DISTRACTED
            /doevents CAST_FDFAIL
            /doevents CAST_FIZZLE
            /doevents CAST_IMMUNE
            /doevents CAST_INTERRUPTED
            /doevents CAST_NOMOUNT
            /doevents CAST_NOTARGET
            /doevents CAST_NOTREADY
            /doevents CAST_OUTDOORS
            /doevents CAST_OUTOFMANA
            /doevents CAST_OUTOFRANGE
            /doevents CAST_RECOVER
            /varset CheckResisted 1
            /doevents CAST_RESISTED
            /varset CheckResisted 0
            /doevents CAST_RESISTEDYOU
            /doevents CAST_STANDING
            /doevents CAST_STUNNED
            /doevents CAST_TAKEHOLD
			/doevents CAST_TOOMANYABILITIES
            /doevents CAST_FAILED
			/doevents CAST_CURSOR
            /if (${actionFlag}) /break
        }
		POPCALL
        DEBUGCAST DoCastingEvents \awLeave ${CastCalcTimer} ${castHold} ${castReturn} ${Me.Casting.ID} ${Window[CastingWindow].Open}
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_BEGIN
| ----------------------------------------------------------------------------
    Sub Event_CAST_BEGIN(line,CBItem)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_BEGIN \awEnter ${line}
        /varset castReturn CAST_SUCCESS        
        DEBUGCAST Event_CAST_BEGIN \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_CANNOTCAST
| ----------------------------------------------------------------------------
    Sub Event_CAST_CANNOTCAST(Message,theSpell,theMob)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST Event_CAST_CANNOTCAST \awEnter
        /varset castReturn CAST_CANNOTCAST
		/echo You may not cast ${theSpell} on ${theMob}. Not having it. Not today. Permanently ignoring.
		/call Bind_AddToIgnore
		POPCALL
        DEBUGCAST Event_CAST_CANNOTSCAST \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_CANNOTSEE
| ----------------------------------------------------------------------------
    Sub Event_CAST_CANNOTSEE
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST Event_CAST_CANNOTSEE \awEnter
		/varset castReturn CAST_CANNOTSEE
		/call GetCloser los FROMHERE
		POPCALL
        DEBUGCAST Event_CAST_CANNOTSEE \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_COLLAPSE
| ----------------------------------------------------------------------------
    Sub Event_CAST_COLLAPSE
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_COLLAPSE \awEnter
        /varset castReturn CAST_COLLAPSE
        DEBUGCAST Event_CAST_COLLAPSE \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_COMPONENTS
| ----------------------------------------------------------------------------
    Sub Event_CAST_COMPONENTS
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_COMPONENTS \awEnter
        /varset castReturn CAST_COMPONENTS
        /doevents flush CAST_COMPONENTS
        DEBUGCAST Event_CAST_COMPONENTS \awLeave
    /return

| --------------------------------------------------------------------------
| SUB: Event_CAST_COMPONENT
| --------------------------------------------------------------------------
	Sub Event_CAST_COMPONENT(Message,WhatsMissing)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGCAST Event_CAST_COMPONENT \awEnter
		|
		| This is deliberate. We want the system to still react properly.
		| Yes, that is how you compare multi-word strings per Knightly
		|
		/varset castReturn CAST_COMPONENTS
		/if (!${Select[${WhatsMissing},"some required components"]}) {
			/echo You are out of ${WhatsMissing}. Restart KA when you get some.
			|
			| We want to see the message that is sent next that includes what is missing. Repeat until we see it.
			|
			/doevents flush CAST_COMPONENT
		}
		DEBUGCAST Event_CAST_COMPONENT \awLeave
	/return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_CURSOR
| ----------------------------------------------------------------------------
    Sub Event_CAST_CURSOR
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCAST Event_CAST_CURSOR \awEnter
		/call CheckCursor Event_CAST_CURSOR 1
        /doevents flush CAST_CURSOR		
		POPCALL
        DEBUGCAST Event_CAST_CURSOR \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_DISTRACTED
| ----------------------------------------------------------------------------
    Sub Event_CAST_DISTRACTED
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_DISTRACTED \awEnter
        /varset castReturn CAST_DISTRACTED
        DEBUGCAST Event_CAST_DISTRACTED \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_FAILED
| ----------------------------------------------------------------------------
    Sub Event_CAST_FAILED(line,name)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_FAILED \awEnter
        /varset castReturn CAST_FAILED
        DEBUGCAST Event_CAST_FAILED \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_FDFAIL
| ----------------------------------------------------------------------------
    Sub Event_CAST_FDFAIL(line,name)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_FDFAIL \awEnter
        /if (${name.Equal[${Me.Name}]} && ${Defined[castReturn]}) {
            /if (${Me.Sitting}) /stand
            /varset castReturn CAST_RESTART
        }
        DEBUGCAST Event_CAST_FDFAIL \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_FIZZLE
| ----------------------------------------------------------------------------
    Sub Event_CAST_FIZZLE
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_FIZZLE \awEnter
        /varset castReturn CAST_FIZZLE
        DEBUGCAST Event_CAST_FIZZLE \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_IMMUNE
| ----------------------------------------------------------------------------
    Sub Event_CAST_IMMUNE(line,name)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_IMMUNE \awEnter
        DEBUGCAST Event_CAST_IMMUNE \aw${line}
        /varset castReturn CAST_IMMUNE
        DEBUGCAST Event_CAST_IMMUNE \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_INTERRUPT
| ----------------------------------------------------------------------------
    Sub Event_CAST_INTERRUPTED
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_INTERRUPT \awEnter
        /varset castReturn CAST_INTERRUPTED
        DEBUGCAST Event_CAST_INTERRUPT \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_NOMOUNT
| ----------------------------------------------------------------------------
    Sub Event_CAST_NOMOUNT
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_NOMOUNT \awEnter
        /varset castReturn CAST_NOMOUNT
        DEBUGCAST Event_CAST_NOMOUNT \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_NOTARGET
| ----------------------------------------------------------------------------
    Sub Event_CAST_NOTARGET
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_NOTARGET \awEnter
        /varset castReturn CAST_NOTARGET
        DEBUGCAST Event_CAST_NOTARGET \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_NOTREADY
| ----------------------------------------------------------------------------
    Sub Event_CAST_NOTREADY
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_NOTREADY \awEnter
        /varset castReturn CAST_NOTREADY
        DEBUGCAST Event_CAST_NOTREADY \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_OUTDOORS
| ----------------------------------------------------------------------------
    Sub Event_CAST_OUTDOORS
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_OUTDOORS \awEnter
        /varset castReturn CAST_OUTOFMANA
        DEBUGCAST Event_CAST_OUTDOORS \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_OUTOFMANA
| ----------------------------------------------------------------------------
    Sub Event_CAST_OUTOFMANA
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_OUTOFMANA \awEnter
        /varset castReturn CAST_OUTOFMANA
        DEBUGCAST Event_CAST_OUTOFMANA \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_OUTOFRANGE
| ----------------------------------------------------------------------------
    Sub Event_CAST_OUTOFRANGE
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_OUTOFRANGE \awEnter
		/call GetCloser oor FROMHERE
        /varset castReturn CAST_OUTOFRANGE
        DEBUGCAST Event_CAST_OUTOFRANGE \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_RECOVER
| ----------------------------------------------------------------------------
    Sub Event_CAST_RECOVER
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_RECOVER \awEnter
        /varset castReturn CAST_RECOVER
        DEBUGCAST Event_CAST_RECOVER \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_RESISTED
| ----------------------------------------------------------------------------
    Sub Event_CAST_RESISTED(line,name)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_RESISTED \awEnter
        DEBUGCAST Event_CAST_RESISTED \aw${name.Length} ${CheckResisted}
        /if (!${CheckResisted}) /return
        /echo \aw${name} was Resisted \ag
        /if (${castReturn.NotEqual[CAST_IMMUNE]}) /varset castReturn CAST_RESISTED
        /varset LastResisted ${name}
        DEBUGCAST Event_CAST_RESISTED \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_RESISTEDYOU
| ----------------------------------------------------------------------------
    Sub Event_CAST_RESISTEDYOU(line,name)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_RESISTEDYOU \awEnter
        DEBUGCAST Event_CAST_RESISTEDYOU \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_STANDING
| ----------------------------------------------------------------------------
    Sub Event_CAST_STANDING
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_STANDING \awEnter
        /stand
        /varset castReturn CAST_RESTART
        DEBUGCAST Event_CAST_STANDING \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_STUNNED
| ----------------------------------------------------------------------------
    Sub Event_CAST_STUNNED
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_STUNNED \awEnter
        /if (${Me.Stunned}) {
            /delay 3s !${Me.Stunned}
        } else {
            /delay 7
        }
        /varset castReturn CAST_STUNNED
        DEBUGCAST Event_CAST_STUNNED \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_Success1
| ----------------------------------------------------------------------------
    Sub Event_CAST_SUCCESS1(line)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_SUCCESS1 \awEnter
        /varset castReturn CAST_SUCCESS
        DEBUGCAST Event_CAST_SUCCESS1 \awLeave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event_CAST_TAKEHOLD
| ----------------------------------------------------------------------------
    Sub Event_CAST_TAKEHOLD
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGCAST Event_CAST_TAKEHOLD \awEnter
        /varset castReturn CAST_TAKEHOLD
        DEBUGCAST Event_CAST_TAKEHOLD \awLeave
    /return
	
| ---------------------------------------------------------------------------
| SUB: Event_CAST_TOOMANYABILITIES
| ---------------------------------------------------------------------------
	Sub Event_CAST_TOOMANYABILITIES
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGCAST Event_CAST_TOOMANYABILITIES \awEnter
		/varset castReturn CAST_TOOMANYABILITIES
		/echo You cannot cast another aura or ability until you remove the other buff.
		DEBUGCAST Event_CAST_TOOMANYABILITIES \awLeave
	/return

| ---------------------------------------------------------------------------
| SUB: WaitUntilAble
|
| You need to cast something and it has to be done, so we wait. Some code
| Borrowed from CastWhat. Now we can dispense with all the one-offs
| like this in the code.
| ---------------------------------------------------------------------------
	Sub WaitUntilAble(WhatIsThis,string FromWhere)

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGCAST WaitUntilAble Enter from ${FromWhere}
	
		/declare WaitTimerMax		int		local 	30s
		/declare DelayTimer			int		local	5
		/declare CountDownTimer 	timer 	local	0
		/declare castWhat			string	local	${WhatIsThis.Arg[1,|]}
		/if (!${castWhat.Length}) {
			POPCALL
			/return WAIT_NO_SPELL
		}

		/varset CountDownTimer ${WaitTimerMax}
		/while (${CountDownTimer}) {
			/doevents GotHit
			/if (${Select[TRUE,${Me.ItemReady[=${castWhat}]},${Me.AltAbilityReady[${castWhat}]},${Me.CombatAbilityReady[${castWhat}]},${If[(${Me.AbilityReady[${castWhat}]} && ${Me.Skill[${castWhat}]}),TRUE,FALSE]},${Me.SpellReady[${castWhat}]},${Bool[${WhatIsThis.Find[command:]}]}]}) {
				/break
			} else {
           		/if (!${Me.Sitting} && !${Me.Mount.ID} && !${Me.Combat} && !${Me.CombatState.Equal[COMBAT]} && !${AggroTargetID}) /sit
            }
			/delay ${DelayTimer}
		}
		DEBUGCAST WaitUntilAble: CountDownTimer ${CountDownTimer} If 0 we timed out
		/if (!${CountDownTimer}) {
			POPCALL
			/return WAIT_READY_TIMEOUT
		}
		
		DEBUGCAST WaitUntilAble: The spell is ready
		/varset CountDownTimer ${WaitTimerMax}
		
		DEBUGCAST WaitUntilAble: Waiting for endurance / mana if necessary
		/while (${CountDownTimer}) {
			/doevents GotHit
			/if ((${Me.CombatAbility[${castWhat}]} && (${Spell[${castWhat}].EnduranceCost}<${Me.Endurance})) || (${Me.Book[${castWhat}]} && (${Spell[${castWhat}].Mana}<${Me.CurrentMana})) || (${Me.AltAbility[${castWhat}]} && (${Me.AltAbility[${castWhat}].Spell.Mana}<${Me.CurrentMana}))) {
				/break
			} else {
           		/if (!${Me.Sitting} && !${Me.Mount.ID} && !${Me.Combat} && !${Me.CombatState.Equal[COMBAT]} && !${AggroTargetID}) /sit
            }
			/delay ${DelayTimer}
		}
		/if (!${CountDownTimer}) {
			DEBUGCAST WaitUntilAble: Ran out of time medding...
			POPCALL
			/return WAIT_ENDMANA_TIMEOUT
		}
		POPCALL
		DEBUGCAST WaitUntilAble: Everything is a go!
	/return WAIT_READY
