
| ----------------------------------------------------------------------------
| SUB: AE check - cast area effect spells depending on set number of mobs
| ----------------------------------------------------------------------------
    Sub AECheck(int prm_ListMobs, string FromWhere)
        /if (!${AEOn}) /return
        /if (${Target.Type.Equal[corpse]}) /return
        /if (!${AggroTargetID}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
				
        DEBUGCOMBAT AECheck Enter from ${FromWhere}
        /declare i int local
        /declare j int local
        /declare AESpell string local
        /declare AEMobCount int local
        /declare AETarget string local
        /declare AETargetID int local
        /declare AERange int local
        /declare MobCountTemp int local 0
        /declare int_SpawnCountXT int local 0
        /declare int_SpawnCountAE int local 0
        /declare s_WorkSpawn spawn local
        
        /call MobRadar los ${AERadius} FROMHERE
        | Adjust mobcount by subtracting mobs not on xtarget
        DEBUGCOMBAT AECheck Mobcount: ${MobCount} ${prm_ListMobs}
        /if (!${MobCount}) {
			POPCALL
			/return
		}
        /varset MobCountTemp ${SpawnCount[npc xtarhater targetable los radius ${AERadius} zradius 50 noalert 3]}
        /if (${MobCountTemp}<=0) {
			POPCALL
			/return
		}
        /if (${TargetSwitchingOn} && ${Target.ID} && ${Target.ID}!=${MyTargetID} && ${CombatStart}) /call CombatTargetCheck 1 FROMHERE
        /for i 1 to ${AE.Size}
            /doevents GotHit
            /varset AESpell ${AE[${i}].Arg[1,|]}
            /if (${AESpell.Equal[null]}) /continue
            /varset AEMobCount ${AE[${i}].Arg[2,|]}
            /varset AETarget ${AE[${i}].Arg[3,|]}
            | Check if AEspell is ready to use if not skip it
            /if (${AESpell.NotEqual[burn]} && !${Me.SpellReady[${Spell[${AESpell}].RankName}]} && !${Me.AltAbilityReady[${AESpell}]} && !${Me.CombatAbilityReady[${Spell[${AESpell}].RankName}]} && !${Me.AbilityReady[${AESpell}]} && !${AESpell.Find[command:]}) /continue
            /if (${FindItem[=${AESpell}].ID} && !${Me.ItemReady[=${AESpell}]}) /continue
            /if (${AEMobCount}<=${MobCountTemp}) {
                /if (${AETarget.Equal[null]} || ${AETarget.Equal[Mob]} || ${AETarget.Equal[Single]}) {
                    /varset AETargetID ${MyTargetID}
                } else /if (${AETarget.Equal[Me]}) {
                    /varset AETargetID ${Me.ID}
                } else /if (${AETarget.Equal[MA]}) {
                    /varset AETargetID ${Spawn[=${MainAssist}].ID}
                } else /if (${AETarget.Equal[Pet]}) {
                    /varset AETargetID ${Pet.ID}
                } else /if (${AESpell.Equal[burn]} && !${BurnActive}) {
                    /echo AE-> ${MobCountTemp} Mobs: Activating BURN
                    /call Burn NULL FROMHERE
					POPCALL
                    /return
                }
                /varset AERange ${Spell[${AESpell}].AERange}
                /if (!${AERange}) {
                    /varset AERange ${AERadius}
                }
                /if (${Spawn[id ${AETargetID}].ID}) {
                    /vardata s_WorkSpawn Spawn[id ${AETargetID}].ID
                    /varset int_SpawnCountXT ${SpawnCount[npc xtarhater loc ${s_WorkSpawn.X} ${s_WorkSpawn.Y} radius ${AERange}]}
                    /varset int_SpawnCountAE ${SpawnCount[npc loc ${s_WorkSpawn.X} ${s_WorkSpawn.Y} radius ${AERange}]}
                    /if (${Me.XTarget[${XTSlot}].ID} && ${Me.XTarget[${XTSlot}].TargetType.NotEqual[Auto Hater]}) /varcalc int_SpawnCountXT ${int_SpawnCountXT}+1
                    DEBUGCOMBAT AECheck SpawnCountXT: ${int_SpawnCountXT} SpawnCountAE: ${int_SpawnCountAE} AERange: ${AERange}
                    /if (${AETarget.NotEqual[Single]}) {
                        /if (${s_WorkSpawn.ID} && ${int_SpawnCountXT} < ${int_SpawnCountAE}) {
                            /if (!${SpamTimer2}) {
                                /echo AE-> Casting ${AESpell} now would aggro more mobs(${int_SpawnCountAE}) than we have on xtarget(${int_SpawnCountXT})
                                /varset SpamTimer2 20
                            }
                            /if (${prm_ListMobs}) {
                                /for j 1 to ${int_SpawnCountAE}
                                    /vardata WorkSpawn NearestSpawn[${j},npc loc ${s_WorkSpawn.X} ${s_WorkSpawn.Y} radius ${AERange}].ID
                                    /echo Spawn Info: ${j} - ${WorkSpawn.Name} - Direction from you: ${WorkSpawn.HeadingTo} Mob X,Y: ${WorkSpawn.X},${WorkSpawn.Y} 
                                /next j
                                /vardata WorkSpawn ClearSpawnValue
                            }
                            /continue
                        }
                    }
					|/call EstTimeToLive
                    /if (!${ConOn} || !${AE[${i}].Find[|cond]} || ${If[${Cond[${AE[${i}].Mid[${Math.Calc[${AE[${i}].Find[|cond]}+5]},3]}]},1,0]}) {
                        /if (${AETarget.Equal[Single]}) {
                            /call CastWhat "${AESpell}" ${AETargetID} AoE 0 0 FROMHERE
                            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                /echo AE-> ${AESpell} on Single target  >> ${Spawn[id ${AETargetID}].CleanName} <<
                            }
                            /continue
                        } else {
                            /call CastWhat "${AESpell}" ${AETargetID} AoE 0 0 FROMHERE
                            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                /echo AE-> ${MobCountTemp} Mobs: Casting AE ${AESpell}
                            }
                        }
                    }
                } else {
                    /break
                }
            }
        /next i
		POPCALL
        DEBUGCOMBAT AECheck Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: AggroCheck
| -------------------------------------------------------------------------------------
    Sub AggroCheck(string FromWhere)
        /if (!${Me.HaveExpansion[Rain of Fear]} || ${Target.Type.Equal[corpse]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT AggroCheck Enter from ${FromWhere} - ${MyTargetID}
        /declare i            int    local
        /declare AggroSpell   string local
        /declare AggroGLT     string local
        /declare AggroPCT     int    local
        /declare AggroTarget  string local
        /declare AggroTID     int    local

        /if (${TargetSwitchingOn} && ${Target.ID} && ${Target.ID}!=${MyTargetID} && ${CombatStart}) /call CombatTargetCheck 1 FROMHERE
        /if (!${MyTargetID}) {
			POPCALL
			/return
		}
        /for i 1 to ${Aggro.Size}
            /if (${Target.Type.Equal[corpse]} || !${Target.ID}) /break
            /varset AggroSpell ${Aggro[${i}].Arg[1,|]}
            /varset AggroPCT ${Aggro[${i}].Arg[2,|]} 
            /varset AggroGLT ${Aggro[${i}].Arg[3,|]}
            /varset AggroTarget ${Aggro[${i}].Arg[4,|]}
            /if (${AggroGLT.Equal[<<]}) /varcalc AggroPCT ${AggroPCT}-100
            DEBUGCOMBAT AggroCheck ${Me.PctAggro} ${AggroGLT} ${AggroPCT} ${AggroSpell} ${Target.SecondaryPctAggro} ${AggroGLT.Equal[<<]}
			|/call EstTimeToLive
            /if (${ConOn} && ${Aggro[${i}].Find[|cond]} && ${If[${Cond[${Aggro[${i}].Mid[${Math.Calc[${Aggro[${i}].Find[|cond]}+5]},3]}]},0,1]}) /continue
            /if (${Me.SpellReady[${AggroSpell}]} || ${Me.AltAbilityReady[${AggroSpell}]} || ${Me.AbilityReady[${AggroSpell}]} || ${Me.CombatAbilityReady[${AggroSpell}]}) {
                | If I need to Gain more Aggro. My Aggro Check.
                /if (${AggroGLT.Equal[<]}) {
                    /if (${AggroPCT}<=${Me.PctAggro}) /continue
                | If I need to Gain more Aggro. Secondary Aggro Check.
                } else /if (${AggroGLT.Equal[<<]}) {
                    /if (!${Target.SecondaryPctAggro} || ${Target.SecondaryPctAggro}<${AggroPCT}) /continue
                | If I need to Loose Aggro    
                } else /if (${AggroGLT.Equal[>]}) {
                    /if (${AggroPCT}>${Me.PctAggro}) {
                        /continue
                    }
                } else {
                    /continue
                }
                /if (${Me.CombatAbility[${AggroSpell}]} && (${Spell[${AggroSpell}].Duration} && ${Spell[${AggroSpell}].TargetType.Equal[self]} && ${Me.ActiveDisc.ID})) /continue
                DEBUGCOMBAT Trying to control Aggro: ${Me.PctAggro} ${AggroGLT} ${AggroPCT} ${AggroSpell}
                /if (${Select[${AggroTarget},null,Mob]} || (${AggroTarget.Equal[INC]} && ${Spawn[id ${MyTargetID}].Distance}>${MeleeDistance})) {
                    /varset AggroTID ${MyTargetID}
                } else /if (${AggroTarget.Equal[Me]}) {
                    /varset AggroTID ${Me.ID}
                } else /if (${AggroTarget.Equal[MA]}) {
                    /varset AggroTID ${Spawn[=${MainAssist}].ID}
                } else /if (${AggroTarget.Equal[Pet]}) {
                    /varset AggroTID ${Pet.ID}
                } 
                /if (${AggroTarget.Equal[INC]} && ${Spawn[id ${MyTargetID}].Distance}<${MeleeDistance}) /continue
                /if (!${AggroTID}) /continue
                /call CastWhat "${AggroSpell}" ${AggroTID} Aggro 0 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                    /echo Casting >> ${AggroSpell} << to control AGGRO(${AggroGLT}) on ${Spawn[id ${AggroTID}].CleanName}.
                    /if (${AggroGLT.Equal[>]}) {
                        /if (!${AggroOffTimer}) {
                           /if (${Me.Feigning} || ${Me.Invis}) /varset AggroOffTimer 20
                        }
                    }
                    /break
                }
                /if (${AggroGLT.Equal[>]} && ${AggroPCT}>${Me.PctAggro}) /break
                /if (${AggroGLT.Equal[<<]} && ${Target.SecondaryPctAggro}<${AggroPCT}) /break
                /if (${AggroGLT.Equal[<]} && ${AggroPCT}<${Me.PctAggro}) /break
            }
        /next i
		POPCALL
        DEBUGCOMBAT AggroCheck Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Assist - Get Main Tank's target
| -------------------------------------------------------------------------------------
    Sub Assist(string FromWhere)
        /if (${DMZ} && ${Me.InInstance}==FALSE) /return
        /if (!${MeleeOn} && !${DPSOn} && !${MezOn}) /return
        /if (${DPSPaused}) /return
        /if (${Me.Hovering}) /return
        /if (${Pulled} && ${MyTargetID} && ${IAmMA}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		/if (!${AutoTargetOn}) {
			/if (${Pet.ID} && !${Target.ID}) {
				/call PetBackOff FROMHERE
			}
			POPCALL
			/return
		}

        DEBUGCOMBAT Enter from ${FromWhere}
        /declare TempTargetID 		int 	local
		/declare AssistDistance		int		local	${If[${MeleeDistance}>=200,${MeleeDistance},200]}
		
        /doevents
        /call MobRadar los ${MeleeDistance} FROMHERE
        | Normal assist check
        DEBUGCOMBAT 0: ${Me} ${MainAssist} ${IAmMA} ${Spawn[=${MainAssist}].Distance} ${MobCount} ${AggroTargetID} ${Target.ID} ${MyTargetID} ${Me.Combat}
        /if (${MobCount} || ${AggroTargetID}) {

            DEBUGCOMBAT 1: ${Me} ${MainAssist} ${IAmMA} ${Group.MainAssist.ID} ${Spawn[=${MainAssist}].Distance} ${MobCount} ${AggroTargetID} ${Me.XTarget[${XTSlot}].ID} ${Me.XTarget[${XTSlot2}].ID}

			| I am here but now the MA is a goner...and I'm offtank
			/if ((!${Spawn[=${MainAssist}].ID} || ${Spawn[=${MainAssist}].Type.Equal[corpse]}) && ${Select[${Role},OFFTANK_ROLES]}) {
				POPCALL
				/return switch
			}	
			
			| If the MA is alive, then we assist.
			/if (${Spawn[=${MainAssist}].ID} && ${Spawn[=${MainAssist}].Type.NotEqual[corpse]}) {
				| If the MA is within AssistDistance then get their target
				/if (${Spawn[=${MainAssist}].Distance}<${AssistDistance}) {
				
                    DEBUGCOMBAT Assist1: ${Me} ${MainAssist} ${IAmMA} ${Group.MainAssist.ID} ${Spawn[=${MainAssist}].Distance} ${MobCount} ${AggroTargetID} ${Me.XTarget[${XTSlot}].ID} ${Me.XTarget[${XTSlot2}].ID}
                    /if (${Group.MainAssist.ID} && ${Group.MainAssist.ID}==${Spawn[=${MainAssist}].ID}) {
                        /if (${Bool[${Me.GroupAssistTarget.ID}]}==TRUE) {
                            /call TargetThis ${Me.GroupAssistTarget.ID}
                            /call IsFriendly ${Target.ID} FROMHERE
						    /if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
							    /if (${XTarAutoSet} && !${Me.XTarget[${XTSlot}].ID}) /xtarget set ${XTSlot} currenttarget
						    } else {
                                /call TargetThis
                            }
                        } else /if (${Target.ID}) {
							/call TargetThis
                        }
                        DEBUGCOMBAT Assist Target from Group.MainAssist.ID
                    } else {
                        /assist ${MainAssist}
                        /delay 2s ${Me.AssistComplete}==TRUE
						/call IsFriendly ${Target.ID} FROMHERE
						/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
							/if (${XTarAutoSet} && !${Me.XTarget[${XTSlot}].ID}) /xtarget set ${XTSlot} currenttarget
						} else {
                            /call TargetThis
                        }
                        DEBUGCOMBAT Assist Target from using /assist
					}
					
				} else /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<=${MeleeDistance} && ${Target.ID}!=${AggroTargetID}) {
					/call TargetThis ${AggroTargetID}
                    DEBUGCOMBAT Assist Target from AggroTargetID
				} else {
					| We need to clear our target
					/call TargetThis
                    DEBUGCOMBAT Assist Clearing target
				}
			} else {
				| The MA is a goner and I'm not an offtank. If we have a target to kill, make it dead.
				/if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<=${MeleeDistance} && ${Target.ID}!=${AggroTargetID}) {
					/call TargetThis ${AggroTargetID}
                    DEBUGCOMBAT Assist MA Dead getting target on my own.
				} else {
					| We don't have an aggrotarget but let's see what's on target.
					/call IsFriendly ${Target.ID} FROMHERE
					/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
						/if (${XTarAutoSet} && !${Me.XTarget[${XTSlot}].ID}) /xtarget set ${XTSlot} currenttarget
					} else {
						/call TargetThis
					}
                    DEBUGCOMBAT No aggrotarget or its out of range. Seeing what I've got targetted.
				}
			}
        }

        DEBUGCOMBAT Target not returned on assist. Checking aggrotargetid
        /if (!${Target.ID} && ${AggroTargetID}) {
            /call TargetThis ${AggroTargetID}
        }

        DEBUGCOMBAT validatetarget ID:${Target.ID}
        /if (!${Target.ID}) {
            DEBUGCOMBAT Validate Target - No target return
			POPCALL
            /return
        }
		
        /varset TempTargetID ${Target.ID}
        /call ValidateTarget ${TempTargetID} FROMHERE
        | If target is not valid return
        DEBUGCOMBAT Target:${Target.CleanName} ValidTarget:${ValidTarget} Macro Return:${Macro.Return}
        /if (${ValidTarget}==0) {
			/call TargetThis
        } else {
			/if (${Target.ID}!=${TempTargetID}) {
				/call TargetThis ${TempTargetID}
			}
			/if (${XTarAutoSet} && !${Group.Member[${MainAssist}].Index} && !${IAmMA} && !${Me.XTarget[${XTSlot}].ID}) {
				/call IsFriendly ${Target.ID} FROMHERE
				/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
					/xtarget set ${XTSlot} currenttarget
				}
			}
            /varset MyTargetID ${Target.ID}
            /varset MyTargetName ${Target.CleanName}
            /varset LastTargetID ${MyTargetID}
		}
		POPCALL
        DEBUGCOMBAT MyTargetName:${MyTargetName} ID:${MyTargetID} !${IAmMA}
        DEBUGCOMBAT Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: BeforeAttack
| -------------------------------------------------------------------------------------
    Sub BeforeAttack(TarID, int CondCheck, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT BeforeAttack: Enter from ${FromWhere}
        /declare i int local
        /declare UseThis string local
        /declare UseThisArg3 string local
        /declare UseThisArg4 string local
		|/call EstTimeToLive
        /for i 1 to ${BeforeArray.Size}
            /varset UseThis ${BeforeArray[${i}].Arg[1,|]}
            /if (!${Bool[${UseThis}]} || !${Target.ID}) {
				POPCALL
				/return
			}
            /if (!${BeforeArray[${i}].Find[|cond]} && ${CondCheck}==2) /continue
            /if (!${ConOn} || !${BeforeArray[${i}].Find[|cond]} || ${If[${Cond[${BeforeArray[${i}].Mid[${Math.Calc[${BeforeArray[${i}].Find[|cond]}+5]},3]}]},1,0]}) {
                /if (${FindItem[=${UseThis}].ID} && ${Me.ItemReady[${UseThis}]}) {
                    /useitem "${UseThis}"
                    /echo ## Before Attack >> ${UseThis} <<
                } else /if (${Me.AltAbility[${UseThis}]} && ${Me.AltAbilityReady[${UseThis}]} && ${Me.AltAbility[${UseThis}].Type}!=5 && ${UseThis.NotEqual[twincast]})  {
                    /alt act ${Me.AltAbility[${UseThis}].ID}
                    /echo ## Before Attack >> ${UseThis} <<
                } else /if (${Me.CombatAbility[${UseThis}]} && !${Me.CombatAbilityTimer[${UseThis}]} && ${Me.CombatAbilityReady[${UseThis}]} && ${Spell[${UseThis}].EnduranceCost}<${Me.Endurance}) {
                    /disc ${Me.CombatAbility[${Me.CombatAbility[${UseThis}]}].ID}
                    /echo ## Before Attack >> ${UseThis} <<
                } else /if (${Me.Skill[${UseThis}]} && ${Me.AbilityReady[${UseThis}]}) {
                    /doability "${UseThis}"
                    /echo ## Before Attack >> ${UseThis} <<
                } else /if (${UseThis.Find[command:]}) {
                    /call CastCommand "${UseThis}" ${MyTargetID} 0 FROMHERE
                }
                /delay 3
            }
        /next i
		POPCALL
        DEBUGCOMBAT BeforeAttack: Leave
    /return 0

|-----------------------------------------------------------------------------
| SUB: Back Off and stop melee
| ----------------------------------------------------------------------------
    Sub Bind_BackOff(string OnOffFlag, int waitFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare t_Wait      timer local 0
        /declare i_Target    int   local ${Int[${Target.ID}]}
        /declare i_Flag1     int   local 0
        |/declare i_Flag2     int   local 0
        /if (${Select[${OnOffFlag},on,off,1,0]}>0) {
            /if (${Select[${OnOffFlag},on,1]}>0) {
                /varset DPSPaused 0
            } else {
                /varset DPSPaused 2
            }
        }
        /if (${DPSPaused}) {
            |/varset i_Flag2 ${DPSPaused}
            /echo Resetting. No Longer Backing off. ${waitFlag} ${IAmMA}
            /if (${waitFlag} && ${IAmMA}) {
                /if (${Me.Casting.ID}) {
                    /stopcast
                    /varset CastResult CAST_CANCELLED
                }
                /echo Pausing for new target. Switch to new target now.
                /varset t_Wait 30
                |/beep
                /while (${t_Wait} && !${i_Flag1}) {
                    /if (${Target.ID} && ${Target.ID}!=${i_Target}) /varset i_Flag1 1
                    /delay 5
                }
                /if (${i_Flag1}) {
                    /varset i_Flag1 ${TargetSwitchingOn}
                    /varset TargetSwitchingOn 1
                    /call CombatTargetCheck 2 FROMHERE
                    /varset TargetSwitchingOn ${i_Flag1}
                    /echo Target Switched from Backoff command.
                } else {
                    /echo Target NOT Switched. You can always try again.
                }
            }
            /if (${DPSPaused}==2 && ${UseMQ2Melee}) /squelch /melee on
            /varset DPSPaused 0
        } else {
            /varset DPSPaused 1
            /varset CombatStart 0
            /if (${UseMQ2Melee}) /squelch /melee off
            /squelch /attack off
            /if (${Stick.Active}) /stick off
            /call CombatReset 0 FROMHERE
            /varset DPSPaused 2
            /echo Backing off - All Combat has been reset.
        }
        /if (${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc}]} > 15 && !${waitFlag}) {
            /call DoWeMove 0 FROMHERE
        }
        |/doevents flush BackOff
		POPCALL
    /return
	
| ----------------------------------------------------------------------------
| SUB: Burn Section for new bind
| ----------------------------------------------------------------------------
    Sub Bind_Burn(string s_BurnWhat, string s_State)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare BurnWhat int local ${Int[${s_BurnWhat}]}
        /if (${s_BurnWhat.Equal[on]} || ${s_State.Equal[on]}) {
            /varset BurnOn 1
            /varset CampZone ${Zone.ID}
            /echo Turning Burn On. ${s_BurnWhat} - ${s_State} 
        } else /if (${s_BurnWhat.Equal[off]} || ${s_State.Equal[off]}) {
            /varset BurnOn 0
            /varset BurnActive 0
            /varset BurnCalled 0
            /varset BurnID 0
            /echo Turning Burn Off.
        }
        /if (!${BurnOn}) {
			POPCALL
			/return
		}
        /if (${s_BurnWhat.Equal[on]} && ${s_State.NotEqual[doburn]}) {
			POPCALL
			/return
		}
        /varset BurnCalled 1
        /if (${BurnWhat}) {
            /varset BurnID ${BurnWhat}
        } else /if (${MyTargetID}) {
            /varset BurnID ${MyTargetID}
        } else /if (${Target.ID} && !${Select[${Target.Type},pc,pet,mercenary,corpse]}) {
            /varset BurnID ${Target.ID}
        }
        /call Burn ${BurnID} FROMHERE
		POPCALL
    /return
	
| ----------------------------------------------------------------------------
| SUB: Bind Switch
| ----------------------------------------------------------------------------
    Sub Bind_Switch
        /if (${IAmMA}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /declare WasAttacking int local ${Attacking}
        /echo New target called!
        /call CombatReset 1 FROMHERE
        /call Assist FROMHERE
        /if (${WasAttacking}) {
            /squelch /attack on
            /varset Attacking 1
        }
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: Burn Section
| ----------------------------------------------------------------------------
    Sub Burn(int EBurnWhat, string FromWhere)
        /if (${IAmDead} || ${Me.Hovering} || ${CampZone}!=${Zone.ID} || !${BurnOn}) {
            /if (!${BurnOn}) /echo Leaving Burn. Burn is turned Off.
            /return
        }
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGCOMBAT Enter from ${FromWhere}

        /declare i            int local
        /declare BurnSpell    string local
        /declare BurnTarget   string local
        /declare BurnTargetID int local
        /declare BurnArg3     string local
        /declare CondNo       int    local 0
        /declare AbortFlag    int    local 0
        /if (!${BurnActive}) /call BroadCast r "BURN ACTIVATED => Autobots Transform <="
        /if (${UseTribute} && !${Me.TributeActive}) {
           /squelch /tribute personal on
           /squelch /trophy personal on
           /varset TributeTimer 570s
        }
		|/call EstTimeToLive 0		
        /for i 1 to ${Burn.Size}
            /varset BurnSpell ${Burn[${i}].Arg[1,|]}
            /varset BurnTarget ${Burn[${i}].Arg[2,|]}
            /varset BurnArg3 ${Burn[${i}].Arg[3,|]}
            /varset AbortFlag 0
            /if (${ConOn} && ${Burn[${i}].Find[|cond]}) {
                /varset CondNo ${Burn[${i}].Mid[${Math.Calc[${Burn[${i}].Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }
            /if (${BurnSpell.Equal[null]} || ${Me.Hovering}) /continue
            /if (${BurnTarget.Equal[Mob]}) {
                /varset BurnTargetID ${MyTargetID}
            } else /if (${BurnTarget.Equal[Me]}) {
                /varset BurnTargetID ${Me.ID}
            } else /if (${BurnTarget.Equal[MA]}) {
                /varset BurnTargetID ${Spawn[=${MainAssist}].ID}
            } else /if (${BurnTarget.Equal[Pet]}) {
                /varset BurnTargetID ${Pet.ID}
            } else /if (${BurnTarget.Equal[abort]}) {
                /varset BurnTargetID ${MyTargetID}
                /varset BurnArg3 abort
            } else /if (${MyTargetID}) {
                /varset BurnTargetID ${MyTargetID}
            }
            /if (${BurnArg3.Equal[abort]}) {
                /varset AbortFlag 1
            }
            /call CastWhat "${BurnSpell}" ${BurnTargetID} Burn ${CondNo} ${AbortFlag} FROMHERE
            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                /echo Casting >> BURN${i}:${BurnSpell}
                /while (${Me.Casting.ID} && ${Window[CastingWindow].Open} && !${IAmABard}) {
                    /delay 5
                }
            }
			|/call EstTimeToLive 0
        /next i
        /varset BurnActive 1
		POPCALL
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Check for Adds
| -------------------------------------------------------------------------------------
    Sub CheckForAdds(string FromWhere)
        | If no mobs, in a DMZone or pulling Leave

        /if (${DMZ} && ${Me.InInstance}==FALSE) /return
        /if (${Pulling}) /return
        /if (!${DPSOn} && !${MeleeOn}) /return
        /if ((${Select[${Role},puller,pullertank,pullerpettank]} || ${PullManual}) && ${Math.Distance[${CampYLoc},${CampXLoc}]}>=${CampRadius}) /return
        /if (${IAmDead}) /return
        /if (${ChainPull}==2 || ${DPSPaused}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN  CheckForAdds: Enter from ${FromWhere}
        /call MobRadar los ${MeleeDistance} FROMHERE
        DEBUGN MobCount:${MobCount}
        /if (${MobCount}<=1) {
			POPCALL
			/return
		}

		| Don't attack erroneous targets. Allow for reset and re-evaluate.
		/call OnXTarget ${Target.ID}
		/if (${Macro.Return.Equal[0]}) {
			POPCALL
			/return
		}

		| If I have a valid living target in camp radius Leave
        /if (!${Target.ID} && ${MyTargetID} && ${Spawn[id ${MyTargetID}].ID} && ${Spawn[id ${MyTargetID}].Distance}<${CampRadius}) {
			/call IsFriendly ${MyTargetID} FROMHERE
			/if (${Macro.Return.NotEqual[MAY-BE-HOSTILE]}) {
				POPCALL
				/return
			}
			/call TargetThis ${MyTargetID}
			POPCALL
            /return
        }
        | Spam Adds in camp
        /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<=${CampRadius} && !${MyTargetID} && !${AddSpam}) {
            /popup Add(s) in camp detected
            /if (${IAmMA} || ${Select[${Role},tank,pullertank,pettank,pullerpettank]}) /call BroadCast r "Add(s) in camp detected"
            /if (${Select[${Role},pullertank,pullerpettank]}) /varset Pulled 0
            /varset AddSpam 5s
        }
        | Prevent puller from stalling if adds in camp and still returning from pulling mob.
        /if (${Select[${Role},puller,pullertank,pullerpettank]} && ${Pulled} && ${Math.Distance[${CampYLoc},${CampXLoc}]}>=15) {
			POPCALL
			/return
		}
        /if (!${Target.ID} && ${Select[${Role},tank,pullertank,pettank,pullerpettank,hunter,hunterpettank]}) {
			/call TargetThis ${Spawn[id ${AggroTargetID}].ID}
		}
        /if (${Target.Type.NotEqual[npc]} && ${MyTargetID}) {
            /if (!${Spawn[id ${MyTargetID}].ID} || ${Spawn[id ${MyTargetID}].Type.Equal[corpse]}) {
                /varset LastTargetID ${MyTargetID}
                /varset MyTargetID 0
            }
			/call TargetThis
            POPCALL
            /return
        }
		POPCALL
        DEBUGN CheckForAdds: Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: CheckForCombat Used to help with controlling combat
| -------------------------------------------------------------------------------------
    Sub CheckForCombat(int SkipCombat, string FromWhere, int WaitTime)		
        /if (${ChaseAssist} && ${Me.Moving} && (!${IAmMA} || ${WhoToChase.NotEqual[${Me}]})) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT CheckForCombat Enter from ${FromWhere} - SkipCombat: ${SkipCombat} ChainPull: ${ChainPull} Role: ${Role}
        /while (1) {
            /doevents
			/call CheckBeforeCast CheckForCombat FROMHERE
			/if (${Pet.ID} && ${PetOn}) {
                | If I'm not the pet tank (such as assist or offtank etc), taunt may have been enabled
                | during the last fight. Turn it off.
				/if (!${Select[${Role},pettank,pullerpettank,hunterpettank]} && !(${AggroTargetID} || ${CalledTargetID})) {
					/call PetTauntSwitch 0 FROMHERE
				}
                | If pet is out of LOS and I'm not a puller, bring it back
				/if (!${Select[${Role},PULLER_ROLES]} && ${Target.ID} && !${Spawn[id ${Pet.ID}].LineOfSight}) /call PetBackOff FROMHERE
				| If the target is not in LOS of the MA and my pet is out of LOS, pull pet back. Pet may be causing problem.
                /if (${Target.ID} && !${Target.LineOfSight[${MainAssist}]} && !${Spawn[id ${Pet.ID}].LineOfSight}) /call PetBackOff FROMHERE
           		/if ((${CombatStart} || ${CalledTargetID}) && ${Math.Distance[${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}:${Target.Y},${Target.X}]}>${PetAttackRange}) /call PetBackOff FROMHERE
			}
            /if (${SkipCombat}==0) {
                /if (${IAmDead} && ${CampZone}==${Zone.ID} && (${Me.Buff[Resurrection Sickness].ID} || ${SpawnCount[pccorpse ${Me}]}==0)) /varset IAmDead 0
                /call MobRadar los ${MeleeDistance} FROMHERE
                /if (${ChaseAssist}) /call DoWeChase FROMHERE
                /if (${DebugCombat}) /delay 5
                | If you just recovered from death, and there are mobs nearby (MobCount) but you arent in combat, its a circular loop.
                |/if ((${DMZ} && ${Me.InInstance}==FALSE) || ${Me.Hovering} || (${IAmDead} && !${AggroTargetID}) || (!${MobCount} && !${AggroTargetID}) || (!${DPSOn} && !${MeleeOn})) {
                /if ((${DMZ} && ${Me.InInstance}==FALSE) || ${Me.Hovering} || ${IAmDead} || !${AggroTargetID} || (!${DPSOn} && !${MeleeOn})) {
					POPCALL
					/return
				}
                DEBUGCOMBAT CheckForCombat: Assist/Combat Begin ${FromWhere}
                /if (${IAmABard} && ${MeleeTwistOn}==2 && !${DPSTwisting}) /call DoBardStuff FROMHERE
                /varset EngageWaitTimer ${WaitTime}
                /if (!${IAmMA}) {
                    |/varset EngageWaitTimer 200
                    | Changed from 1 to AggroTargetID. Unncessary assists.
                    /while (${AggroTargetID}) {
                        /call Assist FROMHERE
						/if (${Macro.Return.Equal[switch]}) {
							| I am Off Tank and MainAssist is dead. Switch figures out if I'm a pet wrangler.
							/call Bind_SwitchMA ${Me} tank ${SwitchMAAnnounce}
							/break
                        } else /if (${Macro.Return.Equal[INVALID_TARGET]}) {
                            | If we are stuck in a situation where the MA is targetting a corpse, or a friendly while an aggrotargetid exists
                            | we will get in a circular loop. This attempts to fix it. E.g. A merc.
                            /call TargetThis ${AggroTargetID}
                            /attack on
                            /delay 5s
                            /attack off
                            POPCALL
                            /return
                        }
                        /if (${MyTargetID} || ${Role.NotEqual[assist]} || !${EngageWaitTimer} || !${AggroTargetID}) /break
                    }
                } else {
                    |I am MainAssist
                    |Need to call WaitForMob from here and remove it from the Pull routine.
                    /if (!${Select[${Role},pullertank,pullerpettank,hunter,hunterpettank]}) {
                        /if (${AggroTargetID}) {
                            |/varset EngageWaitTimer 200
                            /while (1) {
                                /if (!${AggroTargetID} || ${Spawn[id ${AggroTargetID}].Type.Equal[Corpse]}) /break
                                /if (${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]}>${MeleeDistance}) {
                                    /varset MobCount ${SpawnCount[xtarhater radius ${MeleeDistance} zradius ${MaxZRange}]}
                                } else {
                                    /varset MobCount ${SpawnCount[xtarhater loc ${CampXLoc} ${CampYLoc} radius ${MeleeDistance} zradius ${MaxZRange}]}
                                }
                                /if (!${MobCount} && ${EngageWaitTimer}) /continue
                                /break
                            }
                        }
                    }
                    /call GetCombatTarget FROMHERE
                }
                /call Combat FROMHERE
                | Check if you FD'd to loose aggro and never stood back up.
                /if (${Me.Feigning} || ${Me.Invis}) /call FeignAggroCheck
                DEBUGCOMBAT  CheckForCombat: Assist/Combat End ${FromWhere}
                /if (${ChainPull}==2) {
					POPCALL
					/return
				}
            }
            | Check to see if you are a healer and DPS is off, or DPS is on but the mob is not in LOS
            | This triggers if you are a pet wrangler that heals its own pet. Thats a problem. This stops anyone that heals from doing anything else

			/while (${SkipCombat}==1 || (${DPSOn} && ${HealsOn} && ${MyTargetID} && ${Spawn[id ${MyTargetID}].LineOfSight}==FALSE)) {
                DEBUGCOMBAT CheckForCombat SkipCombat ${SkipCombat} Spawn LOS ${Spawn[id ${MyTargetID}].LineOfSight} Spawn ID ${Spawn[id ${MyTargetID}].ID} MyTargetID ${MyTargetID}
                /if (${IAmABard} && ${MeleeTwistOn}==2 && !${DPSTwisting}) /call DoBardStuff FROMHERE
                /doevents
                /if (${AggroTargetID} || ${CalledTargetID}) {
					|/call GetCloser both
                    /call CombatTargetCheck ${If[${SkipCombat},0,1]} FROMHERE
                    | CalledTargetID wasn't being reset, so it is checked here until root issue is found.
                    /if (${CalledTargetID} && (!${Spawn[id ${CalledTargetID}].ID} || ${Spawn[id ${CalledTargetID}].Type.Equal[Corpse]})) {
                        /varset CalledTargetID 0
                        /continue
                    }
                    /if (!${AggroTargetID}) /continue
                    /if (${AggroOn}) {
                        /call AggroCheck FROMHERE
                        | Check if you FD'd to loose aggro and never stood back up.
                        /if (${Me.Feigning} || ${Me.Invis}) /call FeignAggroCheck
                    }
                    /if (!${CombatStart} && ${BeforeArray[1].NotEqual[null]}) {
                        /call BeforeAttack ${MyTargetID} 1 FROMHERE
                        /varset CombatStart 1
                    }
                    /call Triage FROMHERE
                    /if (!${NamedCheck} && (${BurnAllNamed} || ${GMailEvents.Find[named]})) /call NamedWatch ${SkipCombat} FROMHERE
                    /call WriteDebuffs
                    /if (${MyTargetID} && (${Spawn[id ${MyTargetID}].Type.Equal[Corpse]} || !${Spawn[id ${MyTargetID}].ID})) /call CombatReset 0 FROMHERE-0
                    /if (${WhoToChase.NotEqual[${Me}]} && ${ChaseAssist}) /call DoWeChase FROMHERE
                    | We get into an endless loop when we should be engaged in battle if we get this far.
                    /break
                } else {
                    /if (${Role.NotEqual[manual]} && ${CombatStart}) /call CombatReset 0 FROMHERE-1
					POPCALL
                    /return
                }
            }

            /call CheckForAdds FROMHERE
            /if (${Select[${Role},tank,pullertank]}) {
                | If tank is assisting puller and in chase mode
                /if (${WhoToChase.NotEqual[${Me}]} && ${ChaseAssist}) /call DoWeChase FROMHERE
                /if (${ReturnToCamp} && ((!${MobCount} && ${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]}>15) || (${MobCount}==1 && ${AggroTargetID} && ${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]}>75))) /call DoWeMove 1 checkforcombat
                /if (${MobCount} && ${AggroTargetID}) /continue
                /if (${BuffsOn}) {
                    /for GlobalIndex 1 to ${BuffsSize}
                        /if (${Buffs[${GlobalIndex}].Arg[2,|].NotEqual[end]}) /continue
                        /if (${Me.PctEndurance}<=${Buffs[${GlobalIndex}].Arg[3,|]} && (${Me.CombatAbilityReady[${Buffs[${GlobalIndex}].Arg[1,|]}]} || ${Me.AltAbilityReady[${Buffs[${GlobalIndex}].Arg[1,|]}]})) /call CheckEndurance "${Buffs[${GlobalIndex}].Arg[1,|]}" ${Buffs[${GlobalIndex}].Arg[3,|]} ${Buffs[${GlobalIndex}].Arg[4,|]}
                    /next GlobalIndex
                }
                DEBUGCOMBAT CheckForCombat MobCount: ${MobCount} AggroTargetID: ${AggroTargetID} ChainPull: ${ChainPull} ${SkipCombat}
                /if (${TankTimer}) /continue
            } else /if (${Role.NotEqual[manual]} ) {
                /if (${MyTargetID} && (${Spawn[id ${MyTargetID}].Type.Equal[Corpse]} || !${Spawn[id ${MyTargetID}].ID})) /call CombatReset 0 FROMHERE-2
            }
            /call MobRadar los ${MeleeDistance} FROMHERE
            DEBUGCOMBAT CheckForCombat MobCount: ${MobCount} AggroTargetID: ${AggroTargetID} ChainPull: ${ChainPull} ${SkipCombat} ${MezMobFlag}
            /if ((!${AggroTargetID} && (!${MezMobFlag} || !${MobCount}) && !${ChainPull}) || (${MobCount}<2 && ${ChainPull})) /break
            | if I am in melee distance of camp and there are no mobs in melee distance then we need to return to camp.
            | even if there are mobs in XTarget that doesn't mean we should NOT return to camp.
            /if (${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]}>${CampRadius} && !${SpawnCount[xtarhater loc ${CampXLoc} ${CampYLoc} radius ${MeleeDistance}]}) /call DoWeMove 1 FROMHERE
        }
        /if (${MobCount}==1 && ${ChainPull}==2) {
			POPCALL
			/return
		}
        /if (${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]} > 15) {
            /if (!${IAmMA}) /delay ${Math.Calc[${Math.Rand[1]}+1]}s
            /if (${MobCount}<=0) /call DoWeMove 0 FROMHERE
        } else /if (${Select[${Role},hunter,hunterpettank]} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}>${Math.Calc[${MaxRadius}*.95]}) {
            DEBUGPULL PullHunter Returning hunter to camp
            /echo ${Role}: Reached edge of ${MaxRadius} hunting radius. Trying to return to camp.
            |/varset ReturnToCamp 1
            /call DoWeMove 1 pullhunter
        }
		POPCALL
        DEBUGCOMBAT CheckForCombat leave.
    /return

| -------------------------------------------------------------------------------------
| SUB: Combat
| -------------------------------------------------------------------------------------
    Sub Combat(string FromWhere)
        /if ((${Select[${Role},puller,pullertank,pullerpettank]} || ${PullManual}) && ${Math.Distance[${CampYLoc},${CampXLoc}]}>=${CampRadius} && ${Pulling}) /return
        /if (!${MyTargetID} || !${Target.ID}) /return
        /if (${DMZ} && ${Me.InInstance}==FALSE) /return
        /if (${DPSPaused}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGCOMBAT Enter from ${FromWhere}
        /doevents
        DEBUGCOMBAT Role: ${Role} Camp Distance: ${Math.Distance[${CampYLoc},${CampXLoc}]} ${CampRadius} Pulling: ${Pulling} Target: ${MyTargetID} ${Target.ID} LOS: ${Target.LineOfSight} DPSPaused: ${DPSPaused}

		DEBUGCOMBAT Basic checks done. Am I invis?
		|
		| Is the MA invis? If so don't engage. They may just be looking at a target.
		|
		/call CheckInvis ${MainAssist}
		/if (${Macro.Return.Equal[INVIS_TRUE]}) {
			POPCALL
			/return
		}

		|/call EstTimeToLive
		
		DEBUGCOMBAT Is mob mezzed?
        | Check if mob mezzed
        /if (${Target.Mezzed.ID}) {
            /if (${Spawn[=${MainAssist}].ID} && !${IAmMA} && ${Spawn[id ${MyTargetID}].PctHPs}<=${AssistAt}) {
                /echo Mob is mezzed ->> ${Target.CleanName} <<- I am not going to wake it since I am on assist.
                /delay 10
				POPCALL
                /return
            }
        }
		
		DEBUGCOMBAT Rallying on me, if I'm tank?
        /if (${Select[${Role},tank,pullertank]}==0 && (${Me.Song[Rallying Call].ID} || ${Me.Song[Rallying Solo].ID})) {
			POPCALL
			/return
		}
        
        /declare CombatRadius int   local ${If[${Spawn[id ${MyTargetID}].MaxRangeTo}>${MeleeDistance},${Math.Calc[${Spawn[id ${MyTargetID}].MaxRangeTo}+5]},${MeleeDistance}]}
        /declare SpamTankWait int   local 1
        /declare navTimer     timer local 0
        /varcalc ZDist ${Math.Distance[${Target.Z}:${Me.Z}]}-(${Target.Height}-${Me.Height})
		DEBUGCOMBAT Triage! Stat!
		/call CheckBeforeCast Combat FROMHERE
        /if (${ChaseAssist}) /call DoWeChase FROMHERE	
        | Check Target Hps and type NPC or NPC Pet
        DEBUGCOMBAT ${Spawn[id ${MyTargetID}].Name} PctHPs = ${Spawn[id ${MyTargetID}].PctHPs} AssistAt=${AssistAt} Distance = ${Spawn[id ${MyTargetID}].Distance} CombatRadius = ${CombatRadius}
        /if (${Spawn[id ${MyTargetID}].Type.NotEqual[Corpse]} && ${Spawn[id ${MyTargetID}].PctHPs}<=${AssistAt} && (${Spawn[id ${MyTargetID}].Distance}<${CombatRadius} || (${Math.Distance[${CampYLoc},${CampXLoc}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CombatRadius} && ${Math.Distance[${Target.Y},${Target.X}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CampRadius}))) {
            /if (!${CombatStart}) {
                DEBUGCOMBAT Setting CombatStart to 1
                /varset CombatStart 1		
                /if (${Cursor.ID}) /call CheckCursor Combat 0
                /varset MercAssisting 0
	            /echo ATTACKING -> ${Spawn[id ${MyTargetID}].CleanName} <-
				|/call EstTimeToLive 0
				| PullerPetTank and PetTank send in pet if mob in range
				/if (${Select[${Role},pettank,pullerpettank,hunterpettank]} && ${Spawn[id ${MyTargetID}].Distance}<=${PetAttackRange}) /call CombatPet FROMHERE
                /if (${IAmABard}) /call DoBardStuff FROMHERE
				/if (${AggroOn} && !${IAmMA} && ${Select[${Role},Tank]} && ${Spawn[id ${MyTargetID}].Distance}>${CombatRadius}) /call AggroCheck FROMHERE
                /if (${IAmMA} && ${Select[${Role},Tank,PullerTank,Hunter]}) /call BroadCast y "${Me.CleanName}: TANKING-> ${Spawn[id ${MyTargetID}].CleanName} <- ID:${MyTargetID}"
                /if (${IAmMA} && ${Select[${Role},pettank,pullerpettank,hunterpettank]}) /call BroadCast y "${Me.CleanName}: ${Pet.CleanName} is TANKING-> ${Spawn[id ${MyTargetID}].CleanName} <- ID:${MyTargetID}"
                | Moloing as as puller turn off puller tag in group so tank merc attacks and doesn't wait for me to get 2 feet near them.
                /if (${Group}==1 && ${Select[${Role},puller]} && ${Group.Puller.Name.Equal[${Me}]} && ${Spawn[=${MainAssist}].Type.Equal[Mercenary]} && ${Math.Distance[${CampYLoc},${CampXLoc}]}<${CampRadius}) /call AssignGroupRole unset "${Me.CleanName}" 3
            }
			/if (${Select[${Role},pettank,pullerpettank,hunterpettank]} && ${Spawn[id ${MyTargetID}].Distance}<=${PetAttackRange}) /call CombatPet FROMHERE
            /if (${FaceMobOn} && ${Target.ID} && (${Me.Standing} || ${Me.Mount.ID})) /face ${If[${FaceMobOn}==1,fast nolook,nolook]}
            /if (!${Me.FeetWet}) /look 0
            /if (!${Attacking}) {
                |/if (${Select[${Role},pettank,pullerpettank]} && !${Attacking}) {
                |/if (${MeleeOn} && !${Attacking}) {
                /if (${MeleeOn}) {
					|/call EstTimeToLive 0
                    /varset Attacking 1
                    /if (${Me.Sitting}) /stand
                    /if (${AutoFireOn}!=1) {
                        DEBUGCOMBAT Attack On
                        | Speed up tanks attacking inc mobs MQ2Melee /killthis can cause a delay
                        /if (${Select[${Role},tank,pullertank,hunter]}) {
                            /if (${Me.Skill[Taunt]} && ${Me.AbilityReady[Taunt]}) /doability Taunt
                        }
                        /if (!${Me.Combat} && ${BeforeArray[1].NotEqual[null]}) /call BeforeAttack ${MyTargetID} 1 FROMHERE
                        /if (${Select[${Role},pettank]}) /call PetEngageTarget ${MyTargetID} 0 FROMHERE
						/if (${Select[${Role},pullerpettank]}) /call PetEngageTarget ${MyTargetID} 1 FROMHERE
						| Move to mob Attack on and Stick handled in CheckStick
						/call CheckStick 0 1 FROMHERE
						| Move closer if Z distance more than 4 due to levitation
						/call ZAxisCheck ${ZDist} 4.1
                    } else {
                        /if (!${Me.Combat} && ${BeforeArray[1].NotEqual[null]}) /call BeforeAttack ${MyTargetID} 1 FROMHERE
                    }
                } else {
                    /if (${Stick.Active}) /stick off
                    /if (${Select[${Role},pettank]}) /call PetEngageTarget ${MyTargetID} 0 FROMHERE
					/if (${Select[${Role},pullerpettank]}) /call PetEngageTarget ${MyTargetID} 1 FROMHERE
                }
            }
            /varset  MyExp ${Me.PctExp}
            /varset  MyAAExp ${Me.PctAAExp}
            | Turn on check for mez mob in camp that has been mem blurred if i am a tank type
			|
			| Swapping in role define
            |/if (${Select[${Role},tank,pullertank,pettank,pullerpettank]}) /varset MezMobFlag 1
            |/if (${Stick.Active} && !${MeleeOn}) /stick off
			/if (${Select[${Role},TANK_ROLES]}) /varset MezMobFlag 1
			DEBUGCOMBAT Starting combat while loop
            /while (1) {
				|/call EstTimeToLive 0
                /doevents
				/if (!${AggroTargetID}) /break
				/call CheckBeforeCast Combat FROMHERE
                /if (${Role.Equal[offtank]} && !${Spawn[=${MainAssist}].ID}) /call Bind_SwitchMA ${Me} tank ${SwitchMAAnnounce}
				|
				| Adding petofftank
				|
				/if (${Role.Equal[petofftank]} && !${Spawn[=${MainAssist}].ID}) /call Bind_SwitchMA ${Me} pettank ${SwitchMAAnnounce}
                /if (${MercOn} && !${MercAssisting} && ${MyTargetID} && ${Mercenary.State.Equal[Active]}) /call MercsDoWhat
                /if (${AutoFireOn}!=1) {
                    /if (${MeleeOn}) {
                        /if (${Spawn[id ${MyTargetID}].Distance3D}>${Spawn[id ${MyTargetID}].MaxRangeTo} && !${Stick.Active}) /call CheckStick 0 ${If[${UseMQ2Melee},0,1]} FROMHERE
                    }
                } else {
                    | This is where we would add our call to the routine to position us for Autofire.
                    /varset AutoFireOn ${AutoFireOn}
                }
                /if (${AEOn}) /call AECheck ${AEDisplayMobInfo} FROMHERE
                /if (${AggroOn}) /call AggroCheck FROMHERE
				| Pet decisions...
				/if (${PetOn} && ${PetCombatOn} && (${Spawn[id ${MyTargetID}].PctHPs}<=${PetAssistAt} || ${Pet.Combat})) {
					/call IsPetTooFar FROMHERE
					/if (${Macro.Return.Equal[1]}) {
						/call PetBackOff FROMHERE
					} else {
						/call CombatPet FROMHERE
					}
				}
				DEBUGCOMBAT 1: MyTargetID ${MyTargetID} AggroTargetID ${AggroTargetID}		
                /if (!${NamedCheck} && (${BurnAllNamed} || ${GMailEvents.Find[named]})) /call NamedWatch 0 FROMHERE
				DEBUGCOMBAT Attack 1.20 Role ${Role} ChainPull ${ChainPull}
				| I think what this intends is: I'm not a puller, or I am a puller but I'm not chainpulling.
                /if (!${Select[${Role},PULLER_ROLES]} || (${Select[${Role},PULLER_ROLES]} && !${ChainPull})) {
                    /if (${DebuffAllOn}) {
                        | Debuff stuff
                        /call DoDebuffStuff ${MyTargetID} FROMHERE
                        |When returning the mob you were started on could be dead, so don't keep trying to kill a corpse.
                        /if (${Spawn[id ${MyTargetID}].Type.Equal[Corpse]} || !${Spawn[id ${MyTargetID}].ID} || ${DPSPaused}) {
                           /call CombatReset 0 FROMHERE
                           /break
                        }
                    }
                    /if (${DPSOn}) {
						DEBUGCOMBAT 1: MyTargetID ${MyTargetID} AggroTargetID ${AggroTargetID}
                        /call CombatCast FROMHERE
                    } else {
                        /if (${MashArray.Size}>0 && ${MashArray[1].NotEqual[null]}) /call MashButtons FROMHERE
                    }
                }
                |moved heal checking from CastMana to before calling it.
                /call WriteDebuffs
                /if (${IAmABard}) /call DoBardStuff FROMHERE
                /if (${DPSOn} || ${MeleeOn} || ${PetOn}) /call CombatTargetCheck 1 FROMHERE
				|/if (${Target.Distance}>${MeleeDistance}) /call GetCloser OOR
				|/if (!${Target.LineOfSight}) /call GetCloser LOS
                /if (${Spawn[id ${MyTargetID}].Type.NotEqual[Corpse]} && ${Spawn[id ${MyTargetID}].ID} && !${DPSPaused}) {
                    /if (${AutoFireOn}!=1) {
                        /if (${Attacking} && ${MeleeOn}) {
                            /if (${Target.PctHPs}<=${AssistAt} && ${Target.Distance}<${CombatRadius}) {
                                /if (!${TargetSwitchingOn} && ${Target.ID}!=${MyTargetID}) /call TargetThis ${MyTargetID}
                                /if (!${Me.Combat}) {
                                    /if (${Me.Sitting}) /stand
                                    /call CheckStick 0 1 FROMHERE
                                } else {
                                    /if (!${Stick.Active}) /call CheckStick 1 0 FROMHERE
                                    |/if (!${UseMQ2Melee} && !${Stick.Active}) /call CheckStick 1
                                }
                            } else /if (!${Me.Combat} && ${IAmMA}) {
                                /if (${DebugCombat}) {
                                    /beep
                                    /echo \atIm in the :Attack loop but attack is not on Attacking=${Attacking} MeleeOn=${MeleeOn} Target.PctHPs=${Target.PctHPs} Math.Calc[AssistAt-5]=${Math.Calc[${AssistAt}-5]} Target.Distance=${Target.Distance} CombatRadius=${CombatRadius} AutoFireOn=${AutoFireOn}
                                }
                                /if (${Target.ID} && ${Select[${Me.State},stand,mount]}) /attack on
                            }
                        }
                    } else /if (${AutoFireOn}==1) {
                        /if (${CombatStart} && !${Me.AutoFire}) {
                            /if (${Target.ID}==${MyTargetID} && !${Bool[${Target.Mezzed.ID}]}) {
                                /if (${Me.Sitting}) /stand
                                /autofire
                            }
                        }
                    }
                    | Chain Pulling Check Here
                    /if (${Select[${Role},PULLER_ROLES]} && ${ChainPull}) {
                        /call ChainPullNextMob ${SpamTankWait} FROMHERE
                        /if (${Macro.Return.Equal[1]}) {
							POPCALL
                            /return
                        } else /if (${Macro.Return.Equal[W]}) {
                            /varset SpamTankWait 0
                        }
                        /if (${DebuffAllOn}) /call DebuffCast ${MyTargetID} 1 FROMHERE
                        /if (${DPSOn}) {
                            /call CombatCast FROMHERE
                        } else {
                            /if (${MashArray.Size}>0 && ${MashArray[1].NotEqual[null]}) /call MashButtons FROMHERE
                        }
                    } else {
                        DEBUGCHAINPULL Chain Pull Failed 0: ${Role} ${ChainPull}
                    }
                } else {
                    /if (${DPSPaused} || !${TargetSwitchingOn}) {
                        /call CombatReset 0 FROMHERE
                        /break
                    } else {
                        DEBUGCOMBAT Attack 4 ${MyTargetID} ${Target.ID}
                        /if (${Target.ID} && ${Target.ID}!=${MyTargetID}) {
                            /if (${MyTargetID}) /varset LastTargetID ${MyTargetID}
                            /varset MyTargetID 0
                            /call CombatTargetCheck 1 FROMHERE
                            /if (!${MyTargetID}) {
                                /varset MyTargetID ${LastTargetID}
                                /call CombatReset 0 FROMHERE
                                /break
                            }
                            /continue
                        } else {
                            /call CombatReset 0 FROMHERE
                            /break
                        }
                    }
                }
                /if (${Me.Feigning} || ${Me.Invis}) {
					DEBUGCOMBAT I'm feigning death or invis. Skipping combat...
                    /call FeignAggroCheck
                    /delay 5
                    /if (${Me.Feigning} || ${Me.Invis}) /break
                }
                |/if (${ReturnToCamp} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]} > 15) {
				|	DEBUGCOMBAT It's time to return to camp.
                |    /call DoWeMove 0 dowemed
                |}
				/if (${Pet.ID}) {
					/if (!${Pet.LineOfSight}) {
						/call PetBackOff 1 FROMHERE
						DEBUGCOMBAT I can't see my pet, reeling it in.
					}
				}
				/call LastMove
            }
        } else /if (${Spawn[id ${MyTargetID}].Type.NotEqual[Corpse]} && ${Spawn[id ${MyTargetID}].PctHPs}<=${PetAssistAt} && (${Spawn[id ${MyTargetID}].Distance}<${CombatRadius} || (${Math.Distance[${CampYLoc},${CampXLoc}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CombatRadius} && ${Math.Distance[${Target.Y},${Target.X}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CampRadius}))) {
            /call GetCloser both FROMHERE
			/if (${DPSOn} || ${MeleeOn} || ${PetOn}) /call CombatTargetCheck 1 FROMHERE
			| More pet decisions...
			/if (${PetOn} && ${PetCombatOn} && ${Spawn[id ${MyTargetID}].PctHPs}<=${PetAssistAt} && !${PetAttack} && !${DPSPaused}) {
				/call IsPetTooFar FROMHERE
				/if (${Macro.Return.Equal[1]}) {
					/call PetBackOff FROMHERE
				} else {
					/call CombatPet FROMHERE
				}
			}
        } else {
			|/if (${Spawn[id ${MyTargetID}].Type.NotEqual[Corpse]} && ${Spawn[id ${MyTargetID}].PctHPs}<=${AssistAt} && ${Target.Distance}>${CombatRadius}) {
			|	/if (${Math.Distance[${Target.Y},${Target.X}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CombatRadius} && !${Pulling}) {
			|		/call GetCloser OOR
			|	}
				|/if (${ReturnToCampOn} && ${Math.Distance[${CampYLoc},${CampXLoc}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CombatRadius}) {
				|	/call GetCloser OOR
				|}
			|}
            /if (${IAmABard} && ${MeleeTwistOn}==2 && !${DPSTwisting}) /call DoBardStuff FROMHERE
            /if (${DPSOn} || ${MeleeOn} || ${PetOn}) /call CombatTargetCheck 1 FROMHERE
			|
			| The distance computation is unnecessary. The mob is already here. The routine is not being called reliably.
			|
			|/if (${DebuffAllOn}==2 && ${MyTargetID} && ${Math.Distance[${Target.Y},${Target.X}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=${CampRadius} && ${AggroTargetID}) /call DoDebuffStuff ${MyTargetID}
            /if (${DebuffAllOn}==2 && ${MyTargetID} && ${AggroTargetID}) /call DoDebuffStuff ${MyTargetID} FROMHERE
            /if (!${Me.Combat} && ${BeforeArray[1].NotEqual[null]}) /call BeforeAttack ${MyTargetID} 2 FROMHERE
        }
		POPCALL
        DEBUGCOMBAT Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Combat Cast
| -------------------------------------------------------------------------------------
    Sub CombatCast(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT Enter from ${FromWhere}
        /declare i           int      local 0
        /declare DPSStart    int      local ${Math.Calc[${DebuffCount}+1]}
        /if (${DPSStart}>${DPS.Size}) {
			POPCALL
			/return
		}
        /declare DPSAt       int      local ${AssistAt}
        /declare DPSTargetID int      local 0
        /declare DPSItem     string   local
        /declare DPSPart1    string   local
        /declare DPSPart2    string   local
        /declare DPSPart3    string   local
        /declare DPSPart4    string   local
        /declare DPSPart5    string   local
        /declare DPSStartID  int      local 0
        /declare WeaveCheck  int      local 0
        /declare CondNo      int      local 0
        /call WriteDebuffs
		DEBUGCOMBAT A: Target.ID ${Target.ID} MyTargetID ${MyTargetID} AggroTargetID ${AggroTargetID}
        /if (${TargetSwitchingOn} && ${Target.ID} && ${Target.ID}!=${MyTargetID}) /call CombatTargetCheck 1 FROMHERE
        /varset DPSStartID ${MyTargetID}
		DEBUGCOMBAT B: Target.ID ${Target.ID} MyTargetID ${MyTargetID} AggroTargetID ${AggroTargetID}
		|
		| When we get hit, each time it triggers adds 15. After three rounds, it returns to normal. DPS gradually picks back up.
		|
		/if (${DPSRateDelay}>0) /varcalc DPSRateDelay ${DPSRateDelay}-${DPSRateIncrease}
		/if (${DPSRateDelay}<0) /varset DPSRateDelay 0
		
		|/call EstTimeToLive 0
        /for i ${DPSStart} to ${DPS.Size}
			/if (!${AutoTargetOn} && !${Target.ID}) {
				POPCALL
				/return
			}
            /doevents
			/call CheckBeforeCast CombatCast FROMHERE
            /varset DPSTargetID ${MyTargetID}
            /if (${Spawn[id ${MyTargetID}].Type.Equal[Corpse]} || !${Spawn[id ${MyTargetID}].ID} || ${DPSPaused}) {
                DEBUGCOMBAT Return from CombatCast cause my target is a corpse or dead or DPSPaused ${DPSPaused}.
				POPCALL
                /return
            }
            DEBUGCOMBAT ${DPS[${i}].Arg[1,|]} ${Spell[${DPS[${i}].Arg[1,|]}].RankName} ${DPS[${i}].Arg[1,|]} !${Me.SpellReady[${Spell[${DPS[${i}].Arg[1,|]}].RankName}]} && !${Me.AltAbilityReady[${DPS[${i}].Arg[1,|]}]} && !${Me.CombatAbilityReady[${Spell[${DPS[${i}].Arg[1,|]}].RankName}]} && !${Me.AbilityReady[${DPS[${i}].Arg[1,|]}]}

			DEBUGCOMBAT While Top: MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}
            /while (1) {
				/if (!${AutoTargetOn} && !${Target.ID}) {
					POPCALL
					/return
				}
				
                | This is the Top of the outer loop that will drop you out just above the /next i before going to the next DPS entry.
                /if (!${Bool[${DPS[${i}].Arg[1,|]}]}) {
                    DEBUGCOMBAT I'm skipping in CombatCast cause there is no spell: DPS${i}
                    /break
                }

				|
				| If we are getting pummeled, and we dont belong being pummeled...slow down based on gothit. We will erode value so it will settle somewhere optimal unless the tank totally sucks.
				|
				/delay ${DPSRateDelay}
				
                /if (${DPS[${i}].Find[|weave]} || ${DPS[${i}].Find[|mash]} || ${DPS[${i}].Find[|ambush]}) /break
                /if (!${DPS[${i}].Find[command:]} && (!${Me.SpellInCooldown} && !${IAmABard} && !${Me.SpellReady[${Spell[${DPS[${i}].Arg[1,|]}].RankName}]}) && !${Me.AltAbilityReady[${DPS[${i}].Arg[1,|]}]} && !${Me.CombatAbilityReady[${Spell[${DPS[${i}].Arg[1,|]}].RankName}]} && !${Me.AbilityReady[${DPS[${i}].Arg[1,|]}]} && !${Me.ItemReady[${DPS[${i}].Arg[1,|]}]}) /break
				/if (${Int[${DPS[${i}].Arg[2,|]}]} > 0) {
                    /varset DPSPart1 ${DPS[${i}].Arg[1,|]}
                    /varset DPSPart2 ${DPS[${i}].Arg[2,|]}
                    /if (${Bool[${DPS[${i}].Arg[3,|]}]}) {
                        /varset DPSPart3 ${DPS[${i}].Arg[3,|]}
                    } else {
                        /varset DPSPart3
                    }
                    /if (${Bool[${DPS[${i}].Arg[4,|]}]}) {
                        /varset DPSPart4 ${DPS[${i}].Arg[4,|]}
                    } else {
                        /varset DPSPart4
                    }
                    /if (${Bool[${DPS[${i}].Arg[5,|]}]}) {
                        /varset DPSPart5 ${DPS[${i}].Arg[5,|]}
                    } else {
                        /varset DPSPart5
                    }
                    /if (${DPSOn}==1) {
                        /varset DPSAt ${DPSPart2}
                    } else {
                        /varset DPSAt ${AssistAt}
                    }
                } else {
                    /break
                }
				|/call EstTimeToLive
                /if (${ConOn} && ${DPS[${i}].Find[|cond]}) {
                    /varset CondNo ${DPS[${i}].Mid[${Math.Calc[${DPS[${i}].Find[|cond]}+5]},3]}
                } else {
                    /varset CondNo 0
                }
                DEBUGCOMBAT DPS${i}:${DPSPart1} ConOn: ${ConOn}  CondNo: ${CondNo}
                /if (${Target.Mezzed.ID} && !${IAmMA} && ${Spell[${DPSPart1}].Category.NotEqual[Utility Detrimental]}) {
                    DEBUGCOMBAT Skipping spell in CombatCast because target is mezzed and I'm not mainassist and it will wake up the mob.
                    /break
                }
                /if (${Spell[${DPSPart1}].Subcategory.Equal[Mana Drain]} && ${MyTargetID} && !${Spawn[id ${MyTargetID}].Class.CanCast}) {
                    DEBUGCOMBAT I'm skipping ${Spell[${DPSPart1}]} on ${Spawn[id ${MyTargetID}]} in CombatCast cause we shouldnt try to mana drain non caster mobs
                    /break
                }
                /if (${Select[${DPSPart3},Me,MA,maonce]}==0 && ${DPSTimer${i}} && (${Me.CombatAbility[${DPSPart1}]} || ${Me.Skill[${DPSPart1}]})) /break
                DEBUGCOMBAT 0:${DPS[${i}]} 1:${DPSPart1} 2:${DPSPart2} 3:${DPSPart3} 4:${DPSPart4} 5:${DPSPart5} 6:${DPSAt} 7:${Spawn[id ${MyTargetID}].PctHPs} 8:${DPSSkip} 9:${DPSAt}
				DEBUGCOMBAT MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}
				|
				| We get all this way to find this is not set, which then goes back and loops endlessly.
				|
                |/if (!${AggroTargetID}) /return
                | Check if self combat buff is active
                /if (${DPSPart3.Equal[Me]} && (${Me.Buff[${DPSPart1}].ID} || ${Me.Song[${DPSPart1}].ID})) /break
                /if (${Me.Class.Name.Equal[Cleric]} && ${DPSPart1.Find[Hammer]} && ${Pet.ID}) /break
                /if (${Me.Class.Name.Equal[Wizard]} && ${Pet.ID} && (${DPSPart1.Find[sword]} || ${DPSPart1.Find[blade]})) /break
                DEBUGCOMBAT ABTimer${i} ${ABTimer${i}} DPSTimer${i} ${DPSTimer${i}} FDTimer${i} ${FDTimer${i}}
				/if (${ABTimer${i}} || ${DPSTimer${i}} || ${FDTimer${i}}) /break
				DEBUGCOMBAT MyTargetID ${MyTargetID} PctHPs ${Spawn[id ${MyTargetID}].PctHPs} DPSSkip ${DPSSkip} DPSOn ${DPSOn} DPSAt ${DPSAt}
				| Logic glitch. If PctHPs is 100, and we want to attack DPSAt 100, then this will break! We want to use that condition only when < DPSAt
                /if (${Spawn[id ${MyTargetID}].PctHPs}<=${DPSSkip} || (${DPSOn}==1 && ${Spawn[id ${MyTargetID}].PctHPs}>${DPSAt})) /break
                /if (${DPSPart3.Equal[MA]} || ${DPSPart3.Equal[maonce]}) {
                    /varset DPSTargetID ${Spawn[=${MainAssist}].ID}
                } else /if (${DPSPart3.Equal[Me]} || ${DPSPart3.Equal[Feign]}) {
                    /varset DPSTargetID ${Me.ID}
                }
                DEBUGCOMBAT DPSTarget: ${DPSTargetID} ${Spawn[id ${DPSTargetID}]} End: ${DPSSkip} ${Spawn[id ${DPSTargetID}].PctHPs} Start: ${DPSAt} Target: ${Target.ID} Timer: ${DPSTimer${i}} DPSOn: ${DPSOn}
                /if (${Select[${DPSPart3},Me,MA]} && ${Me.Combat} && !${IAmMA}) {
                    /attack off
                    /delay 10 !${Me.Combat}
                }
                | Only cast spells with weave tag during global cooldown
                /if (${Me.SpellInCooldown} && !${IAmABard}) {
                    /if (${WeaveArray.Size}>0 && ${WeaveArray[1].NotEqual[null]}) {
                        /call CastWeave ${MyTargetID} FROMHERE
                        /varset WeaveCheck 1
                    }
                    /if (${Me.Gem[${DPSPart1}]} && ${Spawn[id ${MyTargetID}].ID}) {
                        DEBUGCOMBAT Spell in Cool Down DPSOn: ${DPSOn}
                        /if (${DPSOn}==2) {
                            /while (${Me.SpellInCooldown}) {
                                /delay 2
                            }
                        } else {
                            /break
                        }
                    }
                }
                /if (${TargetSwitchingOn} && ${Target.ID} && ${Target.ID}!=${MyTargetID}) {
					DEBUGCOMBAT Did we change target? Target.ID ${Target.ID} MyTargetID ${MyTargetID}
                    /call CombatTargetCheck 1 FROMHERE
                    /if (${DPSStartID}!=${MyTargetID}) {
						POPCALL
						/return
					}
                }
                /call CastWhat "${DPSPart1}" ${DPSTargetID} DPS ${CondNo} 0 FROMHERE
                DEBUGCOMBAT MacroReturn: ${Macro.Return}
                /if (${Macro.Return.Equal[CAST_COND_FAILED]}) /break
                /varset MacroReturn ${Macro.Return}
                /varset LastDPSCast ${DPSPart1}
				DEBUGCOMBAT While Before DoEvents: MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}
                /doevents
				DEBUGCOMBAT While After DoEvents: MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}
                /if (${MacroReturn.Equal[CAST_SUCCESS]}) {
                    /if (${Spawn[id ${MyTargetID}].ID}) /echo ** ${DPSPart1} on >> ${Spawn[id ${DPSTargetID}].CleanName} <<
                    | Set timer for spells labeled once 5m
                    /if (${DPSPart3.Length} && (${DPSPart3.Equal[once]} || ${DPSPart3.Equal[maonce]})) {
                        /varset DPSTimer${i} 5m
                    | Timers for items
                    } else /if (${FindItemCount[=${DPSPart1}]}) {
                        /varcalc DPSTimer${i} ${FindItem[=${DPSPart1}].Spell.Duration.TotalSeconds}*10
                    | FD to lose aggro
                    } else /if (${Select[${Me.Class.ShortName},BST,MNK,NEC,SHD]} && ${DPSPart3.Equal[Feign]}) {
                        /delay 30 ${Me.State.Equal[FEIGN]}
                        /varset FDTimer${i} 60s
                        /delay 10s ${Me.State.NotEqual[FEIGN]}
                        /if (${Me.State.Equal[FEIGN]} && !${Me.Sitting}) /stand
                    | Timers for spells
                    } else /if (${Me.Book[${DPSPart1}]}) {
                        | - Attack Buff Timers are seperate. DPS timers are cleared after every fight.
                        /if (${Select[${DPSTargetID},${Me.ID},${Spawn[=${MainAssist}].ID}]}) {
                            |/varcalc ABTimer${i} (${Spell[${DPSPart1}].Duration.TotalSeconds}*${DurationMod})*10
                            /varcalc ABTimer${i} ${Spell[${DPSPart1}].MyDuration.TotalSeconds}*10
                            DEBUGCOMBAT Spell: ${DPSPart1} Timer: ABTimer${i} ${ABTimer${i}}
                        | - Custom timer for counterbias
                        } else /if (${Me.Class.Name.Equal[Shaman]} && ${DPSPart1.Find[counterbias]}) {
                            /varset DPSTimer${i} 1.5m
                        | Custom timer for Chanter suffocation
                        } else /if (${Me.Class.Name.Equal[enchanter]} && ${DPSPart1.Find[suffocation]}) {
                            /varset DPSTimer${i} 1m
                        | Custom timer for Beastlord Feralgia Timer
                        } else /if (${Me.Class.Name.Equal[Beastlord]} && ${DPSPart1.Find[feralgia]}) {
                            /varset DPSTimer${i} 1.5m
                        | Regular spells
                        } else /if (${Spell[${DPSPart1}].Duration.TotalSeconds}>0) {
                            /varcalc DPSTimer${i} ${Spell[${DPSPart1}].Duration.TotalSeconds}*10
                        | Spells with no timers assign DPS interval
                        } else {
                            /varset DPSTimer${i} ${DPSInterval}s
                        }
                    | AA timers
                    } else /if (${Me.AltAbility[${DPSPart1}]}) {
                        /if (${Me.AltAbility[${DPSPart1}].Spell.Duration.TotalSeconds}) {
                            /varcalc DPSTimer${i} ${Me.AltAbility[${DPSPart1}].Spell.Duration.TotalSeconds}*10
                        } else /if (${Me.AltAbility[${DPSPart1}].Spell.Trigger.Duration.TotalSeconds}) {
                            /varcalc DPSTimer${i} ${Me.AltAbility[${DPSPart1}].Spell.Trigger.Duration.TotalSeconds}*10
                        }
                    | Disc Timers
                    } else /if (${Spell[${DPSPart1}].Duration}>0 && ${Me.CombatAbility[${DPSPart1}]}) {
                        /varcalc DPSTimer${i} ${Spell[${DPSPart1}].Duration.TotalSeconds}*10
                    | AA and disc with no timers assign DPS interval
                    } else {
                        /varset DPSTimer${i} ${DPSInterval}s
                    }
                } else /if (${MacroReturn.Left[13].Equal[CAST_RESISTED]}) {
                    |/echo ** ${DPSPart1} on >> ${Spawn[id ${DPSTargetID}].CleanName} << - RESISTED
                    /echo ** ${Spawn[id ${DPSTargetID}].CleanName} - RESISTED - ${LastResisted}
                    /if (${DPSPart3.Length} && (${DPSPart3.Equal[once]} || ${DPSPart3.Equal[maonce]})) {
                        /varset DPSTimer${i} 5m
                    }
                } else /if (${MacroReturn.Equal[CAST_TAKEHOLD]}) {
                    /echo ** ${DPSPart1} on >> ${Spawn[id ${DPSTargetID}].CleanName} << - DID NOT TAKE HOLD
                    /varset DPSTimer${i} 5m
                }
                /break
            }
			|/call EstTimeToLive 0
            | This is the Bottom of the Outer Loop. Add additional checks needed before /next i entry.
            DEBUGCOMBAT ${DPS[${i}].Arg[1,|]} ${Macro.Return} DPSTimer${i} ${DPSTimer${i}}
			DEBUGCOMBAT 1: MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}
			DEBUGCOMBAT 2: MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}

            |/if (${TargetSwitchingOn}) {
            |    /if (${Target.ID} && ${Target.ID}!=${DPSTargetID})
            |}
            /call CombatTargetCheck 1 FROMHERE
			DEBUGCOMBAT 3: MyTargetID ${MyTargetID} DPSTargetID ${DPSTargetID} AggroTargetID ${AggroTargetID}

            /if (${TargetSwitchingOn} && ${DPSStartID}!=${MyTargetID}) {
				POPCALL
				/return
			}
            /if (${WeaveArray.Size}>0 && ${WeaveArray[1].NotEqual[null]} && (${Me.SpellInCooldown} || !${WeaveCheck})) /call CastWeave ${MyTargetID} FROMHERE
            /if (${MashArray.Size}>0 && ${MashArray[1].NotEqual[null]}) /call MashButtons FROMHERE
            /varset WeaveCheck 0
			|/call EstTimeToLive 0
        /next i
		POPCALL
        DEBUGCOMBAT Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: CombatReset
| -------------------------------------------------------------------------------------
    Sub CombatReset(int SFlag, string CalledFrom)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare i 				int 	local
        /declare j 				int 	local
		/declare RandMoveTime	int		local	0
		
		/varcalc RandMoveTime ${Math.Calc[10+${Math.Rand[10]}].Int}
		
        DEBUGCOMBAT CombatReset: Enter ${SFlag} ${CalledFrom}
        /call MobRadar los ${MeleeDistance} FROMHERE
        /for j 1 to 50
            /if (${AddsArray[${j},1].Equal[${MyTargetID}]}) /call RemoveFromArray AddsArray ${j}
            /if (${MobCount}==0) /call RemoveFromArray AddsArray ${j}
            /if (${MezOn} && ${j}<=13) {
                /if (${MezArray[${j},1].Equal[${MyTargetID}]}) {
                    /call RemoveFromArray MezArray ${j}
                } else /if (${MezArray[${j},1].NotEqual[NULL]}) {
                    /if (!${Spawn[id ${MezArray[${j},1]}].ID} || ${Spawn[id ${MezArray[${j},1]}].Type.Equal[Corpse]}) /call RemoveFromArray MezArray ${j}
                }
            }
        /next j
        /if (${MezOn}) {
            /if (${MezImmuneIDs.Find[|${MyTargetID}]}) /varset MezImmuneIDs ${MezImmuneIDs.Replace[|${MyTargetID},]}
            /varset j 1
            /while (${Bool[${MezImmuneIDs.Arg[${j},|].Length}]}) {
                /if (!${Bool[${Spawn[id ${MezImmuneIDs.Arg[${j},|]}].ID}]} || ${Spawn[id ${MezImmuneIDs.Arg[${j},|]}].Type.Equal[corpse]} ) {
                    /varset MezImmuneIDs ${MezImmuneIDs.Replace[|${MezImmuneIDs.Arg[${j},|]},]}
                } else {
                    /varcalc j ${j}+1
                }
            }
            /varset MezMobDone 0
        }
        /if (${MobsToIgnoreByID.NotEqual[null]}) {
            /varset j 1
            /while (${Bool[${MobsToIgnoreByID.Arg[${j},|].Length}]} && ${MobsToIgnoreByID.Arg[${j},|].NotEqual[null]}) {
                /if (!${Bool[${Spawn[id ${MobsToIgnoreByID.Arg[${j},|]}].ID}]} || ${Spawn[id ${MobsToIgnoreByID.Arg[${j},|]}].Type.Equal[corpse]} ) {
                    /varset MobsToIgnoreByID ${MobsToIgnoreByID.Replace[|${MobsToIgnoreByID.Arg[${j},|]},]}
                } else {
                    /varcalc j ${j}+1
                }
            }
        }
		|/call EstTimeToLive 1
        /varset IsFriendlyIDList
        /varset IsHostileIDList
        /varset IsMaybeHostileIDList
		/varset DPSRateDelay ${DPSRateStartDelay}
		/varset GetTheLooseMobAlertOn 0
        /varset CalledTargetID 0
        /varset AggroTargetID2 0
        /if (${Defined[DPSTimeStart${MyTargetID}]}) /deletevar DPSTimeStart${MyTargetID}
        /varset MyTargetID 0
        /varset MyTargetName
		/varset LastTargetID 0					  
        /varset ValidTarget 0
        /varset MercAssisting 0
        /varset CombatStart 0
        /varset Pulled 0
        /varset NamedCheck 0
        /if (${Role.Find[puller]}) {
            /call PullReset FROMHERE
        } else {
            /moveto dist 10
            /if (${MoveTo.Moving}) /moveto off
            /if (${PullMoveUse.Equal[nav]}) {
                /if (${Navigation.Active}) /squelch /nav stop
            }
        }
        /if (${UseMQ2Melee}) /squelch /melee melee=0
        /squelch /attack off
        /if (${Me.AutoFire}) /autofire
        /if (${AutoFireOn}==2) /varset AutoFireOn 1
        /squelch /target clear
        DEBUGCOMBAT CombatReset In Group Check: ${Group.Member[${MainAssist}].Index} !${IAmMA} ${XTSlot}
        /if (${XTarAutoSet} && !${Me.Hovering}) {
            /if (!${Group.Member[${MainAssist}].Index} && !${IAmMA}) /xtarget set ${XTSlot} autohater
        }
        /if (${DPSOn}) {
            /for i 1 to ${DPS.Size}
                /if (${Int[${DPS[${i}].Arg[2,|]}]}<101) {
                    /varset DPSTimer${i} 0
                    /varset FDTimer${i}  0
                }
            /next i
        }
        /if (${Pet.ID}) {
            /varset PetAttack 0
            /call PetBackOff FROMHERE
            /if (${PetHoldOn} && !${Pet.${PetHold}}) /pet ${PetHold}
            |/if (${Pet.Stop}) /pet stop off
        }
        /if (${DebuffAllOn} && ${DebuffCount}) {
            /varset j 0
            /for i 1 to ${XSlotTotal}
                /if (${Me.XTarget[${i}].ID} && ${Me.XTarget[${i}].TargetType.Equal[Auto Hater]} && ${Me.XTarget[${i}].Type.NotEqual[Corpse]} && ${Me.XTarget[${i}].Distance}<=${MeleeDistance}) /varcalc j ${j}+1
            /next i
            /if (${j}==0) {
                /for i 1 to ${DebuffCount}
                    /varset DBOTimer${i} 0
                    /varset DBOList${i}
                /next i
            }
        }
        /varset Attacking 0
        /varset BurnActive 0
        /if (${BurnID} && (!${Spawn[id ${BurnID}].ID} || ${Spawn[id ${BurnID}].Type.Equal[corpse]})) {
            /varset BurnCalled 0
            /varset BurnID 0
            /echo Burn Target is Dead. Turning Burn off.
        }
        /if (!${TwistOn} && ${MeleeTwistOn}) /varset DPSTwisting 0
        /if (${LootOn} && !${SFlag}) {
            /delay 10
            /call LootStuff
        }
        /if (${IAmABard}) /call DoBardStuff FROMHERE
        /varset TankTimer 30s
        DEBUGCOMBAT CombatReset: Leave
        /varset PetFollowTimer 60s
        /delay 2s ${AggroOffTimer}==0
        /while (1) {
            /varset EventFlag 0
            /doevents Timer
            /if (!${EventFlag}) /break
        }
        |/doevents GainSomething
		/doevents		
		| Get back to camp
        /if (!${Select[${Role},PULLER_ROLES]} && ${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc}]} > 15) {
			/delay ${RandMoveTime}
            /call DoWeMove 0  FROMHERE
		}
		
        /doevents flush
        /if (${Stick.Active} && ${Stick.StickTarget}!=${If[${Spawn[=${WhoToChase}].Type.Equal[Pet]},${Spawn[=${WhoToChase}].Master.ID},${Spawn[=${WhoToChase}].ID}]}) /stick off
        /if (${UseMQ2Melee}) /squelch /melee melee=1
        /if (${Select[${Me.Class.ShortName},ROG]}) /call Roguestuff
		POPCALL
    /return

| -------------------------------------------------------------------------------------
| SUB: CombatTargetCheck
|
| SetTarget 0: 1: , 2: Sets the target even if dps is paused.
| -------------------------------------------------------------------------------------
    Sub CombatTargetCheck(int SetTarget, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		/if (!${AutoTargetOn}) {
			/if (${Pet.ID} && !${Target.ID}) {
				/call PetBackOff FROMHERE
			}
			POPCALL
			/return
		}

        /if (${MercOn} && ${Mercenary.State.Equal[Active]}) /call MercsDoWhat FROMHERE

        | If mob is dead return
        DEBUGCOMBAT Enter from ${FromWhere} - 1 ${MyTargetID} ${Spawn[id ${MyTargetID}].Type} ${CalledTargetID}
        /if (${TargetSwitchingOn} && ${Target.ID} && ${Spawn[id ${Target.ID}].Type.Equal[Corpse]}) {
			POPCALL
			/return
		}
        /if (${DPSPaused} && ${SetTarget}!=2) {
			POPCALL
			/return
		}
        /if (${MyTargetID} && (${Spawn[id ${MyTargetID}].Type.Equal[Corpse]} || !${Spawn[id ${MyTargetID}].ID})) {
            /varset LastTargetID ${MyTargetID}
            /varset MyTargetID 0
            |/return
        }
		
		| Current MyTargetID. This is used later to see if target has changed.
        /declare CMyTargetID int Local ${MyTargetID}
		
        | Check target matches MA if group mainassist assigned and MA is in group
        DEBUGCOMBAT Is the mainassist also the Group mainassist?
		/if (${Spawn[=${MainAssist}].ID} && ${Group.MainAssist.ID} && ${Spawn[=${MainAssist}].ID}==${Group.MainAssist.ID}) {
            /if (${Group.MainAssist.ID}!=${Me.ID}) {
				DEBUGCOMBAT I am not the Group MainAssist
                |/if (${Target.ID}!=${Me.GroupAssistTarget.ID} && ${Group.MainAssist.ID}!=${Me.ID}) {
                /if (${Target.ID}!=${Me.GroupAssistTarget.ID}) {
                    /if (${MyTargetID}!=${Me.GroupAssistTarget.ID} && ${Spawn[id ${Me.GroupAssistTarget.ID} npc].ID}) {
                        /if (${MyTargetID}) /echo My target does not match MA's. Switching to new target.
						/varset DPSRateDelay ${DPSRateStartDelay}
                        /varset MyTargetID ${Me.GroupAssistTarget.ID}
                    }
                }
            } else {
				DEBUGCOMBAT I am the Group MainAssist
                /if (${Target.ID} && ${Target.ID}!=${MyTargetID}) {
					DEBUGCOMBAT My target is not the same one I told everyone else to attack.
                |/if (${TargetSwitchingOn} && ${Target.ID} && ${Target.ID}!=${MyTargetID} && (!${Select[${Target.Type},pc,mercenary,pet]} || (${Target.Type.Equal[pet]} && ${Target.Master.Type.NotEqual[pc]}))) {
                    /if (${TargetSwitchingOn} || (!${TargetSwitchingOn} && !${CalledTargetID})) {
						DEBUGCOMBAT Target switching is on or need to get the fight going. Doing something.
                        /call IsFriendly ${Target.ID} FROMHERE
                        /if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
                        |/if (!${Select[${Target.Type},pc,mercenary,pet]} || (${Target.Type.Equal[pet]} && ${Target.Master.Type.NotEqual[pc]})) {
                            /echo I am MA, and I switched to new Target or for some reason didn't call assist earlier.
							/varset DPSRateDelay ${DPSRateStartDelay}
                            /varset MyTargetID ${Target.ID}
                            /varset MyTargetName ${Target.CleanName}
							DEBUGCOMBAT Calling Assist
                            /if (${Select[${Role},Tank,PullerTank,Hunter]}) {
								DEBUGCOMBAT A tank is tanking.
                                /call BroadCast y "TANKING-> ${Spawn[id ${MyTargetID}].CleanName} <- ID:${MyTargetID}"
                            } else /if (${Select[${Role},pettank,pullerpettank,hunterpettank]}) {
								DEBUGCOMBAT Pet is tanking
								/call PetEngageTarget ${MyTargetID} 0 FROMHERE
                                /call BroadCast y "${Pet.CleanName} is TANKING-> ${Spawn[id ${MyTargetID}].CleanName} <- ID:${MyTargetID}"
                            } else {
                                | All hope is lost.
                                /call BroadCast y "TANKING-> ${Spawn[id ${MyTargetID}].CleanName} <- ID:${MyTargetID}"
                            }
                        }
                    } else {
						DEBUGCOMBAT 1.6
                        /call TargetThis ${MyTargetID}
                    }
                }
                /varset CalledTargetID 0
            }
        } else /if (${CalledTargetID} && ${CalledTargetID}!=${MyTargetID}) {
			DEBUGCOMBAT A target was called ${CalledTargetID} and it's different than what I have ${MyTargetID}
            /varset MyTargetID ${CalledTargetID}
            /varset CalledTargetID 0
        }
		
		DEBUGCOMBAT 1.8
        /if (${CMyTargetID}!=${MyTargetID} && ${Target.ID}!=${MyTargetID} && ${Spawn[id ${MyTargetID}].ID}) {
            /if (${XTarAutoSet} && !${Group.Member[${MainAssist}].Index} && !${IAmMA}) {
				DEBUGCOMBAT All heck has broken loose, deciding which mob to attack on my own. Maybe GotHit fired.
                /call IsFriendly ${MyTargetID} FROMHERE
                /if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
                |/if (${Spawn[id ${MyTargetID}].Type.NotEqual[PC]}) {
                    /call TargetThis ${MyTargetID}
                    /if (!${Me.XTarget[${XTSlot}].ID} || (${Me.XTarget[${XTSlot}].ID}!=${MyTargetID})) /xtarget set ${XTSlot} currenttarget
                }
            } else {
				DEBUGCOMBAT Things are clearly awry.
                /if (${SetTarget}) {
                    /call TargetThis ${MyTargetID}
                    | Something is up, so id better go to the MA.
                    /if (${Spawn[=${MainAssist}].Distance}>${MeleeDistance}) /call GetCloser oor FROMHERE
                    /if (${SetTarget}!=2 && ${Pet.ID} && ${Pet.Combat}) /call PetEngageTarget ${MyTargetID} 0 FROMHERE
					DEBUGCOMBAT 1.11
                }
            }
			DEBUGCOMBAT 1.12
            /varset MyTargetName ${Spawn[id ${MyTargetID}].CleanName}
            /varset LastTargetID ${MyTargetID}
        }
		POPCALL
        DEBUGCOMBAT Leave. MyTargetID ${MyTargetID} LastTargetID ${LastTargetID} Spawn Type ${Spawn[id ${MyTargetID}].Type} CalledTargetID ${CalledTargetID}
    /return

| ----------------------------------------------------------------------------
| SUB: Event AttackCalled
| ----------------------------------------------------------------------------
    Sub Event_AttackCalled(String Line, string ACCaller, string ACMobID)
		/doevents flush AttackCalled
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        DEBUGCOMBAT Enter Event_AttackCalled ACCaller ${ACCaller} ACMobID ${ACMobID}

		/if (!${AutoTargetOn}) {
			POPCALL
			/return
		}
		/if (${IAmMA}) {
			POPCALL
			/return
		}
		/if (${ACCaller.NotEqual[${MainAssist}]}) {
			POPCALL
			/return
		}
		/call CheckInvis ${MainAssist}
		/if (${Macro.Return.Equal[INVIS_TRUE]}) {
			POPCALL
			/return	
		}
		/if (!${ACMobID.Length} || ${ACMobID.Equal[null]}) {
            /varset CalledTargetID 0
			POPCALL
            /return
        }
		/if (${ACMobID.Equal[${CalledTargetID}]}) {
			POPCALL
			/return
		}
        /varset CalledTargetID ${ACMobID}
		|
		| If the MA is invis, then don't do anything yet. They are probably just looking.
		|	
        /varset EventFlag 1
        /echo \ay==> \awAttack Called: \ay${ACCaller} \ar${ACMobID}
		/if (${DropInvisMAAssist} && ${Me.Invis}) /makemevis
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: Event GoM Off
| ----------------------------------------------------------------------------
    Sub Event_GoMOff
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /varset EventFlag 1
        /varset GoMActive 0
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event GoM On
| ----------------------------------------------------------------------------
   Sub Event_GoMOn
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT Enter

        /varset EventFlag 1
        /if (${Select[${Me.Class.ShortName},BRD,BER,MNK,ROG,WAR]} || ${GoMByPass}) {
            /varset GoMByPass 0
            /doevents flush GoMOn
            /doevents flush GoMOff
			POPCALL
            /return
        }
        /if (!${CombatStart} || ${GoMTimer}) {
			POPCALL
			/return
		}
        | Release timer after trying to cast for 10 secs
        /varset GoMTimer 3s
        /declare i int local
        /declare GoMCast string local
        /declare GoMTarget string  local
        /declare GoMCastStat string ${CastResult}
        /declare CondNo local int 0
		|/call EstTimeToLive 0
        /for i 1 to ${GoMSpell.Size}
			|/call EstTimeToLive
            /if (${ConOn} && ${GoMSpell[${i}].Find[|cond]}) {
                /varset CondNo ${GoMSpell[${i}].Mid[${Math.Calc[${GoMSpell[${i}].Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }
            /varset GoMCast ${GoMSpell[${i}].Arg[1,|]}
            /varset GoMTarget ${GoMSpell[${i}].Arg[2,|]}
            /if (${GoMCast.Equal[null]} || ${GoMCast.Find[spell]} || ${GoMSpellTimer${i}}) /continue
            /echo Gift of Mana detected! Trying to cast ${GoMCast}
            /doevents flush GoMOn
            /if (${GoMTarget.Equal[Me]} && ${Me.ID}) {
                /varset GoMTarget ${Me.ID}
            } else /if (${GoMTarget.Equal[MA]} && ${Spawn[=${MainAssist}].ID}) {
                /varset GoMTarget ${Spawn[=${MainAssist}].ID}
            } else /if (${MyTargetID}) {
                /varset GoMTarget ${MyTargetID}
            } else {
                /continue
            }
            /varset GoMActive 1
            /if (${GoMTarget.Equal[${MyTargetID}]} && (${Target.Type.Equal[Corpse]} || !${Spawn[id ${MyTargetID}].ID})) {
                DEBUGN Event_GoMOn [GoM] skipping because mob is dead or a corpse.
                /echo [GoM] being skipped, because target (${GoMTarget}) is a corpse.
                /varset GoMTimer 0
                /delay 10
                /doevents GoMOff
				POPCALL
                /return
            }
            | Wait for global cooldown if active
            /while (${Me.SpellInCooldown}) {
                /if (${MeleeOn}) {
                    /if (${WeaveArray.Size}>0 && ${WeaveArray[1].NotEqual[null]}) /call CastWeave ${MyTargetID} FROMHERE
                    /if (${MashArray.Size}>0 && ${MashArray[1].NotEqual[null]}) /call MashButtons FROMHERE
                } else {
                    /delay 2
                }
            }
            /if (${Me.SpellReady[${GoMCast}]}) {
                /call CastWhat "${GoMCast}" ${GoMTarget} GoM ${CondNo} 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_COND_FAILED]}) /continue
                /varset LastDPSCast ${GoMCast}
            } else {
                /echo "${GoMCast}" is not ready!
                /delay 10
            }
            DEBUGN Return: ${Macro.Return}
            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                /echo Gift of Mana Casting >> ${GoMCast} <<
                /varset GoMTimer 0
                /varset GoMSpellTimer${i} ${Spell[${GoMCast}].MyDuration.TotalSeconds}*10
                /doevents flush GoMOn
                /delay 10
                /doevents GoMOff
                /varset CastResult ${GoMCastStat}
				POPCALL
                /return
            } else /if (${Macro.Return.Equal[CAST_CANCELLED]}) {
                /varset CastResult CAST_CANCELLED
				POPCALL
                /return
            }
			|/call EstTimeToLive 0
        /next i
        /varset CastResult ${GoMCastStat}
		POPCALL
    /return
	
| -------------------------------------------------------------------------------------
| SUB: GetCombatTarget - Main Tank selects target to kill.
| -------------------------------------------------------------------------------------
    Sub GetCombatTarget(string FromWhere)
        /if (${DMZ} && ${Me.InInstance}==FALSE) /return
        /if (!${MeleeOn} && !${DPSOn} && !${MezOn}) /return
        /if (${DPSPaused}) /return
        /if (${Me.Hovering}) /return
        /if (${Pulled} && ${MyTargetID} && ${IAmMA}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		/if (!${AutoTargetOn}) {
			/if (${Pet.ID} && !${Target.ID}) {
				/call PetBackOff FROMHERE
			}
			POPCALL
			/return
		}

        DEBUGCOMBAT GetCombatTarget Enter from ${FromWhere}
        /declare j int local
        /declare n int local
        /declare HighestMobID int local 0
        /declare ClosestMobID int local 0
        /declare MostHurtMobID int local 0
        /declare BlurredMobID int local 0
        /declare TempTargetID int local
        /doevents
        /if (${AggroTargetID2} && (!${Spawn[id ${AggroTargetID2}].ID} || ${Spawn[id ${AggroTargetID2}].Type.Equal[corpse]})) /varset AggroTargetID2 0
        /call MobRadar los ${MeleeDistance} FROMHERE
        | Normal assist check
        DEBUGCOMBAT GetCombatTarget0: ${Me} ${MainAssist} ${Spawn[=${MainAssist}].Distance} ${MobCount} ${AggroTargetID} ${Target.ID} ${MyTargetID} ${Me.Combat}
        /if (${IAmMA} || (!${Spawn[=${MainAssist}].ID} && ${Select[${Role},OFFTANK_ROLES]})) {
            DEBUGCOMBAT GetCombatTarget2: MainAssist.Equal[${Me}] is ${IAmMA} OR my role is ${Role} MobCount = ${MobCount}
            /if ((${Target.CleanName.Equal[${Me}]} || ${Pet.ID}==${Target.ID}) && (${MobCount} || ${AggroTargetID})) /call TargetThis
            | I am tank with a single mob wait for it then validate and attack.
            /if (${MobCount}==1 && (!${XTSlot2} || (${XTSlot2} && !${Me.XTarget[${XTSlot2}].ID})) && ${AggroTargetID}) {
                DEBUGCOMBAT GetCombatTarget: ${MobCount}==1 && ${AggroTargetID}
                /call TargetThis ${AggroTargetID}
                DEBUGCOMBAT GetCombatTarget: Single target: ${AggroTargetID} ${Spawn[id ${AggroTargetID}].CleanName}
            } else /if ((${MobCount}>=2 || (${XTSlot2} && ${Me.XTarget[${XTSlot2}].ID})) && ${AggroTargetID}) {
                | More than one mob
                | Check if named incoming an target if true else assign closest target.
                /if (${Spawn[xtarhater named].ID}) {
                    /varset TempTargetID ${Spawn[xtarhater named].ID}
                    /call TargetThis ${TempTargetID}
                } else /if (${Alert[4].Size} && ${Spawn[xtarhater alert 4].ID} && ${Spawn[xtarhater alert 4].Type.NotEqual[Corpse]}) {
                    /varset TempTargetID ${NearestSpawn[1, xtarhater alert 4].ID}
                    /if (!${SpamTimer2}) {
                        /call BroadCast y "Grabbing MEZ Immune -> ${Spawn[id ${TempTargetID}].Name} <- ID:${Spawn[id ${TempTargetID}].ID} "
                        /varset SpamTimer2 15s
                    }
                    /call TargetThis ${TempTargetID}
                } else {
                    /varset j ${SpawnCount[xtarhater]}
                    /if (${j}) {
                        /varset TempTargetID ${NearestSpawn[1, xtarhater].ID}
                        /varset ClosestMobID ${TempTargetID}
                        /varset HighestMobID ${TempTargetID}
                        /varset MostHurtMobID ${TempTargetID}
                        /for n 1 to ${j}
                            /varset TempTargetID ${NearestSpawn[${n}, xtarhater].ID}
                            |/if (${Math.Distance[${Spawn[id ${ClosestMobID}].Y},${Spawn[id ${ClosestMobID}].X}:${CampYLoc},${CampXLoc}]}>${Math.Distance[${Spawn[id ${TempTargetID}].Y},${Spawn[id ${TempTargetID}].X}:${CampYLoc},${CampXLoc}]}) /varset ClosestMobID ${TempTargetID}
                            /if (${Spawn[id ${TempTargetID}].PctHPs}<${Spawn[id ${MostHurtMobID}].PctHPs}) /varset MostHurtMobID ${TempTargetID}
                        /next n
                    }
                    | Don't need to target mob on incoming and out of meleedistance'
                    /if (${MobCount}) {
                        /if (${ReturnToCamp}) {
                            /if (${MostHurtMobID} && ${ClosestMobID}!=${MostHurtMobID} && ${Math.Distance[${Spawn[id ${MostHurtMobID}].Y},${Spawn[id ${MostHurtMobID}].X}:${CampYLoc},${CampXLoc}]}<=${MeleeDistance}) /varset ClosestMobID ${MostHurtMobID}
                            /if (${Target.ID}!=${ClosestMobID} && ${Math.Distance[${Spawn[id ${ClosestMobID}].Y},${Spawn[id ${ClosestMobID}].X}:${CampYLoc},${CampXLoc}]}<=${MeleeDistance}) {
                                /call TargetThis ${ClosestMobID}
                            }
                        } else {
                            /if (${MostHurtMobID} && ${ClosestMobID}!=${MostHurtMobID} && ${Spawn[id ${MostHurtMobID}].Distance}<=${MeleeDistance}) /varset ClosestMobID ${MostHurtMobID}
                            /if (${Target.ID}!=${ClosestMobID} && ${Spawn[id ${ClosestMobID}].Distance}<=${MeleeDistance}) {
                                /call TargetThis ${ClosestMobID}
                            }
                        }
                    }
                }
                DEBUGCOMBAT ClasestMobID: ${ClosestMobID} Distance: ${Math.Distance[${Spawn[id ${ClosestMobID}].Y},${Spawn[id ${ClosestMobID}].X}:${CampYLoc},${CampXLoc}]} XTarget[${XTSlot2}] ID: ${Me.XTarget[${XTSlot2}].ID} Distance: ${Math.Distance[${Me.XTarget[${XTSlot2}].Y},${Me.XTarget[${XTSlot2}].X}:${CampYLoc},${CampXLoc}]} AgroTargetID: ${AggroTargetID} MostHurtID: ${MostHurtMobID}
            } else /if (!${AggroTargetID} && ${MobCount} && ${MezMobFlag}==1) {
			
			
				| BUG: This is confusing nearby mobs that are not agro as blurred. Somehow the mezmobflag is still on, I think?
				| This should just be another pull. They may be out of aggro range. If we just auto-engage the targets,
				| right after a combat reset, we end up just aggroing everything around, which is potentially lethal.
				
                | Check for memblurred mobs in camp when nothing left on xtarget. Check only for 5 secs after last mob.
                DEBUGCOMBAT GetCombatTarget3: ${AggroTargetID} ${MobCount} ${MezMobFlag}
                /varset BlurredMobID ${NearestSpawn[1,npc targetable los radius ${MeleeDistance} zradius 50 noalert 3].ID}
                DEBUGCOMBAT GetCombatTarget4: ${BlurredMobID} ${Math.Distance[${Spawn[id ${BlurredMobID}].Y},${Spawn[id ${BlurredMobID}].X}:${CampYLoc},${CampXLoc}]} ${MeleeDistance}
				| Rather than do it relative to camp, let's do it to the MA. Within 50 is a reasonable aggro radius.
                |/if (${BlurredMobID} && ${Math.Distance[${Spawn[id ${BlurredMobID}].Y},${Spawn[id ${BlurredMobID}].X}:${CampYLoc},${CampXLoc}]}<${MeleeDistance}) {
				/if (${BlurredMobID} && ${Math.Distance[${Spawn[id ${BlurredMobID}].Y},${Spawn[id ${BlurredMobID}].X}:${Me.Y},${Me.X}]}<50) {
                    /call TargetThis ${BlurredMobID}
                    /varset MezMobFlag 0
                    /if (${Target.Mezzed.ID}) {
                        /call BroadCast y "Found Mezzed Mob: ${Spawn[id ${BlurredMobID}].CleanName} <- ID:${BlurredMobID}"
                        /echo MEZ >> Found a Mezzed mob in Camp. <<
                        /varset AggroTargetID2 ${BlurredMobID}
                        /varset MyTargetID ${Target.ID}
                        /varset MyTargetName ${Target.CleanName}
                        /varset LastTargetID ${MyTargetID}
                    } else {
                        /if (${Target.ID}) /squelch /alert add 3 id ${Target.ID}
                    }
					POPCALL
                    /return
                }
                /varset MezMobFlag 0
            }
        }
        DEBUGCOMBAT GetCombatTarget: validatetarget ID: ${Target.ID}
        /if (!${Target.ID}) {
            DEBUGCOMBAT GetCombatTarget: Validate Target - No target return
			POPCALL
            /return
        }
        /varset TempTargetID ${Target.ID}
        /call ValidateTarget FROMHERE
        | If target is not valid return
        DEBUGCOMBAT GetCombatTarget Target:${Target.CleanName} ValidTarget:${ValidTarget} Marco Return:${Macro.Return}
        /if (${ValidTarget}==0) {
            /varset MyTargetID 0
            /varset MyTargetName
			POPCALL
            /return
        } else {
            /if (${Target.ID}!=${TempTargetID}) {
               /call TargetThis ${TempTargetID}
            }
           /varset MyTargetID ${Target.ID}
           /varset MyTargetName ${Target.CleanName}
           /varset LastTargetID ${MyTargetID}
        }
		POPCALL
        DEBUGCOMBAT GetCombatTarget MyTargetName:${MyTargetName} ID:${MyTargetID}
        DEBUGCOMBAT GetCombatTarget Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Mash Buttons
| -------------------------------------------------------------------------------------
    Sub MashButtons(TarID)
        /if (${DPSOn}==0) /return
        /if (!${Select[${Me.State},stand,mount]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare i int local
        /declare MashThis string local
        /declare MashThisArg3 string local
        /declare MashThisArg4 string local
        /if (${TargetSwitchingOn}) {
            /if (${Target.ID} && ${Target.ID}!=${MyTargetID}) /call CombatTargetCheck 1 FROMHERE
        } else /if (${Target.ID}!=${MyTargetID}) {
			/call TargetThis ${MyTargetID}
        }
        /for i 1 to ${MashArray.Size}
            /doevents
            /varset MashThis ${MashArray[${i}].Arg[1,|]}
            /if (!${Bool[${MashThis}]} || !${Target.ID} || ${Target.Type.Equal[corpse]}) {
				POPCALL
				/return
			}
			|/call EstTimeToLive
            /if (!${ConOn} || !${MashArray[${i}].Find[|cond]} || ${If[${Cond[${MashArray[${i}].Mid[${Math.Calc[${MashArray[${i}].Find[|cond]}+5]},3]}]},1,0]}) {
                /if (${FindItem[=${MashThis}].ID} && ${Me.ItemReady[${MashThis}]}) {
                    /useitem "${MashThis}"
                    /delay 2
                    /echo ## Mashing >> ${MashThis} <<
                } else /if (${Me.AltAbility[${MashThis}]} && ${Me.AltAbilityReady[${MashThis}]} && ${Me.AltAbility[${MashThis}].Type}!=5 && ${MashThis.NotEqual[twincast]})  {
                    /alt act ${Me.AltAbility[${MashThis}].ID}
                    /delay 2
                    /if (!${Me.AltAbilityReady[${MashThis}]}) /echo ## Mashing >> ${MashThis} <<
                } else /if (${Me.CombatAbility[${MashThis}]} && !${Me.CombatAbilityTimer[${MashThis}]} && ${Me.CombatAbilityReady[${MashThis}]} && ${Spell[${MashThis}].EnduranceCost}<${Me.Endurance}) {
                    /disc ${Me.CombatAbility[${Me.CombatAbility[${MashThis}]}].ID}
                    /delay 2
                   /if (!${Me.CombatAbilityReady[${MashThis}]}) /echo ## Mashing >> ${MashThis} <<
                } else /if (${Me.Skill[${MashThis}]} && ${Me.AbilityReady[${MashThis}]}) {
                    /doability "${MashThis}"
                    /delay 2
                    /if (!${Me.AbilityReady[${MashThis}]}) /echo ## Mashing >> ${MashThis} <<
                }
            }
        /next i
		POPCALL
    /return 0

| ----------------------------------------------------------------------------
| SUB: NamedWatch
| ----------------------------------------------------------------------------
    Sub NamedWatch(int IgnoreTarget, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGCOMBAT Enter from ${FromWhere}

        /if (!${BurnAllNamed}) {
            | For GMail Notify Only
            /if (${GMailEvents.Find[named]} && ${SpawnCount[xtarhater named radius ${MeleeDistance}]}) {
                /call GmailSend "${Spawn[xtarhater named radius ${MeleeDistance}].CleanName} is a NAMED and its in CAMP!"
                /varset NamedCheck 1
            }
        } else {
            | BurnAllNameds is ON, So Do this.
            /if (!${IgnoreTarget}) {
                | Use Target and MyTargetID to ID the Named.
                /if (${BurnAllNamed}==1 && ${Spawn[id ${MyTargetID}].Named}) {
                    /popup *** Mob:(${Target.CleanName}) is a NAMED!
                    /echo *** Mob:(${Target.CleanName}) is a NAMED!
                    /if (${BurnAllNamed}) /call Burn NULL FROMHERE
                    /varset NamedCheck 1
                    /if (${GMailEvents.Find[named]}) /call GmailSend "${Target.CleanName} is a NAMED and its in CAMP!"
                } else {
                    | Setting BurnAllNamed=2 will only burn mobs on the list.
                    /declare i int local
                    /varset MobsToBurn ${Ini[${InfoFileName},${ZoneName},MobsToBurn]}
                    /if (${MobsToBurn.Find[null]}) {
						POPCALL
						/return
					}
                    /for i 1 to 25
                        /if (${MobsToBurn.Arg[${i},,].Length} && !${MobsToBurn.Find[null]} && ${Spawn[${MobsToBurn.Arg[${i},,]}].ID}==${MyTargetID} && ${Spawn[${MobsToBurn.Arg[${i},,]}].CleanName.Equal[${Target.CleanName}]}) {
                            /call Burn NULL FROMHERE
                            /popup *** Mob:(${Target.CleanName}) is a NAMED!
                            /echo *** Mob:(${Target.CleanName}) is a NAMED!
                            /if (${GMailEvents.Find[named]}) /call GmailSend "${Target.CleanName} is a NAMED and its in CAMP!"
                            /varset NamedCheck 1
                            /break
                        }
                    /next i
                }
            } else {
                | BurnAllNameds is ON, but I am NON-Melee, So Using SpawnCount and Spawn info to determine if Named.
                /if (${BurnAllNamed}==1 && ${SpawnCount[xtarhater named radius ${MeleeDistance}]}) {
                    /popup *** Mob:(${Spawn[xtarhater named radius ${MeleeDistance}].CleanName}) is a NAMED!
                    /echo *** Mob:(${Spawn[xtarhater named radius ${MeleeDistance}].CleanName}) is a NAMED!
                    /varset MyTargetID ${Spawn[xtarhater named radius ${MeleeDistance}].ID}
                    /varset MyTargetName ${Spawn[id ${MyTargetID}].CleanName}
                    /call Burn NULL FROMHERE
                    /varset NamedCheck 1
                    /varset MyTargetID 0
                    /if (${GMailEvents.Find[named]}) /call GmailSend "${Spawn[xtarhater named radius ${MeleeDistance}].CleanName} is a NAMED and its in CAMP!"
                } else {
                    | Setting BurnAllNamed=2 will only burn mobs on the list.
                    /declare i int local
                    /varset MobsToBurn ${Ini[${InfoFileName},${ZoneName},MobsToBurn]}
                    /if (${MobsToBurn.Find[null]}) {
						POPCALL
						/return
					}
                    /for i 1 to 25
                        /if (${MobsToBurn.Arg[${i},,].Length} && ${Spawn[${MobsToBurn.Arg[${i},,]}].ID}==${Spawn[xtarhater named radius ${MeleeDistance}].ID} && ${Spawn[${MobsToBurn.Arg[${i},,]}].CleanName.Equal[${Spawn[xtarhater named radius ${MeleeDistance}].CleanName}]}) {
                            /varset MyTargetID ${Spawn[xtarhater named radius ${MeleeDistance}].ID}
                            /varset MyTargetName ${Spawn[id ${MyTargetID}].CleanName}
                            /call Burn NULL FROMHERE
                            /popup *** Mob:(${Spawn[xtarhater named radius ${MeleeDistance}].CleanName}) is a NAMED!
                            /echo *** Mob:(${Spawn[xtarhater named radius ${MeleeDistance}].CleanName}) is a NAMED!
                            /if (${GMailEvents.Find[named]}) /call GmailSend "${Spawn[xtarhater named radius ${MeleeDistance}].CleanName} is a NAMED and its in CAMP!"
                            /varset NamedCheck 1
                            /varset MyTargetID 0
                            /break
                        } else /if (${MobsToBurn.Arg[${i},,].Length}==0 || ${MobsToBurn.Arg[${i},,].Equal[null]}) {
                            /break
                        }
                    /next i
                }
            }
        }
		POPCALL
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Validate Target Combined Spawn and Target
| -------------------------------------------------------------------------------------
    Sub ValidateTarget(int SpawnID, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT ValidateTarget Enter from ${FromWhere} Target Name:${Target.CleanName} ID:${Target.ID} Spawn Name: ${Spawn[id ${SpawnID}].CleanName} ID:${SpawnID}
        /declare j int local
        /declare PullValid int local 0
        /declare MobID int local 0
        /declare MobName string local
        /declare MobType string local
        /declare MeleeDistanceCheck int local ${MeleeDistance}
        /varset ValidTarget 0
		/declare NearestPCID int local 0
		
        /if (${SpawnID}) {
			DEBUGCOMBAT SpawnID provided: ${SpawnID}
           /varset MobID ${Spawn[id ${SpawnID}].ID}
           /varset MobName ${Spawn[id ${SpawnID}].CleanName}
           /varset MobType ${Spawn[id ${SpawnID}].Type}
        } else {
			DEBUGCOMBAT Spawn ID was not provided. Using Target ${Target.ID}
           /varset MobID ${Target.ID}
           /varset MobName ${Target.CleanName}
           /varset MobType ${Target.Type}
        }

        /if (!${MobID}) {
			POPCALL
			/return NoTarget
		}
				
        DEBUGCOMBAT ValidateTarget Validate 1
		/if (${Select[${MobType},AURA,BANNER,CAMPFIRE,CORPSE,CHEST,ITEM,TRIGGER,TRAP,TIMER,MOUNT,Mercenary]}) {
			POPCALL
			/return BadTargetType
		}

		|
		| Adding friendly check. Some checks, below, are no longer necessary. Leaving for now.
		|
		/call IsFriendly ${MobID} FROMHERE
		DEBUGCOMBAT ValidateTarget Target is ${Macro.Return} - It is not in the group.
		/if (${Macro.Return.NotEqual[MAY-BE-HOSTILE]}) {
			POPCALL
			/return GroupMemberOrDead
		}		
        
        DEBUGCOMBAT ValidateTarget Validate 2
        | If mob found on ignore and not on xtarget skip
        /if (${MobsToIgnore.Find[${MobName}]} && ${Select[${MobID},${Me.XTarget[1].ID},${Me.XTarget[2].ID},${Me.XTarget[3].ID},${Me.XTarget[4].ID},${Me.XTarget[5].ID},${Me.XTarget[6].ID},${Me.XTarget[7].ID},${Me.XTarget[8].ID},${Me.XTarget[9].ID},${Me.XTarget[10].ID},${Me.XTarget[11].ID},${Me.XTarget[12].ID},${Me.XTarget[13].ID}]}==0) {
			POPCALL
			/return MobOnIgnoreList
		}
        /if (${MobsToIgnoreByID.Find[${MobID}|]}) {
			POPCALL
			/return MobOnIgnoreListByID
		}
        | Check if target is somewhere on my extended target.
		| We want to be able to engage mobs as puller, even if we tank. Overriding.
        /if (!${PullManual} && ${Select[${Role},tank,pettank]} && ${MobCount}<=${XSlotTotal} && ${Spawn[${MainAssist} ${MainAssistType} group].ID}) {
			/if (${SpawnCount[id ${MobID} xtarhater]}==0) {
				POPCALL
				/return NotOnXTarget
			}
        }
        /if (${Spawn[id ${MobID}].MaxRangeTo}>${MeleeDistance}) /varcalc MeleeDistanceCheck ${Spawn[id ${MobID}].MaxRangeTo}+5
        /if (${ReturnToCamp} && ${Math.Distance[${Spawn[id ${MobID}].Y},${Spawn[id ${MobID}].X}:${CampYLoc},${CampXLoc}]}>${MeleeDistanceCheck} && !${Pulling} && (${Select[${Role},tank,pullertank,pettank,pullerpettank]} && !${PullManual})) {
			POPCALL
			/return OutofCampRadius
		}
        DEBUGCOMBAT ValidateTarget Validate 3
        /if (${MobName.Find[eye of]} && ${SpawnCount[pc ${MobName.Right[${Math.Calc[${MobName.Length}-7]}]}]}) {
			POPCALL
			/return Spell-Eye-PC
		}
        /if (${MobType.Equal[Pet]} && ${Spawn[id ${MobID}].Master.Type.Equal[PC]}) {
			POPCALL
			/return PET-PC
		}
        /if (${Target.ID}==${MobID} && ${Target.Charmed.ID}) {
			POPCALL
			/return Target-Charmed
		}
        /if (!${Select[${EverQuest.Server},zek]} && ${Select[${MobType},PC]}) {
			POPCALL
			/return PC
		}
        | This prevents characters on the Zek server from attacking PC targets in their group
        /if (${Select[${EverQuest.Server},zek]} && ${Select[${MobType},PC]}) {
            /if (${Spawn[id ${MobID} group].ID}>0) {
				POPCALL
				/return GroupMember
			}
            /if (${MobID}==${Spawn[=${MainAssist}].ID}) {
				POPCALL
				/return MA
			}
        }
        DEBUGCOMBAT ValidateTarget Validate 4
        | Only valid when pulling
        /if (${Pulling} && !${Pulled}) {
			| PullIgnore1 is the devil.
            |/if (${PullIgnore1.Find[${MobID}|]}) /return MobOnPullIgnoreListByPull
            /if (${Select[${PullMoveUse},los,nav]}>0) {
                /if (${Math.Distance[${Spawn[id ${MobID}].Y},${Spawn[id ${MobID}].X}:${CampYLoc},${CampXLoc}]}>${MaxRadius} && ${Spawn[id ${MobID}].Distance3D}>${PullRange}) {
					POPCALL
					/return OutofRadius
				}
				DEBUGCOMBAT Not OutOfRadius
                /if (${PullMoveUse.Equal[los]} && (${Select[${Role},puller,pullertank,pullerpettank]} || ${PullManual}) && !${Spawn[id ${MobID}].LineOfSight}) {
					POPCALL
					/return NoLOS
				}
				DEBUGCOMBAT We aren't pulling with LOS or don't have the right setup for LOS
            }
            /if (${SpawnCount[loc ${Spawn[id ${MobID}].X} ${Spawn[id ${MobID}].Y} radius 30 pc]}>0 && ${Math.Distance[${Spawn[id ${MobID}].Y},${Spawn[id ${MobID}].X}:${Me.Y},${Me.X}]}>30) {
				/varset NearestPCID ${NearestSpawn[1, loc ${Spawn[id ${MobID}].X} ${Spawn[id ${MobID}].Y} radius 30 pc].ID}
				DEBUGCOMBAT PC Near the mob 1: ID ${NearestPCID} Name: ${Spawn[id ${NearestPCID}].CleanName} Distance: ${Spawn[id ${NearestPCID}].Distance}
				/call IsFriendly ${NearestPCID} FROMHERE
				/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
					DEBUGCOMBAT PC ID ${NearestPCID} Name: ${Spawn[id ${NearestPCID}].CleanName} - Returning PCNear
					POPCALL
					/return PCNear
				}
				DEBUGCOMBAT PCNear 1 turned out to be the group being close to the mob.
			}
            /if (${SpawnCount[loc ${Spawn[id ${MobID}].X} ${Spawn[id ${MobID}].Y} radius 30 pc]}>1 && ${Math.Distance[${Spawn[id ${MobID}].Y},${Spawn[id ${MobID}].X}:${Me.Y},${Me.X}]}<31) {
				/varset NearestPCID ${NearestSpawn[1, loc ${Spawn[id ${MobID}].X} ${Spawn[id ${MobID}].Y} radius 30 pc].ID}
				DEBUGCOMBAT PC Near the mob 2: ID ${NearestPCID} Name: ${Spawn[id ${NearestPCID}].CleanName} Distance: ${Spawn[id ${NearestPCID}].Distance}
				/call IsFriendly ${NearestPCID} FROMHERE
				/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
					DEBUGCOMBAT PC ID ${NearestPCID} Name: ${Spawn[id ${NearestPCID}].CleanName} - Returning PCNear
					POPCALL
					/return PCNear
				}
				DEBUGCOMBAT PCNear 2 turned out to be the group being close to the mob.
			}
            /if (${Spawn[id ${MobID}].PctHPs}<=99) {
				POPCALL
				/return PullNotFullHealth
			}
			DEBUGCOMBAT Mob is full health
            /if (${Spawn[id ${MobID}].Level}<${PullMin} || ${Spawn[id ${MobID}].Level}>${PullMax}) {
				POPCALL
				/return BadLevel
			}
			DEBUGCOMBAT Mob is right level
			
            /if (${Window[TargetOfTargetWindow].Open} && ${Target.ID}==${MobID}) {
            | - If mob I'm pulling is aggroed already by non damaging spell by someone else.
                /delay 10 ${Target.ID}==${MobID}
                /if (${Me.TargetOfTarget.Type.Equal[PC]} && ${Me.TargetOfTarget.Name.NotEqual[${Me}]} && !${Group.Member[${Me.TargetOfTarget.Name}].Index}) {
					POPCALL
					/return PullToTTNotPuller
				}
                /if (${Me.TargetOfTarget.Type.Equal[PET]}) {
                    /call IsFriendly ${Me.TargetOfTarget.ID} FROMHERE
                    /if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
					    POPCALL
					    /return PullToTTNotMyPet
                    }
				}
                /if (${Me.TargetOfTarget.Type.Equal[mercenary]} && !${Group.Member[${Me.TargetOfTarget.Name}].Index}) {
					POPCALL
					/return PullToTNotMyMerc
				}
            }
			DEBUGCOMBAT Mob is not already aggrod or targetted or whatever that code block does.
			
            /if (${DebugPull} && ${MobsToPull.NotEqual[all]}) /echo ValidateTarget ${MobsToPull}
            /if (${MobsToPull.Equal[all]}) {
                /varset PullValid 1
            } else {
                /for j 1 to 25
                    DEBUGPULL ValidateTarget ${j} ${MobsToPull.Arg[${j},,]} ${MobName.Find[${MobsToPull.Arg[${j},,]}]}
                    /if (${MobName.Find[${MobsToPull.Arg[${j},,]}]}) {
                        /varset PullValid 1
                        /break
                    }
                /next j
            }
            /if (!${PullValid}) {
				POPCALL
				/return PullMobNotonList
			}
        }
        /varset ValidTarget 1
        DEBUGCOMBAT ValidateTarget Leave ValidTarget ${ValidTarget} MobID ${MobID} TargetID ${Target.ID}
		POPCALL
    /return ${ValidTarget}
