	
| ---------------------------------------------------------------------------
| Sub Bind_CallStack
| Helper for debugging. Records current sub so next sub can read it.
| Usage: /callstack
| ---------------------------------------------------------------------------
	Sub Bind_CallStack(string OnOff)
		/if (!${Defined[CallStack]}) {
			/echo No stack to check.
			/return
		}
        /if (!${DisplayStack} && (!${OnOff.Length} || ${Select[${OnOff},1,on]})) {
            /echo \awAKA: \ayEnabling callstack display
            /varset DisplayStack 1
        }
        /if (${DisplayStack} && ${Select[${OnOff},0,off]}) {
            /echo aw\AKA: \ayDisabling callstack display
            /return
        }
		/echo CallStack size ${CallStackIndex}.
		/declare i int local 0
		/for i 1 to ${CallStackIndex}
			/echo ${i} ${CallStack[${i},1]}
		/next i
	/return

|-----------------------------------------------------------------------------
| SUB: Debug 
| ----------------------------------------------------------------------------
    Sub Bind_Debug(string p_cmd1, string p_cmd2, string p_cmd3)
        /declare str_onoff string local
        /declare str_command string local
        /declare str_uselog string local
        /if (${EverQuest.CurrentUI.NotEqual[Default]}) {
            /echo You are using a Custom UI. Please switch to Default UI before Posting.
        }
        | Check param 3
        /if (${Select[${p_cmd3},log,logc]}) {
            /varset str_uselog ${Select[${p_cmd3},log,logc]}
        } else {
            /varset str_uselog 0
        }
        | Check Param 2
        /if (${Select[${p_cmd2},0,1,on,off]}) {
            /varset str_command ${p_cmd1}
            /varset str_onoff ${p_cmd2}
            /if (${p_cmd2.Equal[on]}) {
                /varset str_onoff 1
            } else {
                /varset str_onoff 0
            }
        } else /if (${Select[${p_cmd2},log,logc]}) {
            /varset str_uselog ${Select[${p_cmd2},log,logc]}
            /varset str_onoff
        } else {
            /varset str_onoff
        }
        | Check Param 1
        /if (${Select[${p_cmd1},0,1,on,off]}) {
            /varset str_command Debug
            /varset str_onoff ${p_cmd1}
            /if (${p_cmd1.Equal[on]}) {
                /varset str_onoff 1
            } else {
                /varset str_onoff 0
            }
            /if (!${str_onoff} && ${DebugAllOn}) /varset str_command all
        } else /if (${p_cmd1.Equal[all]}) {
            /varset str_command ${p_cmd1}
		|
		| Added Give, Pet, Singleheal, and Groupheal. Heals just spammed way too much to be useful. Added Main
		|
		| All Debug vars must have *only* the first letter capitalized. E.g. HealSingle won't be found but Healsingle will.
		|
        } else /if (${Select[${p_cmd1},Buffs,Combat,Cast,Chainp,Cures,Give,Heals,Healsingle,Healgroup,Main,Med,Mez,Move,Pet,Petcombat,Pull,Rez,Rk,TARGET]}) {
            /varset p_cmd1 ${p_cmd1.Left[1].Upper}${p_cmd1.Right[-1].Lower}
            /if (${Select[${p_cmd1.Right[1]},p,k]}) /varset p_cmd1 ${p_cmd1.Left[-1]}${p_cmd1.Right[1].Upper}
            /varset str_command Debug${p_cmd1}
        } else /if (!${p_cmd1.Length}) {
            /if (${DebugAllOn}) {
                /varset str_command all
            } else {
                /varset str_command Debug
            }
        } else {
            /varset str_command Help
            /varset str_onoff
        }
        
        /if (${str_command.Equal[help]}) {
            /echo --------------------------------------------------------------------------------------------
            /echo \ayDebug help: 
            /echo \ay    /debug command action1 action2
            /echo \ay        command: \aohelp/all/Buffs/Combat/Cast/Chainp/Cures/Give/Heals/Healsingle/Healgroup
			/echo \ay                 \aoMain/Med/Mez/Move/Pet/Petcombat/Pull/Rk/Target
            /echo \ay        action1: \aoon/off/0/1 or blank 
            /echo \ay        action2: \aolog or blank
            /echo \ag    Examples:
            /echo \at        /debug all on -----> Turns on debug all.
            /echo \at        /debug all off ----> Turns off debug all. 
            /echo \at        /debug all --------> Taggles on/off debug all.
            /echo \at        /debug all log ----> Toggles on/off debug all and starts/stops logging.
            /echo \at        /debug on ---------> Turns on debug only.
            /echo \at        /debug off --------> Turns off debug only.
            /echo \at        /debug ------------> Toggles on/off debug only.
            /echo \at        /debug combat on --> Turns on combat debug only.
            /echo \at        /debug combat off -> Turns off combat debug only.
            /echo \at        /debug combat -----> Taggles on/off combat debug only
            /echo \at        
            /echo \at        /debug log - Is an invalid format and shouldn't be used. 
            /echo 
            /echo \ay        log - can be used as either action1 or action2, but never as command.
            /echo \ay              you do NOT have to sepcify the log action to turn logging off.
            /echo \ay              any action that turns off any debug command will stop logging.
            /echo
            /echo \ay    Note: MQ2Log plugin will be loaded using the noauto option if the plugin is not loaded. 
            /echo ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            /return
        } else /if (${str_command.Equal[debug]}) {
            /if (!${str_onoff.Length}) {
                /if (${Debug}) {
                    /varset str_onoff 0
                } else {
                    /varset str_onoff 1
                }
            }
            /varset Debug ${str_onoff}
            /if (${Debug}) {
                /echo \atDEBUG On
            } else {
                /echo \atDEBUG Off
            }
        } else /if (${str_command.Equal[all]}) {
            /if (!${str_onoff.Length}) {
                /if (${DebugAllOn}) {
                    /varset str_onoff 0
                } else {
                    /varset str_onoff 1
                }
            }
            /varset DebugAllOn ${str_onoff}
            /if (${DebugAllOn}) {
                /echo \atDebugAll On
            } else {
                /echo \atDebugAll Off
            }
            /varset Debug ${DebugAllOn}
            /varset DebugBuffs ${DebugAllOn}
            /varset DebugCast ${DebugAllOn}
			/varset DebugChainp ${DebugAllOn}
            /varset DebugCombat ${DebugAllOn}
			/varset DebugCures ${DebugAllOn}
			/varset DebugGive ${DebugAllOn}
            /varset DebugHeals ${DebugAllOn}
			/varset DebugHealsingle ${DebugAllOn}
			/varset DebugHealgroup ${DebugAllOn}
			/varset DebugMain ${DebugAllOn}
			/varset DebugMed ${DebugAllOn}
            /varset DebugMez ${DebugAllOn}
            /varset DebugMove ${DebugAllOn}
            /varset DebugPet  ${DebugAllOn}
			/varset DebugPetcombat ${DebugAllOn}
            /varset DebugPull ${DebugAllOn}
			/varset DebugRez ${DebugAllOn}
			/varset DebugRk ${DebugAllOn}
			/varset DebugTarget ${DebugAllOn}
        } else /if (${Defined[${str_command}]}) {
            /if (!${str_onoff.Length}) {
                | Double brackets it is on purpose.
                /if (${${str_command}}) {
                    /varset str_onoff 0
                } else {
                    /varset str_onoff 1
                }
            }
            /varset ${str_command} ${str_onoff}
            /if (${${str_command}}) {
                /echo \at${str_command} On
            } else {
                /echo \at${str_command} Off
            }
        } else {
            /echo Invalid Command. Try /debug help.
            /return
        }
        /if (${str_uselog}) {
            /if (!${Bool[${Plugin[mq2log]}]}) {
                /plugin MQ2Log noauto 
                /delay 20 ${Bool[${Plugin[mq2log]}]}==True
            }
            /if (!${DebugLogging}) {
                /if (${str_onoff.Equal[1]}) {
                    /if (${str_uselog.Equal[2]}) /mqlogcustom ${EverQuest.Server}_${Me.CleanName} clear
                    /mlog on
                    /varset DebugLogging 1
                    /echo Using UI: ${EverQuest.CurrentUI}
                    /echo KissAssist Info: ${MacroName} ${MacroVer}-${KissRevision}
                    /plugin list
                }
            } else {
                /if (${str_onoff.Equal[0]}) {
                    /echo KissAssist Debug Off Marker!
                }
            }
        } else {
            /if (${DebugLogging}) {
                /if (${str_onoff.Equal[0]}) {
                    /echo KissAssist Debug Off Marker!
                }
            }
        }
    /return	

| -------------------------------------------------------------------------------------
| SUB: Event Mlog Off
| -------------------------------------------------------------------------------------
    Sub Event_MLogOff
        /varset EventFlag 1
        /if (${DebugLogging}) {
            /mlog off
            /varset DebugLogging 0
        }
    /return    

| ---------------------------------------------------------------------------
| Sub GetCall
| Helper for debugging. Retrieves the top call from the stack (will be previous sub)
| ---------------------------------------------------------------------------
	Sub GetCall
	/return ${CallStack[${CallStackIndex},1]}
	
| ---------------------------------------------------------------------------
| Sub PopCallStack
| Helper for debugging. Removes the sub from the stack.
| Usage: /call PopCallStack
| ---------------------------------------------------------------------------
	Sub PopCallStack(int CallIndex)
		/while (${CallIndex}>${CallStackIndex}) {
			/varset CallStack[${CallStackIndex},1] NULL
			/varcalc CallStackIndex ${CallStackIndex}-1
		}
	/return

| ---------------------------------------------------------------------------
| Sub PushCallStack
| Helper for debugging. Records current sub so next sub can read it.
| Usage: /call PushCallStack CURRENTSUB
| ---------------------------------------------------------------------------
	Sub OrigPushCallStack(string SubName)
		/if (${CallStackIndex}==100) {
			/echo CallStack ${SubName} exceeds max stack size 100. Dumping stack and quitting.
			/for iCall 1 to 100
				/echo ${iCall} ${CallStack[${iCall},1]}
			/next iCall
			/endmacro
		}
		/varcalc CallStackIndex ${CallStackIndex}+1
		/varset CallStack[${CallStackIndex},1] ${SubName}
	/return


| ---------------------------------------------------------------------------
| Sub PushCallStack
| Helper for debugging. Records current sub so next sub can read it.
| Usage: /call PushCallStack CURRENTSUB
| ---------------------------------------------------------------------------
	Sub PushCallStack(string SubName)
        | These have to be defined here because of the boot order
        /if (!${Defined[CallCircular]}) {
            /declare CallCircular           int         outer       0
            /declare CallStack[100,1]	    string	    outer	    null
            /declare CallStackIndex		    int		    outer	    0
            /declare iCall                  int         outer       0
            /declare DisplayStack           int         outer       0
        }
		/if (${CallStackIndex}==100) {
			/echo CallStack ${SubName} exceeds max stack size 100. Dumping stack and quitting.
			/for iCall 1 to 100
				/echo ${iCall} ${CallStack[${iCall},1]}
			/next iCall
			/endmacro
		}
        /varset CallCircular 0
        /for iCall ${CallStackIndex} downto 1
            /if (${CallStack[${iCall},1].Equal[${SubName}]}) {
                /varset CallCircular 1
                /if (${DisplayStack}) {
                    /echo \ayDEBUG: Circular call detected: \ar${SubName}
                    /call Bind_CallStack
                    /delay 1s
                }
            }
        /next iCall
		/varcalc CallStackIndex ${CallStackIndex}+1
		/varset CallStack[${CallStackIndex},1] ${SubName}
	/return
