
| -------------------------------------------------------------------------------------
| SUB: Assign Group Role
| -------------------------------------------------------------------------------------
    Sub AssignGroupRole(ASGOnOff, AGRName, AGRRole)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN AssignGroupRole ${ASGOnOff} ${AGRName} ${AGRRole}
        /docommand /grouproles ${ASGOnOff} ${AGRName} ${AGRRole}
        /delay 10
    /return

|-----------------------------------------------------------------------------
| SUB: AssignLooter
| ----------------------------------------------------------------------------
    Sub AssignLooter
        /if (${Select[${Me},${Group.Leader}]}==0) /return
        /if (${LooterAssigned}) /return
        /if (${Group}<=0 || ${Raid.Members}>0) /return
        /if (${Group.MasterLooter.ID}>=1) /return
        DEBUGN Sub AssignLooter Enter
        /declare k int local
        /declare IniIDList string local
        /declare IniIDCount int local
        /declare IniID int local
        /declare AmIML string local
        /if (!${DanNetOn}) {
            /varset IniIDList ${Ini["${KABuffsIni}"]}
            /varcalc IniIDCount ${IniIDList.Count[|]}
        } else {
            /varset IniIDList ${DanNet.Peers[${dgtell}]}
            /varset IniIDCount ${IniIDList.Count[|]}
        }
        /if (!${IniIDCount}) /return
        /declare pIDList[${IniIDCount}] string local 
        /for k 1 to ${IniIDCount}
            /varset pIDList[${k}] ${IniIDList.Arg[${k},|]}
        /next k
        | If I am group leader set Main Looter Tag for Group
        /if (${Select[${Me},${Group.Leader}]}) {
            DEBUGN AssignLooter: /echo I am group Leader
            |Assign myself as MainLooter if LootOn=1
            /if (${LootOn}) {
                DEBUGN AssignLooter: /echo I am the looter
                /if (${Group.MasterLooter.Name.NotEqual[${Me}]} && ${Group.MasterLooter.Name.Length}) {
                    /call AssignGroupRole unset "${Group.MasterLooter.Name}" 5
                    /delay 30 !${Group.MasterLooter.Name.Length}
                    /call AssignGroupRole set "${Group.MainAssist.Name}" 5
                    /call BroadCast r "Assigning ${Me} as Master Looter in Group Window"
                    /varset LooterAssigned 1
                    /return
                }
            } else {
                DEBUGN AssignLooter: Looking for looter
                /for k 1 to ${IniIDCount}
                    /if (!${DanNetOn}) {
                        /varset IniID ${pIDList[${k}]}
                        /varset AmIML ${Ini["${KABuffsIni}",${IniIDList.Arg[${k},|]},"AmILooting"]}
                    } else {
                        /varset IniID ${Int[${Spawn[=${pIDList[${k}]}].ID}]}
                        /if (!${IniID} || ${IniID}==${Me.ID} || !${Spawn[id ${IniID} pc group].ID}) /continue
                        /dquery ${pIDList[${k}]} -q "LootOn" -o DNout -t ${DanNetDelay}
                        /if (${Int[DNout]}==0) /continue
                        /varset AmIML ${DNout}
                    }
                    DEBUGN AssignLooter: ${Spawn[${IniIDList.Arg[${k},|]}].ID} ${IniID} ${AmIML} ${Spawn[${IniIDList.Arg[${k},|]}].Type.NotEqual[pc]} ${Spawn[id ${IniIDList.Arg[${k},|]} group].ID}
                    | If toon is not the zone or not a PC skip to next ID
                    /if (!${Spawn[id ${IniID}].ID} || ${Spawn[id ${IniID}].Type.NotEqual[pc]} || !${AmIML}) /continue
                    /if (${Spawn[id ${IniID} pc group].ID}) {
                        | If Looter is someone else than who its suppose to be unset Group tag
                        /if (${Group.MasterLooter.Name.Length} && ${Group.MasterLooter.Name.NotEqual[${Spawn[id ${IniID} group pc].CleanName}]}) /call AssignGroupRole unset "${Group.MasterLooter.Name}" 5
                        /delay 30 !${Group.MasterLooter.Name.Length}
                        /call AssignGroupRole set "${Spawn[id ${IniID} group pc].CleanName}" 5
                        /call BroadCast r "LOOT: Assigning ${Spawn[id ${IniID} group pc].CleanName} as Master Looter in Group Window"
                        /varset LooterAssigned 1
                        /return
                    }
                /next k
            }
        }
        DEBUGN Sub AssignLooter Leave
    /return

| -------------------------------------------------------------------------------------
| Sub Assign Main Assist
| -------------------------------------------------------------------------------------
    Sub AssignMainAssist(string AssignTarget, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN AssignMainAssist Enter from ${FromWhere} - ${Role}
		
		| The purpose of MainAssistTank is to discern whether the PET or PC is the tank.
		/varset MainAssistTank pc
		
        |/echo My Assigned Role Is: ${Role}
		
        /if (${AssignTarget.Length} && ${AssignTarget.NotEqual[NULL]}) {
            /if (${Select[${Role},pettank,pullerpettank,hunterpettank,tank,pullertank,hunter]}) {
                /call TargetThis ${Me.ID}
				/varset IAmMA 1
				/if (!${BootCompleted}) {
					/varset IBeganAsMA 1
					/varset OriginalMA ${Me}
				} else {
					| If we booted up without an MA, we are now assigning one for recovery purposes.
					/if (!${OriginalMA.Length} || ${OriginalMA.Equal[Null]}) {
						/varset OriginalMA ${Me}
						/varset IBeganAsMA 1
					}
				}
            } else /if (${Select[${Role},assist,offtank,petofftank,petassist,puller]}) {
                /if (!${MainAssist.Length} || ${MainAssist.Equal[null]}) {
                    /if (${Target.ID}) {
                        /if (${Target.ID}==${Me.ID}) {
                            /echo \awAKA: \arInvalid Role(${Role}) for you to be the MA. SwitchMA or restart the macro to fix. Proceeding anyway in case MA went LD.
                            /beep
                            /varset IAmMA 0
                        } else /if (!${Select[${Target.Type},Mercenary,PC,Pet]}) {
                            /echo \awAKA: \arERROR: You have >> ${Target.CleanName} << targeted. Please target a Mercenary, PC or Pet for Main Tank and restart the macro.
                            /beep
                            /endmacro
                        }
                    } else {
                        /echo \awAKA: \ayNo MainAssist target. Proceeding anyway in case MA went LD. SwitchMA when there is one.
						/beep
						/varset IAmMA 0
                    }
                } else {
                    /if (${Spawn[pc ${MainAssist}].ID}) {
                        /tar pc ${MainAssist}
                        /delay 10 ${Target.ID}==${Spawn[=${MainAssist} pc].ID}
						/if (!${BootCompleted}) /varset OriginalMA ${MainAssist}
                    } else {
                        /echo \awAKA: \ayMainAssist ${MainAssist} is nowhere to be found. Proceeding anyway. SwitchMA when there is one.
						/beep
						/varset IAmMA 0
                    }
                }
            } else /if (${Role.NotEqual[manual]}) {
                /echo \awAKA: \arInvalid Role: ${Role} Ending Macro.
                /beep
                /endmacro
            }
        }
		
        /varset MainAssist ${Target.CleanName}
        /varset MainAssistType ${Target.Type}
        /varset MainAssistClass ${Target.Class.ShortName}
		
		/if (${IAmMA} && ${Select[${Role},pettank,petofftank,pullerpettank,hunterpettank]}) /varset MainAssistTank pet
		/if (!${IAmMA} && ${Select[${MainAssistClass},PET_CLASSES_SHORTNAME]} && !${Select[${MainAssistClass},DRU,SHD]}) /varset MainAssistTank pet
		POPCALL
        DEBUGN AssignMainAssist Leave
    /return

| ---------------------------------------------------------------------------
| Sub Bind_AllSit
| ---------------------------------------------------------------------------
	Sub Bind_AllSit(string SitFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/if (!${SitFlag.Length} || ${SitFlag.Equal[NULL]}) {
			/bca //allsit 1
		}
		/if (!${Me.Sitting}) /sit
		/call GroupWatch 1 FROMHERE
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: Bind SwitchMA
|
| Logic - If the MA dies, characters that are eligible to become MA announce
| they are MA. Params require their name and role, as well as announce flag.
| The command can be invoked manually, or quietly, to change ones own role.
| This needs to be broken into two parts. One involves assigning MA, the other
| is role switching. Also involved is the role of puller. The naming system
| munges all of this together. E.g.
|
| Pullerpettank decoded means 1) I am the MA, 2) I am the Puller, 3) My pet will tank
| if the MA dies (in this case, pullerpettank), then the puller also has died as
| well as the tank.
|
| Once rezzed, the MA needs to become pullerpettank again,
| and whoever became MA, or whoever changed roles, need to revert to their previous role.
| ----------------------------------------------------------------------------
    Sub Bind_SwitchMA(string newMA, string newRole, string DoWhatFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/if ((!${newMA.Length} || ${newMA.Equal[null]} || !${Spawn[=${newMA}].ID} || ${Spawn[=${newMA}].Type.Equal[corpse]}) && (!${Select[${newRole},VALID_ROLES]})) {
            /echo \awAKA: \ayUsage: /switchma newma mynewrole (optional: 0=quiet / 1=announce group, 2=announce all)
			POPCALL
			/return
		}

		/if (!${newMA.Length} || ${newMA.Equal[null]} || !${Spawn[=${newMA}].ID} || ${Spawn[=${newMA}].Type.Equal[corpse]}) {
            /echo \awAKA: \ayCould not find new MA or they are dead.
			POPCALL
			/return
		}
        /if (!${Select[${newRole},VALID_ROLES]}) {
            /echo \awAKA: \ayPlease specify a new role: VALID_ROLES
            POPCALL
            /return
        }

		|
		| Changed DoWhatFlag to string so we can tell if it's empty. Tightening it up a smidgen.
		|
        /declare WasAttacking 	int 	local 	${Attacking}
		/declare RoleChange		int		local	0
        /declare BCFlag         string  local
        /declare DNFlag         string  local
		
		/if (${newMA.Equal[${Me}]} && ${newRole.NotEqual[${Role}]} && !${DoWhatFlag.Length}) {
			/varset RoleChange 1
			/varset DoWhatFlag 0
		}
		
		/if (!${RoleChange}) {
			
			/varset IWasMA ${IAmMA}
			|
			| Only the one calling for switch announces. If its null, quiet, or 0 then no spam.
			|
			/if (${Select[${DoWhatFlag},1,group]}) {
				/varset DoWhatFlag 1
                /varset BCFlag bcg
                /varset DNFlag dgge
			} else /if (${Select[${DoWhatFlag},2,all]}) {
                /varset DoWhatFlag 2
                /varset BCFlag bca
                /varset DNFlag dgex
            } else {
				/varset DoWhatFlag 0
			}
				
			/if (${DoWhatFlag}) {
				/if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
					/docommand /${BCFlag} //switchma ${newMA} ${newRole} 0
				} else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
					/docommand /${DNFlag} /switchma ${newMA} ${newRole} 0
				} else {
					/echo SwitchMA Command requires MQ2EQBC or DanNet Plugin to be loaded.
				}
			}
					
			/varset MainAssistTank pc
			/varset IAmMA 0
			
			| I've been assigned MA
			/if (${newMA.Equal[${Me}]} || ${newMA.Equal[${Pet.CleanName}]}) {
				/varset newMA ${Me}
				/varset IAmMA 1
			}
			/varset MainAssist ${newMA}
			/varset MainAssistType ${Spawn[=${newMA}].Type}
			/varset MainAssistClass ${Spawn[=${newMA}].Class.ShortName}
			
			/if (${Select[${MainAssistClass},PET_CLASSES_SHORTNAME]} && !${Select[${MainAssistClass},SHD,DRU]}) {
				/if (!${Select[${newRole},PET_TANK_ROLES]}) {
					/varset newRole pettank
				}
				/varset MainAssistTank pet
			}	
			
			/echo The Main Assist is ${newMA}
			
			| I've been made the MA.
			/if (${IAmMA} && !${IBeganAsMA}) {
				/varset Role ${newRole}
			}		
			
			| I'm not the MA and didn't begin as one. Im returning to my original role if it changed.
			/if (!${IAmMA} && ${IWasMA} && !${IBeganAsMA}) {
				/varset Role ${MyOriginalRole}
			}

			| Im the MA ... again.
			/if (${IAmMA} && !${IWasMA} && ${IBeganAsMA}) {
				/varset Role ${MyOriginalRole}
			}
			
			| Alter my role since there is a new MA for now. Dont know what to do about hunter.
			/if (!${IAmMA} && ${IBeganAsMA}) {
				/if (${Role.Equal[Tank]}) /varset Role Offtank
				/if (${Role.Equal[PullerTank]}) /varset Role Offtank
				/if (${Role.Equal[PetTank]}) /varset Role PetOfftank
				/if (${Role.Equal[PullerPetTank]}) /varset Role PetOfftank
			}
		} else {
			| Changing my role in the group.
			/varset Role ${newRole}
			/varset MyOriginalRole ${Role}
		}
		|
		| Done: Need to remove the hardcoded IAmMA from checkroles or control so it only happens on startup or a call to sub AssignMainAssist
		|
		/call CheckRoles 0 FROMHERE
		
		/echo My role is ${Role}
		
        | This causes circular calls. It will shake itself out within Combat.
        |/call CombatReset 0 FROMHERE
        |/if (!${IAmMA}) {
        |    /call Assist FROMHERE
        |} else {
        |    /call GetCombatTarget FROMHERE
        |}

        /if (${WasAttacking} && ${Target.ID}) {
            /squelch /attack on
            /varset Attacking 1
        }
		POPCALL
    /return

| -------------------------------------------------------------------------------------------------
| SUB:Bind_SwitchRole
| -------------------------------------------------------------------------------------------------
    Sub Bind_SwitchRole(string NewRole)

        /call Bind_SwitchMA ${Me} ${NewRole}

    /return

| -------------------------------------------------------------------------------------------------
| Sub:CheckMana
| A general function that determines whether med is necessary within the group.
| Other functions do the medding. If Return==1 we med.
| -------------------------------------------------------------------------------------------------
    Sub CheckMana(string FromWhere)

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

		DEBUGMED CheckMana Enter from ${FromWhere}

        /declare i                  int     local   0
        /declare MemberClass        string  local   
        /declare MemberEndurance    string  local   0
        /declare MemberID           int     local   0
        /declare MemberMana         int     local   0
        /declare StatPct            int     local   0
        /declare StartMed           int     local   0
        /declare EndMed             int     local   0

        | Checks mercs too.
        /for i 0 to ${Group.Members}
            /varset MemberID ${Group.Member[${i}].ID}
            /if (!${GroupWatchOn}) {
                /if (${MemberID}!=${Me.ID}) /continue
            }
            /varset MemberClass ${Group.Member[${i}].Class.ShortName}
            /if (${Group.Member[${i}].Name.Equal[${Me}]}) {
                /varset StartMed ${MedStart}
            } else {
                /varset StartMed ${GroupMedStart}
            }
            /varset MemberMana ${Group.Member[${i}].PctMana}
            /varset MemberEndurance ${Group.Member[${i}].PctEndurance}

            /if ((${Select[${MemberClass},BRD,BST,PAL,RNG,SHD]}) && (${MemberMana}<${StartMed} || ${MemberEndurance}<${StartMed})) /return 1
            /if (${Select[${MemberClass},CLR,DRU,ENC,MAG,NEC,SHM,WIZ]} && ${MemberMana}<${StartMed}) /return 1
            /if (${Select[${MemberClass},BER,MNK,ROG,WAR]} && ${MemberEndurance}<${StartMed}) /return 1
            /if (!${IAmMA} && ((${Group.MainAssist.ID} && ${Group.MainAssist.Sitting}) || (!${Group.Member[${MainAssist}].Index} && ${Spawn[PC ${MainAssist}].Sitting}))) /return 1
        /next i

    /return 0

| -------------------------------------------------------------------------------------
| SUB: CheckStats
| -------------------------------------------------------------------------------------
    Sub CheckStats(int statcheck, charname, ckclass, cktype, stat, int pause,int resume, string FromWhere)
        /if (!${statcheck}) /return
        /if (!${Spawn[${ckclass} ${cktype} ${charname}].ID}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGMED CheckStats Enter from ${FromWhere}
        /if (${Spawn[${ckclass} ${cktype} ${charname}].Current${stat}}>${pause}) {
			DEBUGMED CheckStats Stat ok, returning.
			POPCALL
			/return STAT_OK
		}
        DEBUGMED CheckStats statcheck ${statcheck} charname ${charname} ckclass ${ckclass} stat ${stat} pause ${pause} resume ${resume}
        /if (${Role.Equal[puller]} && ${ChainPull} ) {
            /call MobRadar los ${MeleeDistance} FROMHERE
            /if (${MobCount}>0) {
                /varset PullHold 1
				POPCALL
                /return MOBS
            }
        }
        /if (${Select[${Role},PULLER_ROLES]}) {
            /call BroadCast t "Waiting for >> ${charname} << to med up to ${resume}% ${stat}."
        } else {
            /echo  Waiting for >> ${charname} << to med up to ${resume}% ${stat}.
        }
        | target toon to make sure they aren't at full mana due to lag
        /call TargetThis ${Spawn[${ckclass} ${cktype} ${charname}].ID}
        /delay 10
        /varset Pulling 0
        /call DoWeMed 2 ${Target.ID} "${stat}" ${resume} FROMHERE
        /if (${Select[${Role},PULLER_ROLES]}) {
            /call BroadCast t "${charname} is now above ${resume}% ${stat} resuming activity."
        } else {
           /echo ${charname} is now above ${resume}% ${stat} resuming activity.
        }
        |
		| This is annoying if you manually sit down it stands you up.
		|
		|/if (!${Me.Mount.ID} && ${Me.Sitting}) /stand
        /varset Medding 0
        /varset PullHold 0
        /if (${IAmABard} && ${TwistMed}) {
            /call CastBardCheck FROMHERE
        }
        /if (${PullPause.NotEqual[0]}) /varset PullWaitTimer1 ${PullPause.Arg[1,"|"]}m
		POPCALL
        DEBUGMED CheckStats Leave
    /return NEEDED_TO_MED

| -----------------------------------------------------------------------------------
| SUB: DoWeMed
| -----------------------------------------------------------------------------------
	Sub DoWeMed(int p_UseFlag, int p_watchID, string p_stat, int p_resume, string FromWhere)
        /if (!${MedOn}) /return
        /if (!${MedCombat} && ${AggroTargetID}) /return
        /if (${MedCombat} && !${Medding} && ${AggroTargetID}!=0 && ${AggroTargetID}==${MyTargetID}) /return
        /if (!${MedCombat} && ${AggroTargetID}) /return
        /if (${MedCombat} && !${Medding} && ${AggroTargetID}!=0 && ${AggroTargetID}==${MyTargetID}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /if (${CallCircular}) {
            POPCALL
            /return
        }

		DEBUGMED DoWeMed Enter from ${FromWhere}
        /declare Med2On       int    local 0
        /declare MedForceOn   int    local 0
        /declare MedStat1     string local ${MedStat}
        /declare i            int    local 0
        /declare j            int    local 0
        /declare MedFlag      int    local 0
        /declare IAmMedding   int    local 0
        /declare MedSingingID int    local 0
        /declare watchName    string local
        /declare MedCombatCK  int    local ${MedCombat}
		/declare RandTimeAdj  int	 local 0
        /declare AllStanding  int    local 0
        /declare MedSongsOn   int    local 0
        /declare DoINeedTo    int    local 0
		
		/call LastMove
		/varcalc RandTimeAdj ${Math.Calc[7+${Math.Rand[5]}].Int}
		
		DEBUGMED DoWeMed Setting class stat to monitor. ${p_UseFlag} ${p_watchID} ${p_stat} ${p_resume}
        /if (${Select[${Me.Class.ShortName},BST,BRD,CLR,DRU,ENC,MAG,NEC,PAL,RNG,SHM,SHD,WIZ]}) /varset MedStat Mana
        /if (${Select[${Me.Class.ShortName},BER,MNK,ROG,WAR]}) /varset MedStat Endurance
		/if (!${p_stat.Length} || ${p_stat.Equal[null]}) /varset p_stat ${MedStat}
		/if (!${p_resume}) /varset p_resume 100
        /if (!${Me.Moving}) {
            /if (${Select[${Me.Class.ShortName},BRD,BST,PAL,RNG,SHD]} && ${Me.Pct${MedStat2}}<${MedStart} && ${Me.Pct${MedStat}}>${MedStart}) {
                /varset MedStat1 ${MedStat}
                /varset MedStat ${MedStat2}
                /varset Med2On 1
            }
            /if (!${IAmMA} && ((${Group.MainAssist.ID} && ${Group.MainAssist.Sitting}) || ${Spawn[PC ${MainAssist}].Sitting} || (!${Group.Member[${MainAssist}].Index} && ${Spawn[PC ${MainAssist}].Sitting}))) {
                DEBUGMED DoWeMed The MA is sitting, therefore I *have* to sit for awhile.                
                /varset MedForceOn 1
            }
            /if (${Me.Pct${MedStat}}<${MedStart}) {
                /varset DoINeedTo 1
                /varset MedFlag 1
            } else /if (${PullHold}==2 && ${Me.Pct${MedStat}}<98) {
                /varset MedFlag 1
            } else /if (${MedForceOn} && ${Me.Pct${MedStat}}<90 && !${Role.Find[puller]}) {
                /if (${MedCombat}) /varset MedCombatCK 0
                /varset MedFlag 1
            } else /if (${MedForceOn} && ${IAmABard} && ${TwistMed}) {
                /varset MedFlag 1
            } else /if (${p_UseFlag}==1 && ${PullWaitTimer1}) {
                /varset MedFlag 1
            } else /if (${p_UseFlag}==2 && ${p_watchID}) {
                /varset MedFlag 1
                /varset watchName ${Spawn[id ${p_watchID}].CleanName}
            }
			DEBUGMED DoWeMed Are we going to med? ${MedFlag}
            /if (${MedFlag}) {
                /if (${Target.ID}) /call TargetThis
                /varset Medding 1
                /if (${Attacking}) /call CombatReset 0 FROMHERE
                /if (${Medding} && ${Me.Pct${MedStat}}<${MedStop}) /echo Medding until ${MedStat} ${MedStop}% ${Me.Pct${MedStat}} ${MedStart}
                /if (${Me.Pct${MedStat}}<${MedStart}) {
                    /if (!${Select[${Role},PULLER_ROLES]}) {
                        /call BroadCast t "My ${MedStat} is ${Me.Pct${MedStat}}% time to med."
                    } else {
                        /call BroadCast t "Puller needs to rest ${MedStat} is ${Me.Pct${MedStat}}%."
                    }
                }
				DEBUGMED DoWeMed We are medding.
                /while (1) {
                    /call LastMove
					/call ShouldIStand
					/if (${Macro.Return.Equal[1]}) {
						/varset Medding 0
						/break
					}
                    /doevents GotHit
                    /call Triage FROMHERE
					/call DoMiscStuff FROMHERE
                    /doevents
                    /if (${ChaseAssist}) /call DoWeChase
                    /if (${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc}]} > 15) {
                        /call DoWeMove 0 FROMHERE
                    }
                    /if (${MountOn} && !${Me.Mount.ID} && (${Zone.Outdoor} || ${Select[${Zone.Type},1,2,5]})) /call CastMount

                    /while (${IAmABard} && !${MedSongsOn}) {
                        | bards twisting while others fighting negate fast med

                        /call GroupStanding
                        /if (${Macro.Return.Equal[1]} && !${DoINeedTo}) /break

                        | If TwistMed 0, we skip this.
                        /if (${TwistMed}) {
                            | If there are multiple songs, then we stand. If one song, we sit.
                            /if (${Int[${TwistMed.Arg[2,]}]}>0) {
                                /varset MedFlag 2
                            } else /if (${Int[${TwistMed.Arg[1,]}]}>0) {
                                | TwistMed could be 0 5 6 7 8, so check the first arg.
                                /varset MedSingingID ${Me.Gem[${TwistMed.Arg[1,]}].ID}
                            }
                        }
                        |/echo == Clearing twist
                        /call CastBardCheck FROMHERE 0
                        /squelch /twist clear

                        /if (${MedFlag}==1) {
                            /if (${MedSingingID}) {
                                /if (${MedSingingID}!=${Me.Casting.ID} || !${Me.Casting.ID}) {
                                    /echo == Starting med song
                                    /squelch /stopsong
                                    /if (${Me.Sitting}) /stand
                                    /delay 5
                                    /cast ${TwistMed}
                                    /delay 10
                                    /while (${Window[CastingWindow].Open}) {
                                        /delay 5
                                    }
                                    /varset IAmMedding 1
                                    /varset MedSongsOn 1
                                }
                            }
                        } else /if (${MedFlag}==2) {
                            | Its possible someone sat the bard down on purpose. Let it happen.
                            /if (!${Twist} || ${Twist.List.Left[-1].NotEqual[${TwistMed}]} && !${Me.Sitting}) {
                                /echo == Starting med twist
                                /call CastBardCheck FROMHERE 0
                                /squelch /twist ${TwistMed}
                                /varset IAmMedding 1
                                /varset MedSongsOn 1
                                /delay 10
                            }
                        }
                        | Else do nothing.
                        /break
                    }

                    DEBUGMED ${MedStat} ${MedStat1} ${MedStat2} ${MedFlag}
                    /delay 10
                    /if (!${MedCombatCK}) {
                        /doevents AttackCalled
                        DEBUGMED MedCombat1 ${CalledTargetID} ${Group.Member[${MainAssist}].Index} ${IAmMA} ${Me.XTarget[${XTSlot}].TargetType}
                        /if (${CalledTargetID} && !${Group.Member[${MainAssist}].Index} && !${IAmMA} && ${Spawn[id ${CalledTargetID}].Type.NotEqual[PC]}) {
                            /call TargetThis ${CalledTargetID}
                            /delay 10
                            /if (${XTarAutoSet}) {
                                /xtarget set ${XTSlot} currenttarget
                                /delay 10
                            }
                            /varset CalledTargetID 0
                        }
                        /call WaitSubs FROMHERE
                        DEBUGMED MedCombat2 ${CalledTargetID} ${Group.Member[${MainAssist}].Index} ${IAmMA} ${Me.XTarget[${XTSlot}].TargetType}
                        /if (${CalledTargetID} && !${Group.Member[${MainAssist}].Index} && !${IAmMA} && ${Spawn[id ${CalledTargetID}].Type.NotEqual[PC]}) {
                            /call TargetThis ${CalledTargetID}
                            /delay 10
                            /if (${XTarAutoSet}) {
                                /xtarget set ${XTSlot} currenttarget
                                /delay 10
                            }
                            /varset CalledTargetID 0
                        }
                        /if (${AggroTargetID} && (${SpawnCount[xtarhater radius 150]} || ${MeleeTwistOn}==2 || ${Int[${Me.XTarget[${XTSlot}].Distance}]}<150)) {
                            /if (!${Me.Mount.ID} && ${Me.Sitting}) {
                                /stand
                            }
                            /varset Medding 0
                            /if (${IAmABard}) {
                                /call CastBardCheck FROMHERE
                                /if (${MeleeTwistOn}==2) /call DoBardStuff FROMHERE
                            }
                            | May need to add check to call DoBardStuff to get meletwist started.
                            /if (${Med2On}) /varset MedStat ${MedStat1}
							POPCALL
                            /return
                        }
					}
                    /if (!${Me.Sitting}) {
                        /call LastMove
                        /varcalc RandTimeAdj ${Math.Calc[7+${Math.Rand[5]}].Int}
					    /if (${TimeSinceMove}>${RandTimeAdj} && !${Me.Mount.ID} && (!${IAmABard} || (${IAmABard} && ${MedFlag}==1)) && ${Me.Pct${MedStat}}<${MedStop}) {
                            DEBUGMED DoWeMed I'm sitting 1
						    /sit
                        }
					}
					DEBUGMED DoWeMed Setting class stat to monitor. p_UseFlag ${p_UseFlag} p_watchID ${p_watchID} p_stat ${p_stat} p_resume ${p_resume} MedForceOn ${MedForceOn}
                    /if (!${p_UseFlag}) {
						DEBUGMED DoWeMed Has the MA stood up, and, am I done medding?
                        /if (${MedForceOn}) {
							/if (!${IAmMA} && ((${Group.MainAssist.ID} && ${Group.MainAssist.Sitting}) || (!${Group.Member[${MainAssist}].Index} && ${Spawn[PC ${MainAssist}].Sitting}))) /varset MedForceOn 0
						}
                        /if (${Me.Pct${MedStat}}>=${MedStop} && !${MedForceOn}) {
							/if (${Me.Sitting}) /stand
							/break
						}
                    } else {
                        /if (${p_UseFlag}==1) {
                            /if (!${PullWaitTimer2}) /break
                        } else /if (${p_UseFlag}==2 && ${p_watchID}) {
                            /if (${Spawn[id ${p_watchID}].ID} && ${Target.ID}!=${p_watchID}) {
                                /call TargetThis ${p_watchID}
                                /delay 20
                            } else /if (!${Spawn[id ${p_watchID}].ID}) {
                                /echo Character ${watchName} Left the zone ... or died. Leaving Med Routine.
								/if (${Me.Sitting}) /stand
                                /break
                            }
                            /if (${Target.Pct${p_stat}}>=${p_resume}) {
								/if (${Me.Sitting}) /stand
								/break
							}
                        }
                    }
					/call CheckBeforeCast DoWeMed FROMHERE
					/if (${BuffsOn}) /call DoWeBuff FROMHERE
					/if (${PetOn}) /call DoPetStuff FROMHERE
                    /if (${PetBuffsOn} && !${CheckPetBuffsTimerOn}) /call CheckPetBuffs FROMHERE
                }
                DEBUGMED DoWeMed Done Medding
                /if (${Med2On}) /varset MedStat ${MedStat1}
                | Keep playing restor / med song if group sitting. Others may be medding still. Also it makes us look like a meerkat.
                /if (${IAmABard} && ${TwistMed} && ${MedSongsOn}) {
                    /if (${AllStanding}) {
                        /echo == Starting normal twist from med
                        /call CastBardCheck FROMHERE
                        /if (${TwistOn}) /squelch /twist ${TwistWhat}
                        /varset MedSongsOn 0
                    }
                }
            } else {
				DEBUGMED DoWeMed I'm not in a formal med state. I'm idle. ${MedStat} Mana: ${Me.PctMana} Endurance: ${Me.PctEndurance} HPs: ${Me.PctHPs}
				|
				| If a char is just idle and not 100% then plunk them down.
				|
                /if (!${Me.Sitting}) {
                    /call LastMove
                    /varcalc RandTimeAdj ${Math.Calc[7+${Math.Rand[5]}].Int}
				    /if (${TimeSinceMove}>${RandTimeAdj} && !${Me.Mount.ID} && (!${IAmABard} || (${IAmABard} && ${MedFlag}==1)) && (${Me.Pct${MedStat}}<90 || ${Me.PctHPs}<90)) {
                        DEBUGMED DoWeMed I'm sitting 2
						/sit
                    }
				} else /if (!${Me.Mount.ID} && ${Me.Pct${MedStat}}==100 && ${Me.PctHPs}==100) {
					|
					| This is annoying. If you manually sit down, it stands up right away.
					|
					|/stand
				}
			}
			DEBUGMED DoWeMed If we were watching someone we are done. ${p_UseFlag} ${p_watchID}
            /varset Medding 0
            | return if using timer or watching another character.
            /if (${p_UseFlag}) {
				POPCALL
				/return
			}
			
			DEBUGMED DoWeMed If I'm a puller, I need to med up.
            /if (${Select[${Role},PULLER_ROLES]} && ${Me.PctHPs}<=50) {
                /echo Resting before resuming pulls.
                /if (${ReturnToCamp} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]} > 15) {
                    /call DoWeMove 0 FROMHERE
                }
                /if (!${Me.Sitting}) {
                    /call LastMove
                    /varcalc RandTimeAdj ${Math.Calc[7+${Math.Rand[5]}].Int}
				    /if (${TimeSinceMove}>${RandTimeAdj} && !${Me.Mount.ID} && (!${IAmABard} || (${IAmABard} && ${MedFlag}==1)) && ${Me.Pct${MedStat}}<${MedStop}) {
                        DEBUGMED DoWeMed I'm sitting 3
					    /sit
                    }
				}
                /varset Medding 1
				DEBUGMED DoWeMed Puller medding.
                /while (1) {
                    /doevents
                    /delay 5
					/call ShouldIStand
					/if (${Macro.Return.Equal[1]}) {
						/varset Medding 0
						/break
					}					
                    /if (!${MedCombatCK}) {
                        /call WaitSubs FROMHERE
                        /if (${AggroTargetID}) {
                            /if (${DPSOn} || ${MeleeOn}) {
                                /call CheckForCombat 0 FROMHERE-3 0
                            } else {
                                /call CheckForCombat 1 FROMHERE-4 0
                            }
                            /varset Medding 0
							POPCALL
                            /return
                        }
                    }
                    /if  (${Me.PctHPs}>=${MedStop}) {
                        /varset Medding 0
                        /break
                    }
                }
				DEBUGMED DoWeMed Puller done medding.
                /if (!${Me.Mount.ID} && ${Me.Sitting}) {
					|
					| This is annoying if you manually sit down, it stands you up right away.
					|
                    |/stand
                }
				DEBUGMED DoWeMed If I use a pet while pulling, heal it up.
				/if (${Select[${Role},pullerpettank,hunterpettank]} && !${Me.Invis}) {
					/call DoPetHealStuff FROMHERE
				}
            }
        }
		POPCALL
        DEBUGMED DoWeMed Leave
		
	/return

| ----------------------------------------------------------------------------
| SUB: Event Joined 20s switch to prevent heals from firing off
| ----------------------------------------------------------------------------
    Sub Event_Joined(string Jmessage,string Joinee)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /varset EventFlag 1
        /echo ${Joinee} has joined the party.
        /varset JoinedParty 200
        /call GroupHasA        
        /delay 3s
        /if (${BuffsOn} && ${BuffOnJoin} && ${Spawn[${Joinee}].Distance}<100) {
            /varset SubParamsCache[1] 1 0
        }
		POPCALL
    /return

| -------------------------------------------------------------------------------------
| SUB: Event LeftGroup
| -------------------------------------------------------------------------------------
    Sub Event_LeftGroup(Line,LGName)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /varset EventFlag 1
		/call GroupHasA
        /if (${GMailEvents.Find[leftgroup]}) /call GmailSend "${LGName} has left the group."
        /doevents flush LeftGroup
		POPCALL
    /return

| -------------------------------------------------------------------------------------------------
| Sub:Event_ManaListener
| -------------------------------------------------------------------------------------------------
    Sub Event_ManaListener(Message,int PctMana)
        /if (!${GroupWatchOn}) /return
        /if (!${Select[${Role},PULLER_ROLES]}) /return
        /if (${Medding}) /return

       /doevents flush ManaListener

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /if (${Math.Abs[${Math.Calc[${PctMana}-${GroupMedStart}]}]}<20) {
            /call Event_PleaseWaitListener NULL 30s
        }

        POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: GroupEscape
| ----------------------------------------------------------------------------
    Sub GroupEscape
        /if (!${GroupEscapeOn}) /return
 
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
 
        DEBUGN GroupEscape Enter
        |- If (in combat) or (Have AgroID) AND (MA is not present) or (a corpse).
        /if ((${Me.CombatState.Equal[COMBAT]} || ${AggroTargetID}) && (!${Spawn[=${MainAssist}].ID} || ${Spawn[=${MainAssist}].Type.Equal[Corpse]})) {
            DEBUGN GroupEscape: CombatState:${Me.CombatState.Equal[COMBAT]} AggroTargetID:${AggroTargetID} MA Dead:!${Spawn[=${MainAssist}].ID}|${Spawn[=${MainAssist}].Type.Equal[Corpse]}
            /echo + The MA is dead and I'm in combat, activating Group Escape!
            /if (${Select[${Me.Class.ShortName},WIZ,DRU]}) {
                |-- Druid AA or Spell group evac casting.
                /if (${Select[${Me.Class.ShortName},DRU]}) {
                    |- Drop Divine Barrier if it is up so we can exodus group!
                    /removebuff "Divine Barrier"
                    /if (${Me.AltAbilityReady[Exodus]}) {
                        /call CastWhat "Exodus" ${Me.ID} GroupEscape 0 0 FROMHERE
                    } else /if (${Me.Book[Succor]}) {
                        /call CastWhat "Succor" ${Me.ID} GroupEscape 0 0 FROMHERE
                    }
                }
                |-- Wizard AA or Spell group evac casting.
                /if (${Select[${Me.Class.ShortName},WIZ]}) {
                    /if (${Me.AltAbilityReady[Exodus]}) {
                        /call CastWhat "Exodus" ${Me.ID} GroupEscape 0 0 FROMHERE
                    } else /if (${Me.Book[Evacuate]}) {
                        /call CastWhat "Evacuate" ${Me.ID} GroupEscape 0 0 FROMHERE
                    }
                }
            }
        }
		POPCALL
        DEBUGN GroupEscape Leave
    /return

| --------------------------------------------------------------------------
| Sub GroupHasA
|
| Sets outer vars to whether a class is present in group.
|
| E.g. ini usage CondX=${GroupHasAMag} might be coupled with a request for
| modrods or pet gear, or a special buff request. If a shaman is present...
| --------------------------------------------------------------------------
	Sub GroupHasA
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		/declare i 			int		local	0
		/declare grpmembers	int		local	${Group.Members}
		
		|
		| Group member 0 is the char itself
		|
		/if (!${grpmembers}) {
			/varcalc GroupHasA${Me.Class.ShortName} ${GroupHasA${Me.Class.ShortName}}+1
		} else {
			/for i 0 to ${grpmembers}
				/varcalc GroupHasA${Group.Member[${i}].Class.ShortName} ${GroupHasA${Group.Member[${i}].Class.ShortName}}+1
			/next i
		}

	/return

| -------------------------------------------------------------------------------------------------
| SUB: GroupStanding
| -------------------------------------------------------------------------------------------------
    Sub GroupStanding

        /declare i int local 0

        /for i 1 to ${Group}
            /if (${Group.Member[${i}].Type.Equal[PC]} && ${Spawn[id ${Group.Member[${i}].ID}].Type.NotEqual[CORPSE]} && ${Group.Member[${i}].Sitting}) /return 0
        /next i

    /return 1

| -------------------------------------------------------------------------------------
| SUB: GroupWatch
| -------------------------------------------------------------------------------------
    Sub GroupWatch(int ForceMed, string FromWhere)
        /if (!${GroupWatchOn} ) /return
        /if (${AggroTargetID} && !${ChainPull}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /if (${CallCircular}) {
            POPCALL
            /return
        }
		
        DEBUGMED GroupWatch Enter from ${FromWhere}
        /declare i              int local
        /declare GrpMemType     string local
        /declare GrpMemName     string local
        /declare GrpMemClass    string local
        /declare GrpMemStat     string local
        /declare GrpWatchCondNo int local
        /declare GrpMedOn       int local
		/declare NeededToMed	int	local	0
		/declare StartMed		int	local ${GroupMedStart}
		/declare StopMed		int	local ${GroupMedStop}
		
        /if (!${Spawn[=${MainAssist}].ID} && !${Select[${Role},tank,pullertank,pettank,pullerpettank,hunter,hunterpettank]} && ${CampZone}==${Zone.ID}) {
            /echo I am not detecting Main Assist.
            /while (1) {
                /doevents
                /if (${DPSOn} || ${MeleeOn}) {
                    /call CheckForCombat 0 FROMHERE-1
                } else {
                    /call CheckForCombat 1 FROMHERE-2
                }
                /call WaitSubs FROMHERE
                /if (${Spawn[=${MainAssist}].ID}) {
                    /echo Main Assist is back resuming action.
                    /break
                }
                /delay 10
            }
        }
		
		DEBUGMED GroupWatch Checking GroupWatchCheck condition
        /if (${GroupWatchCheck.Find[cond]}) {
            /varset GrpWatchCondNo ${GroupWatchCheck.Mid[${Math.Calc[${GroupWatchCheck.Find[cond]}+4]},3]}
        } else {
            /varset GrpWatchCondNo 0
        }
		|/call EstTimeToLive
        /if (${ConOn} && ${GrpWatchCondNo} && ${If[${Cond[${GrpWatchCondNo}]},1,0]}) {
            /echo Pausing due to GroupWatchCheck..
            /while (1) {
				/call MobRadar los ${MeleeDistance} GroupWatch
				/if (${MobCount}>0) {
					/varset PullHold 1
					POPCALL
					/return
				}
                /if (${If[${Cond[${GrpWatchCondNo}]},0,1]}) /break
                /delay 10
				| What is this doing? Does not do anything useful.
                DOPARSE
                /if (!${MedCombat} && ${AggroTargetID}) /break
            }
            /echo Continuing from GroupWatchCheck condition.
        }
		
        /if (${PullHold}==1) /varset PullHold 0
		
		/if (${ForceMed}) {
			/varset StartMed 0
			/varset StopMed 100
		}	
		
		/while (1) {
			/for i 1 to ${Group}
				DEBUGMED GroupWatch Checking Group member ${Group.Member[${i}].CleanName}
				/if (!${Group.Member[${i}].ID} || ${Group.Member[${i}].Type.Equal[corpse]} ) {
					|/if (${ChainPull} && ${Group.Member[${i}].Type.Equal[corpse]}) /varset PullHold 1
					/varset PullHold 1
					POPCALL
					/return
				}
				/if (${GroupWatchOn}==2 && !${Select[${Group.Member[${i}].Class.ShortName},CLR,DRU,SHM]}) /continue
				/varset GrpMemType ${Group.Member[${i}].Type}
				/varset GrpMemName ${Group.Member[${i}].CleanName}
				/varset GrpMemClass ${Group.Member[${i}].Class.ShortName}
				/if (${Select[${GrpMemClass},BER,MNK,ROG,WAR]}) {
					/varset GrpMemStat Endurance
				} else {
					/varset GrpMemStat Mana
				}
				/varset GrpMedOn ${MedOn}
				/if (!${MedOn}) /varset MedOn 1
				DEBUGMED ${i} /call CheckStats 1 "${GrpMemName}" "${GrpMemClass}" "${GrpMemType}" ${GrpMemStat} ${StartMed} ${StopMed}
				
				/if (${Select[${GrpMemClass},BST,PAL,RNG,SHD]}) {
					/call CheckStats 1 "${GrpMemName}" "${GrpMemClass}" "${GrpMemType}" Endurance ${StartMed} ${StopMed}
				} else {
					/call CheckStats 1 "${GrpMemName}" ${GrpMemClass} ${GrpMemType} ${GrpMemStat} ${StartMed} ${StopMed}
				}
				/if (${Me.Combat} || ${AggroTargetID}) {
					POPCALL
					/return
				}
				/if (${Macro.Return.Equal[NEEDED_TO_MED]}) /varcalc NeededToMed ${NeededToMed}+1
				/if (${Macro.Return.Equal[MOBS]}) {
					POPCALL
					/return
				}
				/if (!${GrpMedOn}) /varset MedOn 0
			/next i
			| If we spun through the group and at any time we encountered someone who needed to med, we repeat
			/if (${NeededToMed}) {
				/varset NeededToMed 0
			} else {
				/varset PullHold 0
				/break
			}
		}
		POPCALL
        DEBUGMED GroupWatch Leave
    /return


| -------------------------------------------------------------------------------------------------
| SUB:IsGroupReady
| Is the group ready for a pull? To break mez?
| -------------------------------------------------------------------------------------------------
    Sub IsGroupReady(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        DEBUGCOMBAT Enter from ${FromWhere}

        /declare i              int     local 0
		/declare GroupRezCount	int		local 0

        DEBUGCOMBAT Is the group alive? Anyone linkdead?

        | Is the group alive?
		/for i 0 to ${Group.Members}
            /if (${Group.Member[${i}].Type.Equal[pc]} && ${Group.Member[${i}].Linkdead}) {
                DEBUGCOMBAT Group member ${Group.Member[${i}].CleanName} is linkdead.
                /varset PullHold 1
                /return LINKDEAD
            }
			/varcalc GroupRezCount ${GroupRezCount} + ${SpawnCount[pccorpse ${Group.Member[${i}].CleanName} radius ${CampRadiusExceed} zradius 100]}
		/next i
		
		DEBUGREZ Bodycount ${GroupRezCount}
		
		/if (${GroupRezCount}) {
            /varset PullHold 1
            DEBUGCOMBAT The group still needs to be rezzed.
            /return NOT_REZZED
		}

        DEBUGCOMBAT Is mana ok?

        /call CheckMana FROMHERE
        | 1 means we need to med.
        /if (${Macro.Return.Equal[1]}) {
            /varset PullHold 1
            POPCALL
            /return NEED_MANA
        }

        DEBUGCOMBAT Group is ready. Leaving.
        /varset PullHold 0
    /return 1
