	
| ----------------------------------------------------------------------------
| SUB: Auto Load INI Entries
| ----------------------------------------------------------------------------
    Sub AutoLoad(string SectionName)
        /if (${SectionName.Equal[null]} || !${SectionName.Length}) /return
        /if (${Select[${SectionName},buffs,heals,dps]}==0) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /echo AutoLoad INI - ${SectionName}
        /declare ActionsTag     string     local
        /declare SpellLevel     int        local
        /declare SpellLevelChk  int        local
        /declare ka             int        local
        /declare kb             int        local
        /declare kc             int        local
        /declare kl             int        local
        /declare km             int        local
        /declare kx             int        local
        /declare AutoLoadFile   string     local     aka\data\AUTO${Me.Class.ShortName}.ini
        /declare SpellList      string     local
        /declare SpellListL     string     local
        /declare SpellListT     string     local
        /declare SpellName      string     local
        /declare SpellNameChk   string     local
        /declare VarArray       string     local
        /declare SpellTag       string     local
        /declare SpellTagL      string     local     null
        /declare UseLowerLevel  int        local     0
        /declare MemTheSpell    int        Local     0
        /if (${SectionName.Equal[buffs]}) {
            /varset VarArray Buffs
        } else /if (${SectionName.Equal[heals]}) {
            /varset VarArray Heals
        } else /if (${SectionName.Equal[dps]}) {
            /varset VarArray DPS
        } else {
            /echo Invalid Auto Array (${SectionName}) to check.
            /return
        }
        /varset ka 1
        /varset kc 0
        | File Name Fromat: AUTO Class Short Name .ini Example: AUTOCLR.ini, AUTOSHM.ini, AUTOMAG.ini
        | tag: is used for what you want to tag on after the end of the spell name. 
        |      Use standard kiss syntax. 
        |      This should come before the Actions: tag
        |      Example: tag:90|MA.
        | Actions Tag Syntax:
        |      UL - Is used to designate the use of a lower level spell for the previous spell list. This allows for 2 remedy spells.
        |           The spell based on your current level and the one just below your current level.
        |      Mem|# - Mem the spell in Gem #. This has to be last entry on line.
        | 
        | Heals1=Ethereal Remedy,Supernal Remedy,Pious Remedy,Sacred Remedy,Solemn Remedy,Devout Remedy,Earnest Remedy,Faithful Remedy,Graceful Remedy,Spiritual Remedy,Merciful Remedy,tag:85|MA,Actions:Mem|1
        | Heals2=tag:90|MA,Actions:UL|Mem|2
        | Heals3=tag:75|!MA
        | Heals4=tag:80|!MA,Actions:UL
        | OR
        | Heals3=tag:75
        | Heals4=tag:80,Actions:UL
        |
        /varset SpellListL null
        /while (1) {
            /varset SpellList null
            /varset SpellListT null
            /varset SpellLevel 0
            /if (${Ini[${AutoLoadFile},${SectionName},${VarArray}${ka}].Length}) {
                /varset SpellListT ${Ini[${AutoLoadFile},${SectionName},${VarArray}${ka}]}
            }
            /if (${SpellListT.NotEqual[null]}) {
                /varset kb 1
                /varset SpellTag null
                /varset kx 1
                /varset ActionsTag null
                | lets parse the line for tags and spells.
                /while (1) {
                    /if (!${Bool[${SpellListT.Arg[${kx},,]}]}) /break
                    /varset SpellNameChk ${SpellListT.Arg[${kx},,]}
                    /if (${SpellNameChk.Left[4].Equal[tag:]}) {
                        /varset SpellTag ${SpellNameChk.Replace[tag:,]}
                    } else /if (${SpellNameChk.Left[8].Equal[actions:]}) {
                        /varset ActionsTag ${SpellNameChk.Replace[actions:,]}
                    } else {
                        /if (${SpellList.Equal[null]}) {
                            /varset SpellList ${SpellNameChk}
                        } else {
                            /varset SpellList ${SpellList},${SpellNameChk}
                        }
                    }
                    /varcalc kx ${kx}+1
                }
                /if (${ActionsTag.NotEqual[null]}) {
                    /if (${ActionsTag.Arg[1,|].Equal[ul]}) {
                        /varset UseLowerLevel 1
                        /if (${ActionsTag.Arg[2,|].Equal[mem]}) {
                            /varset MemTheSpell ${Int[${ActionsTag.Arg[3,|]}]}
                        } else {
                            /varset MemTheSpell 0
                        }
                    } else /if (${ActionsTag.Arg[1,|].Equal[mem]}) {
                        /varset UseLowerLevel 0
                        /varset MemTheSpell ${Int[${ActionsTag.Arg[2,|]}]}
                    }
                } else {
                    /varset MemTheSpell 0
                    /varset UseLowerLevel 0
                }
                | Set SpellList to previous list if no spells listed in the current entry.
                /if (${SpellList.Equal[null]}) {
                    /if (${SpellListL.Equal[null]}) /continue
                    /varset SpellList ${SpellListL}
                } else {
                    /varset SpellListL ${SpellList}
                }
                
                /varset SpellName null
                
                |/if (!${SpellListT.Find[,lowerlevel]}) {
                /if (!${UseLowerLevel}) {
                    /while (${Bool[${SpellList.Arg[${kb},,]}]}) {
                        /varset SpellNameChk ${SpellList.Arg[${kb},,].Lower}
                        |/if (${SpellNameChk.Left[4].NotEqual[tag:]}) {
                            /varset SpellLevelChk ${Int[${Spell[${SpellNameChk}].Level}]}
                            /if (${SpellLevelChk}<=${Me.Level} && ${SpellLevel}<${SpellLevelChk}) {
                                | No ${FindItem[=${SpellNameChk}].ID} yet, For like Mounts and stuff. Will have to figure out later.
                                /if (${Me.Book[${SpellNameChk}]} || ${Me.AltAbility[${SpellNameChk}]} || ${Me.CombatAbility[${SpellNameChk}]} || ${Me.Skill[${SpellNameChk}]}) {
                                    /varset SpellLevel ${SpellLevelChk}
                                    /varset SpellName ${SpellNameChk}
                                    /varset kl ${kb}
                                }
                            }
                        |} else {
                        |    /varset SpellTag ${SpellNameChk.Replace[tag:,]}
                        |    /varset SpellTagL null
                        |}
                        /varcalc kb ${kb}+1
                    }
                } else {
                    /if (${kl}>1) {
                        /varcalc km ${kl}-1
                        /varset SpellName ${SpellList.Arg[${km},,].Lower}
                        /varset SpellLevel ${Int[${Spell[${SpellName}].Level}]}
                        /if (${SpellTagL.NotEqual[null]} && ${SpellTag.Equal[null]}) /varset SpellTag ${SpellTagL}
                    }
                }
                /if (${SpellName.NotEqual[null]} && ${SpellLevel}>0) {
                    /varcalc kc ${kc}+1
                    /if (${SpellTag.NotEqual[null]}) {
                        /varset SpellTagL ${SpellTag}
                        /varset SpellName ${SpellName}|${SpellTag}
                    }
                    |} else {
                    |    /varset SpellTagL null
                    |}
                    /ini "${IniFileName}" "${SectionName}" "${VarArray}${kc}" "${SpellName}"
                }
            } else {
                /break
            }
            /varcalc ka ${ka}+1
        }
    /return

	
| ----------------------------------------------------------------------------
| SUB: IniWrite - quick ini entry for spells,  aas, discs, items
| ----------------------------------------------------------------------------
    Sub Bind_IniWrite(IWSection, IWE1, IWE2, IWE3, IWE4, IWE5, IWE6, IWE7, IWE8)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGN Bind_IniWrite: Enter
		/declare keyNum int local 0
		/declare IWPercent int local 100
		/declare IWSlot int local 1
		/declare IWType string local ${IWE1}
		/declare IWTypeSingle string local
		/declare IWArray int local ${${IWSection}.Size}
		/declare IWEmptySlot string local 0
		/declare IWEntry string local
		/declare i int local
		/declare j int local
		/declare k int local
		| Determine if single type
		/if (${Select[${IWType},aa,disc,item,spell,clear]}) {
			| Set Item
			/if (${IWType.Equal[item]}) {
				/if (!${Cursor.ID}) {
					/echo ..SET${IWSection}: You need to put the item on your cursor.
					POPCALL
					/return
				}
				/varset IWTypeSingle ${Cursor.Name}
				/echo ${IWTypeSingle}
			}
			| Set Spell
			/if (${IWType.Equal[spell]}) {
				/if (!${Me.Gem[${IWE2}].Name.Length}) {
					/echo ..SET${IWSection}: You need to mem a spell
					POPCALL
					/return
				}
				/varset IWTypeSingle ${Me.Gem[${IWE2}].Name}
			}
			| Set AA
			/if (${IWType.Equal[aa]}) {
				/if (!${Me.AltAbility[${IWE2}]}) {
					/echo ..SET${IWSection}: You don't have that AA
					POPCALL
					/return
				}
				/varset IWTypeSingle ${Me.AltAbility[${IWE2}].Name}
			}
			| Set Disc/Combat Ability
			/if (${IWType.Equal[disc]}) {
				/if (!${Select[${IWE2},1,2,3,4,5,6,7,8]}) {
					/echo ..SET${IWSection}: Disc # must be a Combat Abilty Button 1-8
					POPCALL
					/return
				}
				/if (!${Me.CombatAbility[${Window[CombatAbilityWnd].Child[CAW_Button${IWE2}].Text}]}) {
					/echo ..SET${IWSection}: You don't have that Disc or Combat Ability button ${IWE2} is empty.
					POPCALL
					/return
				}
				/varset IWTypeSingle ${Window[CombatAbilityWnd].Child[CAW_Button${IWE2}].Text}
			}
			| Final Catchall for error control
			/if (!${IWTypeSingle.Length}) {
				/echo ..SET${IWSection}: ${IWType} parameter is blank. Please provide a ${IWType}
				POPCALL
				/return
			}
			| Find empty slot & check if entry exists
			/echo ..SET${IWSection}: Looking of for spot to write ${IWTypeSingle}
			/for k 1 to ${IWArray}
				/varset IWEntry ${Ini[${IniFileName},${IWSection},${IWSection}${k}]}
				/if (${IWSection.Equal[DPS]}) /varset IWPercent 90
				/if (${IWSection.Equal[Heals]}) /varset IWPercent 80
				DEBUGN ${${IWSection}[${k}].Length}
				/if (${IWEntry.Find[${IWTypeSingle}]}) {
					/echo ..SET${IWSection}: Duplicate entry ${IWSection}${k}=${IWTypeSingle} skipping.
					POPCALL
					/return
				}
				/if (${IWEntry.Equal[null]} && ${IWEmptySlot}==0) {
					/varset IWEmptySlot ${k}
				}
				/if (${k}==${IWArray} && !${IWEmptySlot}) /varset IWEmptySlot ${k}
			/next k
			/if (${IWEmptySlot}==${IWArray}) {
				/echo ..SET${IWSection}: No empty slots in ${IWSection} to write
				POPCALL
				/return
			}
			/if (${Select[${IWSection},DPS,Heals]}) {
				/ini "${IniFileName}" "${IWSection}" "${IWSection}${IWEmptySlot}" "${IWTypeSingle}|${IWPercent}"
				/echo  ..SET${IWSection}: ${IWSection}${IWEmptySlot} is empty writing ${IWTypeSingle}|${IWPercent}
			} else {
				/ini "${IniFileName}" "${IWSection}" "${IWSection}${IWEmptySlot}" "${IWTypeSingle}"
				/echo  ..SET${IWSection}: ${IWSection}${IWEmptySlot} is empty writing ${IWTypeSingle}
			}
		} else {
			/echo ..SET${IWSection}: This command will write over current ${IWSection} settings
			/for i 1 to 8
				/varset keyNum ${i}
				/if (${Me.Gem[${IWE${i}}].Name.Length}) {
					/if (${IWSection.Equal[DPS]}) /varcalc IWPercent ${IWPercent}-5
					/if (${IWSection.Equal[Heals]}) /varset IWPercent 80
					/if (${Select[${IWSection},DPS,Heals]}) {
						/ini "${IniFileName}" "${IWSection}" "${IWSection}${IWSlot}" "${Me.Gem[${IWE${i}}].Name}|${IWPercent}"
						/echo ..SET${IWSection}: Writing ${IWSection}${IWSlot}=${Me.Gem[${IWE${i}}].Name}|${IWPercent}
					}
					/if (${Select[${IWSection},Buffs]}) {
						/ini "${IniFileName}" "${IWSection}" "${IWSection}${IWSlot}" "${Me.Gem[${IWE${i}}].Name}"
						/echo ..SET${IWSection}: Writing ${IWSection}${IWSlot}=${Me.Gem[${IWE${i}}].Name}
					}
					/varcalc IWSlot ${IWSlot}+1
					/delay 10
				}
			/next i
		}
		POPCALL
    /return
	
| ----------------------------------------------------------------------------
| SUB: Bind Kiss Check - scan ini file for errors based on nostress KissNamechecker.mac
| ----------------------------------------------------------------------------
    Sub Bind_KissCheck
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /call ScanIni all 0
		POPCALL
    /return
	
|-----------------------------------------------------------------------------
| SUB: Load INI Settings
| ----------------------------------------------------------------------------
    Sub Bind_Settings(string command1, string command2, int skipIniCheck)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /declare CondNo     int     local     0
		
		| list and help are not implemented.
        /if (!${Select[${command1},load,list,help]}) {
            /echo Invalid Settings command.. Please use load, list, or help.
            POPCALL
            /return
        }
        /if (${command1.Equal[load]}) {
            /if (!${command2.Length} || ${command2.Equal[null]}) /varset command2 all
            /if (!${Select[${command2},all,general,spells,buffs,melee,gom,gmail,ae,dps,aggro,heals,cures,pet,merc,mez,burn,pull,pulladvanced,afktools,conditions,vars]}) {
                /echo Invalid reload option. Valid options are: general, spells, buffs, melee, gom, gmail, ae, dps, aggro, heals, cures, pet, merc, mez, burn, pull, pulladvanced, afktools, conditions, vars, or all.
                POPCALL
                /return
            }
            /echo Loading INI Info from ${command2} Section(s).
			| KVars goes on top because we use the vars in the ini. Use: Vars[1]
            | ************************* KVars ************************************|
            /if (${Select[${command2},all,vars]}) {
                /if (${Defined[Vars]}) /deletevar Vars
                /call LoadIni KVars VarsOn             		int         0
                /call LoadIni KVars VarsSize          		int         10
                /declare Vars[${VarsSize}]                  string      outer
                /call LoadIni KVars Vars              		string      NULL		Vars
            }				
            | ************************* General **************************************|
            /if (${Select[${command2},all,general]}) {
                | Edit settings in your KissAssist_ToonName.ini file
                | Only call role from ini if not defined in command line from hot key
                /call LoadIni General Role                  string      Assist
                /if (${p_Role.NotEqual[null]}) /varset Role ${p_Role}
                /call LoadIni General CampRadius            int         30
                /call LoadIni General CampRadiusExceed      int         400
                /call LoadIni General ReturnToCamp          int         0
                /call LoadIni General ChaseAssist           int         0
                /call LoadIni General ChaseDistance         int         25
                /call LoadIni General MedOn                 int         1
                /call LoadIni General MedStart              int         20
                /call LoadIni General MedStop               int         100
                /call LoadIni General MedCombat             int         0
                /call LoadIni General LootOn                int         0
                /call LoadIni General RezAcceptOn           string      1|90
                /call LoadIni General AcceptInvitesOn       int         1
                /call LoadIni General GroupWatchOn          string      0
                /call LoadIni General GroupWatchCheck       string      FALSE
				/call LoadIni General GroupMedStart			int			20
				/call LoadIni General GroupMedStop			int			80
                /call LoadIni General CorpseRecoveryOn      int         0
                /if (${CorpseRecoveryOn}) {
                    /if (${Select[${Me.Class.ShortName},NEC,SHD]}) {
                        /if (${FindItemCount[Tiny Jade Inlaid Coffin]}<2 || ${Me.Level}<70) {
                            /varset CorpseRecoveryOn 2
                        }
                    } else /if (${Me.Class.ShortName.Equal[ROG]}) {
                        /if (!${Me.AltAbility[Shroud of Stealth]}) {
                            /varset CorpseRecoveryOn 2
                        }
                    } else {
                        /varset CorpseRecoveryOn 2
                    }
                }
                /if (${GroupWatchOn.Find[|]}) {
                    /varset GroupMedStart ${GroupWatchOn.Arg[2,|]}
                    /varset GroupWatchOn ${GroupWatchOn.Arg[1,|]}
                }
                /call LoadIni General EQBCOn                string      1
                /call LoadIni General DanNetOn              string      1
                /call LoadIni General DanNetDelay           int         20
                /if (${EQBCOn}) {
                    /varset BroadCastSay bc
                    /if (${EQBCOn.Arg[2,|].Length} && ${EQBCOn.Arg[1,|].Equal[2]}) {
                        DEBUGN ${EQBCOn} ${EQBCOn.Arg[1,|]} ${EQBCOn.Arg[2,|]}
                        /varset BroadCastSay bct ${EQBCOn.Arg[2,|]}
                        /varset EQBCOn 2
                    }
                } else /if (${DanNetOn}) {
                    /varset BroadCastSay dgtell all
                    /if (${DanNetOn.Arg[2,|].Length} && ${DanNetOn.Arg[1,|].Equal[2]}) {
                        DEBUGN ${DanNetOn} ${DanNetOn.Arg[1,|]} ${DanNetOn.Arg[2,|]}
                        /varset BroadCastSay dgtell ${DanNetOn.Arg[2,|]}
                        /varset DanNetOn 2
                    }
                }
                /call LoadIni General IRCOn                 int         0
                /call LoadIni General CampfireOn            int         0
                /if (${Int[${Ini[${IniFileName},General,CharInfo].Arg[2,|]}]}!=${Me.Level}) /ini "${IniFileName}" "General" "CharInfo" "${Me.Class}|${Me.Level}|${Me.Subscription}"
                /if (${Int[${Ini[${IniFileName},General,DefaultUI].Arg[1,|]}]}!=${EverQuest.CurrentUI.Equal[Default]}) /ini "${IniFileName}" "General" "DefaultUI" "${If[${EverQuest.CurrentUI.Equal[Default]},TRUE,FALSE|Custom UIs are not supported. Please switch to Default UI before posting bugs.]}"
                /if (${Select[${Me.Class.ShortName},WIZ,DRU]}) {
                    /call LoadIni General GroupEscapeOn     int         0
                } else {
                    /if (!${Defined[GroupEscapeOn]}) {
                        /declare GroupEscapeOn              int         outer    0
                    }
                }
                /call LoadIni General ScatterOn             int         0
                /if (${IAmABard}) {
                    /call LoadIni General TwistOn           int         0
                    /call LoadIni General TwistMed          string      "Mana song gem"
                    /call LoadIni General TwistWhat         string      "Twist order here"
                } else {
                    /if (!${Defined[TwistOn]}) {
                        /declare TwistOn                    int         outer       0
                        /declare TwistMed                   string      outer       0
                        /declare TwistWhat                  string      outer       0
                    }
                }
                /if (${Int[${TwistMed.Left[1]}]}==0) /varset TwistMed 0

                /call LoadIni General HelpXTarWatch            string      "0 off, 1 on, 2 (watch xtargets only)"
                /call LoadIni General HelpXTarWatchList        string      "Xtar slots to watch. Example: 5|6|7"
                /call LoadIni General HelpXTarWatchTargets     string      "Who to assign and watch. Any target: NPCs, PCs, Pets, Mercs etc. StartSlot|Name1|Name2.. Example: 2|Uberguy|Ubergal|Captain Underpants"

                /call LoadIni General XTarWatch                int         0
                /call LoadIni General XTarWatchList            string      "NULL"
                /call LoadIni General XTarWatchTargets         string      "NULL"

                /if (${XTarWatch} && ${Int[${XTarWatchTargets.Arg[1,|]}]}) /call SetXTargets "${XTarWatchTargets}"
                /if (${XTarWatch} && ${XTarWatchList.NotEqual[null]}) /call SetXTargetWatchList "${XTarWatchList}"

                /call LoadIni General HelpSwitchMAAnnounce     string      "If killed in combat, announce MA switch to the [group] or [all] in the channel/clients."
                /call LoadIni General SwitchMAAnnounce         string      "group"
            }
            | ************************* Spells *************************************|
            /if (${Select[${command2},all,spells]}) {
                /if (${Select[${Me.Class.ShortName},BER,MNK,ROG,WAR]}==0) {
					| Allows the use of Gem[n] as vars in the ini.
					/if (${Defined[Gem]}) /deletevar Gem
					/declare GemSize						int			outer		13
					/declare Gem[${GemSize}]	            string      outer
					/call LoadIni Spells Gem           		string      NULL		Gem
                    /call LoadIni Spells MiscGem            int         8
                    /call LoadIni Spells MiscGemLW          int         0
					|
					| Gem that you want to hotswap without it being overwritten by remem.
					|
					/call LoadIni Spells HotSwapGem			int			0					
                    /call LoadIni Spells MiscGemRemem       int         1
                    /call LoadIni Spells LoadSpellSet       int         0
                    /call LoadIni Spells SpellSetName       string      "KissAssist"
                    /call LoadIni Spells CastingInterruptOn int         1
                    /call LoadIni Spells CheckStuckGem      int         1
					|
					| Gem that you want to hotswap without it being overwritten by remem.
					|
					/call LoadIni Spells HotSwapGem			int			0
                    /if (${CastingInterruptOn}==1) /varset CastingInterruptOn 30
                } else /if (!${Defined[MiscGem]} ) {
					/declare GemSize						int			outer	13
					/declare Gem[${GemSize}]				string		outer	null
					/declare HotSwapGem						int			outer	0
                    /declare MiscGem                        int         outer   0
                    /declare MiscGemLW                      int         outer   0
                    /declare MiscGemRemem                   int         outer   0
                    /declare LoadSpellSet                   int         outer   0
                    /declare SpellSetName                   string      outer   null
                    /declare CastingInterruptOn             int         outer   0
                    /declare CheckStuckGem                  int         outer   0
                }
            }
            | ************************* Buffs ****************************************|
            /if (${Select[${command2},all,buffs]}) {
                /if (${LoadFromINI}) /call AutoLoad "buffs"
                /if (${Defined[Buffs]}) /deletevar Buffs
                /call LoadIni Buffs BuffsOn                 int         0
                /call LoadIni Buffs BuffsSize               int         20
                /declare Buffs[${BuffsSize}]                string      outer
                /call LoadIni Buffs Buffs                   string      NULL       Buffs
                /call LoadIni Buffs RebuffOn                int         1
                /call LoadIni Buffs CheckBuffsTimer         int         10
                /call LoadIni Buffs PowerSource             string      NULL
				|
				| Support for modrods and Coth
				|
				/call LoadIni Buffs ProvideCoth				int			0
				/call LoadIni Buffs ProvideModRods			int			0
				/call LoadIni Buffs RequestModRods			int			0
                /call LoadIni Buffs BuffOnJoin              int         0
                /if (${BuffsOn}) {
                    /call SortArray Buffs 100|100 >
                } else {
                    /call CreateTimersBuffs
                }
            }
            | ************************* Melee ****************************************|
            /if (${Select[${command2},all,melee]}) {
                /call LoadIni Melee AssistAt                int         95
                /if (${p_AssistAt}) /varset AssistAt ${p_AssistAt}
                /if (${Select[${Me.Class.ShortName},BST,BER,MNK,PAL,RNG,ROG,SHD,WAR]}) {
                    /call LoadIni Melee MeleeOn             int         1
                } else {
                    /call LoadIni Melee MeleeOn             int         0
                }
                /call LoadIni Melee FaceMobOn               int         1
                /call LoadIni Melee MeleeDistance           int         75
                /call LoadIni Melee StickHow                string      "snaproll"
                /call LoadIni Melee AutoFireOn              int         0
				|
				| Allow the user to select the target. KA does the rest.
				| 1 = KA operates as normal. 0 means manual.
                /call LoadIni Melee UseMQ2Melee             int         1
                /call LoadIni Melee TargetSwitchingOn       int         0
				|
				| Flag to disable KA from choosing target and not override user
				| Also whether I will jump on loose mobs and rescue chars if they get agro.
				|
				/call LoadIni Melee RescueCharsOn			int			1
				/call LoadIni Melee DropInvisMAAssist		int			1
                /if (${Select[${Me.Class.ShortName},ROG]}) {
                    /call LoadIni Melee AutoHide            int         1
                } else /if (!${Defined[AutoHide]}) {
                    /declare AutoHide                       int         outer 0
                }
                /if (${IAmABard}) {
                    /call LoadIni Melee MeleeTwistOn        int         0
                    /call LoadIni Melee MeleeTwistWhat      string      "DPS twist order here"
                } else /if (!${Defined[MeleeTwistOn]}) {
                   /declare MeleeTwistOn                    int         outer       0
                   /declare MeleeTwistWhat                  string      outer       0
                }
				/call LoadIni Melee MoveIfCantSee			int			1
				/call LoadIni Melee MoveIfOOR				int			1
                /call LoadIni Melee OKToGetHit              int         1                
				/call LoadIni Melee MoveWhenHit				int			0
            }
            | ************************* GoM ****************************************|
            /if (${Select[${command2},all,gom]}) {
                /if (!${Select[${Me.Class.ShortName},BRD,BER,MNK,ROG,WAR]}) {
                    /if (${Defined[GoMSpell]}) /deletevar GoMSpell
                    /call LoadIni GoM GoMSHelp              string       "Format - Spell|Target, MA Me or Mob, i.e. Rampaging Servant Rk. II|Mob"
                    /call LoadIni GoM GoMSize               int         3
                    /declare GoMSpell[${GoMSize}]           string      outer
                    /call LoadIni GoM GoMSpell              string      NULL       GoMSpell
                    /call CreateTimersGoM
                } else /if (!${Defined[GoMSize]}) {
                    /declare GoMSize                        int         outer 1
                    /declare GoMSpell[${GoMSize}]           string      outer
                }
            }
            | ************************* Gmail ****************************************|
            /if (${Select[${command2},all,gmail]}) {
                /if (${Defined[GMail]}) /deletevar GMail
                /call LoadIni GMail GMailHelp               string      "Events currently support - Dead,Drag,GM,Level,Named,Leftgroup,Tells"
                /call LoadIni GMail GMailOn                 int         0
                /call LoadIni GMail GMailSize               int         5
                /declare GMail[${GMailSize}]                string      outer
                /call LoadIni GMail GMail                   string      NULL       GMail
                /if (${GMailOn}) /call GmailIniParse
            }
            | *************************  AE ******************************************|
            /if (${Select[${command2},all,ae]}) {
                /if (${Defined[AE]}) /deletevar AE
                /call LoadIni AE AEOn                       int         0
                /call LoadIni AE AESize                     int         10
                /call LoadIni AE AERadius                   int         50
                /declare AE[${AESize}]                      string      outer
                /call LoadIni AE AE                         string      NULL       AE
            }
            | ************************* DPS ******************************************|
            /if (${Select[${command2},all,dps]}) {
                /if (${LoadFromINI}) /call AutoLoad "dps"
                /if (${Defined[DPS]}) /deletevar DPS
				/call LoadIni DPS DPSHelp					string		"Format - Spell|%Health. ex. DPS1=Burst Of Flame|100 casts the spell when the mob is at 100% health"
                /call LoadIni DPS DPSOn                     int         0
                /call LoadIni DPS DPSSize                   int         20
				/call LoadIni DPS DPSSkipHelp				string		"Stop DPS when mob is below % health."
                /call LoadIni DPS DPSSkip                   int         0
                /call LoadIni DPS DPSInterval               int         2
				|
				/call LoadIni DPS DPSRateDelayHelp			string		"Allows group to balance agro. Each dps round subtracts DPSRateIncrease which speeds up dps. If pc gets hit, it adds DPSRateReduction to slow them down. Combat smooths out to a rate at which tank can hold agro without it being stolen."
				/call LoadIni DPS DPSRateStartDelay			int			10
				/call LoadIni DPS DPSRateReduction			int			5
				/call LoadIni DPS DPSRateIncrease			int			5
                /declare DPS[${DPSSize}]                    string      outer
                /call LoadIni DPS DPS                       string      NULL        DPS
                /call LoadIni DPS DebuffAllOn               int         0
                /if (${DPSOn}) /call SortArray DPS 1|1 <
            }
            | ************************* Aggro ******************************************|
            /if (${Select[${command2},all,aggro]}) {
                /if (${Defined[Aggro]}) /deletevar Aggro
				/call LoadIni Aggro AggroHelp				string		"Use to lower or raise hate with a mob. Spell/Ability|pct hate|< gain/lose > aggro. E.g. Boggle|60|> or Taunt|100|<"
                /call LoadIni Aggro AggroOn                 int         0
                /if (${Select[${Me.Class.ShortName},SHD,WAR,PAL]})  {
                    /call LoadIni Aggro AggroSize           int         10
                } else {
                    /call LoadIni Aggro AggroSize           int         5
                }
                /declare Aggro[${AggroSize}]                string      outer
                /call LoadIni Aggro Aggro                   string      NULL        Aggro
                |/call LoadIni Aggro Aggro2nd                int         0
				/call LoadINi Aggro MitigateHelp			string		"Mitigate aggro: debuff, slow methods to handle loose mobs."
				/call LoadIni Aggro MitigateDebuff			string		null
				/call LoadIni Aggro MitigateSlow			string		null
                /if (${AggroOn}) /call SortArray Aggro 1|1 <
            }
            | ************************* Heals ***************************************|
            /if (${Select[${command2},all,heals]}) {
                /if (${Defined[AutoRez]}) /deletevar AutoRez
                /if (${Defined[Heals]}) /deletevar Heals
                /if (${Defined[SingleHeal]}) /deletevar SingleHeal
                /if (${Defined[GroupHeal]}) /deletevar GroupHeal
                /call LoadIni Heals Help                    string      "Format Spell|% to heal at i.e. Devout Light Rk. II|50"
                /if (${LoadFromINI}) /call AutoLoad "heals"
                /call LoadIni Heals HealsOn                 int         0
                /call LoadIni Heals HealInterval            int         0
                /call LoadIni Heals AutoRezOn               int         0
				|
				| Timer var to reduce rezcheck spam in non-essential functions.
				|
				/call LoadIni Heals RezCheckTimer			int			1
                /declare AutoRez[3]                         string      outer
                /if (${Select[${Me.Class.ShortName},CLR,SHM,DRU,PAL]})  {
                    /call LoadIni Heals HealsSize           int         15
                } else {
                    /call LoadIni Heals HealsSize           int         5
                }
                /declare Heals[${HealsSize}]                string      outer
                /declare GroupHeal[10]                      string      outer
                /declare SingleHeal[50]                     string      outer
                /call LoadIni Heals Heals                   string      NULL        Heals
                /call LoadIni Heals HealGroupPetsOn         int         0
				|
				| Intended for pet wranglers so they can avoid the HealsOn checks intended for real healers
				| Specialized pet heal checks in code now.
				|
				/call LoadIni Heals PetHealsOnly			int			0
				|
				| Delay between pet heals. Affects battle res as well.
				|
				/call LoadIni Heals PetHealInterval			int			1			
                /call LoadIni Heals RezMeLast               int         0
                /if (${HealsOn}) {
                    /call SortArray Heals 100|100 >
                    /call FindSingleHeals
                    /call FindGroupHeals
                    /call CreateTimersHeals
                }
                /if (${AutoRezOn}) /call CreateTimersRez
            }
            | ************************* Cures ***************************************|
            /if (${Select[${command2},all,cures]}) {
                /if (${Defined[Cures]}) /deletevar Cures
                /call LoadIni Cures CuresOn                 int         0
                /call LoadIni Cures CuresSize               int         5
                /declare Cures[${CuresSize}]                string      outer
                /call LoadIni Cures Cures                   string      NULL        Cures
				|
				| Timer check for cures
				|
				/call LoadIni Cures CheckCuresTimer			int			1
            }
            | ************************* Pet *****************************************|
            /if (${Select[${command2},all,pet]}) {
                /if (${Defined[PetBuffs]}) /deletevar PetBuffs
                /if (${Defined[PetToys]}) /deletevar PetToys
                /if (${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]}) {
                    /call LoadIni Pet PetOn                 int         0
                    /call LoadIni Pet PetSpell              string      "YourPetSpell"
                    |/if (${Select[${Me.Class.ShortName},BST,MAG,NEC,SHM,DRU,SHD]})  {
                        /call LoadIni Pet PetFocus          string      "NULL"
                    |} else /if (!${Defined[PetFocus]}) {
                    |    /declare PetFocus                   string      outer   NULL
                    |}
                    /call LoadIni Pet PetShrinkOn           int         0
                    /call LoadIni Pet PetShrinkSpell        string      "Tiny Companion"					
					|
					| Record the size of the pet after shrink. If the pet changes, we will re-shrink and record to avoid re-casting if KA restarts with pet already shrunk.
					|
					/call LoadIni Pet PetShrunkSizeHelp		string		"Stores the size of the pet when shrunk"
					/call LoadIni Pet PetShrunkSize			float		2.0
                    /call LoadIni Pet PetBuffsOn            int         0
                    /call LoadIni Pet PetBuffsSize          int         8
                    /declare PetBuffs[${PetBuffsSize}]      string      outer
                    /call LoadIni Pet PetBuffs              string      NULL    PetBuffs
                    /call LoadIni Pet PetCombatOn           int         1
                    /call LoadIni Pet PetAssistAt           int         95
                    /call LoadIni Pet PetAttackDistance     int         115
                    /call LoadIni Pet PetPullDistance       int         150                    
					/call LoadIni Pet PetFocusOn			int			1
                    /call LoadIni Pet PetToysSize           int         6
                    /declare PetToys[${PetToysSize}]        string      outer
					/declare PetToysContents[${PetToysSize}] string		outer
                    /if (${IAmAMage}) {
                        /call LoadIni Pet PetToysOn         int         0
                        /call LoadIni Pet PetToys           string      NULL    PetToys
						/call LoadIni Pet PetToysContents   string      NULL    PetToysContents
                        /call LoadIni Pet PetToysGave       string      NULL
                    } else /if (!${Defined[PetToysOn]}) {
                        /declare PetToysGave                string      outer   NULL
                        /declare PetToysOn                  int         outer   0
                    }
                    /call LoadIni Pet PetBreakMezSpell      string      NULL
					|
					| Allow ini setting for petbufftimer. Default of 30s works well.
					| Battle summon pet if they die in combat
					|
	                /call LoadIni Pet CheckPetBuffsTimer  	int         5
					/call LoadIni Pet BattleSummonPet		int			0
					|
					| Mana regen method
					|
					/call LoadIni Pet ReclaimHelp			string		"Reclaim energy from pets with an item or spell, and the name of the pet spell."
					/call LoadIni Pet ReclaimEnergyMethod	string		NULL
					/call LoadIni Pet SacrificialPetSpell	string		NULL
                    /call LoadIni Pet PetRampPullWait       int         0
                    /call LoadIni Pet PetSuspend            int         0
					|
					| Adding follow override mode. If enabled then if a role calls to guard, it will istead follow. Can be manually changed later.
					|
					/call LoadIni Pet PetAlwaysFollowOn		int			0
                    /call LoadIni Pet PetHoldOn             int         1
                    | PetHold needed a valid value to try to access object property and not barf
                    /if (!${Defined[PetHold]}) /declare PetHold                        string     outer     Hold
                    /if (${Int[${Me.AltAbility[Companion's Discipline]}]} > 0) {
                        /if (${Me.AltAbility[Companion's Discipline]}>1) {
                            /varset PetHold GHold
                        } else {
                            /varset PetHold Hold
                        }
                    }
                    /call LoadIni Pet PetForceHealOnMed     int         0
					|
					| Provide bags of pet toys. 0 disabled, 1 or more for number of bags
					|
					/call LoadIni Pet GivePetToyBags		int			0
					|
					| Pet attack if you have line of sight.
					|
					/call LoadIni Pet PetLineOfSightOn		int			0
					|
					| Added variable to allow startup to turn off pet taunt, even as a pettank.
					| Provided an override so that the pet will *never* taunt automatically, like in a raid
					|
					/call LoadIni Pet PetTauntOn			int			0
					/call LoadIni Pet PetAllowTaunt			int			1
					|
					| Flag to allow pet wranglers to request pet toys when they make their pet
					| and whether the mage will provide them.
					|
					/call LoadIni Pet RequestPetToys		int			0
					/call LoadIni Pet ProvidePetToys		int			0
               } else /if (!${Defined[PetOn]}) {
					|
					| Non pet wielders see the BattleSummonPet
					| and if you do a /bcaa to change PetDistance, it causes a glitch
					|
					/declare BattleSummonPet				int			outer	0
					|
					| Needs to be here because used in CheckRoles
					|
					/declare PetAlwaysFollowOn				int			outer	0
					/declare PetAllowTaunt                  int         outer   0
                    /declare PetAttackDistance				int			outer	0
                    /declare PetPullDistance                int         outer   0
					/declare ProvidePetToys					int			outer 	0
					/declare RequestPetToys					int			outer 	0
                    /declare PetForceHealOnMed              int         outer   0
                    /declare PetOn                          int         outer   0
                    /declare PetAssistAt                    int         outer   0
                    /declare PetCombatOn                    int         outer   0
                    /declare PetRampPullWait                int         outer   0
					|
					| Exposed within common routine
					|
                    /declare PetBuffsOn                     int         outer   0
					/declare PetFocusOn						int			outer	0
                    /declare PetHoldOn                      int         outer   0
                    | Needs a valid default so the TLO doesn't complain
                    /declare PetHold                        string      outer   Hold
                    /declare PetToysOn                      int         outer   0
					/declare PetSuspend						int			outer	0
                    /declare PetTauntOn                     int         outer   0
                }
            }
            | ************************* Merc ****************************************|
            /if (${Select[${command2},all,merc]}) {
                /call LoadIni Merc Help                     string      "Recommended: Turn off Auto Assist in Manage Mercenary Window"
                /call LoadIni Merc MercOn                   int         0
                /call LoadIni Merc MercAssistAt             int         92
                /call LoadIni Merc MercAttackDistance       int         75
            }
            | ************************* Mez *****************************************|
            /if (${Select[${command2},all,mez]}) {
                /if (${Defined[MezAECount]}) /deletevar MezAECount
                /if (${Defined[MezCount]}) /deletevar MezCount
                /if (${Defined[MezAEClosest]}) /deletevar MezAEClosest
                /if (${Select[${Me.Class.ShortName},BRD,ENC,NEC]}) {
                    /call LoadIni Mez MezOn                 int         0
                    /call LoadIni Mez MezRadius             int         50
                    /call LoadIni Mez MezMinLevel           int         "Min Mez Spell Level"
                    /call LoadIni Mez MezMaxLevel           int         "Max Mez Spell Level"
                    /call LoadIni Mez MezStopHPs            int         80
                    /call LoadIni Mez MezSpell              string      "Your Mez Spell"
                    /call LoadIni Mez MezDebuffOnResist     int         0
                    /call LoadIni Mez MezDebuffSpell        string      "Your Debuff Spell"
					|
					| How often will we check on mezzes
					|
					/call LoadIni Mez CheckMezTimer			int			1
                    | necros can't AE mez
                    /if (${Select[${Me.Class.ShortName},BRD,ENC]}) {
                        /call LoadIni Mez MezAESpell        string      "Your AE Mez Spell|0"
                        /declare MezAECount                 int         outer   ${MezAESpell.Arg[2,|]}
                        /varset MezAESpell                  ${MezAESpell.Arg[1,|]}
                    }
                    /declare MezCount[13]                   int         outer 0
                    /declare MezAEClosest                   int         outer 0
                } else /if (!${Defined[MezOn]}) {
                    /declare MezOn                          int         outer 0
                }
                | This loads and declares the MezImmune var
                /call LoadIni "${ZoneName}" MezImmune   string      "List up to 10 mobs. Use full names i.e. a green snake,a blue tiger,a wide eye ooze or NULL" NULL ${InfoFileName}
                /if (${MezOn}) /call CreateTimersMez
                |KissAssist_Info variables
                /if (!${MezImmune.Find[null]} && ${MezImmune.Length}>0) {
                    /squelch /alert clear 4
                    /call AlertAddToList 4 "${MezImmune}"
                } else {
                    /varset MezImmune null
                }
            }
            | ************************* Burn ****************************************|
            /if (${Select[${command2},all,burn]}) {
                /if (${Defined[Burn]}) /deletevar Burn
                /call LoadIni Burn  BurnAllNamed            int         0
                /call LoadIni Burn  UseTribute              int         0
                /call LoadIni Burn  BurnSize                int         15
                /declare Burn[${BurnSize}]                  string      outer
                /call LoadIni Burn  Burn                    string      NULL        Burn
                /call SortArray Burn 1|1 >
                /call FixBurnSpells
            }
            | ************************* Pull ****************************************|
            /if (${Select[${command2},all,pull]}) {
                /call LoadIni Pull PullWith                 string      "Melee"
                /call LoadIni Pull PullMeleeStick           int         0
                /call LoadIni Pull MaxRadius                int         350
                /call LoadIni Pull MaxZRange                int         50
                /call LoadIni Pull UseWayPointZ             int         0
                /call LoadIni Pull PullWait                 int         5
                /call LoadIni "${ZoneName}" MobsToPull      string      "List up to 25 mobs. Use full names i.e. a green snake,a blue tiger,a wide eye ooze or ALL for all mobs" NULL  ${InfoFileName}
                /call LoadIni "${ZoneName}" MobsToIgnore    string      "List up to 25 mobs. Use full names i.e. a green snake,a blue tiger,a wide eye ooze or NULL" NULL ${InfoFileName}
                /call LoadIni "${ZoneName}" MobsToBurn      string      "List up to 10 mobs. Use full names i.e. Beget Cube,Helias,Raze or NULL" Null ${InfoFileName}
                /call LoadIni "${ZoneName}" PullPath        string      "Place holder for path file. Not yet impletmented." NULL ${InfoFileName}
                /if (${p_PullPath.NotEqual[null]}) /varset PullPath ${p_PullPath}
                /call LoadIni Pull PullRadiusToUse          int         90
                /call LoadIni Pull PullRoleToggle           int         0
                /call LoadIni Pull ChainPull                int         0
                /call LoadIni Pull ChainPullHP              int         90
                /call LoadIni Pull PullPause                string      30|2
                /call LoadIni Pull PullLevel                string      0|0
                /call LoadIni Pull PullArcWidth             string      0
                
                /if (${IAmABard}) {
                    /call LoadIni Pull PullTwistOn          int         0
                } else /if (!${Defined[PullTwistOn]}) {
                    /declare PullTwistOn                    int         outer       0
                }
                /call LoadIni Pull PullOnReturn             int         0
                /if ((${MobsToPull.Find[all for all]} || !${MobsToPull.Length} || ${MobsToPull.Equal[all]} || ${MobsToPull.Equal[null]}) && (${MobsToIgnore.Find[or null]} || !${MobsToIgnore.Length} || ${MobsToIgnore.Equal[null]})) {
                    /varset MobsToPull all
                    /varset MobsToIgnore null
                } else /if (${MobsToIgnore.Find[or null]} || !${MobsToIgnore.Length} || ${MobsToIgnore.Equal[null]}) {
                    /varset MobsToIgnore null
                } else /if (${MobsToPull.Find[all for all]} || !${MobsToPull.Length} || ${MobsToPull.Equal[all]} || ${MobsToPull.Equal[null]}) {
                    /varset MobsToPull all
                }
                /squelch /alert clear 2
                /if (${MobsToPull.Equal[all]}) {
                    /varset SearchType noalert 1
                } else {
                    /call AlertAddToList 2 "${MobsToPull}" "null"
                    /varset SearchType alert 2
                }
                /squelch /alert clear 3
                /if (${MobsToIgnore.NotEqual[null]}) {
                    /call AlertAddToList 3 "${MobsToIgnore}" "null"
                }
                /if (${Role.Find[Puller]} || ${Role.Find[hunter]}) {
                    /if (${Bool[${Plugin[MQ2Map]}]}) {
                        /squelch /mapfilter CastRadius color 25 225 25
                        /squelch /mapfilter SpellRadius color 25 25 225
                        /squelch /mapfilter PullRadius color 255 255 0
                        /squelch /mapfilter CampRadius color 255 25 25
                    }
                }
                /call LoadIni Pull HelpPullManual           string  "Enables you to use /pull at will rather than setting your role as puller."
				/call LoadIni Pull PullManual				int		1
				|
				| Adding escape spell / method, such as Mistwalk for a druid
				|
				/call LoadIni Pull PullEscapeMethod			string	null

				/call LoadIni Pull PullCampAdvanceHelp		string  "Puller calls the group to them and continues pulling from the new camp"
				/call LoadIni Pull PullCampAdvanceOn		int		0
				/call LoadIni Pull PullCampDistFromCamp		int		150
				/call LoadIni Pull PullCampDistToMob		int		150
				
                /if (!${PullRadiusToUse} || ${PullRadiusToUse}>150) /varset PullRadiusToUse 100
            }
            | *********************** PullAdvanced ***********************************|
            /if (${Select[${command2},all,pullAdvanced]}) {
                /if (${Defined[PullLocs]}) /deletevar PullLocs
            |    /call LoadIni pullAdvanced CalmOn           int         0
            |    /call LoadIni pullAdvanced CalmWith         string      0
            |    /call LoadIni pullAdvanced CalmRadius       int         50
            |    /call LoadIni pullAdvanced PullAbortOn      int         0      
            |    /call LoadIni pullAdvanced PullAbortCMD     string      null

                /declare PullLocs[5]                        string      outer
                /call LoadIni PullAdvanced PullLocsOn       int         0
                /call LoadIni "${ZoneName}" PullLocsHelp    string      "Y,X|Range. Ignore mobs in this area" NULL ${InfoFileName}
                /call LoadIni "${ZoneName}" PullLocs        string      0        PullLocs ${InfoFileName}
            }
            | ************************* AFKTools ************************************|
            /if (${Select[${command2},all,afktools]}) {
                /call LoadIni AFKTools AFKHelp              string      "AFKGMAction=0 Off, 1 Pause Macro, 2 End Macro, 3 Unload MQ2, 4 Quit Game"
                /call LoadIni AFKTools AFKToolsOn           int         1
                /call LoadIni AFKTools AFKGMAction          int         1
                /call LoadIni AFKTools AFKPCRadius          int         500
                /call LoadIni AFKTools CampOnDeath          int         0
                /call LoadIni AFKTools ClickBacktoCamp      int         0
                /call LoadIni AFKTools InactivityEndHelp    string      "End AKA after X mins of inactivity; i.e. not moving, sitting and standing, looking around."
                /call LoadIni AFKTools InactivityEndMins    int         0
                /if (${InactivityEndMins}) {
                    /varset InactivityEndSecs ${Math.Calc[${InactivityEndMins}*60]}
                }
                /call LoadIni AFKTools InactivityCampHelp   string      "Camp after X mins of inactivity; i.e. not moving, sitting and standing, looking around. Supercedes endmacro."
                /call LoadIni AFKTools InactivityCampMins   int         0
                /if (${InactivityCampMins}) {
                    /varset InactivityCampSecs ${Math.Calc[${InactivityCampMins}*60]}
                }

            }
            | ************************* KCond ************************************|
            /if (${Select[${command2},all,conditions]}) {
                /if (${Defined[Cond]}) /deletevar Cond
                /call LoadIni KConditions ConOn             int         0
                /call LoadIni KConditions CondSize          int         5
                /declare Cond[${CondSize}]                  string      outer
                /call LoadIni KConditions Cond              string      TRUE      Cond
            }
            | Re-figure Declared variables if needed.
            /if (${Select[${command2},all,pull]}) {
                /if (${PullPause.Find[|cond]}) {
                    /squelch /engine parser 2
                    /varset CondNo ${PullPause.Mid[${Math.Calc[${PullPause.Find[|cond]}+5]},3]}
                    /varset PullHoldCond ${Parse[1,${Cond[${CondNo}]}]}
                    /squelch /engine parser 1
                } else {
                    /varset PullHoldCond FALSE
                }
            }
            /if (!${skipIniCheck}) {
                /echo Checking your ini file for errors.
                /call ScanIni ${command2}
            }
			
        }
		POPCALL
        DEBUGN Settings: 1: ${command1} 2: ${command2} procesed
    /return

| ----------------------------------------------------------------------------
| SUB: DeclareOuters
| ----------------------------------------------------------------------------
    Sub DeclareOuters(string declareFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        | Do Not Edit These *****************************************************|
        /if (${declareFlag.Equal[pre]}) {
			|
			| Added boot flag
			|
			/declare KACharIniDir			string		outer		aka\chars\${EverQuest.Server}\
			/declare KAAddonsDir			string		outer		aka\addons\
			/declare KALibDir				string		outer		aka\lib\
			/declare KADataDir				string		outer		aka\data\
			/declare KABuffsIni				string		outer		${KADataDir}aKissAssist_Buffs.ini
			/declare BootCompleted			int			outer		0
			/declare BootTime				int			outer		${EverQuest.Running}
            /declare BroadCastSay           string      outer       bc
            /declare CampXLoc               int         outer       ${Me.X}
            /declare CampYLoc               int         outer       ${Me.Y}
            /declare CampZLoc               int         outer       ${Me.Z}
            /declare CampZone               int         outer       ${Zone.ID}
			
			| All Debug vars must have *only* the first letter capitalized. E.g. HealSingle won't be found but Healsingle will.
			
            /declare Debug                  int         outer       0
            /declare DebugAllOn             int         outer       0
            /declare DebugBuffs				int         outer       0
            /declare DebugCast              int         outer       0
            /declare DebugChainp            int         outer       0
            /declare DebugCombat            int         outer       0
			/declare DebugCures				int			outer		0
            /declare DebugGive 	            int         outer       0
            /declare DebugHeals             int         outer       0
			/declare DebugHealsingle		int			outer		0
			/declare DebugHealgroup			int			outer		0
			/declare DebugMain				int			outer		0
            /declare DebugMed               int         outer       0
            /declare DebugMez               int         outer       0
            /declare DebugMove              int         outer       0
            /declare DebugPet               int         outer       0
			/declare DebugPetcombat			int			outer		0
            /declare DebugPull              int         outer       0
			/declare DebugRez				int			outer		0
            /declare DebugRk                int         outer       0
			/declare DebugTarget			int			outer		0
            /declare DebugTime              int         outer       0
            /declare DebugLogging           int         outer       0
            /declare ForceAlias             int         outer       1
            /declare GoMTimer               timer       outer       0
			|
			| Flags to enable group class detection.
			|
			/declare GroupHasABER			int			outer		0
			/declare GroupHasABRD			int			outer		0
			/declare GroupHasABST			int			outer		0
			/declare GroupHasACLR			int			outer		0
			/declare GroupHasAENC			int			outer		0			
			/declare GroupHasADRU			int			outer		0
			/declare GroupHasAMAG			int			outer		0
			/declare GroupHasAMNK			int			outer		0			
			/declare GroupHasANEC			int			outer		0
			/declare GroupHasAPAL			int			outer		0
			/declare GroupHasARNG			int			outer		0			
			/declare GroupHasAROG			int			outer		0
			/declare GroupHasASHD			int			outer		0
			/declare GroupHasASHM			int			outer		0
			/declare GroupHasAWAR			int			outer		0			
			/declare GroupHasAWIZ			int			outer		0
			|
			| This happens on death etc.
			|
			/declare GroupHasANULL			int			outer		0
            /declare IAmABard               bool        outer       ${Me.Class.Name.Equal[Bard]}
			/declare IAmAMage				bool		outer		${Me.Class.Name.Equal[Magician]}
			/declare IAmAEnch				bool		outer		${Me.Class.Name.Equal[Enchanter]}
			/declare IAmANec				bool		outer		${Me.Class.Name.Equal[Necromancer]}
            /declare IniFileName            string      outer
            /declare InactivityEndSecs      int         outer       0
            /declare InactivityCampSecs     int         outer       0
            /declare KissAssistVer          string      outer
            /declare KissRevision          	string      outer       012AN
            /declare LookForward            int         outer       ${Me.Heading.DegreesCCW}
            /declare LoadFromINI            int         outer       0
			|
			| Flag to enable MyMainloopSubs routines
			|
			/declare MyMainloopSubsOn		int			outer		0
			|
			|
			| Number of parameters set when loaded.
			|
			/declare NumParams				int			outer		0
			/declare ShortMacroName			string		outer		aka
            /declare MacroName              string      outer       aKissAssist
            /declare BuffFileName           string      outer       ${KADataDir}${MacroName}_Buffs.ini
            /declare InfoFileName           string      outer       ${KADataDir}${MacroName}_Info.ini
            /declare MacroVer               string      outer       13
            /declare Parse0                 bool        outer       TRUE
            /declare PIniSet                int         outer       0
			|
			| When we start, what target are we looking at? Used when ma not provided as param
			|
			/declare StartupTarget			string		outer		${Target.CleanName}
            /declare ZoneName               string      outer       ${Zone}
        } else /if (${declareFlag.Equal[main]}) {
            /declare AddSpam                timer       outer       0
            |
			| AddsArray and MezArray use same functions. Leave both at 7 columns.
			|
			/declare AddsArray[50,7]        string      outer       NULL
            /declare AdvpathPointNum        int         outer       0
            /declare AdvpathPointX          float       outer       0
            /declare AdvpathPointY          float       outer       0
            /declare AdvpathPointZ          float       outer       0
            /declare AEDisplayMobInfo       int         outer       0
            /declare AggroOffTimer          timer       outer       0
            /declare AggroTargetID          string      outer
            /declare AggroTargetID2         string      outer       0
            /declare AmmoSwitch             int         outer       0
            /declare Attacking              int         outer       0
            /declare AutoRezAll             int         outer       0
			|
			| Standard KA targetting is 1, to allow manual targetting 0
			|
			/declare AutoTargetOn			int			outer		1
            /declare BagNum                 int         outer       0
            /declare BagNumLast             int         outer       0
            /declare BeforeArray[5]         string      outer       null
            /declare BeginMobID             string      outer
            /declare Banestrike             string      outer
            /declare BardStartTwist         int         outer       0
            /declare BardWasTwisting        string      outer       null
            /declare BindActive             int         outer       0
            /declare BurnActive             int         outer       0
            /declare BurnCalled             int         outer       0
            /declare BurnOn                 int         outer       1
            /declare BurnID                 int         outer       0
            /declare BlockedBuffsCount      int         outer       0
            /declare CalledTargetID         int         outer       0
            |/declare CalmCount              int         outer       0 
            /declare CampOnDeathTimer       timer       outer       0
            /declare CampfireClickTimer     timer       outer       0
            /declare CampfireTimer          timer       outer       0
            /declare CantHit                int         outer       0
            /declare CantSee                int         outer       0
            /declare CastResult             string      outer
            /declare castReturn             string      outer       CAST_CANCELLED
            /declare CheckResisted          int         outer       0
            /declare ChainPullTemp          string      outer
            /declare CheckOnReturn          int         outer       0
            /declare CleanBuffsTimer        timer       outer       0
            /declare ClearSpawnValue        spawn       outer
            /declare ColorIdx               int         outer       0
            /declare ColorList              string      outer       tWgtuwyr
            /declare CombatStart            int         outer       0
            /declare ConColor               string      outer       t
            /declare CorpseRezCheck         string      outer       null
			|
			| Timer for how often to check cures and mez
			|
			/declare CheckBuffsTimerOn		timer		outer		0
			/declare CheckCuresTimerOn		timer		outer		0
			/declare CheckCastManaTimerOn	timer		outer		0
			/declare CheckCastManaTime		int			outer		1
			/declare CheckMezTimerOn		timer		outer		0			
            /declare CursorID               int         outer       0
            /declare CursorIDCount          int         outer       0
            /declare CursorIDTimer          timer       outer       0
            /declare DebuffCount            int         outer       0
            /declare DebugTicker            timer       outer       0
            /declare DMZ                    int         outer       ${Select[${Zone.ID},345,344,202,203,279,151,33506]}
            /declare DNout                  string      outer       null
            /declare DontMoveMe             int         outer       0
            /declare DPSPaused              int         outer       0
			|
			| If we get hit, add a short delay between combat attacks to allow tank to regain agro.
			|
			/declare DPSRateDelay			int			outer		0
            /declare DPSSpam                int         outer       0
            /declare DPSTwisting            int         outer       0
            /declare DPSWriteOn             int         outer       0
            /declare DragCorpse             int         outer       0
            /declare DStickHow              string      outer       0
            /declare DurationMod            float       outer       1
            /declare EventByPass            int         outer       0
            /declare EventFlag              int         outer       0
            /declare EventTimer             timer       outer       0
            /declare EngageWaitTimer        timer       outer       0
            /declare ExtendedBuffList       string      outer
            /declare FailCounter            int         outer       0
            /declare FailMax                int         outer       3
            /declare GemSlots               int         outer       8
			|
			| To reduce the spam of assist messages
			|
			/declare GetTheLooseMobAlertOn	timer		outer		0
            /declare GMailEvents            string      outer
            /declare GSent                  int         outer       0
            /declare GoMActive              int         outer       0
            /declare GoMByPass              int         outer       0
            /declare GotHitToggle           int         outer       0
            /declare GlobalIndex            int         outer       0
            /declare HasBuffDuration        int         outer       0
            /declare HealAgain              int         outer       0
            /declare HealRemChk1            string      outer       Divine Barrier
            /declare HealRemChk2            string      outer       Touch of the Divine
            /declare HealRemChk3            string      outer       null
			|
			| So the rezzer stops prematurely buffing...
			|
			/declare HoldBuffsRezzing  		int			outer		0
            /declare IAMCastingID           int         outer       0
            /declare IAmDead                int         outer       0
			| MA States
            /declare IAmMA                  int         outer       0
			/declare IWasMA					int			outer		0
			/declare IBeganAsMA				int			outer		0
            /declare IniNextTimer           timer       outer       0
			|
			| Outer vars for pet toys
			|
			/declare IsAPet					int			outer		0
			/declare IsAPC					int			outer		0
            /declare IsFriendlyIDList       string      outer
            /declare IsHostileIDList        string      outer
            /declare IsMaybeHostileIDList   string      outer
            /declare ItemsGiven             int         outer       0
            /declare JoinedParty            timer       outer       0
            /declare JustZoned              timer       outer       0
            /declare KABegActive            int         outer       0
            /declare KAPetBegActive         int         outer       0
            /declare KABegForList           string      outer
            /declare KABegForPetList        string      outer
            /declare LastDPSCast            string      outer
            /declare CheckHealthTimerOn     timer       outer       0
			|
			| Timer for pet healing
			|
			/declare PetHealTimerOn		timer		outer		0
            /declare LastMobPullID          int         outer       0
			|
			| When did we last move, and where were we?
			|
			/declare LastSitStand			bool		outer		${Me.Sitting}
			/declare LastMoveHeading		float		outer		0.0
			/declare LastMoveX				float		outer		0.0
			/declare LastMoveY				float		outer		0.0
			/declare LastMoveZ				float		outer		0.0
			/declare LastMoveTime			int			outer		${EverQuest.Running}
			/declare TimeSinceMove			int			outer		60
            /declare LastResisted           int         outer
            /declare LastTargetID           int         outer
            /declare LastZone               int         outer       ${Zone.ID}
            /declare LooterAssigned         int         outer       0
            /declare MacroReturn            string      outer
            /declare MainAssist             string      outer
            /declare MainAssistClass        string      outer
            /declare MainAssistType         string      outer
			|
			| The purpose of MainAssistTank is to discern whether the PET or PC is the tank.
			|
			/declare MainAssistTank			string		outer
            /declare MapSet                 int         outer       0
            /declare MashArray[10]          string      outer       null
            /declare MedStat                string      outer
            /declare MedStat2               string      outer       Endurance
            /declare Medding                int         outer       0
            /declare MercAssisting          int         outer       0
            /declare MercInGroup            int         outer       0
            /declare MezAETimer             timer       outer       0
			|
			| Cols 1=id, 2=level, 3=cleanname, 4=mezimmune, 5=tashed, 6=maloed, 7=slowed
			|
            /declare MezArray[13,7]         string      outer       NULL
            /declare MezBroke               int         outer       0
            /declare MezImmuneIDs           string      outer
            /declare MezMobAECount          int         outer       0
            /declare MezMobCount            int         outer       0
            /declare MezMobDone             int         outer       0
            /declare MezMobFlag             int         outer       0
            /declare MezMod                 int         outer       0
            /declare MissingComponent       int         outer       0
            /declare MobCount               int         outer       0
            /declare MobFlag                int         outer       1
            /declare MobsToIgnoreByID       string      outer       null
            /declare MountOn                int         outer       1
            /declare MQ2MeleeReload         int         outer       0
            /declare MQ2CastReload          int         outer       0
            /declare MyAAExp                float       outer       ${Me.PctAAExp}
            /declare MyExp                  float       outer       ${Me.PctExp}
            /declare MyMerc                 string      outer       0
            /declare MyOriginalRole         string      outer
			| Used to detect if we were rezed
			/declare MyOriginalSpawnID		int			outer		${Me.ID}
            /declare MyTargetID             int         outer       0
            /declare MyTargetName           string      outer       0
            /declare NamedCheck             int         outer       0
            /declare NeedCuring             int         outer       0
            /declare OrigRanged             string      outer       ${Me.Inventory[ranged].Name}
            /declare OriginalMA				string		outer		null
			|
			| My pet's name
			|
			/declare MyPetName				string		outer		null
            /declare PetActiveState         int         outer       0
            /declare PetAttack              timer       outer       0
            /declare PetAttackRange         int         outer       0
            /declare CheckPetBuffsTimerOn    timer       outer       0
			|
			| Moved to ini
			|
            |/declare PetFocusOn             int         outer       0
            /declare PetFollowTimer         timer       outer       60s	
            /declare PetSuspendState        int         outer       0
            /declare PetTanking             int         outer       0
			|
			| Toy Request Timer
			|
			/declare PetToysTimer			timer		outer		0
			/declare PetToysGiveup			int			outer		0
			/declare PetSummonSuspendTM		timer		outer		0
			|
			| Moved PetTauntOn to ini
			|
            |/declare PetTauntOn          int         outer       0
            /declare PetTotCount            int         outer       0
            /declare PetToyList             string      outer        
			|
			| If pettoys gets interrupted, we can clean up.
			|
			/declare PetToysResumeStep		int			outer		0
			/declare PetToysResumeBagNum	int			outer		0
			|
			| For short term pauses due to buffing, pet gear, or just plain standby.
			|
			/declare PleaseWaitTimerOn	    timer		outer		0
			|
			| When char dies it can first cast priority spells.
			|
			/declare PriorityBuffsDone      int			outer		0
            /declare PullDoManualPull       int         outer       0
            /declare PullAggroTargetID      string      outer
            /declare PullAlertTimer         timer       outer       0
            /declare PullAmmo               string      outer       NULL
            /declare Pulled                 int         outer       0
            /declare PullHeading            float       outer       0
            /declare PullLSide              float       outer       0
            /declare PullRSide              float       outer       0
            /declare PullHold               int         outer       0
            /declare PullHoldCond           string      outer       0
            /declare PullIgnore1            string      outer       NULL
            /declare PullIgnore2            string      outer       NULL
            /declare PullIgnore3            string      outer       NULL
            /declare Pulling                int         outer       0
            /declare PullItem               string      outer       NULL
            /declare PullMax                int         outer       0
            /declare PullMaxCount           int         outer       500
            /declare PullMin                int         outer       0
            /declare PullMob                int         outer       0
            /declare PullMoveUse            string      outer
            /declare PullNavDistance        int         outer       0
            /declare PullPathArrayX[999]    float       outer
            /declare PullPathArrayY[999]    float       outer
            /declare PullPathArrayZ[999]    float       outer
            /declare PullPathWpCount        int         outer       0
            /declare PullSearchIter         int         outer       1
            /declare PullRange              int         outer       0
            /declare PullTimer              timer       outer       0
            /declare PullTooFar             int         outer       0
            /declare PullWithAlt            string      outer       Melee
            /declare PullWaitTimer1         timer       outer       0
            /declare PullWaitTimer2         timer       outer       0
            /declare PullXPCheck            int         outer       1
            /declare p_AssistAt             int         outer       0
            /declare p_PullPath             string      outer       null
            /declare p_Role                 string      outer       null
            /declare RangedSwitch           int         outer       0
            /declare ReMemCast              int         outer       0
            /declare ReMemCastLW            int         outer       0
            /declare ReMemWaitLong          string      outer       null
            /declare ReMemWaitShort         string      outer       null
            /declare ReadBuffsTimer         timer       outer       0
            /declare Redguides              int         outer       1
            /declare RememberCamp           int         outer       0
			|
			| Rez check timer
			|
			/declare RezCheckTimerOn		timer		outer		0
            /declare SearchType             string      outer
            /declare SHealPct               int         outer
            /declare SingleHealPoint        int         outer       0
            /declare SingleHealPointMA      int         outer       0
			/declare SingleHealPointPet		int			outer		0
            /declare SingleHealPointRange   int         outer       0
            /declare SpamTimer              timer       outer       0
            /declare SpamTimer1             timer       outer       0
            /declare SpamTimer2             timer       outer       0
            /declare SpellReadyL            int         outer       0
            /declare StickDist              int         outer       13
            /declare StickDistUW            int         outer       10
            |
            | This will be used to provide params to subs in the mainloop.
            | Binds will populate the array and return rather than directly
            | invoking the subs.
            | 
            | 1: CheckBuffs
            |
            /declare SubParamsCache[1]      string      outer       |
            /declare TankTimer              timer       outer       0
            /declare TempAmmo               string      outer       ${Me.Inventory[ammo].Name}
            /declare TempMaxRadius          int         outer       0
            /declare ToClose                int         outer       0
            /declare TributeTimer           timer       outer       0
            /declare Twisting               int         outer       0
            /declare TwistHold              int         outer       0
            /declare ValidTarget            int         outer       0
            /declare WasTwisting            bool        outer       FALSE
            /declare WaitTimer              timer       outer       0
            /declare WeaveArray[50]         string      outer       null
            /declare WhoToChase             string      outer
            /declare WorkSpawn              spawn       outer
            | Radius we use in place of MaxRadius when we are calculating.
            /declare WorkingMaxRadius       int         outer       0
            /declare WriteBuffsMercTimer    timer       outer       0
            /declare WriteBuffsPetTimer     timer       outer       0
            /declare WriteBuffsTimer        timer       outer       0
            /declare XSlotTotal             int         outer       13
            /declare XTSlot                 int         outer       0
            /declare XTSlot2                int         outer       0
            /declare XTarAutoSet            int         outer       1
            /declare XTarToWatch[20]        int         outer       0
            /declare ZDist                  float       outer       0
			/declare ZoneText				string		outer
        } else /if (${declareFlag.Equal[post]}) {
            /declare ReMemMiscSpell         string      outer       ${Me.Gem[${MiscGem}].Name}
            /declare ReMemMiscSpellLW       string      outer       ${Me.Gem[${MiscGemLW}].Name}
            /declare WayPointZRange         int         outer       ${MaxZRange}
        } else /if (${declareFlag.Equal[global]}) {
            /if (!${Defined[k_globals]}) {
                /declare k_globals          int         global      2
                /declare g_PetToysGave      string      global
				/if (!${Defined[g_ExtendedBuffList]}) {
					/declare g_ExtendedBuffList string      global
				}
            } else /if (${k_globals}==1) {
				/if (!${Defined[g_ExtendedBuffList]}) {
					/declare g_ExtendedBuffList string      global
				}
                /varset k_globals 2
            }
        }
    DEBUGN Misc Declares Processed
    /return

| -----------------------------------------------------------------------------
| Sub:FindCharIni
| -----------------------------------------------------------------------------
	Sub FindCharIni

		| if Kiss finds a Kissassist_ServerName_ToonName.ini file it will use that one.
	
		| Users might copy their files into the root directory with kissassist.mac
		| or they might copy them into /chars
		| or ideally they copy them into the /chars/server dir
		| It is desirable to take chars that have been placed at the root or /chars
		| and copy them to the /chars/server dir, somehow. User may need to do it

		/declare IniFound		    int		local	0
		/declare SafeIniName	    string	local
        /declare UseServerNameDir   int     local   USE_SERVER_NAME_DIR
        /declare MyName             string  local   ${Me.CleanName}

        /if (${MyName.Find['s corpse]}) {
            /varset MyName ${MyName.Left[-9]}
        }

		| If the INI is found, it will automatically be completed with dirs
		/varset IniFileName ${MacroName}_${EverQuest.Server}_${MyName}.ini
		/call TryCharIni ${IniFileName}
		/varset IniFound ${Macro.Return}
		
		/if (!${IniFound}) {
            /varset IniFileName ${MacroName}_${MyName}.ini
			/call TryCharIni ${IniFileName}
			/varset IniFound ${Macro.Return}
		}

        | Set the name of the new INI
        /if (!${IniFound}) {
            /if (${UseServerNameDir}==1) {
                /varset IniFileName ${KACharIniDir}${MacroName}_${EverQuest.Server}_${MyName}.ini
            } else {
                /varset IniFileName ${MacroName}_${EverQuest.Server}_${MyName}.ini
            }
        }
	
	/return ${IniFound}	
| ----------------------------------------------------------------------------
| SUB: Find Group heals
| ---------------------------------------------------------------------------
    Sub FindGroupHeals
        /if (!${Select[${Me.Class.ShortName},BST,CLR,SHM,DRU,PAL]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN Enter FindGroupHeals
        /declare i int local
        /declare j int local
        /declare GHCount int 0
        /declare HealSpell string  local
        /for i 1 to ${Heals.Size}
            /varset HealSpell ${Heals[${i}].Arg[1,|]}
            DEBUGN ${HealSpell}
            /if (!${HealSpell.Length} || ${HealSpell.Equal[null]} || ${Select[${Spell[${HealSpell}].TargetType},Single,Self]} || ${Spell[${FindItem[=${HealSpell}].Spell}].TargetType.Find[self]} || ${HealSpell.Find[Aegis of Superior Divinity]} || ${HealSpell.Find[Harmony of the Soul]}) /continue
            /if (${HealSpell.Find[Burst of Life]} || ${HealSpell.Find[Focused Celestial Regeneration]}) /continue
            /if (${Me.Class.Name.Equal[Shaman]} && ${Spell[${HealSpell}].Name.Find[Intervention]} || ${Me.Class.Name.Equal[Druid]} && ${Spell[${HealSpell}].Name.Find[Survival]}) /continue
            /if (${Spell[${HealSpell}].TargetType.Find[group v]} || ${Spell[${FindItem[=${HealSpell}].Spell}].TargetType.Find[group v]} || ${Spell[${HealSpell}].TargetType.Find[Targeted AE]} && !${Select[${Heals[${i}].Arg[3,|]},MA,ME]}) {
                /varcalc GHCount ${GHCount}+1
                /varset GroupHeal[${GHCount}] ${Heals[${i}]}
            }
        /next i
        DEBUGN ${GHCount}
        /if (${GHCount}) {
            /call SortArray GroupHeal 100|100 >
            /for j 1 to ${GroupHeal.Size}
                DEBUGN ${j} ${GroupHeal[${j}]} ${Spell[${GroupHeal[${j}].Arg[1,|]}].CastTime.Float} ${Spell[${GroupHeal[${j}].Arg[1,|]}].Duration}
            /next j
        }
		POPCALL
        DEBUGN Leave FindGroupHeals
    /return
	
| ----------------------------------------------------------------------------
| SUB: Find single heals - seperate single heals from group heals
| ---------------------------------------------------------------------------
    Sub FindSingleHeals
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN Enter FindSingleHeals
        /declare i int local
        /declare j int local
        /declare SHCount int 0
        /declare HealHighPoint int  local 0
        /declare HealHighestPoint int  local 0
        /declare HealHighestPointMA int  local 0
        /declare HealPointTag string  local 0
        /declare HealSpell string  local
        /declare HealSpellRange int local 0
        /for i 1 to ${Heals.Size}
            /varset HealSpell ${Heals[${i}].Arg[1,|]}
            /varset HealPointTag ${Heals[${i}].Arg[3,|]}
            /if (${HealPointTag.Equal[MA]}) {
                /varset HealHighestPointMA ${Heals[${i}].Arg[2,|]}
            } else {
                /varset HealHighPoint ${Heals[${i}].Arg[2,|]}
            }
            /varset HealSpellRange ${Int[${Spell[${HealSpell}].Range}]}
            DEBUGN ${i} ${HealSpell} ${Spell[${HealSpell}].TargetType} ${Select[${Spell[${HealSpell}].TargetType},Single,Self]}
            /if (${HealSpell.Find[Aegis of Superior Divinity]} || ${HealSpell.Find[Harmony of the Soul]} || ${HealSpell.Find[Burst of Life]} || ${HealSpell.Find[Focused Celestial Regeneration]}) {
                /varcalc SHCount ${SHCount}+1
                /varset SingleHeal[${SHCount}] ${Heals[${i}]}
            } else /if (${Select[${Me.Class.Name},Druid,Shaman]} && (${HealSpell.Find[Intervention]} || ${HealSpell.Find[Survival]})) {
                /varcalc SHCount ${SHCount}+1
                /varset SingleHeal[${SHCount}] ${Heals[${i}]}
            } else /if (${Select[${Spell[${HealSpell}].TargetType},Single,Self]} || ${Spell[${FindItem[=${HealSpell}].Spell}].TargetType.Find[single]} || ${Spell[${FindItem[=${HealSpell}].Spell}].TargetType.Find[self]} || ${Heals[${i}].Arg[3,|].Find[tap]} || ${Heals[${i}].Arg[3,|].Find[pet]} || ${Spell[${HealSpell}].TargetType.Find[Targeted AE]} && ${Select[${Heals[${i}].Arg[3,|]},MA,ME,pet]}) {
                /varcalc SHCount ${SHCount}+1
                /varset SingleHeal[${SHCount}] ${Heals[${i}]}
            } else /if (${Spell[${HealSpell}].TargetType.Equal[Free Target]}) {
                /varcalc SHCount ${SHCount}+1
                /varset SingleHeal[${SHCount}] ${Heals[${i}]}
            }
            /if (${HealPointTag.NotEqual[MA]} && ${HealHighPoint}>${SingleHealPoint}) /varset SingleHealPoint ${HealHighPoint}
            /if (${HealPointTag.Equal[MA]} && ${HealHighestPointMA}>${SingleHealPointMA}) /varset SingleHealPointMA ${HealHighestPointMA}
            /if (${HealSpellRange}>${SingleHealPointRange}) /varset SingleHealPointRange ${HealSpellRange}
            DEBUGN ${SingleHealPoint} ${SingleHealPointRange}
        /next i
        /if (${SHCount}) /call SortArray SingleHeal 100|100 >
        /if (!${SingleHealPoint}) /varset SingleHealPoint 99
        /if (!${SingleHealPointMA}) /varset SingleHealPointMA ${SingleHealPoint}
        /if (!${SingleHealPointRange}) /varset SingleHealPointRange 200
        /if (${Debug}) {
        /for j 1 to ${SingleHeal.Size}
            DEBUGN ${j} ${SingleHeal[${j}]} ${Spell[${SingleHeal[${j}].Arg[1,|]}].CastTime.Float} ${Spell[${SingleHeal[${j}].Arg[1,|]}].Duration}
        /next j
        }
		POPCALL
        DEBUGN Leave FindSingleHeals
    /return
	
| ----------------------------------------------------------------------------
| SUB: Fix Burn Spells
| ----------------------------------------------------------------------------
    Sub FixBurnSpells
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /declare i        int    local 0
        /declare CondNo   int    local 0
        /declare BurnArg1 string local
        /declare BurnArg2 string local
        /declare BurnArg3 string local
        /for i 1 to ${Burn.Size}
            /if (${Burn[${i}].NotEqual[null]}) {
                /if (${Burn[${i}].Find[|cond]}) {
                    /varset CondNo ${Burn[${i}].Mid[${Math.Calc[${Burn[${i}].Find[|cond]}+5]},3]}
                } else {
                    /varset CondNo 0
                }
                /varset BurnArg1 ${Burn[${i}].Arg[1,|]}
                /if (${Select[${Burn[${i}].Arg[2,|]},mob,me,ma,pet]}) {
                    /varset BurnArg2 ${Burn[${i}].Arg[2,|]}
                } else {
                    /varset BurnArg2 mob
                }
                /if (${Select[${Burn[${i}].Arg[3,|]},1,2,3]}) {
                    /varset BurnArg3 ${Burn[${i}].Arg[3,|]}
                } else {
                    /varset BurnArg3 1
                }
                /if (${CondNo}) {
                    /varset Burn[${i}] ${BurnArg1}|${BurnArg2}|${BurnArg3}|cond${CondNo}
                } else {
                    /varset Burn[${i}] ${BurnArg1}|${BurnArg2}|${BurnArg3}
                }
            }
        /next i
    /return

| ----------------------------------------------------------------------------
| SUB: Ini Cleanup / Fix ini / Deprecated settings / clean ini
| ----------------------------------------------------------------------------
    Sub IniCleanup
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /declare ICidx 		int 	local 0
        /declare ICtemp 	string 	local null
		/declare TempStr	string	local
		
        | General Section
        /ini "${IniFileName}" "General" "ConditionsOn" NULL
        /ini "${IniFileName}" "General" "MiscGem" NULL
        /ini "${IniFileName}" "General" "MiscGemLW" NULL
        /ini "${IniFileName}" "General" "MiscGemRemem" NULL
        /ini "${IniFileName}" "General" "CastingInterruptOn" NULL
        /ini "${IniFileName}" "General" "DPSMeter" NULL

        | Buffs Section
        | Melee Section
        /ini "${IniFileName}" "Melee" "BeforeCombat" NULL
        | AE Section
        /ini "${IniFileName}" "AE" "AECOn" NULL
        | DPS Section
        /ini "${IniFileName}" "DPS" "DPSCOn" NULL
        | Aggro Section
        /ini "${IniFileName}" "Aggro" "AggroCOn" NULL
        /ini "${IniFileName}" "Aggro" "Aggro2nd" NULL
        | Heals section
        /ini "${IniFileName}" "Heals" "HealsCOn" NULL
        /ini "${IniFileName}" "Heals" "XTarWatch2" NULL
        /ini "${IniFileName}" "Heals" "AutoRez" NULL
        /ini "${IniFileName}" "Heals" "AutoRez1" NULL
        /ini "${IniFileName}" "Heals" "AutoRez2" NULL
        /ini "${IniFileName}" "Heals" "AutoRez3" NULL
        /ini "${IniFileName}" "Heals" "XTarHeal" NULL
        /ini "${IniFileName}" "Heals" "XTarHealList" NULL

        | Burn Section
        /ini "${IniFileName}" "Burn" "BurnCOn" NULL
        | GOM Section
        /ini "${IniFileName}" "GOM" "GOMCOn" NULL
		
		| Pet Section
		/varset TempStr ${MoveWhenHit}
		/call LoadIni Pet MoveWhenHit
		/if (${Select[${MoveWhenHit},0,1]}) {
			/ini "${IniFileName}" "Pet" "MoveWhenHit" NULL
			/ini "${IniFileName}" "Melee" "MoveWhenHit" ${MoveWhenHit}
		} else {
			/varset MoveWhenHit ${TempStr}
		}
		
        | Pull Section
        /ini "${IniFileName}" "Pull" "ChainPullPause" NULL
        | Old SpellSet section. Was moved to Spells section.
        /ini "${IniFileName}" "SpellSet" NULL
        | My Spells Section
        /varset ICtemp ${Ini[${IniFileName},MySpells,Gem1,BLANK]}
        /if (${ICtemp.Length}>0 && ${Select[${ICtemp},blank,null]}==0) {
            /for ICidx 1 to 13
                /varset ICtemp ${Ini[${IniFileName},MySpells,Gem${ICidx},NULL]}
                /ini "${IniFileName}" "Spells" "Gem${ICidx}" "${ICtemp}"
            /next ICidx
            /ini "${IniFileName}" "MySpells" NULL
        }
    /return

| ----------------------------------------------------------------------------
| SUB: Kiss Conditions
| ----------------------------------------------------------------------------
    Sub KissConditons
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
        /call LoadIni KConditions Cond              string      TRUE      Cond
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: LoadAliases
| ----------------------------------------------------------------------------
    Sub LoadAliases
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
    | ************************* Aliases **************************************|
        DEBUGN Ini/Alias info ${KissAssistVer.NotEqual[${MacroVer}.${KissRevision}]} "${KissAssistVer}" "${MacroVer}.${KissRevision}"
        /if (${KissAssistVer.NotEqual[${MacroVer}.${KissRevision}]} || ${ForceAlias}) {
            /if (${ForceAlias}) {
                /echo Resetting Aliases this can take up to 1 min
            } else {
                /echo Version Mismatch Detected, Resetting Aliases this can take up to 1 min
            }
            /squelch /alias /afktoolson     /changevarint AFKTools AFKToolsOn
            /squelch /alias /assistat       /changevarint Melee AssistAt
            /squelch /alias /autofireon     /togglevariable AutoFireOn
            /squelch /alias /autorezon      /togglevariable AutoRezOn
            /squelch /alias /buffson        /togglevariable BuffsOn
            /squelch /alias /camphere       /togglevariable ReturnToCamp
            /squelch /alias /campradius     /changevarint General CampRadius
            /squelch /alias /chase          /togglevariable ChaseAssist
            /squelch /alias /chasedistance  /changevarint General ChaseDistance
            /squelch /alias /chaseoff       /changevarint General ChaseAssist 0
            /squelch /alias /chaseon        /changevarint General ChaseAssist 1
            /squelch /alias /debugall       /debug all
            /squelch /alias /dpsinterval    /changevarint DPS DPSInterval
            /squelch /alias /dpson          /changevarint DPS DPSOn
            /squelch /alias /dpsskip        /changevarint DPS DPSSkip
            /squelch /alias /dpsspam        /togglevariable DPSSpam
            /squelch /alias /dpswrite       /togglevariable DPSWriteOn
			/squelch /alias /givepettoys	/echo PetToysPlease
			/squelch /alias /givetoys		/echo PetToysPlease
			/squelch /alias /givebags		/echo PetToysPlease
            /squelch /alias /healson        /changevarint Heals HealsOn
            /squelch /alias /interrupton    /togglevariable CastingInterruptOn
            /squelch /alias /ktdismount     /echo KTDismount
            /squelch /alias /ktdoor         /echo KTDoorClick
            /squelch /alias /kthail         /echo KTHail
            /squelch /alias /ktinvite       /echo KTInvite
            /squelch /alias /ktsay          /echo KTSay
            /squelch /alias /kttarget       /echo KTTarget
            /squelch /alias /looton         /changevarint General LootOn
            /squelch /alias /maxradius      /changevarint Pull MaxRadius
            /squelch /alias /maxzrange      /changevarint Pull MaxZRange
            /squelch /alias /medcombat      /togglevariable MedCombat
            /squelch /alias /medstart       /changevarint General MedStart
            /squelch /alias /meleedistance  /changevarint Melee MeleeDistance
            /squelch /alias /meleeon        /togglevariable MeleeOn
            /squelch /alias /mercassistat   /changevarint Merc MercAssistAt
            /squelch /alias /mezon          /changevarint Mez MezOn
			/squelch /alias /modrods	    /echo ModRodsPlease
			/squelch /alias /modrodspls		/echo ModRodsPlease
			/squelch /alias /modrodsplz		/echo ModRodsPlease
			/squelch /alias /movewhenhit    /togglevariable MoveWhenHit
			/squelch /alias /pethold        /togglevariable PetHold
			/squelch /alias /peton          /togglevariable PetOn
			/squelch /alias /pettoyson      /togglevariable PetToysOn
			/squelch /alias /pettoys		/echo PetToysPlease			
			/squelch /alias /pettoysplz     /echo PetToysPlease
            /squelch /alias /rebuffon       /togglevariable RebuffOn
            /squelch /alias /returntocamp   /togglevariable ReturnToCamp
            /squelch /alias /rezallon       /togglevariable AutoRezAll 1
            /squelch /alias /rezalloff      /togglevariable AutoRezAll 0
            /squelch /alias /scatteron      /togglevariable ScatterOn
            /squelch /alias /setae          /iniwrite AE
            /squelch /alias /setaggro       /iniwrite Aggro
            /squelch /alias /setbackoff     /backoff
            /squelch /alias /setbuffs       /iniwrite Buffs
            /squelch /alias /setburn        /iniwrite Burn
            /squelch /alias /setcure        /iniwrite Cure
            /squelch /alias /setdps         /iniwrite DPS
            /squelch /alias /setheals       /iniwrite Heals
            /squelch /alias /katwistpause   /togglevariable TwistHold 1
            /squelch /alias /katwistresume  /togglevariable TwistHold 0
            /squelch /alias /switchma       /switchma
            /squelch /alias /waithere       /togglevariable waithere
            /squelch /alias /trackme        /trackmedown
            /squelch /alias /debug delete
            /squelch /alias /DEBUGBUFFS delete
            /squelch /alias /debugcombat delete
            /squelch /alias /debugcast delete
            /squelch /alias /debugchainpull delete
            /squelch /alias /debugheal delete
            /squelch /alias /debugmez delete
            /squelch /alias /debugmove delete 
            /squelch /alias /debugpull delete
            /squelch /alias /debugrk delete
            /squelch /alias /dpsspam delete
            /ini "${IniFileName}" "General" "KissAssistVer" "${MacroVer}.${KissRevision}"

        }
        DEBUGN Aliases processed
    /return
	
| ----------------------------------------------------------------------------
| SUB: Load Ini
| ----------------------------------------------------------------------------
    Sub LoadIni(string sectionName, string varName, string varType, string varValue, string varArray, string FileName, FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGN Enter from ${FromWhere}

        /if (${Debug}) {
            /delay 2
            /echo \atDEBUG Sub Loadini S:${sectionName} V1:${varName} V2:${varType} V3:${varValue} V4:${varArray}
        }
        /declare rkTemp                 string      local
        /declare UtilInt                int         local        0
        /declare FileName1              string      local        ${FileName}
        /declare RezCount               int         local        0
        | Assign ini name to default ini if not defined
        /if (${FileName1.Length}==0  || ${FileName1.Equal[NULL]}) {
            /varset FileName1 ${IniFileName}
        }
        | Check if ini value is asking for an array ie buff1 to buff20
        /if (${Bool[${varArray}]}) {
            /if (${${varArray}.Size}>0) {
                /declare i int local
                /for i 1 to ${${varArray}.Size}
                    /if (${sectionName.NotEqual[KConditions]}) {
                        /if (!${Ini[${FileName1},${sectionName},${varArray}${i}].Length}) {
                            /ini "${FileName1}" "${sectionName}" "${varArray}${i}" "${varValue}"
                        } else {
                            /varset ${varArray}[${i}] ${Ini[${FileName1},${sectionName},${varArray}${i}]}
                        }
                        /if (${${varArray}[${i}].NotEqual[null]} && ${${varArray}[${i}].Left[1].NotEqual[;]}) {
                            | find out if there is a Rank and fix spell name.
                            /if (${varType.Equal[string]} && ${Int[${${varArray}[${i}].Left[1]}]}==0) {
                                /call SpellRankCheck "${${varArray}[${i}]}" FROMHERE
                                /varset ${varArray}[${i}] ${Macro.Return}
                            }
                            | code to fix the Heal PCT for those zones Crypt of Sul, that knock your HPs down to
                            /if (${Int[${${varArray}[${i}].Arg[2,|].Left[1]}]}>0) {
                                /if (${sectionName.Equal[Heals]}) {
                                    /if (${${varArray}[${i}].Arg[3,|].Find[rez]}) {
                                        /varcalc RezCount ${RezCount}+1
                                        /if (${RezCount}<=${AutoRez.Size}) {
                                            /varset AutoRez[${RezCount}] ${${varArray}[${i}]}
                                            /varset ${varArray}[${i}] null
                                        }
                                    } else /if (${Select[${Zone.ID},795,796]}) {
                                        /varcalc UtilInt ${Int[${${varArray}[${i}].Arg[2,|]}]}*.7
                                        /varset ${varArray}[${i}] ${${varArray}[${i}].Replace[|${${varArray}[${i}].Arg[2,|]},|${UtilInt}]}
                                    }
                                } else /if (${sectionName.Equal[DPS]} && ${${varArray}[${i}].Arg[3,|].Equal[debuffall]}) {
                                    /varcalc UtilInt ${Int[${${varArray}[${i}].Arg[2,|]}]}+100
                                    /varset ${varArray}[${i}] ${${varArray}[${i}].Replace[|${${varArray}[${i}].Arg[2,|]},|${UtilInt}]}
                                } else /if (${sectionName.Equal[Aggro]} && ${${varArray}[${i}].Arg[3,|].Equal[<<]}) {
                                    /varcalc UtilInt ${Int[${${varArray}[${i}].Arg[2,|]}]}+100
                                    /varset ${varArray}[${i}] ${${varArray}[${i}].Replace[|${${varArray}[${i}].Arg[2,|]},|${UtilInt}]}
                                }
                            } else /if (${sectionName.Equal[Heals]}) {
                                /if (${${varArray}[${i}].Arg[3,|].Find[rez]}) {
                                    /varcalc RezCount ${RezCount}+1
                                    /if (${RezCount}<=${AutoRez.Size}) {
                                        /varset AutoRez[${RezCount}] ${${varArray}[${i}]}
                                        /varset ${varArray}[${i}] null
                                    }
                                }
                            }
                        } else {
                            /varset ${varArray}[${i}] null
                        }
                        DEBUGN Loadini: ${i} - ${varArray}[${i}] - ${${varArray}[${i}]}
                    } else {
                        /if (!${Ini[${FileName1},${sectionName},${varArray}${i}].Length}) {
                            /ini "${FileName1}" "${sectionName}" "${varArray}${i}" "${varValue}"
                        } else {
                            /varset ${varArray}[${i}]  ${Ini[${FileName1},${sectionName},${varArray}${i},NULL,noparse]}
                        }
                        DEBUGN ${varArray}[${i}]  ${Ini[${FileName1},${sectionName},${varArray}${i},NULL,noparse]}
                    }
                /next i
				POPCALL
                /return
            }
        } else {
            /if (!${Defined[${varName}]} && ${Select[${varType},string,float,int]}>0) /declare ${varName} ${varType} outer 0
                /if (!${Ini[${FileName1},${sectionName},${varName}].Length}) {
                    /if (${varValue.Length}) {
                        /ini "${FileName1}" "${sectionName}" "${varName}" "${varValue}"
                        /varset ${varName} ${varValue}
                        DEBUGN Sub Loadini /varset ${varName} ${varValue}
                    }
                } else {
                    /varset ${varName} ${Ini[${FileName1},${sectionName},${varName}]}
                }
                /if (${FileName1.Equal[${IniFileName}]}) {
                    /varset rkTemp ${${varName}}
                    | find out if there is a Rank and fix spell name.
                    /if (${varType.Equal[string]} && ${Int[${rkTemp.Left[1]}]}==0 && !${varName.Find[Help]}) {
                        /call SpellRankCheck "${${varName}}" FROMHERE
                        /if (${Macro.Return.NotEqual[null]}) /varset ${varName} ${Macro.Return}
                    }
                }
            DEBUGN Sub LoadIni: ${varName} - ${${varName}}
            /varset rkTemp
        }
		POPCALL
        DEBUGN Sub LoadIni: Leave
    /return

| ----------------------------------------------------------------------------
| SUB: LoadSpellSet
| ----------------------------------------------------------------------------
    Sub LoadSpellSet
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN LoadSpellSet Enter
        /declare GemNum      int local
        /declare ValidSpells int local 0

        DEBUGN Sub LoadSpellSet LoadSpellSet=(${LoadSpellSet})
        /varcalc GemSlots ${Int[${Me.AltAbility[Mnemonic Retention].Rank}]}+8
        /if (${LoadSpellSet}==1) {
            DEBUGN Sub LoadSpellSet SpellSetName=(${SpellSetName})
            /echo Memming spellset (${SpellSetName}).
            /memspellset ${SpellSetName}
            /delay ${Math.Calc[${GemSlots}*10]}
        } else {
            |---Test to see if we have MySpells section defined in INI or not.
            /for GemNum 1 to ${GemSlots}
                /call LoadIni Spells Gem${GemNum} string NULL
                /if (${Gem${GemNum}.Length} && ${Gem${GemNum}.NotEqual[NULL]}) {
                    |-- We have found a good spell defined, one good spell is all it takes to be a valid Spells config.
                    /varset ValidSpells 1
                    /break
                }
            /next GemNum
            /if (${LoadSpellSet}==2) {
                /if (!${ValidSpells}) {
                    /echo \ayYou have no valid spells defined in your ini file [Spells], load your spells now and do a /writespells command while in KissAsssist.
                } else {
                    /call Bind_MemMySpells ${Me.CleanName}
                }
            }
        }
        |-- If we called this routine, make sure we update values for ReMemMiscSpell and ReMemMiscSpellLW since they might have changed after spellset load.
        /varset ReMemMiscSpell ${Me.Gem[${MiscGem}].Name}
        /varset ReMemMiscSpellLW ${Me.Gem[${MiscGemLW}].Name}
		POPCALL
        DEBUGN LoadSpellSet Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Scan ini file for errors in spelling or missing items
| ----------------------------------------------------------------------------
    Sub ScanIni(string p_Sections)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare int_i             int    local 1
        /declare int_j             int    local 1
        /declare int_Count         int    local 0 
        /declare int_CountEntries  int    local 0
        /declare int_CountErrors   int    local 0
        /declare str_Sections      string local
        /declare str_Section       string local null
        /declare str_iniKey        string local
        /declare str_SummonedStuff string local null
        
        /if (!${p_Sections.Length} || ${p_Sections.Equal[null]} || ${p_Sections.Equal[all]}) {
            /varset str_Sections Buffs|DPS|Burn|Heals|AE|Cures|Pet|PetBuffs|GoM|Mez|Aggro|Pull
        } else {
            /varset str_Sections ${p_Sections}
        }
        
        /if (${str_Sections.Find[Buffs]}) {
            /for int_i 1 to ${BuffsSize}
                /varset str_iniKey ${Ini["${IniFileName}",Buffs,Buffs${int_i}]}
                /if (${str_iniKey.NotEqual[null]}) {
                    /if (${str_iniKey.Arg[2,|].Equal[summon]}) {
                        /if (${str_SummonedStuff.Equal[null]}) {
                            /varset str_SummonedStuff ${str_iniKey.Arg[3,|]}|
                        } else {
                            /varset str_SummonedStuff ${str_SummonedStuff}${str_iniKey.Arg[3,|]}|
                        }
                    }
                }
            /next int_i
        }

        /for int_j 1 to ${Math.Calc[${str_Sections.Count[|]}+1]}
            /varset str_Section ${str_Sections.Arg[${int_j},|]}
            /echo ---------------->> Scanning ${str_Section} <<----------------
            /varset int_CountEntries 0
            /varset int_CountErrors 0
            /if (${Select[${str_Section},Buffs,DPS,Burn,Heals,AE,Cures,PetBuffs,GoM,Aggro]}) {
                /varset int_Count ${str_Section}Size
            } else /if (${str_Section.Equal[Pet]}) {
                /varset int_Count 3
            } else /if (${str_Section.Equal[Mez]}) {
                /varset int_Count 2
            } else /if (${str_Section.Equal[Pull]}) {
                /varset int_Count 1
            } else {
                /continue
            }
            /for int_i 1 to ${int_Count}
                /if (${Select[${str_Section},DPS,Burn,Heals,AE,Cures,Aggro]}) {
                    /varset str_iniKey ${Ini["${IniFileName}",${str_Section},${str_Section}${int_i}]}
                } else /if (${str_Section.Equal[Buffs]}) {
                    /if (${Select[${str_iniKey.Arg[2,|]},summon,remove]}) {
                        /varset str_iniKey null
                    } else /if (${str_SummonedStuff.NotEqual[null]} && ${str_SummonedStuff.Find[${str_iniKey.Arg[1,|]}|]}) {
                        /varset str_iniKey null
                    } else {
                        /varset str_iniKey ${Ini["${IniFileName}",${str_Section},${str_Section}${int_i}]}
                    }
                } else /if (${str_Section.Equal[Pet]}) {
                    /if (${int_i}==1) {
                        /varset str_iniKey ${Ini["${IniFileName}",${str_Section},PetSpell]}
                    } else /if (${int_i}==2) {
                        /varset str_iniKey ${Ini["${IniFileName}",${str_Section},PetShrinkSpell]}
                    } else /if (${int_i}==3) {
                        /varset str_iniKey ${Ini["${IniFileName}",${str_Section},PetBreakMezSpell]}
                    } else {
                        /break
                    }
                } else /if (${str_Section.Equal[PetBuffs]}) {
                    /varset str_iniKey ${Ini["${IniFileName}",Pet,${str_Section}${int_i}]}
                } else /if (${str_Section.Equal[GoM]}) {
                    /varset str_iniKey ${Ini["${IniFileName}",${str_Section},GomSpell${int_i}]}
                } else /if (${str_Sections.Equal[Mez]}) {
                    /if (${int_i}==1) {
                        /varset str_iniKey ${Ini["${IniFileName}",${str_Section},MezSpell]}
                    } else /if (${int_i}==2) {
                        /varset str_iniKey ${Ini["${IniFileName}",${str_Section},MezAESpell]}
                    } else {
                        /break
                    }
                } else /if (${str_Sections.Equal[Pull]}) {
                    /varset str_iniKey ${Ini["${IniFileName}",${str_Section},PullWith]}
                }
                /if (${str_iniKey.Left[1].Equal[;]} || ${str_iniKey.Equal[null]}) /continue
                /while (1) {
                    DEBUGN ScanIni: ${str_Section}${int_i}=${str_iniKey}
                    | find out if there is a Rank and fix spell name.
                    /call SpellRankCheck "${str_iniKey}"
                    /varset str_iniKey ${Macro.Return}
                    DEBUGN ScanIni: ${str_iniKey} after return
                    /if (${str_iniKey.Find[|]}) /varset str_iniKey ${str_iniKey.Arg[1,|]}
                    /if (${str_iniKey.Find[Command:]}) /break
                    /if (${str_Section.Equal[GoM]} && ${str_iniKey.Find[Gift Of Mana]}) /break
                    /if (${str_Section.Equal[AE]} && ${str_iniKey.Find[Burn]}) /break
                    /if (${str_Section.Equal[Pull]} && ${Select[${str_iniKey},melee,pet]}) {
                        /varcalc int_CountEntries ${int_CountEntries}+1
                        /break
                    }
                    /if (!${Me.Book[${Spell[${str_iniKey}].RankName}]} && !${Me.CombatAbility[${str_iniKey}]} && !${Me.AltAbility[${str_iniKey}]} && !${FindItem[=${str_iniKey}].ID} && ${str_iniKey.NotEqual[banestrike]} && !${Me.Skill[${str_iniKey}]}) {
                        /echo ...ERROR: ${str_Section}${int_i}=${str_iniKey} unable to find as a AA, Combat Ability, Item, Skill, or Spell
                        /varcalc int_CountErrors ${int_CountErrors}+1
                    }
                    /varcalc int_CountEntries ${int_CountEntries}+1
                    /break
                }
            /next int_i
            /if (!${int_CountEntries}) {
                /echo -- Nothing defined in this section
            } else /if (!${int_CountErrors}) {
                /echo -- No Spelling Errors or Missing Items Detected
            }
        /next int_j
		POPCALL
    /return
	
| ----------------------------------------------------------------------------
| SUB: Sort Array
| ----------------------------------------------------------------------------
    Sub SortArray(ArrayName, HiLo, SortHow)
        /if (${${ArrayName}.Size}<2) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN SortArray Enter ${ArrayName} ${HiLo} ${SortHow}
        /declare i                  int     local
        /declare j                  int     local
        /declare k                  int     local
        /declare l                  int     local
        /declare m                  int     local
        /declare TempSortedName     string  local ${HiLo}
        /declare TempPos            int     local 0
        /declare NewArrayPos        int     local 0
        /declare NewArraySize       int     local 0
        /declare TempArray[${${ArrayName}.Size}] string     local 0
        /declare TArray2[${${ArrayName}.Size}]   string     local 0
        /declare CArray[${${ArrayName}.Size}]    string     local TRUE
        /declare MArrayCount int    local 1
        /declare WArrayCount int    local 1
        /declare BArrayCount int    local 1
        /declare TempSwapHold       string  local
        /declare Swapped            int     local 1
        | Assign Array to temp array
        /for i 1 to ${${ArrayName}.Size}
            DEBUGN ${i} ${${ArrayName}[${i}]}
            /varset TempArray[${i}] ${${ArrayName}[${i}]}
        /next i
        /if (${ArrayName.Equal[dps]}) {
            /for i 1 to ${TempArray.Size}
                /if (${TempArray[${i}].Find[|weave]} && ${TempArray[${i}].Arg[2,|].NotEqual[0]}) {
                    /varset WeaveArray[${WArrayCount}] ${TempArray[${i}].Replace[|weave,]}
                    DEBUGN ${WeaveArray[${WArrayCount}]}
                    /if (${WArrayCount}>1) /varset TempArray[${i}] NULL
                    /varcalc WArrayCount ${WArrayCount}+1
                } else /if (${TempArray[${i}].Find[|mash]} && ${TempArray[${i}].Arg[2,|].NotEqual[0]}) {
                    /varset MashArray[${MArrayCount}] ${TempArray[${i}].Replace[|mash,]}
                    DEBUGN ${MashArray[${MArrayCount}]}
                    /if (${MArrayCount}>1) /varset TempArray[${i}] NULL
                    /varcalc MArrayCount ${MArrayCount}+1
                } else /if (${TempArray[${i}].Find[|ambush]} && ${TempArray[${i}].Arg[2,|].NotEqual[0]}) {
                    /varset BeforeArray[${BArrayCount}] ${TempArray[${i}].Replace[|ambush,]}
                    DEBUGN ${BeforeArray[${BArrayCount}]}
                    /if (${BArrayCount}>1) /varset TempArray[${i}] NULL
                    /varcalc BArrayCount ${BArrayCount}+1
                }
            /next i
        }
        | Move Array to Temp Array leaving out useless entries.
        /for m 1 to ${${ArrayName}.Size}
            /if (${TempArray[${m}].Length} && !${TempArray[${m}].Find[|0]} && ${TempArray[${m}].NotEqual[null]}) {
                /if (!${Select[${ArrayName},Buffs,Burn]} && ${Int[${TempArray[${m}].Arg[2,|]}]}==0) {
                    /echo Invalid Format for: ${ArrayName}${m}=${TempArray[${m}]} Second Tag: ${TempArray[${m}].Arg[2,|]} Should be a Numeric Value.
                    /echo Skipping Entry. ${ArrayName}${m}. Please correct and restart macro.
                    /continue
                }
                /varcalc NewArrayPos ${NewArrayPos}+1
                /varset TArray2[${NewArrayPos}] ${TempArray[${m}]}
                /varcalc NewArraySize ${NewArraySize}+1
            }
        /next m
        |Sort the Array if needed
        /if (!${Select[${ArrayName},Buffs,Burn]} && ${NewArraySize}>1) {
            /varset m ${NewArraySize}
            /while (${Swapped} && ${m}>1) {
                /varset Swapped 0
                /for k 2 to ${m}
                    /varcalc j ${k}-1
                    /if (${TArray2[${j}].Arg[2,|]} ${SortHow} ${TArray2[${k}].Arg[2,|]}) {
                        /varset TempSwapHold ${TArray2[${j}]}
                        /varset TArray2[${j}] ${TArray2[${k}]}
                        /varset TArray2[${k}] ${TempSwapHold}
                        /varset Swapped 1
                    }
                /next k
                /varcalc m ${m}-1
            }
        }
        | Bail if array is empty and turn off switch
        /if (!${NewArraySize}) {
            /if (${Defined[${ArrayName}On]}) {
                /if (${${ArrayName}On}) {
                    /varset ${ArrayName}On 0
                    /echo ${ArrayName}
                    /if (${ArrayName.NotEqual[heals]} && ${ArrayName.NotEqual[burn]}) {
                        /echo ERROR1: ${ArrayName}On=1 but section is empty. Turning ${ArrayName} off. Please check your ini file.
                        /beep
                        /delay 10
                    } else /if (${ArrayName.Equal[heals]} && !${AutoRezOn}) {
                        /echo ERROR: ${ArrayName}On=1 but section is empty. Turning ${ArrayName} off. Please check your ini file.
                        /beep
                        /delay 10
                    }
                }
            }
			POPCALL
            /return
        }
        /deletevar ${ArrayName}
        /declare ${ArrayName}[${NewArraySize}] string outer
        /for l 1 to ${NewArraySize}
            /varset ${ArrayName}[${l}] ${TArray2[${l}]}
            DEBUGN  ${${ArrayName}[${l}]}
        /next l
        /if (${ArrayName.Equal[buffs]}) /call CreateTimersBuffs
        /if (${ArrayName.Equal[dps]}) /call CreateTimersDPS
		POPCALL
        DEBUGN ${${ArrayName}.Size}
        DEBUGN SortArray Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: SpellRankCheck
| ------------------------------------ -------------------------------------------------
    Sub SpellRankCheck(Rk_Check_What, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        /declare rkCheck                string      local null
        /declare rkCheck1               string      local
        /declare rkdCheck               string      local
        /declare rkTemp                 string      ${Rk_Check_What.Arg[1,|]}
        /declare rkdTemp                string      ${Rk_Check_What.Arg[3,|]}
        /declare rkd_i                  int         local 0
        DEBUGN SpellRankChecks: Enter from ${FromWhere}
        /if (${Rk_Check_What.Left[1].Equal[0]} || ${Int[${Rk_Check_What.Left[1]}]}>0) {
			/return ${Rk_Check_What}
		}
        | Check for Rk. in spell name and Remove it.
        /if (${rkTemp.Find[ Rk.]}) {
            /varset rkTemp ${rkTemp.Left[${Math.Calc[${rkTemp.Find[ Rk.]}-1]}]}
        }
        /if (${Int[${Me.Book[${rkTemp}]}]}==0 && ${Int[${Me.Book[${Spell[${rkTemp}].RankName}]}]}==0 && ${Int[${Me.AltAbility[${rkTemp}]}]}==0 && ${Int[${Me.AltAbility[${rkTemp}].Spell.ID}]}==0 && ${Int[${Me.CombatAbility[${Spell[${rkTemp}].RankName}]}]}==0) {
			/return ${Rk_Check_What}
		}
        DEBUGN SpellRankChecks: 1 rkCheck: "${rkCheck}" rkTemp: "${rkTemp}" rkdCheck: "${rkdCheck}" rkdTemp: "${rkdTemp}"
        | If this is NOT an Alt Ability then it must be a spell.
        /if (${Int[${Me.AltAbility[${rkTemp}].ID}]}!=0 || ${Int[${Me.AltAbility[${rkTemp}].Spell.ID}]}!=0) {
           /if (${DebugRk}) /echo 1a. well we think ${rkTemp} is an AA
           /varset rkCheck ${rkTemp}
        } else {
           /if (${DebugRk}) /echo 1c. well ${rkTemp} is not an AA or CombatAbility
           /varset rkCheck ${Spell[${rkTemp}].RankName}
        }
        | check for null
        DEBUGN SpellRankChecks: 2 rkCheck: ${rkCheck} rkTemp: ${rkTemp} Rk_Check_What: ${Rk_Check_What}
        | must NOT be null so lets fix Rk_Check_What.
        /if (${rkCheck.NotEqual[${rkTemp}]}) {
            /if (${Rk_Check_What.Find[|]}>0) {
                /varset rkCheck1 ${rkCheck}${Rk_Check_What.Right[-${Math.Calc[${Rk_Check_What.Find[|]}-1]}]}
                /varset rkCheck ${rkCheck1}
            }
        } else {
            /varset rkCheck ${Rk_Check_What}
        }
        /if (${Rk_Check_What.Arg[2,|].Equal[dual]}) {
            /if (${rkdTemp.Find[ Rk.]}) {
                /varset rkdTemp ${rkdTemp.Left[${Math.Calc[${rkdTemp.Find[ Rk.]}-1]}]}
            }
            /if (${Int[${Me.AltAbility[${rkdTemp}].ID}]}!=0 || ${Int[${Me.AltAbility[${rkTemp}].Spell.ID}]}!=0) {
                /varset rkdCheck ${Spell[${rkdTemp}].RankName}
            } else {
                /if (${Me.Subscription.NotEqual[gold]}) {
                    /varset rkdCheck ${rkdTemp}
                } else {
                    /varset rkdCheck ${Spell[${rkdTemp}].RankName}
                }
            }
            DEBUGN SpellRankChecks: 3 rkdCheck: ${rkdCheck} rkdTemp: ${rkdTemp} Rk_Check_What: ${Rk_Check_What}
            /varset rkCheck ${rkCheck.Arg[1,|]}|dual|${rkdCheck}
            /for rkd_i 4 to 10
                /if (!${Bool[${Rk_Check_What.Arg[${rkd_i},|]}]}) /break
                /varset rkCheck ${rkCheck}|${Rk_Check_What.Arg[${rkd_i},|]}
            /next rkd_i
        }
        DEBUGN SpellRankChecks: 4 Rk_Check_What: ${Rk_Check_What} rkCheck: ${rkCheck} rkTemp: ${rkTemp}
        DEBUGN SpellRankChecks: leave
    /return ${rkCheck}

| -----------------------------------------------------------------------------
| Sub:TryCharIni
| -----------------------------------------------------------------------------
	Sub TryCharIni(string IniFile)

		/declare TryDir1			string	local	${KACharIniDir}
		/declare TryDir2			string	local	aka\chars\
		/declare TryDir3			string	local	aka\
		/declare TryDir4			string	local   

        /declare IniTest            string  local
		/declare TempIniFileName	string	local
		/declare SafeDirName		string	local

		/varset SafeDirName ${KACharIniDir}
		/varset SafeDirName ${SafeDirName.Replace[\,\\]}

		/varset TempIniFileName ${TryDir1}${IniFile}
        /varset IniTest ${Ini["${TempIniFileName}"]}
		/if (${IniTest.NotEqual[NULL]}) {
			/varset IniFileName ${TempIniFileName}
            /return 1
		}
		
		/varset TempIniFileName ${TryDir2}${IniFile}
        /varset IniTest ${Ini["${TempIniFileName}"]}
		/if (${IniTest.NotEqual[NULL]}) {
			/varset IniFileName ${TempIniFileName}
			| /echo \awAKA: \ayIt is \awrecommended \aythat you copy your character INI's to a subdir within ${SafeDirName} using the server short name: ${EverQuest.Server}
            /return 1
		}
		
		/varset TempIniFileName ${TryDir3}${IniFile}
        /varset IniTest ${Ini["${TempIniFileName}"]}
		/if (${IniTest.NotEqual[NULL]}) {
			/varset IniFileName ${TempIniFileName}
			| /echo \awAKA: \ayIt is \awrecommended \aythat you copy your character INI's to a subdir within ${SafeDirName} using the server short name: ${EverQuest.Server}
            /return 1
		}

		/varset TempIniFileName ${TryDir4}${IniFile}
        /varset IniTest ${Ini["${TempIniFileName}"]}
		/if (${IniTest.NotEqual[NULL]}) {
			/varset IniFileName ${TempIniFileName}
			| /echo \awAKA: \ayIt is \awrecommended \aythat you copy your character INI's to a subdir within ${SafeDirName} using the server short name: ${EverQuest.Server}
            /return 1
		}
		
	/return 0
