
| -------------------------------------------------------------------------------------------------
| SUB: Add stuff to alert list
| -------------------------------------------------------------------------------------------------
    Sub AlertAddToList(int whatlist, MvarList, IDvarList)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN AlertAddToList List:${whatlist} Mlist: ${MvarList}
        /declare k 				int 	local
		/declare CleanMobName	string	local
        | Clear ignore mobs alert from list before assigning from ini list
        /squelch /alert clear ${whatlist}
        /if (${MvarList.Length} && !${MvarList.Find[null]}) {
            /for k 1 to 25
                /if (${MvarList.Arg[${k},,].Length} && !${MvarList.Find[null]} && ${Debug}) {
					DEBUGN ADD ${MvarList.Arg[${k},,]} to ${MvarList}
				}
                /if (${MvarList.Arg[${k},,].Length}) {
					/varset CleanMobName ${MvarList.Arg[${k},,].Replace[*,]}
					/varset CleanMobName ${MvarList.Arg[${k},,].Replace[#,]}
                    /squelch /alert add ${whatlist} "${CleanMobName}"
                    DEBUGN AlertAddToList Add ${CleanMobName} to Alert List ${whatlist}
                }
            /next k
        }
        | Add by mob ID for mobs that get invalidated when pulling.
        /if (${IDvarList.Length} && ${IDvarList.NotEqual[null]}) {
            /varset k 1
            /while (${IDvarList.Arg[${k},|].Length} && ${IDvarList.Arg[${k},|].NotEqual[null]} && ${Int[${IDvarList.Arg[${k},|]}]}>0) {
                DEBUGN ADD ${IDvarList.Arg[${k},|]} to ${MvarList}
                /if (${Int[${IDvarList.Arg[${k},|]}]}>0) /squelch /alert add ${whatlist} id ${IDvarList.Arg[${k},|]}
                DEBUGN AlertAddToList Add ${IDvarList.Arg[${k},|]} to Alert List ${whatlist}
                /varcalc k ${k}+1
            }
        }
        DEBUGN AlertAddToList Leave
    /return

| -------------------------------------------------------------------------------------------------
| SUB: alert clear
| -------------------------------------------------------------------------------------------------
    Sub AlertClearList(int ListToClear, string SentFrom)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGPULL AlertClearList Enter
        DEBUGPULL Clearing Alert list ${ListToClear}.
        /squelch /alert clear ${ListToClear}
        DEBUGPULL AlertClearList Leave
    /return

| -------------------------------------------------------------------------------------------------
| SUB: Bind Change Var Int resets various interger settings from ini file
| -------------------------------------------------------------------------------------------------
    Sub Bind_ChangeVarInt(ISection, IName, IVar)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN Bind_ChangeVarInt ${ISection} ${IName} ${IVar}
        /echo Changing ${IName} to ${IVar}
        /varset ${IName} ${IVar}
        /ini "${IniFileName}" "${ISection}" "${IName}" "${IVar}"
        /if (${IName.Find[mezon]}) {
            /if (!${Defined[MezTimer1]}) /call CreateTimersMez
        } else /if (${IName.Find[dpson]}) {
            /if (!${Defined[DPSTimer1]}) /call CreateTimersDPS
        } else /if (${IName.Find[buffson]}) {
            /if (!${Defined[Buffs1Timer0]}) {
                /call CreateTimersBuffs
                /echo Buffs on creating timers
            }
        } else /if (${IName.Equal[ChaseAssist]}) {
            /if (${IVar}) {
                /if (${ReturnToCamp}) {
                    | Why set whotochase here. by default whotochase is set to mainassist.
                    /ini "${IniFileName}" "General" "ReturnToCamp" "0"
                    /varset ReturnToCamp 0
                }
                /if (!${Stick.Active}) /varset RebuffOn 300
                /if (${Pet.ID} && ${Pet.Stance.NotEqual[follow]}) /pet follow
            } else {
                /if (${Stick.Active}) /squelch /stick off
            }
        } else /if (${IName.Equal[MaxRadius]}) {
            /varcalc CampRadiusExceed ${MaxRadius}+200
        } else /if (${IName.Equal[LootOn]}) {
            /if (!${LootOn}) {
                /if (${Defined[NALStatus]}) {
                    /varset NALStatus 0
                }
            } else {
                /if (${Defined[NALStatus]}) {
                    /varset NALStatus 1
                }
            }
        }
        
		POPCALL
    /return

| -------------------------------------------------------------------------------------------------
| SUB: Bind MemMySpells
| -------------------------------------------------------------------------------------------------
    Sub Bind_MemMySpells(Message, p_SpellSet)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare temppCharName          string      local
        /declare pCharName              string      local ${Message}
        /declare tempIniFileName        string      local
        /declare pKV                    string      local
        /declare i                      int         local
        /declare ii                     int         local
        /declare SpellToMem             string      local
        /declare tempSpellName          string      local
        /declare tempSpellSection       string      local
        /declare int_WasIStanding       bool        local ${Me.Standing}
        /declare SafeIniName            string      local

        DEBUGN MemMySpells: Enter
        /varcalc GemSlots ${Int[${Me.AltAbility[Mnemonic Retention].Rank}]}+8
        
		/if (!${pCharName.Length} || ${pCharName.Equal[null]}) {
           /varset temppCharName ${Me.CleanName}
        } else {
           /varset temppCharName ${pCharName}
        }
		
        /call FindCharIni
        /varset tempIniFileName ${IniFileName}
        /varset pKV ${Ini["${tempIniFileName}","General","KissAssistVer"]}
        /if (${Int[${pKV}]}==0) {
       		/varset SafeIniName ${tempIniFileName}
            /varset SafeIniName ${SafeIniName.Replace[\,\\]}
            /echo \awAKA: \ayInvalid INI file: ${SafeIniName} for memorizing spells. Returning.
            POPCALL
            /return
        }
        /if (${Bool[${p_SpellSet}]}) {
            /varset tempSpellSection Spells${p_SpellSet}
            /varset pKV ${Ini[${tempIniFileName},"${tempSpellSection}",Gem1]}
            /if (${Int[${pKV.Length}]}==0) {
               /echo \awAKA: \ayNo Spells Section found for: ${tempSpellSection}. Defaulting to Spells Section.
               /varset tempSpellSection Spells
               |/return
            }
        } else {
            /varset tempSpellSection Spells
        }
        /varset pKV ${Ini[${tempIniFileName},"${tempSpellSection}",Gem1]}
        /if (${Int[${pKV.Length}]}==0) {
           /echo \awAKA: \ayNo Spells found in INI file: ${tempIniFileName}. Use /writespells and try again. Returning.
		   POPCALL
           /return
        }
        /if (${IAmABard}) {
            /call CastBardCheck FROMHERE 0
        }
        /for i 1 to ${GemSlots}
			/doevents GotHit
            /varset SpellToMem ${Ini[${tempIniFileName},"${tempSpellSection}",Gem${i}]}
            /if (${SpellToMem.Length} && ${SpellToMem.NotEqual[null]}) {
                /if (${SpellToMem.Find[ Rk.]}) {
                   /varset tempSpellName ${SpellToMem.Left[${Math.Calc[${SpellToMem.Find[ Rk.]}-1]}]}
                } else {
                   /varset tempSpellName ${SpellToMem}
                }
                /varset SpellToMem ${Spell[${tempSpellName}].RankName}
                /if (${Me.Book[${SpellToMem}]}) {
                    /if (${Int[${Me.Gem[${SpellToMem}]}]}>0 && ${Int[${Me.Gem[${SpellToMem}]}]}!=${i}) {
                        /varcalc ii ${Int[${Me.Gem[${SpellToMem}]}]}-1
                        /notify CastSpellWnd CSPW_Spell${ii} rightmouseup
                        /delay 20 ${Int[${Me.Gem[${SpellToMem}]}]}==0
                    }
                    /if (!${Int[${Me.Gem[${i}].Name.Length}]} || ${Me.Gem[${i}].Name.NotEqual[${SpellToMem}]}) {
                        /varset DontMoveMe 1
                        /while (${Me.Moving}) {
                            /delay 5
                        }
                        /if (!${Me.Mount.ID} && ${Me.Standing}) /sit
                        /echo Meming ${SpellToMem} in slot ${i}
                        /if (${Stick.Active}) {
                            /stick pause
                            /MemSpell ${i} "${SpellToMem}"
                            /delay 150 ${Me.Gem[${i}].Name.Equal[${SpellToMem}]}
                            /stick unpause
                        } else {
                            /MemSpell ${i} "${SpellToMem}"
                            /delay 150 ${Me.Gem[${i}].Name.Equal[${SpellToMem}]}
                        }
                        /varset DontMoveMe 0
                    }
                } else {
                    /echo \awAKA: \ayCould Not find the spell ${tempSpellName} in your spell book.
                }
            }
        /next i
        /varset ReMemMiscSpell ${Me.Gem[${MiscGem}].Name}
        /varset ReMemMiscSpellLW ${Me.Gem[${MiscGemLW}].Name}
        /if (${IAmABard} && ${WasTwisting}) {
            /if (${Me.Sitting}) /stand
            /delay 5
            /squelch /twist
        } else /if (${int_WasIStanding} && ${Me.Sitting} && !${Me.Mount.ID}) {
            /stand
        }
		POPCALL
		DEBUGN MemMySpells: leave
    /return

| ---------------------------------------------------------------------------
| SUB: Bind_ReStart
|
| Calls Restarts AKA with original parameters.
| ---------------------------------------------------------------------------
	Sub Bind_ReStart
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/declare BuildParamsStr		string		local
		/declare i					int			local
		/for i 0 to ${NumParams}
			/if (${Defined[Param${i}]}) {
				/varset BuildParamsStr ${BuildParamsStr} ${Param${i}}
			}
		/next i
		
		|/echo StartupTarget ${StartupTarget} BuildParamsStr ${BuildParamsStr}
				
		/call TargetThis ${StartupTarget}
		POPCALL
		/mac ${Macro.Name} ${BuildParamsStr}
	/return

| -------------------------------------------------------------------------------------
| SUB: Bind_ToggleVariable  Check whenever the player is changing any variable via /echo
| -------------------------------------------------------------------------------------
    Sub Bind_ToggleVariable(string Command, string Command2, string Command3)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN ${Command} ${Defined[${Command}]} ${Command2} ${Command3}
        /declare i int local
        /declare OnOff local
        | Toggle Variables & Set Variables
        /if (${Defined[${Command}]}) {
            DEBUGN ${Command}:${${Command}} ${Defined[${Command}]} ${Command2} ${Command3}
            | Toggle the variable
            /if (${Select[${Command2},0,1,on,off]}) {
                /if (${Select[${Command2},0,off]}) {
                    /varset ${Command} 0
                    /varset OnOff Off
                    DEBUGN ${OnOff} 1
                } else /if (${Select[${Command2},1,on]}) {
                    /varset ${Command} 1
                    /varset OnOff On
                    DEBUGN ${OnOff} 2
                }
            } else /if (${${Command}}) {
                /varset ${Command} 0
                /varset OnOff Off
                DEBUGN ${OnOff} 3
                /if (!${ChaseAssist} && ${Stick.Active}) /squelch /stick off
            } else {
                /varset ${Command} 1
                /varset OnOff On
                DEBUGN ${OnOff} 4
            }
            /if (${Command.Equal[ChaseAssist]}) {
                /if (${OnOff.Equal[on]}) {
                    /if (${Command3.NotEqual[null]} && ${Command3.Length}>0 && ${WhoToChase.NotEqual[${Command3}]}) {
                        /varset WhoToChase ${Command3}
                        /echo I Will Now Chase ${WhoToChase}
                    }
                    /if (${ReturnToCamp}) /varset ReturnToCamp 0
                    /if (${Pet.ID} && ${Pet.Stance.NotEqual[follow]}) /pet follow
                } else {
                    /if (${Stick.Active}) /squelch /stick off
                }
            | Set new y,x,z coords regardless of whether return to camp is enabled or disabled. We can set the var ReturnToCamp separately.
            |} else /if (${Command.Equal[ReturnToCamp]} && ${OnOff.Equal[on]}) {
            } else /if (${Command.Equal[ReturnToCamp]}) {                
                /varset CampXLoc ${Me.X}
                /varset CampYLoc ${Me.Y}
                /varset CampZLoc ${Me.FloorZ}
                /varset LookForward ${Me.Heading.DegreesCCW}
                /if (${CampZone}!=${Zone.ID}) /varset CampZone ${Zone.ID}
                | Turn off ChaseAssist if on, if we are enabling ReturnToCamp
                /if (${ChaseAssist} && ${OnOff.Equal[on]}) {
                    /varset ChaseAssist 0
                    /ini "${IniFileName}" "General" "ChaseAssist" "0"
                    /if (${Stick.Active}) /squelch /stick off
                    /echo >> ChaseAssist Off
                }
                /if (${OnOff.Equal[on]}) {
                    /echo >> New camp set (yxz): ${Me.Y}, ${Me.X}, ${Me.FloorZ}
                }
            } else /if (${Command.Equal[AutoRezAll]}) {
                /if (${OnOff.Equal[off]}) {
                    /varset CorpseRezCheck null
                    /echo No longer Rezing Everyone.
                } else {
                    /echo Now Rezing Everyone.
                }
            } else /if (${Command.Equal[looton]}) {
                /if (${OnOff.Equal[off]}) {
                    /if (${Defined[NALStatus]}) {
                        /varset NALStatus 0
                    }
                } else {
                    /if (${Defined[NALStatus]}) {
                        /varset NALStatus 1
                    }
                }
            } else /if (${Command.Equal[targetswitchingon]}) {
                /if (${OnOff.Equal[on]}) {
                    /if (!${IAmMA}) {
                        /varset ${Command} 0
                        /varset OnOff off
                    } 
                }
            }
            DEBUGN ${Command} ${Command2} ${Command3}
            /echo >> Setting: (${Command}) to (${If[${Select[${OnOff},on,1]}>0,On,Off]})
        } else /if (${Command.Equal[waithere]}) {
            /varset ChaseAssist 0
            /varset ReturnToCamp 0
            /if (${Stick.Active}) /squelch /stick off
        }
		POPCALL
    /return
	
| -------------------------------------------------------------------------------------------------
| SUB: Bind WriteMySpell
| -------------------------------------------------------------------------------------------------
    Sub Bind_WriteMySpells(int Quite)
        /if (${Select[${Me.Class.ShortName},BER,MNK,ROG,WAR]}) /return
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varcalc GemSlots ${Int[${Me.AltAbility[Mnemonic Retention].Rank}]}+8
        /declare i int local
        /for i 1 to ${GemSlots}
            /if (!${Quite}) /echo Gem ${i}: ${Me.Gem[${i}].Name}
            /ini "${IniFileName}" "Spells" "Gem${i}" "${Me.Gem[${i}].Name}"
        /next i
    /return

| ----------------------------------------------------------------------------
| SUB: Check Plugin
| ----------------------------------------------------------------------------
    Sub CheckPlugin(string pluginname, int noautoflag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        /declare WaitTimer1 timer local 50
        DEBUGN CheckPlugin: Enter
        /if (!${Bool[${Plugin[${pluginname}]}]}) {
            /if (${noautoflag}) {
                /squelch /plugin ${pluginname} noauto
            } else {
                /squelch /plugin ${pluginname}
            }
            /echo ${pluginname} not detected! This macro requires it! Loading ...
            /while (${WaitTimer1} && !${Bool[${Plugin[${pluginname}]}]}) {
                /delay 5
            }
        }
        DEBUGN CheckPlugin: Leave
    /return

| -------------------------------------------------------------------------------------------------
| Sub Check Roles
| -------------------------------------------------------------------------------------------------
    Sub CheckRoles(int specialK, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN CheckRoles Enter from ${FromWhere}
		| Note: Setting MA here clobbers switchma. On startup, we call assignmainassist
		| then if there is a switchma, it changes at that time.
		|
		| You may also be an offtank that uses its pet to tank... petofftank
		| If you change pet settings after boot, it respects them. Except when it doesn't.
		|
        /if (${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]} && ${Select[${Role},pettank,pullerpettank,hunterpettank,petofftank]} && ${PetOn}) {
            | Make pet if it isn't up already !!!!
            /if (!${Pet.ID}) {
                /echo My role is (${Role}), but I have no active pet.
                /call DoPetStuff FROMHERE
				/if (${Me.Invis}) {
					/echo You are invisible. That's why you can't make a pet.
					/endmacro
				}
            }
			/if (!${Pet.ID} && ${PetOn}) {
                /call WaitUntilAble "${PetSpell}" FROMHERE
                /if (!${Pet.ID}) {
                    /echo \awAKA: \ayYou couldn't make a pet. Perhaps you need components? You get to assist.
                    /varset Role assist
                }
			} else /if (!${PetOn}) {
                /echo \awAKA: \ayYour role requires a pet but you couldn't make one. Perhaps you need components? You get to assist.
                /varset Role assist
            }
        } else /if (!${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]} && ${Select[${Role},pettank,pullerpettank,hunterpettank,petofftank]}) {
			/echo Your role requies a pet but you aren't a pet wrangler! Changing you to assist.
			/varset Role assist
		} else /if (${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]} && ${Select[${Role},pettank,pullerpettank,hunterpettank,petofftank]} && !${PetOn}) {
			/echo Your role requires a pet. But pets are disabled. That's a problem. Changing you to assist.
			/varset Role assist
		}

        | Set camp per char
        | Setting ReturnToCamp populates Camp location regardless of whether it is on or off. It's a starting point.
        /if (!${BootCompleted}) {
            /if (${ReturnToCamp}) {
                /call Bind_ToggleVariable ReturnToCamp on
            } else {
                /call Bind_ToggleVariable ReturnToCamp off
            }
        }

		|
		| Need default settings in case people choose roles that don't take advantage of pet utility
		|
		/if (${Pet.ID}) {
			|
			| Need to set this so pets don't go scampering off to engage far away mobs!
			|
			/varset PetAttackRange ${PetAttackDistance}
		}	
        /if (${Select[${Role},assist]}) {
            DEBUGN Looks like I am ${Role}ing.
            /if (${UseMQ2Melee}) {
                /squelch /melee aggro=0
                /stick mod 0
            } else {
                /if (${MeleeOn} || ${DPSOn}) {
                    /if (${DStickHow.Equal[auto]}) {
                        /varset StickHow snaproll
                        /stick mod 0
                    } else {
                        /varset StickHow ${DStickHow}
                        /stick mod 0
                    }
                } else {
                    /varset StickHow 0
                }
            }
        } else /if (${Role.Equal[offtank]}) {
			|
			| Offtanks are important to rescue the group...
			|
            DEBUGN Looks like I am Off Tank. I will steal agro!
            /varset AssistAt 100
            /if (${UseMQ2Melee}) {
                /squelch /melee aggro=1
            } else {
                /if (${DStickHow.Equal[auto]}) {
                    /varset StickHow snaproll front moveback
                    /stick mod -2
                } else {
                    /varset StickHow ${DStickHow}
                    /stick mod -2
                }
            }
			/varset MountOn 0
        } else /if (${Role.Equal[tank]}) {
            DEBUGN Looks like I am Main Tank. Wish me luck.
            |/varset MainAssist ${Me}
            |
			| Set during AssignMainAssist or switchma.
			|/varset IAmMA 1
			|
            /varset AssistAt 100
            /if (${UseMQ2Melee}) {
                /squelch /melee aggro=1
            } else {
                /if (${DStickHow.Equal[auto]}) {
                    /varset StickHow snaproll front moveback
                    /stick mod -2
                } else {
                    /varset StickHow ${DStickHow}
                    /stick mod -2
                }
            }
			|
			| Missing
			|
			/varset MountOn 0
        } else /if (${Role.Equal[puller]}) {
            DEBUGPULL role puller
            DEBUGPULL Looks like I am Puller.
            /if (${UseMQ2Melee}) {
                /squelch /melee aggro=0
            } else {
                /if (${DStickHow.Equal[auto]}) {
                    /varset StickHow snaproll
                    /stick mod 0
                } else {
                    /varset StickHow ${DStickHow}
                    /stick mod 0
                }
            }
			|
			| Get off mount so you dont blunder into mobs.
			|
			/varset MountOn 0
			/if (!${BootCompleted}) /dismount
            /varset ReturnToCamp 1
            /varset ChaseAssist 0
            /varcalc CampRadiusExceed ${MaxRadius}+200
            /if (${Pet.ID}) {
                /if (${Pet.Distance}<=${CampRadius}) {
					/if (!${BootCompleted} && ${Pet.Stance.NotEqual[guard]}) /pet guard
                } else {
					/if (!${BootCompleted} && ${Pet.Stance.NotEqual[follow]}) /pet follow
                }
            }
        } else /if (${Role.Equal[pullertank]}) {
            DEBUGPULL role pullertank
            DEBUGPULL Looks like I am Puller and Tank.
            |/varset MainAssist ${Me}
            |
			| Set during AssignMainAssist or switchma.
			|/varset IAmMA 1
			|
            /if (${UseMQ2Melee}) /squelch /melee aggro=1
            /varset AssistAt 100
            /if (${DStickHow.Equal[auto]}) {
                /varset StickHow snaproll front moveback
                /stick mod -2
            }
            /varset ReturnToCamp 1
            /varset ChaseAssist 0
			|
			| Get off mount so you dont blunder into mobs.
			|
			/varset MountOn 0
			/if (!${BootCompleted}) /dismount			
            /varcalc CampRadiusExceed ${MaxRadius}+200
            /if (${Pet.ID}) {
                /if (${Pet.Distance}<=${CampRadius}) {
                    /if (!${BootCompleted} && ${Pet.Stance.NotEqual[guard]}) /pet guard
                } else {
                    /if (!${BootCompleted} && ${Pet.Stance.NotEqual[follow]}) /pet follow
                }
            }
        } else /if (${Select[${Role},hunter]}) {
            DEBUGPULLL role hunter
            DEBUGPULLL Looks like I am Hunting.
            |/varset MainAssist ${Me}
            |
			| Set during AssignMainAssist or switchma.
			|/varset IAmMA 1
			|
            /if (${UseMQ2Melee}) /squelch /melee aggro=1
            /varset AssistAt 100
            /if (${StickHow.Equal[auto]}) {
                /varset StickHow moveback
                /stick mod -2
            }
            /varcalc CampRadiusExceed ${MaxRadius}+200
            /varset ReturnToCamp 0
			|
			| Get off mount so you dont blunder into mobs.
			|
			/varset MountOn 0
			/if (!${BootCompleted}) /dismount			
            /if (${Pet.ID} && !${BootCompleted} && ${Pet.Stance.NotEqual[follow]}) /pet follow
        } else /if (${Role.Equal[hunterpettank]}) {
            DEBUGPULL role hunterpettank
            DEBUGPULL Looks like I am Hunting and my pet is tanking.
            |/varset MainAssist ${Me}
            |
			| Set during AssignMainAssist or switchma.
			|/varset IAmMA 1
			|
            /if (${UseMQ2Melee}) /squelch /melee aggro=0
            /varset AssistAt 100
            /varset PetTanking 1
            /varset PetAttackRange ${PetAttackDistance}
            /varset ReturnToCamp 0
            /varset ChaseAssist 0
            /varset MountOn 0
			|
			| Get off the mount
			|
			/if (!${BootCompleted}) /dismount
			|
			| Pet should be taunting
			|
			/if (!${BootCompleted}) /varset PetTauntOn 1
            /if (${Pet.ID} && !${BootCompleted} && ${Pet.Stance.NotEqual[follow]}) /pet follow
        } else /if (${Select[${Role},petassist]}) {
            DEBUGPULL role petassist
            DEBUGPULL Looks like I am assisting a pet.
            /if (${UseMQ2Melee}) /squelch /melee aggro=0
            /varset MeleeOn 0
		|
		| I'm a petofftank
		|
		} else /if (${Select[${Role},petofftank]}) {
            DEBUGPULL role petofftank
            DEBUGPULL Looks like my pet is offtanking.
            /if (${UseMQ2Melee}) /squelch /melee aggro=0
			/varset PetAttackRange ${PetAttackDistance}
            /varcalc CampRadiusExceed ${MaxRadius}+200
			/varset PetTanking 1
			/varset AssistAt 100
			|
			| Put melee pet wranglers on the ground.
			|
			/if (${Select[${Me.Class.ShortName},shd,bst]}) {
				/varset MountOn 0
				/if (!${BootCompleted}) /dismount
			}
			/if (!${BootCompleted} && ${Pet.Stance.NotEqual[follow]}) /pet follow
			|
			| Default taunt behavior will be followed within the ini
			|
			/if (!${BootCompleted}) /varset PetTauntOn 1
        } else /if (${Select[${Role},pettank]}) {
            DEBUGPULL role pettank
            DEBUGPULL Looks like my pet is tanking.
            /if (${UseMQ2Melee}) /squelch /melee aggro=0
            |/varset MainAssist ${Me}
            |
			| Set during AssignMainAssist or switchma.
			|/varset IAmMA 1
			|
            /varset AssistAt 100
            /varset PetTanking 1
			/varset PetAttackRange ${PetAttackDistance}
			|
			| Don't force melee to remount.
			|
			/if (${Select[${Me.Class.ShortName},shd,bst]}) {
				/varset MountOn 0
			}
            /varcalc CampRadiusExceed ${MaxRadius}+200
			
			|
			| We want our pettank to taunt... unless PetTauntAllow is disabled in the ini like it should be in a raid. This is checked at bottom.
			|
			/if (!${BootCompleted}) /varset PetTauntOn 1
			|
			| Need to check whether return to camp is on... otherwise this is moot. This is very important, not going to follow BootCompleted logic.
			|
			/if (${ReturnToCamp}) {
				/if (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}<=${CampRadius} && ${Pet.Stance.NotEqual[guard]}) /pet guard
				/if (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}>${CampRadius} && ${Pet.Stance.NotEqual[follow]}) /pet follow
			} else {
				/if (${Pet.Stance.NotEqual[follow]}) /pet follow
			}
			|
			| This is done in DoPetStuff
			|
            |- Function to determine pet active state and suspended pet state if enabled.
            |/if (${PetSuspend} && ${specialK}) /call CheckPetState
        } else /if (${Select[${Role},pullerpettank]}) {
            DEBUGPULL role pullerpettank
            DEBUGPULL Looks like I am pulling and my pet is tanking.
            /if (${UseMQ2Melee}) /squelch /melee aggro=0
            |/varset MainAssist ${Me}
            |
			| Set during AssignMainAssist or switchma.
			|/varset IAmMA 1
			|
            /varset AssistAt 100
            /varset MeleeOn 0
            /varset PetTanking 1
            /varset PetAttackRange ${PetAttackDistance}
            /varset ReturnToCamp 1
            /varset ChaseAssist 0
            /varset MountOn 0
			|
			| Get off
			|
			/if (!${BootCompleted}) /dismount
            /varcalc CampRadiusExceed ${MaxRadius}+200
			/if (!${BootCompleted}) /varset PetTauntOn 1
			|
			| Check if we are in a camp situation. Adding this in case we change default behavior. Not altering with BootCompleted flag.
			|
			/if (${ReturnToCamp}) {
				/if (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}<=${CampRadius} && ${Pet.Stance.NotEqual[guard]}) /pet guard
				/if (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}>${CampRadius} && ${Pet.Stance.NotEqual[follow]}) /pet follow
			} else {
				/if (${Pet.Stance.NotEqual[follow]}) /pet follow
			}
			|
			| Why?
			|
            /if (${PullRoleToggle} && ${Group.Leader.ID}!=${Me.ID}) {
                /echo You are set to toggle puller mode but are NOT the group leader.
                /echo Please correct this and restart KissAssist.
				/beep
                /endmacro
            }
			|
			| Done in DoPetStuff
            |- Function to determine pet active state and suspended pet state if enabled.
            |/if (${PetSuspend} && ${specialK}) /call CheckPetState
        } else /if (${Role.Equal[manual]}) {
            /if (${UseMQ2Melee}) /squelch /melee aggro=0
            /varset MeleeOn 0
            /varset ReturnToCamp 0
            /varset ChaseAssist 0
            /varset DPSOn 0
            /varset BuffsOn 0
            /varset DebuffAllOn 0
            /if (${Defined[HealsOn]}) /varset HealsOn 0
            /if (${Defined[MezOn]}) /varset MezOn 0
        }
		
		|
		| I disagree with this. Sometimes I want to manually target other mobs with other chars to make a correction. Leaving for now.
		|
        /if (${TargetSwitchingOn} && !${IAmMA}) /varset TargetSwitchingOn 0
        /if (${StickHow.Equal[null]} || ${StickHow.Equal[auto]}) /varset StickHow 0
		|
		| Why aren't the pure pullers chain pulling? pullerpet should be pullerpettank?
		|
        /if (${Select[${Role},puller,pullerpettank]}==0 && ${ChainPull}) /varset ChainPull 0
		|
		| I think this should be left alone and just configured in the ini, not overridden here. The variable I think was intended was PullWait. PullPause does something else.
		|
        |/if (!${Role.Find[puller]} && !${Role.Find[hunter]}) /varset PullPause 0
        /if (${MezOn}) {
            /if (${MezDebuffOnResist}) {
                /if (!${Me.AltAbility[${MezDebuffSpell}]} && !${FindItem[=${MezDebuffSpell}].ID} && !${Me.Book[${MezDebuffSpell}]}) {
                    /varset MezDebuffOnResist 0
                    /echo Setting MezDebuffOnResist off. Could not Find MezDebuffSpell: ${MezDebuffSpell}.
                }
            }
        }
		
		|
		| Added check for whether we want pet to taunt at all.
		| /togglevariable to modify behavior on the fly.
		| We will *never* allow taunt. Not ever.
		|
		/if (${Pet.ID} && ${PetOn}) {
			/if (!${PetAllowTaunt}) {
				/call PetTauntSwitch 0 FROMHERE
			} else {
				/if (${Select[${Role},pettank,pullerpettank,hunterpettank]}) {
					/call PetTauntSwitch 1 FROMHERE
				} else /if (${PetTauntOn}) {
					/call PetTauntSwitch 1 FROMHERE
				} else /if (!${PetTauntOn}) {
                    /call PetTauntSwitch 0 FROMHERE
                }
			}
            |
            | Pet will always follow if guard is called for as part of role, prior to boot being complete. Can be overriden by user action.
            |
            /if (${PetAlwaysFollowOn} && !${BootCompleted} && ${Pet.Stance.NotEqual[follow]}) /pet follow
            /if (${PetHoldOn} && !${BootCompleted} && !${Pet.${PetHold}}) /pet ${PetHold}
            |/if (${Pet.Stop}) /pet stop off
		}
		
		/if (${Select[${Role},PULLER_ROLES]}) {
            /call Bind_ToggleVariable ReturnToCamp on
            /call Bind_MakeCampHere
        }
		
		POPCALL
        DEBUGN CheckRoles Leave
    /return

| ----------------------------------------------------------------------------
| SUB: End Mac If
| ----------------------------------------------------------------------------
    Sub EndMacroIf(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN EndMacroIf: Enter from ${FromWhere}
        | I died wait for rez loop
        /if (${Me.Hovering}) /call PauseWhileHovering FROMHERE
        /while (${EverQuest.GameState.NotEqual[ingame]}) {
            /delay 10
            /if (${EverQuest.GameState.Equal[CHARSELECT]}) /endmac
        }
        /while (${CampZone}!=${Zone.ID} && ${RezAcceptOn.Arg[1,|].Equal[1]} && ${IAmDead} && ${Me.ID}) {
            /if (${EverQuest.GameState.Equal[CHARSELECT]}) /endmac
            /if (${Attacking}) /call CombatReset 0 FROMHERE
            /delay 10
            /if (${ClickBacktoCamp}) /call CampfireBack
            /if (${CampOnDeath}) /call DoICamp
        }
        /if (${RezAcceptOn.Arg[1,|].Equal[0]} && ${CampZone}!=${Zone.ID}) {
            /if (${CampOnDeath}) /call DoICamp
            |/if (${IAmDead}) {
            |    /if (${IAmABard}) /call CastBardCheck FROMHERE
            |    /endmac
            |}
        }
		POPCALL
        DEBUGN EndMacroIf: Leave
    /return

| ---------------------------------------------------------------------------
| SUB: IniNotifications
|----------------------------------------------------------------------------
	Sub IniNotifications
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        | Despammed.

		/if (!${AutoTargetOn}) {
			|/echo - I will target mobs on my own. I will be ignoring the MA. I will still automatically do the things once I acquire a hostile target. By. My. Self.
			/varset RescueCharsOn 0
		}
		/if (${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]}) {
			/if (${PetOn}) {
				/if (${Select[${Me.Class.ShortName},DRU]}) {
					/varset PetSuspend 0
				}
				/if (${PetSuspend}) {
					|/echo - I will wrangle two pets, and may charm or tame.
				} else /if (!${PetSuspend} && !${Select[${Me.Class.ShortName},DRU]}) {
					|/echo - I will wrangle a pet, charm, or tame.
				} else /if (!${PetSuspend} && ${Select[${Me.Class.ShortName},DRU]}) {
					|/echo - I may tame a pet.
				}
			} else {
				|/echo - I will not be wrangling a pet, but I may charm or tame.
			}
			/if (${PetOn}) {
				/if (${RequestPetToys}) {
					|/echo - I will request toys for my pet
				}
				/if (${BattleSummonPet}) {
					|/echo - I will summon a new pet if mine dies in battle.
				}
				/if (${PetLineOfSightOn}) {
					|/echo - My pet will only engage mobs when I have line of sight.
				}
				/if (!${PetAllowTaunt}) {
					|/echo - I have forbidden my pet from taunting.
				} else {
					/if (${PetTauntOn}) {
						|/echo - My pet will taunt when called for.
					}
				}
				/if (${PetHoldOn} && ${PetFocusOn}) {
					|/echo - My pet will do as its told and hold.
				} else /if (${PetHoldOn} && !${PetFocusOn}) {
					|/echo - My pet will hold until it decides not to.
				} else /if (!${Select[${Me.Class.ShortName},DRU]}) {
					|/echo - It's lord of the flies. My pet is free range and will do whatever it wants. Danger! Excitement!
				} else /if (${Select[${Me.Class.ShortName},DRU]}) {
					|/echo - If I tame a pet, then we will find out whether it holds.
				} else {
					|/echo - My pet may be a wallflower. Or it may raise hell. Who knows.
				}
				/if (${PetAlwaysFollowOn}) {
					|/echo - My pet will follow me around, unless it doesn't because I'm doing puller stuff.
				}
			}
		}	
		/if (${RescueCharsOn}) {
			/if  (${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]} && ${PetOn}) {
				/if (!${IAmMA}) {
					|/echo - I will change target if a delicate flower aggros and try to save them. I will send my pet after the hostile. I will follow the MA again after a short time if they change target.
				} else {
					|/echo - I will change target if a delicate flower aggros and try to save them. I will send my pet after the hostile.
				}
			} else {
				/if (${Select[${Role},tank,offtank,puller,pullertank,pettank,petofftank,pullerpettank,hunter,hunterpettank]}) {		
					|/echo - I will change target if a delicate flower aggros and try to save them. I will follow the MA again after a short time if they change target.
				}
			}
			/if (${MitigateDebuff.Length} && ${MitigateDebuff.NotEqual[null]}) {
				|/echo - I will mitigate aggro by debuffing using ${MitigateDebuff}
			}
			/if (${MitigateSlow.Length} && ${MitigateSlow.NotEqual[null]}) {
				|/echo - I will mitigate aggro by slowing using ${MitigateSlow}
			}
		}
		/if (${Select[${Role},PULLER_ROLES]} && (${PullEscapeMethod.Length} || ${PullEscapeMethod.NotEqual[NULL]})) {
			|/echo - If hit while pulling I will do: ${PullEscapeMethod}. You can set this in the ini. Suggestions include your jump-ahead ability such as Mistwalk or Shadowstep, or if a mage is in group and configured to coth on request, command:/bca //cothme name
		}		
		/if (${IAmAMage}) {
			/if (${ProvideModRods} && ${RequestModRods}) {
				/varset RequestModRods 0
			}
			/if (${ProvideModRods}) {
				|/echo - I will provide modrods on request. You may request them by /bca //modrods which you can use in an ini with command:/bca //modrods
			}
			/if (${Me.Level}>54) {
				/if (${ProvideCoth}) {
					|/echo - I will COTH on request. Individuals may request /cothme or /cothus to call the group to the mage. It might be handy to use command:/cothme as a PullEscapeMethod.
				}
				|/echo - I can COTH individuals directly by doing /cothpc name, or /cothgroup (if level 97+). If you provide optional parameter 1, it will drop invis and cast. E.g. /cothpc uberguy 1, /cothgroup 1
			}
			/if (${PetOn} && ${PetToysOn}) {
				/if (${ProvidePetToys}) {
					|/echo - I will make pet toys and take requests to equip other pets in group if defined in the ini. They will be notified when I am finished. You may request toys by doing /bca //givepettoys petname, or bca //givepettoys group to equip all the pets in the group.
					/if (${GivePetToyBags}) {
						/if (${GivePetToyBags}>20) {
							|/echo - Warning: Too many pet toy bags specified. Set to maximum of 20 per type. Setting to 2.
							/varset GivePetToyBags 2
						}
						|/echo - I will take requests from PC for ${GivePetToyBags} bags of toys if defined in the ini. Do /bca //givepettoys yourname
					}
				}
			}
		}
		/if (${IAmAEnch} || ${IAmABard} || ${IAmANec}) {
			/if (${MezOn}) {
				/if (${MezSpell.Length} && ${MezSpell.NotEqual[NULL]} && ${Spell[${Spell[${MezSpell}].RankName}].ID}) {
					/if (${Spell[${Spell[${MezSpell}].RankName}].MaxLevel}>${MezMaxLevel}) {
						/echo WARNING: Your spell ${Spell[${MezSpell}].RankName} can mez mobs up to level ${Spell[${Spell[${MezSpell}].RankName}].Level} but your MezMaxLevel is set to ${MezMaxLevel}!
						/echo Check your AE mez too.
					}
				} else {
					/echo WARNING: Your MezSpell is invalid...
				}
			}
		}
		/if (${PetOn}) {
			/if (${MeleeDistance}>${PetAttackRange}) {
				|/echo WARNING: You will be casting or engaging the mob before your pet. Aggro will go to you first. Check MeleeDistance and PetAttackDistance in your ini.
			}
		}
		/if (${DropInvisMAAssist}) {
			|/echo - I will drop invis if the MA calls assist.
		}
		|/echo You may /restartka at anytime to reload KA with current settings.  To reload all clients, you may /bca //restartka

		/if (${Me.Invis}) {
			/multiline ; /echo ; /echo \ayFYI - If you are wondering why nothing is happenning, you are invisible. You're welcome. ; /echo
		}
		
	/return

| ----------------------------------------------------------------------------
| SUB: Init Data
| ----------------------------------------------------------------------------
    Sub InitData
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /declare n              int       local
        /declare WorkString     string    local
        /declare CondNo         int       local
        | Set AA DurationMod for various timer from Spell Casting Reinforcement AA
        /if (${Bool[${Me.AltAbility[Spell Casting Reinforcement].Rank}]}) {
            /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==1) {
                /varset DurationMod 1.15
            } else /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==2) {
                /varset DurationMod 1.3
            } else /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==3) {
                /varset DurationMod 1.5
            } else /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==4) {
                /varset DurationMod 1.6
            } else /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==5) {
                /varset DurationMod 1.7
            } else /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==6) {
                /varset DurationMod 1.8
            } else /if (${Me.AltAbility[Spell Casting Reinforcement].Rank}==7) {
                /varset DurationMod 1.9
            }
        } else /if (${Bool[${Me.AltAbility[Extended Ingenuity].Rank}]}) {
            /if (${Me.AltAbility[Extended Ingenuity].Rank}==1) {
                /varset DurationMod 1.15
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==2) {
                /varset DurationMod 1.3
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==3) {
                /varset DurationMod 1.4
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==4) {
                /varset DurationMod 1.5
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==5) {
                /varset DurationMod 1.6
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==6) {
                /varset DurationMod 1.7
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==7) {
                /varset DurationMod 1.8
            } else /if (${Me.AltAbility[Extended Ingenuity].Rank}==8) {
                /varset DurationMod 1.9
            }
        }
        | Set AA DurationMod for mez timer from Spell Casting Reinforcement AA
        /if (${Bool[${Me.AltAbility[Mesmerization Mastery].Rank}]}) {
            /if (${Me.AltAbility[Mesmerization Mastery].Rank}==1) {
                /varset MezMod 6
            } else /if (${Me.AltAbility[Mesmerization Mastery].Rank}==2) {
                /varset MezMod 12
            } else /if (${Me.AltAbility[Mesmerization Mastery].Rank}==3) {
                /varset MezMod 18
            } else /if (${Me.AltAbility[Mesmerization Mastery].Rank}==4) {
                /varset MezMod 24
            }
        } else /if (${Bool[${Me.AltAbility[Domination Mastery].Rank}]}) {
            /if (${Me.AltAbility[Mesmerization Mastery].Rank}==9) {
                /varset MezMod 6
            } else /if (${Me.AltAbility[Mesmerization Mastery].Rank}==10) {
                /varset MezMod 12
            } else /if (${Me.AltAbility[Mesmerization Mastery].Rank}==11) {
                /varset MezMod 18
            }
        }
        
        /if (${Bool[${Me.AltAbility[Companion's Discipline].Rank}]}) {
            /if (${Me.AltAbility[Companion's Discipline]}>5) /varset PetFocusOn 1
        }
        | Compensate for Eyes Wide open AA and Extended Target Window
        /if (${Ini[${IniFileName},General,XTSlot].Length}) {
            /varset XTSlot ${Ini[${IniFileName},General,XTSlot]}
            /if (${XTSlot}) /xtarget set ${XTSlot} autohater
            /ini "${IniFileName}" "General" "XTSlot" "0"
            /while (${Me.XTarget[${XTSlot}].TargetType.NotEqual[Auto Hater]}) {
               /delay 5
            }
            /varset XTSlot 0
        }
        /for n 1 to ${XSlotTotal}
            /if (${Me.XTarget[${n}].TargetType.Equal[Auto Hater]}) {
                /if (${XTSlot} && !${XTSlot2}) /varset XTSlot2 ${n}
                /if (${XTSlot}==0) {
                    /varset XTSlot ${n}
                    /ini "${IniFileName}" "General" "XTSlot" "${XTSlot}"
                }
            }
        /next n
        |  Added extra slot check and Error Message
        /if (${XTSlot}==0 || ${ChainPull} && !${XTSlot2}) {
            /echo You need more slots in your Extended Target Window set to Auto.
            /if (${ChainPull}) {
                /echo Please set at least 2 slots to Auto for Chain Pulling and restart KissAssist.
            } else {
                /echo Please set at least 1 slot to Auto and restart KissAssist.
            }
            /endmacro
        }
		
		| The way AggroTargetID and PullAggroTargetID work are HUGELY important. There should be no direct assignments made to either.
		
        | Changed Logic for populating AggroTargetID. This change will include mobs in camp not on XTarget.
        /noparse /varset AggroTargetID ${If[${Me.XTarget[${XTSlot}].ID},${Me.XTarget[${XTSlot}].ID},${If[${AggroTargetID2},${AggroTargetID2},0]}]}

        | Look at removing the AggroTargetID2 code if the change below works.
        | It did NOT work. Will have to update the pull code NOT to use MyTargetID and start using PullMob.
        |/noparse /varset AggroTargetID ${If[${Me.XTarget[${XTSlot}].ID},${Me.XTarget[${XTSlot}].ID},${If[${MyTargetID},${MyTargetID},0]}]}
        /noparse /varset PullAggroTargetID ${If[${ChainPull}==0,${Me.XTarget[${XTSlot}].ID},${If[${Me.XTarget[${XTSlot}].ID} && (${Me.XTarget[${XTSlot}].ID}==${MyTargetID} || ${Me.XTarget[${XTSlot}].ID}!=${BeginMobID} || ${Me.XTarget[${XTSlot2}].ID}),${MyTargetID},0]}]}

        /if (${Select[${Me.Class.ShortName},BST,BRD,CLR,DRU,ENC,MAG,NEC,PAL,RNG,SHM,SHD,WIZ]}) /varset MedStat Mana
        /if (${Select[${Me.Class.ShortName},BER,MNK,ROG,WAR]}) /varset MedStat Endurance
        
        /if (${PullLevel.Find[auto]}) {
           /varcalc PullMin ${Me.Level}-5
           /varcalc PullMax ${Me.Level}+2
        } else /if (${PullLevel.Equal[0|0]} || ${PullLevel.Equal[0]} || ${PullLevel.Equal[null]} || !${PullLevel.Find[|]}) {
           /varset PullMin 1
           /varset PullMax 200
           /varset PullLevel off
        } else {
           /varset PullMin ${PullLevel.Left[${Math.Calc[${PullLevel.Find[|]}-1]}]}
           /varset PullMax ${PullLevel.Right[${Math.Calc[${PullLevel.Length}-${PullLevel.Find[|]}]}]}
           /if (${PullMin}==0) /varset PullMin 1
           /if (${PullMax}==0) /varset PullMax 200
        }
        /if (${PullMin}>${PullMax} || ${PullMin}==0 || ${PullMax}==0) {
           /echo Invalid Pull Level Settings resetting to default.
           /varset PullMin 1
           /varset PullMax 200
           /varset PullLevel off
        }
        /if (${PullArcWidth}>359) /varset PullArcWidth 0
        /if (${Select[${Role},puller,pullertank,pullerpettank,hunter,hunterpettank]}) {
            /if (${PullWith.Find[|]} && ${PullWith.Arg[2,|].Length}) {
                /if (!${FindItemCount[=${PullWith.Arg[2,|]}]}) {
                    /varset WorkString ${PullWith.Arg[2,|]}
                    /for n 1 to ${Buffs.Size}
                        /if (${Buffs[${n}].Arg[2,|].Equal[summon]} && ${Buffs[${n}].Arg[3,|].Equal[${WorkString}]}) {
                            /if (${ConOn} && ${Buffs[${n}].Find[|cond]}) {
                                /varset CondNo ${Buffs[${n}].Mid[${Math.Calc[${Buffs[${n}].Find[|cond]}+5]},3]}
                            } else {
                                /varset CondNo 0
                            }
                            /call SummonStuff "${Buffs[${n}].Arg[1,|]}" "${WorkString}" 1 ${CondNo}
                            /if (${FindItemCount[=${PullWith.Arg[2,|]}]}) /break
                        }
                    /next n
                    /if (!${FindItemCount[${PullWith.Arg[2,|]}]}) {
                        /echo You have NO Ammo to pull with and I wasn't able to summon any.
                    }
                }
            }
            /if (${PullWith.Length} && ${PullWith.NotEqual[null]}) /call PullRangeSet
        }
        /if (${g_ExtendedBuffList.Length} && ${g_ExtendedBuffList.NotEqual[null]}) {
            /echo Recovering Extended Buff List.
            /varset ExtendedBuffList ${g_ExtendedBuffList}
        }
		POPCALL
    /return
	
| ----------------------------------------------------------------------------
| SUB: InitPlugins
| ----------------------------------------------------------------------------
    Sub InitPlugins
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /declare PeersZone string local
        /call CheckPlugin MQ2Exchange
        /call CheckPlugin MQ2Moveutils
        /call CheckPlugin MQ2Posse
        /call CheckPlugin MQ2Rez
        /if (${IAmABard}) /call CheckPlugin MQ2Twist 1
        /if (!${IAmABard} && !${Bool[${Plugin[mq2twist]}]}) /declare Twist int outer 0
        /if (${UseMQ2Melee}) {
            /call CheckPlugin MQ2Melee
            /if (${Bool[${Plugin[mq2melee]}]}) {
            |  Turn aggro mode off and turn on melee mode in MQ2Melee
                /squelch /melee aggro=0
                /squelch /melee melee=1
                /squelch /melee petassist=0
                /squelch /melee on
                |stickmode: 0=MQ2Melee Auto mode, 1=Use custom StickCmd from MQ2Melee ini settings,2=Turn stick off. No /Sticking.
                /if (${UseMQ2Melee}==1) {
                    /squelch /melee stickmode=0
                } else {
                    /squelch /melee stickmode=1
                }
                /varset StickHow 0
            } else {
                /echo MQ2Melee plugin did NOT load. Setting UseMQ2Melee off.
                /varset UseMQ2Melee 0
                /if (${StickHow.Equal[0]}) /varset StickHow auto
            }
        } else {
            /if (${Bool[${Plugin[mq2melee]}]}) {
                /plugin mq2melee unload noauto
                /varset MQ2MeleeReload 1
            }
            /if (${StickHow.Equal[0]}) /varset StickHow auto
        }
        /if (${Bool[${Plugin[mq2cast]}]} && !${UseMQ2Melee}) {
            /plugin mq2cast unload noauto
            /varset MQ2CastReload 1
        }
        /varset DStickHow ${StickHow}
        /if (${EQBCOn} && !${Macro.IsTLO[EQBC]}) /plugin mq2eqbc noauto
        /if (${DanNetOn}) {
            /if (!${Macro.IsTLO[DanNet]}) {
                /call CheckPlugin mq2dannet 1
            }
            /if (${Zone.ShortName.Find[_]}) {
                /varset PeersZone zone_${Zone.ShortName}
            } else {
                /varset PeersZone zone_${EverQuest.Server.Lower}_${Zone.ShortName}
            }
            /dnet fullnames off
            /echo I see ${DanNet.PeerCount[all]} clients connected to DanNet and ${DanNet.PeerCount[${PeersZone}]} clients in same Zone.
        }
        | Set MQ2moveutils variables
        /stick set autosave off
        /stick set verbflags 0
        /stick set breakonkb on
        /stick set breakonmouse off
        /stick set breakdist ${CampRadiusExceed}
        /stick set breakonwarp on
        /stick set usefleeing on
        /stick set delaystrafe on
        /stick set feign on
        | Set up MQ2rez if RezAcceptOn=1
        | Use new Rez TLO to capture current settings and restore when exiting macro.
        /if (${RezAcceptOn.Arg[1,|].Equal[1]}) {
            /squelch /rez accept on
            /squelch /rez loot off
            /if (${Int[${RezAcceptOn.Arg[2,|]}]}>0) /rez pct ${Int[${RezAcceptOn.Arg[2,|]}]}
        } else {
            /squelch /rez accept off
        }
        /if (${Macro.IsTLO[Posse]}) {
            /if (${Select[${AFKToolsOn},1,2]}) {
                /posse radius ${AFKPCRadius}
                /posse friendnotify off
                /posse strangernotify on
                /if (!${Posse.Status})  {
                    /posse on
                    /posse load
                }
            }
        } else {
            /varset AFKToolsOn 0
        }
        /if (${Bool[${Plugin[mq2log]}]}) {
            /varset DebugLogging ${Int[${Ini["..\${EverQuest.Server}_${Me.CleanName}.ini",MQ2Log,Enabled]}]}
        }
		POPCALL
    /return

| -------------------------------------------------------------------------------------------------
| SUB: PParse Parse passed command line parameters
| -------------------------------------------------------------------------------------------------
    Sub PParse(int iniLoaded, int nump)
        /if (!${nump}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN PParse: iniLoaded: ${iniLoaded} NumP: ${nump}
        /declare i int local 0
        /declare j int local 0
        /declare k int local 0
        /declare pMaxRadius int local 0
        /declare TempPathX float local 0
        /declare TempPathY float local 0
        /declare TempPathZ float local 0
        /declare ipa int local 0
        /declare ipb int local 0
        /declare numc int local ${Math.Calc[${nump}-1]}
        | Command Line Passed Parameterss start with the number 0. 0 is the first param and is counted as 1 param even though the loop is 0 to 0.
        /for i 0 to ${numc}
            DEBUGN PParse: ${i}. ${Defined[PParam${i}]} P${i}: ${PParam${i}}
            /if (${Defined[PParam${i}]}) {
                | ipa increases the param counter by 1 so we can assign the variable after the current parma.
                | /mac kissassist assist ma bob - if Param1 is ma for mainassist the next param is bob
                /varcalc ipa ${i}+1
                /if (${i}>0) /varcalc ipb ${i}-1
                /if (${Select[${PParam${i}},debug,debugall]}) /continue
                /if (!${iniLoaded}) {
                    /if (${PParam${i}.Equal[ini]}) {
                        /varset IniFileName ${PParam${ipa}}
                        /echo \awAKA: \ayIni file has been set to >> ${PParam${ipa}} <<
                        /varset PIniSet 1
                    } else /if (${PParam${i}.Equal[forcealias]}) {
                        /varset ForceAlias 1
                    }
                } else {
                    /if (${PParam${i}.Equal[ini]}) {
                        /varcalc i ${i}+1
                        /continue
                    } else /if (${Select[${PParam${i}},debug,debugall,forcealias]}) {
                        /continue
					|
					| Added petofftank, made a define.
					|
                    } else /if (${Select[${PParam${i}},VALID_ROLES]}) {
                        /varset p_Role ${PParam${i}}
                    } else /if (${PParam${i}.Equal[ma]}) {
                        /if (${Defined[PParam${ipa}]}) {
                            /varset MainAssist ${PParam${ipa}}
                            /varcalc i ${i}+1
                        } else {
                            /varset MainAssist
                            /break
                        }
                    } else /if (${PParam${i}.Equal[assistat]}) {
                        /if (${Defined[PParam${ipa}]}) {
                            /varset p_AssistAt ${PParam${ipa}}
                            /varcalc i ${i}+1
                        } else {
                            /varset p_AssistAt 95
                            |/break
                        }
                        /continue
                    } else /if (${PParam${i}.Equal[scanini]}) {
                        /ini "${KABuffsIni}" ${Me.ID} Zone NULL
                    } else /if (${PParam${i}.Equal[autoload]}) {
                        /varset LoadFromINI 1
                    } else /if (${PParam${i}.Equal[path]}) {
                        /if (!${Defined[PParam${ipa}]}) {
                            /echo Please provide a Path name when using the Path parameter.
                            /varset PullMoveUse
                            /varset PullPathWpCount 0
                        } else {
                            /call CheckPlugin MQ2AdvPath
                            /if (${Bool[${Plugin[MQ2AdvPath]}]}) {
                                /delay 20 ${AdvPath.Active}
                                | Play path on pause to load info . Only way we can grab info from advpath
                                /if (${AdvPath.PathList[${PParam${ipa}}]}) {
                                    /play ${PParam${ipa}} pause
                                    /varset p_PullPath ${PParam${ipa}}
                                    /delay 10
                                    | Set PullPathWpCount with total amount of waypoints in path
                                    /varset PullPathWpCount ${AdvPath.Waypoints}
                                    | Load path points into array
                                    /for k 1 to ${PullPathWpCount}
                                        DEBUGN PParse WP#: ${Int[${Math.Calc[${k}-1]}]}-${k} Distance Between: ${Math.Distance[${TempPathY},${TempPathX}:${AdvPath.Y[${k}]},${AdvPath.X[${k}]}]}
                                        /varset PullPathArrayX[${k}] ${AdvPath.X[${k}]}
                                        /varset PullPathArrayY[${k}] ${AdvPath.Y[${k}]}
                                        /varset PullPathArrayZ[${k}] ${AdvPath.Z[${k}]}
                                        /varset TempPathX ${PullPathArrayX[${k}]}
                                        /varset TempPathY ${PullPathArrayY[${k}]}
                                        /varset TempMaxRadius ${Math.Distance[${CampYLoc},${CampXLoc}:${PullPathArrayY[${k}]},${PullPathArrayX[${k}]}]}
                                        /if (${TempMaxRadius}>${pMaxRadius}) /varset pMaxRadius ${TempMaxRadius}
                                        DEBUGN PParse: WP: ${k} WPX: ${PullPathArrayX[${k}]} WPY: ${PullPathArrayY[${k}]}
                                    /next k
                                    /varset TempMaxRadius ${pMaxRadius}
                                    /play off
                                    | Tell Kiss were are using MQ2advpath for pulling
                                    /varset PullMoveUse advpath
                                }
                            } else {
                                /echo Path ${PParam${ipa}} not found.
                                /varset PullMoveUse
                                /varset PullPathWpCount 0
                            }
                        }
                    } else {
                        /if (${Int[${PParam${i}}]}==0) {
                            /varset MainAssist ${PParam${i}}
                        } else /if (${Int[${PParam${i}}]} >= 1 && ${Int[${PParam${i}}]} <= 100) {
                            /varset p_AssistAt ${PParam${i}}
                        }
                    }
                }
            }
        /next i
        /if (${iniLoaded}) {
            /if (${Debug}) /echo \atDEBUG PParse Leave Role: ${p_Role} MA: ${MainAssist} AssistAt: ${p_AssistAt} PullPath: ${p_PullPath}
        } else {
            /if (${Debug}) /echo \atDEBUG PParse Leave IniFile: ${IniFileName} InitAlias: ${ForceAlias}
        }
    /return

| ---------------------------------------------------------------------------
| SUB PlayerHelp
| ---------------------------------------------------------------------------
	Sub PlayerHelp
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

		/echo
		/echo Usage: /mac kissassist [KissRole] [AssistsName]
		/echo
		/echo Instead of specifying the [AssistsName], target them. That
		/echo character is your Main Assist which will direct combat.
		/echo
		/echo If this is your first time using KissAssist, welcome! To get you
		/echo started, I have made a profile that you can configure. There is
		/echo a wiki at www.kissassist.com, as well as example ini files in
		/echo the Redguides Macro KissAssist forum. Please feel free to ask
		/echo questions in the forum. Players are encouraged to share their
		/echo ini files so we all improve.
		/echo
		/echo You do not have to always play the same role. You may set a
		/echo preferred default in your ini or specify the [KissRole] at
		/echo startup.
		/echo
		/echo Tanks  : Tank, Offtank, PetTank, PetOfftank
		/echo Pullers: Puller, PullerTank, PullerPetTank, Hunter, HunterPetTank
		/echo Assist : Assist, PetAssist, Manual
		/echo
		/echo Your ini file is: ${IniFileName}
		/echo which you can find in /VeryVanilla/Macros
		/echo
		
	/return
	
| ---------------------------------------------------------------------------
| SUB: PullerNotifications
| ---------------------------------------------------------------------------	
	Sub	PullerNotifications
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /if (${Role.Find[pull]} || ${Role.Find[hunt]}) {
            /if (${PullPathWpCount} && ${PullMoveUse.Equal[advpath]}) {
                /call BroadCast r "PULL: Path >> ${PullPath} <<  found with ${PullPathWpCount} waypoints."
                /call BroadCast r "PULL: Using MQ2AdvPath to Pull with."
            } else /if (${Bool[${Plugin[MQ2Nav]}]}) {
                /if (${Navigation.MeshLoaded}) {
                    | Set pullmoveuse to nav if mq2nav is detected without a mq2advpath path
                    /varset PullMoveUse nav
                    /call BroadCast r "PULL: The MQ2Nav mesh for ${Zone} is loaded"
                    /call BroadCast r "PULL: Using MQ2Nav to Pull with ${PullWith}"
                } else {
                    /varset PullMoveUse los
                    /call BroadCast r "PULL: Using Line of Sight to Pull with ${PullWith}"
                }
            } else {
                /varset PullMoveUse los
                /call BroadCast r "PULL: Using Line of Sight to Pull with ${PullWith}"
            }
        } else {
            /if (${Bool[${Plugin[MQ2Nav]}]}) {
                /if (${Navigation.MeshLoaded}) {
                    | Set pullmoveuse to nav if mq2nav is detected without a mq2advpath path
                    /varset PullMoveUse nav
                    /echo The MQ2Nav mesh for ${Zone} is loaded
                    /echo Using MQ2Nav to Move.
                } else {
                    /varset PullMoveUse los
                }
            } else {
                /varset PullMoveUse los
                /echo Using MoveUtil to move with.
            }
        }
        /if (${Select[${PullMoveUse},los,nav]}>=1) /varset UseWayPointZ 0
		POPCALL
    /return
	
| ---------------------------------------------------------------------------
| SUB: RoleNotifications
| All the things that I will do.
| ---------------------------------------------------------------------------
	Sub RoleNotifications
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /if (${Select[${Role},tank]}) {
            /if (${IAmMA}) {
                /echo I am Tanking & Main Assist
            }
        } else /if (${Select[${Role},puller]}) {
            /echo I am Puller. KissAssisting >> ${MainAssist} << at ${AssistAt}%
            /if (${ChainPull}) /echo  What? I have to chain pull now.
        } else /if (${Select[${Role},pullertank]}) {
            /echo I am Puller & Tank.
		|
		| Petofftank makes things better.
		|
        } else /if (${Select[${Role},petofftank]}) {
            /echo My Pet >> ${Pet.CleanName} << is Offtanking & KissAssisting >> ${MainAssist} << at ${AssistAt}%
			/echo You'll see that pets are useful. Promise.
        | PetTank set role		
        } else /if (${Select[${Role},pettank]}) {
            /echo My Pet >> ${Pet.CleanName} << is Tanking & KissAssisting >> ${MainAssist} <<
        | PullerPetTank set role
        } else /if (${Select[${Role},pullerpettank]}) {
            /echo I am Pulling & my Pet >> ${Pet.CleanName} << is Tanking.
            /echo We are all doomed.
            /delay 10
            /echo DOOMED!
        | HunterPetTank set role
        } else /if (${Select[${Role},hunterpettank]}) {
            /echo I am Hunting & my Pet >> ${Pet.CleanName} << is Tanking.
        } else /if (${Select[${Role},hunter]}) {
            /echo I am Hunting.
        } else /if (${Select[${Role},offtank]}) {
            /echo I am Off Tanking. KissAssisting >> ${MainAssist} << at ${AssistAt}%
        } else {
            /if (${MainAssist.Length} && ${MainAssist.NotEqual[null]}) {
                /echo KissAssisting >> ${MainAssist} << at ${AssistAt}%
                /echo ${MainAssist} is a ${MainAssistType} ${Spawn[=${MainAssist}].Class}
            }
        }
        /if (${Role.Find[Puller]} && ${Float[${PullArcWidth}]}>0) {
            /call SetPullAngles ${Me.Heading.Degrees} ${Float[${PullArcWidth}]} 1
            /echo Pulling an Area starting from the Left at ${PullLSide} degrees ending at ${PullRSide} degrees.
        }
        /call TargetThis
        /squelch /assist off
		POPCALL
	/return

| -------------------------------------------------------------------------------------------------
| SUB: Set XTargets
|
| WatchTargets=Starting XTSlot|Name1|Name2..
| -------------------------------------------------------------------------------------------------
    Sub SetXTargets(string WatchTargets)

        /if (!${WatchTargets.Find[|]}) {
            /echo \awAKA: \ayExpected something like 2|Charname. The starting xtslot must be provided.
            /return
        }
        /if (!${Int[${WatchTargets.Arg[1,|]}]} || ${Int[${WatchTargets.Arg[1,|]}]}>13) {
            /echo \awAKA: \ayExpected something like 2|Charname. The starting xtslot must be between 1-13, and at most 13 characters can be watched.
            /return
        }

        /call ClearXTargets

        /declare XTSlotStart int local ${WatchTargets.Arg[1,|]}
        /declare XTarTargets int local ${WatchTargets.Count[|]}
        /declare XTarSlotEnd int local ${Math.Calc[${XTSlotStart}+${XTarTargets}-1]}
        /declare WatchIndex  int local 2
        /declare i           int local 0
        /declare SetSucceed  int local 1
        
        /for i ${XTSlotStart} to ${XTarSlotEnd}
            /if (${Spawn[pc ${WatchTargets.Arg[${WatchIndex},|]}].ID}) {
                /xtarget set ${i} "${Spawn[pc ${WatchTargets.Arg[${WatchIndex},|]}].Name}"
            } else /if (${Spawn[pet ${WatchTargets.Arg[${WatchIndex},|]}].ID}) {
                /xtarget set ${i} "${Spawn[pet ${WatchTargets.Arg[${WatchIndex},|]}].Name}"
            } else /if (${Spawn[mercenary ${WatchTargets.Arg[${WatchIndex},|]}].ID}) {
                /xtarget set ${i} "${Spawn[mercenary ${WatchTargets.Arg[${WatchIndex},|]}].Name}"
            } else /if (${Spawn[npc ${WatchTargets.Arg[${WatchIndex},|]}].ID}) {
                /xtarget set ${i} "${Spawn[npc ${WatchTargets.Arg[${WatchIndex},|]}].Name}"
            } else /if (${Spawn[${WatchTargets.Arg[${WatchIndex},|]}].ID}) {
                /xtarget set ${i} "${Spawn[${WatchTargets.Arg[${WatchIndex},|]}].Name}"
            } else {
                /varset SetSucceed 0
            }           
            /if ( ${SetSucceed}) {
                /echo \awAKA: \aySet XTSlot ${i} to ${WatchTargets.Arg[${WatchIndex},|]}
            } else {
                /echo \awAKA: \ayCould not add ${WatchTargets.Arg[${WatchIndex},|]} to xtargets. Use /watch r to refresh when they are in zone or log in.
                /varset SetSucceed 1
            }
            /delay 10
            /varcalc WatchIndex ${WatchIndex}+1
        /next i

    /return

| -------------------------------------------------------------------------------------------------
| SUB: Clear XTargets
| -------------------------------------------------------------------------------------------------
    Sub ClearXTargets

        /declare XTSlotStart int local 1
        /declare XTarSlotEnd int local 13
        /declare i           int local 0
        
        /for i ${XTSlotStart} to ${XTarSlotEnd}
            /xtarget remove ${i}
            /delay 10
        /next i

    /return

| ----------------------------------------------------------------------------
| SUB: Set Xtargets to Watch
| ----------------------------------------------------------------------------
    Sub SetXTargetWatchList(string WatchList)
        /if (!${XTarWatch} && ${WatchList.Equal[null]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /declare n int local 0
        /if (${WatchList.Equal[all]}) {
            /for GlobalIndex 1 to ${XSlotTotal}
                /if (${Me.XTarget[${GlobalIndex}].TargetType.Equal[Auto Hater]}) {
                    /echo \awAKA: \ayXTarget ${GlobalIndex} is assigned as Auto Hater. You may want to fix this when using the ALL tag.
                } else {
                    /varcalc n ${n}+1
                    /varset XTarToWatch[${n}] ${GlobalIndex}
                }
            /next GlobalIndex
            /if (${n} && ${n}<${XSlotTotal}) {
                /varcalc n ${n}+1
                /for GlobalIndex ${n} to ${XSlotTotal}
                    /varset XTarToWatch[${GlobalIndex}] 0
                /next GlobalIndex
            }
        } else /if (${WatchList.Equal[auto]}) {
            /for GlobalIndex 1 to ${XSlotTotal}
                /if (${Me.XTarget[${GlobalIndex}].TargetType.Equal[Auto Hater]}) {
                    /continue
                } else {
                    /varcalc n ${n}+1
                    /varset XTarToWatch[${n}] ${GlobalIndex}
                }
            /next GlobalIndex
            /if (${n} && ${n}<${XSlotTotal}) {
                /varcalc n ${n}+1
                /for GlobalIndex ${n} to ${XSlotTotal}
                    /varset XTarToWatch[${GlobalIndex}] 0
                /next GlobalIndex
            }
        } else {
            /varset n 1
            /varset GlobalIndex 1
            /if (${WatchList.Find[|]}) {
                /while (${GlobalIndex}<${XSlotTotal}) {
                    /if (${Int[${WatchList.Arg[${GlobalIndex},|]}]}>0 && ${Int[${WatchList.Arg[${GlobalIndex},|]}]}<=${XSlotTotal}) {
                        /varset XTarToWatch[${n}] ${Int[${WatchList.Arg[${GlobalIndex},|]}]}
                        /if (${Me.XTarget[${XTarToWatch[${n}]}].TargetType.Equal[Auto Hater]}) /echo \awAKA: \ayXTarget ${XTarToWatch[${n}]} is assigned as Auto Hater. You may want to fix this.
                        /varcalc n ${n}+1
                        /varcalc GlobalIndex ${GlobalIndex}+1
                    } else /if (${Int[${WatchList.Arg[${GlobalIndex},|]}]}==0) {
                        /varset XTarToWatch[${n}] 0
                        /varcalc GlobalIndex ${XSlotTotal}+1
                    } else {
                        /varcalc GlobalIndex ${GlobalIndex}+1
                    }
                }
            } else {
                /varset XTarToWatch[1] ${Int[${WatchList}]}
            }
        }
    /return

| ----------------------------------------------------------------------------
| SUB: Startup commands
| ----------------------------------------------------------------------------
    Sub StartupCommands
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN StartupCommands Enter
        /declare CommandText string   local null
        /declare i           int      local 0
        /declare StartCount  int      local 0
        /declare CondNo      int      local 0
        /if (!${Ini[${IniFileName},"StartupCommands","CommandSize"].Length}) {
			/return
		}
        /varset StartCount ${Ini[${IniFileName},"StartupCommands","CommandSize"]}
        /if (!${StartCount}) {
			/return
		}
        /for i 1 to ${StartCount}
            /varset CommandText ${Ini[${IniFileName},"StartupCommands","Command${i}"]}
            /if (${ConOn} && ${CommandText.Find[|cond]}) {
                /varset CondNo ${CommandText.Mid[${Math.Calc[${CommandText.Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }
            /if (${CommandText.Length} && ${CommandText.NotEqual[null]}) {
                /if (${CondNo} && ${If[${Cond[${CondNo}]},0,1]}) /continue
                /docommand ${CommandText}
                DOPARSE
                /delay 5
            }
        /next i
        DEBUGN StartupCommands Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: StartupCredits
| ----------------------------------------------------------------------------
    Sub StartupCredits
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /echo ====================================================
        /echo \arRedguides presents
        /echo AlsoKissAssist v${MacroVer}.${KissRevision}
        /echo Developed by American Nero
		/echo KissAssist Created by Maskoi
		/echo Forked from v12.001 developed by CTaylor22
		/echo Future KA releases will be integrated where feasible.
        /echo ====================================================
        /if (${EQBCOn} && ${DanNetOn}) {
            /echo Using EQBC for Messaging and DanNet for Everything Else.
        } else /if (${EQBCOn}) {
            /echo Using EQBC for Messaging.
        } else /if (${DanNetOn}) {
            /echo Using DanNet for Everything.
        } else {
            /echo NOT using EQBC or DanNet.
        }
        /echo ====================================================
	/return

| ----------------------------------------------------------------------------
| SUB: Startup Miscellaneous Stuff
| ----------------------------------------------------------------------------
    Sub StartupMisc
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare s_Temp1 string local ${Ini[${IniFileName},Spells,Gem1,BLANK]}
        /declare i_x int local 0
        | If I am group leader set Main Assist Tag for Group Check for pet and make master MainAssist
        /if (${Select[${Me},${Group.Leader}]}) {
            /if (${Spawn[group ${MainAssist}].ID} || (${Spawn[=${MainAssist}].Type.Equal[pet]} && ${Spawn[group ${Spawn[=${MainAssist}].Master.CleanName}].ID})) {
                | If Main Assist is someone else than who its suppose to be unset Group tag
                /if (${Group.MainAssist.Name.Length} && ${Group.MainAssist.Name.NotEqual[${MainAssist}]}) {
                    /call AssignGroupRole unset "${Group.MainAssist.Name}" 2
                }
                /if (!${Group.MainAssist.Name.Length}) {
                    /if (${Spawn[=${MainAssist}].Type.Equal[pet]}) {
                        /call BroadCast r "Assigning ${Spawn[=${MainAssist}].Master.CleanName} as Main Assist in Group Window"
                        /call AssignGroupRole set "${Spawn[=${MainAssist}].Master.CleanName}" 2
                    } else {
                        /call BroadCast r "Assigning ${MainAssist} as Main Assist in Group Window"
                        /call AssignGroupRole set "${MainAssist}" 2
                    }
                }
            } else /if (${Group.MainAssist.Name.Length} && ${Group.MainAssist.Name.NotEqual[${MainAssist}]}) {
                /call AssignGroupRole unset "${Group.MainAssist.Name}" 2
            }
        }
        /if (${LoadSpellSet}) /call LoadSpellSet
        /if (${s_Temp1.Equal[blank]}) /call Bind_WriteMySpells 1
		POPCALL
    /return
