
| ----------------------------------------------------------------------------
| SUB: Bind_CothGroup
|
| This is for the mage.
| ----------------------------------------------------------------------------
	Sub Bind_CothGroup(string DropInvis)
		/if (!${IAmAMage}) /return
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
				
		/if (${Me.Invis} && ${DropInvis.Equal[1]}) {
			/makemevis
		} else /if (${Me.Invis}) {
			/echo You are currently invisible... you can drop invis by doing /cothgroup 1
			POPCALL
			/return
		}
		
		/declare GroupPCs	int		local	${Int[${Math.Calc[${Group.Members}-${Group.MercenaryCount}]}]}
		/declare SpellID	int		local	${Me.Book[${Spell[Call of the Heroes].RankName}]}
		
		/if (${SpellID} && ${GroupPCs}) {
			/echo We need heroes but all we have are zeroes! Calling the group anyway!
			/call CastHotSwap "Call of the Heroes" null Bind_CothGroup
		} else /if (!${GroupPCs}) {
			/echo No heroes to call.
		} else /if (${Me.Book[${Spell[Call of the Hero].RankName}]}) {
			/declare i int 0
			/for i 1 to ${Group.GroupSize}
				/if (!${Group.Member[${i}].Mercenary}) {
					/call Bind_CothPC ${Group.Member[${i}].CleanName}
				}
			/next i
		} else {
			/echo You don't know how to call heroes yet.
		}
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: Bind_CothMe
|
| This is for other characters requesting a coth
| ----------------------------------------------------------------------------
	Sub Bind_CothMe
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		/if (${GroupHasAMAG}) {
			/call Broadcast y "CothMePlease ${Me.CleanName}"
		}
	/return

| ----------------------------------------------------------------------------
| SUB: Bind_CothPC
|
| This is for the mage. At least it's supposed to be.
| ----------------------------------------------------------------------------
	Sub Bind_CothPC(string Cothee,string DropInvis)
		/if (!${IAmAMage} || (${IAmAMage} && ${Me.Level}<55)) /return
		/if (!${Cothee.Length} || ${Cothee.Equal[NULL]}) /return
		
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL		

		/if (${Me.Invis} && ${DropInvis.Equal[1]}) {
			/makemevis
		} else /if (${Me.Invis}) {
			/echo You are currently invisible... you can drop invis by doing /coth cotheename 1
			POPCALL
			/return
		}
				
		/declare CotheeID		int		local 	${Spawn[=${Cothee} pc].ID}
		
		/if (!${CotheeID}) {
			/echo The Hero ${Cothee} could not be found.
			POPCALL
			/return
		}
		/if ((${Me.Book[${Spell[Call of the Hero].RankName}]} || ${AltAbility[Call of the Hero]}) && ${CotheeID} && ${Group.Member[${Cothee}].ID} && ${CotheeID}!=${Me.ID}) {
			/echo We need a hero, but all I could find is ${Cothee}
			/while (1) {
				/if (!${Me.SpellReady[Call of the Hero]} && !${Me.AltAbilityReady[Call of the Hero]}) {
					/delay 5
				} else {
					/delay 5
					/break
				}
			}
			/call CastWhat "Call of the Hero" ${CotheeID} Bind_CothPC 0 0 FROMHERE
		} else /if (!(${Me.Book[${Spell[Call of the Hero].RankName}]} || ${AltAbility[Call of the Hero]})) {
			/echo You don't know how to call a hero yet.
		} else /if (!${Group.Member[${Cothee}].ID}) {
			/echo That PC is not in the group.
		} else {
			/echo You can't call yourself a hero. That's arrogant.
		}
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: Bind_CothUs
|
| This is for other characters requesting a coth
| ----------------------------------------------------------------------------
	Sub Bind_CothUs
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		/if (${GroupHasAMAG}) {
			/call Broadcast y "CothUsPlease"
		}
	/return

| ---------------------------------------------------------------------------
| Sub Bind_Reclaim
|	
| Usable by nec, enc, mag.
| ---------------------------------------------------------------------------
	Sub Bind_Reclaim		
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/if (!${IAmAMage}) {
			/echo Only Magicians may use this command. Sorry.
			POPCALL
			/return
		}
		/call ReclaimMana
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: CastPetToys
| ----------------------------------------------------------------------------
    Sub CastPetToys(string PetToySpell0)
        /declare retryCount 		int 	local 	0
        /declare cancelFlag 		int 	local 	0
		/declare GemTimerValue		string	local	NULL
		/declare CastToysTimerSec	timer	local	0
		
		/varset CastToysTimerSec 30s

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /while (1 || ${CastToysTimerSec}) {
			/doevents GotHit
			/if (!${Pet.ID}) {
				/varset cancelFlag 1
				/break
			}
            /varcalc retryCount ${retryCount}+1
            /call CastWhat "${PetToySpell0}" ${Me.ID} Pet-nomem 0 0 FROMHERE
            |/echo CastWhat Returned: ${Macro.Return}
            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                /echo Casting pet toy spell >> ${PetToySpell0} <<
                /break
            } else /if (${Macro.Return.Equal[CAST_FIZZLE]}) {
                /if (${retryCount}>3) {
                    /varset cancelFlag 1
                    /break
                }
                /if (!${Me.GemTimer[${PetToySpell0}]} && ${Me.SpellReady[${PetToySpell0}]}) {
                    /delay 5
                    /continue
                } else {
                    /while (${Me.GemTimer[${PetToySpell0}]} && ${CastToysTimerSec}) {
                        /delay 5
                    }
                    /continue
                }
            } else /if (${Macro.Return.Equal[CAST_RECOVER]}) {
				/varset GemTimerValue ${Me.GemTimer[${PetToySpell0}]}
				/if (${GemTimerValue.Equal[NULL]}) {
					/varset cancelFlag 1
					POPCALL
					/return ${cancelFlag}
				}
                /varcalc retryCount ${retryCount}-1
                /while (1 && ${CastToysTimerSec}) {
                    /delay 5
                    /if (${Me.SpellInCooldown}) /continue
                    /if (${Me.GemTimer[${PetToySpell0}]}) /continue
                    /if (!${Me.SpellReady[${PetToySpell0}]}) /continue
                    /break
                }
                /continue
            }
            /varset cancelFlag 1
            /break
        }
		POPCALL
    /return ${cancelFlag}

| ---------------------------------------------------------------------------
| Sub CleanupLostToys
|
| Many toys are lore. If you try to summon a bag with one of the items in your
| inventory, you fail without being given a reasonable error message.
| ---------------------------------------------------------------------------
	Sub CleanupLostToys(int SpellIndex, string PetToysSpell, string Contents)
		/if (!${SpellIndex} || ${PetToysSpell.Equal[NULL]} || !${PetToysSpell.Length}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGPET Enter
		
		/declare ToysContent		string		local		${PetToysContents[${SpellIndex}]}
		/declare ToySpell			string		local		${ToysContent.Arg[1,|]}
		/declare KeepToysFlag		string		local		${ToysContent.Arg[2,|]}
		/declare Toy1				string		local		${ToysContent.Arg[3,|]}
		/declare Toy2				string		local		${ToysContent.Arg[4,|]}
		/declare Toy3				string		local		${ToysContent.Arg[5,|]}
		/declare Toy4				string		local		${ToysContent.Arg[6,|]}
		/declare Toy5				string		local		${ToysContent.Arg[7,|]}
		/declare Toy6				string		local		${ToysContent.Arg[8,|]}
		/declare Toy7				string		local		${ToysContent.Arg[9,|]}
		/declare Toy8				string		local		${ToysContent.Arg[10,|]}
		/declare NewContent			string		local		NULL
		/declare i					int			local		0
		|/declare InvWasOpen			int			local		${Window[InventoryWindow].Open}
		|/declare ItemFound			int			local		0
		
		| We will by default destroy contents from inventory that we find in the list. If 1 or keep, keep. Otherwise its deleted.
		/declare DefaultAction		string		local		Destroy
		
		| We are doing a search and destroy if Contents not provided.
		/if (!${Contents.Length} || ${Contents.Equal[NULL]}) {
			
			/if (${ToysContent.Length} && ${ToysContent.NotEqual[NULL]}) {
				| If the user changed to a different spell, the contents will be updated at the next step.
				
				/if (${Select[${KeepToysFlag},1,keep]}) {
					POPCALL
					/return
				} else /if (!${Select[${KeepToysFlag},0,destroy]}) {
					/echo Invalid keep/destroy flag in ini Pet setting PetToysContents${i}. To destroy items follow the spell name with |0 or |destroy. To keep items use |1 or |keep. Skipping toy check. Restart when fixed.
					POPCALL
					/return
				}
				
				/for i 1 to 8
					/if (!${Toy${i}.Length} || ${Toy${i}.Equal[null]}) /continue
					| Walk the list 1-8 searching for each toy in inventory
					/if (${FindItemCount[=${Toy${i}}]}) {
						/while (1) {
							/squelch /shift /itemnotify "${Toy${i}}" leftmouseup
							/delay 20 ${Cursor.ID}	
							/if (${Cursor.ID}) {
								/destroy
								/delay 10s ${Window[ConfirmationDialogBox].Open}
								/if (${Window[ConfirmationDialogBox].Open}) {
									/nomodkey /notify ConfirmationDialogBox Yes_Button leftmouseup
									/delay 5
								}
							} else {
								/break
							}
						}
					}
					
				/next i
				
				|/if (${ItemFound}) {
				|	/keypress CLOSE_INV_BAGS
				|	/if (${InvWasOpen}) {
				|		/windowstate InventoryWindow close
				|		/delay 2s !${Window[InventoryWindow].Open}
				|	}
				|}
				
			}

		} else {
			| Read the bag contents and create the entry if needed.
	
			/varset NewContent ${PetToysSpell}|${DefaultAction}|${Contents}
			
			/if (${ToysContent.NotEqual[${NewContent}]}) {
				/ini "${IniFileName}" "Pet" "PetToysContents${SpellIndex}" "${NewContent}"	
			}
		}
		
		POPCALL
	/return
	
| ----------------------------------------------------------------------------
| SUB: Check DestroyBag - Based on code from el_nene's autobot. Used with permission.
| Autobot is available at www.Macroquest2.com VIP macro section.
| Updated and Revised for KissAssist
| ----------------------------------------------------------------------------
    Sub DestroyBag
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS DestroyBag Enter
        /declare j int local
        | Make sure bag has no items other than summoned in it before deleting.
        /if (${Me.Inventory[pack${BagNum}].Items}) {
            /for j 1 to ${Me.Inventory[pack${BagNum}].Container}
                /if (${Me.Inventory[pack${BagNum}].Item[${j}].Name.Length}) {
                    /if (!${Me.Inventory[pack${BagNum}].Item[${j}].NoRent}) {
                        /echo Bag has non summoned item(s) in it. Aborting delete. Pet Toys Off
                        /varset PetToysOn 0
						POPCALL
                        /return
                    }
                }
            /next j
        }
        /if (${Me.Inventory[pack${BagNum}].Name.Find[Phantom Satchel]} || ${Me.Inventory[pack${BagNum}].Name.Find[Pouch of Quellious]}) {
            /nomodkey /itemnotify pack${BagNum} leftmouseup
            /delay 5s ${Cursor.ID}
            /if (${Cursor.Name.Find[Phantom Satchel]} || ${Cursor.Name.Find[Pouch of Quellious]}) {
				/destroy
				|
				| Increased potential delay due to lag.
				|
				/delay 50 !${Cursor.ID}
				|
				| Give it one more try. Yes I know this is crappy.
				|
				/if (${Cursor.Name.Find[Phantom Satchel]} || ${Cursor.Name.Find[Pouch of Quellious]}) {
					/destroy
					/delay 50 !${Cursor.ID}
				}
			}

        }
		POPCALL
        DEBUGBUFFS Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: CothMePlease
|
| This is for other characters
| ----------------------------------------------------------------------------
	Sub Event_CothMePlease(Line,string Requestor)
		/doevents flush CothMePlease
		/if (!${IAmAMage} || (${IAmAMage} && ${Me.Level}<55)) /return
		/if (!${ProvideCoth}) /return
		/if (${Requestor.Equal[${Me.CleanName}]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL			
		
		/declare RequestorID	int		local 	${Spawn[=${Requestor} pc].ID}
		
		/if (!${Me.Book[${Spell[Call of the Hero].RankName}]} && !${AltAbility[Call of the Hero]}) {
			/echo I don't know how to call a hero yet.
			POPCALL
			/return
		}
		/if (!${Requestor.Length} || ${Requestor.Equal[NULL]}) {
			/echo A hero wasn't specified.
			POPCALL
			/return
		}
		/if (!${RequestorID}) {
			/echo Could not find the hero.
			POPCALL
			/return
		}
		/if (!${Group.Member[${Spawn[id ${RequestorID}].CleanName}].Index}) {
			/echo That hero is not in the group.
			POPCALL
			/return
		}		
		/if (${Me.Invis}) {
			/tell ${Requestor} I'm currently invisible and cannot COTH.
			POPCALL
			/return
		}
		/tell ${Requestor} Calling...
		/while (1) {
			/if (!${Me.SpellReady[Call of the Hero]} && !${Me.AltAbilityReady[Call of the Hero]}) {
				/delay 5
			} else {
				/break
			}
		}		
		/call CastWhat "Call of the Hero" ${RequestorID} Event_CothMePlease 0 0 FROMHERE
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: CothUsPlease
|
| This is for other characters
| ----------------------------------------------------------------------------
	Sub Event_CothUsPlease(Message)
		/doevents flush CothUsPlease
		/if (!${IAmAMage}) /return
		/if (!${ProvideCoth}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
			
		/if (${Me.Invis}) {
			/bca I'm currently invisible and will not COTH.
			POPCALL
			/return
		}
		
		/declare GroupPCs	int		local	${Int[${Math.Calc[${Group.Members}-${Group.MercenaryCount}]}]}
		/declare SpellID	int		local	${Me.Book[${Spell[Call of the Heroes].RankName}]}
		
		/if (${ProvideCoth} && ${SpellID} && ${GroupPCs}) {
			/echo We need heroes but all we have are zeroes! Calling the group anyway!
			/call CastHotSwap "Call of the Heroes" null Event_CothUsPlease
		} else /if (!${ProvideCoth}) {
			POPCALL
			/return
		} else /if (!${GroupPCs})) {
			/echo No heroes to call.
 		} else /if (${Me.Book[${Spell[Call of the Hero].RankName}]}) {
			/declare i int 0
			/for i 1 to ${Group.GroupSize}
				/if (!${Group.Member[${i}].Mercenary}) {
					/call Bind_CothPC ${Group.Member[${i}].CleanName}
				}
			/next i
		} else {
			/echo You don't know how to call heroes yet.
		}
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: Event ModRodsPlease
|
| This is intended for use in combat. While you can use begfor during buff
| time, this is more flexible.
| ----------------------------------------------------------------------------
	Sub Event_ModRodsPlease
		/doevents flush ModRodsPlease
		/if (!${IAmAMage}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		/if (${ProvideModRods} && ${AltAbility[Summon Modulation Shard].ID}) {
			/call CastWhat "Summon Modulation Shard" 0 ModRodsPlease 0 0 FROMHERE
		}
		POPCALL
	/return
	
| -------------------------------------------------------------------------------------
| SUB: Event PetToysPls
| Changed it from PetToysPlease to PetToysPls because the debug messages triggered
| the event. Need to make sure bind name is different than sub everywhere.
| -------------------------------------------------------------------------------------
    Sub Event_PetToysPls(Message,string MTWho)
		/doevents flush PetToysPls
		/if (!${IAmAMage} || ${AggroTargetID} || !${PetToysOn} || !${ProvidePetToys}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		/if (${CallCircular}) {
			POPCALL
			/return
		}

		|
		| Adding support to give bags to PC
		| Changed the input var MTPet to MTWho to make it easier to understand.
		| Sanity check in case the recipient could not be found.
		| Some nice messages to inform the player what's going on.
		|
		| Quiet response.
		|
		DEBUGPET PetToysPls: Enter
        /varset EventFlag 1
        /if (!${MTWho.Length} || ${MTWho.Find[null]}) {
			DEBUGPET We were not provided a name. Trying target ${Target.Name}
			/echo Name of pet toy recipient not provided. Assuming it's the target.
			/varset MTWho ${Target.Name}
		}
		DEBUGPET MTWho Name: ${MTWho}
		DEBUGPET MTWHO is a Pet: ${Spawn[pet ${MTWho}].ID}, group ${MTWho.Equal[group]}, PC ${Spawn[PC ${MTWho}].ID}
        /if (!${Spawn[pet ${MTWho}].ID} && ${MTWho.NotEqual[group]} && !${Spawn[PC ${MTWho}].ID}) {
			/echo The recipient of pet toys must either be a pet, the group, or a player.
			POPCALL
			/return
		}
        /declare PTPPetID int local
        /declare GMemID int local
        /declare GMemShortName string local
        /declare GMemPetName string local
        /declare i int local 0
		|
		| ${Spawn[pc Group].ID} returns your own ID, so it's a safe keyword to use
		| I tried ${Spawn[pet Group].ID} which returned null, but, what is the chance we ever encounter a pet named Group?
		|
        | If group command give all pets in group toys		
        /if (${MTWho.Find[GROUP]}) {
            /echo I am giving pet toys to every Pet in Group except mine.
            | Start at 1 my pet doesn't need toys
            /for i 1 to 5
				/doevents GotHit
				/call LastMove
				/varset GMemID ${Group.Member[${i}].ID};
				/varset PTPPetID ${Group.Member[${i}].Pet.ID}
				/varset GMemShortName ${Group.Member[${i}].Class.ShortName}
				/varset GMemPetName ${Group.Member[${i}].Pet.Name}
				DEBUGPET PetToysPls ${GMemID} && ${PTPPetID} && ${Select[${GMemShortName},PET_CLASSES_SHORTNAME]} && ${Spawn[=${GMemPetName}].Type.Equal[Pet]}
				|
				| Updated the spawn search so its a targetable pet.
				|
				/if (${GMemID} && ${PTPPetID} && ${Select[${GMemShortName},PET_CLASSES_SHORTNAME]} && ${Spawn[pet targetable ${GMemPetName}].ID}) {
					/call pettoys "${GMemPetName}"
				}
            /next i
			/echo Finished giving pet toys to the group's pets, assuming they had any.
        } else /if (${Spawn[pet targetable ${MTWho}].ID}) {
            | Individual Pet. It could even by my own, just in case I summoned a pet during battle.
            /echo Giving pet toys to ${MTWho}
            /call pettoys "${MTWho}"
        } else /if (${Spawn[PC targetable ${MTWho}].ID}) {
			/echo Giving pet toys to ${MTWho}
			/call pettoys "${MTWho}"
		} else {
			/echo The pet toys recipient could not be found. Maybe they died or logged?
		}
		POPCALL
        DEBUGPET PetToysPls: Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Check GiveTo - Based on code from el_nene's autobot. Used with permission.
| Autobot is available at www.Macroquest2.com VIP macro section.
| Updated and Revised for KissAssist
| ----------------------------------------------------------------------------
    Sub GiveTo(string GItem, int GTarget, int GiveNow)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGGIVE GiveTo Enter
        /declare ItemSummoned  	int    	local 	0
        /declare GItemID       	int    	local 	0
        /declare GDropCount    	int    	local 	0
        /declare x1            	int    	local 	0
        /declare ToyName       	string 	local
        /declare ListItem      	string 	local
		/declare CampWasOn		int		local	${ReturnToCamp}
		
		|
		| Adjusting give distance with param
		|
		/declare TradeDistance	int		local	5
		
        DEBUGGIVE In GiveTo ${GItem}
        /if (${GItem.NotEqual[giveitems]}) {
            /if (${Target.ID}!=${GTarget}) {
				/call TargetThis ${GTarget}
            }
			|
			| Get off the mount first
			|
            /if (${Me.Mount.ID}) {
                /dismount
                /delay 20 !${Me.Mount.ID}
            }
			|
			| Simplified. We will move to them if they are within the camp radius.
			|
			
			| If return to camp is on, then we cant get to the pet sometimes...
			/if (${CampWasOn}) /camphere off
			
            /if (${Target.Distance}<=${CampRadius}) {
                /moveto id ${Target.ID} mdist ${TradeDistance}
                /delay 50 ${MoveTo.Stopped}
            }
            /if (${Me.Levitating}) {
                /removelev
                /delay 20 !${Me.Levitating}
            }
            /if (!${Cursor.ID}) {
                /if (${FindItemCount[=${GItem}]}>0) {
                    /call PickUpItem "${GItem}" 0
                    |/shift /itemnotify "${GItem}" leftmouseup
                    |/delay 20 ${Cursor.ID}
                } else {
                    /echo Item: ${GItem} Not Found in Inventory. Are you sure the Item Name is Correct?
					POPCALL
                    /return
                }
            }
            /varset GItemID ${FindItem[=${GItem}].ID}
            /while (${Cursor.ID} && ${GDropCount}<4) {
				/doevents GotHit
				/doevents
				| Stop if aggro detected
				/if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0
				/if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
					POPCALL
					/return
				}
				
                /if (${Cursor.NoRent}) {
                    |/if (${Cursor.ID}==${FindItem[=${GItem}].ID}) {
                    /if (${Cursor.ID}==${GItemID}) {
                        /varset ItemSummoned 1
                        /nomodkey /click left target
                        /delay 20 !${Cursor.ID}
                        /varcalc ItemsGiven ${ItemsGiven}+1
                    } else {
                        /echo Item: ${GItem} Not Found on Cursor. Dropping ${Cursor} to Inventory.
                        /autoinventory
                        /delay 10
                        |/echo Item: ${GItem} Not Found on Cursor.
                        |/return
                    }
                } else {
                    /echo Item: ${Cursor} is not Summoned. Dropping to Inventory.
                    /autoinventory
                    /delay 10
                }
                /varcalc GDropCount ${GDropCount}+1
            }
            /if (${Cursor.ID}) {
                /echo Item still on Cursor. The Item is the wrong item or your inventory is full.
				POPCALL
                /return
            }
        } else {
            /varset ItemSummoned 1
            /varset GiveNow 1
        }
        /delay 30 ${Window[GiveWnd].Open}
        /if (${Window[GiveWnd].Open}) {
            DEBUGGIVE ${GiveNow} - ${Window[GiveWnd].Child[GVW_MyItemSlot0].Tooltip.Length} - ${Window[GiveWnd].Child[GVW_MyItemSlot1].Tooltip.Length} - ${Window[GiveWnd].Child[GVW_MyItemSlot2].Tooltip.Length} - ${Window[GiveWnd].Child[GVW_MyItemSlot3].Tooltip.Length}
            /if (${GiveNow} || ${ItemsGiven}==4) {
                /notify GiveWnd GVW_Give_Button leftmouseup
                DEBUGGIVE Giving ${GItem} to ${Target.CleanName}
                /echo Giving Item(s) to ${Target.CleanName}
                /delay 20 !${Window[GiveWnd].Open}
                /delay 15
                /varset ItemsGiven 0
            }
            |/echo Item is NOT SUMMONED canceling trade
            |/notify GiveWnd GVW_Cancel_Button leftmouseup
        }
        | New pet patch gives back item if pet has equipped. Delete item from cursor.
        /varset GDropCount 0
        /if (${Cursor.ID}) {
            DEBUGGIVE Cursor.ID ${Cursor.ID}
            /while (${Cursor.ID} && ${GDropCount}<8) {
				/doevents GotHit
                /varset GItemID ${Cursor.ID}
                /varset ToyName ${Cursor.Name}
                | This came out of your inventory, so put it back where you got it.
                DEBUGGIVE Got Here 0 ${PetToyList}
                /if (${PetToyList.Find[${ToyName}]}) {
                    /varset x1 1
                    /while (1) {
						/doevents GotHit
			            /doevents
						| Stop pet buffing if aggro detected
						/if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0
						/if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
							POPCALL
							/return
						}
                        /varset ListItem ${PetToyList.Arg[${x1},|]}
                        DEBUGGIVE Got Here 1 ${x1} ${ListItem}
                        /if (!${ListItem.Length} || ${ListItem.Equal[null]}) /break
                        /if (${ListItem.NotEqual[removed]}) {
                            DEBUGGIVE Got Here 2 ${ListItem.Arg[1,@]} - ${ToyName}
                            /if (${ListItem.Arg[1,@].Equal[${ToyName}]}) {
                                /if (${Int[${ListItem.Arg[3,@]}]}<0) {
                                    /nomodkey /itemnotify pack${ListItem.Arg[2,@]} leftmouseup
                                } else {
                                    /nomodkey /itemnotify in pack${ListItem.Arg[2,@]} ${ListItem.Arg[3,@]} leftmouseup
                                }
                                DEBUGGIVE Got Here 3 ${ListItem.Arg[2,@]} - ${ListItem.Arg[3,@]}
                                /varset PetToyList ${PetToyList.Replace[${ListItem},removed]}
                                /break
                            }
                        }
                        /varcalc x1 ${x1}+1
                    }
                    |/varset PetToyList
                } else /if (${Cursor.NoRent}) {
                    /destroy
                } else {
                    /autoinventory
                }
                /delay 20 ${Cursor.ID}
                DEBUGGIVE Cursor Check2: ${Cursor} - ${Cursor.NoRent}
                /varcalc GDropCount ${GDropCount}+1
            }
        } else /if (${GiveNow}) {
            /varset PetToyList
        }
        |/delay 200 !${Window[GiveWnd].Open}
		POPCALL
        DEBUGGIVE GiveTo Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Check OpenInvSlot - Based on code from el_nene's autobot. Used with permission.
| Autobot is available at www.Macroquest2.com VIP macro section.
| Updated and Revised for KissAssist
| ----------------------------------------------------------------------------
    Sub OpenInvSlot
        /if (${BagNum}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGBUFFS OpenInvSlot Enter
        /declare h int local 1
        /declare i int local 0
        /varset BagNum 0
        /call CheckCursor OpenInvSlot 1
        /if (${Cursor.ID}) {
            /varset BagNumLast 99
			POPCALL
            /return
        }
        /while (${h}<3 && !${BagNum}) {
            /for i 1 to 10
                /if (${Me.Inventory[pack${i}].Container}) /continue
                /if (${h}==1) {
                    /if (${Me.Inventory[pack${i}].ID}==0) {
                        /varset BagNum ${i}
                        /break
                    }
                } else /if (${h}==2) {
                    |/if (!${Me.Inventory[pack${i}].Container} && ${Me.Inventory[pack${i}].NoRent}) {
                    /if (!${Me.Inventory[pack${i}].Container}) {
                        /if (${Me.FreeInventory}>1) {
                            /varset BagNum ${i}
                        } else {
                            /varset BagNumLast 99 
                        }
                        /break
                    }
                } else {
                    /break
                }
            /next i
            /varcalc h ${h}+1
            /if (${BagNum}) /break
        }
        /if (${BagNum}) {
            /if (${BagNum}!=${BagNumLast}) {
                /varset BagNumLast ${BagNum}
                /echo Pet Toys: Inventory slot ${i} is empty using that one.
            }
        }
		POPCALL
        DEBUGBUFFS OpenInvSlot Leave
    /return
	
| -------------------------------------------------------------------------------------------------
| SUB:PetToys
|
| There needs to be a separate routine that will take bags or items from inventory
| casting needs to be a separate process. It's too cumbersome.
| -------------------------------------------------------------------------------------------------
    Sub PetToys(RecipientName)
        /if (!${PetToysOn}) /return 0
        /if (!${Defined[PetToysOn]}) /return
		/if (!${RecipientName.Length} || ${RecipientName.Equal[NULL]}) {
			/echo The RecipientName is [${RecipientName}].  Why? Leaving.
			/return
		}
		/if (${Pet.CleanName.NotEqual[${RecipientName}]} && !${ProvidePetToys}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		| We may be making our own toys and receive a request.
		/if (${CallCircular}) {
			POPCALL
			/return
		}
			
		|
		| We can target the pet and ${Target.Equipment[slot]} which returns int.
		| Ench default primary weap is 10855. Most pets primary is 0. Don't know
		| about necs.
		|
		| Friendlier messages, last 4 heirlooms given to 110+ mage pets.
		| You can summon gear even if you don't have a pet.
		| The routine should give as many items as piped, not limited to 2.
		|
		| The particular heirloom spell, pet level, and focus item influence
		| which heirlooms will be accepted. It's a bit arcane before spell levels 110+.
		| Level 110+ pets with or without focus ear would only take last 4. Changed j<4 to j<3.
		| Without any focus whatsoever, you can give upto spell level 105 6 items. That means
		| a 105 earth pet with near max focus comes to level 111 and you can give 6!
		|
		| Lower level pets just see what happens...  users should specify which items
		| to give their pets if they are fussy about returned items by pets.
		|
		| The function is better behaved and gives what's asked for and nothing more.
		|
        DEBUGPET PetToys Enter
		
		|
		| We are able to give bags of toys, we need to know if pet or pc
		| The user must provide an ini PetToy condition that indicates PC for bags.
		| IsAPC and IsAPet declared for readability. It's the same as ID but used as a flag.
		| We need the full name of the pet to reliably get the id.
		|
		/declare pcName				string	local ${Spawn[=${RecipientName} pc].CleanName}
		/declare pcID				int		local ${Spawn[=${pcName} pc].ID}
		/declare petName			string	local ${Spawn[=${RecipientName} pet].CleanName}
		/declare petID				int		local ${Spawn[=${petName} pet].ID}
		/declare bag				int		local
        /declare i            		int    	local
        /declare j            		int    	local
        /declare GrabItem     		int    	local 0
        /declare PetToySpell  		string 	local 0
        /declare FullText     		string 	local
        /declare 2ndPart      		string 	local
        |/declare 3rdPart      		string 	local
        /declare LastPart     		string 	local
        /declare PetToysTemp  		string 	local ${Ini[${IniFileName},Pet,PetToysGave]}
        /declare PetToyCheck  		string 	local
        /declare GaveItem     		int    	local 1
        /declare CondNo       		int    	local 0
        /declare pCount1      		int    	local 0
        /declare pCount2      		int    	local 0
        /declare pIdx         		int    	local 0
        /declare IsMyPet      		int    	local 0
        /declare retryCount   		int    	local 0
        /declare cancelFlag   		int    	local 0
        /declare SlotOpen     		int    	local 0
        /declare CastFlag1    		int    	local 0
		/declare PetToysTimerSec	int		local 60
		/declare ToysContentList	string	local NULL
		|
		| Parameters to move to trade range and max range to cast bags directly to players.
		|
		/declare GiveDistance		int		local 5
		/declare CastBagsDist		int		local 100
		|
		| We are going to check the pet for gear. Offhand is no longer used as a criterion for being equipped.
		|
		/declare PrimaryWeap		int		local 0
		/declare OffhandWeap		int		local 0
		/declare IsEquipped			int		local 0
		
		/varset IsAPC local ${pcID}
		/varset IsAPet ${petID}

		DEBUGPET pcName ${pcName} pcID ${pcID} IsAPC ${IsAPC} petName ${petName} petID ${petID} IsAPet ${IsAPet}

		|
		| We will allow items to be handed to players directly, or if no items specified, give bags.
		| Magic.
		|
		/varset pcName ${Spawn[=${pcName} pc].CleanName}
		/varset petName ${Spawn[=${petName} pet].CleanName}
		/if (${IsAPC}) {
			/echo Giving bags of pet toys to ${pcName}
			DEBUGPET PC wants toys - swapping petID for pcID
			/varset petID ${pcID}
		}

		|
		| To give proper heirlooms for pets 110+, verbiage.
		|	
		/declare PetLevel	  	int	 	local ${Spawn[id ${petID}].Level}
		/declare PetOwnerClass 	string	local
		/declare PetOwnerName	string	local

		/if (${IsAPet}) {
			/varset PetOwnerClass ${Spawn[id ${petID}].Master.Class.ShortName}
			/varset PetOwnerName ${Spawn[id ${petID}].Master.Name}
			/varset PrimaryWeap ${Spawn[id ${petID}].Equipment[primary]}
			/varset OffhandWeap ${Spawn[id ${petID}].Equipment[offhand]}
		} else {
			/varset PetOwnerClass ${Spawn[id ${pcID}].Class.ShortName}
			/varset PetOwnerName ${pcName}
		}
		|
		| Separating this so we can use this later
		|
        /if (${Pet.CleanName.Equal[${petName}]}) /varset IsMyPet 1
		
		DEBUGPET PetName ${petName} ID ${petID} IsMyPet ${IsMyPet} PrimaryWeap ${PrimaryWeap} OffhandWeap ${OffhandWeap}

		|
		| Let's see if they are equipped already. Using primary weapon as flag.
		| We are outta here if weaps were provided.
		|
		/if (${IsAPet}) {
			/call IsPetEquipped ${petID}
			/if (${Macro.Return.Equal[PET_NOT_EQUIPPED]}) {
				DEBUGPET Pet needs weapons and gear. Continuing.
				| reset if different pet name only on my pet
				/if (${IsMyPet}) {
					/ini "${IniFileName}" "Pet" "PetToysGave" "${petName}"
					/varset PetToysGave
					/varset PetToysTemp ${petName}
				}
			} else {		
				DEBUGPET Pet has been given weapons already. Leaving.
				/echo IsPetEquipped strange result: ${Macro.Return}
				/echo Pet ${petName} is bugged. Destroying. Bye bye.
				/if (${Pet.ID}) /pet leave
				POPCALL
				/return PET_DESTROYED
			}
		}
		|
		| Check distance and move now if in camp.
		|
		/if (${IsAPet}) {
			/if (${Int[${Spawn[id ${petID}].Distance}]}>${GiveDistance} && ${IsMyPet}) {
				/echo Pet, come to me.
				/if (${Pet.Stance.NotEqual[follow]}) /pet follow
				/delay 30 ${Pet.Stance.Equal[follow]}
			}
			/if (${Me.Mount.ID}) {
				/if (${Me.Mount.ID}) /dismount
				/delay 20 !${Me.Mount.ID}
			}
            /if (${Int[${Spawn[id ${petID}].Distance}]}<=${CampRadius}) {
                /moveto id ${petID} mdist ${GiveDistance}
                /delay 50 ${MoveTo.Stopped}
            } else {
				/echo The toys recipient is too far away to trade.
				POPCALL
				/return TRADE_TOO_FAR_AWAY
			}
            /if (${Me.Levitating}) {
                /removelev
                /delay 20 !${Me.Levitating}
            }
		} else /if (${IsAPC}) {
			/if (${Spawn[id ${pcID}].Distance}>${CastBagsDist}) {
				/call BroadCast y  "The PC is too far away for me to cast bags of toys to their cursor. Not going to chase them down."
				POPCALL
				/return CAST_TOO_FAR_AWAY
			}
		}		
		/if (${IsAPet}) {
			/varset BagNum 0
			/call OpenInvSlot
			/if (${BagNumLast}==99) {
				/call BroadCast y "I need an open bag slot to make pet toys. Make room then /togglevariable PetToysOn to try again."
				/varset PetToysOn 0
				/varset PetToysResumeStep 0
				/varset PetToysResumeBagNum 0
				POPCALL
				/return X
			}
			/if (${BagNum}==0) {
				/call BroadCast y "I need an open bag slot to make pet toys. Make room then /togglevariable PetToysOn to try again."
				/varset PetToysOn 0
				/varset PetToysResumeStep 0
				/varset PetToysResumeBagNum 0
				POPCALL
				/return X
			}
			|
			| We will check this slot for a summoned bag if we get interrupted
			|
			/varset PetToysResumeBagNum ${BagNum}
		}
        /if (!${Window[InventoryWindow].Open}) /varset GaveItem 0
		DEBUGPET Entering PetToys.Size ${PetToys.Size} for loop
        /for i 1 to ${PetToys.Size}
            DEBUGPET CHECKING: PetToys${i}
			/call CheckBeforeCast PetToys FROMHERE
            | Stop if aggro detected
            /if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0
            /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
				POPCALL
				/return
			}
			|
			| We get stuck in a loop if the PC / Pet poofs. Check whether spawn still exists.
			|			
			/if (!${Spawn[id ${petID}].ID}) /break

			/varset PetToysResumeStep ${i}
			
			| We build a list of toys from each spell, store it, then use it the next time. We search inventory before we cast it next time.
			/varset ToysContentList
			
            /if (${ConOn} && ${PetToys[${i}].Find[|cond]}) {
                /varset CondNo ${PetToys[${i}].Mid[${Math.Calc[${PetToys[${i}].Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }
			|
			| Adding details to suss out conditional issues
			|
            /if (${DebugPet}) {
                /echo \atPetDebug PetToys 1: ${PetToys[${i}]}
                /echo \atPetDebug PetToys 2: ${PetToysTemp}
                /echo \atPetDebug PetToys 3: ${PetToys[${i}].Equal[Null]} || ${PetToysTemp.Find[${petName}]} && ${PetToysTemp.Find[${PetToys[${i}]}]}
                /echo \atPetDebug PetToys 4: Cond Number: ${CondNo}
				/echo \atPetDebug PetToys 5: Cond true? ${If[${Cond[${CondNo}]},1]} Cond: ${Cond[${CondNo}]}
            }
            /if (${CondNo}) {
                /if (${If[${Cond[${CondNo}]},0,1]}) {
					DEBUGPET Condition ${CondNo} FALSE. Skipping.
					/continue
				} else {
					DEBUGPET Condition ${CondNo} TRUE. Proceeding.
				}
            }
            DEBUGPET PetToys ${i} ${PetToys[${i}].Equal[Null]} SkipPetToy 1
            /if (${PetToys[${i}].Equal[Null]}) /continue
            /if (${PetToys[${i}].Find[|cond]}) {
                /varset FullText ${PetToys[${i}].Left[${Math.Calc[${PetToys[${i}].Find[|cond]}-1]}]}
            } else {
                /varset FullText ${PetToys[${i}]}
            }
			DEBUGPET FullText ${FullText}
			|
			| It will walk through the pipe delimited string and give the items it found.
			| Setting pCount + 1 because it's the position of the item in the string we want.
			|
			/varcalc pCount1 ${FullText.Count[|]}+1
			DEBUGPET pCount1 ${pCount1}
            /varset PetToySpell ${FullText.Arg[1,|]}
			DEBUGPET The spell is in the first position: ${PetToySpell}
            /if (${pCount1}>1) {
                /varset pIdx 2
                /varset 2ndPart ${FullText.Arg[${pIdx},|]}
				DEBUGPET There is a 2ndPart ${2ndPart}
                /varset LastPart ${FullText.Arg[${Math.Calc[${pIdx}+1]},|]}
				DEBUGPET The LastPart ${LastPart}
	            | Are we handing weapons to the pet?
                /if (${2ndPart.Length} && ${2ndPart.NotEqual[null]} && ${LastPart.Equal[${2ndPart}]}) {
                    /varset PetToyCheck :${2ndPart}2
					DEBUGPET The 2ndPart and LastPart are equal. Setting PetToyCheck to ${PetToyCheck}
                } else {
                    /varset PetToyCheck :${2ndPart}1
					DEBUGPET The 2ndPart and LastPart are NOT equal. Setting PetToyCheck to ${PetToyCheck}
                }
            } else {
                /varset pIdx 1
                /varset PetToySpell ${FullText}
                /varset 2ndPart
                /varset PetToyCheck ${PetToySpell}:
            }
			DEBUGPET pIdx ${pIdx} pCount1 ${pCount1} PetToySpell ${PetToySpell} 2ndPart ${2ndPart} LastPart ${LastPart} PetToyCheck ${PetToyCheck}
            /varset LastPart
            |/echo ${IsMyPet} - ${2ndPart.Length} - ${PetToysTemp.Find[PetToyCheck]} - ${Spell[${PetSpell}].Level} SkipPetToy 2
            DEBUGPET IsMyPet ${IsMyPet} 2ndPart.Length ${2ndPart.Length} PetToysTemp.Find[PetToyCheck] ${PetToysTemp.Find[PetToyCheck]} Spell ${PetToySpell} Level ${Spell[${PetToySpell}].Level} SkipPetToy 2
            /if (${IsMyPet}) {
				|
				|Low level weapons (not in bags), require you cast and hand them separately. This requires a 2nd pass through which recasts *everything*, so commenting this out.
				|
                |/if (${PetToysTemp.Find[${petName}]} && ${PetToysTemp.Find[${PetToyCheck}]}) /continue
				
                | Check if spell level less than 76 because mage pets auto equipped after that.
                /if (${Spell[${PetSpell}].Level}>=76 && (${PetToySpell.Find[muzzle]} || ${PetToySpell.Find[visor]} || ${PetToySpell.Find[belt]} || ${PetToySpell.Find[plate]})) {
					/echo ${petName} does not need items from ${PetToySpell} because it is level 76 or higher.
					/continue
				}
            }
            | Check for pet toy spells in book to prevent double casting of items
            /if (${Me.Book[${PetToySpell}]} || (${PetToySpell.Equal[inventory]} && ${FindItemCount[=${2ndPart}]})) {
				
				| We need to do this for lore toys that may have wound up in inventory due to a cancelled trade or other issue
				/if (${Me.Book[${PetToySpell}]}) {
					/call CleanupLostToys ${i} "${PetToySpell}"
				}
				
				/if (!${PetToysTimer}) {
					/if (!${PetToysGiveup} || ${PetToysGiveup}>3) {
						/varset PetToysTimer ${PetToysTimerSec}s
						/varset PetToysGiveup 0
						/if (${IsAPet}) {
							/call Bind_PleaseWait "Making Pet Toys for ${petName}" ${PetToysTimerSec}s
						} else {
							/call Bind_PleaseWait "Making Pet Toys for ${pcName}" ${PetToysTimerSec}s
						}
					}
				}
                | Cast to get Item
                /if (${Me.Book[${PetToySpell}]}) {
					|
					| Is it a pet or pc? If a pc but its in parts, do trade route. Otherwise, summon directly.
					|
					/if (${IsAPet} || (${IsAPC} && ${pCount1}>1)) {
						DEBUGPET Getting a bag of toys
						/call CastPetToys "${PetToySpell}"
	                    /if (${Macro.Return.Equal[1]}) {
							/varcalc PetToysGiveup ${PetToysGiveup}+1
							/continue
						}
						/delay 15s ${Cursor.ID}
						/if (!${Cursor.ID}) {
							POPCALL
							/return 0
						}
					} else /if (${IsAPC} && ${GivePetToyBags}) {
						/if (${Spawn[id $pcID].Distance}>100) {
							/echo The PC is too far away. Get to within 100. I'm not moving to them on my own, that's just not how business is done.
							/continue
						}
						|
						| Summon a bag for the player
						|
						/if (${GivePetToyBags}>20) {
							/echo You can't be serious about giving that many bags. Try 20 or less.
							/continue
						}
						/echo Summoning ${GivePetToyBags} ${PetToySpell} for ${pcName}
						DEBUGPET Summoning bags of toys
						/for bag 1 to ${GivePetToyBags}
							|
							| Another loop to be wary of
							|
							/call CheckBeforeCast PetToys FROMHERE
							/call CastWhat "${PetToySpell}" ${pcID} Pet-nomem 0 0 FROMHERE
							/if (${Macro.Return.NotEqual[CAST_SUCCESS]}) {
								/varcalc PetToysGiveup ${PetToysGiveup} +1
							}
							/delay 35
						/next bag
						/continue
					} else {
						/echo GivePetToyBags disabled. Set it in the ini to the number of bags to give per spell.
						/continue
					}
                }
				|
				| Somewhere in here we need to check for potential lore items in inventory. If there are, the bag poofs and we are left scratching our head to figure out why we can no longer
				| give pets toys. Found this the hard way. Grr. If you are summoning in the guildhall, those things dont go away if you log.
				|
				|/if ( Some Error Condition ) {
				|	DEBUGPET The container disappeared!
				|	/echo You may have lore items from the container in your inventory. Please delete them and try again. You may have to remake your pet. Sorry. Giving you one minute to delete and then continuing.
				|	/delay 60s
				|	/echo Continuing pet toys.
				|	/break
				|}					
				
				|
				| Once we get here, we don't do any events but if we get hit.
				|
                | If it is a Bag we need to drop it into inventory
                /if (${Cursor.Container} || ${Cursor.Name.Find[Folded]}) {
                    | If item is in Inv Slot exchange it with bag on cursor
                    /varset CastFlag1 0
                    /if (${Me.Inventory[pack${BagNum}].ID}) {
                        /varset SlotOpen 0
                    } else {
                        /varset SlotOpen 1
                    }
                    /nomodkey /itemnotify pack${BagNum} leftmouseup
					|
					| Adding debug messages
					|
					DEBUGPET Entering while loop that drops bag / item into inventory
                    /while (1) {
						/call CheckBeforeCast PetToys FROMHERE
                        /if (!${SlotOpen}) {
							DEBUGPET There is no slot open, waiting for cursor
                            /delay 30 ${Cursor.ID}
                        } else {
							DEBUGPET There is a slot open, waiting for cursor
                            /delay 20 !${Cursor.ID}
                        }
                        | Drop bag or item into inventory
                        /if (${Cursor.ID}) {
							DEBUGPET Something is on my cursor ${Cursor.Name} Container ${Cursor.Container}
                            /if (!${Cursor.Container}) {
                                /autoinventory
                            } else {
                                /nomodkey /itemnotify pack${BagNum} leftmouseup
                            }
                        }
						|
						| We still assume it will appear on cursor at some point? What do we do with it though. Should we error out? Retry?
						|
						/delay 20 !${Cursor.ID}
                        | Drop exchanged item into inventory after bag is dropped
                        /if (${Cursor.ID}) /autoinventory
                        | If folded pack right click to convert to phantom satchel
                        /if (${Me.Inventory[pack${BagNum}].Name.Find[folded]}) {
							DEBUGPET I have a folded pack. Unfolding.
                            /nomodkey /itemnotify pack${BagNum} rightmouseup
                            /echo Opening ${Me.Inventory[pack${BagNum}].Name}
                            /delay 10
                            /delay 30 ${Window[CastingWindow].Open}
                            |/delay 30
                            /varset SlotOpen 0
                        } else {
							DEBUGPET I don't have a folded pack.
                            /delay 10
                            /break
                        }
                    }
					DEBUGPET Leaving while loop that drops bag / item into inventory
                    /if (${Me.Inventory[pack${BagNum}].Container}) {
						DEBUGPET I have a container, opening it
                        /nomodkey /itemnotify pack${BagNum} rightmouseup
                        /delay 10
                    }
					| Getting contents to compare next time...
					/for j 1 to ${Me.Inventory[pack${BagNum}].Container}
						/if (${Me.Inventory[pack${BagNum}].Item[${j}].ID} && ${Me.Inventory[pack${BagNum}].Item[${j}].Name.Length}) {
							/varset ToysContentList ${ToysContentList}${Me.Inventory[pack${BagNum}].Item[${j}].Name}|
                        }
                    /next j
                } else /if (${Cursor.Name.Find[Summoned:]}) {
					DEBUGPET I have a summoned item ${Cursor.Name}
					| Put item on the list for future comparison
					/varset ToysContentList ${Cursor.Name}|
                    /varset CastFlag1 1
                } else {
                    /varset CastFlag1 0
                }
				
				| Update toys list if necessary
				/if (${Me.Book[${PetToySpell}]} && ${ToysContentList.Length}) {
					/call CleanupLostToys ${i} "${PetToySpell}" "${ToysContentList}"
				}
				
				DEBUGPET Entering while loop that gives items
                /while (1) {
					/call CheckBeforeCast PetToys FROMHERE
					/if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0
					/if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
						POPCALL
						/return
					}

					/if (!${Spawn[id ${petID}].ID}) /break			
                    /if (${FindItemCount[=${2ndPart}]}) {
						DEBUGPET GiveTo FoundItemCount ${2ndPart}
                        /call GiveTo "${2ndPart}" ${petID} 0
                    } else /if (${Cursor.ID}) {
                        /varset 2ndPart ${Cursor.Name}
                        DEBUGPET GiveTo Cursor ${Cursor.Name}
						/call GiveTo "${Cursor.Name}" ${petID} 1
                    } else /if (${pIdx}==1 && !${2ndPart.Length}) {
						DEBUGPET Nothing to give - pIdx 1 2ndPart.Length ${2ndPart.Length}. CastFlag1 set to 2
                        /varset CastFlag1 2
                        /break
                    } else {
                        /break
                    }
                    /delay 10
					
					|
					| IsMyPet check moved to top - we aren't using PetToysTemp for other pets
					|
					/if (${IsMyPet}) {
						/if (${PetToysTemp.Find[:${2ndPart}1]}) {
							/varset PetToysTemp ${PetToysTemp}|${PetToySpell}:${2ndPart}2
						} else {
							/varset PetToysTemp ${PetToysTemp}|${PetToySpell}:${2ndPart}1
						}
						/ini "${IniFileName}" "Pet" "PetToysGave" "${PetToysTemp}"
					}
					|
					| This was at the top, inside the 2nd while loop, so it gave the last item again. Oops.
					|
                    /if (${pIdx}==${pCount1}) {
						DEBUGPET pIdx ${pIdx} == $pCount1 ${pCount1} - we are done - breaking out of first while loop
						/break
					}

					DEBUGPET Entering while loop that teases apart what to give next if multiple items listed
                    /while (1) {
						DEBUGPET Entering conditions: pIdx ${pIdx} pCount1 ${pCount1}
                        /varset LastPart ${2ndPart}
                        /varcalc pIdx ${pIdx}+1
                        /varset 2ndPart ${FullText.Arg[${pIdx},|]}
						DEBUGPET Updated 2ndPart so now it is: pIdx ${pIdx} 2ndPart ${2ndPart}
                        /if (${2ndPart.Length}) {
                            /if (${2ndPart.NotEqual[null]} && ${2ndPart.Equal[${LastPart}]}) {
                                /varset PetToyCheck :${2ndPart}2
                            } else {
                                /varset PetToyCheck :${2ndPart}1
                            }
                        } else {
							DEBUGPET 2ndPart.Length ${2ndPart.Length} - is empty - breaking out of while
                            /break
                        }
						DEBUGPET PetToyCheck ${PetToyCheck}
                        /if (${IsMyPet}) {
                            /if (${PetToysTemp.Find[${petName}]} && ${PetToysTemp.Find[${PetToyCheck}]}) /continue
                            /if (${Spell[${PetSpell}].Level}>=76 && (${PetToySpell.Find[muzzle]} || ${PetToySpell.Find[visor]} || ${PetToySpell.Find[belt]} || ${PetToySpell.Find[plate]})) /continue
                        }
						DEBUGPET Ending conditions: pIdx ${pIdx} pCount1 ${pCount1} 2ndPart ${2ndPart}
                        /break
                    }
					DEBUGPET Leaving while loop that teases apart what to give next if multiple items listed
                    DEBUGPET pIdx ${pIdx} pCount1 ${pCount1} 2ndPart ${2ndPart} CastFlag1 ${CastFlag1}
					|
					| Are we out of things to give?
					|
                    /if (!${2ndPart.Length} || ${2ndPart.Equal[null]}) {
						DEBUGPET We are out of items to give... back to the for loop.
						/break
					}
                    |/if (${pIdx}>${pCount1}) /break
                    /if (${CastFlag1}==1) {
						DEBUGPET CastFlag1 1 condition - Giving item(s)
                        /if (${Window[GiveWnd].Open}) /call GiveTo "giveitems" ${petID} 1
                        /call CastPetToys "${PetToySpell}"
                        /if (${Macro.Return.Equal[1]}) /break
                        /delay 15s ${Cursor.ID}
                    }
                }
				
				DEBUGPET Leaving while loop that gives items
                /if (${CastFlag1}==2) {
						DEBUGPET Entering for loop that gives everything in container because nothing was specified
                        /for j 1 to ${Me.Inventory[pack${BagNum}].Container}
							/call CheckBeforeCast PetToys FROMHERE
							| Stop if aggro detected
							/if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0
							/if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
								POPCALL
								/return
							}
							/if (!${Spawn[id ${petID}].ID}) /break

							|
							| Heirloom hack for 110+ mage pets. Focus items, pet level, and spell level are not easily rectified for lower level mage pets.
							| The user can specify what they want explicitly in the ini, or fall back on this.
							|
							DEBUGPET IsAPet ${IsAPet} PetOwnerClass ${PetOwnerClass} PetLevel ${PetLevel} PetToySpell heirloom ${PetToySpell.Find[heirloom]} j ${j}
                            /if (${IsAPet} && ${PetOwnerClass.Equal[MAG]} && ${PetLevel}>109 && ${PetToySpell.Find[heirloom]} && ${j}<3) /continue
                            /if (${Me.Inventory[pack${BagNum}].Item[${j}].ID} && ${Me.Inventory[pack${BagNum}].Item[${j}].Name.Length}) {
                                /call GiveTo "${Me.Inventory[pack${BagNum}].Item[${j}].Name}" ${petID} 0
                            }
                            /delay 10
                        /next j
						DEBUGPET Leaving for loop that gives everything in container because nothing was specified
                        /if (${j}>=8 && !${PetToysTemp.Find[${PetToySpell}]} && ${IsMyPet}) {
                            /varset PetToysTemp ${PetToysTemp}|${PetToySpell}|Summoned
                            /if (!${PetToysTemp.Find[Summoned]}) /varset PetToysTemp ${PetToysTemp}|Summoned
                            /ini "${IniFileName}" "Pet" "PetToysGave" "${PetToysTemp}"
                        }
                }
				DEBUGPET Giving last item if give window still open...
                /if (${Window[GiveWnd].Open}) /call GiveTo "giveitems" ${petID} 1
				DEBUGPET Destroying bag if its there
                /if (${Me.Inventory[pack${BagNum}].Name.Find[Phantom Satchel]} || ${Me.Inventory[pack${BagNum}].Name.Find[Pouch of Quellious]}) /call DestroyBag
            } else {
				/echo Could not find the spell or item for PetToys${i}=${PetToys[${i}]}. Disabling the entry.
				/varset PetToys[${i}] NULL
			}
			DEBUGPET End of for loop ${i}
        /next i
		DEBUGPET Leaving PetToys.Size ${PetToys.Size} for loop
		|
		| Finished!
		|
		/varset PetToysResumeStep 0
		/varset PetToysResumeBagNum 0
		/if (!${PetToysGiveup}) {
			/varset PetToysTimer 0
		} else /if (${PetToysGiveup}>3) {
			/varset PetToysGiveup 0
			/varset PetToysTimer 0
		}
		
		/if (${IsAPet} && !${IsMyPet}) {
			/call ToysFinished "${petName}"
		}
		/if (${IsAPC}) {
			/call ToysFinished "${pcName}"
		}
				
        | MUST reset PetToysGave after cycle complete in order to stop calling PetToys all the time.
        /varset PetToysGave ${PetToysTemp}
		|
		| Make sure give window closed too
		|
		/invoke ${Window[GiveWnd].DoClose}
        /if (${Window[InventoryWindow].Open} && !${GaveItem}) /keypress inventory
        /call DoWeMove ${ReturnToCamp} PetToys
		POPCALL
        DEBUGPET PetToys Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Pick Up item
| ----------------------------------------------------------------------------
    Sub PickUpItem(string p_ItemName, p_AddToList)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /declare itemSlot int local
        /declare itemSlot2 int local
        /if (!${FindItemCount[=${p_ItemName}]}) /return
        /varset itemSlot ${FindItem[=${p_ItemName}].ItemSlot}
        /varset itemSlot2 ${FindItem[=${p_ItemName}].ItemSlot2}
        |/echo ${itemSlot} ${itemSlot2}
        /if (${itemSlot}>22) /varcalc itemSlot ${itemSlot}-22
        /if (${itemSlot2}>-1) /varcalc itemSlot2 ${itemSlot2}+1
        |/echo ${itemSlot} ${itemSlot2}

        /if (!${PetToyList.Length}) {
            /varset PetToyList ${p_ItemName}@${itemSlot}@${itemSlot2}
        } else {
            /varset PetToyList ${PetToyList}|${p_ItemName}@${itemSlot}@${itemSlot2}
        }
        /if (${itemSlot2}<0) {
            /nomodkey /itemnotify pack${itemSlot} leftmouseup
        } else {
            /nomodkey /itemnotify in pack${itemSlot} ${itemSlot2} leftmouseup
        }
        |/echo PickUpItem: ${PetToyList}
        /delay 20 ${Cursor.ID}
    /return	

| ---------------------------------------------------------------------------
| Sub ReclaimMana
|
| 1. Pet Suspend
| 2. If pet, use staff
| 3. While Mana < FOM
| 4. Summon highest monster/animation level
| 5. Use staff
| 6. Loop to 3
| 7. Unsuspend pet
| 8. Resume
| ---------------------------------------------------------------------------
	Sub ReclaimMana
		/if (!${IAmAMage}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/declare RMTimerOn			timer	0
		/declare RMTimerDuration	int		600
		/if (${Me.PctMana}>=95) {
			/echo You already have plenty of mana. Leave the monsters alone, you animal!
			POPCALL
			/return ENOUGH_MANA
		}
		/if (!${ReclaimEnergyMethod.Length} || ${ReclaimEnergyMethod.Equal[NULL]}) {
			/echo ReclaimEnergyMethod in your ini pet section is not defined. MAG only.
			POPCALL
			/return ReclaimEnergyMethod_UNDEFINED
		}
		/if (!${SacrificialPetSpell.Length} || ${SacrificialPetSpell.Equal[NULL]}) {
			/echo SacrificialPetSpell in your ini pet section is not defined. MAG only.
			POPCALL
			/return SacrificialPetSpell_UNDEFINED
		}

		/call Bind_PleaseWait "Reclaiming Mana" 60s
				
		| If I have 2 pets, suspend the first, sac the second.
		| If I have 1 pet, suspend

		/if (${PetTotCount}==2) {
			| Suspend the first pet
			/call PetSuspend
			/delay 15
			/call CastHotSwap "${ReclaimEnergyMethod}" NULL ReclaimMana
			/delay 10
			/varset PetTotCount 1
			/varset PetActiveState 0
			/varset PetSuspendState 1
		} else /if (${PetTotCount}==1) {
			/if (${PetActiveState}) {
				/call PetSuspend
				/varset PetSuspendState 1
				/varset PetActiveState 0
				/delay 15
			}
		}
		/varset RMTimerOn ${RMTimerDuration}
		/while (1) {
			/doevents GotHit		
			/if (${Me.PctMana}>=90) /break
			/if (!${RMTimerOn}) /break
			/call CastHotSwap "${SacrificialPetSpell}" NULL ReclaimMana
			/delay 15
			/call CastHotSwap "${ReclaimEnergyMethod}" NULL ReclaimMana
			/delay 10
		}
		/if (${PetSuspendState}) {
			/call PetSuspend
			/varset PetTotCount 1
			/varset PetActiveState 1
			/varset PetSuspendState 0
			/delay 15
		}
		/echo Done reclaiming mana.
		POPCALL
	/return RECLAIMMANA_SUCCESS

| ----------------------------------------------------------------------------
| Sub:ShutdownToysGiving
| ----------------------------------------------------------------------------
	Sub ShutdownToysGiving
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/if (${Window[GiveWnd].Open}) {
            /notify GiveWnd GVW_Cancel_Button leftmouseup
            /delay 20 !${Window[GiveWnd].Open}
		}
		/call DestroyBag
		
		POPCALL	
	/return

| ----------------------------------------------------------------------------
| SUB: ToysFinished - Finished message sent from mage providng toys
| ----------------------------------------------------------------------------
	Sub ToysFinished(PetName)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGPET ToysFinished: ENTER	
		/if (${ProvidePetToys}) {
			/if (${PetName.Length}) {
				/call Broadcast y "ToysFinished ${PetName}"
			} else /if (!${PetName}) {
				/echo Which pet is done receiving toys? I forgot.
			}
		}
		DEBUGPET RequestToys: LEAVE
	/return

