
| -------------------------------------------------------------------------------------
| SUB: AddMezImmune
| -------------------------------------------------------------------------------------
    Sub AddMezImmune(int MezID)
        /if (${Select[${Me.Class.ShortName},Brd,Enc,Nec]}==0) /return
        /if (${MezImmuneIDs.Find[|${MezID}]}) /return
        /varset MezImmuneIDs ${MezImmuneIDs}|${MezID}
        /call BroadCast g "MEZ Immune -> ${Spawn[id ${MezID}].CleanName} <- ID:${MezID} Skipping."
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Bind AddMezImmune
| -------------------------------------------------------------------------------------
    Sub Bind_AddMezImmune(MTImmune)
        /if (!${MTImmune.Length} || ${MTImmune.Find[null]} || ${Spawn[${MTImmune}].ID}==${Me.ID} ) {
            /echo No NPCs detected. Nothing added to list.
            /return
        }
        | Assign temp var MezImmune list
        /declare MezImmuneAdd string local ${MezImmune}
        | If MezImmune default text with the word null in it assign var spawn clean name
        /if (${MezImmuneAdd.Find[null]} && ${MezImmune.Find[null]}) {
            /varset MezImmuneAdd ${Spawn[${MTImmune}].CleanName}
        } else {
            /varset MezImmuneAdd ${MezImmune},${Spawn[${MTImmune}].CleanName}
        }
        | Remove's corpse if closest match is a mob corpse
        /if (${MezImmuneAdd.Right[-10].Find[corpse]}) /varset MezImmuneAdd ${MezImmuneAdd.Right[-8]}
        /if (${MezImmune.Find[${Spawn[${MTImmune}].CleanName}]}) {
            /echo >> ${Spawn[${MTImmune}].CleanName} << already on Mez Immune List.
            /return
        }
        /if (${Spawn[${MTImmune}].CleanName.Equal[null]}) {
            /echo No Mob with ${MTImmune} in Name detected.
            /return
        }
        /if (!${MezImmune.Find[${Spawn[${MTImmune}].CleanName}]}) {
            /ini "${InfoFileName}" "${ZoneName}" "MezImmune" "${MezImmuneAdd}"
            /echo MezImmune -> ${Spawn[${MTImmune}].CleanName} <- Adding to Mez Immune  list.
        }
        | Reassign MezImmune var the new list
        /varset MezImmune ${MezImmuneAdd}
    /return

| -------------------------------------------------------------------------------------
| SUB: Do Mez Stuff
| -------------------------------------------------------------------------------------
    Sub DoMezStuff(string FromWhere)
		/if (!${MezOn}) /return
        /if (${Me.Hovering} || (!${MyTargetID} && ${Spawn[=${MainAssist}].ID} && ${Spawn[=${MainAssist}].Type.NotEqual[Mercenary]}) || ${DMZ} && ${Me.InInstance}==FALSE) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /if (${EventByPass}!=2) {
            /varset EventByPass 1
            /varset GoMByPass 1
            /doevents
            /varset EventByPass 0
            /varset GoMByPass 0
        }		
		/varset CheckMezTimerOn ${CheckMezTimer}s
        /varset GoMByPass 0
		
        DEBUGMEZ DoMezStuff: Enter from ${FromWhere}
        /declare i 				int 	local 	0
        /declare j 				int 	local 	0
        /declare skipFlag 		int 	local 	0
        /declare mezCombat 		bool 	local 	False
		
		|
		| Accounting Var so we know if to AE
		|
		/declare NumMaybeMezzable	int		local	0
		
        | Reset skip mez on health setting if tank dies to 1%
        /if (!${Spawn[=${MainAssist}].ID}) /varset MezStopHPs 1
        /if (${Me.Combat} || ${Me.CombatState.Equal[combat]} || ${DPSOn}) /varset mezCombat True
		
        /call MezRadar FROMHERE
		
        DEBUGMEZ DoMezStuff MezMobCount ${MezMobCount} mezCombat ${mezCombat}

        /if (${MezMobCount}<2 && ${Spawn[=${MainAssist}].ID}) {
            DEBUGMEZ MezMobCount was ${MezMobCount} (so less than 2) & ${MainAssist} is alive and no new mobs so we return
            /varset MezMobDone 1
			POPCALL
            /return
        }
		
		DEBUGMEZ Mobs need to be mezzed. Working on it.
		
		/varset MezMobDone 0

		/if (${Select[${MezOn},1,3]} && ${MezMobCount}>=${MezAECount}) {
			DEBUGMEZ Seeing if I can AE Mez.
			/for i 1 to 13
				/doevents GotHit
				/call LastMove
				| We are already helping with loose mobs by doing this!
				DEBUGMEZ DoMezStuff: Analyzing ${i}: ${Spawn[id ${MezArray[${i},1]}].Name} ${Spawn[id ${MezArray[${i},1]}].ID}

				/varset skipFlag 0
				| Every Mez test conditon is listed seperately for clarity
				DEBUGMEZ DoMezStuff: For Loop i ${i} to ${MezMobCount}  Mob ${Spawn[id ${MezArray[${i},1]}].Name} ${Spawn[id ${MezArray[${i},1]}].ID}

				| Test -> array element empty,
				/if (${MezArray[${i},1].Equal[NULL]}) {
					DEBUGMEZ ${i}  MezArray[${i},1] was equal to NULL, Skip
					/continue
				}
				| Test -> Target is dead
				/if (!${Spawn[id ${MezArray[${i},1]}].ID} || ${Spawn[id ${MezArray[${i},1]}].Type.Equal[corpse]}) {
					DEBUGMEZ ${i}  ${MezArray[${i},3]} is dead, Skip
					/call RemoveFromArray MezArray ${i}
					/continue
				}
				|
				| These tests need to happen now before I look at whether a mob is mezzed
				|
				| Test -> is target MA's current Target
				/if (${Spawn[id ${MezArray[${i},1]}].ID}==${MyTargetID} && ${Spawn[=${MainAssist}].ID}) {
					DEBUGMEZ ${Spawn[id ${MezArray[${i},1]}].Name} had the same ID(${Spawn[id ${MezArray[${i},1]}].ID}) as MyTargetID(${MyTargetID}) & ${MainAssist}(${Spawn[=${MainAssist}].ID}), Skip
					/continue
				}
				| Test -> is  MA's a merc skip 1st target so he attacks it.
				/if (${AggroTargetID} && !${MyTargetID} && ${Spawn[=${MainAssist}].ID} && ${Spawn[=${MainAssist}].Type.Equal[Mercenary]}) {
					DEBUGMEZ AggroTargetID = ${AggroTargetID}  MyTargetID = ${MyTargetID} & Spawn[=MainAssist].ID = ${Spawn[=${MainAssist}].ID} & Spawn[=MainAssist].Type.Equal[Mercenary] was true, Skip
					/continue
				}
				| Test -> is target above mez hps threshold
				/if (${Spawn[id ${MezArray[${i},1]}].PctHPs}<${MezStopHPs}) {
					DEBUGMEZ Spawn[MezArray[${i},1]].PctHPs(${Spawn[id ${MezArray[${i},1]}].PctHPs}) was less than MezStopHPs(${MezStopHPs}), Skip
					/continue
				}
				| Test -> is target within levels defined in ini file
				/if (${MezArray[${i},2]}>${MezMaxLevel} || ${MezArray[${i},2]}<${MezMinLevel}) {
					DEBUGMEZ MezArray[${i},2](${MezArray[${i},2]}) was greater than MezMaxLevel(${MezMaxLevel}) OR less than MezMinLevel(${MezMinLevel}), Skip
					/continue
				}
				|
				| Is this condition going to ever be reached?
				|
				| Test -> I am a bard and if the player is dumb enough to have me tank then don't mez.
				/if (${IAmABard} && ${IAmMA} && ${MyTargetID} && ${AggroTargetID} && ${MezArray[${i},1].Equal[${MyTargetID}]}) {
					DEBUGMEZ im a bard and stuff, Skip
					/continue
				}				
				| Test -> Do i have a mez timer on the mob?
				/if (${MezTimer${i}} > 0) {
				    DEBUGMEZ MezTimer${i}(${MezTimer${i}}) was greater than 0 , Skip				
					/continue
				}
				| Is mob in MezRadius distance
				/if (${Spawn[id ${MezArray[${i},1]}].Distance}>=${MezRadius}) {
					DEBUGMEZ ${i}  Mob distance is greater than MezRadius: ${Spawn[id ${MezArray[${i},1]}].Distance} ${MezRadius} Skip
					/continue
				}
				| Test -> is the target in line of sight
				/if (!${Spawn[id ${MezArray[${i},1]}].LineOfSight}) {
					DEBUGMEZ I dont have LineOfSight to Spawn[MezArray[${i},1]](${Spawn[id ${MezArray[${i},1]}].Name} ID:${Spawn[id ${MezArray[${i},1]}].ID}), Skip
					/continue
				}
				|
				| Now we look at mobs that are trouble
				|
				|
				| Doing the same thing up above with the other immune detections. We should be adding mez immune mobs to this list.
				|
				| Test -> is target on my mez immune list
				/if (${Alert[4].Size}) {
					/for j 0 to ${Alert[4].Size}
						/if (${Alert[4].List[${j}].Name.Equal[${MezArray[${i},3]}]} && ${Alert[4].List[${j}].Name.Length}) {
							/if (${MMTimer${i}}==0) /call BroadCast g "MEZ Immune Detected -> ${MezArray[${i},3]} <- ID:${MezArray[${i},1]}"
							/varset MMTimer${i} 1m
							DEBUGMEZ ${Spawn[id ${MezArray[${i},1]}].Name} ID:${MezArray[${i},1]} is immune, Skip
							/varset skipFlag 1
							/break
						}
					/next j
					/if (${skipFlag}) {
						/varset skipFlag 0
						/call SetImmune MezArray ${i}
						/continue
					}
				}
				| Test -> is target a giant unmezzable
				/if (${Spawn[id ${MezArray[${i},1]}].Body.Name.Equal[Giant]}) {
					/if (${MMTimer${i}}==0) /call BroadCast g "MEZ Immune Detected -> ${MezArray[${i},3]} <- ID:${MezArray[${i},1]}"
					/varset MMTimer${i} 1m
					|
					| Mark the name as such.  We need to add a zone specific flag in the kissassist_info.ini.
					| Some zones have mobs which vary in whether they are invis!
					|						
					|/call Bind_AddMezImmune ${MezArray[${i},3]}
					/call SetImmune MezArray ${i}
					/continue
				}
				/if (${MezImmuneIDs.Find[|${MezArray[${i},1]}]}) {
					DEBUGMEZ Mez Immune Mob Detected: ${MezArray[${i},3]} Skip
					/if (${MMTimer${i}}==0) /call BroadCast g "MEZ Immune Detected -> ${MezArray[${i},3]} <- ID:${MezArray[${i},1]}"
					/varset MMTimer${i} 1m
					/call SetImmune MezArray ${i}
					/continue
				}
				|
				| If it's flagged as immune, skip it. Single target mez fail, so don't count it.
				|
				/if (${MezArray[${i},4]}) /continue				
				
				|
				| If we got this far it might be...
				|
				DEBUGMEZ Mob may be mezzable ${NumMaybeMezzable}
				/varcalc NumMaybeMezzable ${NumMaybeMezzable}+1

			/next i
						
			| Necros can't AE mez.
			| MezOn - 0=Off/1=Single & AE Mez/2=Single Mez only/3=AE Mez only.
			/if (${Select[${Me.Class.ShortName},BRD,ENC]}) {
				/if (${MezAECount}>0 && ${NumMaybeMezzable}>=${MezAECount} && ${MezAETimer}==0) {
					DEBUGMEZ I'm about to AEMez
					/echo I'm about to AEMez
					/call WaitUntilAble "${MezAESpell}" FROMHERE
					/if (${Macro.Return.Equal[WAIT_READY]}) {
						/call MezMobsAE ${MezAEClosest} FROMHERE
					} else /if (${Macro.Return.Equal[WAIT_ENDMANA_TIMEOUT]}) {
						DEBUGMEZ Not enough mana to AE Mez! What to do. What to do.
						POPCALL
						/return
					}
				} else /if (${NumMaybeMezzable}<${MezAECount}) {
					DEBUGMEZ Not enough mobs to bother AE mezzing afterall. NumMaybeMezzable ${NumMaybeMezzable}
				}
			}

		} else {
			/if (${Select[${MezOn},1,3]}) {
					DEBUGMEZ AE Mez is disabled.
				} else {
					DEBUGMEZ Not enough mobs (${MezMobCount}) to AE mez (${MezAECount})
				}
			}
		}

		|
		| Spin through the list and mez what we can.
		|
		/if (${Select[${MezOn},1,2]}) {
			DEBUGMEZ Seeing if I can single mez anything.
			/for i 1 to 13
				/doevents GotHit
				/call LastMove
				| We are already helping with loose mobs by doing this!
				DEBUGMEZ DoMezStuff: Analyzing ${i}: ${Spawn[id ${MezArray[${i},1]}].Name} ${Spawn[id ${MezArray[${i},1]}].ID}

				/varset skipFlag 0
				| Every Mez test conditon is listed seperately for clarity
				DEBUGMEZ DoMezStuff: For Loop i ${i} to ${MezMobCount}  Mob ${Spawn[id ${MezArray[${i},1]}].Name} ${Spawn[id ${MezArray[${i},1]}].ID}

				| Test -> array element empty,
				/if (${MezArray[${i},1].Equal[NULL]}) {
					DEBUGMEZ ${i}  MezArray[${i},1] was equal to NULL, Skip
					/continue
				}
				| Test -> Target is dead
				/if (!${Spawn[id ${MezArray[${i},1]}].ID} || ${Spawn[id ${MezArray[${i},1]}].Type.Equal[corpse]}) {
					DEBUGMEZ ${i}  ${MezArray[${i},3]} is dead, Skip
					/varset MezTimer${i} 0
					/call RemoveFromArray MezArray ${i}
					/continue
				}
				|
				| These tests need to happen now before I look at whether a mob is mezzed
				|
				| Test -> is target MA's current Target
				/if (${Spawn[id ${MezArray[${i},1]}].ID}==${MyTargetID} && ${Spawn[=${MainAssist}].ID}) {
					DEBUGMEZ ${Spawn[id ${MezArray[${i},1]}].Name} had the same ID(${Spawn[id ${MezArray[${i},1]}].ID}) as MyTargetID(${MyTargetID}) & ${MainAssist}(${Spawn[=${MainAssist}].ID}), Skip
					/continue
				}
				| Test -> is  MA's a merc skip 1st target so he attacks it.
				/if (${AggroTargetID} && !${MyTargetID} && ${Spawn[=${MainAssist}].ID} && ${Spawn[=${MainAssist}].Type.Equal[Mercenary]}) {
					DEBUGMEZ AggroTargetID = ${AggroTargetID}  MyTargetID = ${MyTargetID} & Spawn[=MainAssist].ID = ${Spawn[=${MainAssist}].ID} & Spawn[=MainAssist].Type.Equal[Mercenary] was true, Skip
					/continue
				}
				| Test -> is target above mez hps threshold
				/if (${Spawn[id ${MezArray[${i},1]}].PctHPs}<${MezStopHPs}) {
					DEBUGMEZ Spawn[MezArray[${i},1]].PctHPs(${Spawn[id ${MezArray[${i},1]}].PctHPs}) was less than MezStopHPs(${MezStopHPs}), Skip
					/continue
				}
				| Test -> is target within levels defined in ini file
				/if (${MezArray[${i},2]}>${MezMaxLevel} || ${MezArray[${i},2]}<${MezMinLevel}) {
					DEBUGMEZ MezArray[${i},2](${MezArray[${i},2]}) was greater than MezMaxLevel(${MezMaxLevel}) OR less than MezMinLevel(${MezMinLevel}), Skip
					/continue
				}
				|
				| Is this condition going to ever be reached?
				|
				| Test -> I am a bard and if the player is dumb enough to have me tank then don't mez.
				/if (${IAmABard} && ${IAmMA} && ${MyTargetID} && ${AggroTargetID} && ${MezArray[${i},1].Equal[${MyTargetID}]}) {
					DEBUGMEZ im a bard and stuff, Skip
					/continue
				}
				
				| Test -> Do i have a mez timer on the mob?
				/if (${MezTimer${i}} > 0) {
				    DEBUGMEZ MezTimer${i}(${MezTimer${i}}) was greater than 0 , Skip				
					/continue
				}
				| Is mob in MezRadius distance
				/if (${Spawn[id ${MezArray[${i},1]}].Distance}>=${MezRadius}) {
					DEBUGMEZ ${i}  Mob distance is greater than MezRadius: ${Spawn[id ${MezArray[${i},1]}].Distance} ${MezRadius} Skip
					/continue
				}
				| Test -> is the target in line of sight
				/if (!${Spawn[id ${MezArray[${i},1]}].LineOfSight}) {
					DEBUGMEZ I dont have LineOfSight to Spawn[MezArray[${i},1]](${Spawn[id ${MezArray[${i},1]}].Name} ID:${Spawn[id ${MezArray[${i},1]}].ID}), Skip
					/continue
				}
				|
				| Now we look at mobs that are trouble
				|
				|
				| Doing the same thing up above with the other immune detections. We should be adding mez immune mobs to this list. What we need is a list of zones where mobs may or may not be mezzable with same name.
				|
				| Test -> is target on my mez immune list
				/if (${Alert[4].Size}) {
					/for j 0 to ${Alert[4].Size}
						/if (${Alert[4].List[${j}].Name.Equal[${MezArray[${i},3]}]} && ${Alert[4].List[${j}].Name.Length}) {
							/if (${MMTimer${i}}==0) /call BroadCast g "MEZ Immune Detected -> ${MezArray[${i},3]} <- ID:${MezArray[${i},1]}"
							/varset MMTimer${i} 1m
							DEBUGMEZ ${Spawn[id ${MezArray[${i},1]}].Name} ID:${MezArray[${i},1]} is immune, Skip
							/varset skipFlag 1
							/break
						}
					/next j
					/if (${skipFlag}) {
						/varset skipFlag 0
						/call SetImmune MezArray ${i}
						/continue
					}
				}			
				| Test -> is target a giant unmezzable
				/if (${Spawn[id ${MezArray[${i},1]}].Body.Name.Equal[Giant]}) {
					/if (${MMTimer${i}}==0) /call BroadCast g "MEZ Immune Detected -> ${MezArray[${i},3]} <- ID:${MezArray[${i},1]}"
					/varset MMTimer${i} 1m
					|
					| Mark the name as such.  We need to add a zone specific flag in the kissassist_info.ini.
					| Some zones have mobs which vary in whether they are invis!
					|						
					|/call Bind_AddMezImmune ${MezArray[${i},3]}
					/call SetImmune MezArray ${i}
					/continue
				}
				/if (${MezImmuneIDs.Find[|${MezArray[${i},1]}]}) {
					DEBUGMEZ Mez Immune Mob Detected: ${MezArray[${i},3]} Skip
					/if (${MMTimer${i}}==0) /call BroadCast g "MEZ Immune Detected -> ${MezArray[${i},3]} <- ID:${MezArray[${i},1]}"
					/varset MMTimer${i} 1m
					/call SetImmune MezArray ${i}
					/continue
				}						
				|
				| If it's flagged as immune, skip it.
				|
				/if (${MezArray[${i},4]}) /continue
				
				|
				| The mob is theoretically mezzable
				|
				DEBUGMEZ im gonna singlemez ${MezArray[${i},1]}
				/call WaitUntilAble "${MezSpell}" FROMHERE
				/if (${Macro.Return.Equal[WAIT_READY]}) {
					/call MezMobs ${MezArray[${i},1]} ${i} FROMHERE
				} else /if (${Macro.Return.Equal[WAIT_ENDMANA_TIMEOUT]}) {
					DEBUGMEZ Not enough mana to Mez! What to do. What to do.
					POPCALL
					/return
				}
				
				| Flag it if immune so we don't try again.
				/if (${Macro.Return.Equal[CAST_IMMUNE]}) /call SetImmune MezArray ${i}

			/next i
		} else {
			/if (${Select[${MezOn},1,2]}) {
				DEBUGMEZ Single Mez is disabled.
			}
		}

		/varset MezMobDone 1

		/if (${mezCombat}) {
			/call CombatTargetCheck 1 FROMHERE
		} else /if (${IAmABard} && ${MeleeTwistOn} && ${CombatStart}) {
			/call CombatTargetCheck 1 FROMHERE
		}
		POPCALL
        DEBUGMEZ DoMezStuff: Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Event MezBroke
| -------------------------------------------------------------------------------------
    Sub Event_MezBroke(meztext,mezmob,mezbreaker)
        /if (!${MezOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /varset EventFlag 1
        DEBUGMEZ event mezbroke Enter
        | Get out of here. DoMezStuff triggered this call after being called from here. See Below.
        /if (${EventByPass}==2) {
			POPCALL
			/return
		}
        /if (${Spawn[=${mezbreaker}].CleanName.Equal[${MainAssist}]}) {
			/call TargetThis ${Spawn[=${MainAssist}].ID}		
            /if (${XTarAutoSet} && !${Group.Member[${MainAssist}].Index} && !${IAmMA} && ${Me.XTarget[${XTSlot}].ID}!=${Target.ID} && ${Target.Type.NotEqual[PC]}) /xtarget set ${XTSlot} currenttarget
			POPCALL
            /return
        }
        /if (${Spawn[=${MainAssist}].Type.Equal[pet]} && ${Spawn[=${MainAssist}].Master.CleanName.Equal[${mezbreaker}]}) {
			POPCALL
			/return
		}
        /declare i int local
        /call BroadCast g ">> ${Spawn[=${mezbreaker}].CleanName} << has awakened -> ${mezmob}<-"
        /for i 1 to 30
            /if (${MezArray[${i},3].Equal[${mezmob}]} && ${MezArray[${i},1].NotEqual[null]}) {
                /echo Resetting Mez Timer ${mezmob} ID: ${MezArray[${i},1]}
                /varset MezTimer${i} 0
            }
        /next i
        /doevents flush MezBroke
        /varset EventFlag 0
        | Get Out of here and return back to DoMezStuff. This event was triggered by DoMezStuff.
        /if (${EventByPass}==1) {
			POPCALL
			/return
		}
        /varset GoMByPass 1
        /varset EventByPass 2
        /call CombatTargetCheck 1 FROMHERE
        /call DoMezStuff FROMHERE
        /varset EventByPass 0
        /varset GoMByPass 0
        | Set MezOn = 2 to let us know that the event was triggered. Will be set back to 1 in other location
        /varset MezBroke 1
		POPCALL
        DEBUGMEZ event mezbroke Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Event MezImmune
| -------------------------------------------------------------------------------------
    Sub Event_MezImmune(int MezID)
        /varset EventFlag 1
        /if (${Select[${Me.Class.ShortName},Brd,Enc,Nec]}==0) /return
        | Assign temp var MezImmune list
        /declare ImmuneAdd string local ${MezImmune}
        | If mezimmune default text with the word null in it assign var spawn clean name
        /if (${ImmuneAdd.Find[null]}) {
            /varset ImmuneAdd ${Spawn[id ${MezID}].CleanName}
        } else {
            /varset ImmuneAdd ${ImmuneAdd},${Spawn[id ${MezID}].CleanName}
        }
        /if (!${MezImmune.Find[${Spawn[id ${MezID}].CleanName}]}) /ini "${InfoFileName}" "${Zone}${If[${Me.InInstance},_I,]}" "MezImmune" "${ImmuneAdd}"
        /call BroadCast g "MEZ Immune -> ${Spawn[id ${MezID}].CleanName} <- ID:${MezID} Adding to MezImmune list."
        | Reassign mezimmune var the new list
        /varset MezImmune ${ImmuneAdd}
    /return
		
| -------------------------------------------------------------------------------------
| SUB: Mez Mobs
| -------------------------------------------------------------------------------------
    Sub MezMobs(int MobID, int TimerNum, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGMEZ MezMobs Enter from ${FromWhere} - MobID:${MobID} Timer#:${TimerNum}
        /declare MezFail 	int local 0
        /declare MezTry 	int local 1
        /declare ReMez 		int local 0
		/declare ReturnMsg	string	local
        /if (${Me.Combat} || ${AggroTargetID} || ${Me.CombatState.Equal[COMBAT]}) {
            /attack off
            /delay 25 !${Me.Combat}
        }
        | Added this check because of timing. Mob to mez was getting DOTed because of MeleeTwist. 
        /if (${IAmABard} && ${MeleeTwistOn}) /call CastBardCheck FROMHERE 0
		/call TargetThis ${MobID}
        /if (${Target.ID}==${MobID}) {
            /if (${Int[${Target.Mezzed.ID}]} && ${Target.Mezzed.Name.Equal[${MezSpell}]}) {
                DEBUGMEZ MezTimer${TimerNum} ${MezTimer${TimerNum}} Target Info: ${Target.Mezzed.ID} ${Target.Mezzed.Name} ${Target.BuffDuration[${Target.Mezzed.Name}].TotalSeconds} Line#: ${Macro.CurLine}
                /if (${Target.BuffDuration[${Target.Mezzed.Name}].TotalSeconds}>${Math.Calc[(${Spell[${MezSpell}].Duration.TotalSeconds}+${MezMod})*.10]}) {
                    /varcalc MezCount[${TimerNum}] 1
                    /varcalc MezTimer${TimerNum} (${Target.BuffDuration[${Target.Mezzed.Name}].TotalSeconds}*10)*.85
					POPCALL
                    /return
                }
            }
            /if (${MezCount[${TimerNum}]}<1) {
                /call BroadCast g "MEZZING-> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
            } else {
                /call BroadCast g "ReMEZZING-> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                /varset ReMez 1
            }
            | Chanter mez code
            /if (${Me.Class.Name.Equal[Enchanter]}) {
                /while (1) {
                    /call CastWhat "${MezSpell}" ${MobID} MezMobs 0 0 FROMHERE
					/varset ReturnMsg ${Macro.Return}
                    /varcalc MezFail ${MezFail}+1
                    /if (${ReturnMsg.Equal[CAST_SUCCESS]}) {
                        /if (!${ReMez}) {
                            /call BroadCast g "JUST MEZZED -> ${MezSpell} on ${Spawn[id ${MobID}].CleanName}:${MobID}"
                        } else {
                            /call BroadCast g "JUST REMEZZED -> ${MezSpell} on ${Spawn[id ${MobID}].CleanName}:${MobID}"
                        }
                        /varcalc MezCount[${TimerNum}] ${MezCount[${TimerNum}]}+1
                        /varcalc MezTimer${TimerNum} ((${Spell[${MezSpell}].Duration.TotalSeconds}+${MezMod})*10)*.90
                        DEBUGMEZ MezTimer${TimerNum} ${MezTimer${TimerNum}}
                    } else /if (${ReturnMsg.Equal[CAST_RESISTED]} && ${MezFail}<2) {
                        /call BroadCast g "MEZ Resisted -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                        | Added for Debuffing Resistant Mobs while Mezzing.
                        /if (${MezDebuffOnResist} && !${Target.Tashed.ID}) {
                            /while (${Me.SpellInCooldown}) {
                                /delay 3
                            }
                            /call CastWhat "${MezDebuffSpell}" ${MobID} MezDebuff 0 0 FROMHERE
                            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                                /call BroadCast g "MEZ Debuffed -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                                /while (${Me.SpellInCooldown}) {
                                    /delay 3
                                }
                            }
                        } else /if (${Target.Tashed.ID} && ${MezFail}>1) {
							|
							| We tried. Treat it as an immune for this battle.
							|
							/if (!${MezImmuneIDs.Find[|${MobID}]}) /call AddMezImmune ${MobID}
							POPCALL
							/return CAST_IMMUNE
						}
                        /continue
                    } else /if (${ReturnMsg.Equal[CAST_IMMUNE]}) {
						/call BroadCast g "MEZ Immune Detected -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                        /if (!${MezImmuneIDs.Find[|${MobID}]}) /call AddMezImmune ${MobID}
						|
						| Mark the name as such.  We need to add a zone specific flag in the kissassist_info.ini.
						| Some zones have mobs which vary in whether they are invis!
						|						
						|/call Bind_AddMezImmune ${MezArray[${i},3]}
						POPCALL
						/return CAST_IMMUNE
                    } else /if (${Macro.Return.Equal[CAST_CANCELLED]}) {
                        /if (${CastingInterruptOn}) {
							POPCALL
							/return CAST_CANCELLED
						}
                    }
                    /break
                }
            | Bard mez code
            } else /if (${IAmABard}) {
                /while (1) {
                    /call CastWhat "${MezSpell}" ${MobID} MezMobs 0 0 FROMHERE
					/varset ReturnMsg ${Macro.Return}
                    /varcalc MezFail ${MezFail}+1
                    /if (${ReturnMsg.Equal[CAST_SUCCESS]}) {
                        /if (!${ReMez}) {
                            /call BroadCast g "JUST MEZZED -> ${MezSpell} on ${Spawn[id ${MobID}].CleanName}:${MobID}"
                        } else {
                            /call BroadCast g "JUST REMEZZED -> ${MezSpell} on ${Spawn[id ${MobID}].CleanName}:${MobID}"
                        }
						/call TargetThis
                        /varcalc MezCount[${TimerNum}] ${MezCount[${TimerNum}]}+1
                        /varcalc MezTimer${TimerNum} ((${Spell[${MezSpell}].Duration.TotalSeconds}+${MezMod})*10)*.90
                        DEBUGMEZ MezTimer${TimerNum} ${MezTimer${TimerNum}} ${ReturnMsg}
                    } else /if (${ReturnMsg.Equal[CAST_RESISTED]} && ${MezFail}<2) {
                        /call BroadCast g "MEZ Resisted -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                        DEBUGMEZ Cast Resisted ${ReturnMsg}
                        /continue
                    } else /if (${ReturnMsg.Equal[CAST_IMMUNE]}) {
						/call BroadCast g "MEZ Immune Detected -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                        /if (!${MezImmuneIDs.Find[|${MobID}]}) /call AddMezImmune ${MobID}
						|
						| Mark the name as such.  We need to add a zone specific flag in the kissassist_info.ini.
						| Some zones have mobs which vary in whether they are invis!
						|						
						|/call Bind_AddMezImmune ${MezArray[${i},3]}
                        DEBUGMEZ Cast Immune ${ReturnMsg}
						|
						| Need to add this
						|
						POPCALL
						/return CAST_IMMUNE
                    } else /if (${ReturnMsg.Equal[CAST_CANCELLED]}) {
                        DEBUGMEZ Cast Cancelled ${ReturnMsg}
                        /if (${CastingInterruptOn}) {
							POPCALL
							/return CAST_CANCELLED
						}
                    }
                    /break
                }
            | Necro mez code
            } else /if (${Me.Class.Name.Equal[Necromancer]}) {
                /while (1) {
                    /call CastWhat "${MezSpell}" ${MobID} MezMobs 0 0 FROMHERE
					/varset ReturnMsg ${Macro.Return}
                    /varcalc MezFail ${MezFail}+1
                    /if (${ReturnMsg.Equal[CAST_SUCCESS]}) {
                        /varcalc MezCount[${TimerNum}] ${MezCount[${TimerNum}]}+1
                        /varcalc MezTimer${TimerNum} ((${Spell[${MezSpell}].Duration.TotalSeconds}+${MezMod})*10)*.95
                        DEBUGMEZ MezMobs MezTimer${TimerNum} ${MezTimer${TimerNum}}
                        | Necro flag to release from mez loop since spell has 6 sec refresh.
                    } else /if (${ReturnMsg.Equal[CAST_RESISTED]} && ${MezFail}<2) {
                        /call BroadCast g "MEZ Resisted -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                        /continue
                    } else /if (${ReturnMsg.Equal[CAST_IMMUNE]}) {
						/call BroadCast g "MEZ Immune Detected -> ${Spawn[id ${MobID}].CleanName} <- ID:${MobID}"
                        /if (!${MezImmuneIDs.Find[|${MobID}]}) /call AddMezImmune ${MobID}
						|
						| Mark the name as such.  We need to add a zone specific flag in the kissassist_info.ini.
						| Some zones have mobs which vary in whether they are invis!
						|						
						|/call Bind_AddMezImmune ${MezArray[${i},3]}
                    }
                    /break
                }
            }
            /varset MezTry 0
        }
		POPCALL
        DEBUGMEZ MezMobs Leave
    /return ${ReturnMsg}

| -------------------------------------------------------------------------------------
| SUB: Mez Mobs AE
| -------------------------------------------------------------------------------------
    Sub MezMobsAE(int AEMezID, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGMEZ Enter from ${FromWhere}

        | Bard AE mez code
        /declare i int local 1
        /declare WasChasing int local 0
        /if (!${Me.AltAbility[${MezAESpell}]} && !${Me.Book[${MezAESpell}]}) {
            /echo Invalid AEMezSpell ${MezAESpell}. Check the spelling.
			POPCALL
            /return
        }
        /if (${IAmABard}) {
            /if (${Target.ID}) /varset AEMezID ${Target.ID}
            /call CastWhat "${MezAESpell}" ${AEMezID} Mez 0 0 FROMHERE
            /call BroadCast g "MEZZING-> AE Mezzing Now - ${MezAESpell} "
            |/delay 35
            /varset MezAETimer 300
        }
        | Enchanter AE mez code
        /if (${Me.Class.Name.Equal[Enchanter]}) {
            /if (${ChaseAssist}) {
                /varset ChaseAssist 0
                /varset WasChasing 1
                /squelch /stick off
                /moveto off
                /if (${PullMoveUse.Equal[nav]}) {
                    /if (${Navigation.Active}) /squelch /nav stop
                }
                /delay 30 !${Me.Moving}
            }
            /echo I AM AE MEZZING ${MezAESpell}
            /while (!${Me.SpellReady[${MezAESpell}]}) {
                /delay 2
            }
            /call CastWhat "${MezAESpell}" ${AEMezID} Mez 0 0 FROMHERE
            /echo I JUST CAST AE MEZ ${MezAESpell}
            /varset MezAETimer ${Spell[${MezAESpell}].Duration.TotalSeconds}s
            /delay 10 ${Me.SpellReady[${MezAESpell}]}
            DEBUGMEZ TIMER SET ${MezAETimer}
            /call BroadCast g "AE MEZZING-> ${MezAESpell}"
            /if (${WasChasing}) /varset ChaseAssist 1
        }
        | Reset all mez timers to 0 after AE Mez
        /for i 1 to 30
            /varset MezTimer${i} 0
        /next i
		POPCALL
    /return
