
| ---------------------------------------------------------------------------
| Sub AdvancePullCamp
| ---------------------------------------------------------------------------
	Sub AdvancePullCamp(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGPULL Enter from ${FromWhere}

		/declare i 			    int     local 0
		/declare Waiting 	    int     local 1
		/declare Arrived	    int	    local 1
        /declare AdvanceTimer   timer   local 0
        /declare GroupPCs       int     local 0

        /varcalc GroupPCs ${Group}-${Group.MercenaryCount}
		
   		/if (${Pet.ID} && ${Pet.Stance.NotEqual[follow]}) /pet follow

        | Same as /camphere off
        /call Bind_BreakCamp
        /delay 2s

		| Is everyone alive?
		| Is anyone told to stay put?
        |/if (${IAmAMage} && ${Me.Level}>=55) {
        |    /call Bind_CothGroup
        |}

        /call Bind_ToggleVariable ReturnToCamp on
        /squelch /bcga //nav locyxz ${Me.Y} ${Me.X} ${Me.FloorZ}
        /varset AdvanceTimer 2m

        | If we get aggro, we need to tough it out. The crew is coming. We broke camp, so we wait.
		/while ((${Waiting} || ${Arrived}<${GroupPCs}) && !${AdvanceTimer}) {
            /doevents GotHit
			/varset Waiting 0
			/varset Arrived 0
			/for i 1 to ${Group}
				/if (${Group.Member[${i}].Type.Equal[PC]} && ${Group.Member[${i}].Distance}>15 && !${Spawn[=${Group.Member[${i}].Name}].Moving}) {
					/bct ${Group.Member[${i}].CleanName} //nav locyxz ${Me.Y} ${Me.X} ${Me.FloorZ}
					/varset Waiting 1
				}
				/delay 5
			/next i

            /for i 1 to ${Group}
				/if (${Group.Member[${i}].Type.Equal[PC]} && ${Group.Member[${i}].Distance}<=15) {
					/varcalc Arrived ${Arrived}+1
				}
                /delay 2
            /next i
			/if (${Waiting} || ${Arrived}<${GroupPCs}) /delay 1s
		}

        /if (${Waiting} || ${Arrived}<${GroupPCs}) {
            /echo \awAKA: \ayThe group isn't together, but we are out of time.
        }

        /call Bind_MakeCampHere
		/delay 20
		
		POPCALL
	/return 1

| ---------------------------------------------------------------------------
| Sub AmIStuck
| ---------------------------------------------------------------------------
	Sub AmIStuck(int MeX, int MeY, int MeDelay, string FROMHERE)

		/delay ${MeDelay}
		/if (${Math.Abs[${Int[${Math.Calc[${Me.X}-${MeX}]}]}]}<3 && ${Math.Abs[${Int[${Math.Calc[${Me.Y}-${MeY}]}]}]}<3) {
			/return 1
        }
	
	/return 0

|--------------------------------------------------------------------------------------
| SUB: BacktoCampReset
|--------------------------------------------------------------------------------------
    Sub BacktoCampReset(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL BacktoCampReset: Enter from ${FromWhere}
        /if (${ReturnToCamp}) {
            /call DoWeMove 0 FROMHERE
        } else /if (${Math.Distance[${CampYLoc},${CampXLoc}]} < ${CampRadius} || ${Select[${Role},hunter,hunterpettank]}) {
            /call PullReset
            /call DoWeMove 1 FROMHERE
            POPCALL
            /return TRUE
        }
		POPCALL
        DEBUGPULL BacktoCampReset: Leave
    /return 0
	
| ---------------------------------------------------------------------------
| Sub Bind_AdvanceCamp
| ---------------------------------------------------------------------------
	Sub Bind_AdvanceCamp (string Flag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

		| Not sure If I'm going to do this

	/return
	
| ----------------------------------------------------------------------------
| SUB: Bind BreakCamp
| ----------------------------------------------------------------------------
    Sub Bind_BreakCamp
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
            /bcg //camphere off
        } else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
            /dgge /camphere off
        } else {
            /echo BreakCamp command requires MQ2EQBC/MQ2DanNet.
        }
    /return

| ----------------------------------------------------------------------------
| SUB: Bind ChaseMe
| ----------------------------------------------------------------------------
    Sub Bind_ChaseMe
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
            /bcg //chase on ${Me.CleanName}
        } else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
            /dgge /chase on ${Me.CleanName}
        } else {
            /echo ChaseMe command requires MQ2EQBC/MQ2DanNet plugin loaded.
        }
    /return
	
| ----------------------------------------------------------------------------
| SUB: Bind MakeCampHere
| ----------------------------------------------------------------------------
    Sub Bind_MakeCampHere
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
            /bcg //camphere on
        } else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
            /dgge /camphere on
        } else {
            /echo Makecamphere command requires MQ2EQBC/MQ2DanNet.
        }
    /return
	
| ----------------------------------------------------------------------------
| SUB: Bind StayHere
| ----------------------------------------------------------------------------
    Sub Bind_StayHere
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
            /bcg //waithere
        } else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
            /dgge /waithere
        } else {
            /echo Stayhere command requires MQ2EQBC/MQ2DanNet plugin loaded.
        }
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Bind_TrackMeDown
| -------------------------------------------------------------------------------------
    Sub Bind_TrackMeDown(int StickOff, int UseNavOnly, int IgnoreDistance)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /if (${DontMoveMe}) {
            /echo WAIT UP! I was told not to move. Leaving TrackMeDown.
			POPCALL
            /return
        }
        DEBUGN Bind_TrackMeDown Enter
        /declare tmdChaseAssist int local ${ChaseAssist}
        /declare tmdReturnToCamp int local ${ReturnToCamp}
        /declare tmdChaseDistance int local ${ChaseDistance}
        /declare tmdCampRadiusExceed int local ${CampRadiusExceed}
        | Check if I am Dead.
        /if (${Me.Hovering} || ${IAmDead}) {
			POPCALL
			/return
		}
        | Check if Who to chase character is in the zone.
        /if (${Spawn[pc ${WhoToChase}].ID}==0) {
			POPCALL
			/return
			}
        /varset BindActive 1
        | Check if we are to use Navigation and it is loaded with a valid Mesh and Path.
        /if (${UseNavOnly} ) {
            /if (${PullMoveUse.NotEqual[nav]} || !${Navigation.MeshLoaded}) {
                /echo I can't Track Down ${WhoToChase}. Navigation not loaded or bad Mesh.
				POPCALL
                /return
            } else {
                /if (${Navigation.PathExists[id ${Spawn[pc ${WhoToChase}].ID}]}==FALSE) {
                    /echo I can't Track Down ${WhoToChase}. No Valid Path too destination.
					POPCALL
                    /return
                }
            }
        }
        /varset ChaseAssist 2
        /varset ReturnToCamp 0
        /varset ChaseDistance 20
        /if (${IgnoreDistance}) /varset CampRadiusExceed 100000
        /if (${Me.Casting.ID}) /stopcast
        | Go chase them down.
        /call DoWeChase FROMHERE
        | Set things back
        /if (${tmdReturnToCamp}) {
            /varset CampXLoc ${Me.X}
            /varset CampYLoc ${Me.Y}
            /varset CampZLoc ${Me.FloorZ}
            /varset LookForward ${Me.Heading.DegreesCCW}
            /echo >> New camp set ${Me.Y}, ${Me.X}
        }
        /if (${StickOff}) {
            /if (${Stick.Active}) /squelch /stick off
        }
        /varset ChaseAssist ${tmdChaseAssist}
        /varset ReturnToCamp ${tmdReturnToCamp}
        /varset ChaseDistance ${tmdChaseDistance}
        /varset CampRadiusExceed ${tmdCampRadiusExceed}
        /varset BindActive 0
		POPCALL
        DEBUGN Bind_TrackMeDown Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: CheckStick
| -------------------------------------------------------------------------------------
    Sub CheckStick(int p_Flag1, int p_UseAttack, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare navTimer timer local 0
        DEBUGCOMBAT CheckStick: Enter from ${FromWhere}
        DEBUGCOMBAT CheckStick: 1:${Stick.Active} 2:!${IAmMA} 3:${MoveUtils.Aggro} 4:${StickHow} 5:${Me.FeetWet}

        /if (${MeleeDistance}>${CampRadius}) {

			/if (${Spawn[id ${MyTargetID}].MaxRangeTo.Int}<${Spawn[id ${MyTargetID}].Distance}) {
				/if (${PullMoveUse.Equal[nav]}) {
				|/if (${Spawn[id ${MyTargetID}].MaxRangeTo.Int}<${Spawn[id ${MyTargetID}].Distance}) {
					/squelch /nav id ${MyTargetID}
					/varset navTimer 20
					/while (${navTimer}) {
						/if (${Spawn[id ${MyTargetID}].MaxRangeTo.Int}>=${Spawn[id ${MyTargetID}].Distance}) {
							/squelch /nav stop
							/break
						}
					}
				|}
				} else {
					/moveto dist ${Spawn[id ${MyTargetID}].MaxRangeTo}
				}
			}
         
        }
        
        /if (${UseMQ2Melee}) {
            /if (${p_UseAttack}) /killthis
			POPCALL
            /return
        } else {
            /if (${p_UseAttack} && !${Me.Combat} && ${Target.ID} && ${Select[${Me.State},stand,mount]}) /attack on
        }

        /if (${MeleeDistance}>${CampRadius}) {

			/if (!${Select[${StickHow},0,I]}) {
				/if (!${p_Flag1}) {
					/if (${Me.FeetWet}) {
						/stick ${Math.Calc[${Spawn[id ${MyTargetID}].MaxRangeTo}-3]} id ${MyTargetID} ${StickHow} uw
					} else {
						/stick ${Spawn[id ${MyTargetID}].MaxRangeTo} id ${MyTargetID} ${StickHow}
					}
				} else /if (${p_Flag1}==1) {
					/if (${Target.ID} && ${Me.TargetOfTarget.ID}!=${Me.ID}) {
						/if (${Me.FeetWet}) {
							/stick id ${MyTargetID} ${StickHow} uw
						} else {
							/stick id ${MyTargetID} ${StickHow}
						}
					}
				}
			} else /if (${StickHow.NotEqual[I]}) {
				/if (!${p_Flag1}) {
					/if (${Me.FeetWet}) {
						/stick ${Math.Calc[${Spawn[id ${MyTargetID}].MaxRangeTo}-3]} id ${MyTargetID} uw
					} else {
						/stick ${Spawn[id ${MyTargetID}].MaxRangeTo} id ${MyTargetID}
					}
				} else /if (${p_Flag1}==1) {
					/if (${Target.ID} && ${Me.TargetOfTarget.ID}!=${Me.ID}) {
						/if (${Me.FeetWet}) {
							/stick id ${MyTargetID} uw
						} else {
							/stick id ${MyTargetID}
						}
					}
				}
			}
        
        }
        POPCALL
        DEBUGCOMBAT CheckStick: Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Do We Chase
| -------------------------------------------------------------------------------------
    Sub DoWeChase(string FromWhere)	
        /if (!${ChaseAssist}) /return
        /if (${Me.Hovering} || !${Spawn[=${WhoToChase}].ID}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare StuckCount int local 0
        /declare X1 int local
        /declare Y1 int local
        /declare MeshLoadedCheck bool local FALSE
        /declare DWMWPCurrent int local 0
        /declare DWMTimer timer local 0
        /if (${PullMoveUse.Equal[nav]}) {
            /varset MeshLoadedCheck ${Navigation.MeshLoaded}
        }
        DEBUGMOVE DoWeChase: Enter from ${FromWhere}
        /if (${Pet.ID} && ${Pet.Stance.NotEqual[follow]}) /pet follow
        /while (${ChaseAssist}) {
            | Stop sticking if mobs are on xtarget
            /if (${ChaseAssist}==1) {
                /if (${SpawnCount[npc xtarhater]} && !${Role.Find[pull]} && !${IAmMA} && ${Spawn[=${WhoToChase}].Distance} < ${CampRadius}) {
                    /if (${Stick.Active}) {
                        DEBUGMOVE Not gonna be an idiot and move during fight cause I dont have to.
                        /stick off
                        /moveto off
                    }
                    /if (${PullMoveUse.Equal[nav]}) {
                        /if (${Navigation.Active}) /squelch /nav stop
                    }
                    /break
                }
            }
            /doevents
            /call EndMacroIf FROMHERE
            DEBUGMOVE DoWeChase:(ChaseAssist) My distance from (${WhoToChase}) is: (${Spawn[=${WhoToChase}].Distance}) Z: ${Spawn[=${WhoToChase}].DistanceZ}.
            | If the mesh loaded then ignore Distance and Z Distance. Just try and run the path to WhoToChase.
            /if (${JustZoned}==0) {
                /if (!${MeshLoadedCheck} && (${Spawn[=${WhoToChase}].Distance} > ${CampRadiusExceed} || ${Spawn[=${WhoToChase}].DistanceZ}>100)) {
                    /if (${Debug} || ${DebugMove}) /echo \atDEBUG ChaseAssist exceed camp check
                    /varset ChaseAssist 0
                    /echo ChaseAssist distance exceeded: Turning off ChaseAssist
                    /call BroadCast r "Hey! I got left behind please run me to " ${WhoToChase}
                    /break
                }
            } else {
                /while (!${Spawn[=${WhoToChase}].ID}) {
                    /delay 10
                    /if (!${JustZoned}) /break
                    DOPARSE
                }
            }
            /if (!${Spawn[=${WhoToChase}].ID}) /break
            /if (${Spawn[=${WhoToChase}].Distance} > ${ChaseDistance}) {
                /if (${Debug} || ${DebugMove}) /echo \atDEBUG ChaseAssist MA distance check
                /if (${MeshLoadedCheck}) {
                    /if (!${Navigation.Active}) {
                        /if (${Navigation.PathExists[id ${Spawn[=${WhoToChase}].ID}]}) {
                            /squelch /nav id ${Spawn[=${WhoToChase}].ID}
                        } else /if (${Spawn[=${WhoToChase}].LineOfSight}) {
                            /moveto id ${Spawn[=${WhoToChase}].ID} uw mdist ${ChaseDistance}
                        } else {
                            /echo Chase Failed due to ${WhoToChase} is not in Line of sight and Navigation couldn't find a path. Will try /Sticking.
                        }
                    }
                } else /if (${Spawn[=${WhoToChase}].LineOfSight}) {
                    /moveto id ${Spawn[=${WhoToChase}].ID} uw mdist ${ChaseDistance}
                }
                /delay 10 ${Me.Moving}
                /while (${Me.Moving}) {
                    /if (${Spawn[=${WhoToChase}].Distance3D}<=${ChaseDistance}) {
                        /if (${PullMoveUse.Equal[nav]}) {
                            /if (${Navigation.Active}) /squelch /nav stop
                        }
                    }
                    /delay 5
                }
            } else /if (!${Stick.Active} && !${MeshLoadedCheck}) {
                /if (${Spawn[=${WhoToChase}].Type.Equal[Pet]}) {
                    /squelch /target ${Spawn[=${WhoToChase}].Master}
                    /delay 10
                    /if (${Me.FeetWet}) {
                        /stick ${ChaseDistance} id ${Target.ID} loose uw
                    } else {
                        /stick ${ChaseDistance} id ${Target.ID} loose
                    }
                } else /if ( ${Spawn[=${WhoToChase}].Type.Equal[mercenary]}) {
                    /squelch /target ${Spawn[=${WhoToChase}].Owner}
                    /delay 10
                    /if (${Me.FeetWet}) {
                        /stick ${ChaseDistance} id ${Target.ID} loose uw
                    } else {
                        /stick ${ChaseDistance} id ${Target.ID} loose
                    }
                } else {
                   /if (${Me.FeetWet}) {
                        /stick ${ChaseDistance} id ${Spawn[=${WhoToChase}].ID} loose uw
                    } else {
                       /stick ${ChaseDistance} id ${Spawn[=${WhoToChase}].ID} loose
                    }
                }
                /delay 10
                /while (${Me.Moving}) {
                    /delay 10
                }
            }
            /if (!${Me.Moving} && !${Spawn[=${WhoToChase}].Moving}) /break
            /while (${ChaseAssist}==3) {
                /delay 10
            }
        }
		POPCALL
        DEBUGMOVE DoWeChase: Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Do We Move
| -------------------------------------------------------------------------------------
    Sub DoWeMove(int ForceToCamp, string FromWhere)
        /if (!${ReturnToCamp} && !${ForceToCamp}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
				
        /declare StuckCount int local 0
        /declare X1 int local
        /declare Y1 int local
        /declare scatterDistance int local
        /declare CampYRandom int local
        /declare CampXRandom int local
        /doevents
        /call EndMacroIf FROMHERE
        /declare DWMWPCurrent int local 0
        /declare DWMTimer timer local 30s
        /declare SpamTimerL timer local 0
        /if (${Target.ID} && ${Target.Type.Equal[npc]}) {
            | Should this be using FloorZ?
            /varcalc ZDist ${Math.Distance[${Target.Z}:${Me.Z}]}-(${Target.Height}-${Me.Height})
        }
        /declare circleDirection string local
        DEBUGN DoWeMove: Enter from ${FromWhere}
        | - Shuts off ReturnToCamp if a toon moves a big distance defined by CampRadiusExceed ie CoH !${Pulled} || ${Pulling}
        DEBUGMOVE DoWeMove:(ReturnToCamp) My distance from camp is: (${Math.Distance[${CampYLoc},${CampXLoc}]}).
        /if (${Math.Distance[${CampYLoc},${CampXLoc}]} > ${CampRadiusExceed} && !${Role.Find[hunter]} && ${ReturnToCamp}==1 && ${CampZone}==${Zone.ID}) {
            DEBUGMOVE DoWeMove:(ReturnToCamp) CampRadiusExceed turning off ReturnToCamp.
            /varset ReturnToCamp 0
            /echo Leashing exceeded distance of ${CampRadiusExceed} turning off ReturnToCamp
			POPCALL
            /return
        }
        /if (${Math.Distance[${CampYLoc},${CampXLoc}]} > ${Math.Calc[${CampRadius}/2]} && ${CampZone}==${Zone.ID}) {
            /if (${Me.Feigning}) {
                /if (${AggroOffTimer}) {
                    /while (${Me.Feigning}) {
                        /doevents Timer
                        /delay 5
                    }
                } else {
                    /doevents Timer
                    /delay 10
                    /if (${Me.Feigning}) /stand
                }
            }
            DEBUGMOVE DoWeMove:(ReturnToCamp) Distance to camp > 10 and no adds in camp. ${Math.Distance[${CampYLoc},${CampXLoc}]} ${CampRadius} ${Medding}
            | Prevent puller roles from returning to camphere spot and just pull from where they are if in camp radius.
            /if (${Select[${Role},puller,pullertank,pullerpettank]} && ${Math.Distance[${CampYLoc},${CampXLoc}]}<=${CampRadius} && !${ForceToCamp} && !${Medding}) {
                POPCALL
                /return
            }
            /if (${Select[${Role},puller,pullertank,pullerpettank,hunter,hunterpettank]} && ${Math.Distance[${CampYLoc},${CampXLoc}]} > 15) {
                |---------------------------------------------- MQ2Nav ---------------------------------------------------------------------|
                /if (${PullMoveUse.Equal[nav]}) {
                    /if (${Math.Distance[${CampYLoc},${CampXLoc}]} > ${CampRadius})  {
                        DEBUGMOVE DoWeMove:(ReturnToCamp) Distance to camp > 15, MQ2Nav return to camp.
                        /while (1) {
                            /doevents
                            /if (${IAmDead} || ${Me.Hovering}) {
                                /if (${Navigation.Active}) /squelch /nav stop
								POPCALL
                                /return IAD
                            }
                            /if (!${Me.Mount.ID} && ${Me.Sitting}) /stand
                            /squelch /nav locxyz ${CampXLoc} ${CampYLoc} ${CampZLoc}
                            /if (${Me.Mount.ID} && ${Math.Distance[${CampYLoc},${CampXLoc}]} <= 75) {
                                /echo MQ2Nav does not work well with mounts. Dismounting.
                                /dismount
                            }
                            /while (1) {
                                /varset X1 ${Int[${Me.X}]}
                                /varset Y1 ${Int[${Me.Y}]}
                                /if (${Pulled}) {
                                    | PullerPetTank - send in pet to attack on my way back to camp if not too far from camp.
                                    /if (${Role.Equal[pullerpettank]} || ${PullWith.Equal[pet]}) {
                                        /if (${Pet.ID}) {
                                            /if (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}<=${PetAttackRange}) {
                                                /call CombatPet FROMHERE
                                            } else {
                                                /if (${Pet.Combat}) /call PetBackOff FROMHERE
                                                /if (${Pet.Stance.NotEqual[FOLLOW]} && ${PullWith.Equal[pet]}) /pet follow
                                            }
                                        }
                                    }
                                    |if MyTargetID is not on Xtarget, and the mob is still in the zone, then the mob lost aggro.
                                    |and we need to go back and get him.
                                    /if (!${SpawnCount[id ${MyTargetID} xtarhater]} && ${Spawn[id ${MyTargetID}].ID}) {
                                        /if (!${AggroTargetID} || (${ChainPull} && !${PullAggroTargetID})) {
                                            |/echo I got Here1: ${AggroTargetID} ${ChainPull} ${PullAggroTargetID} ${MyTargetID}
                                            /varset Pulled 0
                                            | if using ranged then try and pull mob again, other wise start looking for another mob.
                                            /if (${PullWith.Equal[Ranged]}) {
                                                /if (${Navigation.Active}) /squelch /nav stop
												POPCALL
                                                /return lma
                                            } else {
                                                /continue
                                            }
                                        } else /if (!${ChainPull}) {
                                            /varset MyTargetID ${AggroTargetID}
                                        } else {
                                            /varset MyTargetID ${PullAggroTargetID}
                                        }
                                        /if (!${MyTargetID}) /varset Pulled 0
                                    }
                                    /if ((${Me.Running} && !${SpawnCount[xtarhater radius 300]}) || (!${Me.Running} && ${SpawnCount[xtarhater radius 200]})) /nomodkey /keypress RUN_WALK
                                } else {
                                    | Added for finding mob to pull when running back to camp after a failed pull.
                                    /if (${CheckOnReturn} && ${Math.Distance[${CampYLoc},${CampXLoc}]} < ${Math.Calc[${MaxRadius}*.90]}) {
                                        /call FindMobToPull 0 1 FROMHERE
                                        /if (${Macro.Return}>0) {
                                            /varset MyTargetID 0
                                            /if (${Navigation.Active}) /squelch /nav stop
											POPCALL
                                            /return 
                                        }
                                    }
                                }
                                /delay 5
                                /if (${Me.Hovering}) {
                                    /break
                                } else /if (!${Me.Stunned} && !${Me.Feigning}) {
                                    | Check for getting stuck on geometry
                                    /if (${Int[${Me.X}]}==${X1} && ${Int[${Me.Y}]}==${Y1}) {
                                        /varcalc StuckCount (${StuckCount})+1
                                        /if (${StuckCount}>=3) {
                                            /if (${Navigation.Active}) /squelch /nav stop
                                            /call Stuck FROMHERE
                                            /varset StuckCount 0
                                            /break
                                        }
                                    }
                                } else /if (${Me.Stunned}) {
                                    /while (${Me.Stunned}) {
                                        /delay 2
                                    }
                                    /break
                                }
                                DEBUGMOVE DoWeMove: Distance to camp ${Math.Distance[${CampYLoc},${CampXLoc}]} >= ${CampRadius} Timer: ${DWMTimer}
                                /if (!${Navigation.Active} || !${DWMTimer}) /break
                            }
                            /if (${Math.Distance[${CampYLoc},${CampXLoc}]} < 16) /break
                        }
                    }
                |---------------------------------------------- MQ2AdvPath ---------------------------------------------------------------------|
                } else /if (${PullPathWpCount} && ${PullMoveUse.Equal[advpath]}) {
                    /if (${MoveTo.Moving}) /moveto off
                    /play ${PullPath} reverse nodoor smart
                    DEBUGMOVE DoWeMove: /play ${PullPath} reverse nodoor smart
                    /while (1) {
                        /doevents
                        /if (${IAmDead} || ${Me.Hovering}) {
                            /if (${AdvPath.State}) /play off
							POPCALL
                            /return
                        }
                        /delay 5
                        /varset DWMWPCurrent ${AdvPath.NextWaypoint}
                        DEBUGMOVE DoWeMove: ReturnToCamp WP#: ${DWMWPCurrent} ${MoveTo.Moving}
                        /if (${AdvPath.State}==2 && ${Me.Moving} && ${DWMTimer}<10) /varset DWMTimer 10
                        /if (${DWMTimer}==0) /break
                        |This is for when you get summoned while running back to camp.
                        |AdvPath stops playing the path back to camp when summoned.
                        /if (${DWMWPCurrent}<2) {
                            /break
                        } else /if (${AdvPath.State}==0) {
                            /play ${PullPath} reverse nodoor smart
                            /varset DWMTimer 10
                        }
                        /if (${Pulled}) {
                            /if ((${Me.Running} && !${SpawnCount[xtarhater radius 300]}) || (!${Me.Running} && ${SpawnCount[xtarhater radius 200]})) /nomodkey /keypress RUN_WALK
                        }
                    }
                    /if (${AdvPath.State}) /play off
                }
            } else /if (${PullMoveUse.Equal[nav]}) {
                DEBUGMOVE DoWeMove:(ReturnToCamp) Non-Puller MQ2Nav return to camp.
                /varset DWMTimer 10s
                /doevents
                /if (${IAmDead} || ${Me.Hovering}) {
                    /if (${Navigation.Active}) /squelch /nav stop
					POPCALL
                    /return
                }
                /if (!${Me.Mount.ID} && ${Me.Sitting}) /stand
                /squelch /nav locxyz ${CampXLoc} ${CampYLoc} ${CampZLoc}
                /while (1) {
                    /if (${IAmDead} || ${Me.Hovering}) {
                        /if (${Navigation.Active}) /squelch /nav stop
						POPCALL
                        /return
                    }
                    /if (!${Navigation.Active} || !${DWMTimer}) /break
                }
            }
            |------------------------------------------------ MoveTo -----------------------------------------------------------------------|
            DEBUGMOVE DoWeMove: Distance to camp ${Math.Distance[${CampYLoc},${CampXLoc}]} > 15, MQ2MoveUtils return to camp.
            /doevents
            /if (!${Me.FeetWet}) /look 0
            /moveto dist 10
            /if (${ScatterOn}) {
                | Randomize camp x,y by +- so toons don't always retun to exact same spot and help to look less botted.
                /varcalc scatterDistance ${Math.Rand[7]}+5
                /if (${Math.Rand[2]}) {
                    /varcalc CampYRandom ${CampYLoc}-${scatterDistance}
                } else {
                    /varcalc CampYRandom ${CampYLoc}+${scatterDistance}
                }
                /if (${Math.Rand[2]}) {
                    /varcalc CampXRandom ${CampXLoc}-${scatterDistance}
                } else {
                    /varcalc CampXRandom ${CampXLoc}+${scatterDistance}
                }
            } else {
                /varset CampYRandom ${CampYLoc}
                /varset CampXRandom ${CampXLoc}
            }
            DEBUGMOVE DoWeMove: Camp Location Info: ScatterOn: ${ScatterOn} YRandom: ${CampYRandom} XRandom: ${CampXRandom} ${IAmDead} ${Me.Hovering}
            /while (1) {
                /if (${IAmDead} || ${Me.Hovering}) {
                    /moveto off
					POPCALL
                    /return
                }
                /if (!${Me.Mount.ID} && ${Me.Sitting} && ${Math.Distance[${CampYLoc},${CampXLoc}]} >= 16) /stand
                /if (!${Me.Moving} || !${MoveTo.Moving}) {
                    /if (${Me.FeetWet}) {
                        /moveto set useback off
                        /moveto loc ${CampYRandom} ${CampXRandom} ${CampZLoc} uw mdist 15
                    } else {
                        /moveto set useback on
                        /moveto loc ${CampYRandom} ${CampXRandom} ${CampZLoc}
                    }
                }
                /if (${Pulled}) {
                    /if (${Role.Equal[pullerpettank]} || ${PullWith.Equal[pet]}) {
                        /if (${Pet.ID}) {
                            /if (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}<=${PetAttackRange}) {
                                /call CombatPet FROMHERE
                            } else {
                                /if (${Pet.Combat}) /call PetBackOff FROMHERE
                                /if (${Pet.Stance.NotEqual[FOLLOW]} && ${PullWith.Equal[pet]}) /pet follow
                            }
                        }
                    }
                    /if ((${Me.Running} && !${SpawnCount[xtarhater radius 300]}) || (!${Me.Running} && ${SpawnCount[xtarhater radius 200]})) /nomodkey /keypress RUN_WALK
                }
                /delay 10
                /if ((!${MoveTo.Moving} && !${Me.Moving}) || ${DWMTimer}==0) /break
                DEBUGMOVE DoWeMove: MoveTo My distance from Camp is: ${Math.Distance[${CampYRandom},${CampXRandom},${CampZLoc}]} ${Me.FeetWet}.
                /if (!${MoveTo.Moving} || ${Math.Distance[${CampYRandom},${CampXRandom},${CampZLoc}]} < 16) /break
            }
            /if (${Me.FeetWet} && ${Math.Distance[${CampYRandom},${CampXRandom},${CampZLoc}]} >= 15) {
                /varset DWMTimer 20
                /moveto loc ${CampYRandom} ${CampXRandom} ${CampZLoc} uw mdist 15
                /while (${Math.Distance[${CampYRandom},${CampXRandom},${CampZLoc}]} > 15 && ${DWMTimer}) {
                    /delay 5
                }
                /if (${MoveTo.Moving}) /moveto off
            }
            /delay 20 !${Me.Moving}
            | Move down if Z distance more than 3 due to levitation
            /if (${Target.ID} && ${Select[${Target.Type},npc,corpse]})  /call ZAxisCheck ${ZDist} 3.1
            /if (${FaceMobOn} && !${AggroTargetID} && !${CombatStart} || ${Select[${Role},pullertank,puller,pullerpettank]}==0) /face heading ${LookForward}
            /if (!${Me.FeetWet}) /look 0
            |/if (${Select[${Role},hunter,hunterpettank]}) /varset ReturnToCamp 0
        }
        /if (${Me.FeetWet} && ${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]} >= 15) {
            /moveto loc ${CampYLoc} ${CampXLoc} ${CampZLoc} uw mdist 15
            /varset DWMTimer 30
            /while (${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]} > 15 && ${DWMTimer}) {
                /delay 5
            }
            /if (${MoveTo.Moving}) /moveto off
        }
		POPCALL
        DEBUGMOVE DoWeMove: Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Event CantSee
| -------------------------------------------------------------------------------------
    Sub Event_CantSee
		/if (!${MoveIfCantSee}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /doevents flush CantSee
        |/varset EventFlag 1
        DEBUGPULL Event_CantSee
        | Reset position via stick
        /if (${Pulling}) {
           /varset CantSee 1
		   POPCALL
           /return
        }		
		
		DEBUGCOMBAT Event_CantSee		
        | need to add local variables or more Outer to figure stick command parts.
        |Start Here
        /if (${UseMQ2Melee}) {
            DEBUGCOMBAT CantSee ${Attacking} ${Target.ID} ${Target.Distance} ${UseMQ2Melee} ${Stick.Active} ${Me.Moving} ${Melee} ${Melee.Status}
        } else {
            DEBUGCOMBAT CantSee ${Attacking} ${Target.ID} ${Target.Distance} ${UseMQ2Melee} ${Stick.Active} ${Me.Moving}
        }
        /if (${Attacking}) {
			/cast LastMove
            DEBUGCOMBAT Can't See my target. Moving Closer.
            /if (${Me.Sitting}) /stand
            /if (${FaceMobOn} && ${Target.ID}) /squelch /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
            /look 0
            /if (!${UseMQ2Melee}) {
                /if (!${Select[${StickHow},0,I]}) {
                    /if (${Me.FeetWet}) {
                        /if (${Stick.Active}) /Stick off
                        /if (${FaceMobOn} && ${Target.ID}) /face
                        /moveto ${Target.MaxRangeTo} id ${Target.ID} uw
                        /delay 10
                        /if (${IAmMA}) {
                            /stick ${StickDistUW} id ${MyTargetID} moveback uw
                        } else {
                            /stick ${StickDistUW} id ${MyTargetID} behindonce moveback uw
                        }
                    } else {
                        /moveto ${Target.MaxRangeTo} id ${Target.ID}
                        /delay 10
                        /if (${IAmMA}) {
                            /stick ${StickDist} id ${MyTargetID} moveback
                        } else {
                            /stick ${StickDist} id ${MyTargetID} behindonce moveback
                        }
                    }
                } else /if (${StickHow.NotEqual[I]}) {
                    /if (${MeleeOn}) {
                        /if (${Me.FeetWet}) {
                            /stick ${StickDistUW} id ${MyTargetID} moveback uw
                        } else {
                            /if (${IAmMA}) {
                                /stick ${StickDist} id ${MyTargetID} moveback
                            } else {
                                /stick ${StickDist} id ${MyTargetID} !front moveback
                            }
                        }
                    }
                }
            }
        } else {
            /if (${FaceMobOn} && ${Target.ID}) /squelch /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
        }
		POPCALL
        DEBUGCOMBAT Leave Event_CantSee
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event Too Far
| ----------------------------------------------------------------------------
    Sub Event_TooFar
        /doevents flush TooFar

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/call LastMove
        |/varset EventFlag 1
        /if (${CombatStart} && ((!${UseMQ2Melee} && ${StickHow.Equal[I]}) || (${UseMQ2Melee} && ${MeleeDistance}==${CampRadius}))) {
			POPCALL
			/return
		}
        /if (!${Target.ID} || ${Spawn[id ${Target.ID}].Type.Equal[Corpse]}) {
            POPCALL
            /return
        }
        /varcalc ZDist ${Math.Distance[${Target.Z}:${Me.Z}]}-(${Target.Height}-${Me.Height})
        /if (${Math.Distance[${Target.Y},${Target.X}:${CampYLoc},${CampXLoc}]}<=${MeleeDistance} && ${MeleeOn} && ${CombatStart}) {
            /if (!${UseMQ2Melee}) {
                /if (${Me.FeetWet}) {
                    /if (${FaceMobOn}) /face
                    /if (!${Me.Moving}) /moveto id ${MyTargetID} mdist ${If[${Target.Distance}>5,${Math.Calc[${MoveTo.ArrivalDist}-5]},1]} uw
                    /delay 10
                    /if (${IAmMA}) {
                        /squelch /stick ${MoveTo.ArrivalDist} id ${MyTargetID} uw
                    } else {
                        /squelch /stick ${MoveTo.ArrivalDist} id ${MyTargetID} !front moveback uw
                    }
                } else {
                    /if (!${Me.Moving}) /moveto id ${MyTargetID} mdist ${If[${Target.Distance}>5,${Math.Calc[${MoveTo.ArrivalDist}*.90]},1]}
                    /squelch /stick ${MoveTo.ArrivalDist} id ${MyTargetID} ${StickHow}
                }
            } else {
                /if (${FaceMobOn}) /face
                /if (!${Me.Moving}) /moveto id ${MyTargetID} mdist ${If[${Target.Distance}>5,${Math.Calc[${MoveTo.ArrivalDist}-5]},1]} uw
                /delay 10
            }
        }
        /call ZAxisCheck ${ZDist} 4.1
        /if (${Select[${Role},pullertank,pullerpettank,puller]} && ${Pulling}) {
            /varset PullTooFar 1
        }
		POPCALL
    /return

| ---------------------------------------------------------------------------
| Sub GetCloser
| ---------------------------------------------------------------------------
	Sub GetCloser(string WhichMove, string FromWhere)
        /if (!${IAmMA} && !${CalledTargetID}) /return
        /if (!${Select[${Role},PULLER_ROLES]} && !${CalledTargetID}) /return
        /if (${Me.Moving}) /return
        
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT Enter from ${FromWhere}
		
        /if (!${IAmMA}) {
            /if (${Math.Distance[${Me.Y},${Me.X}:${Target.Y},${Target.X}]}>${Spawn[=${MainAssist}].Distance}) {
                |/echo -------------------------------------------------------------------------------------
                /echo \awAKA: \arThe distance I need to travel is further away than the MA is to me.
                |/echo \awAKA: \arCalled from ${FromWhere}
                |/call Bind_CallStack
                /echo \awAKA: \ayHeading to the MA instead.
                /nav spawn ${MainAssist} | distance=10
                /while (${Me.Moving}) {
                    /doevents GotHit
                    /if (${AggroTargetID}) {
                        POPCALL
                        /return
                    }
                    /delay 5
                }
                POPCALL
                /return
            }
        }

		/declare MoveTimer 				timer 	local 30s
		/declare BackedOffPet 			int 	local 0
		/declare MobStartingDistance 	int 	local ${Target.Distance}
        /declare MAStartingDistance     int     local ${Spawn[=${MainAssist}].Distance}
		
        |/if (${Pulling} || ${Pulled} || !${CalledTargetID}) {
        |    DEBUGCOMBAT Pulling. Leaving
        |    POPCALL
        |    /return
        |}
				
		DEBUGCOMBAT Is target or MA moving closer?
	    |/delay 1s
		|/if (${Target.Distance}<${MobStartingDistance} || (!${IAmMA} && ${Spawn[=${MainAssist}].Distance}<${MAStartingDistance})) {		
		|	DEBUGCOMBAT Target or MA are moving closer. Not moving.
		|	POPCALL
		|	/return
		|}
        /delay 1s
        /if (${Target.Distance}<${MobStartingDistance}) {
            POPCALL
            /return
        }

        | If the MA can't see or is further away from me than the mob, we should wait.
        /call IsMACloser ${Target.ID} FROMHERE
        /if (!${IAmMA} && (!${Target.LineOfSight[=${MainAssist}]} && ${Macro.Return.Equal[0]})) {
            DEBUGCOMBAT I'm not the MA, the MA can't see or is further away, so I'm not moving.
            POPCALL
            /return
        }

		DEBUGCOMBAT Can I move if I can't see? ${MoveIfCantSee}
		/if ((${WhichMove.Equal[los]} || ${WhichMove.Equal[both]}) && ${MoveIfCantSee}) {
			|/if (!${Target.LineOfSight} && ${Spawn[id ${Target.ID}].ID} && ${Spawn[id ${Target.ID}].Type.NotEqual[corpse]} && ${Navigation.PathLength[id ${Target.ID}]}<=${MeleeDistance}) {
            /if (!${Target.LineOfSight} && ${Spawn[id ${Target.ID}].ID} && ${Spawn[id ${Target.ID}].Type.NotEqual[corpse]}) {
				DEBUGCOMBAT LOS - Moving closer.
				/echo Can't see ${Target.CleanName} (${Target.ID}). Moving closer.
				/squelch /nav target | distance=15
                /delay 5
                /if (!${Navigation.Active}) {
                    | We aren't moving! Trying something difference.
                    /call NavToWhoWhatByLoc 1 ${Target.ID} FROMHERE
                }
				/varset MobStartingDistance ${Target.Distance}
                /varset MoveTimer 10s
				/while (1) {
   					/doevents GotHit
                    /if (${Target.LineOfSight}) /break
					/if (${Target.Moving}) /break
					/call AmIStuck ${Me.X} ${Me.Y} 5
					/if (${Macro.Return.Equal[1]}) {
                        | We need a function similar to Stuck that "jiggles". Stuck is too pronounced.
                        /break
                    }
					/delay 5
				}
				/if (${Navigation.Active}) /squelch /nav stop
                | If we are super close, lets shift a bit to not get roflstomped
                /if (${Target.Distance}<=20) /stick ${StickHow}
			}
		}
		
		DEBUGCOMBAT Can I move if I am out of range? ${MoveIfOOR}
		/if ((${WhichMove.Equal[oor]} || ${WhichMove.Equal[both]}) && ${MoveIfOOR}) {
			/if (${Navigation.PathLength[id ${Target.ID}]}>${MeleeDistance} && ${Spawn[id ${Target.ID}].ID} && ${Spawn[id ${Target.ID}].Type.NotEqual[corpse]}) {
				DEBUGCOMBAT OOR - Moving closer.
				/echo ${Target.CleanName} (${Target.ID}) is out of range. Moving closer.
				/squelch /nav target | distance=50
                /if (!${Navigation.Active}) {
                    | We aren't moving! Trying something difference.
                    /call NavToWhoWhatByLoc ${Target.ID} 1 FROMHERE
                }
                /varset MoveTimer 10s
				/while (1) {
					/doevents GotHit
					/if (${Target.Distance}<=${MeleeDistance}) /break
					/call AmIStuck ${Me.X} ${Me.Y} 5
					/if (${Macro.Return.Equal[1]}) /break
                    /if (!${MoveTimer}) /break
				}
				/if (${Navigation.Active}) /squelch /nav stop
                | If we are super close, lets shift a bit to not get roflstomped
                /if (${Target.Distance}<=10) /stick ${StickHow}
			}
		}
		
		POPCALL
        DEBUGCOMBAT Leave
	/return

|--------------------------------------------------------------------------------------------------
| SUB: JiggleLOS
| We can make this so it looks for a better pull path, chooses that spot, then pulls camp over.
| -------------------------------------------------------------------------------------------------
    Sub JiggleLOS(int WhoWhatID, string FromHere)
        /if (!${WhoWhatID} && !${Target.ID}) /return
        /if (${IAmDead}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        DEBUGCOMBAT Enter from ${FromHere}
        DEBUGPULL Enter from ${FromHere}

        /if (${WhoWhatID}) /call TargetThis ${WhoWhatID}
        /if (!${Target.ID}) /return

        /if (!${Target.LineOfSight}) {
            /echo I can't see ${Target.CleanName} (${Target.ID}). Trying to find it.
            /face
            /delay 1s
        } else {
            /return
        }

        /declare StrafeDir          string  local
        /declare StrafeDirNext      string  local
        /declare MoveTimerOn        timer   local   0
        /declare DX                 int     local   0
        /declare DY                 int     local   0
        /declare DZ                 int     local   0
        /declare DNavPath           int     local   0
        /declare DMoveChoice[50,2]  string  local   NULL
        /declare DCounter           int     local   1
        /declare i                  int     local   0
        /declare DShortest          int     local   1

        /varset DMoveChoice[1,1] ${Me.Y} ${Me.X} ${Me.Z}
        /varset DMoveChoice[1,2] ${Navigation.PathLength[id ${Target.ID}]}

        DEBUGCOMBAT Recorded start ${DCounter} position ${DMoveChoice[1,1]} with pathlength ${DMoveChoice[1,2]}

        /if (${Math.Rand[2]}) {
            /varset StrafeDir STRAFE_LEFT
            /varset StrafeDirNext STRAFE_RIGHT
        } else {
            /varset StrafeDir STRAFE_RIGHT
            /varset StrafeDirNext STRAFE_LEFT
        }

        DEBUGCOMBAT Moving ${StrafeDir} first, then ${StrafeDirNext}

        /varset MoveTimerOn 20
        /while (${MoveTimerOn}) {
            /keypress ${StrafeDir} hold
            /delay 3
            /keypress ${StrafeDir}
            /delay 1
            /if (${Target.LineOfSight}) /return
            /varcalc DCounter ${DCounter}+1
            /varset DMoveChoice[${DCounter},1] ${Me.Y} ${Me.X} ${Me.Z}
            /varset DMoveChoice[${DCounter},2] ${Navigation.PathLength[id ${Target.ID}]}
            DEBUGCOMBAT Recorded ${DCounter} position ${DMoveChoice[${DCounter},1]} with pathlength ${DMoveChoice[${DCounter},2]}
            /if (${AggroTargetID}) /return
        }

        /varset MoveTimerOn 20
        /while (${MoveTimerOn}) {
            /keypress ${StrafeDirNext} hold
            /delay 3
            /keypress ${StrafeDirNext}
            /delay 1
            /if (${Target.LineOfSight}) /return
            /varcalc DCounter ${DCounter}+1
            /varset DMoveChoice[${DCounter},1] ${Me.Y} ${Me.X} ${Me.Z}
            /varset DMoveChoice[${DCounter},2] ${Navigation.PathLength[id ${Target.ID}]}
            DEBUGCOMBAT Recorded ${DCounter} position ${DMoveChoice[${DCounter},1]} with pathlength ${DMoveChoice[${DCounter},2]}
            /if (${AggroTargetID}) /return
        }

        DEBUGCOMBAT Recorded ${DCounter} positions.

        /for i 2 to ${DCounter}
            /if (${Float[${DMoveChoice[${i},2]}]}>1 && ${Float[${DMoveChoice[${i},2]}]}<${Float[${DMoveChoice[${DShortest},2]}]}) {
                DEBUGCOMBAT ${i} has a shorter pathlength than ${DShortest}
                /varset DShortest ${i}
            } else {
                DEBUGCOMBAT ${i} pathlength ${DMoveChoice[${i},2]} is not shorter than ${DShortest} ${DMoveChoice[${DShortest},2]}
            }
        /next i

        DEBUGCOMBAT Choosing ${DShortest} position ${DMoveChoice[${DShortest},1]} with pathlength ${DMoveChoice[${DShortest},2]}

        /nav locyxz ${DMoveChoice[${DShortest},1]}
        /while (${Me.Moving}) {
            /delay 2
        }
        /if (${Target.ID}) /face

        |/echo Couldn't find the ${Target.Name} (${Target.ID}). Will try something else.

    /return


| ---------------------------------------------------------------------------
| Sub:NavToWhoWhatByLoc
| Take's the id and uses its coordinates to move.
| ---------------------------------------------------------------------------
	Sub NavToWhoWhatByLoc(string WhoWhatID, int IgnoreAggro, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/declare DX				int		local		${Spawn[id ${WhoWhatID}].X}
		/declare DY				int		local		${Spawn[id ${WhoWhatID}].Y}
		/declare DZ				int		local		${Spawn[id ${WhoWhatID}].Z}

		/nav locyxz ${DY} ${DX} ${DZ} | distance=50

        |/delay 5
        |/while (1) {
		|    /if (!${Me.Moving}) {
        |        /if (${Spawn[id ${WhoWhatID}].Distance}<15) {
        |            | We have arrived.
        |            /stick ${StickHow}
        |        }
        |        /break
        |    }
        |    /if (!${IgnoreAggro}) {
        |        /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
        |            /if (${Navigation.Active}) /nav stop
        |            /break
        |        }
        |    }
        |}
        |/if (!${IgnoreAggro}) {
        |    /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
        |        /call DoWeMove 0 FROMHERE
        |    }
        |}

		POPCALL
	/return

| ---------------------------------------------------------------------------
| Sub:NavToWhoWhatSafer
| Take's the id and uses its coordinates to move.
| ---------------------------------------------------------------------------
	Sub NavToWhoWhatSafer(string WhoWhatID, int IgnoreAggro, int DDistance, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/declare DX				int		local		${Spawn[id ${WhoWhatID}].X}
		/declare DY				int		local		${Spawn[id ${WhoWhatID}].Y}
		/declare DZ				int		local		${Spawn[id ${WhoWhatID}].Z}
        /declare StuckTry       int     local       0
		/squelch /nav locyxz ${DY} ${DX} ${DZ} | distance=${DDistance}
		/varset PullNavDistance ${Navigation.PathLength[id ${WhoWhatID}]}
		
		| A nav path may not be available. We need to move until we get a bit closer for it to kick in, sometimes.
		/if (${PullNavDistance}<0.01) {
            /moveto dist 5

            |/call RadarAtLoc ${DX} ${DY} ${DZ} 50 FromHere)

            | We will move towards it.
            /face
            /delay 2
            /moveto loc ${DY} ${DX} ${DZ} mdist ${DDistance}
        }

        /call TargetThis ${WhoWhatID}
        /while (1) {
            /if (${Target.Distance}<${DDistance}) /break
            /if (${StuckTry}>2) /break
            /if (!${IgnoreAggro} && ${Spawn[id ${WhoWhatID}].LineOfSight}) {
                /call StopMoving
                /break
            }
            /if (!${IgnoreAggro} && ${Spawn[id ${WhoWhatID}].Distance}<75) {
                /call StopMoving
                /break
            }
            /if (!${IgnoreAggro}) {
                /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
                    /break
                }
            }
			/call AmIStuck ${Me.X} ${Me.Y} 5
			/if (${Macro.Return.Equal[1]}) {
                /varcalc StuckTry ${StuckTry}+1
                /call JiggleLOS ${WhoWhatID} FROMHERE
            }
            /if (!${Me.Moving}) /break
        }
        /if (!${IgnoreAggro}) {
            /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
                /call DoWeMove 0 FROMHERE
            }
        }
        /call StopMoving

        /moveto dist 10

		POPCALL
	/return


| -------------------------------------------------------------------------------------------------
| Sub DoWeAdvanceCamp
| -------------------------------------------------------------------------------------------------
    Sub DoWeAdvanceCamp(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGPULL Enter from ${FromWhere}

        /if (${Math.Distance[${CampYLoc},${CampXLoc}:${Me.Y},${Me.X}]}>${PullCampDistFromCamp}) {
            /if (${Navigation.Active}) /squelch /nav stop
            /call PetBackOff FROMHERE
            /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
                POPCALL
                /return 0
            }
            /call MobRadar los 100 FROMHERE
            /if (${MobCount}) {
                POPCALL
                /return 0
            }
            /echo Moving group up since the pull will be long.
            /call AdvancePullCamp FROMHERE
        }

        POPCALL
    /return 1

| ---------------------------------------------------------------------------
| Sub ShouldIStand
| Assist may not have been called yet. If mobs are coming, we need to get up
| so we don't get clobbered.
| ---------------------------------------------------------------------------
	Sub ShouldIStand

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		/if (${Me.Sitting} && !${Me.Mount.ID}) {
			/call OnXTarget
			/if (${Int[${Macro.Return}]}>0) {
				/if (!${MedCombat} && ${Medding}) {
					/stand
					/return 1
				}
			}
		}
	
	/return 0

|--------------------------------------------------------------------------------------
| SUB: Stop Moving
|--------------------------------------------------------------------------------------
    Sub StopMoving
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGMOVE StopMoving: Enter
        /if (${MoveTo.Moving}) /moveto off
        /if (${Stick.Active}) /stick off
        /if (${PullMoveUse.Equal[nav]}) {
            /if (${Navigation.Active}) /squelch /nav stop
        } else /if (${PullMoveUse.Equal[advpath]}) {
            /if (${AdvPath.State}) /play off
        }
        /delay 30 !${Me.Moving}
		POPCALL
        DEBUGMOVE StopMoving: Leave
    /return
|-------------------------------------------------------------------------------------
| SUB: Stuck
| -------------------------------------------------------------------------------------
    Sub Stuck(string FromHere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        DEBUGCOMBAT Enter from ${FromHere}
        DEBUGPULL Enter from ${FromHere}

        /declare strafedir string local
        | - We're stuck, back off a second, move left or right (randomly) for 1 second
        /if (${IAmDead}) /return
        /keypress back hold
        /delay 10
        /keypress back
        /if (${Math.Rand[2]}) {
            /varset strafedir STRAFE_LEFT
        } else {
            /varset strafedir STRAFE_RIGHT
        }
        /keypress ${strafedir} hold
        /delay 10
        /keypress ${strafedir}
    /return

| ----------------------------------------------------------------------------
| SUB: ZCheck /call ZAxisCheck current ,Z to check, difference
| ----------------------------------------------------------------------------
    Sub ZAxisCheck(float Zcur, float Zdiff)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        | Move down if Z distance more than Zcheck due to levitation
        DEBUGN ZCheck ZCur: ${Zcur} ZDiff: ${Zdiff} Enter.
        /if (${Zcur}>=${Zdiff}) {
            /keypress CMD_MOVE_DOWN hold
            /delay 10 ${Math.Distance[${CampZLoc}:${Me.Z}]}<=${Zdiff}
            /keypress CMD_MOVE_DOWN
        }
        DEBUGN ZCheck ZCur: ${Zcur} ZDiff: ${Zdiff} leave.
    /return
