
| -------------------------------------------------------------------------------------------------
| To Do: A routine that equips pet gear from inventory, expand bags then give items.
| -------------------------------------------------------------------------------------------------

| -------------------------------------------------------------------------------------------------
| SUB: Bind_RequestToys - Request pet toys from a listening mage
|
| Mage needs to enable ProvidePetToys in the ini.
| -------------------------------------------------------------------------------------------------
	Sub Bind_RequestToys(FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGPET RequestToys: ENTER from ${FromWhere}
		/if (${FromWhere.Equal[NULL]} || !${FromWhere.Length}) {
			/varset RequestPetToys 1
			/varset PetToysGiveup 0
		}
		/if (${RequestPetToys}) {
			/call IsPetEquipped ${Pet.ID} FROMHERE
			/if (${Macro.Return.Equal[PET_NOT_EQUIPPED]}) {
				/call Broadcast y "PetToysPlease ${Pet.CleanName}"
				/call Bind_PleaseWait "Requested Pet Toys" 90s
			}
		}
		POPCALL
		DEBUGPET RequestToys: LEAVE
	/return

| -------------------------------------------------------------------------------------------------
| SUB: BreakMez - Written by Trehuggindruid for KissAssist
| -------------------------------------------------------------------------------------------------
    Sub BreakMez(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGPETCOMBAT BreakMez: Enter from ${FromWhere}
        /if (${PetBreakMezSpell.Equal[null]} || !${PetBreakMezSpell.Length}) {
			DEBUGPETCOMBAT BreakMez: PetBreakMezSpell not provided
			POPCALL
			/return
		}

		| Don't break mez if the group is dead. Right?
		/call IsGroupReady FROMHERE
		/if (${Macro.Return.Equal[0]}) {
			/echo awAKA: \ayThe group doesn't appear ready to break mez... corpses, mana, linkdead... that sort of thing. If you want to do it anyway, hit it with something.
			/delay 5
			POPCALL
			/return
		}

        /declare PetBreakMezTargetID int local ${Target.ID}
		/declare BreakMezTimer timer local 18s
		
        /echo \awAKA: \ayATTEMPTING TO BREAK MEZ ON: (${Target.CleanName}) ID:(${PetBreakMezTargetID})
        DEBUGPETCOMBAT BreakMez: Break Mez with: - ${PetBreakMezSpell}
        /while (${Target.Mezzed.ID} && ${BreakMezTimer}) {
            /call CastWhat "${PetBreakMezSpell}" ${PetBreakMezTargetID} BreakMez 0 0 FROMHERE
			/if (${Macro.Return.Equal[CAST_SUCCESS]}) /break			
			/if (${Macro.Return.Equal[CAST_RECOVER]}) {
				/delay 3s
			} else /if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
				/echo Need a little more mana before I can break mez. Waiting a tick.
				/delay 6s
			} else {
				/echo BreakMez Cast not successful for PetBreakMezSpell ${PetBreakMezSpell}: ${Macro.Return}
				/break
			}
        }
		/if (!${Target.Mezzed.ID}) {
			DEBUGPETCOMBAT BreakMez: We broke mez. Attacking.
			/varset PetAttack 0
			/echo + Mez broken !
			/call PetEngageTarget ${PetBreakMezTargetID} 0 FROMHERE
		} else {
			DEBUGPETCOMBAT BreakMez: We failed to break mez
			/echo Mob still mezzed!
		}
		POPCALL
        DEBUGPETCOMBAT BreakMez: Leave
    /return
	
|-----------------------------------------------------------------------------
| SUB: Check Begged for Pet buffs
| ----------------------------------------------------------------------------
    Sub CheckBegforPetBuffs(string FromWhere)
		/if (!${PetToysOn}) /return
        /if (${Me.Invis}) /return
   
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare WNWAll    string local
        /declare WNWPart1  string local
        /declare WNWPart1t string local
        /declare WNWx      int    local 1
        /declare WNWy      int    local
        /declare WhatBeenCast string local

        /declare PTPPetID int local
        /declare GMemID int local
        /declare GMemShortName string local
        /declare GMemPetName string local
        /declare i int local 0
        DEBUGPET CheckBegForPetBuffs: Enter GiveToys from ${FromWhere}
        | If group command give all pets in group toys
        /echo CheckBegforPetBuffs: ${KABegForPetList} ${WNWx}
        /if (!${KABegForPetList.Length}) {
			POPCALL
			/return
		}
        /while (1) {
            /varset WNWAll ${KABegForPetList.Arg[${WNWx},|]}
            /if (!${WNWAll.Length} || ${WNWAll.Equal[null]}) {
                /if (!${KABegForPetList.Length} || ${KABegForPetList.Equal[null]}) /varset KAPetBegActive 0
                /break
            }
            /varset WNWPart1 ${WNWAll}
            /if (${WNWPart1.Equal[group]}) {
                /echo I am giving pet toys to every Pet in Group except mine.
                | Start at 1 my pet doesn't need toys
                /for i 1 to 5
                    /varset GMemID ${Group.Member[${i}].ID}
                    /varset PTPPetID ${Group.Member[${i}].Pet.ID}
                    /varset GMemShortName ${Group.Member[${i}].Class.ShortName}
                    /varset GMemPetName ${Group.Member[${i}].Pet.Name}
                    DEBUGPET CheckBegForPetBuffs: ${GMemID} && ${PTPPetID} && ${Select[${GMemShortName},PET_CLASSES_SHORTNAME]} && ${Spawn[=${GMemPetName}].Type.Equal[Pet]}
                    /if (${GMemID} && ${PTPPetID} && ${Select[${GMemShortName},PET_CLASSES_SHORTNAME]} && ${Spawn[=${GMemPetName}].Type.Equal[Pet]}) {
                        /if (${Me.Invis}) /break
                        /call pettoys ${GMemPetName}
                    }
                /next i
            } else {
                | Individual Pet.
                /if (${Me.Invis}) /break
                /echo Giving pet toys to (${WNWPart1}).
                /call pettoys ${WNWPart1} FROMHERE
            }

            /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                /if (${KABegForPetList.Find[${WNWAll}|]}) {
                    /varset KABegForPetList ${KABegForPetList.Replace[${WNWAll}|,]}
                    /if (${KABegForPetList.Find[${WNWPart1}]}) {
                        /varset WNWy ${WNWx}
                        /while (1) {
                            /varset WNWAll ${KABegForPetList.Arg[${WNWy},|]}
                            /if (!${WNWAll.Length} || ${WNWAll.Equal[null]}) {
                                /break
                            } else {
                                /varset WNWPart1t ${WNWAll}
                                /if (${WNWPart1t.Equal[${WNWPart1}]}) {
                                    /if (${KABegForPetList.Find[${WNWAll}|]}) {
                                        /varset KABegForPetList ${KABegForPetList.Replace[${WNWAll}|,]}
                                    } else /if (${KABegForPetList.Find[${WNWAll}]}) {
                                        /varset KABegForPetList ${KABegForPetList.Replace[${WNWAll},]}
                                    } else {
                                        /varcalc WNWy ${WNWy}+1
                                    }
                                } else {
                                    /varcalc WNWy ${WNWy}+1
                                }
                            }
                        }
                    }
                } else /if (${KABegForPetList.Find[${WNWAll}]}) {
                    /varset KABegForPetList ${KABegForPetList.Replace[${WNWAll},]}
                }
            } else /if (${Macro.Return.Equal[CAST_CANCELLED]}) {
                /break
            } else {
                /varcalc WNWx ${WNWx}+1
            }
        }
		POPCALL
    /return
	
| -------------------------------------------------------------------------------------
| SUB: CheckPetBuffs
| -------------------------------------------------------------------------------------
    Sub CheckPetBuffs(string FromWhere)
        /if (!${PetOn} || !${Pet.ID}) /return
        /if (${CombatStart} || ${Pulling}) /return
        /if (${Me.Invis} || ${Me.Moving}) /return
		/if (${Me.PctMana}<20 && (${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID})) /return

		/call LastMove FROMHERE
		/if (${TimeSinceMove}<10) /return

        /varset CheckPetBuffsTimerOn ${CheckPetBuffsTimer}s		

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPET CheckPetBuffs Enter from ${FromWhere}
        /declare PTempBuff string local
        /declare PTempSpell string local
        /declare i int local
        /declare j int local
        /declare 1stPart string local 0
        /declare 2ndPart string local 0
        /declare 3rdPart string local 0
        /declare FoundPetBuff int local 0
        /declare CondNo int local 0
				
        /for i 1 to ${PetBuffs.Size}
			/call CheckBeforeCast CheckPetBuffs FROMHERE
            | Stop pet buffing if aggro detected
			/if (${Me.Moving}) {
				POPCALL
				/return
			}
            /if (${CalledTargetID} && !${AggroTargetID}) /call CombatTargetCheck 0 FROMHERE
            /if (${AggroTargetID} && ${Spawn[id ${AggroTargetID}].Distance}<200) {
				POPCALL
				/return
			}
			|
			| Sometimes your pet gets dismissed or suspended at the most inopportune times.
			|
			/if (!${Pet.ID}) {
				POPCALL
				/return
			}
            /if (${PetBuffs[${i}].Equal[Null]}) /continue
            /varset 1stPart ${PetBuffs[${i}].Arg[1,|]}
            /varset 2ndPart ${PetBuffs[${i}].Arg[2,|]}
            /varset 3rdPart ${PetBuffs[${i}].Arg[3,|]}

            /if (${2ndPart.NotEqual[dual]}) /varset 3rdPart ${1stPart}

            /if (${ConOn} && ${PetBuffs[${i}].Find[|cond]}) {
                /varset CondNo ${PetBuffs[${i}].Mid[${Math.Calc[${PetBuffs[${i}].Find[|cond]}+5]},3]}
            } else {
                /varset CondNo 0
            }

            /if (${Pet.Buff[${1stPart}]} && ${2ndPart.Equal[Remove]}) {
                /if (!${CondNo} || ${If[${Cond[${CondNo}]},1,0]}) {
                    /echo Removing Pet Buff: ${1stPart}
                    /removebuff pet "${1stPart}"
                }
				/continue
			}
            
            | Check for pet spells in book to prevent double casting of items
            /if (${Me.Book[${1stPart}]} || ${Me.AltAbility[${1stPart}]}) {
                /if (${1stPart.Find[ Rk.]}) {
                    /varset PTempSpell ${1stPart.Left[${Math.Calc[${1stPart.Find[ Rk.]}-1]}]}
                } else {
                    /varset PTempSpell ${1stPart}
                }
                /if (${3rdPart.Find[ Rk.]}) {
                    /varset PTempBuff ${3rdPart.Left[${Math.Calc[${3rdPart.Find[ Rk.]}-1]}]}
                } else {
                    /varset PTempBuff ${3rdPart}
                }
                DEBUGPET CheckPetBuffs ${i} ${Me.PetBuff[${PTempBuff}]} ${PetBuffs[${i}]} ${PTempBuff}
                /for j 1 to 50
                    /if (${Me.PetBuff[${j}].Name.Find[${PTempBuff}]}) {
                        /varset FoundPetBuff 1
                        /break
                    }
                /next j
                /if (!${FoundPetBuff}) {
					/if (!${Pet.ID}) {
						POPCALL
						/return
					}
                    | Verbose
                    /call CastWhat "${1stPart}" ${Pet.ID} Pet-nomem ${CondNo} 0 FROMHERE
                    /delay 20
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
						/if (${Pet.ID}) {
							/echo Buffing ${Pet.CleanName}, my pet, with ${1stPart}
						}
                        |/varset FoundPetBuff 0
                    } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                        /echo You are missing components. Turning off ${1stPart}.
                        /varset PetBuffs[${i}] Null
                        
                    }
                    /continue
                }
            } else /if (${FindItem[=${1stPart}].ID}) {
                /varset PTempSpell ${1stPart}
                /varset PTempBuff ${3rdPart}
                DEBUGPET CheckPetBuffs ${FindItem[=${1stPart}].Spell} ${Me.PetBuff[${FindItem[=${1stPart}].Spell}]} ${Me.PetBuff[${3rdPart}]}
                /if (${Me.PetBuff[${FindItem[=${PTempSpell}].Spell}]}>0) /continue
                /if (${Me.PetBuff[${PTempBuff}]}>0) /continue
                DEBUGPET CheckPetBuffs - Dual - ${1stPart} - ${3rdPart}
                /for j 1 to 50
                    /if (${Me.PetBuff[${j}].Name.Find[${PTempBuff}]}) {
                        /varset FoundPetBuff 1
                        /break
                    }
                /next j
                /if (!${FoundPetBuff}) {
					/if (!${Pet.ID}) {
						POPCALL
						/return
					}
                    |Verbose
                    /call CastWhat "${1stPart}" ${Pet.ID} Pet ${CondNo} 0 FROMHERE
                    /delay 20
                    /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
						/if (${Pet.ID}) {
							/echo Buffing ${Pet.CleanName}, my pet, with (${3rdPart})
						}
                    } else /if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
                        /echo You are missing components. Turning off ${1stPart}.
                        /varset PetBuffs[${i}] Null
                    }
                    |/varset FoundPetBuff 0
                    /continue
                }
            } else /if (${1stPart.Equal[pettoys]} && ${2ndPart.Equal[begfor]}) {
                DEBUGPET CheckPetBuffs begfor toys
                /if (${CondNo} && ${If[${Cond[${CondNo}]},0,1]}) /continue 
                /if (${Defined[PetBuff${i}]}) {
                    /if (${PetBuff${i}}) /continue
                }
				|
				| Works well.
				|
				/if (!${Pet.ID}) {
					POPCALL
					/return
				}
                /call Bind_RequestToys CheckPetBuffs-BegForToys
                /if (!${Defined[PetBuff${i}]}) {
                    /declare PetBuff${i} timer outer 900
                } else {
                    /varset PetBuff${i} 900
                }
            }
            /varset FoundPetBuff 0
        /next i
		|
		| Ench pet seems to have problems? The default pet shrinks to 1.44. Illusions can be higher than 1.35 too. Ench keeps recasting shrink. Cast twice, record the height in a var, and compare each pass.
		|
        DEBUGPET CheckPetBuffs Pet Height: ${Pet.Height}
        |/if (${Pet.Height}!=>1.35 && ${PetShrinkOn}) {
		/if (!${Pet.ID}) {
			POPCALL
			/return
		}
		/if (${Math.Abs[${Math.Calc[${Pet.Height}-${PetShrunkSize}]}]}>0.02 && ${PetShrinkOn}) {
            /call CastWhat "${PetShrinkSpell}" ${Pet.ID} Pet 0 0 FROMHERE
            /delay 20
            /call CastWhat "${PetShrinkSpell}" ${Pet.ID} Pet 0 0 FROMHERE
            /delay 10
			/vardata PetShrunkSize Me.Pet.Height
			|
			| Save this so you don't try to reshrink pet if you stop and start KA, which looks bad and wastes time
			|
			/ini "${IniFileName}" "Pet" "PetShrunkSize" "${PetShrunkSize}"
        }
        /if (${Target.ID}==${Pet.ID}) /call TargetThis
		POPCALL
        DEBUGPET CheckPetBuffs Leave
    /return

| -------------------------------------------------------------------------------------------------
| SUB: CheckPetState
| -------------------------------------------------------------------------------------------------
    Sub CheckPetState(string FromWhere)
		/if (!${PetOn}) /return
		| Are we waiting for toys?
		/if (${PetToysTimer}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGPET CheckPetState: ENTER from ${FromWhere}
		|
		| Enhancing so it works as intended, I think. Sets the appropriate state vars
		| So it's not mangled elsewhere. No more number manipulation elsewhere.
		|
		/declare InitialPetID	int		local	${Pet.ID}
		|
		| When we make a new pet, give it time for buffs and gear before we put it away when making 2.
		|
		/declare SuspendNewPetsTM	string	local	180s
		
		|
		| Account for pet before I bail out if petsuspend off.
		| I do it this way because I don't want to make it confusing with varcalcs all over.
		|
		/if (!${PetSuspend}) {
			/if (${Pet.ID}) {
				DEBUGPET CheckPetState: I have 1 active pet, and I don't know about suspended because PetSuspend is disabled.
				/varset PetTotCount 	1
				/varset PetActiveState 	1
			} else /if (!${Pet.ID}) {
				DEBUGPET CheckPetState: I don't have a pet, and I don't know about suspended because PetSuspend is disabled. Making a new one.
				|
				| Make a pet.
				|
				/call PetSummon FROMHERE
				/if (${Pet.ID}) {				
					DEBUGPET CheckPetState: We have a new pet
					/varset PetTotCount 	1
					/varset PetActiveState 	1
				} else {
					DEBUGPET CheckPetState: We failed to make a new pet
					/varset PetTotCount 	0
					/varset PetActiveState 	0
				}
				/if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
					DEBUGPET CheckPetState: Out of pet summoning reagents.
					/echo Out of scooby snacks. Buy some and /togglevariable PetOn or restart.
					/varset PetOn 0
				}
				/if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
					|/echo Not enough mana to summon pet.
					POPCALL
					/return CAST_OUTOFMANA
				}
			}
			/varset PetSuspendState		0			
			/varset MyPetName 			${Pet.CleanName}
			DEBUGPET CheckPetState Exit due to already having a pet and pet suspend disabled.
			POPCALL
			/return
		}
		|
		| We are now going to deal with suspended pets.
		|
		| If we already have a pet, when we perform suspend we will get back a different pet
		| if there was one in suspension. Otherwise, we get back NULL... and no pet!
		| If we didn't get a pet, make one.
		|
		| If we come here from a battle situation, the pet has died. This routine will attempt to unsuspend a pet.
		| If there was no pet in suspension, we will make a new one.
		|
		| If we don't have a pet, set timer to 0.
		|
		| This should trigger if a pet dies in combat. Otherwise it falls through and makes a new one.
		| If PetTotCount==2 then we did not die, but a pet did.
		/if (!${Pet.ID}) {
			/call PetSuspend FROMHERE
			/delay 5
			/if (${Pet.ID}) {
				/varset PetTotCount 1
				/varset PetActiveState 1
				/varset PetSuspendState 0
				POPCALL
				/return 
			} else {
				/varset PetTotCount 0
				/varset PetActiveState 0
				/varset PetSuspendState 0
				/varset PetSummonSuspendTM 0
			}
		}

		| If we get here we 1) May have a pet, 2) May have 2 pets, or 3) not have any pets. We need to figure it out.

		|
		| If the timer is 0, it's ok to do a suspend
		|
		/if (!${PetSummonSuspendTM} && ${Pet.ID}) {
			| InitialPetID is set because we came in with a pet. We know we have at least 1.
			/if (!${PetSuspendState} && !${PetActiveState}) {
				/echo Checking if I have a suspended pet.
			}
			/call PetSuspend FROMHERE
			DEBUGPET CheckPetState: Return from PetSuspend ${Macro.Return}
			/delay 5
		}

		/if (!${Pet.ID}) {
			/call PetSummon FROMHERE
			/if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
				DEBUGPET CheckPetState: Out of pet summoning reagents.
				/echo Out of scooby snacks. Buy some and /togglevariable PetOn or restart.
				/varset PetOn 0
			}
			/if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
				|/echo Not enough mana to summon pet.
				POPCALL
				/return CAST_OUTOFMANA
			}
		}
		/if (${InitialPetID} && ${Pet.ID} && ${InitialPetID}!=${Pet.ID}) {
			DEBUGPET CheckPetState: I began with a pet, and have a pet now, and It's a different pet
			/varset PetTotCount 2
			/varset PetActiveState 1
			/varset PetSuspendState 1
		} else /if (${Pet.ID} && !${InitialPetID}) {
			DEBUGPET CheckPetState: I have a pet now, and I didn't have one to begin with. I want to wait some time before putting it away and making another to give it time for gear since I'm requesting toys.
			/varset PetTotCount 1
			/varset PetActiveState 1
			/varset PetSuspendState 0
			|
			| If we we are fighting, we need to get back to it now.
			|
			/if (${Me.CombatState.Equal[COMBAT]} || ${AggroTargetID}) {
				POPCALL
				/return
			}
			|
			| Set timer until we suspend the new pet to make a 2nd if we request toys.
			|
			/if (${RequestPetToys}) {
				/varset PetSummonSuspendTM ${SuspendNewPetsTM}
			}
		} else /if (${InitialPetID} && !${Pet.ID}) {
			DEBUGPET CheckPetState: The pet I had was suspended, but couldn't make another. Unsuspending the one we have.
			/call PetSuspend FROMHERE
			/if (${Pet.ID}) {
				/varset PetTotCount 1
				/varset PetActiveState 0
				/varset PetSuspendState 1
			} else {
				/varset PetTotCount 0
				/varset PetActiveState 0
				/varset PetSuspendState 0
			}
		} else /if (!${InitialPetID} && !${Pet.ID}) {
			DEBUGPET CheckPetState: I didn't have a pet and I still don't have a pet. This indicates an error of some kind, but we will try again unless disabled.
			/varset PetTotCount 0
			/varset PetActiveState 0
			/varset PetSuspendState 0
		} else /if (${InitialPetID} && ${Pet.ID} && (${InitialPetID}==${Pet.ID})) {
			DEBUGPET CheckPetState: It's the same pet. Skipped suspend until timer expires. This will spam, so no echo.
		} else {
			DEBUGPET CheckPetState: Some condition I didn't think of....
		}
		POPCALL
		DEBUGPET CheckPetState: EXIT
    /return
	
|--------------------------------------------------------------------------------
|SUB: CheckRampPets - Writtten by Trehuggindruid for KissAssist
|--------------------------------------------------------------------------------
    Sub CheckRampPets(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		DEBUGCOMBAT Enter from ${FromWhere}

        /declare i int local
        /declare DoLoop int local 1
        /if (!${Me.CombatState.Equal[COMBAT]}) {
            | Wait for rampage pets to poof before pulling.
            /for i 0 to 20
                /if (${Spawn[${Me.CleanName}`s_pet0${i}].ID}) /echo +++ My rampage pet is up: (${Spawn[${Me.CleanName}`s_pet0${i}]}|${Spawn[${Me.CleanName}`s_pet0${i}].ID}), HOLDING . . .
                /while (${DoLoop}) {
					/doevents GotHit
                    /delay 1
                    /if (!${Me.CombatState.Equal[COMBAT]} && ${Spawn[${Me.CleanName}`s_pet0${i}].ID}) /continue
                    /varset DoLoop 0
                }
            /next i
        }
		POPCALL
    /return
	
| -------------------------------------------------------------------------------------
| SUB: CombatPet
| -------------------------------------------------------------------------------------
    Sub CombatPet(string FromWhere)
		/if (!${PetOn} || !${Pet.ID}) /return
        /if (${PetAttack} || ${DPSPaused} || ${Pet.Combat}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT CombatPet: Enter from ${FromWhere} - use /debug petcombat to go further
		DEBUGPETCOMBAT CombatPet: Enter from ${FromWhere}
		/call CombatTargetCheck 1 FROMHERE
        /if (${Select[${Role},pettank,pullerpettank,hunterpettank]}) {
			DEBUGPETCOMBAT CombatPet: We are a pettank, pullerpettank, or hunterpettank
			/if (!${Target.Mezzed.ID}) {
				DEBUGPETCOMBAT CombatPet: Target is not mezzed and pet is not fighting.
				/if (${Select[${Role},pettank,pullerpettank]}) {
					DEBUGPETCOMBAT CombatPet: 2
					| Sometimes you need your pet to guard, so allow for that and a margin around camp / personal radius.
					/if ((${Pet.Stance.NotEqual[FOLLOW]}) && (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}>${Math.Calc[${CampRadius}*2]}) || (${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}>${Math.Calc[${CampRadius}*2]})) /pet follow
				}
				DEBUGPETCOMBAT CombatPet: Engaging target ${Target.CleanName} (${Target.ID})
				/if ((${Select[${Role},PULLER_ROLES]} || ${PullManual}) && ${PullWith.Equal[Pet]} && ${Pulling}) {
					DEBUGPETCOMBAT Pulling it
					/call PetEngageTarget ${MyTargetID} 1 FROMHERE
					/if (${Macro.Return.Equal[0]}) {
						/if (${Math.Rand[2]}) {
							/call GetCloser los FROMHERE
						} else {
							/call JiggleLOS ${MyTargetID} FROMHERE
						}
					}
				} else {
					DEBUGPETCOMBAT Attacking it
					/call PetEngageTarget ${MyTargetID} 0 FROMHERE
					/if (${Macro.Return.Equal[0]}) {
						/if (${Math.Rand[2]}) {
							/call GetCloser los FROMHERE
						} else {
							/call JiggleLOS ${MyTargetID} FROMHERE
						}
					}
				}
			} else {
				| Let's double check...
				/call GetCombatTarget FROMHERE
				DEBUGPETCOMBAT CombatPet: My target is ${Target.CleanName} (${Target.ID}) It's mez id is ${Target.Mezzed.ID}
				/if (${Target.Mezzed.ID} && ${Select[${Role},pettank,pullerpettank]} && ${PetBreakMezSpell.NotEqual[null]}) {
					DEBUGPETCOMBAT CombatPet: Need to break mez
					/call BreakMez FROMHERE
				}
			}
		} else {
			DEBUGPETCOMBAT CombatPet: We are a petofftank or some other kind of pet wrangler. Attacking
			/call PetEngageTarget ${MyTargetID} 0 FROMHERE
			/if (${Macro.Return.Equal[0]}) {
				/if (${Math.Rand[2]}) {
					/call GetCloser los FROMHERE
				} else {
					/call JiggleLOS ${MyTargetID} FROMHERE
				}
			}
		}
		POPCALL
        DEBUGPETCOMBAT CombatPet: Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: DoPetHealStuff
| -------------------------------------------------------------------------------------
    Sub DoPetHealStuff(string FromWhere)
		/if (!${Select[${Me.Class.ShortName},PET_CLASSES_SHORTNAME]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGHEALS Enter from ${FromWhere}. Use debug with PET to go further.
		DEBUGPET Enter from ${FromWhere}
		
		/if (!${Pet.ID} && (${Me.CombatState.Equal[COMBAT]} || ${AggroTargetID}) && ${BattleSummonPet}) {
			DEBUGPET Pet dead - Battle summoning
			/echo Ack! My pet is dead...going to get another.
			/call CheckPetState FROMHERE
			/if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
				/varset PetHealTimerOn 10s
				POPCALL
				/return CAST_OUTOFMANA
			}
			POPCALL
			/return
		}

		| Leave this here. If the pet is dead, and we aren't battlesummoning, then we leave and make a new pet in dopetstuff
		/if (!${Pet.ID}) {
			POPCALL
			/return
		}

		| We allow battlesummon to work, but if heals are off, bye.
		/if (!${HealsOn}) {
			POPCALL
			/return
		}

		/varset PetHealTimerOn ${PetHealInterval}s

        | Check if my pet needs healing
        /declare j int local
		
		/if (!${SingleHealPointPet}) {
			| This is needed in CastInterruptDPS
			/varset SingleHealPointPet 100
			/for j 1 to ${SingleHeal.Size}
				/if (${SingleHeal[${j}].Arg[3,|].NotEqual[pet]} || !${SingleHeal[${j}].Length} || ${SingleHeal[${j}].Arg[2,|]}==0) /continue
				/if (${SingleHealPointPet}>${SingleHeal[${j}].Arg[2,|]}) /varset SingleHealPointPet ${SingleHeal[${j}].Arg[2,|]}
			/next j
			/if (${SingleHealPointPet}==100) /varset SingleHealPointPet 40
		}
        /for j 1 to ${SingleHeal.Size}
			/doevents GotHit
			/call LastMove
			|
			| Arg1 = the heal spell, Arg2 health pct, Arg3 "pet"
			|
            /if (${SingleHeal[${j}].Arg[3,|].NotEqual[pet]} || !${SingleHeal[${j}].Length} || ${SingleHeal[${j}].Arg[2,|]}==0) /continue
			
            /if (${Pet.PctHPs}<=${SingleHeal[${j}].Arg[2,|]} && ${Pet.ID} && ${Pet.Distance}<${Spell[${SingleHeal[${j}].Arg[1,|]}].Range}) {
                DEBUGPET DoPetHealStuff: (${Pet.PctHPs}<=${SingleHeal[${j}].Arg[2,|]} && ${Pet.ID} && ${Pet.Distance}<${Spell[${SingleHeal[${j}].Arg[1,|]}].Range})
                /call CastWhat "${SingleHeal[${j}].Arg[1,|]}" ${Pet.ID} Heal 0 0 FROMHERE
                /if (${Macro.Return.Equal[CAST_SUCCESS]}) {
                    /call BroadCast o "${SingleHeal[${j}].Arg[1,|]} on  >> ${Pet.CleanName} <<"
                    /varcalc PetHealTimer${j} ${Spell[${SingleHeal[${j}].Arg[1,|]}].MyDuration.TotalSeconds}*10
                    /varset HealAgain    1
                }
            }
        /next j
		POPCALL
        DEBUGPET DoPetHealStuff: Leave
    /return

| -------------------------------------------------------------------------------------------------
| SUB: DoPetStuff
| -------------------------------------------------------------------------------------------------
    Sub DoPetStuff(string FromWhere)
        /if (!${PetOn} || ${CampZone}!=${Zone.ID}) /return
        /if (${AggroTargetID} || ${Me.Invis} || ${Me.Hovering}) /return
		/if (!${Me.Combat} && ${Me.PctMana}<20 && (${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID})) /return
		
		/call LastMove
		/if (${TimeSinceMove}<10) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN DoPetStuff: Enter from ${FromWhere} - Use /debug pet on to continue
        DEBUGPET DoPetStuff: Enter from ${FromWhere}
		
		|
		| Were pet toys interrupted? Clean up.
		|
		/if (${PetToysResumeStep}) {
			| Remove summoned stuff from cursor and summoned bag.
			/call CheckCursor PetToys 1
			/echo You may need to check inventory for lore summoned items and delete them if there are problems summoning toys. /varset PetToysOn 1
			/varset BagNum ${PetToysResumeBagNum}
			/if (${Me.Inventory[pack${BagNum}].Name.Find[Phantom Satchel]} || ${Me.Inventory[pack${BagNum}].Name.Find[Pouch of Quellious]}) /call DestroyBag
			/varset PetToysResumeStep 0
			/varset PetToysResumeBagNum 0
		}

        /if (${Pet.CleanName.Equal[${Me.Name}`s familiar]}) /pet get lost

		/if (${Pet.ID}) {
			/call SetupPet FROMHERE
			/if (${PetBuffsOn} && !${CheckPetBuffsTimerOn}) {
				/call CheckPetBuffs FROMHERE
			}
		}

		| Will make a pet if: Petsuspend disabled and pet dead, or, Petsuspend enabled and the pet is dead and nothing suspended
		| If petsuspend enabled and we have a pet then it will be suspended and a new one will be made after some interval.
		|
		| Also, its possible that both pets were destroyed in battle, and a new one was made during battle. Then when we come
		| into this routine with a pet, it doesn't know that there is only 1 pet.

		| If I have a pet, and it has toys, then we can suspend to check the other. If I don't have a pet, then we need to make one and give it toys, OR we can unsuspend one and give it toys and buffs, then do next one...or...

		/if (${PetSuspend}) {
			/if (${Select[${Me.Class.ShortName},DRU]}) {
				/varset PetSuspend 0
				POPCALL
				/return
			}
		
			/if (!${Pet.ID}) {
				DEBUGPET DoPetStuff: PetSuspend enabled and I don't have an active pet. Unsuspend pet or make a new one.
				/call CheckPetState FROMHERE
				/if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
					POPCALL
					/return CAST_OUTOFMANA
				}

			|
			| I have a pet and the pet summon delay timer is up. Let's see about making another pet.
			|
			} else /if (!${PetSummonSuspendTM} && ${PetTotCount}<2) {
				DEBUGPET DoPetStuff: PetSuspend enabled, I have a pet, I'm not fighting, the timer isn't going, and I'm not sure about what is suspended if i just fired up.
				/call CheckPetState FROMHERE
				/if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
					POPCALL
					/return CAST_OUTOFMANA
				}
			}
		} else {
			DEBUGPET DoPetStuff: Make a pet if I don't have one. Update pet state vars.
			/call CheckPetState FROMHERE
			/if (${Macro.Return.Equal[CAST_OUTOFMANA]}) {
				POPCALL
				/return CAST_OUTOFMANA
			}
			/if (${Pet.ID}) /call SetupPet FROMHERE
		}
		|
		| A pettank needs to be near their master unless otherwise told, or in a camp situation.
		| Adding returntocamp check since we need to consider that...
		|
        /if (${Select[${Role},puller,pullertank,pettank,pullerpettank]}) {
            /if (${ReturnToCamp} && !${ChaseAssist}) {
                /if (${Pet.Distance}<=${CampRadius}) {
                    /if (${Pet.Stance.NotEqual[guard]}) /pet guard
                } else {
                    /if (${Pet.Stance.NotEqual[follow]}) /pet follow
                }
            } else {
                /if (${Pet.Stance.NotEqual[follow]}) /pet follow
            }
        }
        /if (${PetHoldOn}==1) {
            /if (!${Pet.${PetHold}}) /pet ${PetHold}
            /varset PetHoldOn 2
        }
        /if (${PetFocusOn}==1) {
            /if (!${Pet.Focus}) /pet focus on
            /varset PetFocusOn 2
        }
		|
		| Adding check for whether we want a pet to taunt at all, as well as petofftank.
		|
		/if (${PetAllowTaunt}) {
			/if (!${PetTauntOn} && ${Select[${Role},pettank,pullerpettank,hunterpettank]}) {
				/call PetTauntSwitch 1 FROMHERE
			}
		} else {
			/call PetTauntSwitch 0 FROMHERE
		}				
		
        | Check to have pet come to owner if owner out of camp too long.
        /if (${Select[${Role},pettank,hunterpettank]} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}>${CampRadius} && (${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}<=${CampRadius}) && ${Pet.Stance.Equal[GUARD]}) /pet follow
        /if (${Pet.ID} && ${Me.Gem[${MiscGem}].Name.NotEqual[${ReMemMiscSpell}]} && ${MiscGemRemem}) {
            /varset DontMoveMe 1
            /call CastMemSpell "${ReMemMiscSpell}" ${MiscGem} 0 FROMHERE
            /varset DontMoveMe 0
        }
		POPCALL
        DEBUGPET DoPetStuff Leave
    /return

| -------------------------------------------------------------------------------------------------
| SUB: Event_PTaunt
| -------------------------------------------------------------------------------------------------
    Sub Event_PTaunt
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /varset PetTauntOn 1
    /return
	
| -------------------------------------------------------------------------------------------------
| SUB: Event_PTauntOff
| -------------------------------------------------------------------------------------------------
    Sub Event_PTauntOff
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /varset PetTauntOn 0
    /return
	
| -------------------------------------------------------------------------------------------------
| SUB: Event_ToysFinishedListener - Finished toys message listener
| When the mage is done providing toys, it sends a message, and this
| is listening for that message so it can then make the next pet.
| -------------------------------------------------------------------------------------------------
	Sub Event_ToysFinishedListener(Message,RequestedPetName)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGPET ToysFinishedListener: ENTER
		/doevents flush ToysFinishedListener
		/if (${RequestPetToys}) {
			/if (${Pet.CleanName.Equal[${RequestedPetName}]}) {
				/varset PetToysTimer 0
				/varset PetToysGiveup 0
			}
		}
		DEBUGPET ToysFinishedListener: LEAVE
	/return

| -------------------------------------------------------------------------------------------------
| SUB: IsPetEquipped
|
| We are going to check the pet for gear and send result to Macro.Return
| -------------------------------------------------------------------------------------------------
	Sub IsPetEquipped(ThisPetID, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGPET IsPetEquipped: ENTER from ${FromWhere}
		/if (!${ThisPetID}) {
			/echo The petID [${ThisPetID}] is invalid. Returning.
			/return BAD_PET_ID
		}
		/declare PrimaryWeap	int		local ${Spawn[id ${ThisPetID}].Equipment[primary]}

		| Turns out you can't necessarily give two 1h to all pets, esp at low levels, and it could have been a 2h
		| and the pet master can't tell if its a 2h or not. We just have to assume the pet is geared when the
		| primary is populated.
		|/declare OffhandWeap	int		local ${Spawn[id ${ThisPetID}].Equipment[offhand]}
		|/if (${Select[${PrimaryWeap},DEFAULT_PET_GEAR]} || ${Select[${OffhandWeap},DEFAULT_PET_GEAR]}) {
		/if (${Select[${PrimaryWeap},DEFAULT_PET_GEAR]}) {			
			DEBUGPET IsPetEquipped: Pet needs weapons and gear. Continuing.
			/return PET_NOT_EQUIPPED
		} else {		
			DEBUGPET IsPetEquipped: Pet has been given weapons already. Leaving.
			/return PET_EQUIPPED
		}
		DEBUGPET IsPetEquipped: LEAVE
	/return

| -------------------------------------------------------------------------------------------------
| Sub IsPetTooFar
| Return 1 is too far.
| -------------------------------------------------------------------------------------------------
	Sub IsPetTooFar(string FromWhere)

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGCOMBAT Enter from ${FromWhere}

		/if (${Pet.Distance}>${PetAttackDistance} || ${Math.Distance[${Pet.Y},${Pet.X}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}>${PetAttackDistance}) {
			/return 1
		}

	/return 0

| -------------------------------------------------------------------------------------------------
| Sub PetAttack
| -------------------------------------------------------------------------------------------------
	Sub PetAttack(string WhoWhatID, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGPETCOMBAT Enter from ${FromWhere}
		
		/if (!${Target.ID}) /call TargetThis ${WhoWhatID}

		/if (${Target.ID} && ${Spawn[id ${Target.ID}].ID}) {
			DEBUGPETCOMBAT Is ${Target.CleanName} an aggro threat?
			/call IsFriendly ${Target.ID} FROMHERE
			/if (${Macro.Return.Equal[MAY-BE-HOSTILE]}) {
				DEBUGPETCOMBAT Target hostile - attacking with pet. Sickem!
				/if (!${Pet.Combat} || ${Pet.Target.ID}!=${WhoWhatID}) {
					/pet attack
					/if (!${Pulling}) {
						DEBUGPETCOMBAT Send in swarm pets. We aren't pulling.
						/pet swarm
					} else {
						DEBUGPETCOMBAT We are pulling so don't send in swarm pets.
					}
					/varset PetAttack 1
				}
			} else {
				DEBUGPETCOMBAT Target friendly not doing anything.
			}
		} else {
			DEBUGPETCOMBAT Nothing is targetted
		}
		
		POPCALL
		DEBUGPETCOMBAT Leave
	/return	

| -------------------------------------------------------------------------------------------------
| SUB: PetBackOff - So the pet doesn't just keep saying sorry...
| -------------------------------------------------------------------------------------------------
	Sub PetBackOff(int Force, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGPETCOMBAT Enter from ${FromWhere}
		
		/declare OriginalTargetID	int		local	${Pet.Target.ID}
		
		/if (${Force}) {

			DEBUGPETCOMBAT Trying to back pet off. Down, boy!
			/if (!${Pet.${PetHold}}) /pet ${PetHold}
			/if (${Pet.Stance.NotEqual[follow]}) /pet follow

			/if (${Pet.Target.ID} && ${Pet.Target.Type.NotEqual[corpse]}) {
				/if (${Pet.Combat}) /pet back off
				|/if (!${Pet.Stop}) /pet stop
				/if (!${Pet.ReGroup}) /pet regroup
			}

			/delay 1s

			/if (!${Pet.Target.ID} || ${Pet.Target.Type.Equal[corpse]}) {
				DEBUGPETCOMBAT Pet has backed off. Leaving.
				/varset PetAttack 0
				/return
			} else /if (${Pet.Target.ID}==${OriginalTargetID}) {
				DEBUGPETCOMBAT Looks like pet back off failed. Trying again.
			} else /if (${Pet.Target.ID}!=${OriginalTargetID}) {
				DEBUGPETCOMBAT Pet found another target /shrug. Trying again.
			}
			
			/if (${Pet.Combat}) /pet back off
			|/if (!${Pet.Stop}) /pet stop
			/if (!${Pet.ReGroup}) /pet regroup

			/delay 1s

			/if (!${Pet.Target.ID} || ${Pet.Target.Type.Equal[corpse]}) {
				DEBUGPETCOMBAT Pet has backed off. Leaving.
				/varset PetAttack 0
				/return
			} else {
				DEBUGPETCOMBAT ${Pet.Name} is being bad and won't back off... gonna make it go away.
				/echo \awAKA: \ayCould not back off my pet ${Pet.Name}...maybe /pet leave?
				/varset PetAttack 1
				/return
			}
		} else {

			/if (${Pet.Combat}) /pet back off
			|/if (!${Pet.Stop}) /pet stop
			/if (!${Pet.ReGroup}) /pet regroup

			/delay 1s

			/if (!${Pet.Target.ID} || ${Pet.Target.Type.Equal[corpse]}) {
				/varset PetAttack 0
				/return
			}

		}
		DEBUGPETCOMBAT PetBackOff: Leave
	/return

| -------------------------------------------------------------------------------------------------
| SUB PetEngageTarget
| -------------------------------------------------------------------------------------------------
	Sub PetEngageTarget(int GetOnThisMobID, int IgnoreLOS, string FromWhere)
		/if (!${Pet.ID}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGCOMBAT PetEngageTarget: Enter from ${FromWhere} - debug further using petcombat
		DEBUGPETCOMBAT PetEngageTarget: Enter from ${FromWhere}
		/declare PetIR		int		local	0
		/declare PetILOS	int		local	0
		/declare PetOT		int		local	0
		/declare PetNT		int		local	0		
		/declare MobIR		int		local	0
		/declare MobILOS	int		local	0		

		/if (!${Target.ID} && !${GetOnThisMobID}) {
			DEBUGPETCOMBAT PetEngageTarget: Wrangling pet and leaving.
			/call PetBackOff 1 FROMHERE
			POPCALL
			/return -1
		}
		
		/if (!${GetOnThisMobID}) /varset GetOnThisMobID ${Target.ID}
		/if (${Target.ID}!=${GetOnThisMobID}) /call TargetThis ${GetOnThisMobID}

		| Is pet in range?
		|/if (${Math.Distance[${Pet.Y},${Pet.X}:${Me.Y},${Me.X}]}<=${PetAttackRange}) {
		/if (${Math.Distance[${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}:${Target.Y},${Target.X}]}<=${PetAttackRange}) {				
			DEBUGPETCOMBAT PetEngageTarget: Pet is within range of the MA <= ${PetAttackRange}
			/varset PetIR 1
		} else {
			/if (!${PetAttack}) {
				POPCALL
				/return 0
			} else {
				/call PetBackOff 1 FROMHERE
				POPCALL
				/return -1
			}
			DEBUGPETCOMBAT PetEngageTarget: Pet is too far away >${PetAttackRange}
		}
			
		| Can I see my pet?
		/if (${Pet.LineOfSight}) /varset PetILOS 1
		/if (!${PetLineOfSightOn} || ${IgnoreLOS}) /varset PetILOS 1
		/if (${PetILOS}) {
			DEBUGPETCOMBAT PetEngageTarget: Pet is in LOS or override active PetLineOfSightOn ${PetLineOfSightOn} which ignores los.
		} else {
			DEBUGPETCOMBAT PetEngageTarget: Pet is not in LOS
		}
			
		| Pet on any target?
		/if (!${Pet.Target.ID}) {
			/varset PetNT 1
			DEBUGPETCOMBAT PetEngageTarget: Pet does not have a target.
		} else {
			DEBUGPETCOMBAT PetEngageTarget: Pet has a target.
		}
			
		| Pet on the right target?
		/if (${Pet.Target.ID}==${GetOnThisMobID}) {
			DEBUGPETCOMBAT PetEngageTarget: Pet is on the right target.
			/varset PetOT 1
		} else {
			DEBUGPETCOMBAT PetEngageTarget: Pet is not on the right target.
		}
		
		| Mob in appropriate pet attack range? This needs to be relative to the MA.
		|/if (${Math.Distance[${Me.Y},${Me.X}:${Target.Y},${Target.X}]}<=${PetAttackRange}) {
		/if (${Math.Distance[${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}:${Target.Y},${Target.X}]}<=${PetAttackRange}) {			
			DEBUGPETCOMBAT PetEngageTarget: The mob is in range of the MA <=${PetAttackRange}
			/varset MobIR 1
		} else {
			/if (!${PetAttack}) {
				POPCALL
				/return 0
			} else {
				/call PetBackOff 1 FROMHERE
				POPCALL
				/return -1
			}
			DEBUGPETCOMBAT PetEngageTarget: The mob is too far away from the MA >${PetAttackRange}
		}
		
		| Can I see the mob?
		/if (${Spawn[id ${GetOnThisMobID}].LineOfSight}) /varset MobILOS 1
		/if (!${PetLineOfSightOn} || ${IgnoreLOS}) /varset MobILOS 1
		/if (${MobILOS}) {
			DEBUGPETCOMBAT PetEngageTarget: The mob is in line of sight or override active PetLineOfSightOn ${PetLineOfSightOn} which ignores los.
		} else {
			DEBUGPETCOMBAT PetEngageTarget: The mob is not in line of sight.
		}

		/if (${PetIR} && ${PetILOS} && ${PetOT} && ${MobIR} && ${MobILOS}) {
			DEBUGPETCOMBAT PetEngageTarget: Pet is doing the right thing. Leaving.
			POPCALL
			/return 1
		} else {
			DEBUGPETCOMBAT PetEngageTarget: Pet needs to be re-directed.
		}
	
		/if (${MobIR} && ${MobILOS} && (!${PetOT} || ${PetNT})) {
			DEBUGPETCOMBAT PetEngageTarget: Mob is in range and los - pet needs to be directed to target.
			/if ((${PetNT} || !${PetOT}) && ${Target.ID}!=${GetOnThisMobID}) {
				/call TargetThis ${GetOnThisMobID}
			}
			DEBUGPETCOMBAT PetEngageTarget: Mob checks out - sending in pet and swarm and leaving.
			/call PetAttack ${GetOnThisMobID} FROMHERE
			POPCALL
			/return 1
		}

		DEBUGPETCOMBAT PetEngageTarget: Pet needs to be wrangled and brought back.
		/call PetBackOff 1 FROMHERE
		POPCALL
		DEBUGPETCOMBAT PetEngageTarget: Leave
	/return -1

| -------------------------------------------------------------------------------------------------
| SUB: PetSummon
|
| Makes a pet. This should be the *only* routine that makes a pet.
| -------------------------------------------------------------------------------------------------
	Sub PetSummon(string FromWhere)
		/if (!${PetOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGPET Enter from ${FromWhere}

		/declare SummonPetTM	timer	local	0
		/declare WaitTime		string	local	600
		/declare PetSpellToCast	string	local	${PetSpell}

        /declare FocusPet 		string 	local 	${PetFocus.Arg[1,|]}
        /declare FocusSlot 		string 	local 	${PetFocus.Arg[2,|]}
        /declare FocusBuff 		string 	local 	${PetFocus.Arg[3,|]}
        /declare FocusCurrent 	string 	local 
        /declare FocusSwitch 	int 	local 	0

		/if (${Pet.ID}) {
			DEBUGPET We have an active pet. Leaving.
			POPCALL
			/return
		}
		
		/if (${Spell[${PetSpell}].Mana}>0 && ${Me.CurrentMana}<${Int[${Math.Calc[${Spell[${PetSpell}].Mana}*1.1]}]}) {
			DEBUGPET Not enough mana to cast: ${PetSpell}
			POPCALL
			/return CAST_OUTOFMANA
		}
		
		/echo I don't have a pet. ${Me.Class}s live longer when we have pets.
		
        | Swap pet focus in pet cast
        DEBUGPET FocusPet ${FocusPet} FocusSlot ${FocusSlot} FocusCurrent ${FocusCurrent} PetID ${Pet.ID}

        /if (!${FocusSlot.Length} || ${FocusSlot.Equal[null]}) {
            /varset FocusPet
            /varset FocusSlot
            /varset FocusCurrent
        } else /if (${FocusSlot.NotEqual[buff]}) {
            /varset FocusCurrent ${Me.Inventory[${FocusSlot}].Name}
        } else {
            /varset FocusCurrent ${FocusBuff}
        }
		
        /if (${PetFocusOn}) /varset PetFocusOn 1
        /if (${PetHoldOn}) /varset PetHoldOn 1
		
        /if (${FocusBuff.Length} && ${FocusBuff.NotEqual[null]}) {
			DEBUGPET Seeing if we can make a Focus pet. ${FocusBuff}
			|
			| Try and make a focus pet
			|
            /if (!${Me.Buff[${FocusBuff}].ID} && !${Me.Song[${FocusBuff}].ID}) {
		        /echo ARISE my minion!
                /call CastHotSwap "${FocusPet}" ${Me.ID} PetSummon 0 0 FROMHERE
            }
			/delay 10
			|
			| If it fails, see if we can make a regular pet
			|
			/if (${Pet.ID}) {
				DEBUGPET We made a pet.
				/echo My pet is now: ${Pet.CleanName} from ${FocusBuff}
				/ini "${IniFileName}" "Pet" "PetShrunkSize" "0"
				/if (${BootCompleted}) {
					|
					| Establish default pet taunt state.
					|
					/if (!${PetTotCount}) {
						/if (${Pet.Taunt}) /pet taunt off
						/delay 10
						/doevents PTauntOff
						/call CheckRoles 0 FROMHERE
					}
				}
				POPCALL
				/return PET_SUMMON_SUCCESS
			} else {
				DEBUGPET We didn't succeed making a focus pet.
			}
        }
		
		/if (!${PetSpell.Length} || !${Me.Book[${PetSpell}]}) {
			DEBUGPET I don't have a pet spell defined.
			|
			| I don't want to turn this off unless PetFocus is also off. Maybe they using a clicky.
			|
			/if (!${FocusPet}) {
				/varset PetOn 0
			}
			POPCALL
			/return
		}
		
		DEBUGPET PetSummon: Making a new pet
        /echo ARISE ${PetSpell}
		/varset SummonPetTM ${WaitTime}
        /while (!${Pet.ID} && ${SummonPetTM}) {
			DEBUGPET Within the while loop waiting for either a pet or timer to run out ${SummonPetTM}
			/doevents GotHit
			/if (!${FocusSwitch} && ${FocusPet.Length} && ${FindItemCount[=${FocusPet}]}) {
				/if (${FocusSlot.NotEqual[buff]}) {
					/if (!${Cursor.ID} && ${FocusPet.NotEqual[${FocusCurrent}]}) {
						/exchange "${FocusPet}" ${FocusSlot}
						/varset FocusSwitch 1
						/delay 10
					}
				}
			}
			|
			| CastHotSwap waits and casts when ready.
			|
			|/if (!${Window[CastingWindow].Open}) {
				/call WaitUntilAble "${PetSpell}" FROMHERE
				/if (${Me.Combat} && ${BattleSummonPet}) {
					DEBUGPET Battle summon pet!
					/call CastHotSwap "${PetSpell}" ${Me.ID} FROMHERE
				} else {
					DEBUGPET Normal summon
					/call CastWhat "${PetSpell}" ${Me.ID} PetSummon 0 0 FROMHERE
					/delay 10
				}
				/if (${Macro.Return.Equal[CAST_COMPONENTS]}) {
					DEBUGPET You don't have the components to make pet.
					|/echo You are missing components to make a new pet. Buy some Scooby snacks. Turning pets off.
					|/varset PetOn 0
					/break
				}
			|}
            /delay 10
			
			| Make sure this is done immediately so we don't get thrown off if gothit event
			/if (${Pet.ID}) {
				| Swap pet focus out for regular item
				/if (${FocusSwitch} && !${Cursor.ID}) {
					/exchange "${FocusCurrent}" ${FocusSlot}
					/delay 10
				}
				/break
			}
		}
		DEBUGPET Exited the While loop
		
		/if (${Pet.ID}) {
			DEBUGPET We made a pet.
                /echo My pet is now: ${Pet.CleanName} from ${PetSpell}
				/ini "${IniFileName}" "Pet" "PetShrunkSize" "0"
				/if (${BootCompleted}) {
					|
					| Establish default pet taunt state.
					|
					/if (!${PetTotCount}) {
						/if (${Pet.Taunt}) /pet taunt off
						/delay 10
						/doevents PTauntOff
						/call CheckRoles 0 FROMHERE
					}
				}
			POPCALL
			/return PET_SUMMON_SUCCESS
		} else {
			DEBUGPET We did not make a pet.
			/echo We failed to make a pet. This is why: ${Macro.Return}
			POPCALL
			/return ${Macro.Return}
		}
		POPCALL
		DEBUGPET Exit
	/return PET_SUMMON_FAIL

| -------------------------------------------------------------------------------------------------
| SUB: PetSuspend
|
| Basically the old CheckPetState.
| -------------------------------------------------------------------------------------------------
	Sub PetSuspend(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGPET Enter from ${FromWhere}
		
		/declare PetStateTM		timer	local	0
		/declare WaitThisLong	string	local	300

        /if (${Me.AltAbility[Companion's Suspension]}>0) {
			DEBUGPET I have the ability Companion's Suspension
			/varset PetStateTM ${WaitThisLong}
            /while ((!${Me.AltAbilityReady[Companion's Suspension]} || ${Window[CastingWindow].Open}) && !${PetStateTM}) {
				DEBUGPET Waiting for suspend ability to become ready and casting to finish.
				/doevents GotHit
                /delay 5
            }
			DEBUGPET Suspending... or swapping.
			/call CastWhat "Companion's Suspension" ${Me.ID} PetSuspend 0 0 FROMHERE
			POPCALL
			/return ${Macro.Return}
        } else {
			DEBUGPET Player does not have the AA to unsuspend pets. We will still make a new one.
			|
			| Let it fall through so the proper state vars are set.
			|
            /echo \awAKA: \ayYou do not have the AA "Companion's Suspension". PetSuspend is now disabled.
            /varset PetSuspend 0
        }
		POPCALL
		DEBUGPET Leave
	/return NO_PET_SUSPEND
	
| -------------------------------------------------------------------------------------------------
| SUB: PetTauntSwitch
| -------------------------------------------------------------------------------------------------
	Sub PetTauntSwitch(int OnOff, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		DEBUGPET Enter from ${FromWhere}

		/if (!${PetAllowTaunt}) {
			/if (${Pet.Taunt}) {
				/pet taunt off
				/delay 10
				/doevents PTauntOff
			}
			/return
		}

		/if (${Select[${Role},pettank,pullerpettank,hunterpettank]}) {
			/if (!${Pet.Taunt}) {
				/pet taunt on
				/delay 10
				/doevents PTaunt
			}
			/return
		}

		/if (${PetTauntOn} && ${OnOff} && ${Pet.Taunt}) /return
		/if (!${PetTauntOn} && !${OnOff} && !${Pet.Taunt}) /return

		/if (${PetTauntOn} && !${OnOff}) {
			/if (${Pet.Taunt}) /pet taunt off
			/delay 10
			/doevents PTauntOff
			/return
		}

		/if (!${PetTauntOn} && ${OnOff}) {
			/if (!${Pet.Taunt}) /pet taunt on
			/delay 10
			/doevents PTaunt
			/return
		}

		| If all else fails, turn it off.
		/if (${Pet.Taunt}) {
			/pet taunt off
			/delay 10
			/doevents PTauntOff
		}
	/return
	
|-------------------------------------------------------------------------------------
| SUB: Pull With Pet Written by TreeHuginDruid for RedGuides
|-------------------------------------------------------------------------------------
    Sub PullWithPet(int MobID, float petPullDist, string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		| BeginMobID is an outer var used in the PullAggroTarg...ID noparse var.
		/varset BeginMobID ${MobID}

        DEBUGPULL Enter from ${FromWhere}. Our target is ${Spawn[id ${BeginMobID}].CleanName} (${BeginMobID})

        /declare int_petMoving    int local 0
        /declare int_triedSending int local 0

        /if (${Target.ID}) /face ${If[${FaceMobOn}==2,nolook,fast nolook]}

        |- Ensure we are in pull range and pet is following!
        /if (${Pet.Stance.NotEqual[FOLLOW]}) /pet follow
		
		| - Send in pet if I don't have a mob in extended target
        /echo Pulling with PET now !
		/varset Pulling 1
		/while (!${PullAggroTargetID}) {
            | Send in the Pet and monitor his movement.
			
            |/if (!${int_petMoving}) /call PetEngageTarget ${BeginMobID} 1 FROMHERE
			/if (!${int_petMoving}) /call PetAttack ${BeginMobID} FROMHERE
			/delay 5
            | Is the pet moving?
            /if (${Pet.Moving}) {
                /varset int_petMoving 1
                /varset int_triedSending 0
            } else {
                /varset int_petMoving 0
                /varcalc int_triedSending ${int_triedSending}+1 
            }
			
            | Fix for HunterPetTank
            /if (!${Spawn[id ${MyTargetID}].ID} || ${Spawn[id ${MyTargetID}].Type.Equal[corpse]}) /break
            /if (${Spawn[id ${BeginMobID}].Distance3D}>${petPullDist}) /break
            /if (${int_triedSending}>2) /break
        }
		
        /if (${PullAggroTargetID}) {
			DEBUGPULL Pulled ${Spawn[id ${PullAggroTargetID}].CleanName} (${PullAggroTargetID})
            /varset Pulled 1
        } else {
			DEBUGPULL Pull failed. Pet did not aggro mob for some reason.
		}
		
		/call PetBackOff FROMHERE
        /if (${PetHoldOn} && !${Pet.${PetHold}}) /pet ${PetHold}

		POPCALL
        DEBUGPULL Leave
    /return
	
| -------------------------------------------------------------------------------------------------
| Sub SetupPet
| -------------------------------------------------------------------------------------------------
	Sub SetupPet(string FromWhere)
		/if (!${Pet.ID}) /return
		
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		DEBUGPET Enter from ${FromWhere}

        /declare PetSummonTimer		timer	local	90s
		|
		| Timers for requesting pet toys. If it expires, requestpettoys disabled. 120 = 2mins
		|
		/declare RequestAgainTMSec	string	local	120
		/declare RequestRetriesMax	int		local	3
	
		DEBUGPET I have a pet. Do we need pet toys?
		/call IsPetEquipped ${Pet.ID} FROMHERE
		/if (${Macro.Return.Equal[PET_NOT_EQUIPPED]}) {
			|
			| We might be a mage that requests toys rather than make their own.
			|
			| An error condition arises where a pet dies in combat and is immediately recast but the ini remains.
			|
			/if (${Select[${Me.Class.ShortName},MAG]} && ${PetToysOn} && !${RequestPetToys}) {					
				/ini "${IniFileName}" "Pet" "PetToysGave" ""
				/varset PetToysGave
				/call PetToys ${Pet.CleanName} FROMHERE
				|
				| Ok to make another pet.
				|
				/varset PetSummonSuspendTM 0
			} else /if (${RequestPetToys}) {
				|
				| We are requesting toys. We use a timer so we don't suspend our pet before toys can be done.
				|
				DEBUGPET DoPetStuff: Is timer up? If we made a pet on a prior cycle, we wait for some time to allow it to be buffed and geared. Esp important if non-mage pet.
				/if (!${PetToysTimer} && ${PetToysGiveup}<${RequestRetriesMax}) {
					DEBUGPET DoPetStuff: Request pet toys
					/if (!${PetToysGiveup}) {
						/echo Requesting pet toys. We will try ${RequestRetriesMax} times, once every ${RequestAgainTMSec} seconds, before we give up.
						/varset PetToysGave ${Pet.CleanName}:Summoned Toys Requested
						/ini "${IniFileName}" "Pet" "PetToysGave" "${PetToysGave}"
					}
					/call Bind_RequestToys FROMHERE
					/varset PetToysTimer ${RequestAgainTMSec}s
					/varcalc PetToysGiveup ${PetToysGiveup}+1
				} else /if (!${PetToysTimer} && ${PetToysGiveup}>=${RequestRetriesMax}) {
					DEBUGPET DoPetStuff: Requested ${RequestRetriesMax} times to get toys. Giving up. Being quiet about it. There is no one in group providing pet toys.
					/echo No one is providing pet toys. Disabling RequestPetToys.
					/varset RequestPetToys 0
				}
               } else {
				|
				| We aren't equipping our pet.
				|
			}
		} else /if (${Macro.Return.Equal[PET_EQUIPPED]}) {
			DEBUGPET DoPetStuff: Pet is equipped.
			/varset PetToysTimer 0
			/varset PetToysGiveup 0
		} else {
			DEBUGPET We have a... pet with no name. Should we just tell it to get lost?
		}
		POPCALL
	/return

| -------------------------------------------------------------------------------------------------
| Sub:Event_NotLegalTarget
| -------------------------------------------------------------------------------------------------
	Sub Event_NotLegalTarget

		/doevents flush NotLegalTarget
		/call PullIgnoreCheck ${Target.ID} a NotLegalTarget

	/return