

| -------------------------------------------------------------------------------------
| SUB: Bind AddToIgnore
| -------------------------------------------------------------------------------------
    Sub Bind_AddToIgnore(MTIgnore, int byID)
	
		| Sometimes mobs pop up during a quest then despawn. We don't want to necessarily
		| kill them all... just some of them. Sometimes.
		| This needs to just accept MTIgnore and add it to the list if its provided.
		| See if its numeric, and if so, then treat it like byID
	
        | Take the targeted mob as a parameter for mob to ignore.
        /if (!${Defined[MTIgnore]}) /declare MTIgnore string local null
        /if (${MTIgnore.Equal[null]} || ${MTIgnore.Length}==0) /varset MTIgnore ${Target.CleanName}
        /if (!${byID}) {
            /if (!${MTIgnore.Length} || ${MTIgnore.Equal[null]} || ${Spawn[${MTIgnore}].Type.NotEqual[NPC]} || ${Spawn[=${MTIgnore}].CleanName.Equal[null]}) {
                /echo No NPCs named (${MTIgnore}) detected. Nothing added to list. Maybe it despawned? ${byID}
                /return
            }
            | Assign temp var   list
            /declare IgnoreAdd string local ${MobsToIgnore}
            | If MobsToIgnore default text with the word null in it assign var spawn clean name
            /if (${IgnoreAdd.Find[null]}) {
                /varset IgnoreAdd ${Spawn[${MTIgnore}].CleanName}
            } else {
                /varset IgnoreAdd ${IgnoreAdd},${Spawn[${MTIgnore}].CleanName}
            }
            | Remove's corpse if closest match is a mob corpse
            /if (${IgnoreAdd.Right[-10].Find[corpse]}) /varset IgnoreAdd ${IgnoreAdd.Right[-8]}
            /if (${MobsToIgnore.Find[${Spawn[${MTIgnore}].CleanName}]}) {
                /echo >> ${Spawn[${MTIgnore}].CleanName} << already on Ignore List.
                /return
            }
            /ini "${InfoFileName}" "${ZoneName}" "MobsToIgnore" "${IgnoreAdd}"
            /echo AddToIgnore -> ${Spawn[${MTIgnore}].CleanName} <- Adding to Ignore list.
            | Reassign MobsToIgnore var the new list
            /varset MobsToIgnore ${IgnoreAdd}
        } else {
            /if (${MTIgnore.Equal[null]} || ${Spawn[id ${MTIgnore}].Type.NotEqual[NPC]} || ${Spawn[id ${MTIgnore}].CleanName.Equal[null]}) {
                /echo No NPCs with ID: (${MTIgnore}) detected. Nothing added to list. ${byID}
                /return
            }
            /if (${Int[${MTIgnore}]}>0 && !${MobsToIgnoreByID.Find[${MTIgnore}|]}) {
                /varset MobsToIgnoreByID ${MTIgnore}|${MobsToIgnoreByID}
            }
        }
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Bind AddToPull
| -------------------------------------------------------------------------------------
    Sub Bind_AddToPull(MTPull)
        /if (!${MTPull.Length} || ${MTPull.Find[null]} || ${Spawn[=${MTPull}].ID}==${Me.ID} ) {
            /echo No NPCs detected. Nothing added to list.
            /return
        }
        | Assign temp var MobsToPull list
        /declare PullAdd string local ${MobsToPull}
        | If MobsToPull default text with the word null in it assign var spawn clean name
        /if (${PullAdd.Find[all]}) {
            /varset PullAdd ${Spawn[${MTPull}].CleanName}
        } else {
            /varset PullAdd ${PullAdd},${Spawn[${MTPull}].CleanName}
        }
        | Remove's corpse if closest match is a mob corpse
        /if (${PullAdd.Right[-10].Find[corpse]}) /varset PullAdd ${PullAdd.Right[-8]}
        /if (${MobsToPull.Find[${Spawn[${MTPull}].CleanName}]}) {
            /echo >> ${Spawn[${MTPull}].CleanName} << already on Pull List.
            /return
        }
        /if (${Spawn[${MTPull}].CleanName.Equal[null]}) {
            /echo ERROR: No Mob with ${MTPull} in Name detected.
            /return
        }
        /if (!${MobsToPull.Find[${Spawn[${MTPull}].CleanName}]}) {
            /ini "${InfoFileName}" "${ZoneName}" "MobsToPull" "${PullAdd}"
            /echo AddToPull-> ${Spawn[${MTPull}].CleanName} <- Adding to Pull list.
        }
        | Reassign MobsToPull var the new list
        /varset MobsToPull ${PullAdd}
    /return

| ---------------------------------------------------------------------------
| SUB Bind_PleaseWait
| ---------------------------------------------------------------------------
	Sub Bind_PleaseWait(string WaitReason, string WaitTime, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        DEBUGPULL Enter from ${FromWhere}

		/if (!${WaitReason.Length}) /varset WaitReason Need to pause
		/if (!${WaitTime.Length}) /varset WaitTime 60s
	
		/call Broadcast y "${WaitReason}: PleaseWait >${WaitTime}<"
		/delay 20
		/doevents PleaseWaitListener
		
		POPCALL
	/return


| -------------------------------------------------------------------------------------------------
| Sub:Bind_PullAMob
| /pull command. Invoked by setting a variable here and the process is initiated in main loop.
| -------------------------------------------------------------------------------------------------
    Sub Bind_PullAMob

 		/if (!${BootCompleted}) {
			/echo \awAKA: \ayAKA Booting up.
			/return
		}
        /if (!${PullManual}) {
            /echo \awAKA: \ayManual pull is disabled. Please check your INI.
            /return
        }
        /if (${AggroTargetID}) {
            /echo \awAKA: \ayYou are in combat.
            /return
        }

        | Pull will be invoked within main loop.
        /varset PullDoManualPull 1

    /return

| -------------------------------------------------------------------------------------------------
| Sub:PullTheMob
| Performs the /pull action, invoked from the main loop so we can use binds
| -------------------------------------------------------------------------------------------------
    Sub PullTheMob(string FromWhere)

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGPULL Entered from ${FromWhere} - Checking location to return to

        | Reset the state var
        /varset PullDoManualPull 0

		/declare CampWasOn			int		local 	${ReturnToCamp}
		
		/declare MeX				int		local	${Me.X}
		/declare MeY				int		local	${Me.Y}
		/declare MeZ				int		local	${Me.FloorZ}
		/declare MeHeading			int		local	${Me.Heading.DegreesCCW}
		
		/declare OCampXLoc			int		local	${CampXLoc}
		/declare OCampYLoc			int		local	${CampYLoc}
		/declare OCampZLoc			int		local	${CampZLoc}
		/declare OLookForward		int		local	${Me.Heading.DegreesCCW}
				
		/if (!${CampWasOn}) {
			/varset CampXLoc ${Me.X}
			/varset CampYLoc ${Me.Y}
			/varset CampZLoc ${Me.FloorZ}
			/varset LookForward ${Me.Heading.DegreesCCW}
		}

        DEBUGPULL Now starting the pull process
		/call PullNearestValidMob FROMHERE

        DEBUGPULL The pull and combat processes are done. Returning to camp if necessary.
		/call DoWeMove 1 FROMHERE

		/if (!${CampWasOn}) {
			/varset CampXLoc ${MeX}
			/varset CampYLoc ${MeY}
			/varset CampZLoc ${MeZ}
			/varset LookForward ${MeHeading}
		}

        DEBUGPULL Leave
		POPCALL
   /return


|-----------------------------------------------------------------------------
| SUB: SetPullAngle
| ----------------------------------------------------------------------------
    Sub Bind_SetPullArc(float AWidth, string FDir)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		DEBUGCOMBAT Enter
	
        /declare DirDegree string local 0,45,90,135,180,225,270,315
        /declare FDirTemp  string local ${FDir}
        /if (!${AWidth}) {
            /if (${PullArcWidth}) {
                /echo Turning off Directional Pulling.
                /varset PullArcWidth 0
            }
			POPCALL
            /return
        } else {
            /varset PullArcWidth ${AWidth}
        }
        /if (!${Bool[${FDir}]}) {
            /varset FDirTemp ${Me.Heading.Degrees}
        } else /if (${Float[${FDir}]}>0) {
            /varset FDirTemp ${FDir}
        } else {
            /varset FDirTemp ${DirDegree.Arg[${Select[${FDir},n,ne,e,se,s,sw,w,nw]},,]}.00
            /if (!${FDirTemp} && ${FDir.NotEqual[n]}) {
                /echo Invalid Direction. Turning off Directional Pulling.
                /varset PullArcWidth 0
				POPCALL
                /return
            }
        }
        /call SetPullAngles ${Float[${FDirTemp}]} ${AWidth} 0
		
		DEBUGCOMBAT Leave
		
		POPCALL
    /return
	
| ----------------------------------------------------------------------------
| SUB: ChainPullNextMob
| ----------------------------------------------------------------------------
    Sub ChainPullNextMob(int EchoWaitMessage, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGCHAINPULL ChainPullNextMob: ENTER from ${FromWhere}
        /if (${Math.Distance[${CampYLoc},${CampXLoc}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}<=75) {
            /if (!${PullHold} && ${MobCount}<2 && !${Me.XTarget[${XTSlot2}].ID} && ${If[${Target.Named},0,1]}==1) {
                /if (${Target.ID} && ${Target.PctHPs} < ${ChainPullHP}) {
                    /call FindMobToPull 0 1 FROMHERE
                    /if (${Macro.Return}>0 && (!${PullXPCheck} || (${Spawn[${ChainPullTemp}].Distance}<${Math.Calc[${PullRange}+400]} && ${PullXPCheck})) && ${Me.TargetOfTarget.Name.NotEqual[${Me.CleanName}]} && ${Me.PctAggro}<50) {
                        /varset PullMob ${Macro.Return}
                        /if (${UseMQ2Melee}) /squelch /melee melee=0
                        /if (${Stick.Active}) /squelch /stick off
                        /squelch /attack off
                        /delay 10
                        /if (${UseMQ2Melee}) /squelch /melee melee=1
                        /varset ChainPull 2
                        /varset MyTargetID 0
                        /varset Attacking 0
                        /varset CombatStart 0
						POPCALL
                        /return 1
                    } else {
                        DEBUGCHAINPULL Chain Pull Failed 3: ${Macro.Return} ${PullXPCheck} ${Spawn[${ChainPullTemp}].Distance}<${Math.Calc[${PullRange}+400]} ${Me.TargetOfTarget.Name} ${Me.PctAggro}
                    }
                } else {
                    DEBUGCHAINPULL Chain Pull Failed 2: ${Target.ID} ${Target.PctHPs}<${ChainPullHP}
                }
            } else {
                DEBUGCHAINPULL Chain Pull Failed 1: ${PullHold} ${MobCount}<2 ${Me.XTarget[${XTSlot2}].ID} ${Target.Named}
            }
        } else /if (${EchoWaitMessage}) {
            /call BroadCast r "Holding Pulls. Tank to far from camp."
			POPCALL
            /return W
        }
		POPCALL
		DEBUGCHAINPULL ChainPullNextMob: EXIT
    /return 0
	
| -------------------------------------------------------------------------------------
| SUB: Event CantHit
| -------------------------------------------------------------------------------------
    Sub Event_CantHit
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        |/varset EventFlag 1
        DEBUGN Event_CantHit
        | Reset position via stick
        /if (${Pulling}) {
            /varset CantHit 1
            /if (${PullWith.Equal[Ranged]} && ${Target.Distance}<=30 && ${Target.LineOfSight}) /varset ToClose 1
        }
        DEBUGN Leave Event_CantHit
    /return
	
| ---------------------------------------------------------------------------
| SUB Event_PleaseWaitListener
| ---------------------------------------------------------------------------
	Sub Event_PleaseWaitListener(Message,string TimeEstimate)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		| Let them all through to make sure we get the right duration.
		|/doevents flush PleaseWaitListener
		/if (!${Select[${Role},PULLER_ROLES]}) {
			POPCALL
			/return
		}
		/if (!${TimeEstimate.Length} || ${TimeEstimate.Equal[NULL]}) {
			POPCALL
			/return
		}
		
		/declare WaitTimeEst	int		local	0
		
		/if (${TimeEstimate.Find[s]}) {
			/varcalc WaitTimeEst ${Int[${TimeEstimate}]}*10
		} else /if (${TimeEstimate.Find[m]}) {
			/varcalc WaitTimeEst ${Int[${TimeEstimate}]}*600
		} else {
			/varset WaitTimeEst ${Int[${TimeEstimate}]}
		}
		
		/if (!${WaitTimeEst}) {
			POPCALL
			/return
		}
		
		/if (${Pulling} && !${Pulled}) {
			/echo \ayReturning to camp to wait for ${TimeEstimate}
			/call BacktoCampReset FROMHERE
		} else /if (!${Pulling} && !${Pulled}) {
			/echo \ayPausing pulls for ${TimeEstimate}
		} else /if (${Pulled}) {
			/echo \arCan't pause! I've already pulled.
			POPCALL
			/return
		}
						
		/if (${PleaseWaitTimerOn}<${WaitTimeEst}) {
			/varset PleaseWaitTimerOn ${WaitTimeEst}
		}
		POPCALL
	/return
	
| ---------------------------------------------------------------------------
| SUB Event_PulledGetReady
|
| Directs the MA to check the target right away rather than go through all
| the rest of the routines. If mobs are already in camp then it will sort out
| then.
| ---------------------------------------------------------------------------
	Sub Event_PulledGetReady(Message,string MobName, int MobID)
		/if (!${AutoTargetOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
		/doevents flush PulledGetReady
		/if (!${IAmMA} || (${Select[${Role},PULLER_ROLES]} || ${PullManual})) {
			POPCALL
			/return
		}
		/if (!${Me.Combat}) {
			/echo Getting Ready for mob -> ${MobName} <- ID: ${MobID}
			/call TargetThis ${MobID}
			/call CombatTargetCheck ${MobID} FROMHERE
		}
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: Event Too Close
| ----------------------------------------------------------------------------
    Sub Event_TooClose
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        |/varset EventFlag 1
        /if (${MyTargetID} && ${AutoFireOn}==1 && ${CombatStart}) {
            /if (${Me.AutoFire}) /autofire
            /varset AutoFireOn 2
            /if (${UseMQ2Melee}) /killthis
        }
        /if (${Pulling} && ${PullWithAlt.Equal[Melee]}) {
           /echo Mob Too Close for ${PullWith}... Switching to Melee.
           /varset ToClose 1
        }
        /doevents flush TooClose
    /return
	
|-----------------------------------------------------------------------------
| SUB: FigureAngles
| ----------------------------------------------------------------------------
    Sub FigureMobAngle(int aMobID)
        /if (!${aMobID}) /return 0
        | Exploring adding a "width" option to narrow down where pulls are made.
        | /if (!${AWidth}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX		

		DEBUGCOMBAT Enter

        /declare DirectionToMob float local 0
        /varset DirectionToMob ${Spawn[id ${aMobID}].HeadingTo[${CampYLoc},${CampXLoc}].Degrees}
        /if (${PullLSide}>=${PullRSide}) {
            /if (${DirectionToMob}<${PullLSide} && ${DirectionToMob}>${PullRSide}) /return 0
        } else {
            /if (${DirectionToMob}<${PullLSide} || ${DirectionToMob}>${PullRSide}) /return 0
        }
		
		DEBUGCOMBAT Leave
		
    /return 1
		
| -----------------------------------------------------------------------------------------------------------
| SUB: Find Mob Using Advanced Path.
| -----------------------------------------------------------------------------------------------------------
    Sub FindMobAdvPath(int PFlag, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare i int local
        /declare k int local
        /declare l int local
        /declare PullMobName string local 0
        /declare PullMobDistance float local 0
        /declare PullMobValid int local 0
        /declare DistanceCheck int local
        /declare WPMobCount int local
        | Advpath searches for mobs along the path using Pullwith radius not Maxradius
        DEBUGPULL FindMobAvdPath Enter from ${FromWhere} - ${PFlag}
        /if (${Target.ID}) /call TargetThis
        /varset PullMobValid 0
        | loop through pathwaypoints and check for mobs
        /for k 1 to ${PullPathWpCount}
			/call LastMove
            /varset WPMobCount 0
            /varset PullMob 0
            /if (${UseWayPointZ}) {
                /varset WPMobCount ${SpawnCount[npc loc ${PullPathArrayX[${k}]} ${PullPathArrayY[${k}]} ${PullPathArrayZ[${k}]} radius ${PullRange} zradius ${MaxZRange} targetable ${SearchType}]}
            } else {
                /varset WPMobCount ${SpawnCount[npc loc ${PullPathArrayX[${k}]} ${PullPathArrayY[${k}]} radius ${PullRange} zradius ${MaxZRange} targetable ${SearchType}]}
            }
            /if (${WPMobCount}) {
                /varset i 0
                /for l 1 to ${WPMobCount}
                    /if (${UseWayPointZ}) {
                        /varset PullMob ${NearestSpawn[${l}, npc loc ${PullPathArrayX[${k}]} ${PullPathArrayY[${k}]} ${PullPathArrayZ[${k}]} radius ${PullRange} zradius ${MaxZRange} targetable ${SearchType}].ID}
                    } else {
                        /varset PullMob ${NearestSpawn[${l}, npc loc ${PullPathArrayX[${k}]} ${PullPathArrayY[${k}]} radius ${PullRange} zradius ${MaxZRange} targetable ${SearchType}].ID}
                    }
                    DEBUGPULL FindMobAdvPath 1: WP: ${k} MobID ${PullMob} LOS ${LineOfSight[${PullPathArrayY[${k}]},${PullPathArrayX[${k}]},${PullPathArrayZ[${k}]}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}]} YXZ ${PullPathArrayY[${k}]},${PullPathArrayX[${k}]},${PullPathArrayZ[${k}]}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}
                    DEBUGPULL FindMobAdvPath 1.0: WP: ${k} MobID ${PullMob} UseWaypointZ: ${UseWayPointZ} WP Z: ${PullPathArrayZ[${k}]} Spawn Z: ${Spawn[id ${PullMob}].Z} Distance From Z: ${Math.Distance[${PullPathArrayZ[${k}]}:${Spawn[id ${PullMob}].Z}]}
                    /if (${DebugPull}) /delay 1
                    /if (${PullMob} && ${LineOfSight[${PullPathArrayY[${k}]},${PullPathArrayX[${k}]},${PullPathArrayZ[${k}]}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}]}) {
                        /varset DistanceCheck ${Math.Distance[${PullPathArrayY[${k}]},${PullPathArrayX[${k}]},${PullPathArrayZ[${k}]}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}]}
                        /if (${k}<${PullPathWpCount}) {
                            /varcalc i ${k}+1
                            /while (${i}<=${PullPathWpCount} && ${DistanceCheck}>${Math.Distance[${PullPathArrayY[${i}]},${PullPathArrayX[${i}]},${PullPathArrayZ[${i}]}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}]}) {
                                /varset DistanceCheck ${Math.Distance[${PullPathArrayY[${i}]},${PullPathArrayX[${i}]},${PullPathArrayZ[${i}]}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}]}
                                /varset k ${i}
                                /varcalc i ${i}+1
                            }
                        }
                        DEBUGPULL FindMobAdvPath: WP ${k} MobCount ${l} ${WPMobCount}
                        /varset PullMobName ${Spawn[id ${PullMob}].CleanName}
                        /varset PullMobDistance ${Math.Distance[${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X}:${PullPathArrayY[${k}]},${PullPathArrayX[${k}]}]}
                        /varcalc AdvpathPointNum ${k}
                        /varset AdvpathPointX ${PullPathArrayX[${k}]}
                        /varset AdvpathPointY ${PullPathArrayY[${k}]}
                        /varset AdvpathPointZ ${PullPathArrayZ[${k}]}
                        DEBUGPULL FindMobAdvPath 2: WP: ${k} Pullmob ${PullMob} Waypoint: ${AdvpathPointNum} XY: ${PullPathArrayX[${k}]} ${PullPathArrayY[${k}]} ${Math.Distance[${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X}:${AdvpathPointY},${AdvpathPointX}]}<${PullRange}
                        DEBUGPULL FindMobAdvPath 2: AdvPull: Pullmob: ${PullMobName} ID ${PullMob} Waypoint: ${PullPathWpCount} XY: ${PullPathArrayX[${k}]} ${PullPathArrayY[${k}]}
                        /call PullValidate ${PullMob} ${PFlag} FROMHERE
                        /varset PullMobValid ${Macro.Return.Equal[1]}
                        /if (${PullMobValid}) {
							POPCALL
							/return ${PullMob}
						}
                    }
                /next l
            }
        /next k
        /varset PullMob 0
		POPCALL
        DEBUGPULL FindMobAdvPath: Mob Not Found. AdvPull: ReadyToPullFlag: ${PFlag} Role: ${Role} ID: ${PullMob} PullRange: ${PullRange}
        DEBUGPULL FindMobAdvPath: ReadyToPullFlag: ${PFlag} Leave
        | Check for mobs in max pull radius for normal,MQ2nav pulling
    /return 0
	
| -----------------------------------------------------------------------------------------------------------
| SUB: Find Mob Using LOS.
| -----------------------------------------------------------------------------------------------------------
    Sub FindMobLOS(int PFlag, int BCount, int ECount, PRole, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare i int local
        /declare p int local
        /declare PullMobName string local 0
        /declare PullMobValid int local 0
        DEBUGPULL FindMobLOS Enter from ${FromWhere} - ${PFlag}
        /for i ${BCount} to ${ECount}
            DEBUGPULL FindMobLOS 1.0:  ReadyToPullFlag: ${PFlag} Pullcount: ${ECount}
            /varset PullMob ${NearestSpawn[${i}, npc los loc ${CampXLoc} ${CampYLoc} radius ${WorkingMaxRadius} zradius ${MaxZRange} targetable noalert 1].ID}
            /if (${PullMob}) /varset PullMobName ${Spawn[id ${PullMob}].CleanName}
            DEBUGPULL FindMobLOS: ReadyToPullFlag: ${PFlag} Normal Name: ${PullMobName} ID: ${PullMob} LOS: ${LineOfSight[${CampYLoc},${CampXLoc},${CampZLoc}:${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X},${Spawn[id ${PullMob}].Z}]}
            /varset PullMobValid 0
            /if (${PullMob}) {
                /call PullValidate ${PullMob} ${PFlag} FROMHERE
                DEBUGPULL FindMobLOS: ${i}.${PullMob} Macro.Return ${Macro.Return}
                /if (${Macro.Return.Equal[1]}) {
                    /varset PullMobValid 1
                    /varset ChainPullTemp ${PullMob}
                }
            }
            /if (${PullMobValid}) {
				POPCALL
				/return ${PullMob}
			}
        /next i
        /varset PullMob 0
		
		POPCALL
        DEBUGPULL FindMobLOS: ReadyToPullFlag: ${PFlag} Leave
    /return ${PullMob}
	
| -----------------------------------------------------------------------------------------------------------
| SUB: Find Mob Using Navigation.
| -----------------------------------------------------------------------------------------------------------
    Sub FindMobNAV(int PFlag, int BCount, int MobsInRadius, string PRole, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare p int local
        /declare PullMobName string local 0
        /declare PullMobValid int local 0
        /declare MobID          int     local   0
        /declare PathLength     float   local   0
        /declare MobIDDistance  float   local   0
        /declare PathCount      int     local   1
        /declare PathShortest   float   local   0

        /if (!${BCount}) /varset BCount 1

        DEBUGPULL FindMobNAV Enter from ${FromWhere} - ${PFlag} ${MobID}
        /for p ${BCount} to ${MobsInRadius}
            DEBUGPULL FindMobNAV: ${PRole} ${Spawn[id ${MobID}].Distance} ${PathShortest} ${PathCount}
            /if (${PRole.Find[hunter]}) {
                /varset MobID ${NearestSpawn[${p}, npc loc ${CampXLoc} ${CampYLoc} radius ${WorkingMaxRadius} zradius ${MaxZRange} targetable ${SearchType}].ID}
            } else {
                /varset MobID ${NearestSpawn[${p}, npc loc ${CampXLoc} ${CampYLoc} radius ${WorkingMaxRadius} zradius ${MaxZRange} targetable ${SearchType}].ID}
            }
			DEBUGPULL FindMobNav: PFlag ${PFlag} p ${p} MobsInRadius ${MobsInRadius} MobID ${MobID} MobName ${Spawn[id ${MobID}].CleanName} working radius ${WorkingMaxRadius} zradius ${MaxZRange} SearchType ${SearchType}
            /if (${Spawn[id ${MobID}].Distance}>${PathShortest} && ${PathCount}>1) {
                /continue
            }
            
            DEBUGPULL FindMobNAV: Call PullValidate ${MobID} ${PFlag}
            /call PullValidate ${MobID} ${PFlag} FROMHERE
            DEBUGPULL FindMobNAV: ${p}.${MobID} Macro.Return ${Macro.Return}
            /if (${Macro.Return.NotEqual[1]}) {
                DEBUGPULL FindMobNAV: ${MobID} not valid pull ${Macro.Return}
                /continue
            }

            /varset PathLength ${Navigation.PathLength[id ${MobID}]}
			
			| Geometry plays a role here, and often when we get closer to a mob the path is found. The pull code should be able to make decisions. We may run past this
			| mob and agro it, so we had best include it here to make the best possible decision.
			/if (${PathLength}<0.01) {
				DEBUGPULL Bad path length returned for ${MobID}. Navigation.PathLength ${PathLength}. Mesh may need to be updated, or mob is in an enclosed space. Using spawn distance.
				/varset PathLength ${Spawn[id ${MobID}].Distance3D}
			}
			
			| Leaving this alone for now.
            DEBUGPULL FindMobNAV: Sorting Mobs by nav pathlength
            /if (${PathLength} > 0) {
                /varset ChainPullTemp ${MobID}
                DEBUGPULL FindMobNAV: ${MobID} Valid pull - ${PathLength} 
                /if (${PathCount}==1) {
                    /varset PullMob ${MobID}
                    /varset PathShortest ${PathLength}
                } else /if (${PathLength} < ${PathShortest}) {
                    /varset PullMob ${MobID}
                    /varset PathShortest ${PathLength}
                }
                /varcalc PathCount ${PathCount}+1 
            } else /if (${PullWith.Equal[Pet]}) {
                /varset PullMob ${MobID}
                /varset PathShortest ${Spawn[id ${MobID}].Distance}			
			} else {
                DEBUGPULL FindMobNAV: ${MobID} not valid pull - ${PathLength}
            }
        /next p
        /if (${PullMob}) {
            /varset PullMobName ${Spawn[id ${PullMob}].CleanName}
        } else {
            /varset PullMob 0
            /varset PullMobName
        }
		POPCALL
        DEBUGPULL FindMobNAV: ${PullMob} PullMobName ${PullMobName} ReadyToPullFlag: ${PFlag} Leave
    /return ${PullMob}

| -------------------------------------------------------------------------------------
| SUB: FindMobOnReturn
| -------------------------------------------------------------------------------------
    Sub FindMobOnReturn(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGPULL Enter from ${FromWhere}

        /while (1) {
            /varset PullMob 0
            /call DoWeMove 0 FROMHERE
            /if (!${PullMob}) {
                /break
            } else {
                /call PullCheck FROMHERE
                /if (${Math.Distance[${CampYLoc},${CampXLoc}]} < 16) /break
            }
        }
		POPCALL
    /return

| -----------------------------------------------------------------------------------------------------------
| SUB: ORIGINALFindMobToPull(int ReadyToPullFlag) (NEW VERSION) ReadyToPullFlag 1 - Find mob and pull  0 - Check to see if there is a mob
| -----------------------------------------------------------------------------------------------------------
    Sub ORIGINALFindMobToPull(int ReadyToPullFlag, int Piterations, string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL Enter from ${FromWhere}

        DEBUGPULL FindMobToPull PreCheck ${DMZ} ${Me.InInstance} ${ReadyToPullFlag} Pulled: ${Pulled} ${AggroTargetID} ${ChainPull} Invis: ${Me.Invis} ${PullHold} ${DPSPaused} ${Me.Buff[Resurrection Sickness].ID} ${Me.Buff[Revival Sickness].ID}
        /if ((${DMZ} && ${Me.InInstance}==FALSE) || (${ReadyToPullFlag} && (!${Select[${Role},PULLER_ROLES]} && !${PullManual})) || (!${ReadyToPullFlag} && (!${Select[${Role},PULLER_ROLES]} && !${PullManual})) || ${Pulled} || (${AggroTargetID} && !${ChainPull})) {
			POPCALL
			/return 0
		}
        DEBUGPULL FindMobToPull Precheck 2
		/if (${Me.Invis} || ${PullHold} || ${DPSPaused} || ${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID}) {
			POPCALL
			/return 0
		}
        /if (${PullWith.Equal[pet]} && !${Pet.ID}) {
            /if (!${SpamTimer1}) {
                /echo \awAKA: \ayHow can you pull with a pet when you don't have one?
                /varset SpamTimer1 60s
                POPCALL
                /return
            }
        }
		DEBUGPULL FindMobToPull Precheck 3
        /if (${CheckOnReturn} && ${ReadyToPullFlag}) /varset CheckOnReturn 0
		DEBUGPULL FindMobToPull Calling Mobradar pull 0 FindMobToPull
		/call MobRadar xtar 0 FROMHERE
		DEBUGPULL FindMobToPull Return from MobRadar ${MobCount}
        /if (${ChainPull} && (${MobCount}>1 || ${Me.XTarget[${XTSlot2}].ID})) {
			POPCALL
			/return 0
		}
        /if (${ReadyToPullFlag}) {
            /if (${ChainPull}) {
                /if (${Target.ID}==${Me.ID}) {
					/call TargetThis
                }
				DEBUGPULL FindMobToPull Checking Pull Wait Conditions
                /if (${Me.XTarget[${XTSlot}].ID} && ((!${MyTargetID} && !${Target.ID}) || ${Target.PctHPs}>=${ChainPullHP} || (${MyTargetID} && ${Spawn[id ${MyTargetID}].PctHPs}>=${ChainPullHP}))) {
					POPCALL
					/return 0
				}
                /if (${Math.Distance[${CampYLoc},${CampXLoc}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}>75) {
					POPCALL
					/return 0
				}
				DEBUGPULL FindMobToPull Finished Checking Pull Wait Condition
            }
        }
        /if (${ReadyToPullFlag} && ((!${Select[${Role},PULLER_ROLES]} && !${PullManual}) || ${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID} || ${IAmDead})) {
			POPCALL
			/return 0
		}
        |/if (${ReadyToPullFlag} && ${PetRampPullWait} && !${Me.CombatState.Equal[COMBAT]} && ${Select[${Role},pullerpettank]} && ${Select[${Me.Class.ShortName},MAG,NEC,BST]}) /call CheckRampPets
        /if (${ReadyToPullFlag} && ${PetRampPullWait} && !${Me.CombatState.Equal[COMBAT]} && ${Select[${Me.Class.ShortName},MAG,NEC,BST]}) /call CheckRampPets FROMHERE

        DEBUGPULL FindMobToPull Enter PullRangeSet ${ReadyToPullFlag}
        /call PullRangeSet FROMHERE
        /doevents
        /declare BeginSearchX    int    local 0
        /declare MobsNearCamp    int    local
        /declare MobsToPullList  int    local
        /declare MobsReturnCheck int    local 0
        /declare PullAttempts    int    local 3
        /declare PullCount       int    local
        /declare LastCount       int    local 1
        /declare Pindex          int    local 1
        /declare PTempRadius     int    local 0
        /declare vstStr1         string local
        /varset Pulling 0
        /call GroupWatch 0 FROMHERE
        /if (${PullHold}) {
			POPCALL
			/return 0
		}
        /if (!${Piterations}) /varset Piterations 1
        /if (${ReadyToPullFlag}) {
            /if (!${FailCounter}) /echo Looking for Close Range Mobs
        } else {
            /if (!${SpamTimer}) {
                /echo Checking for Close Range Mobs
                /varset SpamTimer 50
            }
        }
        | Clear alert list 1, add mobs to ignore alert list1, set timer to keep alert list manageable for pulling no alert 1
        /if (!${PullAlertTimer}) {
            /varset PullIgnore1 null
            | Add Ignore Mob list to alert list
            /call AlertAddToList 1 "${MobsToIgnore}" "null"
            /varset PullAlertTimer 5m
        } else {
            /call PullIgnoreCheck 1 c
        }
        | Advpath searches for mobs along the path using Pullwith radius not Maxradius
        | FindAdvPath Routine searches and returns first valid mob along path.
        | Does not require additional code for searching.
        /if (${PullMoveUse.Equal[advpath]}) {
            /call FindMobAdvPath ${ReadyToPullFlag} FROMHERE
			POPCALL
            /return ${Macro.Return}
        }
        /if (${PullMoveUse.Equal[nav]}) {
            /varset vstStr1 npc loc ${CampXLoc} ${CampYLoc}
        } else {
            /if (${Select[${Role},hunter,hunterpettank]}) {
                /varset vstStr1 npc
            } else {
                /varset vstStr1 npc los loc ${CampXLoc} ${CampYLoc}
            }
        }

        |To keep from taking to long to find the next mob. Have the search break the area into smaller sizes.
        |PullAttempts=3 All mobs in MaxRange. PullAttempts=1 Use range that will find 25 mobs at a time.
        /if (${SpawnCount[${vstStr1} radius ${MaxRadius} zradius ${MaxZRange} targetable ${SearchType}]}>${PullMaxCount}) /varset PullAttempts 1
        /while (1) {
			/call LastMove
            /varset PullCount 0
            /varset Pindex 1
            /varset Piterations 1
            /if (${PullAttempts}<3) {
                /varcalc MobsReturnCheck ${PullAttempts}*25
            } else {
                /varset MobsReturnCheck 10000
            }
            /while (!${PullCount} && (${Pindex}<=${Piterations})) {
                /if (${Pindex}==${Piterations}) {
                    /varset PTempRadius ${MaxRadius}
                    /varcalc Pindex ${Piterations}+1
                } else {
                    /varcalc PTempRadius (${MaxRadius}/${Piterations})*${Pindex}
                    /varcalc Pindex ${Pindex}+1
                }
                /varset PullCount ${SpawnCount[${vstStr1} radius ${PTempRadius} zradius ${MaxZRange} targetable ${SearchType}]}
                /if (${PullCount}>${MobsReturnCheck}) {
                    /varcalc Piterations ${Piterations}+1
                    /varcalc Pindex ${Pindex}-1
                    /varset PullCount 0
                    /continue
                }
                /varset MobsNearCamp ${SpawnCount[${vstStr1} radius ${MeleeDistance} zradius ${MaxZRange} targetable ${SearchType}]}
                DEBUGPULL FindMobToPull: Checking to temp radius \at${PTempRadius}\ax and found \at${PullCount}\ax mobs \at${Pindex} - ${Piterations}\ax 
            }
            /if (${Bool[${Plugin[MQ2Map]}]}) /squelch /mapfilter SpellRadius ${PTempRadius}
            DEBUGPULL FindMobToPull ReadyToPullFlag:${ReadyToPullFlag} Pullcount: ${LastCount} : ${PullCount} MobsNearCamp: ${MobsNearCamp} Pull How: ${PullMoveUse} Attempt: ${PullAttempts} Search Type: ${SearchType}
            /if (!${ReadyToPullFlag}) { 
                | Are we Chain Pulling and Last Mob Pulled still out of melee range?
                /if (${PullCount}>0 && ${Spawn[id ${LastMobPullID}].Distance}>=${MeleeDistance}) {
					POPCALL
					/return 0
				}
                | We are chain Pulling so recalc PullCount based on PullCount - Mobs in MelleDistance.
                /varcalc PullCount ${PullCount}-${MobsNearCamp}
            }
            | If PullCount is NOT zero then lets find a valid mob to pull.
            /if (${PullCount}) {
                /if (!${ReadyToPullFlag} && ${MobsNearCamp}) {
                    /if (${LastCount}<2) {
                        /varset BeginSearchX 2
                    } else {
                        /varset BeginSearchX ${LastCount}
                    }
                } else {
                    /varset BeginSearchX ${LastCount}
                }
                /if (${PullMoveUse.Equal[nav]}) {
                    /if (${Select[${Role},hunter,hunterpettank]}==0 || ${PullManual}) {
                        /call FindMobNAV ${ReadyToPullFlag} ${BeginSearchX} ${PullCount} NULL FROMHERE
                    } else {
                        /call FindMobNAV ${ReadyToPullFlag} ${BeginSearchX} ${PullCount} hunter FROMHERE
                    }
                } else /if (${PullMoveUse.Equal[los]}) {
                    /call FindMobLOS ${ReadyToPullFlag} ${BeginSearchX} ${PullCount} NULL FROMHERE
                }
                /varset LastCount ${PullCount}
                /if (!${PullMob}) /varset ChainPullTemp 0
            } else {
                | There were no mobs to pull based on PullCount.
                /varset ChainPullTemp 0
                /varset PullMob 0
                /break
            }
            /if (${PullAttempts}==3 || ${PullMob}) /break
            /varcalc PullAttempts ${PullAttempts}+1
        }
		POPCALL
        DEBUGPULL FindMobToPull: ReadyToPullFlag: ${ReadyToPullFlag} Name: ${Spawn[id ${PullMob}].CleanName} MobID: ${PullMob} PullCount: ${PullCount}
        DEBUGPULL FindMobToPull Leave
    /return ${PullMob}
	


| -----------------------------------------------------------------------------------------------------------
| SUB: FindMobToPull(int ReadyToPullFlag) (NEW VERSION) ReadyToPullFlag 1 - Find mob and pull  0 - Check to see if there is a mob
| -----------------------------------------------------------------------------------------------------------
    Sub FindMobToPull(int ReadyToPullFlag, int Piterations, string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL Enter from ${FromWhere}

        DEBUGPULL FindMobToPull PreCheck ${DMZ} ${Me.InInstance} ${ReadyToPullFlag} Pulled: ${Pulled} ${AggroTargetID} ${ChainPull} Invis: ${Me.Invis} ${PullHold} ${DPSPaused} ${Me.Buff[Resurrection Sickness].ID} ${Me.Buff[Revival Sickness].ID}
        /if ((${DMZ} && ${Me.InInstance}==FALSE) || (${ReadyToPullFlag} && (!${Select[${Role},PULLER_ROLES]} && !${PullManual})) || (!${ReadyToPullFlag} && (!${Select[${Role},PULLER_ROLES]} && !${PullManual})) || ${Pulled} || (${AggroTargetID} && !${ChainPull})) {
			POPCALL
			/return 0
		}
        DEBUGPULL FindMobToPull Precheck 2
		/if (${Me.Invis} || ${PullHold} || ${DPSPaused} || ${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID}) {
			POPCALL
			/return 0
		}
        /if (${PullWith.Equal[pet]} && !${Pet.ID}) {
            /if (!${SpamTimer1}) {
                /echo \awAKA: \ayHow can you pull with a pet when you don't have one?
                /varset SpamTimer1 60s
                POPCALL
                /return
            }
        }
		DEBUGPULL FindMobToPull Precheck 3
        /if (${CheckOnReturn} && ${ReadyToPullFlag}) /varset CheckOnReturn 0
		DEBUGPULL FindMobToPull Calling Mobradar pull 0 FindMobToPull
		/call MobRadar xtar 0 FROMHERE
		DEBUGPULL FindMobToPull Return from MobRadar ${MobCount}
        /if (${ChainPull} && (${MobCount}>1 || ${Me.XTarget[${XTSlot2}].ID})) {
			POPCALL
			/return 0
		}
        /if (${ReadyToPullFlag}) {
            /if (${ChainPull}) {
                /if (${Target.ID}==${Me.ID}) {
					/call TargetThis
                }
				DEBUGPULL FindMobToPull Checking Pull Wait Conditions
                /if (${Me.XTarget[${XTSlot}].ID} && ((!${MyTargetID} && !${Target.ID}) || ${Target.PctHPs}>=${ChainPullHP} || (${MyTargetID} && ${Spawn[id ${MyTargetID}].PctHPs}>=${ChainPullHP}))) {
					POPCALL
					/return 0
				}
                /if (${Math.Distance[${CampYLoc},${CampXLoc}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}>75) {
					POPCALL
					/return 0
				}
				DEBUGPULL FindMobToPull Finished Checking Pull Wait Condition
            }
        }
        /if (${ReadyToPullFlag} && ((!${Select[${Role},PULLER_ROLES]} && !${PullManual}) || ${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID} || ${IAmDead})) {
			POPCALL
			/return 0
		}
        |/if (${ReadyToPullFlag} && ${PetRampPullWait} && !${Me.CombatState.Equal[COMBAT]} && ${Select[${Role},pullerpettank]} && ${Select[${Me.Class.ShortName},MAG,NEC,BST]}) /call CheckRampPets
        /if (${ReadyToPullFlag} && ${PetRampPullWait} && !${Me.CombatState.Equal[COMBAT]} && ${Select[${Me.Class.ShortName},MAG,NEC,BST]}) /call CheckRampPets FROMHERE

        DEBUGPULL FindMobToPull Enter PullRangeSet ${ReadyToPullFlag}
        /call PullRangeSet FROMHERE
        /doevents
        /declare BeginSearchX    int    local 0
        /declare MobsNearCamp    int    local
        /declare MobsToPullList  int    local
        /declare MobsReturnCheck int    local 5
        /declare PullAttempts    int    local 3
        /declare PullCount       int    local
        /declare LastCount       int    local 1
        /declare Pindex          int    local 1
        /declare PTempRadius     int    local 0
        /declare vstStr1         string local
        /declare NearestMobDist  int    local
        /declare Radii           int    local

        /varset WorkingMaxRadius ${MaxRadius}
        /varset Pulling 0
        /call GroupWatch 0 FROMHERE
        /if (${PullHold}) {
			POPCALL
			/return 0
		}

        /if (!${Piterations}) /varset Piterations 1
        
        /if (${ReadyToPullFlag}) {
            /if (!${FailCounter}) /echo Looking for Close Range Mobs
        } else {
            /if (!${SpamTimer}) {
                /echo Checking for Close Range Mobs
                /varset SpamTimer 50
            }
        }

        | Clear alert list 1, add mobs to ignore alert list1, set timer to keep alert list manageable for pulling no alert 1
        /if (!${PullAlertTimer}) {
            /varset PullIgnore1 null
            | Add Ignore Mob list to alert list
            /call AlertAddToList 1 "${MobsToIgnore}" "null"
            /varset PullAlertTimer 5m
        } else {
            /call PullIgnoreCheck 1 c
        }

        | Advpath searches for mobs along the path using Pullwith radius not Maxradius
        | FindAdvPath Routine searches and returns first valid mob along path.
        | Does not require additional code for searching.
        /if (${PullMoveUse.Equal[advpath]}) {
            /call FindMobAdvPath ${ReadyToPullFlag} FROMHERE
			POPCALL
            /return ${Macro.Return}
        }

        /if (${PullMoveUse.Equal[nav]}) {
            /varset vstStr1 npc loc ${CampXLoc} ${CampYLoc}
        } else {
            /if (${Select[${Role},hunter,hunterpettank]}) {
                /varset vstStr1 npc
            } else {
                /varset vstStr1 npc los loc ${CampXLoc} ${CampYLoc}
            }
        }

        |To keep from taking to long to find the next mob. Have the search break the area into smaller sizes.
        |PullAttempts=3 All mobs in MaxRange. PullAttempts=1 Use range that will find 25 mobs at a time.

        | Going to start with MaxRadius and handle it in ever widening proportions until we get mobs.

        | We will find the first mob, get it's range, then add.

        /if (${SpawnCount[${vstStr1} radius ${MaxRadius} zradius ${MaxZRange} targetable ${SearchType}]}>${PullMaxCount}) /varset PullAttempts 1

        /varset NearestMobDist ${NearestSpawn[1,${vstStr1} radius ${MaxRadius} zradius ${MaxZRange} targetable ${SearchType}].Distance}
        /varcalc Radii ${Int[${Math.Abs[${Math.Calc[(${MaxRadius}-${NearestMobDist})/100]}]}]}
        /while (1) {
			/call LastMove
            /varset PullCount 0
            /varset Piterations 1

            /while (${Piterations}<=${Radii}) {
                /varcalc PTempRadius ${NearestMobDist}+${Piterations}*100

                /varset PullCount ${SpawnCount[${vstStr1} radius ${PTempRadius} zradius ${MaxZRange} targetable ${SearchType}]}
                DEBUGPULL FindMobToPull: Pull Attempt ${PullAttempts} Radii ${Radii} Checking to temp radius \at${PTempRadius}\ax and found \at${PullCount}\ax mobs \at${Piterations}\ax 
                /if (${PullCount}>=${MobsReturnCheck}) {
                    /varset WorkingMaxRadius ${PTempRadius}
                    /break
                }
                /varcalc Piterations ${Piterations}+1
            }

            /if (${Bool[${Plugin[MQ2Map]}]}) /squelch /mapfilter SpellRadius ${PTempRadius}

            /varset MobsNearCamp ${SpawnCount[${vstStr1} radius ${MeleeDistance} zradius ${MaxZRange} targetable ${SearchType}]}
            DEBUGPULL FindMobToPull ReadyToPullFlag:${ReadyToPullFlag} Pullcount: ${LastCount} : ${PullCount} MobsNearCamp: ${MobsNearCamp} Pull How: ${PullMoveUse} Attempt: ${PullAttempts} Search Type: ${SearchType}
            /if (!${ReadyToPullFlag}) { 
                | Are we Chain Pulling and Last Mob Pulled still out of melee range?
                /if (${PullCount}>0 && ${Spawn[id ${LastMobPullID}].Distance}>=${MeleeDistance}) {
					POPCALL
					/return 0
				}
                | We are chain Pulling so recalc PullCount based on PullCount - Mobs in MelleDistance.
                /varcalc PullCount ${PullCount}-${MobsNearCamp}
            }
            | If PullCount is NOT zero then lets find a valid mob to pull.
            /if (${PullCount}) {
                /if (!${ReadyToPullFlag} && ${MobsNearCamp}) {
                    /if (${LastCount}<2) {
                        /varset BeginSearchX 2
                    } else {
                        /varset BeginSearchX ${LastCount}
                    }
                } else {
                    /varset BeginSearchX ${LastCount}
                }
                /if (${PullMoveUse.Equal[nav]}) {
                    /if (${Select[${Role},hunter,hunterpettank]}==0 || ${PullManual}) {
                        /call FindMobNAV ${ReadyToPullFlag} ${BeginSearchX} ${PullCount} NULL FROMHERE
                    } else {
                        /call FindMobNAV ${ReadyToPullFlag} ${BeginSearchX} ${PullCount} hunter FROMHERE
                    }
                } else /if (${PullMoveUse.Equal[los]}) {
                    /call FindMobLOS ${ReadyToPullFlag} ${BeginSearchX} ${PullCount} NULL FROMHERE
                }
                /varset LastCount ${PullCount}
                /if (!${PullMob}) /varset ChainPullTemp 0
            } else {
                | There were no mobs to pull based on PullCount.
                /varset ChainPullTemp 0
                /varset PullMob 0
                /break
            }
            /if (${PullAttempts}>${Radii} || ${PullMob}) /break
            /varcalc PullAttempts ${PullAttempts}+1
        }
		POPCALL
        DEBUGPULL FindMobToPull: ReadyToPullFlag: ${ReadyToPullFlag} Name: ${Spawn[id ${PullMob}].CleanName} MobID: ${PullMob} PullCount: ${PullCount}
        DEBUGPULL FindMobToPull Leave
    /return ${PullMob}
	
| -------------------------------------------------------------------------------------
| Sub:Pull
| -------------------------------------------------------------------------------------
    Sub Pull(string FromWhere)
        /if (${DMZ} && ${Me.InInstance}==FALSE) /return
        /if (${Select[${Role},PULLER_ROLES]}==0 && !${PullManual}) /return
        /if (!${Pulling}) /return
        /if (${DPSPaused} || ${Me.Invis}) /return
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL Pull Enter from ${FromWhere}

        /if (${PullHoldCond}) {
            /if (!${SpamTimer1}) {
                /echo Holding Pulls Due to Pull Hold Condition.
                /varset SpamTimer1 50
            }
			POPCALL
            /return 0
        }
        /declare PullAttempts       int    local 0
        /declare StuckCount         int    local 0
        /declare PullDist           float  local ${PullRange}
        /declare AdvpathPaused      int    local 0
        /declare WPCurrent          int    local 0
        /declare AdvpathDirection   string local
        /declare X1                 int    local
        /declare Y1                 int    local
        /declare X2                 int    local
        /declare Y2                 int    local
        /declare AdjustHeadingTimer timer  local 0
        /declare WasInRange         int    local 0
        /declare PullStatusFlag     int    local 0
        /declare ReturnStat         string local 0
        /varset Pulled 0
        /varset PullTooFar 0
        /varset PullTimer 50
        /varset CantHit 0
        /varset ToClose 0
        | PullStatusFlag: 1-Normal Pull, 2-You are OOR Mob may be pullable, 3-Mob is OOR and may be pullable, 4-Don't even try pulling the mob.
        
        DEBUGPULL Pull: PullWith: ${PullWith} PullDist: ${PullDist} PullUsing: ${PullMoveUse}
        DEBUGPULL Check Ability: AggroTargetID ${AggroTargetID} PullAggroTargetID ${PullAggroTargetID} ChainPull ${ChainPull} PullWithMeleePetRanged? ${Select[${PullWith},Melee,Pet,Ranged]} Spell ready? ${Me.SpellReady[${PullWith}]} AA ready? ${Me.AltAbilityReady[${PullWith}]} CombatAbility Ready? ${Me.CombatAbilityReady[${PullWith}]} Item ready? ${Me.ItemReady[${PullWith}]} PullWith ${PullWith} PullWithRanged? ${PullWith.Equal[Ranged]} Ranged Ready? ${Me.RangedReady}
        | Set autofire setting off during pulls if not using ranged item to pull
        /if (${Me.AutoFire}) /autofire
        /if (${IAmABard}) {
            /if (!${PullTwistOn} && ${Twist}) /call CastBardCheck FROMHERE 0
        }
        /if (!${Me.Mount.ID} && (${Me.Sitting} || ${Me.Feigning})) /stand
		
        /if (${Select[${Role},pullerpettank]} && ${PullRoleToggle} && ${Group.Puller.ID}!=${Me.ID}) {
            /if (${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X},${Spawn[id ${MyTargetID}].Z}:${CampYLoc},${CampXLoc},${CampZLoc}]}>${CampRadius}) /call PullModeToggle TurnOn FROMHERE
        }
		
        /varset BeginMobID ${Me.XTarget[${XTSlot}].ID}
		DEBUGPULL Top of Pull While loop. BeginMobID ${BeginMobID} which is from XTSlot ${XTSlot} for some reason
        /while (1) {
			/call LastMove
            /varset PullStatusFlag 1
            /varset ReturnStat 0
            /doevents
            /if (${CorpseRecoveryOn}) {
                /if (!${DragCorpse} && ${SpawnCount[pccorpse ${Me} radius ${MaxRadius}]}) {
                    /call GrabCorpse 1
                    /if (${DragCorpse}) {
                        POPCALL
                        /return dcbtc
                    }
                }
            }
            /if (${DPSPaused}) {
				POPCALL
				/return
			}
            | vars used to determine if we are stuck
            /varset X1 ${Int[${Me.X}]}
            /varset Y1 ${Int[${Me.Y}]}
            /if (${PullAggroTargetID}) {
                DEBUGPULL Pulling 1.1
                /varset Pulled 1
                /varset MyTargetID ${AggroTargetID}
                /varset MyTargetName ${Spawn[id ${AggroTargetID}].CleanName}
                /call StopMoving
                DEBUGPULL Pull Aggro detected
                /break
            }
            | Exit pull and reset if timed out or wandered too far from camp
            DEBUGPULL Pulling 1.2 PullTimer: ${PullTimer} CampDistance: ${Math.Distance[${CampYLoc},${CampXLoc}]} CampDistance3D: ${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]} CampMaxRadius: ${Math.Calc[${MaxRadius}*.90]} PullAttempts: ${PullAttempts} MyTargetName: ${Spawn[id ${MyTargetID}].CleanName} MyTargetID: ${Spawn[id ${MyTargetID}].ID}  Target LOS: ${Spawn[id ${MyTargetID}].LineOfSight} TargetDistance: ${Spawn[id ${MyTargetID}].Distance}
            /if (${PullTimer}==0 || (${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]} >= ${Math.Calc[${MaxRadius}*.90]}) || (${PullAttempts}>=7 && !${Spawn[id ${MyTargetID}].LineOfSight} && !${Select[${Role},pettank,pullerpettank,hunter,hunterpettank]}) || !${Spawn[id ${MyTargetID}].ID} || ${PullAttempts}>=100) {
                /if (${MyTargetID}) {
					/call PullIgnoreCheck ${MyTargetID} a pull1
					/echo Ran out of time on pull, mob wandered away, or we were asked to return to camp.
				}
                DEBUGPULL Pull: Adding ${Spawn[id ${MyTargetID}].CleanName} ID: ${MyTargetID} to temp ignore list
                DEBUGPULL Pull: Done Pulling-Timer expired, Mob unreachable or exceeded max pull radius.
                /varset ReturnStat btcr
                /break
            }
            /if (((${AggroTargetID} && !${ChainPull}) || (${Me.XTarget[${XTSlot2}].ID} && ${ChainPull})) && ${Math.Distance[${CampYLoc},${CampXLoc}]} < ${CampRadius}) {
                /echo Looks like mobs in camp aborting pull.
                /call PullReset FROMHERE
                DEBUGPULL Pull Mobs in camp detected
				POPCALL
                /return micd
            }
            /if (${PullWith.Equal[Ranged]}) {
                /call PullWithRanged ${PullDist} 0 FROMHERE
            }
            | - Filter to prevent pulling until AA/Disc/Spell/Item is ready.
            DEBUGPULL Pull Starting PullDist ${PullDist} PullMoveUse ${PullMoveUse} MobID ${MyTargetID} Distance to mob ${Spawn[id ${MyTargetID}].Distance}
            /varset PullAttempts 0
            | Set group role puller to adjust for merc running up while pulling if soloing
            /if (${Group}==1 && !${Group.Puller.Name.Equal[${Me}]} && (${Select[${Role},PULLER_ROLES]} || ${PullManual}) && ${Spawn[=${MainAssist}].Type.Equal[Mercenary]}) /call AssignGroupRole set "${Me.CleanName}" 3
            /while (1) {
                DEBUGPULL In the While loop MobID ${MyTargetID} Distance ${Spawn[id ${MyTargetID}].Distance}
				/call LastMove
|------------------------------------------------------------------------Pull Begin Move-------------------------------------------------------------------------------------------|
				/if ((${Spawn[id ${MyTargetID}].Distance3D}>${PullDist} || !${Spawn[id ${MyTargetID}].LineOfSight}) && ${Math.Distance[${Me.Y},${Me.X},${Me.Z}:${CampYLoc},${CampXLoc},${CampZLoc}]}<${MaxRadius}) {				
|------------------------------------------------------------------------Pet Pull Exception----------------------------------------------------------------------------------------|
					DEBUGPULL Spawn is outside my PullDist or I dont have LOS, and, I'm within MaxRadius ${MaxRadius}
                    | But... if we are using a pet, we don't care about LOS as long as we are in range.
					/if (${Spawn[id ${MyTargetID}].Distance3D}<=${Math.Calc[${PullDist}*.95]} && ${PullWith.Equal[pet]}) {
                        DEBUGPULL I'm a pet wrangler. The spawn is within my pulldist, but I must not have LOS. That's ok. Breaking out of while loop.
                        /varset PullStatusFlag 2
						/break
					}
|------------------------------------------------------------------------MQ2AdvPath-------------------------------------------------------------------------------------------|
                    | Advpath pull does not use max pull radius. It uses pullwith radius
                    /if (${PullMoveUse.Equal[advpath]}) {
                        /call PullUsingAdvPath ${MyTargetID} ${PullDist}
                        /if (${Macro.Return.Equal[btcr]}) {
                            /varset ReturnStat btcr
                            /varset PullStatusFlag 2
                            /break
                        }
                        /if (!${MyTargetID}) {
							POPCALL
							/return 0
						}
|------------------------------------------------------------------------MQ2Nav-------------------------------------------------------------------------------------------|
                    } else /if (${PullMoveUse.Equal[nav]}) {
                        DEBUGPULL I am using PullUsingNav to get closer to target ${MyTargetID} PullDist ${PullDist}, now it's ${Target.Distance} away.
                        | Get a little closer so the pull margin is narrower and we are more likely to pull successfully.
                        /call PullUsingNav ${MyTargetID} ${Math.Calc[${PullDist}*0.95]} FROMHERE
                        DEBUGPULL Just got back from PullUsingNav Target ${MyTargetID} PullDist ${PullDist}, now ${Spawn[id ${MyTargetID}].Distance} away.
                        /if (${Macro.Return.Equal[huntpr]}) {
							POPCALL
                            /return 0
                        } else /if (${Macro.Return.Equal[btcr]}) {
                            /varset ReturnStat btcr
                            /varset PullStatusFlag 2
                            /break
                        } else /if (${Macro.Return.Equal[dcbtc]}) {
							POPCALL
                            /return dcbtc
                        }
|------------------------------------------------------------------------LOS-------------------------------------------------------------------------------------------|
                    | We are pulling by LOS.
                    } else /if (${Spawn[id ${MyTargetID}].LineOfSight}) {
                        /if (${Me.FeetWet}) {
                            /if (${X2}==0) /varcalc PullDist ${PullDist}-(${Spawn[id ${MyTargetID}].Distance3D}-${Spawn[id ${MyTargetID}].Distance})
                            /moveto id ${MyTargetID} mdist ${PullDist} uw
                        } else {
                            /moveto id ${MyTargetID} mdist ${PullDist}
                        }
                        /delay 10
                        /varset X2 ${Int[${Me.X}]}
                        /varset Y2 ${Int[${Me.Y}]}
                        DEBUGPULL Pull LOS ${Spawn[id ${MyTargetID}].LineOfSight} ${PullDist}
|------------------------------------------------------------------------Mob OOR Return to Camp-------------------------------------------------------------------------------------------|
                    } else {
                        /if (${X2}!=0) {
                            /if (${Math.Distance[${Me.Y},${Me.X}:${Y2},${X2}]}>200 || ${PullTimer}==0) {
                                /echo Mob is no Longer in LOS. Returning to Camp.
                                /if (${MoveTo.Moving}) /moveto off
                                /varset ReturnStat btcr
                                /varset PullStatusFlag 4
                                /break
                            } else /if ((!${Me.Moving} || !${MoveTo.Moving}) && ${PullDist}<${Spawn[id ${MyTargetID}].Distance}) {
                                /if (${Me.FeetWet}) {
                                    /moveto id ${MyTargetID} mdist ${PullDist} uw
                                } else {
                                    /moveto id ${MyTargetID} mdist ${PullDist}
                                }
                                /delay 10
                            }
                        }
                        DEBUGPULL Pull NO-LOS ${Spawn[id ${MyTargetID}].LineOfSight} ${Spawn[id ${MyTargetID}].Distance3D} ${PullDist}
                    }
                } else /if (${Spawn[id ${MyTargetID}].Distance3D}<=${PullDist} && (${Spawn[id ${MyTargetID}].LineOfSight} || ${PullWith.Equal[Pet]})) {
                    DEBUGPULL I'm a pet wrangler and the target is in range and I have LOS. Breaking out of while loop.
                    /varset PullStatusFlag 2
                    | This turns into a circular loop if the mob is close and in camp to begin with. Commenting break to allow rest of pull procedure to occur.
                    |/break
                } else /if (${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X},${Spawn[id ${MyTargetID}].Z}:${CampYLoc},${CampXLoc},${CampZLoc}]}>${Math.Calc[${MaxRadius}+${PullRange}]}) {
                    /varset PullStatusFlag 4
                    /varset ReturnStat btcr
                    /break                
                }
|------------------------------------------------------------------------End Pull Move-------------------------------------------------------------------------------------------|
                /if (${Pulled} || ${PullAggroTargetID}) /break
                /if (${Spawn[id ${MyTargetID}].Distance3D}<=${PullDist} && (${Target.FeetWet}==${Me.FeetWet} || ${PullWith.Equal[pet]})) /varset WasInRange 1
                /varset CantSee 0
                /doevents
                | Pull counter used to in conjunction with 1s delay for timing
                /varcalc PullAttempts ${PullAttempts}+1
                |Checking to see if you are far from camp to try and fix the exceed to far from camp check.
                /if (${Select[${PullMoveUse},los,nav]}>0) {
                    |Have I ran to far from camp?
                    /if (${Math.Distance[${CampYLoc},${CampXLoc},${CampZLoc}]}>=${Math.Calc[${MaxRadius}*.90]}) {
                        /if (${Spawn[id ${MyTargetID}].Distance3D}<=${PullDist} && (${Spawn[id ${MyTargetID}].LineOfSight} || ${PullWith.Equal[pet]})) {
                            /varset PullStatusFlag 2
                        } else {
                            /varset PullStatusFlag 4
                        }
                        /varset ReturnStat btcr
                        /break
                    }
                    | Extending PullTimer if moving closer or target moving && !${Select[${Role},hunter]}
                    /if (${PullMoveUse.Equal[nav]}) {
                        /if ((${Navigation.Active} || ${MoveTo.Moving} || (${Spawn[id ${MyTargetID}].Speed}>25 && ${Spawn[id ${MyTargetID}].Distance3D}>${PullRange}))) /varcalc PullTimer ${PullTimer}+50
                    } else /if (${PullMoveUse.Equal[los]} && !${Select[${Role},hunter,hunterpettank]}) {
                        /if ((${Me.Moving} || ${MoveTo.Moving} || (${Spawn[id ${MyTargetID}].Speed}>25 && ${Spawn[id ${MyTargetID}].Distance3D}>${PullRange}))) /varcalc PullTimer ${PullTimer}+50
                    }
                    | Try and pull again after 7 seconds or 3 seconds if target is moving
                    /if (${PullAttempts}>=7) {
                        | Make range smaller to creep closer to mob if not los
                        /if (${Spawn[id ${MyTargetID}].Distance3D}<=${PullDist} && (!${Spawn[id ${MyTargetID}].LineOfSight} && ${PullWith.NotEqual[pet]})) /varcalc PullDist ${PullDist}*.6
                        DEBUGPULL Pull PullDist: ${PullDist} - PullLoops: ${PullAttempts} LineOfSight: ${Spawn[id ${MyTargetID}].LineOfSight}
                        /break
                    } else /if (${PullAttempts}>=3 && ${Spawn[id ${MyTargetID}].Speed}>25 && ${WasInRange} && ${Spawn[id ${MyTargetID}].Distance3D}>${PullDist}) {
                        | Make range smaller to creep closer to mob if Mob is Moving
                        /varcalc PullDist ${PullDist}*.6
                        /varset WasInRange 0
                        DEBUGPULL Pull PullDist: ${PullDist}*.6 - PullLoops: ${PullAttempts}
                        /break
                    }
                }
                /if (${DPSPaused}) {
					POPCALL
					/return
				}
                | 1s timer used in conjunction with PullAttempts to control pulling
                /delay 10
|------------------------------------------------------------------------Are We Stuck-------------------------------------------------------------------------------------------|
                | - Check to see if we are stuck
                /if ((${Int[${Me.X}]}==${X1}) && (${Int[${Me.Y}]}==${Y1})) {
                    /varcalc StuckCount (${StuckCount})+1
                    /if (${StuckCount}>=2) {
                        /if (${IAmDead} || ${Me.Hovering}) {
                            /call Stopmoving
							POPCALL
                            /return
                        } else {
                            /call Stuck FROMHERE
                        }
                    }
                    /if (${StuckCount}>=7 && !${PullAggroTargetID}) {
                        /echo I am stuck aborting pull
                        /call StopMoving
                        /varset ReturnStat btcr
                        /varset PullStatusFlag 4
                        /break
                    }
                }
|------------------------------------------------------------------------Are We Stuck End-------------------------------------------------------------------------------------------|
                DEBUGPULL Pull Loop Count: ${PullAttempts} ${Me.Moving} ${MoveTo.Moving} ${Me.Speed} ${Spawn[id ${MyTargetID}].Distance3D} ${PullRange} ${PullDist}
                | Not using advpath
                /if (${Select[${PullMoveUse},los,nav]}>0) {
                    | Distance loop check until mob in range to pull
                    /if ((${Spawn[id ${MyTargetID}].Distance3D}>${PullRange} || !${Spawn[id ${MyTargetID}].LineOfSight} || ${Target.FeetWet}!=${Me.FeetWet}) && !${PullAggroTargetID}) {
                        /if (${PullWith.NotEqual[pet]} || ${Spawn[id ${MyTargetID}].Distance3D}>${PullRange}) {
                        /if (!${Me.Moving} || ${WasInRange}) /varcalc PullDist ${PullDist}*.8
                            DEBUGPULL Pull Decrease pull distance to ${PullDist}
                            /continue
                        }
                    } else /if (${PullAggroTargetID}) {
                        /break
                    }
                }
                /varset PullStatusFlag 2
                /break
            | end of Inner /while loop.
            }
            /if (${Pulled} || ${PullAggroTargetID}) /break
            |/echo Pull Stat: ${ReturnStat} ${Spawn[id ${MyTargetID}].LineOfSight} ${PullStatusFlag} ${PullWith}
            | Back To Camp Reset was flaged, but if target is not LOS, there is no reason to try and pull it. 
            /if (${ReturnStat.Equal[btcr]}) {
                /if (${PullStatusFlag}==4) /break
                /if (${PullWith.NotEqual[pet]}) {
                    /if (!${Spawn[id ${MyTargetID}].LineOfSight}) /break
                } else {
                    /if (${Spawn[id ${MyTargetID}].Distance3D}>${PullRange}) /break
                }
            }
            | We are not close enough to the mob to pull
            /if (${PullStatusFlag}==1) /continue
            | We are in pull range and have LOS.
			| We aren't in pull range from 2x the distance... are we?
            /if (${Spawn[id ${MyTargetID}].ID} && (${Target.FeetWet}==${Me.FeetWet} || ${PullWith.Equal[pet]}) && !${PullAggroTargetID} && (${Spawn[id ${MyTargetID}].Distance3D}<${PullRange} || (${PullWith.Equal[Melee]} && ${Spawn[id ${MyTargetID}].Distance3D}<${Math.Calc[${PullRange}*2]}))) {
                /if (${PullMoveUse.Equal[advpath]}) /varset WasInRange 1
                /call StopMoving
                | Target mob before Aggroing
				/call TargetThis ${MyTargetID}
				
				| This is hosing up pull with pet due to distance calculation.
                | Validate target one more time before pulling
                |/call ValidateTarget
                |/if (${ValidTarget}==0) {
                |    /echo Aborting Pull! Target invalid now! Reason:${Macro.Return}
                |    /varset ReturnStat btcr
                |    /break
                |}
                |/if (${CalmOn}) {
                |    /call PullCalmCheck ${Target.ID} ${CalmRadius}
                |}
				
                /if (${PullWith.Equal[Ranged]} && ${Spawn[id ${MyTargetID}].Distance3D}<30) /varset ToClose 1
|------------------------------------------------------------------------Pull with Melee-------------------------------------------------------------------------------------------|
                | Handle pulling with Melee setting
                /if (${PullWith.Equal[Melee]} || (${PullWithAlt.Equal[Melee]} && ${ToClose} && !${Select[${Role},hunter,hunterpettank]})) {
                    /call PullWithMelee FROMHERE
|------------------------------------------------------------------------Pull with Ranged-------------------------------------------------------------------------------------------|
                | Pull with ranged
                } else /if (${PullWith.Equal[Ranged]} && !${ToClose}) {
                    /call PullWithRanged ${PullDist} 1 FROMHERE
                    /if (${Macro.Return}>=1) /varset PullDist ${Int[${Macro.Return}]}
|------------------------------------------------------------------------Pull with Pet-------------------------------------------------------------------------------------------|
                | Pull with pet
                } else /if (${PullWith.Equal[Pet]}) {
                    DEBUGPULL Calling PullWithPet Target: ${Target.ID} PullDist: ${PullDist} Distance To Mob: ${Target.Distance}
                    /call PullWithPet ${Target.ID} ${PullDist} FROMHERE
|------------------------------------------------------------------------Pull with Cast-------------------------------------------------------------------------------------------|
                | Pull with cast
                } else {
                    /call PullWithCast ${PullDist} FROMHERE
                    /if (${Macro.Return}>=1) {
                        /varset PullDist ${Int[${Macro.Return}]}
                        |/continue
                    }
                }
|------------------------------------------------------------------------Pull with End-------------------------------------------------------------------------------------------|
                |- Toggle puller mode off if option enabled.
                /if ((${Select[${Role},pullerpettank]} || (${PullManual} && ${PullWith.Equal[pet]})) && ${PullRoleToggle} && ${Group.Puller.ID}==${Me.ID}) /call PullModeToggle TurnOff FROMHERE
            } else /if (${PullAggroTargetID}) {
                | The else /if fixes when puller stalls because puller grabs aggro with out getting to pull.
                /varset Pulled 1
            } else /if (${PullStatusFlag}==3) {
                /break
            }
            | If pull failed start over while timer > 0
            /if (${Select[${PullMoveUse},los,nav]}>0 && !${Pulled}) /continue
            /break
        | end of outer /while loop
        }
        | reset mq2moveutils dist back to 10 from pull distance to ensure correct movement
        /moveto dist 10
        /if (!${Pulled} && ${PullAggroTargetID}) {
            /varset Pulled 1
            /varset ReturnStat 0
        }
        /if (${PullWith.Equal[Ranged]}) {
            /call PullWithRanged ${PullDist} 2 FROMHERE
        }
        /varset Pulling 0
        /if (${ReturnStat.Equal[btcr]}) {
            /if (${MyTargetID}) {
                /call PullIgnoreCheck ${MyTargetID} a pull2
				/echo Back to reset camp for some reason. We had a mob selected.
                /varset MyTargetID 0
            } else /if (${Target.ID}) {
                /call PullIgnoreCheck ${Target.ID} a pull3
				/echo Back to reset camp for some reason. We had a mob targetted.
				/call TargetThis
            }
            /if (!${PullOnReturn}) {
                /call BackToCampReset FROMHERE
                /if (${Macro.Return}) {
					POPCALL
					/return 0
				}
            } else {
				POPCALL
                /return oor
            }
        }
        DEBUGPULL Pull Done Pulling ${ReturnToCamp} ${Pulled} ${PullAggroTargetID}
        /if (${ReturnToCamp}) {
            /if (${Pulled}) {
                /call DoWeMove 1 FROMHERE
                /if (${Macro.Return.Equal[iad]}) {
					POPCALL
					/return IAD 
				}
                /if (!${Me.Running}) /nomodkey /keypress RUN_WALK
                /if (${Macro.Return.Equal[lma]}) {
                    /varset Pulled 0
                    /echo Returned To Pull: lma 
					POPCALL
                    /return lma
                }
                /call WaitForMob FROMHERE
                /if (${Target.ID} && ${FaceMobOn}==3) /face fast nolook
                /varset Pulled 0
            } else {
                /call DoWeMove 1 FROMHERE
            }
        }
		POPCALL
        DEBUGPULL Pull Leave Mob ID:${Spawn[id ${MyTargetID}].ID}
    /return
	
|--------------------------------------------------------------------------------------
| SUB: PullCalmCheck
|--------------------------------------------------------------------------------------
    Sub PullCalmCheck(int PCCTarget, int PCCRadius)
        /if (!${PCCRadius}) /varset PCCRadius 50
    /return
	
| -----------------------------------------------------------------------------------------------------------
| SUB: PullCheck PullMob is Mob ID of mob to pull.
| -----------------------------------------------------------------------------------------------------------
    Sub PullCheck(string FromWhere)
        /if (${PullHold} || ${DPSPaused} || ${Me.Buff[Resurrection Sickness].ID} || ${Me.Buff[Revival Sickness].ID} || ${CampZone}!=${Zone.ID} || ${Me.Invis}) /return 0

		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return 0

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullCheck Enter from ${FromWhere} - ${PullMob}
        DEBUGPULL PullCheck: 1.0: Name: ${Spawn[id ${PullMob}].CleanName} MobID: ${PullMob} ${PullMoveUse}

        |Conditions too stringent
        |/call IsGroupReady FROMHERE
        |/if (!${Macro.Return.Equal[1]}) {
        |    /call PullReset FROMHERE
        |    POPCALL
        |    /return 0
        |}

        /if (${ChainPull}==2) /varset ChainPull 1
        /if (${PullOnReturn} && ${CheckOnReturn}) /varset CheckOnReturn 0
        /if (${PullMob} && ${Select[${PullMoveUse},los,nav]}>=1 && (${Spawn[id ${PullMob}].Distance3D}<=360 || ${Spawn[id ${PullMob}].LineOfSight})) {
			/call TargetThis ${PullMob}
        }
        /if (${PullMob} && ${Spawn[id ${PullMob}].ID}) {
            /varset Pulling 1
            | Advpath skill validate mob
            /if (${PullMoveUse.Equal[advpath]}) {
				/call TargetSet ${PullMob}
                | Is mob really in range. check for spawn lag
                /if (${Math.Distance[${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X}:${AdvpathPointY},${AdvpathPointX}]}>${PullRange}) {
                    /call PullIgnoreCheck ${PullMob} a
                    /echo Mob is OOR after targeting. Trying Again. ${PullMob} ${Math.Distance[${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X}:${AdvpathPointY},${AdvpathPointX}]} ${PullRange} - ${AdvpathPointY} ${AdvpathPointX}
					/call TargetThis
                    /varset Pulling 0
					POPCALL
                    /return 0
                }
            }

            | This looks redundant because we just checked it while selecting a mob to pull
            |/call ValidateTarget ${PullMob} FROMHERE
            DEBUGPULL PullCheck: Target: ${Spawn[id ${PullMob}].CleanName} Valid: ${ValidTarget} MacReturn ${Macro.Return}
            |/if (${ValidTarget}==0) {
			|	/echo Target ${Spawn[id ${PullMob}].CleanName} not valid because ${Macro.Return}. Adding to pull ignore list.
            |    /call PullIgnoreCheck ${PullMob} a "PullChecknav${Macro.Return}"
			|	/call TargetThis
            |    /varset Pulling 0
			|	POPCALL
            |    /return 0
			|}

            | Wandered away?
			/if (${Target.ID} && ${Select[${PullMoveUse},los,nav]}>=1 && ${Math.Distance[${Target.Y},${Target.X}:${CampYLoc},${CampXLoc}]}>${MaxRadius}) {
				/echo Target not valid because its too far away. Adding to pull ignore list.
                /call PullIgnoreCheck ${PullMob} a "PullChecknav${Macro.Return}"
				/call TargetThis
                /varset Pulling 0
				POPCALL
                /return 0
            }
            /varcalc ColorIdx ${Select[${Spawn[id ${PullMob}].ConColor.Replace[ ,_]},grey,green,light_blue,blue,white,yellow,red]}+1
            /varset ConColor ${ColorList.Mid[${ColorIdx},1]}
            /if (${BroadCastSay.Equal[bc]}) {
                /call BroadCast t "PULLING-> [+${ConColor}+]${Spawn[id ${PullMob}].CleanName}[+t+] <- ID:${PullMob} at ${Int[${Math.Distance[${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X}:${CampYLoc},${CampXLoc}]}]} feet."
            } else {
                /if (${ConColor.EqualCS[W]}) /varset ConColor -${ConColor.Lower}
                /call BroadCast t "PULLING-> \a${ConColor}${Spawn[id ${PullMob}].CleanName}\at <- ID:${PullMob} at ${Int[${Math.Distance[${Spawn[id ${PullMob}].Y},${Spawn[id ${PullMob}].X}:${CampYLoc},${CampXLoc}]}]} feet."
            }
            /varset MyTargetID ${PullMob}
            /varset MyTargetName ${Spawn[id ${PullMob}].CleanName}
            /if (${Pulling} && ${MyTargetID}) {
                /while (1) {
                    /if (${PullWith.Equal[Pet]} && ${Pet.ID}) {
                        /if (${Pet.Combat}) /call PetBackOff FROMHERE
                        /if (${Pet.Stance.NotEqual[FOLLOW]}) /pet follow
                    } else /if (${PullWith.Equal[melee]}) {
                        /varcalc PullRange ${Spawn[id ${MyTargetID}].MaxRangeTo}*.90
                    }
                    /if (${Target.ID} && ${Target.ID}!=${PullMob}) {
                        /if (${Me.Combat}) /attack off
						/call TargetThis
					}
                    /call Pull
                    /varset Pulled 0
                    /if (${PullPause.Arg[1,|].NotEqual[0]}) /varset PullWaitTimer2 ${Math.Calc[${PullPause.Arg[2,"|"]}+1]}m
                    /if (${Macro.Return.Equal[oor]}) {
                        /varset CheckOnReturn 1
						POPCALL
                        /return oor
                    } else /if (${Macro.Return.Equal[lma]}) {
                        |/echo I got here2: ${MyTargetID} ${PullMob} ${Pulling} ${Pulled}
                        /varset Pulling 1
                        /continue
                    } else /if (${Macro.Return.Equal[dcbtc]} || ${Macro.Return.Equal[micd]}) {
                        /varset Pulling 0
                        /if (${ReturnToCamp}) /call DoWeMove 1 FROMHERE
                    } else /if (${Macro.Return.Equal[iad]}) {
                        /doevents
						POPCALL
                        /return IAD
                    } else {
						POPCALL
                        /return 0
                    }
                    /break
                }
            }
        } else /if (!${PullMob}) {
            /varcalc FailCounter ${FailCounter}+1
            DEBUGPULL PullCheck: No Valid Target in Range ${MaxRadius} - ${FailCounter} Time(s)
            /if (${FailCounter}>=${FailMax}) {
                /call AlertClearList 1 PullCheck
                /varset FailCounter 0
                /varset PullAlertTimer 0
                /if (${Select[${Role},hunter,hunterpettank]} && ${Math.Distance[${CampYLoc},${CampXLoc}]} > 15) {
                    DEBUGPULL PullCheck Returning hunter to camp
                    /echo ${Role}: There are no mobs within ${MaxRadius} trying to return to camp.
                    /call DoWeMove 1 FROMHERE
                }
                /if (${PullWait} && !${AggroTargetID}) {
                    /call BroadCast t "PULLING-> Waiting ${PullWait} seconds for mobs to respawn."
                    /call PullDelay ${PullWait}
                }
				POPCALL
                /return 0
            }
        }
		POPCALL
        DEBUGPULL PullCheck:  Leave
    /return 0
	
| -------------------------------------------------------------------------------------
| SUB: PullDelay
| -------------------------------------------------------------------------------------
    Sub PullDelay(int TimerAmount,string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullDelay from ${FromWhere} - ${TimerAmount} Enter
        /declare PDTimer        timer   local   ${TimerAmount}s
        /declare RandTimeAdj    int     local   0
        /varset Pulling 0
        /varset Pulled 0

        /call LastMove
        /varcalc RandTimeAdj ${Math.Calc[7+${Math.Rand[5]}].Int}
        /while (${PDTimer} && !${AggroTargetID}) {
            /doevents
            /if (!${Me.Sitting} && !${Me.Mount.ID} && !${IAmABard}) {
		        /if (${TimeSinceMove}>${RandTimeAdj} && ((${Select[MANA_CLASSES,${Me.Class.ShortName}]} && ${Me.PctMana}<85) || (${Select[ENDURANCE_CLASSES,${Me.Class.ShortName}]} && ${Me.PctEndurance}<85) || ${Me.PctHPs}<85)) {
			        /sit
		        }
            }
            /delay 5
            DOPARSE
        }
        /if (${Me.Sitting} && !${Me.Mount.ID}) /stand
        /if (${AggroTargetID}) {
            /if (${DPSOn} || ${MeleeOn}) {
                /call CheckForCombat 0 FROMHERE-1 0
            } else {
                /call CheckForCombat 1 FROMHERE-2 0
            }
        }
		POPCALL
        DEBUGPULL PullDelay Leave
    /return
	
|--------------------------------------------------------------------------------------
| SUB: PullIgnoreCheck
|--------------------------------------------------------------------------------------
    Sub PullIgnoreCheck(string mobID, string Action, string sentFrom)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        /declare k int     local     0
        /if (${Int[${mobID}]}<1) /return
        /if (${Action.Equal[a]}) {
            /if (!${PullIgnore1.Find[|${mobID}]}) {
                /if (${SearchType.Equal[noalert 1]}) /squelch /alert add 1 id ${mobID}
                /varset PullIgnore1 ${PullIgnore1}|${mobID}
                /echo Added ${mobID} to ignore pull list. ${PullIgnore1} ${sentFrom}
            }
        } else /if (${Action.Equal[d]}) {
            /if (!${PullIgnore1.Find[|${mobID}]}) {
                /varset PullIgnore1 ${PullIgnore1.Replace[|${mobID},]}
                /if (${SearchType.Equal[noalert 1]}) /squelch /alert remove 1 id ${mobID}
            }
        } else /if (${Action.Equal[c]}) {
            /varset k 1
            /while (${PullIgnore1.Arg[${k},|].Length} && ${PullIgnore1.Find[|]} && ${PullIgnore1.NotEqual[null]}) {
                DEBUGPULL PullIgnore: ${PullIgnore1} Count: ${k} Arg: ${PullIgnore1.Arg[${k},|]}
                /if ((!${Spawn[id ${PullIgnore1.Arg[${k},|]}].ID} || ${Spawn[${PullIgnore1.Arg[${k},|]}].Type.Equal[Corpse]}) && ${PullIgnore1.Arg[${k},|].NotEqual[null]}) {
                    /varset PullIgnore1 ${PullIgnore1.Replace[|${PullIgnore1.Arg[${k},|]},]}
                    /if (${SearchType.Equal[noalert 1]}) /squelch /alert remove 1 id ${PullIgnore1.Arg[${k},|]}
                } else {
                    /varcalc k ${k}+1
                }
            }
        }
    /return
	
| -------------------------------------------------------------------------------------
| SUB: PullModeToggle
| -------------------------------------------------------------------------------------
    Sub PullModeToggle(ToggleState,string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL Enter from ${FromWhere}

        /if (!${Select[${Me},${Group.Leader}]} || !${SpawnCount[group mercenary]}) {
			POPCALL
			/return
		}
        /if (${ToggleState.Equal[TurnOn]}) {
            /while (${Target.Distance}>${CampRadius} && ${Group.Puller.ID}!=${Me.ID}) {
                /if (${Group.Puller.ID}!=${Me.ID}) /grouproles set ${Me.CleanName} 3
                /delay 10 ${Group.Puller.ID}==${Me.ID}
                /if (${Group.Puller.ID}==${Me.ID}) /echo + You have been set to be group puller.
            }
        } else /if (${ToggleState.Equal[TurnOff]}) {
            /while (${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}>${CampRadius} || ${Group.Puller.ID}==${Me.ID}) {
                /if (${Group.Puller.ID}==${Me.ID} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}<=${CampRadius}) {
                    DEBUGPULL KICKIT! (${Group.Puller.ID}==${Me.ID} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}<=${CampRadius})
                    /if (${Group.Puller.ID}==${Me.ID}) /grouproles unset ${Me.CleanName} 3
                } else {
                    /if (${Group.Puller.ID}==${Me.ID} && ${Math.Distance[${Me.Y},${Me.X}:${CampYLoc},${CampXLoc}]}>${CampRadius}) /moveto loc ${CampYLoc} ${CampXLoc} mdist 10
                }
                /delay 10 ${Group.Puller.ID}!=${Me.ID}
                /if (${Group.Puller.ID}!=${Me.ID}) /echo + You are no longer group puller.
            }
        }
		POPCALL
    /return
		
| ---------------------------------------------------------------------------
| Sub PullNearestValidMob
| ---------------------------------------------------------------------------
	Sub PullNearestValidMob(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        | Conditions too stringent
        |/call IsGroupReady FROMHERE
        |/if (!${Macro.Return.Equal[1]}) {
        |    POPCALL
        |    /return 0
        |}

		DEBUGPULL Starting pull routines from ${FromWhere}

        /if (${If[${PullHoldCond},0,1]} && !${DragCorpse}) {
            /if (${Select[${PullWith},Melee,Pet]} || ${Select[TRUE,${Me.SpellReady[${PullWith}]},${Me.AltAbilityReady[${PullWith}]},${Me.CombatAbilityReady[${PullWith}]},${Me.ItemReady[${PullWith}]},${If[${PullWith.Equal[Ranged]} && ${Me.RangedReady},TRUE,FALSE]}]}) {
                /if (!${PullMob}) /call FindMobToPull 1 1 FROMHERE
                /call PullCheck FROMHERE
                /varset PullMob 0
                /if (${PullOnReturn} && ${Macro.Return.Equal[oor]}) /call FindMobOnReturn FROMHERE
                /if (${DragCorpse}) {
                    POPCALL
                    /return
                }
            } else {
                /if (!${SpamTimer1}) {
                    /echo Holding Pulls. PullWith ${PullWith} is not ready.
                    /varset SpamTimer1 50
                }
            }
        } else {
            /if (!${SpamTimer1}) {
                /if (!${DragCorpse}) {
                    /echo Holding Pulls Due to Pull Hold Condition.
                } else {
                    /echo Holding Pulls Due to Dragging Corpse Back to Camp.
                    /if (!${SpawnCount[pccorpse ${Me} radius 89]}) {
                        /call PullReset FROMHERE
                        POPCALL
                        /return
                    }
                }
                /varset SpamTimer1 50
            }
        }

		DEBUGPULL Leaving pull routines

		POPCALL
	/return

| -------------------------------------------------------------------------------------
| SUB: PullRangeSet
| -------------------------------------------------------------------------------------
    Sub PullRangeSet(string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullRange Enter from ${FromWhere}

        /declare PullItemRange int local
        /if (${FindItemCount[=${PullWith.Arg[1,|]}]} && ${Redguides}) {
            /if (${Select[${FindItem[=${PullWith.Arg[1,|]}].Type},Archery,Throwing,Throwingv1,Throwingv2,ammo]}) {
                /varset PullItem ${PullWith.Arg[1,|]}
                /varset PullItemRange ${FindItem[=${PullWith.Arg[1,|]}].Range}
                /if (!${PullItemRange}) /varset PullItemRange 50
                /if (${FindItem[=${PullWith.Arg[2,|]}].WornSlot[ammo]} && ${FindItemCount[=${PullWith.Arg[2,|]}]}) {
                    /varset PullAmmo ${PullWith.Arg[2,|]}
                    | If pullitem is a bow add arrow range to bow for total range
                    /if (${FindItem[=${PullWith.Arg[1,|]}].Type.Equal[Archery]}) {
                        /varcalc PullItemRange ${PullItemRange}+${FindItem[=${PullWith.Arg[2,|]}].Range}
                    }
                    /call PullVars ${Math.Calc[${PullItemRange}*(${PullRadiusToUse}/100)]} Ranged ${PullItemRange}
                } else {
                    /echo I can't find any ammo defaulting to Melee for PullWith
                    /varset PullWith Melee
                    /call PullVars 15 Melee 15
                }
                DEBUGPULL PullWith=(${PullWith}) PullItem=(${PullItem}) PullItemRange=(${PullItemRange}) PullItemCount=(${FindItemCount[=${PullWith.Arg[1,|]}]}) PullAmmo=(${PullAmmo})
            } else /if (${FindItemCount[=${PullWith}]} && !${PullWith.Arg[2,|].Length}) {
                /varset PullItemRange ${FindItem[=${PullWith}].Spell.Range}
                /call PullVars ${Math.Calc[${PullItemRange}*(${PullRadiusToUse}/100)]} "${PullWith}" ${PullItemRange}
            }
        } else /if (${Me.CombatAbility[${PullWith}]} || ${Me.Book[${PullWith}]} || ${Me.AltAbility[${PullWith}]}) {
            /if (${Me.AltAbility[${PullWith}]}) {
                DEBUGPULL ${Math.Calc[${Me.AltAbility[${PullWith}].Spell.Range}*(${PullRadiusToUse}/100)]} "${PullWith}" ${Me.AltAbility[${PullWith}].Spell.Range}
                /call PullVars ${Math.Calc[${Me.AltAbility[${PullWith}].Spell.Range}*(${PullRadiusToUse}/100)]} "${PullWith}" ${Me.AltAbility[${PullWith}].Spell.Range}
            } else {
                DEBUGPULL ${Math.Calc[${Spell[${Spell[${PullWith}].ID}].MyRange}*(${PullRadiusToUse}/100)]} "${PullWith}" ${Spell[${PullWith}].MyRange}
                /call PullVars ${Math.Calc[${Spell[${PullWith}].MyRange}*(${PullRadiusToUse}/100)]} "${PullWith}" ${Spell[${PullWith}].MyRange}
            }
        } else /if (${PullWith.Equal[Pet]}) {
            /if (${Role.Equal[hunterpettank]}) {
                /call PullVars ${Math.Calc[${PetAttackRange}*.80]} Pet ${Math.Calc[${PetAttackRange}*.80]}
            } else {
				| Use PetAttackDistance
                |/call PullVars 185 Pet 185
				/call PullVars ${Math.Calc[${PetPullDistance}*.98]} Pet
            }
        } else /if (${PullWith.Equal[Melee]}) {
            /if (${PullPathWpCount} && ${PullMoveUse.Equal[advpath]}) {
                /beep
                /beep
                /beep
                /popup You can't pull with MQ2Advpath and Melee. Please change PullWith to a Spell/AA/Disc/Ranged Weapon.
                DEBUGPULL ${PullPathWpCount} && ${PullMoveUse.Equal[advpath]}
                /echo You can't pull with MQ2Advpath and Melee. Please change PullWith to a Spell/AA/Disc/Ranged Weapon.
                /endmac
            } else {
                /call PullVars 15 Melee 15
            }
        } else /if (!${Select[${PullWith},Ranged]}) {
            /echo Unknown PullWith setting. Please see Kiss Instructions.
        }
		POPCALL
        DEBUGPULL PullRange PullWith: ${PullWith} - CA:${Me.CombatAbility[${PullWith}]}/SPELL:${Me.Book[${PullWith}]}/ AA: ${Me.AltAbility[${PullWith}]}
        DEBUGPULL PullRange Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Reset Pull variables
| -------------------------------------------------------------------------------------
    Sub PullReset(string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullReset Enter from ${FromWhere}
        /moveto dist 10
        /varset Pulling 0
        /varset Pulled 0
        /varset MyTargetID 0
        /varset MyTargetName
        /varset ToClose 0
        /attack off
        /if (${MoveTo.Moving}) /moveto off
        /if (${PullMoveUse.Equal[nav]}) {
            /if (${Navigation.Active}) /squelch /nav stop
        }
        /varset WaitTimer 0
        /varset DragCorpse 0
		/call TargetThis
		POPCALL
        DEBUGPULL PullReset Leave
    /return
	
|-------------------------------------------------------------------------------------
| SUB: Pull Using AdvPath
| -------------------------------------------------------------------------------------
    Sub PullUsingAdvPath(int BeginMobAPID,float APPullDist, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare ReturnStat string local 0
        DEBUGPULL PullUsingAdvPath Enter from ${FromWhere}
        /if (${MoveTo.Moving}) /moveto off
        /play ${PullPath} nodoor smart normal
        DEBUGPULL PullUsingAdvPath /play ${PullPath} nodoor smart normal
        /while (1) {
			/call LastMove
			/doevents GotHit
			/doevents PleaseWaitListener
			/if (${PleaseWaitTimerOn}) /break
            /if (${DebugPull}) /delay 5
            DEBUGPULL PullUsingAdvPath /echo Waypoint: ${AdvPath.NextWaypoint} Target: ${Target.ID} MyTargetID: ${MyTargetID} Aggro: ${AggroTargetID} MobToWPDist: ${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${AdvpathPointY},${AdvpathPointX}]}<${APPullDist} MeToWPDist: ${Math.Distance[${Me.Y},${Me.X}:${AdvpathPointY},${AdvpathPointX}]}>50 WP<NWP: ${AdvPath.NextWaypoint}>=${AdvpathPointNum}
            | Do we have aggro?
            /if (${AggroTargetID}) /break
            | Has the mob move out of range from the original way point
            /if (${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${AdvpathPointY},${AdvpathPointX}]}>${APPullDist}) {
				POPCALL
				/return btcr
			}
            | Is mob within pull range and LOS
            /if (${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${Me.Y},${Me.X}]}<${APPullDist} && ${Spawn[id ${MyTargetID}].LineOfSight} && ${Target.FeetWet}==${Me.FeetWet}) /break
            | Stop at our waypoint
            /if (${AdvPath.NextWaypoint}>=${AdvpathPointNum} && ${Math.Distance[${Me.Y},${Me.X}:${AdvpathPointY},${AdvpathPointX}]}<=5) {
				POPCALL
				/return btcr
			}
        }
        /play off
		POPCALL
        DEBUGPULL PullUsingAdvPath /play ${PullPath} nodoor smart normal
        DEBUGPULL PullUsingAdvPath Leave ${AdvPath.NextWaypoint} ${ReturnStat}
    /return ${ReturnStat}
	
|-------------------------------------------------------------------------------------
| SUB: Pull Using MQ2Nav || (${Math.Distance[${CampYLoc},${CampXLoc}]}>=${PullNavDistance}) fix spwn dist from camp not mine.
| -------------------------------------------------------------------------------------
    Sub PullUsingNav(int MobNavID, int NavPullDist, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullUsingNav Enter from ${FromWhere} - Pulling ${Spawn[id ${MobNavID}].CleanName} ${NavPullDist} ${Spawn[id ${MobNavID}].Distance3D}
        /varset PullTimer 30
        /declare PullNavTimer 	timer 	local 	3m
		/declare NewMobNavID	string	local	0
		/declare CreepDistance	int		local	0
		/declare NearestMobID	string	local	0
		/declare HaveLOS		int		local	${Target.LineOfSight}
        /declare IgnorePullDist int     local   0
        /declare CalcPullTime   int     local   0
        /declare WhileLoops     int     local   0
        /declare NavParams      string  local

        /call TargetThis ${MobNavID}

		/varset PullNavDistance ${Navigation.PathLength[id ${MobNavID}]}
		
		| A nav path may not be available. We need to move until we get a bit closer for it to kick in, sometimes.
        /noparse /varset NavParams id ${MobNavID}
		/if (${PullNavDistance}<0.01) {
            DEBUGPULL No path found to spawn. Trying Loc
            /echo \awAKA: \ayCan't establish a pull path using spawn. Trying loc.
            /noparse /varset NavParams locyxz ${Spawn[${MobNavID}].Y} ${Spawn[${MobNavID}].X} ${Spawn[${MobNavID}].Z} 
            |/nav locxyz ${Spawn[${MobNavID}].X} ${Spawn[${MobNavID}].Y} ${Spawn[${MobNavID}].Z} distance=${Int[${Math.Calc[${NavPullDist}*.66]}]}
            |/delay 5
            |/while (${Me.Moving}) {
            |    /doevents GotHit
            |    /if (${AggroTargetID}) {
            |        POPCALL
            |        /return 0
            |    }                
            |    /delay 5
            |}
            |/varset PullNavDistance ${Navigation.PathLength[id ${MobNavID}]}
            |/if (${PullNavDistance}<0.01) {
            |    /call PullIgnoreCheck ${PullMob} a
            |    DEBUGPULL Couldn't find a path to ${Spawn[id ${MobNavID}].CleanName} ${MobNavID}
            |    /echo \awAKA: \ay May have to manually pull this mob ${Spawn[id ${MobNavID}].CleanName} ${MobNavID}
            |    POPCALL
            |    /return btcr
            |}
        }
		
        | This sets a condition to determine whether we should move camp.
        /if (${Math.Abs[${Math.Calc[${Spawn[id ${MobNavID}].Distance3D}-${NavPullDist}]}]}<${PullCampDistFromCamp}) {
            /varset IgnorePullDist 1
        }

        /while (1) {
            DEBUGPULL WhileLoops made ${WhileLoops}
            /varcalc WhileLoops ${WhileLoops}+1
			/call LastMove
            /doevents
			/if (${PleaseWaitTimerOn}) {
				DEBUGPULL PleaseWaitTimerOn. Leaving
				POPCALL
				/return 0
			}
		
			DEBUGPULL Moving to ${Spawn[id ${MobNavID}].CleanName} (${MobNavID}) Distance ${Spawn[id ${MobNavID}].Distance3D} Path Distance ${Navigation.PathLength[id ${MobNavID}]}
            /if (${Spawn[id ${MobNavID}].Distance3D}<${NavPullDist}) {
                /if (${PullWith.Equal[pet]} || (${PullWith.NotEqual[pet]} && ${Spawn[id ${MobNavID}].LineOfSight})) {
                    DEBUGPULL In pull range now. Leaving.
                    /if (${Navigation.Active}) /squelch /nav stop
                    POPCALL
                    /return 0
                }
            }
			/if (!${Navigation.Active}) /squelch /nav ${NavParams}

            DEBUGPULL Do I have a corpse?
            | Check if puller has corpse from dying on previous pull along path
            /if (${CorpseRecoveryOn}) {
                /if (!${DragCorpse} && ${SpawnCount[pccorpse ${Me} radius 95]}) {
                    /call GrabCorpse 2
                    /if (${DragCorpse}) {
                        DEBUGPULL PullUsingNav Leave found my cporse
						POPCALL
                        /return dcbtc
                    }
                }
            }
			
            | Corrects heading when mob is moving and your using Navigation.
            /if (${Spawn[id ${MobNavID}].Speed}>25) {
                DEBUGPULL Mob is moving.
                /if ((${Role.Equal[hunter]} || ${PullWith.Equal[melee]}) && ${Spawn[id ${MobNavID}].LineOfSight}) {
                    /if (!${Stick.Active} && ${Spawn[id ${MobNavID}].Distance3D}<20) {
						DEBUGPULL I'm a hunter or pulling with melee. Moving in closer to get the mob. Distance ${Spawn[id ${MobNavID}].Distance3D}
                        /if (${Navigation.Active}) /squelch /nav stop
                        /moveto id ${Target.ID} mdist ${NavPullDist}
                        /stick ${NavPullDist} id ${MobNavID}
						POPCALL
                        /return 0
                    }
                }
            }

            DEBUGPULL Checking for aggro
            | Check for Unexpected Aggro
            /if (!${ChainPull}) {
                /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
					DEBUGPULL Ran into a mob. Whoops.
					POPCALL
                    /return 0
                }
            } else {
                /if (${Me.XTarget[${XTSlot2}].ID}) {
					DEBUGPULL Chainpulling - Enough mobs. Leaving.
					POPCALL
					/return 0
				}
                /if (${Me.XTarget[${XTSlot}].ID} && ${Me.XTarget[${XTSlot}].ID}!=${BeginMobID}) {
					DEBUGPULL Chainpulling - Ran into another mob. Leaving.
					POPCALL
					/return 0
				}
            }				

            DEBUGPULL Should we bother checking for closer mobs or mobs in the way?
            | This process can take quite a bit of time, we should only use this if we need to travel a long distance...
            |/if (${Math.Abs[${Math.Calc[${Spawn[id ${MobNavID}].Distance3D}-${NavPullDist}]}]}>100) {

                | Let's see if another mob is closer, in case it moved or spawned or we just didn't see it due to LOS
                DEBUGPULL Checking if another mob is closer: FindMobToPull
                /call FindMobToPull 0 1 FROMHERE
                /varset NewMobNavID ${Macro.Return}
                
                DEBUGPULL Checking MobRadar
                | What's the id of the nearest mob to us
                /call MobRadar los 100 FROMHERE
                /varset NearestMobID ${Macro.Return}
                
                | It's a new target, and the radar and find say it's the same mob.
                /if (${NearestMobID}==${NewMobNavID}) {	
                    DEBUGPULL Checking if the results of FindMobToPull and MobRadar agree.		
                    /if (${NewMobNavID.NotEqual[${MobNavID}]} && ${NewMobNavID.Length} && ${NewMobNavID.NotEqual[NULL]} && ${NewMobNavID.NotEqual[0]}) {
                        /if (${Navigation.PathLength[id ${NewMobNavID}]}<${Navigation.PathLength[id ${MobNavID}]}) {
                            /if (${Navigation.Active}) /squelch /nav stop
                            /call TargetSet ${NewMobNavID}
                            /varset MobNavID ${NewMobNavID}
                            DEBUGPULL Found a new, closer mob. ${Spawn[id MobNavID].CleanName} (${MobNavID}) Distance ${Spawn[id ${MobNavID}].Distance3D} Path Distance ${Navigation.PathLength[id ${MobNavID}]}
                            /echo Found a closer target. Changing pull to > ${Spawn[id ${MobNavID}].CleanName} < (ID:${MobNavID})
                            /if (${Spawn[id ${MobNavID}].Distance3D}<=${NavPullDist}) {
                                /if (${Navigation.Active}) /squelch /nav stop
                                POPCALL
                                /return 0
                            }
                            | We need to do this in case we started with the loc param method
                            /noparse /varset NavParams id ${MobNavID}
                            /squelch /nav ${NavParams}
                            /continue
                        }
                    }
                } else {
                    DEBUGPULL Radar and FindMobToPull results don't match.
                    | Radar and findmob don't agree. It might be one we are ignoring or it just spawned. We will blunder into it if we don't deal with it.
                    /if (${NearestMobID.NotEqual[${MobNavID}]} && ${NearestMobID.Length} && ${NearestMobID.NotEqual[NULL]} && ${NearestMobID.NotEqual[0]}) {
                        /if (${Navigation.PathLength[id ${NearestMobID}]}<${Navigation.PathLength[id ${MobNavID}]}) {
                            DEBUGPULL Validating whether its a valid threat.
                            /call PullValidate ${NearestMobID} FROMHERE
                            /if (${Macro.Return.Equal[1]} || ${Macro.Return.Equal[PV_IGNORED_PULLLIST]}) {
                                /if (${Navigation.Active}) /squelch /nav stop
                                /call TargetSet ${NearestMobID}
                                /varset MobNavID ${NearestMobID}
                                DEBUGPULL Found a mob in the way. ${Spawn[id MobNavID].CleanName} (${MobNavID}) Distance ${Spawn[id ${MobNavID}].Distance3D} Path Distance ${Navigation.PathLength[id ${MobNavID}]}
                                /echo A mob is in the way. Changing pull to > ${Spawn[id ${MobNavID}].CleanName} < (ID:${NearestMobID})
                                /if (${Spawn[id ${MobNavID}].Distance3D}<=${NavPullDist}) {
                                    /if (${Navigation.Active}) /squelch /nav stop
                                    POPCALL
                                    /return 0
                                }						
                                | We need to do this in case we started with the loc param method
                                /noparse /varset NavParams id ${MobNavID}
                                /squelch /nav ${NavParams}
                                /continue
                            }
                        }
                    }				
                }
            |}

            DEBUGPULL Should we advance camp?		
			| Should we move camp?
			/while (${PullCampAdvanceOn} && !${IgnorePullDist}) {
                | If target is not LOS then this will happen. Try to get close to cast or body agro.
                /if (${PullWith.NotEqual[Pet]} && ${Navigation.PathLength[id ${MobNavID}]}<${PullCampDistToMob} && !${Spawn[id ${MobNavID}].LineOfSight} && ${Math.Distance[${CampYLoc},${CampXLoc}:${Me.Y},${Me.X}]}>${PullCampDistFromCamp}) {
                    /echo Mob near, I can't see it. Moving group to me so we can creep up on it.
                    /if (${Navigation.Active}) /squelch /nav stop
                    /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
                        POPCALL
                        /return 0
                    }
                    /call MobRadar los 50 FROMHERE
                    /if (${MobCount}) {
                        /varset IgnorePullDist 1
                        /squelch /nav ${NavParams}
                        /break
                    }
                    /call AdvancePullCamp FROMHERE
                    POPCALL
                    /return 0
                }

                /if (${Math.Distance[${CampYLoc},${CampXLoc}:${Me.Y},${Me.X}]}>${PullCampDistFromCamp}) {
                    /if (${Navigation.Active}) /squelch /nav stop
                    /if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
                        POPCALL
                        /return 0
                    }
                    /call MobRadar los 100 FROMHERE
                    /if (${MobCount}) {
                        /varset IgnorePullDist 1
                        /squelch /nav ${NavParams}
                        /break                        
                    }
                    /echo Moving group up since the pull will be long.
                    /call AdvancePullCamp FROMHERE
                    POPCALL
                    /return 0
                }
            }
			
            DEBUGPULL Are we too far from camp?
            | Check for being to far from camp lose MyTargetID or path
            /if (${Math.Distance[${CampYLoc},${CampXLoc}]}>=${Math.Calc[${MaxRadius}*.95]} || ${PullNavTimer}==0 || !${Spawn[id ${MobNavID}].ID} || ${Navigation.PathLength[id ${MobNavID}]}<0.01) {
                /echo We have exceeded max pulling radius or timer or lost path to mob. Returning to camp.
                /if (${Navigation.Active}) /squelch /nav stop
                DEBUGPULL PullUsingNav Leave Max radius/no timer/no mob/nopath (${Math.Distance[${CampYLoc},${CampXLoc}]}>=${Math.Calc[${MaxRadius}*.95]} && ${Spawn[id ${MobNavID}].Speed}>25) || (${Math.Distance[${CampYLoc},${CampXLoc}]}>=${PullNavDistance}) || ${PullNavTimer}==0 || !${Spawn[id ${MobNavID}].ID} || ${Navigation.PathLength[id ${MobNavID}]}<0.01
                /if (${Select[${Role},hunter,hunterpettank]}) {
                    /call PullReset FROMHERE
					POPCALL
                    /return huntpr
                } else {
					POPCALL
                    /return btcr
                }
            }
            
            DEBUGPULL If we are still moving, extend pull timer.
            | Keep timer from main Pull sub alive
            /if (${Me.Moving} && ${Navigation.Active}) /varset PullTimer 30
			
            DEBUGPULL Checking pull situation - distance to mob, LOS, feet wet...
            /if (${Spawn[id ${MobNavID}].Distance3D}>${NavPullDist} || !${Spawn[id ${MobNavID}].LineOfSight} || ${Spawn[id ${MobNavID}].FeetWet}!=${Me.FeetWet}) {
                /if (${PullWith.NotEqual[pet]} || ${Spawn[id ${MobNavID}].Distance3D}>${NavPullDist}) {
                    /if (!${ChainPull} && !${AggroTargetID}) /continue
                    /if (${ChainPull}) {
                        /if (!${Me.XTarget[${XTSlot2}].ID}) {
                            /if (!${Me.XTarget[${XTSlot}].ID}) /continue
                            /if (${Me.XTarget[${XTSlot}].ID}==${BeginMobID}) /continue
                            /if (${Me.XTarget[${XTSlot}].ID}!=${MobNavID}) /continue
                        }
                    }
                }
            }
            
            DEBUGPULL Checking melee pull situation
            /if (${PullWith.NotEqual[pet]} && !${Spawn[id ${MobNavID}].LineOfSight} && ${Spawn[id ${MobNavID}].Distance3D}>20) {
                /delay 1
                /continue
            }
			
            DEBUGPULL Checking if we can unleash pet
			| We use our pet to pull around corners, don't need LOS
			/if (${PullWith.Equal[pet]} && ${Spawn[id ${MobNavID}].Distance3D}>${NavPullDist}) {
				DEBUGPULL Wrangling a pet. I'm not in range yet.
                /delay 1
				/continue
			}

            DEBUGPULL If we got here, we must be in pull range ${Spawn[id ${MobNavID}].CleanName} (${MobNavID}) Distance ${Spawn[id ${MobNavID}].Distance3D}
			| We must be in pull range now?
			/if (${Navigation.Active}) /squelch /nav stop			
            /break
        }
		POPCALL
        DEBUGPULL PullUsingNav Leave
    /return 0

| ----------------------------------------------------------------------------
| SUB: PullValidate
| ----------------------------------------------------------------------------
    Sub PullValidate(PVPullMob, int PFlag, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare j 					int 	local
        /declare skipFlag 			int    	local 0
        /declare mobCheck 			string 	local
		/declare MobPctHPsCheck		string	local
        
        DEBUGPULL Enter from ${FromWhere}: PVPullMob ${PVPullMob} PFlag ${PFlag}

		/call IsFriendly ${PVPullMob} FROMHERE
		/if (${Macro.Return.NotEqual[MAY-BE-HOSTILE]}) {
			POPCALL
			/return PV_NOT_HOSTILE
		}
		
		/if (${MobsToPull.NotEqual[all]}) {
            /for j 1 to 25
                /if (!${MobsToPull.Arg[${j},,].Length}) /break
                /varset mobCheck ${MobsToPull.Arg[${j},,]}
                DEBUGPULL PullValidate: PFlag: ${PFlag} ${j} ${PVPullMob} PullList ${Spawn[id ${PVPullMob}].CleanName}/${MobsToPull.Arg[${j},,]} ${Spawn[id ${PVPullMob}].CleanName.Equal[${MobsToPull.Arg[${j},,]}]}
                /varset mobCheck ${mobCheck.Replace[*,]}
				/varset mobCheck ${mobCheck.Replace[#,]}
				/if (${Spawn[id ${PVPullMob}].CleanName.Find[${mobCheck}]}) {
					DEBUGPULL PullValidate Mob found: ${Spawn[id ${PVPullMob}].CleanName} ${Spawn[id ${PVPullMob}].CleanName.Find[${mobCheck}]}					
                    /varset skipFlag 1
					/break
                }
            /next j
            /if (!${skipFlag}) {
                DEBUGPULL PullValidate ${Spawn[id ${PVPullMob}].CleanName} NOT on MobsToPull List
				POPCALL
                /return 0
            }
        }
		DEBUGPULL PullValidate We didn't find a match on MobsToPull. 0 = no, 1=yes:  ${skipFlag}  ${Spawn[id ${PVPullMob}].Name}

        | If mob found on ignore list
        /if (${MobsToIgnore.Find[${Spawn[id ${PVPullMob}].CleanName}]}>0) {
			POPCALL
			/return PV_IGNORED_NAMELIST
		}
        DEBUGPULL PullValidate We didn't find a match on MobsToIgnore: Spawn "${Spawn[id ${PVPullMob}].CleanName}" Find: ${MobsToIgnore.Find[${Spawn[id ${PVPullMob}].CleanName}]}
        /if (${MobsToIgnoreByID.Find[${PVPullMob}|]}) {
			POPCALL
			/return PV_IGNORED_IDLIST
		}
        |/if (${PullIgnore1.Find[${PVPullMob}|]}) /return PV_IGNORED_PULLLIST
		DEBUGPULL PullValidate Not on MobsToIgnoreByID ${PVPullMob} ${Spawn[id ${PVPullMob}].Name}
		
        /if (${PullLocsOn}) {
            /for j 1 to ${PullLocs.Size}
                /if (!${Bool[${PullLocs[${j}]}]}) /break
                /if (${Math.Distance[${Spawn[id ${PVPullMob}].Y},${Spawn[id ${PVPullMob}].X}:${PullLocs[${j}].Arg[1,|]}]}<=${PullLocs[${j}].Arg[2,|]}) {
                    DEBUGPULL PullValidate ${Spawn[id ${PVPullMob}].CleanName} is in Invalid PullLocs Location.
					POPCALL
                    /return PV_PULLLOCS_OUTOFBOUND
                }
            /next j
        }
		DEBUGPULL PullValidate PullLocsOn are ok
		
        DEBUGPULL PullValidate Pulling: ${Spawn[id ${PVPullMob}].CleanName}
        | Check spawn for out of range - macro start point as epicEnter
        /if (${Select[${PullMoveUse},los,nav]}>=1 && ${Math.Distance[${Spawn[id ${PVPullMob}].Y},${Spawn[id ${PVPullMob}].X}:${CampYLoc},${CampXLoc}]}>${MaxRadius}) {
            DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} invalid target Reason: Out of Range
			POPCALL
            /return PV_OUTOFRANGE
        }
		DEBUGPULL PullValidate Its within range
		
        | Check spawn for eye of zomm/tallon ${SpawnCount[pc ${PVPullMob.Right[${Math.Calc[${PVPullMob.Length}-7]}]}]}
        /if (${Spawn[id ${PVPullMob}].CleanName.Find[Eye of]} && ${SpawnCount[pc ${Spawn[id ${PVPullMob}].CleanName.Right[${Math.Calc[${Spawn[id ${PVPullMob}].CleanName.Length}-7]}]}]}) {
            DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} invalid target Reason: Eye of Zomm/Tallon
			POPCALL
            /return PV_EYE
        }
		DEBUGPULL PullValidate Its not an eye of zomm/tallon
		
        | Check spawn for line of sight - no mq2nav
        /if (${Select[${Role},PULLER_ROLES]} && !${Spawn[id ${PVPullMob}].LineOfSight} && ${PullMoveUse.Equal[los]}) {
            DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} invalid target Reason: No line of sight
			POPCALL
            /return PV_USINGLOS_NOLOS
        }
		DEBUGPULL PullValidate Its in LOS
		
        | Check spawn for Level Range
        /if (${Spawn[id ${PVPullMob}].Level}<${PullMin} || ${Spawn[id ${PVPullMob}].Level}>${PullMax}) {
            DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].Level} invalid target Reason: Invalid NPC Level
			POPCALL
            /return PV_OUTOFLEVELRANGE
        }
		DEBUGPULL PullValidate Level range ok
		
        /if (${PullArcWidth}>0) {
            /call FigureMobAngle ${Int[${PVPullMob}]}
            /if (${Macro.Return.Equal[0]}) {
                DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} ${PullLSide} ${Spawn[id ${PVPullMob}].HeadingTo[${CampYLoc},${CampXLoc}].Degrees} ${PullRSide} invalid target Reason: Mob not in Pull Area
				POPCALL
                /return PV_OUTOFPULLARC
            }
        }
		DEBUGPULL PullValidate It's within the pull arc width.

		| We only care about this stuff when other players may be around.
		/if (!${Me.InInstance}) {
			| If you are dragging your group along, then when you pull, the group will appear as if its the PC's nearby which results in a bad response.
			| If a mob memblurs while it is mezzed, then it falls off xtarget. This condition makes you not engage it. Adding distance from camp condition, too.
			| Check if any PC/toon is near the mob
			/if (${SpawnCount[loc ${Spawn[id ${PVPullMob}].X} ${Spawn[id ${PVPullMob}].Y} radius 15 pc]}>=1 && ${Pulling}) {
				/if (${Math.Distance[${Spawn[id ${PVPullMob}].Y},${Spawn[id ${PVPullMob}].X}:${Me.Y},${Me.X}]}>=16 && ${Math.Distance[${Spawn[id ${PVPullMob}].Y},${Spawn[id ${PVPullMob}].X}:${CampYLoc},${CampXLoc}]}>${Math.Calc[${CampRadius}*2]}) {
					DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} invalid target Reason: PCs near mob
					POPCALL
					/return PV_PCNEAR
				}
			}
			DEBUGPULL PullValidate We didn't see any PC's near mob

			| We have no choice but to target and wait for the mob to update.
			/if (${Spawn[id ${PVPullMob}].PctHPs}<100) {
				/call TargetThis ${PVPullMob}
				/delay 2s
			}

			DEBUGPULL PullValidate If the hps are less than 100 and the mob is not idle, then its a no.
			/if (${Spawn[id ${PVPullMob}].PctHPs}<100 && ${Spawn[id ${PVPullMob}].PlayerState}) {
				POPCALL
				/return PV_HPSBELOW100_COMBAT
			}
			
			| If the hps are less than 100 and the mob is idle, then we need to query server.
			/if (${Spawn[id ${PVPullMob}].PctHPs}<100 && !${Spawn[id ${PVPullMob}].PlayerState}) {
				DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} invalid target Reason: Mob not 100% health ${Spawn[id ${PVPullMob}].PctHPs}
				/call TargetThis ${PVPullMob}
				DEBUGPULL PullValidate: Mob not at 100% HPs Double checking for server lag PFlag: ${PFlag} PVPullMob: ${PVPullMob} - ${Spawn[id ${PVPullMob}].CleanName} MobCount: ${MobCount}			
				/if (${Spawn[id ${PVPullMob}].PctHPs}<100) {
					DEBUGPULL PullValidate: Mob is < 100, skipping.
					/echo Mob doesn't appear to be at 100% health.
					/call PullIgnoreCheck ${PVPullMob} a pullvalidate
					POPCALL
					/return PV_HPSBELOW100_LAGCHECK
				}
				DEBUGPULL PullValidate: Mob is actually at 100% health. Continuing.
			}
			DEBUGPULL PullValidate Mob is full health
		}
		
        /if (${Spawn[id ${PVPullMob}].Named} && ((${PFlag} && ${MobCount} && ${Me.XTarget[${XTSlot}].ID}) || !${PFlag})) {
            DEBUGPULL PullValidate: PFlag: ${PFlag} ${Spawn[id ${PVPullMob}].CleanName} invalid target Reason: No Pull Names with Mobs in Camp
			POPCALL
            /return PV_NAMED_MOBSINCAMP
        }
		DEBUGPULL PullValidate Mob isn't a named and we aren't fighting anything.  Returning VALID pull 1.
		POPCALL
    /return 1
	
| -------------------------------------------------------------------------------------
| SUB: PullVars
| -------------------------------------------------------------------------------------
    Sub PullVars(int pRange, pType, int pRange2)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGPULL PullVars Enter
        /varset PullRange ${pRange}
        /varset PullWith ${pType}
        /if (${PullPathWpCount} && ${PullMoveUse.Equal[advpath]}) /varcalc MaxRadius ${TempMaxRadius}+${PullRange}
        /if (${Bool[${Plugin[MQ2Map]}]}) {
            /if (!${Select[${Role},hunter,hunterpettank]} || !${MapSet}) {
                /squelch /mapfilter CastRadius ${PullRange}
                /squelch /mapfilter SpellRadius ${MaxRadius}
                /squelch /mapfilter PullRadius ${MaxRadius}
                /squelch /mapfilter CampRadius ${CampRadius}
                /varset MapSet 1
            }
        }
        DEBUGPULL MaxRadius is now ${MaxRadius}
        DEBUGPULL PullVars Leave
    /return
	
|-------------------------------------------------------------------------------------
| SUB: Pull With Casting
|-------------------------------------------------------------------------------------
    Sub PullWithCast(int PullDistCast, string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullWithCast Enter from ${FromWhere}

        DEBUGPULL PullWithCast: Casting to pull mob
        /if (${Me.Moving}) /call StopMoving
		/if (${PullEscapeMethod.Length} && ${PullEscapeMethod.NotEqual[NULL]}) {
			|
			| No need to face a mob when casting. If anything turn around for a faster getaway.
			|
			/squelch /face away fast nolook
		} else {
			/if (${Target.ID}) /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
		}
        /look 0
        /while (1) {
            /if (${PullAggroTargetID}) {
                /varset Pulled 1
				POPCALL
				/return
            }
            /if (!${Spawn[id ${MyTargetID}].LineOfSight}) {
                /varcalc PullDistCast ${PullDistCast}*.8
				POPCALL
				/return ${PullDistCast}
            }
            /if (!${Me.Moving}) /call CastWhat "${PullWith}" ${Target.ID} Pull 0 0 FROMHERE
            /if (${Macro.Return.Equal[CAST_FIZZLE]}) /continue
            /if (${Macro.Return.Equal[CAST_SUCCESS]} || ${Macro.Return.Equal[CAST_RESISTED]} || ${PullAggroTargetID}) /varset Pulled 1
            /delay 10 ${PullAggroTargetID}
            /break
        }
		POPCALL
		DEBUGPULL PullWithCast: Leave
	/return
	
|--------------------------------------------------------------------------------------
| SUB: Pull with Melee
|-------------------------------------------------------------------------------------
    Sub PullWithMelee(string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullWithMelee: Enter from ${FromWhere}
			
        | Turn off mq2melee function so puller and pullertank doesn't attack mob on pull
        /if (${Select[${Role},puller,pullertank]} && ${UseMQ2Melee}) /squelch /melee melee=0
        /moveto id ${MyTargetID} mdist 15
        /delay 10
        /while (1) {
			/call LastMove
            /if (${PullAggroTargetID} || ${Target.PctHPs}<100) /break
            /if (${Target.ID}) /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
            /look 0
            |/echo Arrival Distance: ${MoveTo.ArrivalDist} ${Target.Distance3D}
            /if (${Target.MaxRangeTo}>=${Target.Distance3D}) {
                /if (!${Me.Moving}) {
                    |/echo PullWithMelee 1
                    /moveto id ${MyTargetID} mdist ${If[${MoveTo.ArrivalDist}>5,${Math.Calc[${MoveTo.ArrivalDist}-5]},1]}
                    /if (${PullMeleeStick} && !${PullAggroTargetID}) /stick ${MoveTo.ArrivalDist} front
                } else {
                    |/echo PullWithMelee 2 
                    /moveto mdist ${If[${MoveTo.ArrivalDist}>5,${Math.Calc[${MoveTo.ArrivalDist}-5]},1]}
                    /if (${PullMeleeStick} && !${PullAggroTargetID}) /stick ${MoveTo.ArrivalDist} front
                }
                |/squelch /attack on
                /if (!${Stick.Active} && ${PullMeleeStick} && !${PullAggroTargetID}) /stick ${MoveTo.ArrivalDist} id ${MyTargetID} front
            } else {
                /if (!${Me.Moving}) {
                    |/echo PullWithMelee 3
                    /moveto id ${MyTargetID} mdist ${If[${MoveTo.ArrivalDist}>5,${Math.Calc[${MoveTo.ArrivalDist}-5]},1]}
                    /if (${PullMeleeStick} && !${PullAggroTargetID}) /stick ${MoveTo.ArrivalDist} front
                }
            }
            |/echo PullWithMelee 4
            /squelch /attack on
            /delay 10
            /if (${PullAggroTargetID} || ${Target.PctHPs}<100) /break
        }
        | Turn off combat so puller returns to camp. You mean run like hell.
        /if (${Select[${Role},puller,pullertank,pullerpettank,hunterpettank]}) {
            /attack off
            /if (${Stick.Active}) /stick off
			/call TargetThis
            | Turn on mq2melee function back on after pull
            /if (${Select[${Role},puller,pullertank]} && ${UseMQ2Melee}) /squelch /melee melee=1
        }
        /varset Pulled 1
        /varset ToClose 0
		POPCALL
        DEBUGPULL PullWithMelee: Leave
    /return
	
|-------------------------------------------------------------------------------------
| SUB: Pull With Ranged
|-------------------------------------------------------------------------------------
    Sub PullWithRanged(int PullDistRanged,int RSwitch, string FromWhere)
		/doevents PleaseWaitListener
		/if (${PleaseWaitTimerOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL PullWithRanged: Enter from ${FromWhere}

        /declare TryCount int local 0
        /declare AmmoCount int local 0
        DEBUGPULL PullWithRanged: Ranged
        | Cursor check sometimes summoned items get stuck on cursor.
        /if (${Cursor.ID}) /call CheckCursor 0
        /if (${RSwitch}==0) {
            /if (${Me.Inventory[ranged].Name.NotEqual[${PullItem}]}) {
                /exchange "${PullItem}" ranged
                /varset RangedSwitch 1
            }
            /if (${Me.Inventory[ammo].Name.NotEqual[${PullAmmo}]}) {
                /exchange "${PullAmmo}" ammo
                /if (${TempAmmo.NotEqual[${PullAmmo}]}) /varset AmmoSwitch 1
            }
        } else /if (${RSwitch}==1) {
            /while (1) {
                /varcalc TryCount ${TryCount}+1
                /doevents
                /if (${DPSPaused}) {
					POPCALL
					/return
				}
                /if (${PullAggroTargetID}) {
                    /varset Pulled 1
					POPCALL
                    /return
                }
                /if (${CantSee}) {
                    /if (${Target.ID}) /squelch /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
                    /delay 10
                    /varset CantSee 0
                    DEBUGPULL Could Not see Target. Trying Again.
                }
                | Mod for puller to turn back to camp after /range this saves on the puller turning AFTER mob is aggroed  and turns facing camp while waiting for mob to aggro.
                /if (${Me.Combat}) {
                    /Attack off
                    /delay 20 !${Me.Combat}
                }
                /if (${Stick.Active}) /stick off
                /if (${Target.ID}) /squelch /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
                /look 0
                /varset AmmoCount ${FindItemCount[=${PullAmmo}]}
                /delay 30 ${Me.Heading.ShortName.Equal[${Target.HeadingTo}]}
                /if (${Target.ID}==${MyTargetID} && ${Target.Distance3D}>=30) {
                    | This is where we would call the Pacification code.
                    |/echo Distance From Target: ${Target.Distance3D} ${PullDistRanged}
                    /while (${AmmoCount}==${FindItemCount[=${PullAmmo}]} && !${PullAggroTargetID} && ${Target.Distance3D}>=30 && ${Target.LineOfSight} && ${Target.FeetWet}==${Me.FeetWet}) {
                        /range
                        /doevents TooClose
                        /if (${ToClose}) {
                            /varset PullDistRanged 15
							POPCALL
                            /return ${PullDistRanged}
                        }
                        /doevents CantHit
                        /if (${CantHit}) {
                            /varset CantHit 0
                            /varcalc PullDistRanged ${PullDistRanged}*.8
							POPCALL
                            /return ${PullDistRanged}
                        }
                        /doevents TooFar
                        /if (${PullTooFar}) {
                            /varset PullTooFar 0
                            /varcalc PullDistRanged ${PullDistRanged}*.8
							POPCALL
                            /return ${PullDistRanged}
                        }
                    }
                }
                /if (${Math.Distance[${CampYLoc},${CampXLoc}]} > ${CampRadius}) {
                    /delay 10 ${PullAggroTargetID}
                    /if (${Target.ID}) /squelch /face ${If[${FaceMobOn}==2,nolook,fast nolook]} loc ${CampYLoc},${CampXLoc}
                }
                /if (!${PullAggroTargetID}) {
                    /delay ${Math.Calc[1+${Target.Distance}/50].Int}s ${PullAggroTargetID}
                    /varcalc PullTimer ${PullTimer}+10
                }
                DEBUGPULL Pull: ${PullTimer} !${PullAggroTargetID} ${Target.PctHPs}==100
                /if (!${PullTimer} || ${TryCount}>2 || ${PullTooFar} || ${PullAggroTargetID}) /break
            }
            /if (${PullAggroTargetID}) {
                /varset Pulled 1
				POPCALL
                /return
            }
        } else /if (${RSwitch}==2) {
            /if (${Cursor.ID}) /call CheckCursor PullWithRanged 0
            /if (${OrigRanged.NotEqual[null]} && ${Me.Inventory[ranged].Name.NotEqual[${OrigRanged}]}) {
                /exchange "${OrigRanged}" ranged
                /varset RangedSwitch 0
            }
            /if (${TempAmmo.NotEqual[null]} && ${Me.Inventory[ammo].Name.NotEqual[${TempAmmo}]}) {
                /exchange "${TempAmmo}" ammo
                /varset AmmoSwitch 0
            }
        }
		POPCALL
        DEBUGPULL PullWithRanged: Leave
    /return
	
|-----------------------------------------------------------------------------
| SUB: SetPullAngles
| ----------------------------------------------------------------------------
    Sub SetPullAngles(float FDir, float AWidth, int IgnoreMessage)
        /if (!${AWidth}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		DEBUGCOMBAT Enter
	
        /if (!${FDir}) /varset FDir 0.00
        | Figure the Degrees for the left side
        /if (${Math.Calc[${FDir}-(${AWidth}*.5)]}<0) {
            /varcalc PullLSide 360-((${AWidth}*.5)-${FDir})
        } else {
            /varcalc PullLSide ${FDir}-(${AWidth}*.5)
        }
        |Figure the Degrees for the right side
        /if (${Math.Calc[${FDir}+(${AWidth}*.5)]}>360) {
            /varcalc PullRSide ((${AWidth}*.5)+${FDir}-360)
        } else {
            /varcalc PullRSide ${FDir}+(${AWidth}*.5)
        }
        |Store your current heading
        /varset PullHeading ${FDir}
        /if (!${IgnoreMessage}) /echo Setting Pull Angles. Facing: ${FDir} Left Side: ${PullLSide} Right Side: ${PullRSide} Width: ${AWidth}
		
		DEBUGCOMBAT Leave
		
    /return

| -------------------------------------------------------------------------------------
| SUB: Wait for Mob
| -------------------------------------------------------------------------------------
    Sub WaitForMob(string FromWhere)
        /if (${Select[${Role},hunter,hunterpettank]} || ${DPSPaused}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare MobsInCamp int local 0
        DEBUGPULL WaitForMob Enter from ${FromWhere}
        /varset WaitTimer 45s
        /if (${Pulled}) {
            DEBUGPULL WaitForMob Waiting for mob
            /if (${ChainPull}) /varset LastMobPullID ${Target.ID}
            /if (${Me.Inventory[ranged].Name.NotEqual[${OrigRanged}]} && ${OrigRanged.NotEqual[null]}) {
                /exchange "${OrigRanged}" ranged
            }
            | When you target a mob and another mob aggros you, but your target never gets aggroed.
            /if (${PullAggroTargetID} && ${Target.ID}!=${PullAggroTargetID} && ${Target.AggroHolder.ID}==0) {
				/call TargetThis ${AggroTargetID}
            }
            /while (1) {
				/call LastMove
                /call IsMACloser ${Target.ID} FROMHERE
                /if (${Macro.Return.Equal[1]}) {
                    /break
                }
				/call Triage FROMHERE
                /if (${FaceMobOn} && ${Target.ID} && (${Me.Standing} || ${Me.Mount.ID})) {
                    /if (${FaceMobOn}==1) {
                        /face fast nolook
                    } else /if (${FaceMobOn}==2) {
                        /face nolook
                    }
                    |/face ${If[${FaceMobOn}==1,fast nolook,nolook]}
                }
                /doevents GotHit
                | Did the GotHit event trigger, if it did MyTargetID will be zero.
                /if (!${MyTargetID}) {
                    /call CombatTargetCheck FROMHERE
                    /if (!${MyTargetID}) /varset MyTargetID ${AggroTargetID}
					POPCALL
					/return
                }
                /call MobRadar los ${CampRadius} FROMHERE
                | If NOT chain pulling and multiple mobs in camp. /return
                /if (${MobCount}>=2 && !${ChainPull}) {
                    /call PullReset FROMHERE
					POPCALL
                    /return
                }
                DEBUGPULL - WaitTimer: ${WaitTimer} Target Distance: ${Target.Distance} Mob Dist from Camp: ${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${CampYLoc},${CampXLoc}]}>=${CampRadius} Mob Dist from tank: ${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${Me.Y},${Me.X}]}>=20
                | if target lost somehow add to ignore list and continue pulls
                /if (!${AggroTargetID} || ${WaitTimer}==0) {
                    DEBUGPULL WaitForMob return no AggroTargetID
                    /if (${Target.ID}) {
						/echo Lost mob ${Target.CleanName} (${Target.ID}) while waiting somehow.
						/call PullIgnoreCheck ${Target.ID} a waitformob
					}
                    /call PullReset FROMHERE
					POPCALL
                    /return
                }
                /delay 5
                /varset MobsInCamp ${SpawnCount[xtarhater loc ${CampXLoc} ${CampYLoc} radius ${MeleeDistance} zradius ${MaxZRange}]}
                /if (${Select[${Role},pullertank]}) {
                    | Wait in camp for mob if timer active and mob is outside of camp radius and mob is farther away from tank than 20 feet
                    /if (${WaitTimer} && !${MobsInCamp}) /continue
                } else /if (${Select[${Role},puller]}) {
                    | If I am PULLER and NOT chain pulling
                    /if (!${ChainPull}) {
                        /if (!${MobsInCamp} && !${SpawnCount[xtarhater loc ${Spawn[=${MainAssist}].X} ${Spawn[=${MainAssist}].Y} radius 20 zradius ${MaxZRange}]}) /continue
                        /if (${MercOn} && !${MercAssisting} && ${MyTargetID} && ${Mercenary.State.Equal[Active]}) /call MercsDoWhat
                    } else {
                        | If I am PULLER and chain pulling
                        | Leave if multi mobs or no mobs
                        /if (${MobsInCamp}>1 || !${MyTargetID} || (${Me.XTarget[${XTSlot}].ID} && ${Me.XTarget[${XTSlot2}].ID})) {
                            /call PullReset FROMHERE
							POPCALL
                            /return
                        }
						|
						| Need to also check pet... maybe the pet is tanking
						|
						/if (${Spawn[=${MainAssist}].Pet.ID}) {
							/if (${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${Spawn[=${MainAssist}].Pet.Y},${Spawn[=${MainAssist}].Pet.X}]}<=20 && ${Target.ID}==${Spawn[id ${MyTargetID}].ID} && ${Me.TargetOfTarget.ID}==${Me.ID}) /break
						}
                        /if (${Math.Distance[${Spawn[id ${MyTargetID}].Y},${Spawn[id ${MyTargetID}].X}:${Spawn[=${MainAssist}].Y},${Spawn[=${MainAssist}].X}]}>20 && ${Target.ID}==${Spawn[id ${MyTargetID}].ID} && ${Me.TargetOfTarget.ID}==${Me.ID}) /continue
                    }
                } else /if (${Select[${Role},pullerpettank]}) {
                    | I am PULLER with PET TANK
                    |- Make sure pet is returning to camp with me.
                    /if (${Pet.ID} && ${Math.Distance[${Pet.Y},${Pet.X}:${CampYLoc},${CampXLoc}]}>${CampRadius} && ${Math.Distance[${Pet.Y},${Pet.X}:${Me.Y},${Me.X}]}>20) {
                        /call PetBackOff FROMHERE
                        /if (${Pet.Stance.NotEqual[FOLLOW]}) /pet follow
                    }
                    | If the mob is within pet attack distance from camp send the pet in to attack
                    /if (!${SpawnCount[xtarhater targetable loc ${CampXLoc} ${CampYLoc} radius ${PetAttackRange} zradius ${MaxZRange}]}) {
                        /continue
                    } else {
                        /varset MyTargetID ${NearestSpawn[1,xtarhater targetable loc ${CampXLoc} ${CampYLoc} radius ${PetAttackRange} zradius ${MaxZRange}].ID}
                    }
                    /if (!${PetAttack}) /call CombatPet FROMHERE
                }
                /break
            }
        }
        | I believe this is done to make it so a merc healer will work.
        /if (${Group}==1 && ${Select[${Role},puller]} && ${Group.Puller.Name.Equal[${Me}]} && ${Spawn[=${MainAssist}].Type.Equal[Mercenary]} && ${Spawn[id ${MyTargetID}].Distance}<=${MeleeDistance}) /call AssignGroupRole unset "${Me.CleanName}" 3

        /if (${MyTargetID} && !${PullAggroTargetID}) /call PullReset FROMHERE
        /if (${IAmABard}) /call DoBardStuff FROMHERE
        /varset WaitTimer 0
        /call MercsDoWhat
		POPCALL
        DEBUGPULL WaitForMob Leave
    /return
