
| -------------------------------------------------------------------------------------------------
| Sub:AddFriendly
| -------------------------------------------------------------------------------------------------
    Sub AddFriendly(int SpawnID)
        /if (!${SpawnID}) /return
        /if (!${IsFriendlyIDList.Find[|${SpawnID}|]}) {
            /varset IsFriendlyIDList ${IsFriendlyIDList}|${SpawnID}|
        }
    /return


| -------------------------------------------------------------------------------------------------
| Sub:AddHostile
| -------------------------------------------------------------------------------------------------
    Sub AddHostile(int SpawnID)
        /if (!${SpawnID}) /return
        /if (!${IsHostileIDList.Find[|${SpawnID}|]}) {
            /varset IsHostileIDList ${IsHostileIDList}|${SpawnID}|
        }
    /return


| -------------------------------------------------------------------------------------------------
| Sub:AddMaybeHostile
| -------------------------------------------------------------------------------------------------
    Sub AddMaybeHostile(int SpawnID)
        /if (!${SpawnID}) /return
        /if (!${IsMaybeHostileIDList.Find[|${SpawnID}|]}) {
            /varset IsMaybeHostileIDList ${IsMaybeHostileIDList}|${SpawnID}|
        }
    /return


| -------------------------------------------------------------------------------------
| SUB: Add to Array
| -------------------------------------------------------------------------------------
    Sub AddToArray(ArrayName, int Rows, int AddMobID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        /if (!${Rows} || !${AddMobID}) /return
        DEBUGN AddToArray ${AddMobID} Enter
        /declare i int local
		|
		| Go through the list of potential mobs.
		|
		| The first one that is null, plunk the info. If no room, maybe wipe!
		|
		| Cols 1=id, 2=level, 3=cleanname, 4=mezimmune, 5=tashed, 6=maloed, 7=slowed
		|
        /for i 1 to ${Rows}
			/if (${${ArrayName}[${i},1].Equal[${AddMobID}]}) /return
            /if (${${ArrayName}[${i},1].Equal[NULL]}) {
                /varset ${ArrayName}[${i},1] ${Spawn[id ${AddMobID}].ID}
                /varset ${ArrayName}[${i},2] ${Spawn[id ${AddMobID}].Level}
                /varset ${ArrayName}[${i},3] ${Spawn[id ${AddMobID}].CleanName}
				/varset ${ArrayName}[${i},4] NULL
				/varset ${ArrayName}[${i},5] NULL
				/varset ${ArrayName}[${i},6] NULL
				/varset ${ArrayName}[${i},7] NULL
                DEBUGN ARRAY Assign >> ${${ArrayName}[${i},3]} << to ${ArrayName}${i}.
                /return
            }
        /next i
        DEBUGN AddToArray Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: AFK Tools from AHTools by Anonymous Hero
| ----------------------------------------------------------------------------
    Sub AFKTools(string FromWhere)
        /if (${CampZone}!=${Zone.ID} || (${HealsOn} && ${AggroTargetID}) ) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare holding bool local
        /if (${Select[${AFKToolsOn},1,2]}) {
            /if (${Macro.IsTLO[Posse]}) {
                /while (${Posse.Strangers}>=1) {
                    /if (!${holding}) {
                        /echo [AHTools] Macro on hold due to player activity in camp radius.
                        /call BroadCast r "**PCS DETECTED IN CAMP RADIUS**"
                        /multiline ; /beep ; /timed 1 /beep ; /timed 1 /beep ; /timed 5 /beep ; /timed 5 /beep ; /timed 5 /beep ; /timed 5 /beep ; /timed 1 /beep ; /timed 1 /beep
                        /varset holding 1
                    }
                    /delay 1s
                    /if (${DPSOn} || ${MeleeOn}) {
                        /call CheckForCombat 0 FROMHERE-1 0
                    } else {
                        /call CheckForCombat 1 FROMHERE-2 0
                    }
                    /doevents
                    /call EndIfInactive FROMHERE
                }
            } else {
                /varset holding 0
            }
            /call EndIfInactive FROMHERE
        }
        /if (${Select[${AFKToolsOn},1,3]}) {
            /if (${GMailEvents.Find[GM]} && ${SpawnCount[GM]}>=1) /call GmailSend "GM in Zone, ${Zone.ShortName}"
            /if (${SpawnCount[GM]}>=1) {
                /if (${AFKGMAction}==1) {
                    /while (${SpawnCount[GM]}>=1) {
                        /if (!${holding}) {
                            /echo [AHTools] Macro on hold due to GM Presence
                            /call BroadCast r "** GM DETECTED **"
                            /multiline ; /beep ; /timed 1 /beep ; /timed 1 /beep ; /timed 5 /beep ; /timed 5 /beep ; /timed 5 /beep ; /timed 5 /beep ; /timed 1 /beep ; /timed 1 /beep
                            /varset holding 1
                        }
                        /delay 1s
                        /call EndAfterInactive
                    }
                } else {
                    /varset holding 0
                }
                /if (${AFKGMAction}==2) {
                    /multiline ; /echo [AHTools] Ending Macro due to GM Presence ; /mq2log [AHTools] Ending Macro due to GM Presence ; /endmacro
                } else /if (${AFKGMAction}==3) {
                    /multiline ; /echo [AHTools] Unloading MQ2 due to GM Presence; /mq2log [AHTools] Unloading MQ2 due to GM Presence ; /unload
                } else /if (${AFKGMAction}==4) {
                    /multiline ; /echo [AHTools] Quitting out of EQ due to GM Presence ; /mq2log [AHTools] Quitting out of EQ due to GM Presence ; /quit
                }
            }
            /call EndIfInactive FROMHERE
        }
		POPCALL
   /return

| -------------------------------------------------------------------------------------------------
| SUB: EndIfInactive
| -------------------------------------------------------------------------------------------------
    Sub EndIfInactive(string FromWhere)
        /if (!${InactivityEndMins} && !${InactivityCampMins}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /call LastMove
        /if (!${InactivityCampMins}) {
            /if (${TimeSinceMove}>${InactivityEndSecs}) {
                /echo \awAKA: \ayCharacter has been inactive for ${InactivityEndMins} minutes. Ending AKA.
                /endmacro
            }
        } else {
            /if (${TimeSinceMove}>${InactivityCampSecs}) {
                /echo \awAKA: \ayCharacter has been inactive for ${InactivityCampMins} minutes. Camping.
                /camp
                /endmacro
            }
        }

        POPCALL
    /return
| ----------------------------------------------------------------------------
| SUB: Add a friend to mq2posse list
| ----------------------------------------------------------------------------
    Sub Bind_AddAFriend
        /declare AFriend string local ${Target.CleanName}
        /if (!${Target.ID} || ${Spawn[id ${Target.ID}].Type.NotEqual[pc]} || ${Target.ID}==${Me.ID}) {
            /echo --ADDFRIEND: Target a PC to add your Posse list.
            /return
        }
        /docommand /posse add ${AFriend}
        /docommand /posse save
        /docommand /posse load
    /return

| ----------------------------------------------------------------------------
| SUB: Bind Kiss Edit - Edit ini file in MQ2NotePad
| ----------------------------------------------------------------------------
    Sub Bind_KissE
        /if (!${Bool[${Plugin[MQ2Notepad]}]}) {
            /echo
            /echo \awAKA: \ayThis function requires MQ2Notepad to be loaded.
            /echo \aw1. \ayPlease copy MQUI_NotepadWindow.xml to your Everquest/UIFiles/default or custom ui folder
            /echo \aw2. \aythen /plugin MQ2Notepad
            /echo \aw3. \ayRunning this command again should open your profile located at: \at${IniFileName.Replace[\,\\]}
        }
        /if (${Bool[${Plugin[MQ2Notepad]}]}) {
            /docommand /notepad ${IniFileName}
        }
    /return

| ----------------------------------------------------------------------------
| SUB: BroadCast - Handles echos and messages in mq2irc and mq2eqbc
| ----------------------------------------------------------------------------
    Sub BroadCast(msgcolor, message)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /if (${msgcolor.Equal[null]}) /varset msgcolor w
        /if (${EQBCOn}) {
            /if (${Macro.IsTLO[EQBC]}) {
                /if (${EQBC.Connected}) {
                    /if (TRUE) /${BroadCastSay} [+${msgcolor}+] [${Time}] ${message} [+x+]
                } else {
                    /echo You are NOT connected to an EQBC Server. Please check your connection.
                    /echo ${message}
                }
            } else {
                /echo EQBC is Required, but the plugin is NOT Loaded.
                /echo ${message}
            }
        } else /if (${DanNetOn}) {
            /if (${Macro.IsTLO[DanNet]}) {
                /if (${DanNet.PeerCount}) {
                    /if (TRUE) /${BroadCastSay} \a${msgcolor} [${Time}] ${message} \aw
                } else {
                    /echo DanNet is Loaded but no Peers are connected.
                    /echo ${message}
                }
            } else {
                /echo DanNet is Required, but the plugin is NOT Loaded.
                /echo ${message}
            }
        } else {
            /echo ${message}
        }
        /if (${Bool[${Plugin[MQ2IRC]}]} && ${IRCOn}) /i say ${message}
    /return

| ----------------------------------------------------------------------------
| SUB: Campfire Section -  OriginalCode from toomanynames, wizbomb
| ----------------------------------------------------------------------------
    Sub Bind_Campfire
		| What about instances?
        /if (${Select[${Zone.ID},33506]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /declare UseThisCampfire int local ${CampfireOn}
        /if (${ReturnToCamp}) /call DoWeMove 1 Bind_CampFire
        /if (${UseThisCampfire}>1) {
            /if (${FindItemCount[Fellowship Campfire Materials]}<1) {
                /varset UseThisCampfire 1
                /echo Fellowship Campfire Materials Not Found. Setting to Regular Fellowship.
            }
        }
        /windowstate FellowshipWnd open
        /delay 10
        /nomodkey /notify FellowshipWnd FP_Subwindows tabselect 2
        /if (${Me.Fellowship.Campfire}) {
            /if (!${Select[${Me.Fellowship.CampfireZone.ID},${Zone.ID}]}) {
                /nomodkey /notify FellowshipWnd FP_DestroyCampsite leftmouseup
                /delay 5s ${Window[ConfirmationDialogBox].Open}
                /if (${Window[ConfirmationDialogBox].Open}) {
                    /nomodkey /notify ConfirmationDialogBox Yes_Button leftmouseup
                }
                /delay 5s !${Me.Fellowship.Campfire}
            }
        }
        /nomodkey /notify FellowshipWnd FP_RefreshList leftmouseup
        /delay 1s
        /nomodkey /notify FellowshipWnd FP_CampsiteKitList listselect ${UseThisCampfire}
        /delay 1s
        /nomodkey /notify FellowshipWnd FP_CreateCampsite leftmouseup
        /delay 5s ${Me.Fellowship.Campfire}
        /windowstate FellowshipWnd close
        /if (${Me.Fellowship.Campfire}) /echo Campfire Dropped
		POPCALL
    /return

| ---------------------------------------------------------------------------
| Sub Bind_HeartBeat
|
| Dump some vars I want to see when I want to see them!
| ---------------------------------------------------------------------------
	Sub Bind_HeartBeat
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		/echo
		/echo KA Dump                                    Last Moved: ${TimeSinceMove}s
		/echo ------------------------------------------------------------------------------
		/echo Target ID: ${Target.ID} Name: ${Target.CleanName}
		/echo MyTarget ID: ${MyTargetID} Name: ${MyTargetName}
		/echo CalledTargetID: ${CalledTargetID}
		/echo ValidTarget: ${ValidTarget}
		/echo CombatStart: ${CombatStart}
		/echo Pulled: ${Pulled}
		/echo AggroTargetID: ${AggroTargetID}
		/echo AggroTargetID2: ${AggroTargetID2}
		/echo LastTargetID: ${LastTargetID}
		/echo
		/echo MobCount: ${SpawnCount[npc targetable los radius ${MeleeDistance} zradius 50 noalert 3]}
		/echo MeleeDistance: ${MeleeDistance}
		/echo
		/call Bind_ViewArray AddsArray 50
		/echo
		/call Bind_ViewArray MezArray 13
		/echo
		POPCALL
	/return
| -------------------------------------------------------------------------------------------------
| Sub:Bind_UnitTest
| -------------------------------------------------------------------------------------------------
	Sub Bind_UnitTest(string TheSub, string TheParams1, string TheParams2, string TheParams3, string TheParams4, string TheParams5)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

		/if (!${TheSub.Length}) {
			/echo \ay/unittest subname and params not provided
			POPCALL
			/return
		}

		/echo \ayStarting test of ${TheSub} with parameters "${TheParams1}" "${TheParams2}" "${TheParams3}" "${TheParams4}" "${TheParams5}"
		/call Bind_Debug all on
		/call ${TheSub} "${TheParams1}" "${TheParams2}" "${TheParams3}" "${TheParams4}" "${TheParams5}"
		/echo \ayMacro.Return: ${Macro.Return}
		/call Bind_Debug all off

		POPCALL
	/return

| ---------------------------------------------------------------------------
|	Sub Bind_ViewArray
|
| List what is in the array
| ---------------------------------------------------------------------------
	Sub Bind_ViewArray(ArrayName, int Rows)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /declare i int local
		|
		|/echo Cols 1=id, 2=level, 3=cleanname, 4=mezimmune, 5=tashed, 6=maloed, 7=slowed
		|
		/echo ${ArrayName} Contents
		/echo Cols 1=id, 2=level, 3=cleanname, 4=mezimmune, 5=tashed, 6=maloed, 7=slowed
		/echo --------------------------------------------------------------------------
        /for i 1 to ${Rows}
			/if (!${${ArrayName}[${i},1]}) {
				/break
			}
			/echo Row ${i} Cols 1: ${${ArrayName}[${i},1]} 2: ${${ArrayName}[${i},2]} 3: ${${ArrayName}[${i},3]} 4: ${${ArrayName}[${i},4]} 5: ${${ArrayName}[${i},5]} 6: ${${ArrayName}[${i},6]} 7: ${${ArrayName}[${i},7]}
		/next i
	/return

| -------------------------------------------------------------------------------------------------
| SUB: Bind XTarWatch
|
| /watch command "name"
| command: 1/on 0/off add/del (empty for status)
| 
| -------------------------------------------------------------------------------------------------
    Sub Bind_XTarWatch(string Command, string WatchValues)

        /declare i int local 0

        /if (!${Command.Length} || !${Select[${Command},1,on,0,off,2,l,list,t,targets,r,refresh,s,status,c,clear]}) {
            /echo \awAKA: \ayUsage: /watch [1/on] [0/off] [2] (1 heals group and xtargets, 2 heals xtargets only). Updates INI
            /echo \awAKA: \ayUsage: /watch [c/clear] Removes all watched targets from xtar. Does not update INI.
            /echo \awAKA: \ayUsage: /watch [l/list] "XTSlot|XTSlot|XTSlot..n" "all" "auto" or preface with 0| to clear. Allows you to watch xtslots without specifying characters. Updates INI
            /echo \awAKA: \ayUsage: /watch [t/targets] "Starting XTSlot|Name1|Name2|Name...n" or preface with 0| to clear. Allows you to watch specific characters, NPC's too. Updates INI
            /echo \awAKA: \ayUsage: /watch [s/status]
            /echo \awAKA: \ayYou may watch slots without setting watch targets, and vice versa. Targets on the slot list will be treated like group members.
            /echo \awAKA: \ayE.g. /watch list "3|5" are monitored, even if targets are set for 2, 3, 4, and 5. Disable by setting to 0, E.g. "0|2|3". Pets of PCs are also watched.
            /echo \awAKA: \ayE.g. /watch targets "2|Uberguy|Ubergal|Xoxopet or merc from a another char|NPC name" sets the xtargets, but are not watched unless the list is also set. Disable by prefacing with 0.
            /echo
            /varset Command status
        }

        /if (${Select[${Command},1,on]} && !${XTarWatch}) {
            /varset XTarWatch 1
            /echo \awAKA: \ayXTarWatch is now enabled.
            /ini "${IniFileName}" "General" "XTarWatch" "${XTarWatch}"
            /return
        }

        /if (${Select[${Command},2]} && !${XTarWatch}) {
            /varset XTarWatch 2
            /echo \awAKA: \ayXTarWatch is now enabled. Only XTargets will be watched (not the group).
            /ini "${IniFileName}" "General" "XTarWatch" "${XTarWatch}"
            /return
        }

        /if (${Select[${Command},0,off]}) {
            /varset XTarWatch 0
            /echo \awAKA: \ayXTarWatch is now disabled. Only watching group.
            /ini "${IniFileName}" "General" "XTarWatch" "${XTarWatch}"
            /return
        }

        /if (${Select[${Command},l,list]} && ${XTarWatch}) {
            /if (!${WatchValues.Length}) {
                /echo \awAKA: \ayUsage: /watch l/list "XTSlot|XTSlot|XTSlot..n" or 0 to clear
                /return
            }
            /varset XTarWatchList ${WatchValues}
            /call SetXTargetWatchList "${XTarWatchList}"
            /ini "${IniFileName}" "General" "XTarWatchList" "${XTarWatchList}"            
            /echo \awAKA: \ayUpdated XTarget Watch List
            /delay 10
        }

        /if (${Select[${Command},t,targets]} && ${XTarWatch}) {
            /if (!${WatchValues.Length}) {
                /echo \awAKA: \ayUsage: /watch t/targets "Starting XTSlot|Name1|Name2|Name...n" or 0 to clear
                /return
            }
            /varset XTarWatchTargets ${WatchValues}
            /call SetXTargets "${XTarWatchTargets}"
            /ini "${IniFileName}" "General" "XTarWatchTargets" "${XTarWatchTargets}"
            /echo \awAKA: \ayUpdated XTarget Watch Targets
            /delay 10
        }

        /if (${Select[${Command},r,refresh]} && ${XTarWatch}) {
            /call SetXTargets "${XTarWatchTargets}"
            /delay 10
            /call SetXTargetWatchList "${XTarWatchList}"
            /echo \awAKA: \ayRefreshed XTarget list and targets.
            /delay 10

            /varset Command status
        }

        /if (${Select[${Command},s,status]}) {
            /if (!${XTarWatch}) {
                /echo \awAKA: \ayXTarWatch is disabled.
            } else {
                /if (${XTarWatch}==1) {
                    /echo \awAKA: \ayXTarWatch is enabled.
                } else {
                    /echo \awAKA: \ayXTarWatch is enabled. Only XTargets are being watched (not the group)
                }
            }
            /echo \awAKA: \ayXTarget Watch List and Targets
        }

        /if (${Select[${Command},c,clear]}) {
            /call ClearXTargets
            /echo \awAKA: \ayXTargets cleared. You may /watch r to reload.
            /delay 10
        }

        /for i 1 to 13
            /if (!${XTarToWatch[${i}]}) /continue
            /echo \ayWatch ${i}: XTSlot ${XTarToWatch[${i}]} -> ${Spawn[id ${Me.XTarget[${XTarToWatch[${i}]}].ID}].CleanName}
        /next i

    /return

| -------------------------------------------------------------------------------------
| SUB: Bind ZoneInfo
| -------------------------------------------------------------------------------------
    Sub Bind_ZoneInfo
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /declare LineInfo string local
        /echo -------------------------------------------------------------------------
        /echo  ${ZoneName} - (${Zone.ShortName})
        /echo -------------------------------------------------------------------------
        /echo MezImmune: ${Ini[${InfoFileName},${ZoneName},MezImmune]}
        /echo MobsToPull: ${Ini[${InfoFileName},${ZoneName},MobsTopull]}
        /echo MobsToIgnore: ${Ini[${InfoFileName},${ZoneName},MobsToIgnore]}
        /echo MobsToBurn: ${Ini[${InfoFileName},${ZoneName},MobsToBurn]}
        /echo -------------------------------------------------------------------------
    /return

| ----------------------------------------------------------------------------
| SUB: Campfire ${Window[FellowshipWnd].Child[FP_CampPage].Child[FP_CampsiteViewer].Text}
| ----------------------------------------------------------------------------
    Sub Campfire
        /if (!${CampfireOn}) /return
        /if (${CampfireTimer}) /return
        /if (${Me.Fellowship.CampfireZone.ID} && (${Select[${Me.Fellowship.CampfireZone.ID},${Zone.ID}]} || ${Me.Fellowship.CampfireZone.Name.Find[guild hall]})) /return
        /if (${Math.Distance[${CampYLoc},${CampXLoc}]}>${CampRadius}) /return
        /if (${AggroTargetID}) /return
        /if (${CombatStart}) /return
		
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL		
		
        /if (${SpawnCount[pc radius 50 fellowship]}>=3) {
            /call Bind_Campfire
        } else {
            /echo Not enough fellowship members trying again in 5 minutes
            /varset CampfireTimer 5m
        }
        /doevents TooSteep
		POPCALL
    /return

|-----------------------------------------------------------------------------
| SUB: Campfire back to camp
| ----------------------------------------------------------------------------
    Sub CampfireBack
        /if (${CampfireClickTimer}) /return
        /if (${CampZone}==${Zone.ID}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN CampFireBack Enter ${CampZone} ${Zone.ID} ${IAmDead} ${CampfireClickTimer}
        /if (${Me.Hovering}) /call PauseWhileHovering CampFireBack
        /if (!${Me.ID} || !${Zone.ID}) /call PauseWhileZoning CampFireBack
        /declare SpamTimerCFB timer local 0
        /declare t_Wait timer local 100
        /while (${t_Wait}) {
            /delay 5
            /if (${Me.Fellowship.Campfire} && ${ClickBacktoCamp}==1) /break
        }
        | Am I Dead?
        /if (${Me.Buff[Revival Sickness].ID}) {
            | Does Campfire Exist?
            /if (!${Me.Fellowship.Campfire}) {
                /echo There is no campfire up.
            | Am I & the campfire in the same zone?
            } else /if (${Select[${Me.Fellowship.CampfireZone.ID},${Zone.ID}]}) {
                /echo I'm back in the same zone as my campfire.
                /varset IAmDead 0
            } else /if (${FindItemCount[Fellowship Registration Insignia]}) {
                /while (1) {
                    /if (${FindItem[Fellowship Registration Insignia].TimerReady} == 0) {
                        /echo Time to get back to work. Clicking Fellowship Insignia in 30 seconds.
                        | Delay for rest state to kick in
                        /while (${Select[${Me.CombatState},active,resting]}==0) {
                            /delay 5
                        }
                        /doevents
                        /squelch /nomodkey /itemnotify "Fellowship Registration Insignia" rightmouseup
                        /delay 50 !${Zone.ID}
                        /if (!${Zone.ID}) /call PauseWhileZoning CampFireBack
                        /break
                    } else {
                        /if (!${SpamTimerCFB}) /echo Waiting for Fellowship Registration Insignia to refresh.
                        /varset SpamTimerCFB 100
                    }
                    /delay 10
                    /if (!${Me.Fellowship.Campfire}) {
                        /echo There is no campfire up.
                        /break
                    }
                }
                /doevents
            } else {
                /echo You Don't have a Fellowship Registration Insignia. You may want to go get one.
            }
        }
        /varset CampfireClickTimer 1m
		POPCALL
        DEBUGN CanpFireBack Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: Check cursor
| -------------------------------------------------------------------------------------
    Sub CheckCursor(string SentFrom, int ForceDrop)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN CheckCursor: Enter from ${SentFrom} - ${ForceDrop}
        /if (${ForceDrop}) {
            /while (${Cursor.ID}) {
                /if (${Debug} && ${Cursor.ID}) /echo Dropping ${Cursor} ${SentFrom}
                /if (!${Me.FreeInventory}) {
                    /echo HEY YOUR INVENTORY IS FULL!
                    /break
                }
                /autoinventory
                /delay 10
            }
            /varset CursorID 0
        } else {
            /if ((!${CursorIDTimer} && !${CursorID}) || (${CursorID} && ${Cursor.ID}!=${CursorID})) {
                /varset CursorIDTimer 20s
                /varset CursorID ${Cursor.ID}
                /if (${Me.FreeInventory}) {
                    /echo ${Cursor.Name} is stuck on my cursor. Dropping it into inventory in 15s.
                } else {
                    /echo HEY YOUR INVENTORY IS FULL!
                }
            } else /if (!${CursorIDTimer}) {
                /while (${Cursor.ID}) {
                    /if (${Debug} && ${Cursor.ID}) /echo Dropping ${Cursor} ${SentFrom}
                    /autoinventory
                    /delay 10
                }
                /varset CursorID 0
            }
        }
        DEBUGN CheckCursor: leave
    /return

| ---------------------------------------------------------------------------
| Sub CheckInvis
|
| Check if invis and report to the user whether they are. Return flag. No
| target means Me.
| ---------------------------------------------------------------------------
	Sub CheckInvis(string IsWho)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		/if (!${IsWho.Length} && !${IsWho.Equal[NULL]}) /return

		/declare WhoID 					int			local 	${Spawn[id ${IsWho}].ID}
		/declare WhoName				int			local 	${Spawn[=${IsWho}].ID}
		/declare TheID					int			local
		/declare SpawnIsInvis			bool		local	FALSE

		/if (${WhoID}) {
			/varset TheID ${WhoID}
		} else /if (${WhoName}) {
			/varset TheID ${WhoName}
		} else {
			/return INVIS_BAD_TARGET
		}

		/varset SpawnIsInvis ${Spawn[id ${TheID}].Invis}

		/if (${SpawnIsInvis} && ${TheID}==${Me.ID}) {
			/echo You are invisible. If you are trying to cast, that's why nothing is happenning.
			/return INVIS_TRUE
		} else /if (!${SpawnIsInvis} && ${TheID}==${Me.ID}) {
			| Echo nothing.
			/return INVIS_FALSE
		} else /if (${SpawnIsInvis}) {
			|/echo Your target ${MyTargetName} is invisible.
			/return INVIS_TRUE
		} else /if (!${SpawnIsInvis}) {
			|/echo Your target ${MyTargetName} is visible.
			/return INVIS_FALSE
		}
		|
		| We should never get here.
		|
	/return INVIS_ERROR
	
| ----------------------------------------------------------------------------
| SUB: Check and Fix Stuck Gems
| ----------------------------------------------------------------------------
    Sub CheckStuckGems
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		/declare CSGTimerOn	string local 15s
		/declare CSG int local ${CheckStuckGem}

		| Valid flags are 0, 1, 2. 0 is ignore, 1 is warning, 2 is brute force origin method. Default of 1 is warning.
		/if (!${CSG}) {
			/return
		} else /if (${CSG}==1) {
			/call BroadCast y "${Me.CleanName} has a stuck spell gem or player is trying to do something..."
			/delay 2s
			/return
		}
        /if (${CSG}!=2) /return

		| If CheckStuckGem=2, then we try the brute force method.
        /if (${Window[CastingWindow].Open} || ${Me.Invis}) /return

		/call BroadCast y "${Me.CleanName} has a stuck spell gem. Attempting Origin AA method."       
		/while (1) {
			/if (${Me.AltAbilityReady[origin]}) {
				/alt act ${Me.AltAbility[origin].ID}
				/delay 50 ${Window[CastingWindow].Open}
				/stopcast
				/delay 10
				/break
			} else {
				/delay 20
			}
			/if (!${CSGTimerOn}) /break
        }
		
    /return

| ----------------------------------------------------------------------------
| SUB: Clear Array
| ----------------------------------------------------------------------------
    Sub ClearArray(CArrayName, CArraySize, CArrayMemberSize)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /if (!${Defined[CArraySize]}) /return
        /if (!${Defined[CArrayMemberSize]}) /declare CArrayMemberSize string local 0
        /declare i int local
        /declare j int local
        /for i 1 to ${CArraySize}
            /if (${CArrayMemberSize}>=1) {
                /for j 1 to ${CArrayMemberSize}
                    /varset ${CArrayName}[${i},${j}] 0
                /next j
            } else {
                /varset ${CArrayName}[${i}] 0
            }
        /next i
    /return

| ----------------------------------------------------------------------------
| SUB: Create Timers Buffs
| ----------------------------------------------------------------------------
    Sub CreateTimersBuffs
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        | Declare timers for Buff duration spells
        /declare o int local
        /declare p int local
        | Create buff timer for all buff in array
        /for o 1 to ${Buffs.Size}
           | Create timers for everyone in group plus 2 extra for MA buffs
            /for p 0 to 7
                /if (!${Defined[Buff${o}GM${p}]}) {
                    /declare Buff${o}GM${p}     timer   outer   0
                } else {
                    /varset Buff${o}GM${p} 0
                }
                /if (${Buffs[${o}].Find[|begfor]}) {
                    /varset Buff${o}GM${p} 600
                }
                /if (${Debug}) {
                    /echo \atDEBUG Buff Timers:Buff${o}GM${p} ${Buff${o}GM${p}}
                    |/delay 1
                }
            /next p
        /next o
    /return

| ----------------------------------------------------------------------------
| SUB: Create Timers DPS
| ----------------------------------------------------------------------------
    Sub CreateTimersDPS
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        | Declare timers for DPS duration spells and Attack buffs
        /declare i int local
        /varset DebuffCount 0
        /for i 1 to ${DPS.Size}
            /if (${Int[${DPS[${i}].Arg[2,|]}]}<101) {
                /if (!${Defined[DPSTimer${i}]}) {
                    /declare DPSTimer${i}       timer         outer 5
                    /declare ABTimer${i}        timer         outer 0
                    /declare FDTimer${i}        timer         outer 0
                } else {
                    /varset DPSTimer${i} 0
                    /varset ABTimer${i} 0
                    /varset FDTimer${i} 0
                }
            } else {
                /if (!${Defined[DBOTimer${i}]}) {
                    /declare DBOTimer${i}       timer         outer 0
                    /declare DBOList${i}        string        outer
                    /varcalc DebuffCount ${DebuffCount}+1
                } else {
                    /varset DBOTimer${i} 0
                    /varset DBOList${i}
                }
            }
        /next i
    /return
	
| ----------------------------------------------------------------------------
| SUB: Create Timers GoM
| ----------------------------------------------------------------------------
    Sub CreateTimersGoM
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        | Declare timers for Rez duration spells
        /declare i int local
        /for i 1 to ${GoMSpell.Size}
            /if (!${Defined[GoMSpellTimer${i}]}) {
                /declare GoMSpellTimer${i} timer outer 0
            } else {
                /varset GoMSpellTimer${i} 0
            }
        /next i
    /return

| ----------------------------------------------------------------------------
| SUB: Create Timers Heals
| ----------------------------------------------------------------------------
    Sub CreateTimersHeals
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        | Declare timers for Heal duration spells
        /declare j int local
        /declare k int local
        /declare q int local
        /for j 1 to ${GroupHeal.Size}
            | Group Heal duration timers
            /if (!${Defined[SpellGH${j}]}) {
                /declare SpellGH${j}    timer   outer   0
            } else {
                /varset SpellGH${j} 0
            }
        /next j
        /for j 1 to ${SingleHeal.Size}
            /for k 0 to 13
                | Self and MA duration heal timers for  out of group including Pets.
                /if (!${Defined[Spell${j}GM${k}]}) {
                    /declare Spell${j}GM${k}     timer   outer   0
                } else {
                    /varset Spell${j}GM${k} 0
                }
                DEBUGN Group heal Timers Spell${j}GM${k} ${Spell${j}GM${k}}
            /next k
        /next j
       | Declare timers for Pet heals
        /for q 1 to ${SingleHeal.Size}
            /if (!${Defined[PetHealTimer${q}]}) {
                /declare PetHealTimer${q} timer outer 0
            } else {
                /varset PetHealTimer${q} 0
            }
        /next q
        /for j 1 to ${SingleHeal.Size}
            /for k 0 to ${XSlotTotal}
                | XTarget Timers.
                /if (!${Defined[Spell${j}XT${k}]}) {
                    /declare Spell${j}XT${k}     timer   outer   0
                } else {
                    /varset Spell${j}XT${k} 0
                }
                DEBUGN XTarget heal Timers Spell${j}XT${k} ${Spell${j}XT${k}}
            /next k
        /next j
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: Create Timers Mez
| ----------------------------------------------------------------------------
    Sub CreateTimersMez
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        | Declare timers for mezzing
        /if (${Select[${Me.Class.ShortName},BRD,ENC,NEC]}) {
            /declare l int local
            /for l 1 to 50
                /if (!${Defined[MezTimer${l}]}) {
                    /declare MezTimer${l} timer outer 0
                    /declare MMTimer${l} timer outer 0
                } else {
                    /varset MezTimer${l} 0
                    /varset MMTimer${l} 0
                }
            /next l
        }
    /return

| ----------------------------------------------------------------------------
| SUB: Create Timers Rez
| ----------------------------------------------------------------------------
    Sub CreateTimersRez
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        | Declare timers for Rez duration spells
        /declare m int local
        /for m 1 to 5
            /if (!${Defined[BattleRezTimer${m}]}) {
            /declare BattleRezTimer${m} timer outer 0
        } else {
            /varset BattleRezTimer${m} 0
        }
        /next m
    /return
	
| ----------------------------------------------------------------------------
| SUB: Do Bard Stuff New
| ----------------------------------------------------------------------------
    Sub DoBardStuff(string FromWhere)
        /if (!${IAmABard}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
				
        DEBUGCAST DoBardStuff Enter from ${FromWhere}

        /if (!${Twist}) {
            DEBUGCAST DoBardStuff - Twist OFF: ${Twist} BardSongPlaying ${Me.BardSongPlaying} Casting ${Me.Casting.ID} CastingWindow Open ${Window[CastingWindow].Open}
            /varset Twisting 0
            /varset DPSTwisting 0
            /if (${Me.BardSongPlaying} && ${Me.Casting.ID} && !${Window[CastingWindow].Open}) {
                DEBUGCAST DoBardStuff Stopping song.
                /stopsong
            }
        }

        /if (!${BardStartTwist} && !${Me.Invis} && !${TwistHold}) {
            DEBUGCAST DoBardStuff BardStartTwist ${BardStartTwist} Invis ${Me.Invis} TwistHold ${TwistHold}
            /call CastBardCheck FROMHERE
            /if (${TwistWhat.Length} && ${TwistWhat.Find[order]}==0) /squelch /twist ${TwistWhat}
            /varset BardStartTwist 1
			POPCALL
            /return
        } else /if (${Me.Invis} || ${TwistHold}) {
            /if (${Twist} || (${Medding} && ${MedCombat} && ${AggroTargetID})) {
                /call CastBardCheck FROMHERE
            }
			POPCALL
            /return
        }

        /if (!${Twist}) {
            DEBUGCAST Entering dpsmelee section. Twist is off.
            | Handle Melee Twist
            /if (${MeleeTwistOn} && !${DPSTwisting} && (${CombatStart} || (${MeleeTwistOn}==2 && ${AggroTargetID}))) {
                DEBUGCAST We are starting a combat situation. DPSTwisting ${DPSTwisting}
                /varset DPSTwisting 1
                /varset Twisting 0
                /if (${MeleeTwistWhat.Equal[Continuous]}) {
                    DEBUGCAST MeleeTwistWhat is continuous
                    /if (${Me.BardSongPlaying}) {
                        /stopsong
                        /delay 5
                    }
                    /if (${Twist.List.Left[-1].Equal[${TwistWhat}]}) {
                        /if (${Me.Sitting}) {
                            /stand
                            /delay 20 !${Me.Sitting}
                        }
                        /squelch /twist
                    } else {
                        /if (${Me.Sitting}) {
                            /stand
                            /delay 20 !${Me.Sitting}
                        }
                        DEBUGCAST Staring twist using ${TwistWhat}
                        /squelch /twist ${TwistWhat}
                    }
                } else {
                    DEBUGCAST MeleeTwistWhat is NOT continuous
                    /if (${Me.BardSongPlaying}) {
                        /stopsong
                        /delay 5
                    }
                    /if (${Twist.List.Left[-1].NotEqual[${MeleeTwistWhat}]}) {
                        DEBUGCAST Starting MeleeTwistWhat ${MeleeTwistWhat}
                        /echo == Starting melee twist
                        /if (${Me.Sitting}) {
                            /stand
                            /delay 20 !${Me.Sitting}
                        }
                        /squelch /twist ${MeleeTwistWhat}
                    } else {
                        DEBUGCAST Resuming melee test
                        /echo == Resuming melee twist
                        /if (${Me.Sitting}) {
                            /stand
                            /delay 20 !${Me.Sitting}
                        }
                        /squelch /twist
                    }
                    /varset DPSTwisting 2
                }
            } else /if (${TwistOn} && !${Twisting} && !${CombatStart} && (${MeleeTwistOn}!=2 || !${AggroTargetID})) {
                | Handle Normal Twist
                /varset DPSTwisting 0
                /varset Twisting 1
                /if (${Me.BardSongPlaying}) {
                    /stopsong
                    /delay 5
                }
                /if (${Me.Sitting}) {
                    /stand
                    /delay 20 !${Me.Sitting}
                }
                DEBUGCAST Starting normal twist ${TwistWhat} - I don't see how we will get here ... the top level checks for twist off and we are nested.
                /squelch /twist ${TwistWhat}
                /echo == Starting normal twist
            }
        } else {
            /if (${MeleeTwistOn} && !${DPSTwisting} && (${CombatStart} || (${MeleeTwistOn}==2 && ${AggroTargetID}))) {
                /varset DPSTwisting 1
                /varset Twisting 0
                /if (${MeleeTwistWhat.Equal[Continuous]}) {
                    /echo == Continuing normal twist for melee
					POPCALL
                    /return
                } else {
                    /if (${Twist.List.Left[-1].NotEqual[${MeleeTwistWhat}]}) {
                        /call CastBardCheck FROMHERE
                        /echo == Starting melee twist
                        /squelch /twist ${MeleeTwistWhat}
                        /varset DPSTwisting 2
                    }
                }
            } else /if (${MeleeTwistOn} && ${DPSTwisting} && ${AggroTargetID}) {
                /if (${MeleeTwistWhat.NotEqual[Continuous]} && ${DPSTwisting}==1) {
                    /echo == Continuing melee twist
                    /varset DPSTwisting 2
                }
            } else /if (${TwistOn} && !${Twisting} && !${CombatStart} && (${MeleeTwistOn}!=2 || !${AggroTargetID})) {
                /varset DPSTwisting 0
                /varset Twisting 1
                /if (${Twist.List.Left[-1].Equal[${TwistWhat}]}) {
                    /echo == Continuing normal twist
					POPCALL
                    /return
                } else {
                    /call CastBardCheck FROMHERE
                    /squelch /twist ${TwistWhat}
                    /echo == Starting normal twist
                }
            } else /if (!${TwistOn} && !${CombatStart}) {
                /varset DPSTwisting 0
                /if (!${AggroTargetID}) {
                    /call CastBardCheck FROMHERE
                    /if (${Twist.List.Length}) /squelch /twist clear
                }
            }
        }
		POPCALL
        DEBUGCAST DoBardStuff: Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Do I Camp
| ----------------------------------------------------------------------------
    Sub DoICamp
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN DoICamp Entered ${CampOnDeathTimer} ${CampOnDeath} ${CampZone} ${Zone.ID}
        /while (${CampOnDeathTimer} && ${CampOnDeath}==1 && ${CampZone}!=${Zone.ID}) {
            /delay 10
            DOPARSE
        }
        /if ((!${CampOnDeathTimer} || ${CampOnDeath}==2) && ${CampZone}!=${Zone.ID}) {
            /echo I am dead and not where I am suppose to be. Time to camp out.
            /if (${IAmABard}) {
                /call CastBardCheck FROMHERE
            }
            /docommand /camp desktop
            /delay 40s
            /endmac
        }
		POPCALL
        DEBUGN DoICamp Leave
    /return

| ---------------------------------------------------------------------------
| SUB EstTimeToLive
| ---------------------------------------------------------------------------
	Sub EstTimeToLive(int ClearFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

		|
		| Script should be able to do this:  ${${TTLMob${Target.ID}}}>5
		| So as we are going through conditions loops, this function
		| is called and the value is updated.
		|
		| We will create two globals per mob and add to a list, which we then read
		| and destroy the entries as they die, and when combat reset.
		|
		
		/if (!${Defined[TTLMobArray]}) {
			/declare TTLMobArray[50,1]		string  outer	NULL
			/declare TTLIndex				int		outer	1
			/declare TTLAnnounceOn			timer	outer	0
			/declare TTLAnnounceSecs		int		outer	5
			/declare TTLMobNULL				int		outer	10000
			/declare TTLMob0				int		outer	10000
			/declare TTLMob					int		outer	10000
		}
		/declare i	int	local	1		
		/if (${ClearFlag}) {
			/declare id	int	local	0	
			/for i 1 to ${TTLIndex}
				/varset id ${TTLMobArray[${i},1]}
				/if (${Int[${id}]}) {
					/if (${Defined[${TTLMob${id}}]}) {
						/deletevar ${TTLMob${id}}
					}
					/if (${Defined[${StartTimeMobID${id}}]}) {
						/deletevar ${StartTimeMobID${id}}
					}
				}
				/varset TTLMobArray[${i},1] NULL
			/next i
			/varset TTLIndex 1
			/return
		}
				
		/declare MobID				int		local	0
		/if (${Target.ID}) {
			/varset MobID ${Target.ID}
		} else /if (${MyTargetID}) {
			/varset MobID ${MyTargetID}
		} else {
			/return
		}
		
		/declare TTLMobID			string	local	TTLMob${MobID}
		/declare StartPctHPsMobID	string	local	StartPctHPsMobID${MobID}
		/declare StartTimeMobID		string	local	StartTimeMobID${MobID}
		
		/if (!${Spawn[id ${MobID}].ID} || ${Spawn[id ${MobID}].Type.Equal[Corpse]}) {
			/if (${Defined[${TTLMobID}]}) {
				/deletevar ${TTLMobID}
			}
			/if (${Defined[${StartTimeMobID}]}) {
				/deletevar ${StartTimeMobID}
			}
			/if (${Defined[${StartPctHPsMobID}]}) {
				/deletevar ${StartPctHPsMobID}
			}			
			/for i 1 to 50
				/if (${TTLMobArray[${i},1].Equal[${MobID}]}) {
					/varset TTLMobArray[${i},1] NULL
				}
			/next i
			/return
		}
		
		/if (!${Defined[${TTLMobID}]} && !${Defined[${StartTimeMobID}]} && !${Defined[${StartPctHPsMobID}]}) {
			/declare ${StartTimeMobID}		int		outer	${EverQuest.Running}
			/declare ${StartPctHPsMobID}	int		outer	${Spawn[id ${MobID}].PctHPs}
			/declare ${TTLMobID}			int		outer	10000
			
			/varset TTLMobArray[${TTLIndex},1] ${MobID}
			/varcalc TTLIndex ${TTLIndex}+1
			
			| We just declared it, so we have no information to estimate, but we want dps to start!
			/return
		}
		
		/declare StartTime			int		local	${${StartTimeMobID}}
		/declare CurrentTime		int		local	${EverQuest.Running}
		/declare TimeSeconds		int		local	0
		/varcalc TimeSeconds		(${CurrentTime}-${StartTime})/1000
		
		/declare StartingPctHPs		int		local	${${StartPctHPsMobID}}
		/declare CurrentPctHPs		int		local	${Spawn[id ${MobID}].PctHPs}
		
		/declare PctHPsPerSec		int		local	0
		/if (!${TimeSeconds}) /varset TimeSeconds 1
		/varcalc PctHPsPerSec (${StartingPctHPs}-${CurrentPctHPs})/${TimeSeconds}
		/if (!${PctHPsPerSec}) /return
		
		/varcalc ${TTLMobID} ${CurrentPctHPs}/${PctHPsPerSec}

		/if (!${TTLAnnounceOn} && ${${TTLMobID}}>0 && ${CurrentPctHPs}<34) {
			/echo ${Spawn[id ${MobID}].CleanName} has about ${${TTLMobID}}s to live. Damage rate is ${PctHPsPerSec} %hps/sec. You have been fighting for ${TimeSeconds}s.
			/varset TTLAnnounceOn ${TTLAnnounceSecs}s
		}

	/return

| ---------------------------------------------------------------------------
| SUB: EvalCondition
| ---------------------------------------------------------------------------
	Sub EvalCondition(int CondNumber)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		/if (!${CondNumber}) {
			/echo Condition given without a number! Returning as FALSE
			POPCALL
			/return CAST_COND_FAILED
		}
		|/call EstTimeToLive
		/if (${Select[${Cond[${CondNumber}]},0,FALSE,NULL]}) {
			POPCALL
			/return CAST_COND_FAILED
		}
		POPCALL
	/return

| ----------------------------------------------------------------------------
| SUB: Event Camping - end macro
| ----------------------------------------------------------------------------
    Sub Event_Camping
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /varset EventFlag 1
        /if (${IAmABard}) {
            /if (${Twist}) /call CastBardCheck FROMHERE
        }
        /endmacro
    /return

| ----------------------------------------------------------------------------
| SUB: Event EQBCIRC - Pick up commands from MQ2IRC or MQ2EQBC(todo)
| ----------------------------------------------------------------------------
    Sub Event_EQBCIRC(EIMessage,EISender,EICommand)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
        /varset EventFlag 1
        /if (${EICommand.Left[1].Equal[/]} && ${EICommand.Left[2].NotEqual[/]}) /docommand ${EICommand}
        /doevents flush EQBCIRC
    /return
	
| ----------------------------------------------------------------------------
| SUB: Event FSEQBC - Echo fellowship meassages in EQBC
| ----------------------------------------------------------------------------
    Sub Event_FSEQBC(Message,FSName,FSText)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /if (${FSName.Equal[${Me.CleanName}]}) /return
        /if (${Macro.IsTLO[EQBC]}) {
            /if (${EQBC.Connected} && ${Select[${EQBCOn},3,4]}) /call BroadCast p "${FSName} tells Fellowship: ${FSText} "
        }
    /return

| ----------------------------------------------------------------------------
| SUB: Event Gain Something - EQBC message
| ----------------------------------------------------------------------------
    Sub Event_GainSomething(string Line,string text)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        /varset EventFlag 1
        /if (!${EQBCOn} && !${IRCOn} && !${DanNetOn}) {
			POPCALL
			/return
		}
        /if (${Line.Find["ABILITY POINT!"]}) {
            /call BroadCast w "${Me.Name} gained an AA, now has ${Me.AAPoints} unspent"
        } else /if (${Line.Find[LEVEL]}) {
            /call BroadCast w "${Me.Name} gained a level, now is Level ${Me.Level}"
            /if (${GMailEvents.Find[level]}) /call GmailSend "${Me.Name} gained a level, I am Level ${Me.Level}"

            | People report not liking this feature. It changes pull parameters when a user may not want to change them.
            | Recalculate pull when level gained
            |/if (${PullLevel.Find[auto]}) {
            |   /varcalc PullMin ${Me.Level}-5
            |   /varcalc PullMax ${Me.Level}+2
            |} else /if (${PullMin}>0) {
            |   /varcalc PullMin ${PullMin}+1
            |   /varcalc PullMax ${PullMax}+1
            |}
            | need to add a new flag and set for memming new tombs and spells if in inventory.
        }
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: Event GUEQBC - Echo guild meassages in EQBC
| ----------------------------------------------------------------------------
    Sub Event_GUEQBC(Message,GUName,GUText)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /if (${GUName.Equal[${Me.CleanName}]}) /return
        /if (${Macro.IsTLO[EQBC]}) {
            /if (${EQBC.Connected} && ${Select[${EQBCOn},2,4]}) /call BroadCast p "${GUName} tells Guild: ${GUText} "
        }
    /return

| ----------------------------------------------------------------------------
| SUB: Event Invised Mainly to turn off bard twisting while invis.
| ----------------------------------------------------------------------------
    Sub Event_Invised
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /varset EventFlag 1
        /if (${IAmABard}) {
            /if (${Twist}) /call CastBardCheck FROMHERE
        }
		POPCALL
    /return

| -------------------------------------------------------------------------------------
| SUB: Event Missing
| -------------------------------------------------------------------------------------
    Sub Event_Missing
        /varset EventFlag 1
        /varset MissingComponent 1
    /return 1
	
| ----------------------------------------------------------------------------
| SUB: Event Task Update - EQBC message
| ----------------------------------------------------------------------------
    Sub Event_TaskUpdate(Line,name)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /call BroadCast t "Task updated...(${name})"
    /return
	
| -------------------------------------------------------------------------------------
| SUB: Event_Timer
| ------------------------------------ -------------------------------------------------
    Sub Event_Timer(Timer, OriginalValue)
        /if (${Select[${Timer},TributeTimer,AggroOffTimer,TellTimer,CursorIDTimer]}==0) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /varset EventFlag 1
        DEBUGN Event_Timer Enter ${Timer}
        /if (${Timer.Equal[TributeTimer]}) {
            /if (${UseTribute} && ${Me.TributeActive}) {
                /if (!${AggroTargetID} || (${Target.ID} && !${Target.Named})) {
                    /squelch /tribute personal off
                    /squelch /trophy personal off
                } else {
                    /if (${Target.ID} && ${Target.Named}) /varset ${Timer} 580s
                }
            }
        } else /if (${Timer.Equal[AggroOffTimer]}) {
            /if (${Me.Feigning}) /stand
            /if (${Me.Invis}) /makemevisible
        } else /if (${Timer.Equal[CursorIDTimer]}) {
            /if (${Cursor.ID}) /call CheckCursor Event_Timer 1
            /varset CursorID 0
        }
		POPCALL
        DEBUGN Event_Timer leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Campfire Section -  Code from toomanynames, wizbomb
| ----------------------------------------------------------------------------
    Sub Event_TooSteep
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /varset CampfireOn 0
        /echo Setting CampfireOn to 0. You are on a hill.
    /return

|-----------------------------------------------------------------------------
| SUB: Capture Tells
| ----------------------------------------------------------------------------
    Sub Event_YouGotTell(Message, Fwho, Swhat)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /varset EventFlag 1
        /if (${GMailEvents.Find[tells]}) {
            | The Fwho.Equal[${Me.CleanName}'s pet] does NOT work, so I split it to 2 Finds and this works.
            /if ((${Pet.ID} && ${Spawn[=${Fwho}].ID}==${Pet.ID}) || (${Fwho.Find[${Me.CleanName}]} && ${Fwho.Find[s pet]})) {
				POPCALL
				/return
			}
            /if (!${Pet.ID} && ${Swhat.Find[, master.]} && ${Swhat.Find[I am unable to wake an]}) {
				POPCALL
				/return
			}
            /if (${Select[${Spawn[=${Fwho}].Type},NPC,PET]}) {
				POPCALL
				/return
			}
            /echo ====> ${Fwho} Sent you a Tell: ${Swhat} <====
            /call GmailSend "You Got Tell From ${Fwho}, ${Swhat}"
        } else {
            /doevents flush YouGotTell
        }
		POPCALL
    /return

| ----------------------------------------------------------------------------
| SUB: Event Zoned
|
| ZoneText is used to make decisions elsewhere. It is not the same as Zone.Name
|
| We can tell if we started to zone by looking at ..., and when we enter
| by the ZoneText. When we startup, ZoneText will be empty.
| ----------------------------------------------------------------------------
    Sub Event_Zoned(Message, string ZoneText)
        /if (${Message.Find[Drunken Monkey]} || ${Message.Find[effects]}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /varset EventFlag 1
        /call PauseWhileZoning Event_Zoned
        /if (!${JustZoned}) /echo Just zoned
		/call LastMove
        /call CombatReset 0 zoned
        /varset JustZoned 200
        /varset CampOnDeathTimer 10m
        /if (${LastZone}!=${Zone.ID}) {
            /if (${Zone.Name.Find[,]} || ${Zone.Name.Find[']}) {
                /varset ZoneName ${Zone.ShortName}${If[${Me.InInstance},_I,]}
            } else {
                /varset ZoneName ${Zone}${If[${Me.InInstance},_I,]}
            }
        }
        /varset LastZone ${Zone.ID}
        | Shut down combat and mez in GH, GL, PoK, PoT, and Abysmal
        /if (${Select[${Zone.ID},345,344,202,203,279]}) {
            /varset DMZ 1
        } else {
            /varset DMZ 0
        }
        /if (${CampZone}!=${Zone.ID}) {
            /if (${ReturnToCamp}) {
                /varset ReturnToCamp 0
                /varset RememberCamp 1
            }
        } else {
            /if (${RememberCamp} && ${Math.Distance[${CampYLoc},${CampXLoc}]}<=150) {
                /varset ReturnToCamp 1
                /varset RememberCamp 0
            } else {
				/camphere off
			}
            | Can't have chars running back to camp. They may have been dragged.
            /if (${IAmDead}) {
                /varset IAmDead 0
                /camphere off
            }
        }
        /call WinTitle
		POPCALL
    /return

|-------------------------------------------------------------------------------------
| SUB: Exchange Item.
|-------------------------------------------------------------------------------------
    Sub ExchangeItem(string prm_Item, string prm_exToSlot, int prm_deleteFlag, int prm_autoInvFlag, int prm_autoAttuneFlag)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare int_slotNo1 int local 0
        /declare int_slotNo2 int local 0
        /declare str_slotName1 string local
        /declare str_slotName2 string local
        /declare tim_timer1 timer local 0
        /declare bol_attuneable bool local false
        /declare bol_noTrade bool local false
        /if (!${FindItemCount[=${prm_Item}]}) {
			POPCALL
			/return
		}
        DEBUG ExchangeItem: Enter ${prm_Item} ${prm_exToSlot} ${prm_autoInvFlag}
        /if (${Cursor.ID}) /call CheckCursor ExchangeItem
        /if (${Cursor.ID}) {
            /beep 
            /echo Your Inventory is full. This process needs open inventory slots for this to work.
			POPCALL
            /return
        }
        /if (!${Select[${prm_exToSlot},charm,leftear,head,face,rightear,neck,shoulder,arms,back,leftwrist,rightwrist,ranged,hands,mainhand,offsand,leftfinger,rightfinger,chest,legs,feet,waist,powersource,ammo]}) {
            /echo Invalid Item slot ${prm_exToSlot}, must be valid Equipment/Armor slot.
			POPCALL
            /return
        }
        /if (${Me.Inventory[${prm_exToSlot}].Name.Equal[${prm_Item}]}) {
            /echo You already have item ${prm_Item} equiped.
			POPCALL
            /return
        }
        /varcalc int_slotNo1 ${Int[${FindItem[=${prm_Item}].ItemSlot}]}
        /if (${int_slotNo1}>32) {
            /echo Item ${prm_Item} is not in your characters Inventory.
			POPCALL
            /return
        } else /if (${int_slotNo1}<23) {
            /echo Item is already equiped in slot number ${int_slotNo1}
			POPCALL
            /return
        }
        /if (${Me.Inventroy[${int_slotNo1}].Container}) {
            /varcalc int_slotNo2 ${Int[${FindItem[=${prm_Item}].ItemSlot2}]}+1
        } else {
            /varset int_slotNo2 0
        }
        /varcalc int_slotNo1 ${int_slotNo1}-22
        | Check if there is an item in the target Slot we are exchanging to.
        /if (${Me.Inventory[${prm_exToSlot}].ID}) {
            /varset str_slotName1 ${Me.Inventory[${prm_exToSlot}].Name}
        } else {
            /varset str_slotName1 null
        }
        |Pick up item on cursor
        /if (${int_slotNo2}) {
            /nomodkey /itemnotify in pack${int_slotNo1} ${int_slotNo2} leftmouseup
        } else {
            /nomodkey /itemnotify pack${int_slotNo1} leftmouseup
        }
        | Wait for item to show on cursor.
        /varset tim_timer1 20
        /while (!${Cursor.ID} && ${tim_timer1}) {
            DOPARSE
            /delay 5
        }
        /if (!${Cursor.ID}) {
            /echo Could Not pick up the item ${prm_Item}. Exiting.
			POPCALL
            /return
        } else {
            /varset bol_noTrade ${Cursor.NoDrop}
            /varset bol_attuneable ${Cursor.Attunable}
        }
        |Put Item in Target Slot.
        /nomodkey /itemnotify ${prm_exToSlot} leftmouseup
        /if (${bol_attuneable} && !${bol_noTrade}) /delay 10
        | If item is attuneable then lets attune it.
        /if (${bol_attuneable} && ${Cursor.ID}) {
            /delay 20 ${Window[confirmationdialogbox].Open}
            /if (${Window[confirmationdialogbox].Open}) {
                /if (${prm_autoAttuneFlag}) {
                    /notify confirmationdialogbox CD_Yes_Button leftmouseup
                } else {
                    /notify confirmationdialogbox CD_No_Button leftmouseup
                }
                /delay 20 !${Window[confirmationdialogbox].Open}
            }
        }
        | Wait for cursor to refresh with an item or nothing.
        /varset tim_timer1 20
        /if (${str_slotName1.NotEqual[null]}) {
            /while (${Cursor.Name.NotEqual[${str_slotName1}]} && ${tim_timer1}) {
                DOPARSE
                /delay 5
            }
        } else {
            /delay 10
        }
        |If this was exchanged with another item, then put the item in the originating slot.
        /if (${Cursor.Name.Equal[${str_slotName1}]}) {
            /if (${int_slotNo2}) {
                /nomodkey /itemnotify in pack${int_slotNo1} ${int_slotNo2} leftmouseup
            } else {
                /nomodkey /itemnotify pack${int_slotNo1} leftmouseup
            }
            /delay 10
        }
        | If item stuck on cursor lets drop it in inventory.
        /if (${Cursor.ID}) /autoinventory
		POPCALL
        DEBUG ExchangeItem: Leave
    /return
	
|-----------------------------------------------------------------------------
| SUB: FeignAggroCheck
| ----------------------------------------------------------------------------
    Sub FeignAggroCheck
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
	
		DEBUGCOMBAT Enter
	
        /if (${AggroOffTimer}) {
            /while (${Me.Feigning} || ${Me.Invis}) {
                /doevents Timer
                /delay 5
            }
        } else {
            /doevents Timer
        }
		
		DEBUGCOMBAT Leave
		
    /return
	
| ---------------------------------------------------------------------------
| Sub GetCorpse
| ---------------------------------------------------------------------------
	Sub GetCorpse(id CorpseID, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGCOMBAT Enter from ${FromWhere}
		
		/declare CorpseDistance 	int 	local 	95
		/declare CloseEnough		int		local	90
		/declare MoveTimer 			timer 	local 	300
		/declare NearestMobID 		int 	local 	0
		/declare CampWasOn			int		local 	${ReturnToCamp}
		/declare Spam				timer	local	0
        /declare CorpseX            int     local   0
        /declare CorpseY            int     local   0
        /declare CorpseZ            int     local   0

		/call TargetThis ${CorpseID}
		/if (${Target.ID}!=${CorpseID}) {
			POPCALL
			/return CORPSE_POOFED
		}
		
		/if (!${CampWasOn}) /camphere on
		
		/if (${Target.Distance}>${CorpseDistance}) {
			DEBUGCOMBAT Corpse is ${Target.Distance} away. Moving closer.
			/echo \ayCan't grab ${Target.CleanName} (${Target.ID}). Moving closer.
			/squelch /nav spawn "${Target.Name}" |distance=${CloseEnough}
            | Need to check if we are moving and if not, switch to Moveto.

            |Recording position of corpse to check for consent
            /varset CorpseX ${Int[${Spawn[id ${CorpseID}].X}]}
            /varset CorpseY ${Int[${Spawn[id ${CorpseID}].Y}]}
            /varset CorpseZ ${Int[${Spawn[id ${CorpseID}].FloorZ}]}

			/while (1) {
				/doevents GotHit
				| What's the id of the nearest mob to us
				/call MobRadar los 75 GetCorpse
				/varset NearestMobID ${Macro.Return}
				/if (${NearestMobID} && !${Spam}) {
                    /call PullValidate ${NearestMobID} 0 FROMHERE
                    /if (${Macro.Return.Equal[1]}) {
					    /echo Mob close to me ${Spawn[id ${CorpseID}].CleanName}. Hope you consented me!
					    /varset Spam 5s
                    }
                    /call TargetThis ${CorpseID}
				}
                
				/if (${AggroTargetID} || ${Me.XTarget[${XTSlot}].ID}) {
					DEBUGPULL Aggro while going to get corpse. Trying to get back to camp. Wish me luck.
					/break
				}
				/if (${Target.Distance}<=${CloseEnough}) /break
				/if (!${MoveTimer}) /break
			}
			/if (${Navigation.Active}) /squelch /nav stop
			/if (${Target.Distance}<=${CloseEnough}) {
				/corpsedrag
                /delay 1s
                /if (${Math.Distance[${Spawn[id ${CorpseID}].X},${Spawn[id ${CorpseID}].Y},${Spawn[id ${CorpseID}].FloorZ}:${CorpseX},${CorpseY},${CorpseZ}]}<1) {
                    /call BroadCast r "Need consent to drag ${Target.CleanName} back to camp!"
                }
				/call DoWeMove 1 GetCorpse
                /delay 5
				/corpsedrop
                /delay 5
			}
		} else /if (${Target.Distance}<=${CloseEnough} && ${Target.Distance}>50) {
			/call MobRadar los 75 GetCorpse
			/varset NearestMobID ${Macro.Return}
			/if (${NearestMobID} && !${Spam}) {
                /call PullValidate ${NearestMobID} 0 FROMHERE
                /if (${Macro.Return.Equal[1]}) {
    			    /echo Mob close to me ${Spawn[id ${CorpseID}].CleanName}. Hope you consented me!
				    /varset Spam 5s
                }
                /call TargetThis ${CorpseID}
			}
            
			/corpse
            /delay 1s
            /if (${Math.Distance[${Spawn[id ${CorpseID}].X},${Spawn[id ${CorpseID}].Y},${Spawn[id ${CorpseID}].FloorZ}:${CorpseX},${CorpseY},${CorpseZ}]}<1) {
                /call BroadCast r "Need consent to move ${Target.CleanName} closer to me!"
            }
		}
		/if (!${CampWasOn}) /camphere off

		POPCALL
        DEBUGCOMBAT Leave
	/return

| ----------------------------------------------------------------------------
| SUB: GmailParse
| ----------------------------------------------------------------------------
    Sub GmailIniParse
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN GmailSend Enter
        /declare i int local 0
        /declare GMailEventCheck string local
        /for i 1 to ${GMail.Size}
            /varset GMailEventCheck ${Ini[${IniFileName},Gmail,Gmail${i}]}
            /if (${GMailEventCheck.Length} && ${GMailEventCheck.NotEqual[null]}) {
                /if (${Select[${GMailEventCheck},Dead,Drag,GM,Level,Named,Leftgroup,Tells]}) {
                    DEBUGN /echo ${i}. ${GMailEventCheck}
                    /if (${GMailEvents.Length}) {
                        /varset GMailEvents ${GMailEvents},${GMailEventCheck}
                    } else {
                        /varset GMailEvents ${GMailEventCheck}
                    }
                }
            }
        /next i
        DEBUGN GmailSend Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: GmailSend
| ----------------------------------------------------------------------------
    Sub GmailSend(GMessage)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN GmailSend Enter
        |Goofy time shit because Gmail fails if any entry has a colon : in it.
        /declare GTime string local
        /declare GtimeHour string local ${Time.Hour}
        /declare AMPM string local am
        /if (${Time.Hour}>=13) {
            /varset GtimeHour ${Int[${Math.Calc[${Time.Hour}-12]}]}
            /varset AMPM pm
        }
        /varset GTime Date.${Time.Date} Time.${GtimeHour}.${Time.Minute} ${AMPM}
        | Ghetto fix for buffer overflow until MQ2GMail is fixed
        /if (${Bool[${Plugin[MQ2Gmail]}]}) /squelch /plugin MQ2Gmail unload noauto
        /squelch /plugin MQ2Gmail noauto
        /gmail "Kiss-${EverQuest.Server}-${Me}" "${GTime} - ${GMessage}"
        /echo GMAIL just sent "Kiss-${EverQuest.Server}-${Me}" "${GTime} - ${GMessage}"
        /varcalc GSent ${GSent}+1
        /if (${GSent}==5) {
            /varset GSent 0
        }
        /delay 10
        DEBUGN GmailSend Leave
    /return

| ----------------------------------------------------------------------------
| SUB: Grab Corpse
| ----------------------------------------------------------------------------
    Sub GrabCorpse(int checkFlag, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGN GrabCorpse Enter from ${FromWhere} - ${checkFlag}
        /if (!${checkFlag}) /varset checkFlag 1
        /if (${checkFlag}==1) {
            /if (${SpawnCount[pccorpse ${Me}]}) {
                /if (${CorpseRecoveryOn}==1) {
                    /if (${NearestSpawn[1,pccorpse ${Me}].Distance3D}>89) {
                        /call RecoverCorpses "me" 89
                        /delay 30
                    }
                }
                /if (${SpawnCount[pccorpse ${Me} radius 89]}) {
                    /corpsedrag
                    /varset DragCorpse 1
                }
            }
        } else /if (${checkFlag}==2) {
            /if (${Math.Distance[${CampYLoc},${CampXLoc}]}>=${CampRadius}) {
                /call TargetThis ${Me}
                /delay 10
                /corpsedrag
                /varset DragCorpse 1
                /echo Hey I found my corpse. Running back to camp for a rez
                /if (${GMailEvents.Find[drag]}) /call GmailSend "Hey I found my corpse. Running back to camp for a rez!"
            }
        }
		POPCALL
        DEBUGN GrabCorpse Leave
    /return
	
| -------------------------------------------------------------------------------------
| SUB: IsFriendly
|
| Looks at the spawnID given, or the target, and decides whether it may be a threat.
| -------------------------------------------------------------------------------------
    Sub IsFriendly(int SpawnID, string FromWhere)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        DEBUGCOMBAT Enter from ${FromWhere} - Target Name:${Target.CleanName} ID:${Target.ID} Spawn Name: ${Spawn[id ${SpawnID}].CleanName} ID:${SpawnID}

        | Have we seen this id before?
        /if (${SpawnID} && ${IsMaybeHostileIDList.Find[|${SpawnID}|]}) /return MAY-BE-HOSTILE
        /if (${SpawnID} && ${IsFriendlyIDList.Find[|${SpawnID}|]}) /return FRIENDLY
        /if (!${SpawnID} && ${Target.ID} && ${IsFriendlyIDList.Find[|${Target.ID}|]}) /return FRIENDLY
        /if (${SpawnID} && !${Spawn[id ${SpawnID}].ID} || ${Spawn[id ${SpawnID}].Type.Equal[Corpse]}) /return DEAD-SPAWN

        /declare 	j 					int 	local	0
        /declare 	MobID 				int 	local 	0
		/declare 	MobMasterID 		int 	local 	0
		/declare	MobTarget			string	local

		DEBUGCOMBAT Validate Friendlies
		
        /if (${SpawnID}) {
			DEBUGCOMBAT SpawnID ${SpawnID} provided
			/varset MobTarget ${Spawn[id ${SpawnID}].DoTarget}
			/delay 5
			/varset MobID ${Spawn[id ${SpawnID}].ID}
			/varset MobMasterID ${Spawn[id ${SpawnID}].Master.ID}
			DEBUGCOMBAT MobID ${MobID} MobMasterID ${MobMasterID} (in case a pet)
        } else {
			DEBUGCOMBAT SpawnID not provided. Using Target
           /varset MobID ${Target.ID}
		   /varset MobMasterID ${Target.Master.ID}
        }

		DEBUGCOMBAT MobID ${MobID} MobMasterID ${MobMasterID}
		
		/if (!${MobID}) /return NO-SPAWN
		/if (${Spawn[id ${MobID}].Type.Equal[CORPSE]}) /return DEAD-SPAWN

		DEBUGCOMBAT Spawn is present and not a corpse.

		|
		| Are we looking at anything that is me?
		|
   		/if (${MobMasterID}==${Me.ID} || ${MobID}==${Me.ID} || ${MobID}==${Me.Mercenary.ID} || ${MobID}==${Pet.ID} || ${MobID}==${Me.Mount.ID}) {
            /call AddFriendly ${MobID}
            /call AddFriendly ${MobMasterID}
            /return FRIENDLY
        }
		
		DEBUGCOMBAT It's not me apparently
		
		/if (${Spawn[id ${MobID} group].ID}>0) {
            /call AddFriendly ${MobID}
            /call AddFriendly ${MobMasterID}
            /return FRIENDLY
        }
		
		DEBUGCOMBAT Not in the group apparently
		
		/if (${MobMasterID}) {
			/for j 1 to ${Group.Members}
                /if (${MobMasterID}==${Group.Member[${j}].ID} || ${MobMasterID}==${Group.Member[${j}].Master.ID} || ${MobMasterID}==${Group.Member[${j}].Pet.ID}) {
                    /call AddFriendly ${MobID}
                    /call AddFriendly ${MobMasterID}
                    /return FRIENDLY
                }
			/next j
		}

		DEBUGCOMBAT Not a groupmember, pet, or whatever... returning MAY-BE-HOSTILE

        /call AddMaybeHostile ${MobID}
        /call AddMaybeHostile ${MobMasterID}

        DEBUGCOMBAT Leave
    /return MAY-BE-HOSTILE

| -------------------------------------------------------------------------------------
| Task Code
| -------------------------------------------------------------------------------------
| SUB: Dismount
| -------------------------------------------------------------------------------------
    Sub Event_KTDismount
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        /varset EventFlag 1
        /if (${MountOn}) /varset MountOn 0
        /if (${Me.Mount.ID}) /dismount
    /return
	
|-----------------------------------------------------------------------------
| SUB: TaskDoorTarget
| ----------------------------------------------------------------------------
    Sub Event_KTDoorClick(Line, int KTDoorID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        |/varset EventFlag 1
        /declare KTCDTimer timer local 10s
        /if (!${Defined[KTDoorID]}) {
            /doortarget
            /delay 3
            /declare KTDoorID ${DoorTarget.ID}
        }
        /echo DoorID: ${KTDoorID}
        /delay 10
        /keypress FIRST_PERSON_CAMERA hold
        /delay 2
        /keypress FIRST_PERSON_CAMERA
        /delay 10
        /if (${Target.ID}) /call TargetThis
        /delay 3
        /while (${KTCDTimer}) {
            /echo target door id ${KTDoorID}
            /if (${KTDoorID}) {
                /doortarget id ${KTDoorID}
            } else {
                /doortarget
            }
            /delay 3
            /echo ${DoorTarget.Name}
            /if (${Switch.ID}) /break
        }
        /face door
        /delay 3
        /if (!${KTCDTimer}) /varset KTCDTimer 50
        /while (${KTCDTimer} && ${DoorTarget.ID}) {
            /if (${DoorTarget.Distance}<=70)  {
                /echo Moving to Door
                /if (${DoorTarget.Distance}>15) {
                    /keypress forward hold
                    /delay 3
                    /keypress forward
                } else /if (${DoorTarget.Distance}<10) {
                    /keypress back hold
                    /delay 1
                    /keypress back
                }
            } else {
               /echo ${DoorTarget.Name} is too far away(${DoorTarget.Distance}). Get closer.
               /break
            }
            /if (!${Switch.Open}) {
                /face door
                /delay 3
                /echo clicking door
                /click left door
                /delay 1s
            } else {
                /break
            }
        }
        /if (${Window[largedialogwindow].Open}) {
            /notify largedialogwindow LDW_YesButton leftmouseup
        }
        /doevents flush KTDoorClick
		POPCALL
    /return
	
|-----------------------------------------------------------------------------
| SUB: KTHail
| ----------------------------------------------------------------------------
    Sub Event_KTHail(Line, KTMobID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        |/varset EventFlag 1
        /tar id ${Spawn[npc ${KTMobID}].ID}
        /delay ${Math.Rand[20]}
        /keypress h
        /doevents flush KTaskSay
    /return

|-----------------------------------------------------------------------------
| SUB: KTInvite
| ----------------------------------------------------------------------------
    Sub Event_KTInvite
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /varset EventFlag 1
        /declare i int
        /declare WhoToInvite ${SpawnCount[pc radius 75 guild]}
        /alert clear 6
        /squelch /alert add 6 ${Me}
        /for i 1 to ${WhoToInvite}
			/call TargetThis ${NearestSpawn[radius 75 pc guild noalert 6].ID}
            /delay 10
            /invite
            /delay 20
            /if (${EQBCOn} && ${Macro.IsTLO[EQBC]}) {
            /bct ${Target.CleanName} //invite
            } else /if (${DanNetOn} && ${Macro.IsTLO[DanNet]}) {
                /dex ${Target.CleanName} /invite
            }
            /delay 10
            /squelch /alert add 6 id ${Target.ID}
        /next i
		POPCALL
    /return

|-----------------------------------------------------------------------------
| SUB: KTSay
| ----------------------------------------------------------------------------
    Sub Event_KTSay(Line, KTSayWhat, KTMobID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

        |/varset EventFlag 1
        /tar id ${KTMobID}
        /delay ${Math.Rand[20]}
        /say ${KTSayWhat}
        /delay 10
        /doevents flush KTaskSay
    /return
	
|-----------------------------------------------------------------------------
| SUB: Target NPC
| ----------------------------------------------------------------------------
    Sub Event_KTTarget(Line, NPCName)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
	
        /varset EventFlag 1
        /echo Targeting ${NPCName}
        /if (${NPCName.Equal[null]}) {
            /echo NPC Name is Null. Check your variables.
			POPCALL
            /return FALSE
        }
        /if (!${Spawn[npc ${NPCName}].ID}) {
            /echo ${NPCName}? You must be in the wrong place, no one here by that name
			POPCALL
            /return FALSE
        }
		/call TargetThis ${Spawn[${NPCName}].ID}
        /if (${Target.Distance}>15 && ${Target.Distance}<50) {
            /moveto id  ${Spawn[${NPCName}].ID}
            /delay 250 ${MoveTo.Stopped}
        }
        /varcalc ZDist ${Math.Distance[${Target.Z}:${Me.Z}]}-(${Target.Height}-${Me.Height})
        /call ZAxisCheck ${ZDist} 4.1
        /face ${If[${FaceMobOn}==2,nolook,fast nolook]}
        /delay 10
		POPCALL
    /return TRUE


| ---------------------------------------------------------------------------
| SUB: LastMove
| 
| Time since character last moved accessible in TimeSinceMove in tenths of a sec
| ---------------------------------------------------------------------------
	Sub LastMove(string FromWhere)
		| Debug call stack removed.

		/if (${Math.Abs[${Math.Calc[${Me.X}-${LastMoveX}]}]}>1 || ${Math.Abs[${Math.Calc[${Me.Y}-${LastMoveY}]}]}>1 || ${Math.Abs[${Math.Calc[${Me.Z}-${LastMoveZ}]}]}>1 || ${Math.Abs[${Math.Calc[${Me.Heading.Degrees}-${LastMoveHeading}]}]}>1 || ${Me.Combat} || ${Me.CombatState.Equal[COMBAT]} || ${Me.Sitting}!=${LastSitStand}) {
			/vardata LastMoveTime   EverQuest.Running
			/vardata LastMoveX 		Me.X
			/vardata LastMoveY 		Me.Y
			/vardata LastMoveZ 		Me.Z
			/vardata LastMoveHeading Me.Heading.Degrees
			/varset LastSitStand	${Me.Sitting}
			/varset TimeSinceMove   0
		} else {
			/varcalc TimeSinceMove (${EverQuest.Running}-${LastMoveTime})/1000
		}
		| Give 60 seconds when first starting
		|/if (${Math.Calc[(${EverQuest.Running}-${BootTime})/1000]}<60) /varset TimeSinceMove 60
	/return


| -----------------------------------------------------------------------------
| Sub:LocAggroRisk
| -----------------------------------------------------------------------------
	Sub LocAggroRisk(int KDX, int KDY, int KDZ, string FromWhere)

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL	
	
		DEBUGPULL Enter from ${FromWhere}

		| This helps us evaluate risk and whether we keep pulling or approach the loc
		| Waterfall down until we dont find mobs. Caveat: If mobs path thats a wildcard
		| Highest (6) to lowest (0) risk of aggro

		/declare KRadius		int		local
		/declare KRadarResults	string	local

		/varset KRadius 25
		/call RadarAtLoc ${KDX} ${KDY} ${KDZ} ${KRadius} FROMHERE
		/varset KRadarResults ${Macro.Return}
		/if (${KRadarResults.Arg[1,|]}) {	
			| You will almost 99.5% likely agro... if it didnt see invis or ivu and not named...thats a crazy train feature.
			DEBUGPULL Leave: Radius ${KRadius}
			POPCALL
			/return 6|${KRadius}|${KRadarResults}
		}
		
		/varset KRadius 50
		/call RadarAtLoc ${KDX} ${KDY} ${KDZ} ${KRadius} FROMHERE
		/varset KRadarResults ${Macro.Return}
		/if (${KRadarResults.Arg[1,|]}) {
			| High risk, mobs very close
			DEBUGPULL Leave
			POPCALL
			/return 5|${KRadius}|${KRadarResults}
		}
		
		/varset KRadius 100
		/call RadarAtLoc ${KDX} ${KDY} ${KDZ} ${KRadius} FROMHERE
		/varset KRadarResults ${Macro.Return}
		/if (${KRadarResults.Arg[1,|]}) {
			| Moderate risk, mobs nearby
			DEBUGPULL Leave
			POPCALL
			/return 4|${KRadius}|${KRadarResults}
		}
		
		/varset KRadius 150
		/call RadarAtLoc ${KDX} ${KDY} ${KDZ} ${KRadius} FROMHERE
		/varset KRadarResults ${Macro.Return}
		/if (${KRadarResults.Arg[1,|]}) {	
			| Likely safe unless mobs roaming
			DEBUGPULL Leave
			POPCALL
			/return 3|${KRadius}|${KRadarResults}
		}

		/varset KRadius 300
		/call RadarAtLoc ${KDX} ${KDY} ${KDZ} ${KRadius} FROMHERE
		/varset KRadarResults ${Macro.Return}
		/if (${KRadarResults.Arg[1,|]}) {
			| Very Low risk
			DEBUGPULL Leave
			POPCALL
			/return 2|${KRadius}|${KRadarResults}
		}
		
		/varset KRadius 500
		/call RadarAtLoc ${KDX} ${KDY} ${KDZ} ${KRadius} FROMHERE
		/varset KRadarResults ${Macro.Return}
		/if (${KRadarResults.Arg[1,|]}) {	
			| Cleared
			POPCALL
			/return 1|${KRadius}|${KRadarResults}
		}

		| Nothing within our KMaxRadius. Safe as safe can be.

		DEBUGPULL Leave
		POPCALL
		
	/return 0|${KRadius}|${KRadarResults}

| -------------------------------------------------------------------------------------
| SUB: Loot Stuff
| -------------------------------------------------------------------------------------
    Sub LootStuff
        /if (!${LootOn} || (!${Me.UseAdvancedLooting} && ${AggroTargetID}) || (${IAmMA} && ${AggroTargetID}) || (${DMZ} && ${Me.InInstance}==FALSE) || ${Me.Invis}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL	

        DEBUGN LootStuff: Enter
        /if (${Me.FreeInventory}==0) {
            /echo \awAKA:\ayInventory is full. Looting OFF
            /varset LootOn 0
            /if (${Defined[NALStatus]}) {
                /varset NALStatus 0
            }
            /return
        }
        /doevents
        /if (${Me.UseAdvancedLooting}) {
            /if (${Bool[${Plugin[MQ2AutoLoot]}]}) {
                /if (${AutoLoot.Active}) /return
            }
            /call UseAdvLoot
        } else {
            /call LootMobs
        }
        /call DoWeMove 0 lootstuff
        DEBUGN LootStuff: Leave
        POPCALL
    /return

| -------------------------------------------------------------------------------------
| SUB: Mercs Do What
| -------------------------------------------------------------------------------------
    Sub MercsDoWhat
        /if (!${MercOn}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL

        DEBUGN MercsDoWhat Enter

        /if (${Mercenary.State.Equal[Active]}) /varset MercInGroup 1
        | Revive the merc if dead and previously detected in group
        /if (${MercInGroup} && ${Window[MMGW_ManageWnd].Child[MMGW_SuspendButton].Enabled} && ${Mercenary.State.Equal[DEAD]}) {
            /notify MMGW_ManageWnd MMGW_SuspendButton LeftMouseUp
            /delay 5s
            /if (${Group.Member[1].Owner.Name.Equal[${Me}]}) /varset MyMerc ${Group.Member[1].Name}
        }

        | If the target is fleeing, let the merc finish it off. Otherwise stay within bounds and los.
        /if (${MercInGroup}) {
            /if (${Select[${Me.Mercenary.Class.ShortName},WAR,ROG]} && ${Me.Mercenary.Stance.NotEqual[Passive]} && (!${Target.Fleeing} && (!${Me.Mercenary.LineOfSight} || ${Me.Mercenary.Distance}>${MercAttackDistance}))) {
                /stance passive
                /varset MercAssisting 0
            }
            /if (${Select[${Me.Mercenary.Class.ShortName},WAR]} && ${Me.Mercenary.Stance.NotEqual[Aggressive]} && (${Target.Fleeing} || (${Me.Mercenary.LineOfSight} && ${Me.Mercenary.Distance}<=${MercAttackDistance}))) {
                /stance aggressive
            }
            /if (${Select[${Me.Mercenary.Class.ShortName},ROG]} && ${Me.Mercenary.Stance.NotEqual[Burn]} && (${Target.Fleeing} || (${Me.Mercenary.LineOfSight} && ${Me.Mercenary.Distance}<=${MercAttackDistance}))) {
                /stance burn
            }
        }
        /if (${MercAssistAt}>=${Spawn[id ${MyTargetID}].PctHPs} && ${Mercenary.State.Equal[Active]} && !${MercAssisting} && (${CombatStart} || (${Select[${Role},Puller]} && ${Pulled})) && ${Target.Distance}<=${MercAttackDistance}) {
            /mercassist
            DEBUGCOMBAT MercsDoWhat ${Spawn[id ${MyTargetID}].CleanName} %:${Spawn[id ${MyTargetID}].PctHPs} ID:${Spawn[id ${MyTargetID}].ID}
            /varset MercAssisting 1
        }

		POPCALL
        DEBUGN MercsDoWhat Leave
    /return

| -------------------------------------------------------------------------------------
|   Sub MezRadar
| -------------------------------------------------------------------------------------
    Sub MezRadar(string FromWhere)
        /if ((${DMZ} && ${Me.InInstance}==FALSE)) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGMEZ MezRadar Enter from ${FromWhere}
        /declare NMMob int local 0
        /declare i int local
        /varset MezMobAECount 0
        /varset MezAEClosest 0
        /varset MezMobCount ${SpawnCount[xtarhater]}
        /varset MezMobAECount ${SpawnCount[xtarhater radius ${MezRadius}]}
        /if (${Me.XTarget[${XTSlot}].TargetType.NotEqual[Auto Hater]} && ${Me.XTarget[${XTSlot}].ID}) {
            /varcalc MezMobCount ${MezMobCount}+1
            /varcalc MezMobAECount ${MezMobAECount}+1
        }
		
		/if (${DebugMez}) {
			DEBUGMEZ Mez Array Before
			/for i 1 to 13
                /varset NMMob ${NearestSpawn[${i},xtarhater radius ${MezRadius}].ID}
                DEBUGMEZ MezRadar:  Mob ${i} ID ${NMMob} Name ${Spawn[id ${NMMob}].Name} Type ${Spawn[id ${NMMob}].Type} 
			/next i
		}
		
        /if (${MezMobAECount}) {
            /for i 1 to ${MezMobAECount}
                /varset NMMob ${NearestSpawn[${i},xtarhater radius ${MezRadius}].ID}
                DEBUGMEZ MezRadar:  Mob ${i} ID ${NMMob} Name ${Spawn[id ${NMMob}].Name} Type ${Spawn[id ${NMMob}].Type} 
                /if (${NMMob} && ${Select[${NMMob},${MezArray[1,1]},${MezArray[2,1]},${MezArray[3,1]},${MezArray[4,1]},${MezArray[5,1]},${MezArray[6,1]},${MezArray[7,1]},${MezArray[8,1]},${MezArray[9,1]},${MezArray[10,1]},${MezArray[11,1]},${MezArray[12,1]},${MezArray[13,1]}]}==0) {
                    DEBUGMEZ MezRadar: ADDING -> Name: ${Spawn[id ${NMMob}].Name} ID: ${NMMob} to mezlist
                    /call AddToArray MezArray 13 ${NMMob}
                }
            /next i
        }
        /varset MezAEClosest ${NearestSpawn[1,xtarhater radius ${MezRadius}].ID}

		/if (${DebugMez}) {
			DEBUGMEZ Mez Array After
			/for i 1 to 13
                /varset NMMob ${NearestSpawn[${i},xtarhater radius ${MezRadius}].ID}
                DEBUGMEZ MezRadar:  Mob ${i} ID ${NMMob} Name ${Spawn[id ${NMMob}].Name} Type ${Spawn[id ${NMMob}].Type} 
			/next i
		}
		POPCALL
        DEBUGMEZ MezRadar: MezMobCount: ${MezMobCount} Leave
    /return

| -------------------------------------------------------------------------------------
|   Sub MobRadar
| -------------------------------------------------------------------------------------
    Sub MobRadar(string RadarCheck,int CountRadius,string FromWhere)
        /if ((${DMZ} && ${Me.InInstance}==FALSE)) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        DEBUGPULL MobRadar Enter from ${FromWhere} - ${CountRadius} ${RadarCheck}
        /declare NMob              int      local
        /declare i                 int      local
        /declare i_CorpseCount     int      local 0
        /if (${RadarCheck.Equal[los]}) {
            /varset MobCount ${SpawnCount[npc targetable los radius ${CountRadius} zradius 50 noalert 3]}
            /if (${MobCount}>0) {
                /for i 1 to ${MobCount}
                    /varset NMob ${NearestSpawn[${i},npc targetable los radius ${CountRadius} zradius 50 noalert 3].ID}
                    /if (${i}>13) /break
                    /if (${NMob} && (${Spawn[id ${NMob}].Type.Equal[Corpse]} || !${Spawn[id ${NMob}].ID})) {
                        /call RemoveFromArray AddsArray ${Select[${NMob},${AddsArray[1,1]},${AddsArray[2,1]},${AddsArray[3,1]},${AddsArray[4,1]},${AddsArray[5,1]},${AddsArray[6,1]},${AddsArray[7,1]},${AddsArray[8,1]},${AddsArray[9,1]},${AddsArray[10,1]},${AddsArray[11,1]},${AddsArray[12,1]},${AddsArray[13,1]}]}
                        /varcalc i_CorpseCount ${i_CorpseCount}+1
                    } else /if (${Select[${NMob},${AddsArray[1,1]},${AddsArray[2,1]},${AddsArray[3,1]},${AddsArray[4,1]},${AddsArray[5,1]},${AddsArray[6,1]},${AddsArray[7,1]},${AddsArray[8,1]},${AddsArray[9,1]},${AddsArray[10,1]},${AddsArray[11,1]},${AddsArray[12,1]},${AddsArray[13,1]}]}==0) {
                        /call AddToArray AddsArray 50 ${NMob}
                    }
                /next i
                /varcalc MobCount ${MobCount}-${i_CorpseCount}
            }
        } else /if (${RadarCheck.Equal[xtar]}) {
            /if (${CountRadius}>0) {
                /varset i_CorpseCount ${SpawnCount[xtarhater npccorpse radius ${CountRadius} zradius 50]}
                /varcalc MobCount ${SpawnCount[xtarhater radius ${CountRadius} zradius 50]}-${i_CorpseCount}
            } else {
                /varset i_CorpseCount ${SpawnCount[xtarhater npccorpse]}
                /varcalc MobCount ${SpawnCount[xtarhater]}-${i_CorpseCount}
            }
        } else /if (${RadarCheck.Equal[pull]}) {
            /varset i_CorpseCount ${SpawnCount[npccorpse los loc ${CampXLoc} ${CampYLoc} radius ${MeleeDistance} zradius 50 noalert 3]}
            /varcalc MobCount ${SpawnCount[npc targetable los loc ${CampXLoc} ${CampYLoc} radius ${MeleeDistance} zradius 50 noalert 3]}-${i_CorpseCount}
        }
        DEBUGPULL MobRadar ${FromWhere} ${RadarCheck} ${MobCount} ${i_CorpseCount} ${XTSlot} ${Me.XTarget[${XTSlot}].ID} ${Me.XTarget[${XTSlot}].Type}
        | Check if NPC Pet is on Xtarget
        /if (!${MobCount} && ${Me.XTarget[${XTSlot}].ID} && ${Me.XTarget[${XTSlot}].Type.NotEqual[corpse]}) {
            DEBUGCOMBAT MobRadar MobCount=0 but Mob on Xtarget Setting Mobcount to 1
            /varset MobCount 1
        } else /if (${Me.XTarget[${XTSlot}].ID} && ${Me.XTarget[${XTSlot}].TargetType.NotEqual[Auto Hater]}) {
            /varcalc MobCount ${MobCount}+1
        }
		POPCALL
        DEBUGPULL MobRadar Leave ${MobCount}
		| Return the ID of the nearest mob we can see. It might be in the way.
    /return ${NearestSpawn[1,npc targetable los radius ${CountRadius} zradius 50].ID}
	
| ---------------------------------------------------------------------------
| Sub OnXTarget
|
| If given an id, tell whether it's on xtarget. If no id is given, it returns
| whether anything is on xtarget.
| ---------------------------------------------------------------------------
	Sub OnXTarget(int MobID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX

	/return (${Select[${MobID},${Me.XTarget[1].ID},${Me.XTarget[2].ID},${Me.XTarget[3].ID},${Me.XTarget[4].ID},${Me.XTarget[5].ID},${Me.XTarget[6].ID},${Me.XTarget[7].ID},${Me.XTarget[8].ID},${Me.XTarget[9].ID},${Me.XTarget[10].ID},${Me.XTarget[11].ID},${Me.XTarget[12].ID},${Me.XTarget[13].ID}]}==0)

| ----------------------------------------------------------------------------
| SUB: Pause While Hovering
| ----------------------------------------------------------------------------
    Sub PauseWhileHovering(string SentFrom)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN PauseWhileHovering SentFrom: ${SentFrom} Enter
        /declare idx int local 0
        /doevents flush
        /while (${Me.Hovering}) {
            /if (${Role.Find[Puller]} && ${ClickBacktoCamp} && ${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc}:${Me.Y},${Me.X}]}>150) {
                /if (${Me.ItemReady[=Fellowship Registration Insignia]}) {
                    /if (${Window[respawnWnd].Open}) {
                        /varset idx ${Window[respawnWnd].Child[RW_OptionsList].List[=Bind Location,2]}
                        /if (${idx}) {
                            /nomodkey /notify respawnWnd RW_OptionsList listselect ${idx}
                            /delay 10
                            /nomodkey /notify respawnwnd RW_SelectButton leftmouseup
                        }
                    }
                } else {
                    /delay 10
                }
            } else {
                /delay 10
            }
        }
        DEBUGN PauseWhileHovering Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Pause While Zoning
| ----------------------------------------------------------------------------
    Sub PauseWhileZoning(string SentFrom)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN \atPauseWhileZoning SentFrom: ${SentFrom} \awEnter
        /while (!${Me.ID} || !${Zone.ID}) {
            /delay 10
        }
        DEBUGN \atPauseWhileZoning \awEnter
    /return


| -------------------------------------------------------------------------------------
|   Sub RadarAtLoc
| -------------------------------------------------------------------------------------
    Sub RadarAtLoc(int KDX, int KDY, int KDZ, KDRadius, string FromWhere)

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGPULL Enter from ${FromWhere}
				
		| Get all the mobs and let ValidateTarget sort it out
		/declare KNumMobs			int		local	${SpawnCount[loc ${KDX} ${KDY} ${KDZ} npc targetable radius ${KDRadius} zradius 50]}
		/declare KNearestMobID		int		local 	${NearestSpawn[1,loc ${KDX} ${KDY} ${KDZ} npc targetable radius ${KDRadius} zradius 50].ID}

		/declare KMobID				int		local	0
		/declare KNumValidMobs		int		local	0
		/declare i					int		local	0
		/declare KResults			string	local
		/declare KNearestValidMobID	string	local	0
		/declare ValidateReturn		string	local
		
        /if (${KNumMobs}>0) {
            /for i 1 to ${KNumMobs}
                /varset KMobID ${NearestSpawn[${i},loc ${KDX} ${KDY} ${KDZ} npc targetable radius ${KDRadius} zradius 50].ID}
                /if (${KMobID}) {
					/call ValidateTarget ${KMobID} FROMHERE
					/varset ValidateReturn ${Macro.Return}
					/if (${ValidateReturn.Equal[1]}) {
						/if (!${KNearestValidMobID}) /varset KNearestValidMobID ${KMobID}
						/varcalc KNumValidMobs ${KNumValidMobs}+1
					}
				}
            /next i
		}
	
		/varset KResults ${KNumValidMobs}|${KNearestValidMobID}|${KNumMobs}|${KNearestMobID}

        DEBUGPULL Leave: Valid mobs ${KNumValidMobs} Nearest valid mob ${KNearestValidMobID}
		
		POPCALL
    /return ${KResults}



| ----------------------------------------------------------------------------
| SUB: Recover Corpse
| ----------------------------------------------------------------------------
    Sub RecoverCorpses(string rc_Flag1,int rc_Distance)
        /if (${AggroTargetID} || ${Me.Invis}) /return false
        /if (!${Select[${Me.Class.ShortName},shd,nec,rog]}) /return false

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare int_summonID    int    local 0
        /declare int_summonLevel int    local 0
        /declare int_coffinCount int    local 0
        /declare int_corpseCount int    local 0
        /declare int_idx1        int    local 0
        /declare int_idx2        int    local 0
        /declare str_useWhat     string local
        /declare str_Status      string local false
        /declare tim_wait1       timer  local 0
        
        /if (!${rc_Distance}) /varset rc_Distance 150
        DEBUGN SummonCorpse Enter ${rc_Flag1} ${rc_Distance}
        /if (${ReturnToCamp} && ${Math.Distance[${CampYLoc},${CampXLoc}]}>10) /call DoWeMove 1 summoncorpse
        /if (!${SpawnCount[pccorpse ${Me}]} && !${SpawnCount[pccorpse group]}) {
			POPCALL
			/return false
		}
        /if (${Select[${Me.Class.ShortName},shd,nec]}) {
            /if (${FindItemCount[Tiny Jade Inlaid Coffin]}<2) {
                /varset CorpseRecoveryOn 2
                POPCALL
                /return false
            }
            /while (1) {
                /varset int_coffinCount ${FindItemCount[Tiny Jade Inlaid Coffin]}
                /varset int_summonID 0
                /varset str_useWhat null
                /if (${SpawnCount[pccorpse ${Me}]}) {
                    /if (${NearestSpawn[1,${Me} pccorpse].Distance3D}>${rc_Distance}) {
                        /varset int_summonID ${Me.ID}
                        /varset int_summonLevel ${Me.Level}
                    }
                }
                /if (!${int_summonID}) {
                    /if (${rc_Flag1.Equal[me]}) /break
                    /for int_idx1 1 to 5
                        /if (${Group.Member[${int_idx1}].OtherZone} || ${Group.Member[${int_idx1}].Type.Equal[corpse]} || ${Group.Member[${int_idx1}].Distance3D}>100) /continue
                        /varset int_corpseCount ${SpawnCount[${Group.Member[${int_idx1}].CleanName} pccorpse]}
                        /if (${int_corpseCount}) {
                            /for int_idx2 1 to ${int_corpseCount}
                                /if (${NearestSpawn[${int_idx2},${Group.Member[${int_idx1}].CleanName} pccorpse].Distance3D}>${rc_Distance}) {
                                    /varset int_summonID ${Group.Member[${int_idx1}].ID}
                                    /varset int_summonLevel ${Group.Member[${int_idx1}].Level}
                                    /break
                                }
                            /next int_idx2
                        }
                        /if (${int_summonID}) /break
                    /next int_idx1
                }
                
                /if (!${int_summonID}) /break
 
                /if (${Me.AltAbilityReady[Summon Remains]} && ${int_coffinCount}>3) {
                    /varset str_useWhat Summon Remains
                } else /if (${int_coffinCount}>1) {
                    /if (${Me.Spell[Duskreaper's Proclamation].ID}) {
                        | Up to level 115 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Duskreaper's Proclamation]}
                    } else /if (${Me.Spell[Shadereaper's Proclamation].ID} && ${int_summonLevel}<111) {
                        | Up to level 110 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Shadereaper's Proclamation]}
                    } else /if (${Me.Spell[Stormreaper's Proclamation].ID} && ${int_summonLevel}<106) {
                        | Up to level 105 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Stormreaper's Proclamation]}
                    } else /if (${Me.Spell[Reaper's Proclamation].ID} && ${int_summonLevel}<101) {
                        | Up to level 100 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Reaper's  Proclamation]}
                    } else /if (${Me.Spell[Reaper's Decree].ID} && ${int_summonLevel}<96) {
                        | Up to level 95 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Reaper's Decree]}
                    } else /if (${Me.Spell[Reaper's Beckon].ID} && ${int_summonLevel}<91) {
                        | Up to level 90 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Reaper's Beckon]}
                    } else /if (${Me.Spell[Reaper's Call].ID} && ${int_summonLevel}<86) {
                        | Up to level 85 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Reaper's Call]}
                    } else /if (${Me.Spell[Procure Corpse].ID} && ${int_summonLevel}<81) {
                        | Up to level 80 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Procure Corpse]}
                    } else /if (${Me.Spell[Exhumer's Corpse].ID} && ${int_summonLevel}<76) {
                        | Up to level 75 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Exhumer's Corpse]}
                    } else /if (${Me.Spell[Conjure Corpse].ID} && ${int_summonLevel}<71) {
                        | Up to level 70 TJIC x 2
                        /varset str_useWhat ${Me.Spell[Conjure Corpse]}
                    }
                }
                /if (${str_useWhat.Equal[null]}) /break
                
                /while (${Me.SpellInCooldown}) {
                   /delay 5
                }
                
                /if (${Me.Gem[${str_useWhat}]}) {
                    /varset tim_wait1 350
                    /while (!${Me.SpellReady[${str_useWhat}]} && ${tim_wait1}) {
                        /if (${ChaseAssist}) {
                            /call DoWeChase 0 summoncorpse
                        } else {
                            DOPARSE
                            /delay 5
                        }
                    }
                    /if (!${Me.SpellReady[${str_useWhat}]}) /break
                }
                
                /if (${Me.Invis}) /break
                /if (!${Target.ID} || ${Target.ID}!=${int_summonID}) {
					/call TargetThis ${int_summonID}
				}
                /call CastWhat "${str_useWhat}" ${int_summonID} summoncorpse-nomem 0 0 FROMHERE
                /if (${Macro.Return.Equal[cast_success]}) {
                    /call BroadCast r "Summoned Corpse for: ${Spawn[ID ${int_summonID}].CleanName} Using: ${str_useWhat}"
                    /varset str_Status true
                    /delay 20
                } else {
                    /break
                }
                /if (${rc_Flag1.Equal[me]}) /break 
            | End of While Loop.
            }
        } else /if (${Me.Class.ShortName.Equal[rog]}) {
            /echo Rogues are not Supported at this time. Thank you for shopping at RedGuides.
            /delay 50
            /varset CorpseRecoveryOn 2
        }
		POPCALL
        DEBUGN SummonCorpse Leave ${int_summonID} ${int_coffinCount} ${str_useWhat} ${int_summonLevel}
    /return ${str_Status}

| -------------------------------------------------------------------------------------
| SUB: Remove From Array
| -------------------------------------------------------------------------------------
    Sub RemoveFromArray(RArrayName, int ArNum)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        /if (${${RArrayName}[${ArNum},1].Equal[NULL]}) /return
        /if (${ArNum}<1 || ${ArNum}>${${RArrayName}.Size}) /return
		
		|
		| Cols 1=id, 2=level, 3=cleanname, 4=mezimmune, 5=tashed, 6=maloed, 7=slowed
		|
        DEBUGN RemoveFromArray ${ArNum} Enter
        DEBUGN ARRAY Remove >> ${${RArrayName}[${ArNum},3]} << from ${RArrayName}${ArNum}.
        /varset ${RArrayName}[${ArNum},1] NULL
        /varset ${RArrayName}[${ArNum},2] NULL
        /varset ${RArrayName}[${ArNum},3] NULL
        /varset ${RArrayName}[${ArNum},4] NULL
        /varset ${RArrayName}[${ArNum},5] NULL
        /varset ${RArrayName}[${ArNum},6] NULL
        /varset ${RArrayName}[${ArNum},7] NULL
		
        /if (${MezOn} && ${ArNum}<=13) {
			/varset MezCount[${ArNum}] 0
			/varset MezTimer${ArNum} 0
		}
        DEBUGN RemoveFromArray Leave
    /return
	
| ----------------------------------------------------------------------------
| SUB: Roguestuff
| ----------------------------------------------------------------------------
    Sub Roguestuff
        /if (${Me.Hovering}) /return

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN Roguestuff Enter
        /if (${Me.Class.Name.Equal[Rogue]} && !${Me.Combat} && ${AutoHide}) {
            /if (${Me.AbilityReady[hide]} && ${Me.AbilityReady[sneak]}) {
                /doability hide
                /doability sneak
            }
        }
        DEBUGN Roguestuff Leave
    /return

| -------------------------------------------------------------------------------------
| SUB: SetArrayRow
| -------------------------------------------------------------------------------------
    Sub SetArrayRow(ArrayName, ArrayRow, int AddMobID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGN SetArrayRow ${ArrayName} ${ArrayRow} ${AddMobID} Enter
        /if (!${AddMobID}) {
			/varset ${ArrayName}[${ArrayRow},1] NULL
			/return
		}
		|
		| Cols 1=id, 2=level, 3=cleanname, 4=mezimmune, 5=tashed, 6=maloed, 7=slowed
		|
        /varset ${ArrayName}[${ArrayRow},1] ${Spawn[id ${AddMobID}].ID}
        /varset ${ArrayName}[${ArrayRow},2] ${Spawn[id ${AddMobID}].Level}
        /varset ${ArrayName}[${ArrayRow},3] ${Spawn[id ${AddMobID}].CleanName}
		/varset ${ArrayName}[${ArrayRow},4] NULL
		/varset ${ArrayName}[${ArrayRow},5] NULL
		/varset ${ArrayName}[${ArrayRow},6] NULL
		/varset ${ArrayName}[${ArrayRow},7] NULL
        DEBUGN SetArrayRow Leave
    /return

| ---------------------------------------------------------------------------
| SUB: SetTheTarget
|
| Validates the target and sets MyTargetID and MyTargetName. Accepts id or name.
| ---------------------------------------------------------------------------
	Sub SetTheTarget(string IntendedTarget)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGTARGET Enter - IntendedTarget ${IntendedTarget} for MyTarget
		
		/declare IntendedTargetID		int		local 	${Int[${IntendedTarget}]}
		/declare IntendedTargetName 	string 	local 	${IntendedTarget}
		/declare IntendedTargetResultID	int		local	0		
		/declare IntendedTargetResult	string	local
		
		/if (${IntendedTargetName.NotEqual[NULL]} && ${IntendedTargetName.Length}) {
			|
			| Is it real?
			|
			/if (${IntendedTargetID}) {
				/if (${Spawn[id ${IntendedTargetID}].ID}) {
					/varset IntendedTargetResultID ${Spawn[id ${IntendedTargetID}].ID}
				}
			} else /if (${IntendedTargetName.Length}) {
				/varset IntendedTargetResultID ${Spawn[=${IntendedTargetName}].ID}
			}
			
			|
			| If something was specified, but we didn't find it, leave the current target information alone.
			|
			/if (!${IntendedTargetResultID}) {
				DEBUGTARGET Leave - Couldnt find IntendedTarget ${IntendedTarget}
				/return
			}
		
			/varset MyTargetID ${IntendedTargetResultID}
			/varset MyTargetName ${Spawn[id ${IntendedTargetResultID}].CleanName}
		} else {
			|
			| If nothing was specified, clear the target information.
			|
			/varset MyTargetID 0
			/varset MyTargetName
		}
		DEBUGTARGET Leave - IntendedTarget ${IntendedTarget} MyTargetID ${MyTargetID} MyTargetName ${MyTargetName}
	/return

| -------------------------------------------------------------------------------------
| SUB: SummonStuff
| -------------------------------------------------------------------------------------
    Sub SummonStuff(SSpell,SumItem,int SumNum,int CondNumber)
        /if (${Me.Invis}) /return
        /if (${FindItemCount[=${SumItem}]}>=${SumNum}) /return 0

		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
        /declare SumResult string local FALSE
        /declare SummonAttempts int local 0
        /declare CurrentCount int local 0
        /declare OriginalCount int local ${FindItemCount[=${SumItem}]}
        DEBUGBUFFS SummonStuff Enter Spell: ${SSpell} SumItem: ${SumItem} SumNum: ${SumNum}
        /if (${CondNumber} && ${If[${Cond[${CondNumber}]},0,1]}) {
			POPCALL
			/return 0
		}
        /while (${FindItemCount[=${SumItem}]}<${SumNum}) {
            /if (${Me.FreeInventory}==0) {
                /echo No room in inventory skipping summoning >> ${SumItem} <<.
                /break
            }
            /varset CurrentCount ${FindItemCount[=${SumItem}]}
            | Summon axes for zerkers had to be hard coded because spell is same name as the item summoned.
            /if (${Select[${Me.Class.ShortName},BER]} && ${SSpell.Find[axe]}) {
                /doevents flush Missing
                /if (!${Me.CombatAbility[${SSpell}]}) {
                    /varset SumResult CAST_COMPONENTS
					POPCALL
                    /return ${SumResult}
                }
                /if (${Cursor.ID}) /call CheckCursor SummonStuff 1
                /docommand /disc ${SSpell}
                /varset MissingComponent 0
                /call CastWait "${SSpell}" SummonStuff
                /doevents Missing
                /if (!${MissingComponent} && !${Cursor.ID}) {
                    /delay 20 ${Cursor.ID}
                }
                /if (${Cursor.ID}) {
                    /varcalc SummonAttempts ${SummonAttempts}+1
                    /varset SumResult CAST_SUCCESS
                } else {
                    /if (!${MissingComponent}) {
                        /doevents Missing
                    } else {
                        /varset SumResult CAST_COMPONENTS
                    }
                }
            } else {
                | Check if summoning from an item
                /if (${FindItemCount[=${SSpell}]} > 0) {
                    | Check if item is ready to cast
                    /if (${FindItem[=${SSpell}].Timer}!=0) {
                        DEBUGBUFFS ${SSpell} not ready yet skipping
                        /varset SumResult CAST_NOT_READY
						POPCALL
                        /return ${SumResult}
                    }
                }
                /if (${Cursor.ID}) /call CheckCursor SummonStuff 1
                /call CastWhat "${SSpell}" ${Me.ID} SummonStuff-nomem 0 0 FROMHERE
                /varset SumResult ${Macro.Return}
            }
            DEBUGBUFFS CheckBuffs summon item cast result ${Macro.Return} ${SumResult}
            /if (${SumResult.Equal[CAST_SUCCESS]}) {
                /delay 5s ${Cursor.ID}
                /if (${Cursor.ID}) {
                    /echo Summoned  >> ${SumItem} <<
                    /varcalc SummonAttempts ${SummonAttempts}+1
                    /call CheckCursor SummonStuff 1
                } else /if (${FindItemCount[=${SumItem}]}==${CurrentCount} && ${SummonAttempts}>0) {
                    /echo Summoning >> ${SumItem} << Failed - Check reagents, timer, etc
                    /echo -- Turning off ${SSpell} - ${SSpell}|Summon|${SumItem}|0
                    /varset SummonAttempts 0
                    /varset SumResult CAST_COMPONENTS
                    /break
                }
            } else /if (${SumResult.Equal[CAST_COMPONENTS]}) {
                /echo You are missing components. Turning Off ${SSpell}.
                /break
            } else /if (${SumResult.Equal[CAST_NO_RESULT]}) {
                /break
            }
            /if (${SummonAttempts}>5) /break
        }
        /if (${Cursor.ID}) /call CheckCursor SummonStuff 0
        /if (${FindItemCount[=${SumItem}]}>${OriginalCount}) /echo I now have ${FindItemCount[=${SumItem}]} of >> ${SumItem} <<
		POPCALL
        DEBUGBUFFS SummonStuff Leave ${Me.FreeInventory} ${SumResult} ${SummonAttempts}
    /return ${SumResult}
	
| -------------------------------------------------------------------------------------
| Sub TargetThis
|
| Generic Target function. Accepts only id.
| -------------------------------------------------------------------------------------
	Sub TargetThis(int IntendedTargetID)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
		DEBUGTARGET Enter - IntendedTargetID ${IntendedTargetID}
		|
		| Clear the target if nothing was provided.
		|		
		/if (!${IntendedTargetID}) {
			/squelch /target clear
			/varset MyTargetID 0
			/varset MyTargetName
			DEBUGTARGET Leave - Clearing Target
			/return
		}
		
		/if (${Target.ID}==${IntendedTargetID}) {
			DEBUGTARGET Leave - Same Target
			/return
		}
		
		|
		| I believe that changing the target before buffs populated is a red flag.
		|
		/squelch /target id ${IntendedTargetID}
		/delay 20 ${Target.ID}==${IntendedTargetID} && ${Target.BuffsPopulated}
		DEBUGTARGET Leave - IntendedTargetID ${IntendedTargetID} Target ID ${Target.ID}
	/return
	
| -------------------------------------------------------------------------------------
| Sub TargetSet
|
| Generic Target function.  Accepts a name or id.
| -------------------------------------------------------------------------------------
	Sub TargetSet(string IntendedTarget)
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		PUSHCALL
		
		DEBUGTARGET Enter - IntendedTarget ${IntendedTarget} for MyTarget
		|
		| Clear the target if nothing was provided.
		|		
		/if (${IntendedTarget.Equal[NULL]} || !${IntendedTarget.Length}) {
			/squelch /target clear
			/varset MyTargetID 0
			/varset MyTargetName
			DEBUGTARGET Leave - Clearing Target and MyTarget
			POPCALL
			/return
		}
		
		/call SetTheTarget "${IntendedTarget}"
		/call TargetThis ${MyTargetID}
		POPCALL
		DEBUGTARGET Leave - IntendedTarget ${IntendedTarget} Target ID ${Target.ID} MyTargetID ${MyTargetID} MyTargetName ${MyTargetName}
	/return

| ----------------------------------------------------------------------------
| SUB: Set Window Title Buffs
| ----------------------------------------------------------------------------
    Sub WinTitle
		| Debug call stack
		CALLINGSUB
		CALLINGINDEX
		
        DEBUGN WinTitle Enter
        /SetWinTitle ${Me.Name} (Lvl:${Me.Level} ${Zone.ShortName})
        DEBUGN WinTitle Leave
    /return
